<?php
/**
 * Custom header implementation
 *
 * @link https://codex.wordpress.org/Custom_Headers
 *
 * @package Pharmacy Shop
 * @subpackage pharmacy_shop
 */

function pharmacy_shop_custom_header_setup() {
    register_default_headers( array(
        'default-image' => array(
            'url'           => get_template_directory_uri() . '/assets/images/header_img.png',
            'thumbnail_url' => get_template_directory_uri() . '/assets/images/header_img.png',
            'description'   => __( 'Default Header Image', 'pharmacy-shop' ),
        ),
    ) );
}
add_action( 'after_setup_theme', 'pharmacy_shop_custom_header_setup' );

/**
 * Styles the header image based on Customizer settings.
 */
function pharmacy_shop_header_style() {
    $pharmacy_shop_header_image = get_header_image() ? get_header_image() : get_template_directory_uri() . '/assets/images/header_img.png';

    $pharmacy_shop_height     = get_theme_mod( 'pharmacy_shop_header_image_height', 350 );
    $pharmacy_shop_position   = get_theme_mod( 'pharmacy_shop_header_background_position', 'center' );
    $pharmacy_shop_attachment = get_theme_mod( 'pharmacy_shop_header_background_attachment', 1 ) ? 'fixed' : 'scroll';

    $pharmacy_shop_custom_css = "
        .header-img, .single-page-img, .external-div .box-image-page img, .external-div {
            background-image: url('" . esc_url( $pharmacy_shop_header_image ) . "');
            background-size: cover;
            height: " . esc_attr( $pharmacy_shop_height ) . "px;
            background-position: " . esc_attr( $pharmacy_shop_position ) . ";
            background-attachment: " . esc_attr( $pharmacy_shop_attachment ) . ";
        }

        @media (max-width: 1000px) {
             .header-img, .single-page-img, .external-div .box-image-page img,.external-div,.featured-image{
                height: 250px !important;
            }
            .box-text h2{
                font-size: 27px;
            }
        }
    ";

    wp_add_inline_style( 'pharmacy-shop-style', $pharmacy_shop_custom_css );
}
add_action( 'wp_enqueue_scripts', 'pharmacy_shop_header_style' );

/**
 * Enqueue the main theme stylesheet.
 */
function pharmacy_shop_enqueue_styles() {
    wp_enqueue_style( 'pharmacy-shop-style', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'pharmacy_shop_enqueue_styles' );