<?php
/**
 * Creates Header Post Type
 * ................................................................
 */

// Initialize
//................................................................
StaticHeaderContent::onload();

// Easy access to static block output
//................................................................
function the_header_static_block( $id = false, $args = array() ) {
	if ($id) {
		$args["id"] = $id;
		echo StaticHeaderContent::get_static_content($args);
	}
}

#-----------------------------------------------------------------
# Static Block Class
#-----------------------------------------------------------------
class StaticHeaderContent {
	static function onload() {
		add_action('init', array(__CLASS__,'init_static_blocks'));
		//add_action("after_switch_theme", "flush_rewrite_rules", 10 ,  2); // update permalinks for new rewrite rules
		//add_shortcode('static_content', array(__CLASS__,'static_content_shortcode'));
		add_shortcode('maxhost_hdr_builder', array(__CLASS__,'static_content_shortcode'));
	}
	static function init_static_blocks() {
		if (function_exists('register_post_type')) {
			register_post_type('maxhost_hdr_builder',
				array(
					'labels' => array(
							'name' =>				esc_html_x('Header Builder', 'post type general name', 'maxhost'),
							'singular_name' =>		esc_html_x('Header Builder', 'post type singular name', 'maxhost'),
							'add_new' =>			esc_html_x('Add New', 'block', 'maxhost'),
							'add_new_item' =>		esc_html__('Add New Header', 'maxhost'),
							'edit_item' =>			esc_html__('Edit Header', 'maxhost'),
							'new_item' =>			esc_html__('New Header', 'maxhost'),
							'all_items' =>			esc_html__('Headers', 'maxhost'),
							'view_item' =>			esc_html__('View Header', 'maxhost'),
							'search_items' =>		esc_html__('Search', 'maxhost'),
							'not_found' =>			esc_html__('No Headers found', 'maxhost'),
							'not_found_in_trash' =>	esc_html__('No Headers found in Trash', 'maxhost'), 
							'parent_item_colon' => '',
							'menu_name' => 'Header Builder'
						),
					'exclude_from_search' => true,
					'publicly_queryable'  => true,
					'public'              => true,
					'show_ui'             => true,
					'show_in_menu'		  => false,
					'show_in_admin_bar'	  => true,
					'query_var'           => 'maxhost_hdr_builder',
					'rewrite'             => array('slug' => 'maxhost_hdr_builder'),
					'supports'            => array(
						'title',
						'editor',
						'revisions',
					),
				)
			);
		}
	}
}