<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Title_09 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_title_09';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Title Style 09', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-t-letter';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'heading1',
            [
                'label'     => esc_html__( 'Title (Bold Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading2',
            [
                'label'     => esc_html__( 'Title (Bold Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'font_color',
            [
                'label'     => esc_html__('Black or White?', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '' => esc_html__('Choose Color', 'maxhost'),
                    'black' => esc_html__('Black', 'maxhost'),
					'white' => esc_html__('White', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text',
            [
                'label'     => esc_html__( 'Bottom Paragraph Part', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['heading1'] =  $settings['heading1'];
		$args['heading2'] =  $settings['heading2'];
		$args['font_color'] =  $settings['font_color'];
		$args['text'] =  $settings['text'];

       
        if( function_exists( 'maxhost_ztitle_nine_shortcode' ) ) {
            echo maxhost_ztitle_nine_shortcode( $args );
        }

    }

}