<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Pricing_Table_02 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_pricing_table_02';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Pricing Table 02', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-price-table';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'plane_name',
            [
                'label'     => esc_html__( 'Pracing Plan Name', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price',
            [
                'label'     => esc_html__( 'Price', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price with Currency (e.g. $99)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'duration',
            [
                'label'     => esc_html__( 'Duration', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Duration (e.g. month)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features',
            [
                'label'     => esc_html__( 'Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each feature on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'button_text',
            [
                'label'     => esc_html__( 'Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_url',
            [
                'label'     => esc_html__( 'Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'active',
            [
                'label'     => esc_html__( 'Want to make this table highlighted?', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['plane_name'] =  $settings['plane_name'];
		$args['price'] =  $settings['price'];
		$args['duration'] =  $settings['duration'];
		$args['features'] =  $settings['features'];
		$args['button_text'] =  $settings['button_text'];
		$args['button_url'] =  $settings['button_url'];
		$args['active'] =  $settings['active'];
       
        if( function_exists( 'maxhost_pricing_two_shortcode' ) ) {
            echo maxhost_pricing_two_shortcode( $args );
        }

    }

}