<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Mega_Menu_01 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_mega_menu_01';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Mega Menu - List Items', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-nav-menu';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'general_section',
            [
                'label'     => esc_html__( 'General', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu_title',
            [
                'label'     => esc_html__( 'Menu Title', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'font_color',
            [
                'label'     => esc_html__('Menu Title Color', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '' => esc_html__('Choose Menu Title Color', 'maxhost'),
                    'font-black' => esc_html__('Black', 'maxhost'),
                    'font-white' => esc_html__('White', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'number_of_menus',
            [
                'label'     => esc_html__('Number of Menus', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '1' => esc_html__('One', 'maxhost'),
                    '2' => esc_html__('Two', 'maxhost'),
                    '3' => esc_html__('Three', 'maxhost'),
                    '4' => esc_html__('Four', 'maxhost'),
					'5' => esc_html__('Five', 'maxhost'),
                    '6' => esc_html__('Six', 'maxhost'),
                    '7' => esc_html__('Seven', 'maxhost'),
                    '8' => esc_html__('Eight', 'maxhost'),
					'9' => esc_html__('Nine', 'maxhost'),
                    '10' => esc_html__('Ten', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();

        $this->start_controls_section(
            'menu01_section',
            [
                'label'     => esc_html__( 'Menu 01', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu1',
            [
                'label'     => esc_html__( 'Menu-01 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu1_url',
            [
                'label'     => esc_html__( 'Menu-01 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon1',
            [
                'label'     => esc_html__( 'Menu-01 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__("Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ", "maxhost").'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__("refer here", "maxhost").'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'menu02_section',
            [
                'label'     => esc_html__( 'Menu 02', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu2',
            [
                'label'     => esc_html__( 'Menu-02 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu2_url',
            [
                'label'     => esc_html__( 'Menu-02 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon2',
            [
                'label'     => esc_html__( 'Menu-02 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ', 'maxhost').'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'menu03_section',
            [
                'label'     => esc_html__( 'Menu 03', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu3',
            [
                'label'     => esc_html__( 'Menu-03 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu3_url',
            [
                'label'     => esc_html__( 'Menu-03 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon3',
            [
                'label'     => esc_html__( 'Menu-03 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ', 'maxhost').'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'menu04_section',
            [
                'label'     => esc_html__( 'Menu 04', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu4',
            [
                'label'     => esc_html__( 'Menu-04 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu4_url',
            [
                'label'     => esc_html__( 'Menu-04 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon4',
            [
                'label'     => esc_html__( 'Menu-04 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ', 'maxhost').'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'menu05_section',
            [
                'label'     => esc_html__( 'Menu 05', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu5',
            [
                'label'     => esc_html__( 'Menu-05 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu5_url',
            [
                'label'     => esc_html__( 'Menu-05 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon5',
            [
                'label'     => esc_html__( 'Menu-05 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ', 'maxhost').'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'menu06_section',
            [
                'label'     => esc_html__( 'Menu 06', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu6',
            [
                'label'     => esc_html__( 'Menu-06 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu6_url',
            [
                'label'     => esc_html__( 'Menu-06 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon6',
            [
                'label'     => esc_html__( 'Menu-06 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ', 'maxhost').'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'menu07_section',
            [
                'label'     => esc_html__( 'Menu 07', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu7',
            [
                'label'     => esc_html__( 'Menu-07 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu7_url',
            [
                'label'     => esc_html__( 'Menu-07 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon7',
            [
                'label'     => esc_html__( 'Menu-07 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ', 'maxhost').'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'menu08_section',
            [
                'label'     => esc_html__( 'Menu 08', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu8',
            [
                'label'     => esc_html__( 'Menu-08 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu8_url',
            [
                'label'     => esc_html__( 'Menu-08 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon8',
            [
                'label'     => esc_html__( 'Menu-08 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ', 'maxhost').'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'menu09_section',
            [
                'label'     => esc_html__( 'Menu 09', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu9',
            [
                'label'     => esc_html__( 'Menu-09 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu9_url',
            [
                'label'     => esc_html__( 'Menu-09 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon9',
            [
                'label'     => esc_html__( 'Menu-09 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ', 'maxhost').'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'menu10_section',
            [
                'label'     => esc_html__( 'Menu 10', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'menu10',
            [
                'label'     => esc_html__( 'Menu-10 Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'menu10_url',
            [
                'label'     => esc_html__( 'Menu-10 URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon10',
            [
                'label'     => esc_html__( 'Menu-10 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Input FontAwesome Icon name here (e.g. telegram). Leave it blank if you do not want icon for this menu. Icon list - ', 'maxhost').'<a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['menu_title'] =  $settings['menu_title'];
		$args['number_of_menus'] =  $settings['number_of_menus'];
		$args['font_color'] =  $settings['font_color'];
		$args['menu1'] =  $settings['menu1'];
		$args['menu1_url'] =  $settings['menu1_url'];
		$args['icon1'] =  $settings['icon1'];
		$args['menu2'] =  $settings['menu2'];
		$args['menu2_url'] =  $settings['menu2_url'];
		$args['icon2'] =  $settings['icon2'];
		$args['menu3'] =  $settings['menu3'];
		$args['menu3_url'] =  $settings['menu3_url'];
		$args['icon3'] =  $settings['icon3'];
		$args['menu4'] =  $settings['menu4'];
		$args['menu4_url'] =  $settings['menu4_url'];
		$args['icon4'] =  $settings['icon4'];
		$args['menu5'] =  $settings['menu5'];
		$args['menu5_url'] =  $settings['menu5_url'];
		$args['icon5'] =  $settings['icon5'];
		$args['menu6'] =  $settings['menu6'];
		$args['menu6_url'] =  $settings['menu6_url'];
		$args['icon6'] =  $settings['icon6'];
		$args['menu7'] =  $settings['menu7'];
		$args['menu7_url'] =  $settings['menu7_url'];
		$args['icon7'] =  $settings['icon7'];
		$args['menu8'] =  $settings['menu8'];
		$args['menu8_url'] =  $settings['menu8_url'];
		$args['icon8'] =  $settings['icon8'];
		$args['menu9'] =  $settings['menu9'];
		$args['menu9_url'] =  $settings['menu9_url'];
		$args['icon9'] =  $settings['icon9'];
		$args['menu10'] =  $settings['menu10'];
		$args['menu10_url'] =  $settings['menu10_url'];
		$args['icon10'] =  $settings['icon10'];
		
        if( function_exists( 'maxhost_megamenu_shortcode_one' ) ) {
            echo maxhost_megamenu_shortcode_one( $args );
        }

    }

}