<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Features_Block_06 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_features_block_06';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Features Block 06', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-table-of-contents';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'maxhost_shortcodes_parallax_bg',
            [
                'label'     => esc_html__("Section Background Image URL", 'maxhost'),
                'type' => \Elementor\Controls_Manager::TEXT,
                "description" => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id',
			[
				'label' => esc_html__( 'Left Side Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
            'heading1',
            [
                'label'     => esc_html__( 'Heading Line-1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading2_1st',
            [
                'label'     => esc_html__( 'Heading Line-2 (1st Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading2_2nd',
            [
                'label'     => esc_html__( 'Heading Line-2 (2nd Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading2_3rd',
            [
                'label'     => esc_html__( 'Heading Line-2 (3rd Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading3',
            [
                'label'     => esc_html__( 'Heading Line-3', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text',
            [
                'label'     => esc_html__( 'Text Below Headings', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'button_label',
            [
                'label'     => esc_html__( 'Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_url',
            [
                'label'     => esc_html__( 'Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'crossed_top',
            [
                'label'     => esc_html__( 'Crossed Shaped Section Top', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->add_control(
            'crossed_bottom',
            [
                'label'     => esc_html__( 'Crossed Shaped Section Bottom', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['maxhost_shortcodes_parallax_bg'] =  $settings['maxhost_shortcodes_parallax_bg'];
		$args['img_one_elementor_id'] =  $settings['img_one_elementor_id'];
		$args['heading1'] =  $settings['heading1'];
		$args['heading3'] =  $settings['heading3'];
		$args['heading2_1st'] =  $settings['heading2_1st'];
		$args['heading2_2nd'] =  $settings['heading2_2nd'];	
		$args['heading2_3rd'] =  $settings['heading2_3rd'];	
		$args['text'] =  $settings['text'];
		$args['crossed_top'] =  $settings['crossed_top'];
		$args['crossed_bottom'] =  $settings['crossed_bottom'];
		$args['button_label'] =  $settings['button_label'];
		$args['button_url'] =  $settings['button_url'];
       
        if( function_exists( 'maxhost_features_block_six_shortcode' ) ) {
            echo maxhost_features_block_six_shortcode( $args );
        }

    }

}