<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Domains_Register extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_domains_register';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Domains Register Block', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-product-meta';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'heading1',
            [
                'label'     => esc_html__( 'Section Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain1',
            [
                'label'     => esc_html__( 'Domain - 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain2',
            [
                'label'     => esc_html__( 'Domain - 2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain3',
            [
                'label'     => esc_html__( 'Domain - 3', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain4',
            [
                'label'     => esc_html__( 'Domain - 4', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain5',
            [
                'label'     => esc_html__( 'Domain - 5', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'register_url',
            [
                'label'     => esc_html__( 'Register URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example Register Domain URL: YOUR_WHMCS_PAGE_URL/cart.php?a=add&domain=register','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['heading1'] =  $settings['heading1'];
		$args['domain1'] =  $settings['domain1'];
		$args['domain2'] =  $settings['domain2'];
		$args['domain3'] =  $settings['domain3'];
		$args['domain4'] =  $settings['domain4'];
		$args['domain5'] =  $settings['domain5'];
		$args['register_url'] =  $settings['register_url'];
       
        if( function_exists( 'maxhost_domains_register_shortcode' ) ) {
            echo maxhost_domains_register_shortcode( $args );
        }

    }

}