<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Blog_Posts_02 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_blog_posts_02';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Blog Posts 02', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-post-list';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'maxhost_shortcodes_parallax_bg',
            [
                'label'     => esc_html__( 'Section Background Image URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading1',
            [
                'label'     => esc_html__( 'Heading Line-1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading2',
            [
                'label'     => esc_html__( 'Heading Line-2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'num_post',
            [
                'label'     => esc_html__( 'Number of Posts', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Number of Posts to Show (e.g. 2)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'crossed_top',
            [
                'label'     => esc_html__("Crossed Shaped Section Top", 'maxhost'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->add_control(
            'crossed_bottom',
            [
                'label'     => esc_html__("Crossed Shaped Section Bottom", 'maxhost'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['maxhost_shortcodes_parallax_bg'] =  $settings['maxhost_shortcodes_parallax_bg'];
		$args['heading1'] =  $settings['heading1'];
		$args['heading2'] =  $settings['heading2'];
		$args['num_post'] =  $settings['num_post'];
		$args['crossed_top'] =  $settings['crossed_top'];
		$args['crossed_bottom'] =  $settings['crossed_bottom'];
       
        if( function_exists( 'maxhost_blog_post_two_shortcode' ) ) {
            echo maxhost_blog_post_two_shortcode( $args );
        }

    }

}