<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Accor_01 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_accor_01';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Accordion Section - 01', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-text';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'number_of_tabs',
            [
                'label'     => esc_html__('Number of Items to Show', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '1' => esc_html__('1', 'maxhost'),
                    '2' => esc_html__('2', 'maxhost'),
                    '3' => esc_html__('3', 'maxhost'),
                    '4' => esc_html__('4', 'maxhost'),
                    '5' => esc_html__('5', 'maxhost'),
                    '6' => esc_html__('6', 'maxhost'),
					'7' => esc_html__('7', 'maxhost'),
                    '8' => esc_html__('8', 'maxhost'),
                    '9' => esc_html__('9', 'maxhost'),
                    '10' => esc_html__('10', 'maxhost'),
					'11' => esc_html__('11', 'maxhost'),
                    '12' => esc_html__('12', 'maxhost'),
                    '13' => esc_html__('13', 'maxhost'),
                    '14' => esc_html__('14', 'maxhost'),
                    '15' => esc_html__('15', 'maxhost'),
                    '16' => esc_html__('16', 'maxhost'),
					'17' => esc_html__('17', 'maxhost'),
                    '18' => esc_html__('18', 'maxhost'),
                    '19' => esc_html__('19', 'maxhost'),
                    '20' => esc_html__('20', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title1',
            [
                'label'     => esc_html__( 'Item title - 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text1',
            [
                'label'     => esc_html__( 'Item text - 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title2',
            [
                'label'     => esc_html__( 'Item title - 2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text2',
            [
                'label'     => esc_html__( 'Item text - 2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title3',
            [
                'label'     => esc_html__( 'Item title - 3', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text3',
            [
                'label'     => esc_html__( 'Item text - 3', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title4',
            [
                'label'     => esc_html__( 'Item title - 4', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text4',
            [
                'label'     => esc_html__( 'Item text - 4', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title5',
            [
                'label'     => esc_html__( 'Item title - 5', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text5',
            [
                'label'     => esc_html__( 'Item text - 5', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title6',
            [
                'label'     => esc_html__( 'Item title - 6', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text6',
            [
                'label'     => esc_html__( 'Item text - 6', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title7',
            [
                'label'     => esc_html__( 'Item title - 7', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text7',
            [
                'label'     => esc_html__( 'Item text - 7', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title8',
            [
                'label'     => esc_html__( 'Item title - 8', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text8',
            [
                'label'     => esc_html__( 'Item text - 8', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title9',
            [
                'label'     => esc_html__( 'Item title - 9', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text9',
            [
                'label'     => esc_html__( 'Item text - 9', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title10',
            [
                'label'     => esc_html__( 'Item title - 10', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text10',
            [
                'label'     => esc_html__( 'Item text - 10', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title11',
            [
                'label'     => esc_html__( 'Item title - 11', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text11',
            [
                'label'     => esc_html__( 'Item text - 11', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title12',
            [
                'label'     => esc_html__( 'Item title - 12', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text12',
            [
                'label'     => esc_html__( 'Item text - 12', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title13',
            [
                'label'     => esc_html__( 'Item title - 13', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text13',
            [
                'label'     => esc_html__( 'Item text - 13', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title14',
            [
                'label'     => esc_html__( 'Item title - 14', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text14',
            [
                'label'     => esc_html__( 'Item text - 14', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title15',
            [
                'label'     => esc_html__( 'Item title - 15', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text15',
            [
                'label'     => esc_html__( 'Item text - 15', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title16',
            [
                'label'     => esc_html__( 'Item title - 16', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text16',
            [
                'label'     => esc_html__( 'Item text - 16', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title17',
            [
                'label'     => esc_html__( 'Item title - 17', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text17',
            [
                'label'     => esc_html__( 'Item text - 17', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title18',
            [
                'label'     => esc_html__( 'Item title - 18', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text18',
            [
                'label'     => esc_html__( 'Item text - 18', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title19',
            [
                'label'     => esc_html__( 'Item title - 19', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text19',
            [
                'label'     => esc_html__( 'Item text - 19', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'title20',
            [
                'label'     => esc_html__( 'Item title - 20', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text20',
            [
                'label'     => esc_html__( 'Item text - 20', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['number_of_tabs'] =  $settings['number_of_tabs'];
		$args['title1'] =  $settings['title1'];
		$args['title2'] =  $settings['title2'];
		$args['title3'] =  $settings['title3'];
		$args['title4'] =  $settings['title4'];
		$args['title5'] =  $settings['title5'];
		$args['title6'] =  $settings['title6'];
		$args['title7'] =  $settings['title7'];
		$args['title8'] =  $settings['title8'];
		$args['title9'] =  $settings['title9'];
		$args['title10'] =  $settings['title10'];
		$args['title11'] =  $settings['title11'];
		$args['title12'] =  $settings['title12'];
		$args['title13'] =  $settings['title13'];
		$args['title14'] =  $settings['title14'];
		$args['title15'] =  $settings['title15'];
		$args['title16'] =  $settings['title16'];
		$args['title17'] =  $settings['title17'];
		$args['title18'] =  $settings['title18'];
		$args['title19'] =  $settings['title19'];
		$args['title20'] =  $settings['title20'];
		
		$args['text1'] =  $settings['text1'];
		$args['text2'] =  $settings['text2'];
		$args['text3'] =  $settings['text3'];
		$args['text4'] =  $settings['text4'];
		$args['text5'] =  $settings['text5'];
		$args['text6'] =  $settings['text6'];
		$args['text7'] =  $settings['text7'];
		$args['text8'] =  $settings['text8'];
		$args['text9'] =  $settings['text9'];
		$args['text10'] =  $settings['text10'];
		$args['text11'] =  $settings['text11'];
		$args['text12'] =  $settings['text12'];
		$args['text13'] =  $settings['text13'];
		$args['text14'] =  $settings['text14'];
		$args['text15'] =  $settings['text15'];
		$args['text16'] =  $settings['text16'];
		$args['text17'] =  $settings['text17'];
		$args['text18'] =  $settings['text18'];
		$args['text19'] =  $settings['text19'];
		$args['text20'] =  $settings['text20'];
       
        if( function_exists( 'maxhost_accordion_one_shortcode' ) ) {
            echo maxhost_accordion_one_shortcode( $args );
        }

    }

}