<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Team extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_team';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Team Member', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-nerd';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'name',
            [
                'label'     => esc_html__( 'Member Name', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'designation',
            [
                'label'     => esc_html__( 'Member Designation', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id',
			[
				'label' => esc_html__( 'Upload Member Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
            'text',
            [
                'label'     => esc_html__( 'Desctiption', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'fb_url',
            [
                'label'     => esc_html__( 'Facebook URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'tw_url',
            [
                'label'     => esc_html__( 'Twitter URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'gp_url',
            [
                'label'     => esc_html__( 'Google Plus URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'ln_url',
            [
                'label'     => esc_html__( 'Linkedin URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'active',
            [
                'label'     => esc_html__( 'Make this Member Highlighted?', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
				'label_block' => true,
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['name'] =  $settings['name'];
		$args['designation'] =  $settings['designation'];
		$args['img_one_elementor_id'] =  $settings['img_one_elementor_id'];
		$args['text'] =  $settings['text'];
		$args['fb_url'] =  $settings['fb_url'];
		$args['tw_url'] =  $settings['tw_url'];
		$args['gp_url'] =  $settings['gp_url'];
		$args['ln_url'] =  $settings['ln_url'];
		$args['active'] =  $settings['active'];

       
        if( function_exists( 'maxhost_team_one_shortcode' ) ) {
            echo maxhost_team_one_shortcode( $args );
        }

    }

}