<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Features_Table extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_features_table';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Features Table', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'features1',
            [
                'label'     => esc_html__( '1st Row Features - Table Titles', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('1st row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features2',
            [
                'label'     => esc_html__( '2nd row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('2nd row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features3',
            [
                'label'     => esc_html__( '3rd row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('3rd row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features4',
            [
                'label'     => esc_html__( '4th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('4th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features5',
            [
                'label'     => esc_html__( '5th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('5th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features6',
            [
                'label'     => esc_html__( '6th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('6th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features7',
            [
                'label'     => esc_html__( '7th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('7th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features8',
            [
                'label'     => esc_html__( '8th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('8th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features9',
            [
                'label'     => esc_html__( '9th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('9th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features10',
            [
                'label'     => esc_html__( '10th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('10th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features11',
            [
                'label'     => esc_html__( '11th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('11th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features12',
            [
                'label'     => esc_html__( '12th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('12th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features13',
            [
                'label'     => esc_html__( '13th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('13th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features14',
            [
                'label'     => esc_html__( '14th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('14th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features15',
            [
                'label'     => esc_html__( '15th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('15th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features16',
            [
                'label'     => esc_html__( '16th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('16th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features17',
            [
                'label'     => esc_html__( '17th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('17th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features18',
            [
                'label'     => esc_html__( '18th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('18th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features19',
            [
                'label'     => esc_html__( '19th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('19th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features20',
            [
                'label'     => esc_html__( '20th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('20th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features21',
            [
                'label'     => esc_html__( '21st row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('21st row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features22',
            [
                'label'     => esc_html__( '22nd row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('22nd row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features23',
            [
                'label'     => esc_html__( '23rd row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('23rd row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features24',
            [
                'label'     => esc_html__( '24th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('24th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features25',
            [
                'label'     => esc_html__( '25th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('25th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features26',
            [
                'label'     => esc_html__( '26th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('26th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features27',
            [
                'label'     => esc_html__( '27th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('27th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features28',
            [
                'label'     => esc_html__( '28th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('28th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features29',
            [
                'label'     => esc_html__( '29th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('29th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'features30',
            [
                'label'     => esc_html__( '30th row Features', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('30th row Features of the table. Start each feature on new line','maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['features1'] =  $settings['features1'];
		$args['features2'] =  $settings['features2'];
		$args['features3'] =  $settings['features3'];
		$args['features4'] =  $settings['features4'];
		$args['features5'] =  $settings['features5'];
		$args['features6'] =  $settings['features6'];
		$args['features7'] =  $settings['features7'];
		$args['features8'] =  $settings['features8'];
		$args['features9'] =  $settings['features9'];
		$args['features10'] =  $settings['features10'];
		$args['features11'] =  $settings['features11'];
		$args['features12'] =  $settings['features12'];
		$args['features13'] =  $settings['features13'];
		$args['features14'] =  $settings['features14'];
		$args['features15'] =  $settings['features15'];
		$args['features16'] =  $settings['features16'];
		$args['features17'] =  $settings['features17'];
		$args['features18'] =  $settings['features18'];
		$args['features19'] =  $settings['features19'];
		$args['features20'] =  $settings['features20'];	
		$args['features21'] =  $settings['features21'];
		$args['features22'] =  $settings['features22'];
		$args['features23'] =  $settings['features23'];
		$args['features24'] =  $settings['features24'];
		$args['features25'] =  $settings['features25'];
		$args['features26'] =  $settings['features26'];
		$args['features27'] =  $settings['features27'];
		$args['features28'] =  $settings['features28'];
		$args['features29'] =  $settings['features29'];
		$args['features30'] =  $settings['features30'];
       
        if( function_exists( 'maxhost_features_table_shortcode' ) ) {
            echo maxhost_features_table_shortcode( $args );
        }

    }

}