<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Offers_Carousel extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_offers_carousel';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Offers Carousel', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-slides';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'general_section',
            [
                'label'     => esc_html__( 'General', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'maxhost_shortcodes_parallax_bg',
            [
                'label'     => esc_html__( 'Section Background Image URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading1',
            [
                'label'     => esc_html__( 'Heading Line-1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading2',
            [
                'label'     => esc_html__( 'Heading Line-2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'crossed_top',
            [
                'label'     => esc_html__( 'Crossed Shaped Section Top', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->add_control(
            'crossed_bottom',
            [
                'label'     => esc_html__( 'Crossed Shaped Section Bottom', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->add_control(
            'no_white_font',
            [
                'label'     => esc_html__( 'Use Dark Font', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->add_control(
            'number_of_tabs',
            [
                'label'     => esc_html__('Number of Slides', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '1' => esc_html__('One', 'maxhost'),
                    '2' => esc_html__('Two', 'maxhost'),
                    '3' => esc_html__('Three', 'maxhost'),
                    '4' => esc_html__('Four', 'maxhost'),
					'5' => esc_html__('Five', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();

        $this->start_controls_section(
            'slide01_section',
            [
                'label'     => esc_html__( 'Slide 01', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'text_heading_bold0',
            [
                'label'     => esc_html__( 'Title (Bold Part) of Slide-01', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text_heading_thin0',
            [
                'label'     => esc_html__( 'Title (Thin Part) of Slide-01', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text0',
            [
                'label'     => esc_html__( 'Text of Slide-01', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'features_one0',
            [
                'label'     => esc_html__( 'Bullet Points of Slide-01', 'maxhost' ),         
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'image0',
            [
                'label'     => esc_html__( 'Product Image URL of Slide-01', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_title0',
            [
                'label'     => esc_html__( 'Product Price Title of Slide-01', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Title (e.g. Starts at)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price0',
            [
                'label'     => esc_html__( 'Product Price of Slide-01', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price with Currency (e.g. $99)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_duration0',
            [
                'label'     => esc_html__( 'Product Price Duration of Slide-01', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Duration (e.g. /mo)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'slide02_section',
            [
                'label'     => esc_html__( 'Slide 02', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'text_heading_bold1',
            [
                'label'     => esc_html__( 'Title (Bold Part) of Slide-02', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text_heading_thin1',
            [
                'label'     => esc_html__( 'Title (Thin Part) of Slide-02', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text1',
            [
                'label'     => esc_html__( 'Text of Slide-02', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'features_one1',
            [
                'label'     => esc_html__( 'Bullet Points of Slide-02', 'maxhost' ),         
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'image1',
            [
                'label'     => esc_html__( 'Product Image URL of Slide-02', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_title1',
            [
                'label'     => esc_html__( 'Product Price Title of Slide-02', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Title (e.g. Starts at)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price1',
            [
                'label'     => esc_html__( 'Product Price of Slide-02', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price with Currency (e.g. $99)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_duration1',
            [
                'label'     => esc_html__( 'Product Price Duration of Slide-02', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Duration (e.g. /mo)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'slide03_section',
            [
                'label'     => esc_html__( 'Slide 03', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'text_heading_bold2',
            [
                'label'     => esc_html__( 'Title (Bold Part) of Slide-03', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text_heading_thin2',
            [
                'label'     => esc_html__( 'Title (Thin Part) of Slide-03', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text2',
            [
                'label'     => esc_html__( 'Text of Slide-03', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'features_one2',
            [
                'label'     => esc_html__( 'Bullet Points of Slide-03', 'maxhost' ),         
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'image2',
            [
                'label'     => esc_html__( 'Product Image URL of Slide-03', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_title2',
            [
                'label'     => esc_html__( 'Product Price Title of Slide-03', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Title (e.g. Starts at)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price2',
            [
                'label'     => esc_html__( 'Product Price of Slide-03', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price with Currency (e.g. $99)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_duration2',
            [
                'label'     => esc_html__( 'Product Price Duration of Slide-03', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Duration (e.g. /mo)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'slide04_section',
            [
                'label'     => esc_html__( 'Slide 04', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'text_heading_bold3',
            [
                'label'     => esc_html__( 'Title (Bold Part) of Slide-04', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text_heading_thin3',
            [
                'label'     => esc_html__( 'Title (Thin Part) of Slide-04', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text3',
            [
                'label'     => esc_html__( 'Text of Slide-04', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'features_one3',
            [
                'label'     => esc_html__( 'Bullet Points of Slide-04', 'maxhost' ),         
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'image3',
            [
                'label'     => esc_html__( 'Product Image URL of Slide-04', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_title3',
            [
                'label'     => esc_html__( 'Product Price Title of Slide-04', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Title (e.g. Starts at)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price3',
            [
                'label'     => esc_html__( 'Product Price of Slide-04', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price with Currency (e.g. $99)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_duration3',
            [
                'label'     => esc_html__( 'Product Price Duration of Slide-04', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Duration (e.g. /mo)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'slide05_section',
            [
                'label'     => esc_html__( 'Slide 05', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'text_heading_bold4',
            [
                'label'     => esc_html__( 'Title (Bold Part) of Slide-05', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text_heading_thin4',
            [
                'label'     => esc_html__( 'Title (Thin Part) of Slide-05', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text4',
            [
                'label'     => esc_html__( 'Text of Slide-05', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'features_one4',
            [
                'label'     => esc_html__( 'Bullet Points of Slide-05', 'maxhost' ),         
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'image4',
            [
                'label'     => esc_html__( 'Product Image URL of Slide-05', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_title4',
            [
                'label'     => esc_html__( 'Product Price Title of Slide-05', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Title (e.g. Starts at)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price4',
            [
                'label'     => esc_html__( 'Product Price of Slide-05', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price with Currency (e.g. $99)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_duration4',
            [
                'label'     => esc_html__( 'Product Price Duration of Slide-05', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Duration (e.g. /mo)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['maxhost_shortcodes_parallax_bg'] =  $settings['maxhost_shortcodes_parallax_bg'];
		$args['number_of_tabs'] =  $settings['number_of_tabs'];
		$args['heading1'] =  $settings['heading1'];
		$args['heading2'] =  $settings['heading2'];
		$args['crossed_top'] =  $settings['crossed_top'];
		$args['crossed_bottom'] =  $settings['crossed_bottom'];
		$args['no_white_font'] =  $settings['no_white_font'];
		
		$args['text_heading_bold0'] =  $settings['text_heading_bold0'];
		$args['text_heading_thin0'] =  $settings['text_heading_thin0'];
		$args['text0'] =  $settings['text0'];
		$args['features_one0'] =  $settings['features_one0'];
		$args['image0'] =  $settings['image0'];
		$args['price_title0'] =  $settings['price_title0'];
		$args['price0'] =  $settings['price0'];
		$args['price_duration0'] =  $settings['price_duration0'];
		
		$args['text_heading_bold1'] =  $settings['text_heading_bold1'];
		$args['text_heading_thin1'] =  $settings['text_heading_thin1'];
		$args['text1'] =  $settings['text1'];
		$args['features_one1'] =  $settings['features_one1'];
		$args['image1'] =  $settings['image1'];
		$args['price_title1'] =  $settings['price_title1'];
		$args['price1'] =  $settings['price1'];
		$args['price_duration1'] =  $settings['price_duration1'];
		
		$args['text_heading_bold2'] =  $settings['text_heading_bold2'];
		$args['text_heading_thin2'] =  $settings['text_heading_thin2'];
		$args['text2'] =  $settings['text2'];
		$args['features_one2'] =  $settings['features_one2'];
		$args['image2'] =  $settings['image2'];
		$args['price_title2'] =  $settings['price_title2'];
		$args['price2'] =  $settings['price2'];
		$args['price_duration2'] =  $settings['price_duration2'];
		
		$args['text_heading_bold3'] =  $settings['text_heading_bold3'];
		$args['text_heading_thin3'] =  $settings['text_heading_thin3'];
		$args['text3'] =  $settings['text3'];
		$args['features_one3'] =  $settings['features_one3'];
		$args['image3'] =  $settings['image3'];
		$args['price_title3'] =  $settings['price_title3'];
		$args['price3'] =  $settings['price3'];
		$args['price_duration3'] =  $settings['price_duration3'];
		
		$args['text_heading_bold4'] =  $settings['text_heading_bold4'];
		$args['text_heading_thin4'] =  $settings['text_heading_thin4'];
		$args['text4'] =  $settings['text4'];
		$args['features_one4'] =  $settings['features_one4'];
		$args['image4'] =  $settings['image4'];
		$args['price_title4'] =  $settings['price_title4'];
		$args['price4'] =  $settings['price4'];
		$args['price_duration4'] =  $settings['price_duration4'];
		
        if( function_exists( 'maxhost_offers_carousel_shortcode' ) ) {
            echo maxhost_offers_carousel_shortcode( $args );
        }

    }

}