<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Htab_02 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_htab_02';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Horizontal Tabs 02', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-tabs';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'general_section',
            [
                'label'     => esc_html__( 'Number of Tabs', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'number_of_tabs',
            [
                'label'     => esc_html__('Number of Tabs', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '1' => esc_html__('One', 'maxhost'),
                    '2' => esc_html__('Two', 'maxhost'),
                    '3' => esc_html__('Three', 'maxhost'),
                    '4' => esc_html__('Four', 'maxhost'),
					'5' => esc_html__('Five', 'maxhost'),
                    '6' => esc_html__('Six', 'maxhost'),
                    '7' => esc_html__('Seven', 'maxhost'),
                    '8' => esc_html__('Eight', 'maxhost'),
					'9' => esc_html__('Nine', 'maxhost'),
                    '10' => esc_html__('Ten', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();

        $this->start_controls_section(
            'tab01_section',
            [
                'label'     => esc_html__( 'Tab 01', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title1',
            [
                'label'     => esc_html__( 'Tab-01 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text1',
            [
                'label'     => esc_html__( 'Tab-01 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id1',
			[
				'label' => esc_html__( 'Tab-01 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab02_section',
            [
                'label'     => esc_html__( 'Tab 02', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title2',
            [
                'label'     => esc_html__( 'Tab-02 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text2',
            [
                'label'     => esc_html__( 'Tab-02 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id2',
			[
				'label' => esc_html__( 'Tab-02 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab03_section',
            [
                'label'     => esc_html__( 'Tab 03', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title3',
            [
                'label'     => esc_html__( 'Tab-03 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text3',
            [
                'label'     => esc_html__( 'Tab-03 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id3',
			[
				'label' => esc_html__( 'Tab-03 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab04_section',
            [
                'label'     => esc_html__( 'Tab 04', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title4',
            [
                'label'     => esc_html__( 'Tab-04 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text4',
            [
                'label'     => esc_html__( 'Tab-04 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id4',
			[
				'label' => esc_html__( 'Tab-04 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab05_section',
            [
                'label'     => esc_html__( 'Tab 05', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title5',
            [
                'label'     => esc_html__( 'Tab-05 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text5',
            [
                'label'     => esc_html__( 'Tab-05 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id5',
			[
				'label' => esc_html__( 'Tab-05 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab06_section',
            [
                'label'     => esc_html__( 'Tab 06', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title6',
            [
                'label'     => esc_html__( 'Tab-06 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text6',
            [
                'label'     => esc_html__( 'Tab-06 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id6',
			[
				'label' => esc_html__( 'Tab-06 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab07_section',
            [
                'label'     => esc_html__( 'Tab 07', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title7',
            [
                'label'     => esc_html__( 'Tab-07 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text7',
            [
                'label'     => esc_html__( 'Tab-07 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id7',
			[
				'label' => esc_html__( 'Tab-07 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab08_section',
            [
                'label'     => esc_html__( 'Tab 08', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title8',
            [
                'label'     => esc_html__( 'Tab-08 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text8',
            [
                'label'     => esc_html__( 'Tab-08 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id8',
			[
				'label' => esc_html__( 'Tab-08 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab09_section',
            [
                'label'     => esc_html__( 'Tab 09', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title9',
            [
                'label'     => esc_html__( 'Tab-09 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text9',
            [
                'label'     => esc_html__( 'Tab-09 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id9',
			[
				'label' => esc_html__( 'Tab-09 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab10_section',
            [
                'label'     => esc_html__( 'Tab 10', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title10',
            [
                'label'     => esc_html__( 'Tab-10 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text10',
            [
                'label'     => esc_html__( 'Tab-10 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id10',
			[
				'label' => esc_html__( 'Tab-10 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['number_of_tabs'] =  $settings['number_of_tabs'];
		$args['title1'] =  $settings['title1'];
		$args['text1'] =  $settings['text1'];
		$args['img_one_elementor_id1'] =  $settings['img_one_elementor_id1'];
		$args['title2'] =  $settings['title2'];
		$args['text2'] =  $settings['text2'];
		$args['img_one_elementor_id2'] =  $settings['img_one_elementor_id2'];
		$args['title3'] =  $settings['title3'];
		$args['text3'] =  $settings['text3'];
		$args['img_one_elementor_id3'] =  $settings['img_one_elementor_id3'];
		$args['title4'] =  $settings['title4'];
		$args['text4'] =  $settings['text4'];
		$args['img_one_elementor_id4'] =  $settings['img_one_elementor_id4'];
		$args['title5'] =  $settings['title5'];
		$args['text5'] =  $settings['text5'];
		$args['img_one_elementor_id5'] =  $settings['img_one_elementor_id5'];
		$args['title6'] =  $settings['title6'];
		$args['text6'] =  $settings['text6'];
		$args['img_one_elementor_id6'] =  $settings['img_one_elementor_id6'];
		$args['title7'] =  $settings['title7'];
		$args['text7'] =  $settings['text7'];
		$args['img_one_elementor_id7'] =  $settings['img_one_elementor_id7'];
		$args['title8'] =  $settings['title8'];
		$args['text8'] =  $settings['text8'];
		$args['img_one_elementor_id8'] =  $settings['img_one_elementor_id8'];
		$args['title9'] =  $settings['title9'];
		$args['text9'] =  $settings['text9'];
		$args['img_one_elementor_id9'] =  $settings['img_one_elementor_id9'];
		$args['title10'] =  $settings['title10'];
		$args['text10'] =  $settings['text10'];
		$args['img_one_elementor_id10'] =  $settings['img_one_elementor_id10'];
		
        if( function_exists( 'maxhost_htab_two_shortcode' ) ) {
            echo maxhost_htab_two_shortcode( $args );
        }

    }

}