<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Banner_01 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_banner_01';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Banner', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-image-hotspot';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'heading1',
            [
                'label'     => esc_html__( 'Heading Line 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading2',
            [
                'label'     => esc_html__( 'Heading Line 2 (Colored Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading3',
            [
                'label'     => esc_html__( 'Heading Line 2 (Simple Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading4',
            [
                'label'     => esc_html__( 'Sub-Heading Line 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading5',
            [
                'label'     => esc_html__( 'Sub-Heading Line 2 (Simple Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading6',
            [
                'label'     => esc_html__( 'Sub-Heading Line 2 (Colored Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading7',
            [
                'label'     => esc_html__( 'First Caption Line 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading8',
            [
                'label'     => esc_html__( 'First Caption Line 2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading9',
            [
                'label'     => esc_html__( 'First Caption Line 3', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading10',
            [
                'label'     => esc_html__( 'First Caption Line 4', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading11',
            [
                'label'     => esc_html__( 'Second Caption Line 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading12',
            [
                'label'     => esc_html__( 'Second Caption Line 2 (Simple Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'heading13',
            [
                'label'     => esc_html__( 'Second Caption Line 2 (Colored Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'btn1',
            [
                'label'     => esc_html__( 'Button Text', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		$this->add_control(
            'url1',
            [
                'label'     => esc_html__( 'Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['heading1'] =  $settings['heading1'];
		$args['heading2'] =  $settings['heading2'];
		$args['heading3'] =  $settings['heading3'];
		$args['heading4'] =  $settings['heading4'];
		$args['heading5'] =  $settings['heading5'];
		$args['heading6'] =  $settings['heading6'];
		$args['heading7'] =  $settings['heading7'];
		$args['heading8'] =  $settings['heading8'];
		$args['heading9'] =  $settings['heading9'];
		$args['heading10'] =  $settings['heading10'];
		$args['heading11'] =  $settings['heading11'];
		$args['heading12'] =  $settings['heading12'];
		$args['heading13'] =  $settings['heading13'];
		$args['btn1'] =  $settings['btn1'];
		$args['url1'] =  $settings['url1'];

       
        if( function_exists( 'maxhost_banner_shortcode' ) ) {
            echo maxhost_banner_shortcode( $args );
        }

    }

}