<img src="https://apirone.com/docs/logo.svg" width="200">

# Apirone API PHP <!-- omit in toc -->

[![GitHub license](https://img.shields.io/badge/license-MIT-green.svg?style=flat-square)](https://raw.githubusercontent.com/Apirone/apirone-api-php/main/LICENSE)

This library provides the methods of [Apirone API](https://apirone.com/docs) with PHP. 

- [Requirements](#requirements)
- [Installation](#installation)
- [Library usage](#library-usage)
- [Documentation](#documentation)
- [Support](#support)
- [Changelog](#changelog)
- [License](#license)

## Requirements

- PHP 7.4 or higher. Tested up to 8.2.
- cURL extension
- JSON extension

## Installation

Use [composer](https://getcomposer.org/) for library installation.

```bash
composer require apirone/apirone-api-php
```

## Library usage

To check out docs, visit [apirone.github.io/apirone-sdk-php](https://apirone.github.io/apirone-sdk-php).

- [Account methods](./docs/Account.md) | [Account API docs](https://apirone.com/docs/account)

- [Invoice methods](./docs/Invoices.md) | [Invoices API docs](https://apirone.com/docs/invoices)

- [Wallet methods](./docs/Wallet.md) | [Wallet API docs](https://apirone.com/docs/wallet)

- [Authorization methods](./docs/Authorization.md) | [Authorization API docs](https://apirone.com/docs/authorization)

- [Services methods](./docs/Services.md) |
 [Service Info API docs](https://apirone.com/docs/service),
 [Network Fee API docs](https://apirone.com/docs/fee),
 [Exchange Rate API docs](https://apirone.com/docs/rate)

- [Log Handling](./docs/LogHandling.md)

- [Helpers](./docs/Helpers.md)

## Documentation

To check out docs, visit [apirone.github.io/apirone-api-php](https://apirone.github.io/apirone-api-php).

## Support

- https://github.com/Apirone/apirone-api-php/issues  
- support@apirone.com

## Changelog

Detailed changes for each release are documented in the [CHANGELOG](https://github.com/Apirone/apirone-api-php/blob/main/CHANGELOG.md).

## License

[MIT](https://github.com/Apirone/apirone-api-php/blob/main/LICENSE)

Copyright (c)  2017-present. Apirone. All rights reserved
