#!/usr/bin/python3

# Copyright (c) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Post upcp check php handlers hook
"""
import subprocess
import simplejson as json
import sys

def describe():
    """
    Description of the current hook for Cpanel
    """
    descr = [
        {
            'category': 'System',
            'event'   : 'upcp',
            'stage'   : 'post',
            'hook'    : '/usr/share/lve/modlscapi/hooks/cpanel_post_upcp_check_handlers_hook.py',
            'exectype': 'script',
        }
    ]
    return json.dumps(descr)


if "__main__" == __name__:
    argv = sys.argv[1:]
    if '--describe' in argv:
        print(describe())
        sys.exit(0)
    ret = subprocess.call(["/usr/share/lve/modlscapi/hooks/cpanel_check_handlers_hook.sh", "--post"])
    exit(ret)
