# Copyright (c) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

criu_settings_malfunctions = {
    'on_stopped': {
        'reason': 'Criu service stopped',
        'description': "Run 'service criu start' because lsapi_criu enabled through Apache configs"
    },
    'off_running': {
        'reason': 'lsapi_criu disabled',
        'description': "Set 'lsapi_criu On' through Apache configs because criu service is running"
    }
}
lsapi_settings_malfunctions = {
    'disabled': {
        'reason': 'Apache module lsapi_module is not loaded',
        'description': "Enable mod_lsapi through Apache configs with 'LoadModule lsapi_module modules/mod_lsapi.so' directive"
    }
}
liblsapi_malfunctions = {
    None: {
        'reason': 'No liblsapi found',
        'description': "Install liblsapi package"
    }
}


