#!/usr/bin/bash

CMD="$1"

HLOG="/usr/share/lve/modlscapi/logs/last.pre.upcp.handlers"

function get_current_handlers() {
    /usr/sbin/whmapi1 php_get_handlers | while read -r line;
    do
        echo -n "$line" | sed -n '/current_handler:/p' >> "$LOG"
        echo " $line" | sed -n '/version: [ea:alt]/p' >> "$LOG"
    done
}

function set_handlers_back() {
    cat "$HLOG" | while read -r line;
    do
        HANDLER=$(echo "$line" | cut -d ' ' -f2)
        PHPVERS=$(echo "$line" | cut -d ' ' -f4)
        echo "Setting $PHPVERS to $HANDLER handler" >> "$LOG"
        /usr/sbin/whmapi1 php_set_handler version="$PHPVERS" handler="$HANDLER" 2>/dev/null >/dev/null
    done
}

if [ "$CMD" == "--pre" ]; then
    LOG="/usr/share/lve/modlscapi/logs/Pre.upcp.$(date +%Y-%m-%d_%H:%M).log"
    get_current_handlers
    truncate -s 0 "$HLOG"
    cat "$LOG" >> "$HLOG"
    exit 0
fi

if [ "$CMD" == "--post" ]; then
    LOG="/usr/share/lve/modlscapi/logs/Post.upcp.$(date +%Y-%m-%d_%H:%M).log"
    get_current_handlers
    if diff "$LOG" "$HLOG" >/dev/null ; then
        echo "Handlers matched after upcp" >> "$LOG"
    else
        echo "Error: Handlers not matched after upcp" >> "$LOG"
        # Uncomment on the server where the lsapi handler is automatically turned off after the upcp
        set_handlers_back
    fi
    exit 0
fi


