<?php
/********************************************
 * LiteSpeed web server Plugin for WHM
 * @Author:   Lite Speed Technologies, Inc. (http://www.litespeedtech.com)
 * @Copyright: (c) 2013
 *********************************************/

define ('PHP_AP_LOC', '/usr/local/bin/php');
define ('EASYAPACHE_BUILD_DIR_CP', '/home/cpeasyapache/src');
define ('EASYAPACHE_BUILD_DIR_LS', '/home/cpeasyapache/ls.src');

class WhmMod_LiteSpeed_BuildPHP
{
	
	private function get_php_config($php_binary)
	{
		putenv( "ACCEPT_ENCODING" );
		putenv( "HTTP_ACCEPT_ENCODING" );
		putenv( "SCRIPT_FILENAME" );
		putenv( "REDIRECT_STATUS" );
		putenv( "SERVER_SOFTWARE" );
		putenv( "SERVER_NAME" );
		putenv( "GATEWAY_INTERFACE" );
		putenv( "REQUEST_METHOD" );

		$extract_values = array();
		exec("$php_binary -c ./php.ini -i", $output, $returns);
		if ($returns > 10) {
			$extract_values['error'] =  "ERROR: $php_binary -i returns $returns <br>" . implode('<br>', $output);
			return $extract_values;
		}

		foreach($output as $line) {
			//PHP Version 4.4.7
			//<tr><td class="e">Configure Command </td><td class="v"> &#039;./configure&#039; </td></tr>
			//PHP Version => 4.4.8
			//Configure Command =>  './configure' '--enable-bcmath' '--enable-calendar' '--enable-ftp' '--enable-gd

			if (preg_match("/PHP Version [^\d]*([\d.]+)/", $line, $matches)) {
				$extract_values['PHP_VERSION'] = $matches[1];
			}

			if (strpos($line, 'Configure Command') !== FALSE) {
				# echo "\n\nA: $line\n";
				// before 4.4.8
				trim($line);
				$line = str_replace('&#039;', "'", $line);
				$start_pos = strpos($line, "./configure");
				if ($start_pos === FALSE) { // should not happen
					$extract_values['error'] = 'Cannot find configure options!';
					return $extract_values;
				}
				if ($line[$start_pos-1] == "'")
				-- $start_pos; //including the quote
				$line = substr($line, $start_pos);
				if (($end_pos = strpos($line, '</td>')) !== FALSE) {
					$line = substr($line, 0, $end_pos);
				}

				// remove unused params: '--with-apxs2=/usr/local/apache/bin/apxs'
				$pattern_unused = '/\'?--with-apxs[^ \']+\'? ?/';
				$line = preg_replace($pattern_unused, '', $line);

				$pattern_unused = '/\'?--enable-fastcgi\'? ?/';
				$line = preg_replace($pattern_unused, '', $line);

				if (strpos($line, '--with-litespeed') === FALSE) {
					//find last param, see if there's missing quote
					$line = trim($line);
					if (substr($line,-1) != "'" ) {
						$pos0 = strrpos($line, '--');
						if ($pos0 > 1 && (substr($line, $pos0 -1, 1) == "'")) {
							$line .= "'";
						}
					}
					$line .= " '--with-litespeed'";
				}

				$extract_values['PHP_CONF_OPTIONS'] = $line;
				return $extract_values;
			}
		}
		$extract_values['error'] = 'Cannot find configuration options!';
		if (count($output) < 10) {
			$extract_values['error'] .= "ERROR: $php_binary -i returns $returns <br>" . implode('<br>', $output);
		}
		return $extract_values;
	}

	public function GenerateBuildScript($base_php_binary, $path_to_bld = "")
	{
		$result = array();
		//get env
		$php_options = $this->get_php_config($base_php_binary);
		if (isset($php_options['error'])) {
			$result['error'] = $php_options['error'];
			return $result;
		}

		$php_options['PHP_BUILD_DIR'] = EASYAPACHE_BUILD_DIR_LS;
		$php_options['CP_BUILD_DIR'] = $path_to_bld.EASYAPACHE_BUILD_DIR_CP;
		$php_options['LSWS_HOME'] = LSWS_HOME;

		if ( !file_exists(WGET_TEMP) && !mkdir(WGET_TEMP, 0700, true) ) {
			$result['error'] = 'Cannot create temp build directory ' . WGET_TEMP;
			return $result;
		} 
			
		//generate shell script
		$template = './php_build.template';
		$sh_template = file_get_contents($template);
		if ($sh_template === false) {
			$result['error'] = 'failed to read file: ' . $template;
			return $result;
		}

		$search = array('{PHP_BUILD_DIR}',
			'{CP_BUILD_DIR}',
			'{PHP_VERSION}', 
			'{PHP_CONF_OPTIONS}',
			'{LSWS_HOME}');
		$replace = array($php_options['PHP_BUILD_DIR'],
		$php_options['CP_BUILD_DIR'],
		$php_options['PHP_VERSION'],
		$php_options['PHP_CONF_OPTIONS'],
		$php_options['LSWS_HOME']);
		$sh_script = str_replace($search, $replace, $sh_template);

		$file_name = WGET_TEMP . '/build_lsphp_' . $php_options['PHP_VERSION'] . '.sh';
		
		if ( file_put_contents($file_name, $sh_script) === FALSE) {
			$result['error'] = 'Failed to create build script: ' . $file_name;
			return $result;
		}

		if ( chmod($file_name, 0700) == FALSE) {
			$result['error'] = 'Failed to chmod for ' . $file_name;
			return $result;
		}

		$result['file'] = $file_name;
		return $result;
	}

	function PrecheckPHPVersion($PHP_BINARY_LOC)
	{
		// return 0: same, 1 different; 2 error stop;
		$result = array('msg' => '', 'next' => 1);

		$apache_php = $this->get_php_config($PHP_BINARY_LOC);
		if (isset($apache_php['error'])) {
			$result['msg'] .= $apache_php['error'];
			$result['next'] = 2;
			return $result;
		}		
		$result['msg'] .= "Found Apache PHP binary at $PHP_BINARY_LOC  Version is {$apache_php['PHP_VERSION']} \n";
		$main_version = $apache_php['PHP_VERSION'][0];

		$lsphp_binary = LSWS_HOME . '/fcgi-bin/lsphp' . $main_version;
		if (!file_exists($lsphp_binary)) {
			$result['msg'] .= "{$lsphp_binary} does not exist! \n";
			return $result;
		}

		$ls_php = $this->get_php_config($lsphp_binary);
		if (isset($ls_php['error'])) {
			$result['msg'] .= "{$lsphp_binary} exists, but not runnable: {$ls_php['error']} \n";
			return $result;
		}
		$result['msg'] .= "Found LiteSpeed PHP binary at {$lsphp_binary}. Version is {$ls_php['PHP_VERSION']} \n";

		if ( $apache_php['PHP_VERSION'] != $ls_php['PHP_VERSION'] ) {
			$result['msg'] .= "PHP binary has different version! \n";
			return $result;
		}

		//compare conf
		$apache_options = preg_split("/[' ]/", $apache_php['PHP_CONF_OPTIONS'], -1, PREG_SPLIT_NO_EMPTY);
		$ls_options = preg_split("/[' ]/", $ls_php['PHP_CONF_OPTIONS'], -1, PREG_SPLIT_NO_EMPTY);
		$conf_diff = '';
		foreach( $apache_options as $ai) {
			if (!in_array($ai, $ls_options)) {
				$conf_diff .= " $ai";
			}
		}
		if ($conf_diff == '') {
			$result['msg'] .= "Configuration options for lsphp and Apache PHP are matched.\n";
			$result['next'] = 0; // same, no action needed.
			return $result;
		}
		else {
			$result['msg'] .= "Apache PHP configuration has more options that are not available or different in lsphp: $conf_diff \n";
			return $result;
		}

	}


}



