<?php defined( 'ABSPATH' ) or die;
/* @var DiRFFd $field */
/* @var DiRF $form */
/* @var mixed $default */
/* @var string $name */
/* @var string $idname */
/* @var string $label */
/* @var string $desc */
/* @var string $rendering */

// [!!] the counter field needs to be able to work inside other fields; if
// the field is in another field it will have a null label

$selected = $form->autovalue( $name, $default );

$attrs = array
(
	'name' => $name,
	'id'   => $idname,
);

// group show

if ($field->hasmeta('show_group')) {
	$attrs['data-show_group'] =  $field->getmeta('show_group');
}

if ($field->hasmeta('display_option')) {
	$attrs['data-display_option'] =  $field->getmeta('display_option');
}?>
<div class="select">
	<label id="<?php echo esc_attr($name) ?>"><?php echo esc_html($label) ?></label>
	<select <?php echo $field->htmlattributes( $attrs ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- done already ?>>
		<?php foreach ( $this->getmeta( 'options', array() ) as $key => $label ): ?>
			<option <?php if ($key == $selected): ?>selected<?php endif; ?>
			        value="<?php echo esc_attr($key); ?>">
				<?php echo esc_html($label); ?>
			</option>
		<?php endforeach; ?>
	</select>
</div>
