<?php

namespace {
	/**
	 * The main blog template loop class.
	 *
	 * Responsible for loading a group of blogs into a loop for display.
	 */
	class BP_Blogs_Template
	{
		/**
		 * The loop iterator.
		 *
		 * @var int
		 */
		public $current_blog = -1;
		/**
		 * The number of blogs returned by the paged query.
		 *
		 * @var int
		 */
		public $blog_count;
		/**
		 * Array of blogs located by the query..
		 *
		 * @var array
		 */
		public $blogs = array();
		/**
		 * The blog object currently being iterated on.
		 *
		 * @var object
		 */
		public $blog;
		/**
		 * A flag for whether the loop is currently being iterated.
		 *
		 * @var bool
		 */
		public $in_the_loop = \false;
		/**
		 * The page number being requested.
		 *
		 * @var int
		 */
		public $pag_page = 1;
		/**
		 * The number of items being requested per page.
		 *
		 * @var int
		 */
		public $pag_num = 20;
		/**
		 * An HTML string containing pagination links.
		 *
		 * @var string
		 */
		public $pag_links = '';
		/**
		 * URL argument used for the pagination param.
		 *
		 * @var string
		 */
		public $pag_arg;
		/**
		 * The total number of blogs matching the query parameters.
		 *
		 * @var int
		 */
		public $total_blog_count;
		/**
		 * Constructor method.
		 *
		 * @since 1.2.0
		 * @since 10.0.0 Converted to array as main function argument. Added $date_query parameter.
		 *
		 * @see BP_Blogs_Blog::get() for a description of parameters.
		 *
		 * @param array $args {
		 *     Array of arguments. See {@link BP_Blogs_Blog::get()}.
		 * }
		 */
		public function __construct(...$args)
		{
		}
		/**
		 * Whether there are blogs available in the loop.
		 *
		 * @see bp_has_blogs()
		 *
		 * @return bool True if there are items in the loop, otherwise false.
		 */
		public function has_blogs()
		{
		}
		/**
		 * Set up the next blog and iterate index.
		 *
		 * @return object The next blog to iterate over.
		 */
		public function next_blog()
		{
		}
		/**
		 * Rewind the blogs and reset blog index.
		 */
		public function rewind_blogs()
		{
		}
		/**
		 * Whether there are blogs left in the loop to iterate over.
		 *
		 * This method is used by {@link bp_blogs()} as part of the while loop
		 * that controls iteration inside the blogs loop, eg:
		 *     while ( bp_blogs() ) { ...
		 *
		 * @see bp_blogs()
		 *
		 * @return bool True if there are more blogs to show, otherwise false.
		 */
		public function blogs()
		{
		}
		/**
		 * Set up the current blog inside the loop.
		 *
		 * Used by {@link bp_the_blog()} to set up the current blog data while
		 * looping, so that template tags used during that iteration make
		 * reference to the current blog.
		 *
		 * @see bp_the_blog()
		 */
		public function the_blog()
		{
		}
	}
	/**
	 * The main theme compat class for BuddyPress Blogs.
	 *
	 * This class sets up the necessary theme compatibility actions to safely output
	 * group template parts to the_title and the_content areas of a theme.
	 *
	 * @since 1.7.0
	 */
	class BP_Blogs_Theme_Compat
	{
		/**
		 * Set up theme compatibility for the Blogs component.
		 *
		 * @since 1.7.0
		 */
		public function __construct()
		{
		}
		/**
		 * Are we looking at something that needs Blogs theme compatibility?
		 *
		 * @since 1.7.0
		 */
		public function is_blogs()
		{
		}
		/** Directory *************************************************************/
		/**
		 * Add template hierarchy to theme compat for the blog directory page.
		 *
		 * This is to mirror how WordPress has
		 * {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param string $templates The templates from bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function directory_template_hierarchy($templates)
		{
		}
		/**
		 * Update the global $post with directory data.
		 *
		 * @since 1.7.0
		 */
		public function directory_dummy_post()
		{
		}
		/**
		 * Filter the_content with the groups index template part.
		 *
		 * @since 1.7.0
		 */
		public function directory_content()
		{
		}
		/** Create ****************************************************************/
		/**
		 * Add custom template hierarchy to theme compat for the blog create page.
		 *
		 * This is to mirror how WordPress has
		 * {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param string $templates The templates from bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function create_template_hierarchy($templates)
		{
		}
		/**
		 * Update the global $post with create screen data.
		 *
		 * @since 1.7.0
		 */
		public function create_dummy_post()
		{
		}
		/**
		 * Filter the_content with the create screen template part.
		 *
		 * @since 1.7.0
		 */
		public function create_content()
		{
		}
	}
	/**
	 * Blogs endpoints.
	 *
	 * Use /blogs/
	 * Use /blogs/{id}
	 *
	 * @since 6.0.0
	 */
	class BP_REST_Blogs_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 6.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 6.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve Blogs.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to blog items.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Retrieve a blog.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to get information about a specific blog.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Create a new blog.
		 *
		 * @since 7.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Check if a given request has access to create a blog.
		 *
		 * @since 7.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Prepares blogs data for return as an object.
		 *
		 * @since 6.0.0
		 *
		 * @param stdClass        $blog    Blog object.
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($blog, $request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 6.0.0
		 *
		 * @param stdClass $blog Blog object.
		 * @return array
		 */
		protected function prepare_links($blog)
		{
		}
		/**
		 * Get blog permalink.
		 *
		 * @param stdClass $blog Blog object.
		 * @return string
		 */
		protected function get_blog_permalink($blog)
		{
		}
		/**
		 * Get a blog object from a blog_id.
		 *
		 * @since 6.0.0
		 *
		 * @param int $blog_id Blog ID.
		 * @return stdClass|int
		 */
		public function get_blog_object($blog_id)
		{
		}
		/**
		 * Edit the type of the some properties for the CREATABLE method.
		 *
		 * @since 7.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the blogs schema, conforming to JSON Schema.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for blogs collections.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * Attachments Trait
	 *
	 * @since 5.0.0
	 */
	trait BP_REST_Attachments
	{
		/**
		 * Cover upload from file.
		 *
		 * @since 6.0.0
		 *
		 * @param array $file $_FILES superglobal.
		 * @return string|WP_Error
		 */
		protected function upload_cover_from_file($file)
		{
		}
		/**
		 * Avatar upload from File.
		 *
		 * @since 5.0.0
		 *
		 * @param array $files $_FILES superglobal.
		 * @return stdClass|WP_Error
		 */
		protected function upload_avatar_from_file($files)
		{
		}
		/**
		 * Resize image.
		 *
		 * @since 5.0.0
		 *
		 * @param string $file Image to resize.
		 * @return string|WP_Error
		 */
		protected function resize($file)
		{
		}
		/**
		 * Crop image.
		 *
		 * @since 5.0.0
		 *
		 * @param string $image_file Image to crop.
		 * @return array|WP_Error
		 */
		protected function crop_image($image_file)
		{
		}
		/**
		 * Delete group's existing avatar if one exists.
		 *
		 * @since 5.0.0
		 */
		protected function delete_existing_image()
		{
		}
		/**
		 * Returns the avatar object.
		 *
		 * @since 6.0.0
		 *
		 * @param array $args {
		 *    An array of arguments to build the Avatar object.
		 *
		 *    @type string $full  The url to the full version of the avatar.
		 *    @type string $thumb The url to the thumb version of the avatar.
		 * }
		 * @return object The avatar object.
		 */
		protected function get_avatar_object($args = array())
		{
		}
		/**
		 * Get item id.
		 *
		 * @since 5.0.0
		 *
		 * @return int
		 */
		protected function get_item_id()
		{
		}
		/**
		 * Get cover object component.
		 *
		 * @since 6.0.0
		 *
		 * @return string
		 */
		protected function get_cover_object_component()
		{
		}
	}
	/**
	 * Blog avatar endpoints.
	 *
	 * @since 6.0.0
	 */
	class BP_REST_Attachments_Blog_Avatar_Endpoint extends \WP_REST_Controller
	{
		use \BP_REST_Attachments;
		/**
		 * Reuse some parts of the BP_REST_Blogs_Endpoint class.
		 *
		 * @since 6.0.0
		 *
		 * @var BP_REST_Blogs_Endpoint
		 */
		protected $blogs_endpoint;
		/**
		 * This variable is used to query for the requested blog only once.
		 * It is set during the permission check methods.
		 *
		 * @since 6.0.0
		 *
		 * @var BP_Blogs_Blog
		 */
		protected $blog;
		/**
		 * Constructor.
		 *
		 * @since 6.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 6.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Fetch an existing blog avatar.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Checks if a given request has access to get a blog avatar.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Prepares avatar data to return as an object.
		 *
		 * @since 6.0.0
		 *
		 * @param stdClass        $avatar  Avatar object.
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($avatar, $request)
		{
		}
		/**
		 * Get the blog avatar schema, conforming to JSON Schema.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for the `get_item`.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_item_collection_params()
		{
		}
	}
	/**
	 * The main BuddyPress blog class.
	 *
	 * A BP_Blogs_Object represents a link between a specific WordPress blog on a
	 * network and a specific user on that blog.
	 *
	 * @since 1.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Blogs_Blog
	{
		/**
		 * Site ID.
		 *
		 * @var int|null
		 */
		public $id;
		/**
		 * User ID.
		 *
		 * @var int
		 */
		public $user_id;
		/**
		 * Blog ID.
		 *
		 * @var int
		 */
		public $blog_id;
		/**
		 * Constructor method.
		 *
		 * @param int|null $id Optional. The ID of the blog.
		 */
		public function __construct($id = \null)
		{
		}
		/**
		 * Populate the object with data about the specific activity item.
		 */
		public function populate()
		{
		}
		/**
		 * Save the BP blog data to the database.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Check whether an association between this user and this blog exists.
		 *
		 * @return int $value The number of associations between the user and blog
		 *                    saved in the blog component tables.
		 */
		public function exists()
		{
		}
		/** Static Methods ***************************************************/
		/**
		 * Retrieve a set of blog-user associations.
		 *
		 * @since 1.2.0
		 * @since 10.0.0 Converted to array as main function argument. Added `$date_query` parameter.
		 *
		 * @param array $data {
		 *     Array of site data to query for.
		 *     @type string      $type              The order in which results should be returned.
		 *                                          'active', 'alphabetical', 'newest', or 'random'.
		 *     @type int|bool    $per_page          Optional. The number of records to return per page.
		 *                                          Default: false.
		 *     @type int|bool    $page              Optional. The page of records to return.
		 *                                          Default: false (unlimited results).
		 *     @type int         $user_id           Optional. ID of the user whose blogs are being
		 *                                          retrieved. Default: 0.
		 *     @type string|bool $search_terms      Optional. Search by text stored in
		 *                                          blogmeta (such as the blog name). Default: false.
		 *     @type bool        $update_meta_cache Whether to pre-fetch metadata for
		 *                                          blogs. Default: true.
		 *     @type array|bool  $include_blog_ids  Optional. Array of blog IDs to include.
		 *     @type array       $date_query        Optional. Filter results by site last activity date. See first
		 *                                          paramter of {@link WP_Date_Query::__construct()} for syntax. Only
		 *                                          applicable if $type is either 'newest' or 'active'.
		 * }
		 * @return array Multidimensional results array, structured as follows:
		 *               'blogs' - Array of located blog objects
		 *               'total' - A count of the total blogs matching the filter params
		 */
		public static function get(...$args)
		{
		}
		/**
		 * Delete the record of a given blog for all users.
		 *
		 * @param int $blog_id The blog being removed from all users.
		 * @return int|bool Number of rows deleted on success, false on failure.
		 */
		public static function delete_blog_for_all($blog_id)
		{
		}
		/**
		 * Delete the record of a given blog for a specific user.
		 *
		 * @param int      $blog_id The blog being removed.
		 * @param int|null $user_id Optional. The ID of the user from whom the blog is
		 *                          being removed. If absent, defaults to the logged-in user ID.
		 * @return int|bool Number of rows deleted on success, false on failure.
		 */
		public static function delete_blog_for_user($blog_id, $user_id = \null)
		{
		}
		/**
		 * Delete all of a user's blog associations in the BP tables.
		 *
		 * @param int|null $user_id Optional. The ID of the user whose blog associations
		 *                          are being deleted. If absent, defaults to logged-in user ID.
		 * @return int|bool Number of rows deleted on success, false on failure.
		 */
		public static function delete_blogs_for_user($user_id = \null)
		{
		}
		/**
		 * Get all of a user's blogs, as tracked by BuddyPress.
		 *
		 * Note that this is different from the WordPress function
		 * {@link get_blogs_of_user()}; the current method returns only those
		 * blogs that have been recorded by BuddyPress, while the WP function
		 * does a true query of a user's blog capabilities.
		 *
		 * @param int  $user_id     Optional. ID of the user whose blogs are being
		 *                          queried. Defaults to logged-in user.
		 * @param bool $show_hidden Optional. Whether to include blogs that are not marked
		 *                          public. Defaults to true when viewing one's own profile.
		 * @return array Multidimensional results array, structured as follows:
		 *               'blogs' - Array of located blog objects.
		 *               'total' - A count of the total blogs for the user.
		 */
		public static function get_blogs_for_user($user_id = 0, $show_hidden = \false)
		{
		}
		/**
		 * Get IDs of all of a user's blogs, as tracked by BuddyPress.
		 *
		 * This method always includes hidden blogs.
		 *
		 * @param int $user_id Optional. ID of the user whose blogs are being
		 *                     queried. Defaults to logged-in user.
		 * @return int The number of blogs associated with the user.
		 */
		public static function get_blog_ids_for_user($user_id = 0)
		{
		}
		/**
		 * Check whether a blog has been recorded by BuddyPress.
		 *
		 * @param int $blog_id ID of the blog being queried.
		 * @return int|null The ID of the first located entry in the BP table
		 *                  on success, otherwise null.
		 */
		public static function is_recorded($blog_id)
		{
		}
		/**
		 * Return a count of associated blogs for a given user.
		 *
		 * Includes hidden blogs when the logged-in user is the same as the
		 * $user_id parameter, or when the logged-in user has the bp_moderate
		 * cap.
		 *
		 * @param int|null $user_id Optional. ID of the user whose blogs are being
		 *                          queried. Defaults to logged-in user.
		 * @return int Blog count for the user.
		 */
		public static function total_blog_count_for_user($user_id = \null)
		{
		}
		/**
		 * Return a list of blogs matching a search term.
		 *
		 * Matches against blog names and descriptions, as stored in the BP
		 * blogmeta table.
		 *
		 * @param string   $filter The search term.
		 * @param int|null $limit  Optional. The maximum number of items to return.
		 *                         Default: null (no limit).
		 * @param int|null $page   Optional. The page of results to return. Default:
		 *                         null (no limit).
		 * @return array Multidimensional results array, structured as follows:
		 *               'blogs' - Array of located blog objects.
		 *               'total' - A count of the total blogs matching the query.
		 */
		public static function search_blogs($filter, $limit = \null, $page = \null)
		{
		}
		/**
		 * Retrieve a list of all blogs.
		 *
		 * Query will include hidden blogs if the logged-in user has the
		 * 'bp_moderate' cap.
		 *
		 * @param int|null $limit Optional. The maximum number of items to return.
		 *                        Default: null (no limit).
		 * @param int|null $page  Optional. The page of results to return. Default:
		 *                        null (no limit).
		 * @return array Multidimensional results array, structured as follows:
		 *               'blogs' - Array of located blog objects.
		 *               'total' - A count of the total blogs.
		 */
		public static function get_all($limit = \null, $page = \null)
		{
		}
		/**
		 * Retrieve a list of blogs whose names start with a given letter.
		 *
		 * Query will include hidden blogs if the logged-in user has the
		 * 'bp_moderate' cap.
		 *
		 * @param string   $letter The letter you're looking for.
		 * @param int|null $limit  Optional. The maximum number of items to return.
		 *                         Default: null (no limit).
		 * @param int|null $page   Optional. The page of results to return. Default:
		 *                         null (no limit).
		 * @return array Multidimensional results array, structured as follows:
		 *               'blogs' - Array of located blog objects.
		 *               'total' - A count of the total blogs matching the query.
		 */
		public static function get_by_letter($letter, $limit = \null, $page = \null)
		{
		}
		/**
		 * Fetch blog data not caught in the main query and append it to results array.
		 *
		 * Gets the following information, which is either unavailable at the
		 * time of the original query, or is more efficient to look up in one
		 * fell swoop:
		 *   - The latest post for each blog, include Featured Image data
		 *   - The blog description
		 *
		 * @param array       $paged_blogs Array of results from the original query.
		 * @param array       $blog_ids    Array of IDs returned from the original query.
		 * @param string|bool $type        Not currently used. Default: false.
		 * @return array $paged_blogs The located blogs array, with the extras added.
		 */
		public static function get_blog_extras(&$paged_blogs, &$blog_ids, $type = \false)
		{
		}
		/**
		 * Check whether a given blog is hidden.
		 *
		 * Checks the 'public' column in the wp_blogs table.
		 *
		 * @param int $blog_id The ID of the blog being checked.
		 * @return bool True if hidden (public = 0), false otherwise.
		 */
		public static function is_hidden($blog_id)
		{
		}
		/**
		 * Get ID of user-blog link.
		 *
		 * @param int $user_id ID of user.
		 * @param int $blog_id ID of blog.
		 * @return int|bool ID of user-blog link, or false if not found.
		 */
		public static function get_user_blog($user_id, $blog_id)
		{
		}
	}
	/**
	 * The Recent Networkwide Posts widget.
	 *
	 * @since 1.0.0
	 * @deprecated 12.0.0
	 */
	class BP_Blogs_Recent_Posts_Widget
	{
		/**
		 * Constructor method.
		 *
		 * @since 1.5.0
		 * @since 9.0.0 Adds the `show_instance_in_rest` property to Widget options.
		 * @deprecated 12.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Display the networkwide posts widget.
		 *
		 * @see WP_Widget::widget() for description of parameters.
		 *
		 * @deprecated 12.0.0
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Widget settings, as saved by the user.
		 */
		public function widget($args, $instance)
		{
		}
		/**
		 * Update the networkwide posts widget options.
		 *
		 * @deprecated 12.0.0
		 *
		 * @param array $new_instance The new instance options.
		 * @param array $old_instance The old instance options.
		 * @return array $instance The parsed options to be saved.
		 */
		public function update($new_instance, $old_instance)
		{
		}
		/**
		 * Output the networkwide posts widget options form.
		 *
		 * @deprecated 12.0.0
		 *
		 * @param array $instance Settings for this widget.
		 */
		public function form($instance)
		{
		}
	}
	/**
	 * BuddyPress Component Class.
	 *
	 * The BuddyPress component class is responsible for simplifying the creation
	 * of components that share similar behaviors and routines. It is used
	 * internally by BuddyPress to create the bundled components, but can be
	 * extended to create other really neat things.
	 *
	 * @since 1.5.0
	 */
	class BP_Component
	{
		/** Variables *************************************************************/
		/**
		 * Translatable name for the component.
		 *
		 * @internal
		 *
		 * @var string
		 */
		public $name = '';
		/**
		 * Unique ID for the component.
		 *
		 * @since 1.5.0
		 *
		 * @var string
		 */
		public $id = '';
		/**
		 * Unique slug for the component, for use in query strings and URLs.
		 *
		 * @since 1.5.0
		 *
		 * @var string
		 */
		public $slug = '';
		/**
		 * Does the component need a top-level directory?
		 *
		 * @since 1.5.0
		 *
		 * @var bool
		 */
		public $has_directory = \false;
		/**
		 * Directory's permalink structure for the component.
		 *
		 * @since 12.0.0
		 *
		 * @var string
		 */
		public $directory_permastruct = '';
		/**
		 * List of available rewrite IDs for the component.
		 *
		 * @since 12.0.0
		 *
		 * @var array
		 */
		public $rewrite_ids = array();
		/**
		 * The path to the component's files.
		 *
		 * @since 1.5.0
		 *
		 * @var string
		 */
		public $path = '';
		/**
		 * The WP_Query loop for this component.
		 *
		 * @since 1.5.0
		 *
		 * @var WP_Query
		 */
		public $query = \false;
		/**
		 * The current ID of the queried object.
		 *
		 * @since 1.5.0
		 *
		 * @var string
		 */
		public $current_id = '';
		/**
		 * Callback for formatting notifications.
		 *
		 * @since 1.5.0
		 *
		 * @var callable
		 */
		public $notification_callback = '';
		/**
		 * WordPress Toolbar links.
		 *
		 * @since 1.5.0
		 *
		 * @var array
		 */
		public $admin_menu = '';
		/**
		 * Placeholder text for component directory search box.
		 *
		 * @since 1.6.0
		 *
		 * @var string
		 */
		public $search_string = '';
		/**
		 * Root slug for the component.
		 *
		 * @since 1.6.0
		 *
		 * @var string
		 */
		public $root_slug = '';
		/**
		 * Metadata tables for the component (if applicable).
		 *
		 * @since 2.0.0
		 *
		 * @var array
		 */
		public $meta_tables = array();
		/**
		 * Global tables for the component (if applicable).
		 *
		 * @since 2.0.0
		 *
		 * @var array
		 */
		public $global_tables = array();
		/**
		 * Table name.
		 *
		 * @since 12.0.0
		 *
		 * @var string
		 */
		public $table_name = '';
		/**
		 * Query argument for component search URLs.
		 *
		 * @since 2.4.0
		 *
		 * @var string
		 */
		public $search_query_arg = 's';
		/**
		 * An array of globalized data for BP Blocks.
		 *
		 * @since 9.0.0
		 *
		 * @var array
		 */
		public $block_globals = array();
		/**
		 * Menu position of the WP Toolbar's "My Account menu".
		 *
		 * @since 1.5.0
		 *
		 * @var int
		 */
		public $adminbar_myaccount_order = 90;
		/**
		 * An array of feature names.
		 *
		 * @since 1.5.0
		 *
		 * @var string[]
		 */
		public $features = array();
		/**
		 * Component's directory title.
		 *
		 * @since 2.0.0
		 *
		 * @var string
		 */
		public $directory_title = '';
		/**
		 * Component's main nav items.
		 *
		 * @since 12.0.0
		 *
		 * @var array
		 */
		public $main_nav = array();
		/**
		 * Component's main nav sub items.
		 *
		 * @since 12.0.0
		 *
		 * @var array
		 */
		public $sub_nav = array();
		/** Methods ***************************************************************/
		/**
		 * Component loader.
		 *
		 * @since 1.5.0
		 * @since 1.9.0 Added $params as a parameter.
		 * @since 2.3.0 Added $params['features'] as a configurable value.
		 * @since 2.4.0 Added $params['search_query_arg'] as a configurable value.
		 *
		 * @param string $id   Unique ID. Letters, numbers, and underscores only.
		 * @param string $name Unique name. This should be a translatable name, eg.
		 *                     __( 'Groups', 'buddypress' ).
		 * @param string $path The file path for the component's files. Used by {@link BP_Component::includes()}.
		 * @param array  $params {
		 *     Additional parameters used by the component.
		 *     @type int    $adminbar_myaccount_order Set the position for our menu under the WP Toolbar's "My Account menu".
		 *     @type array  $features                 An array of feature names. This is used to load additional files from your
		 *                                            component directory and for feature active checks. eg. array( 'awesome' )
		 *                                            would look for a file called "bp-{$this->id}-awesome.php" and you could use
		 *                                            bp_is_active( $this->id, 'awesome' ) to determine if the feature is active.
		 *     @type string $search_query_arg         String to be used as the query argument in component search URLs.
		 * }
		 */
		public function start($id = '', $name = '', $path = '', $params = array())
		{
		}
		/**
		 * Set up component global variables.
		 *
		 * @since 1.5.0
		 * @since 2.0.0 Adds the `$directory_title` argument to the `$args` parameter.
		 * @since 9.0.0 Adds the `$block_globals` argument to the `$args` parameter.
		 * @since 12.0.0 Adds the `$rewrite_ids` argument to the `$args` parameter.
		 *
		 * @param array $args {
		 *     All values are optional.
		 *     @type string   $slug                  The component slug. Used to construct certain URLs, such as 'friends' in
		 *                                           http://example.com/members/joe/friends/. Default: the value of $this->id.
		 *     @type string   $root_slug             The component root slug. Note that this value is generally unused if the
		 *                                           component has a root directory (the slug will be overridden by the
		 *                                           post_name of the directory page). Default: the slug of the directory page
		 *                                           if one is found, otherwise an empty string.
		 *     @type bool     $has_directory         Set to true if the component requires an associated WordPress page.
		 *     @type array    $rewrite_ids           The list of rewrited IDs to use for the component.
		 *     @type string   $directory_title       The title to use for the directory page.
		 *     @type callable $notification_callback The callable function that formats the component's notifications.
		 *     @type string   $search_string         The placeholder text for the directory search box. Eg: 'Search Groups...'.
		 *     @type array    $global_tables         An array of database table names.
		 *     @type array    $meta_tables           An array of metadata table names.
		 *     @type array    $block_globals         An array of globalized data for BP Blocks.
		 * }
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Include required files.
		 *
		 * Please note that, by default, this method is fired on the bp_include
		 * hook, with priority 8. This is necessary so that core components are
		 * loaded in time to be available to third-party plugins. However, this
		 * load order means that third-party plugins whose main files are
		 * loaded at bp_include with priority 10 (as recommended), will not be
		 * loaded in time for their includes() method to fire automatically.
		 *
		 * For this reason, it is recommended that your plugin has its own
		 * method or function for requiring necessary files. If you must use
		 * this method, you will have to call it manually in your constructor
		 * class, ie
		 *   $this->includes();
		 *
		 * Note that when you pass an array value like 'actions' to includes,
		 * it looks for the following three files (assuming your component is
		 * called 'my_component'):
		 *   - ./actions
		 *   - ./bp-my_component/actions
		 *   - ./bp-my_component/bp-my_component-actions.php
		 *
		 * @since 1.5.0
		 *
		 * @param array $includes An array of file names, or file name chunks,
		 *                        to be parsed and then included.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Components should include files here only on specific pages using
		 * conditionals such as {@link bp_is_current_component()}. Intentionally left
		 * empty.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Set up the actions.
		 *
		 * @since 1.5.0
		 */
		public function setup_actions()
		{
		}
		/**
		 * Set up the canonical URL stack for this component.
		 *
		 * @since 2.1.0
		 */
		public function setup_canonical_stack()
		{
		}
		/**
		 * Registers nav items globalizing them into `BP_Component::$main_nav` & `BP_Component::$sub_nav` properties.
		 *
		 * @since 12.0.0
		 *
		 * @param array $main_nav Optional. Passed directly to bp_core_new_nav_item().
		 *                        See that function for a description.
		 * @param array $sub_nav  Optional. Multidimensional array, each item in
		 *                        which is passed to bp_core_new_subnav_item(). See that
		 *                        function for a description.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up component navigation.
		 *
		 * @since 1.5.0
		 * @since 12.0.0 Uses the registered navigations to generate it.
		 *
		 * @param array $main_nav Optional. Passed directly to bp_core_new_nav_item().
		 *                        See that function for a description.
		 * @param array $sub_nav  Optional. Multidimensional array, each item in
		 *                        which is passed to bp_core_new_subnav_item(). See that
		 *                        function for a description.
		 */
		public function setup_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up the component entries in the WordPress Admin Bar.
		 *
		 * @since 1.5.0
		 *
		 * @see WP_Admin_Bar::add_menu() for a description of the syntax
		 *      required by each item in the $wp_admin_nav parameter array.
		 *
		 * @global WP_Admin_Bar $wp_admin_bar WordPress object implementing a Toolbar API.
		 *
		 * @param array $wp_admin_nav An array of nav item arguments. Each item in this parameter
		 *                            array is passed to {@link WP_Admin_Bar::add_menu()}.
		 *                            See that method for a description of the required syntax for
		 *                            each item.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Set up the component title.
		 *
		 * @since 1.5.0
		 */
		public function setup_title()
		{
		}
		/**
		 * Setup component-specific cache groups.
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Register global tables for the component, so that it may use WordPress's database API.
		 *
		 * @since 2.0.0
		 *
		 * @param array $tables Table names to register.
		 */
		public function register_global_tables($tables = array())
		{
		}
		/**
		 * Register component metadata tables.
		 *
		 * Metadata tables are registered in the $wpdb global, for
		 * compatibility with the WordPress metadata API.
		 *
		 * @since 2.0.0
		 *
		 * @param array $tables Table names to register.
		 */
		public function register_meta_tables($tables = array())
		{
		}
		/**
		 * Set up the component post types.
		 *
		 * @since 1.5.0
		 */
		public function register_post_types()
		{
		}
		/**
		 * Set up the component post statuses.
		 *
		 * @since 12.0.0
		 */
		public function register_post_statuses()
		{
		}
		/**
		 * Register component-specific taxonomies.
		 *
		 * @since 1.5.0
		 */
		public function register_taxonomies()
		{
		}
		/**
		 * Add Component's additional rewrite tags.
		 *
		 * @since 1.5.0
		 * @since 12.0.0 Adds the `$rewrite_tags` parameter.
		 *
		 * @param array $rewrite_tags Array of arguments list used to add WordPress rewrite tags.
		 *                            Each argument key needs to match one of `$this->rewrite_ids` keys.
		 */
		public function add_rewrite_tags($rewrite_tags = array())
		{
		}
		/**
		 * Add Component's additional rewrite rules.
		 *
		 * @since 1.9.0
		 * @since 12.0.0 Adds the `$rewrite_rules` parameter.
		 *
		 * @param array $rewrite_rules {
		 *     Array of associative arrays of arguments list used to add WordPress rewrite rules.
		 *     Each associative array needs to include the following keys.
		 *
		 *     @type string $regex    Regular expression to match request against. Required.
		 *     @type string $query    The corresponding query vars for this rewrite rule. Required.
		 *     @type int    $order    The insertion order for the rewrite rule. Required.
		 *     @type string $priority The Priority of the new rule. Accepts 'top' or 'bottom'. Optional.
		 *                            Default 'top'.
		 * }
		 */
		public function add_rewrite_rules($rewrite_rules = array())
		{
		}
		/**
		 * Add Component's permalink structures.
		 *
		 * @since 1.9.0
		 * @since 12.0.0 Adds the `$permastructs` parameter.
		 *
		 * @param array $permastructs {
		 *      Array of associative arrays of arguments list used to register WordPress additional permalink structures.
		 *      Each array enty is keyed with the permalink structure.
		 *      Each associative array needs to include the following keys.
		 *
		 *      @type string $permastruct The permalink structure. Required.
		 *      @type array  $args        The permalink structure arguments. Optional.
		 * }
		 */
		public function add_permastructs($permastructs = array())
		{
		}
		/**
		 * Allow components to parse the main query.
		 *
		 * @since 1.9.0
		 *
		 * @param object $query The main WP_Query.
		 */
		public function parse_query($query)
		{
		}
		/**
		 * Make sure to avoid querying for regular posts when displaying a BuddyPress page.
		 *
		 * @since 12.0.0
		 *
		 * @param  null     $posts A null value to use the regular WP Query.
		 * @param  WP_Query $query The WP Query object.
		 * @return null|array Null if not displaying a BuddyPress page.
		 *                    An array containing the BuddyPress directory page otherwise.
		 */
		public function pre_query($posts = \null, $query = \null)
		{
		}
		/**
		 * Generate any additional rewrite rules.
		 *
		 * @since 1.5.0
		 */
		public function generate_rewrite_rules()
		{
		}
		/**
		 * Init the BP REST API.
		 *
		 * @since 5.0.0
		 *
		 * @param array $controllers The list of BP REST controllers to load.
		 */
		public function rest_api_init($controllers = array())
		{
		}
		/**
		 * Register the BP Blocks.
		 *
		 * @since 6.0.0
		 *
		 * @see `BP_Block->construct()` for a full description of a BP Block arguments.
		 *
		 * @param array $blocks The list of BP Blocks to register.
		 */
		public function blocks_init($blocks = array())
		{
		}
		/**
		 * Add component's directory states.
		 *
		 * @since 10.0.0
		 * @deprecated 12.0.0
		 *
		 * @param string[] $states An array of post display states.
		 * @return array The component's directory states.
		 */
		public function admin_directory_states($states = array())
		{
		}
	}
	/**
	 * Creates our Blogs component.
	 *
	 * @since 1.5.0
	 */
	#[\AllowDynamicProperties]
	class BP_Blogs_Component extends \BP_Component
	{
		/**
		 * Start the blogs component creation process.
		 *
		 * @since 1.5.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set up global settings for the blogs component.
		 *
		 * The BP_BLOGS_SLUG constant is deprecated.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_globals() for description of parameters.
		 *
		 * @param array $args See {@link BP_Component::setup_globals()}.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Include bp-blogs files.
		 *
		 * @see BP_Component::includes() for description of parameters.
		 *
		 * @param array $includes See {@link BP_Component::includes()}.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Only load up certain code when on specific pages.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @see `BP_Component::register_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up component navigation.
		 *
		 * @since 1.5.0
		 * @since 12.0.0 Used to customize the main navigation name.
		 *
		 * @see `BP_Component::setup_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 */
		public function setup_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up bp-blogs integration with the WordPress admin bar.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_admin_bar() for a description of arguments.
		 *
		 * @param array $wp_admin_nav See BP_Component::setup_admin_bar()
		 *                            for description.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Set up the title for pages and <title>.
		 */
		public function setup_title()
		{
		}
		/**
		 * Setup cache groups
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Add the Blog Create rewrite tags.
		 *
		 * @since 12.0.0
		 *
		 * @param array $rewrite_tags Optional. See BP_Component::add_rewrite_tags() for
		 *                            description.
		 */
		public function add_rewrite_tags($rewrite_tags = array())
		{
		}
		/**
		 * Add the Registration and Activation rewrite rules.
		 *
		 * @since 12.0.0
		 *
		 * @param array $rewrite_rules Optional. See BP_Component::add_rewrite_rules() for
		 *                             description.
		 */
		public function add_rewrite_rules($rewrite_rules = array())
		{
		}
		/**
		 * Parse the WP_Query and eventually display the component's directory or single item.
		 *
		 * @since 12.0.0
		 *
		 * @param WP_Query $query Required. See BP_Component::parse_query() for
		 *                        description.
		 */
		public function parse_query($query)
		{
		}
		/**
		 * Init the BP REST API.
		 *
		 * @since 6.0.0
		 *
		 * @param array $controllers Optional. See BP_Component::rest_api_init() for
		 *                           description.
		 */
		public function rest_api_init($controllers = array())
		{
		}
		/**
		 * Register the BP Blogs Blocks.
		 *
		 * @since 9.0.0
		 * @since 12.0.0 Use the WP Blocks API v2.
		 *
		 * @param array $blocks Optional. See BP_Component::blocks_init() for
		 *                      description.
		 */
		public function blocks_init($blocks = array())
		{
		}
	}
	/**
	 * List table class for signups network admin page.
	 *
	 * @since 2.0.0
	 */
	class BP_Members_MS_List_Table extends \WP_MS_Users_List_Table
	{
		/**
		 * Signup counts.
		 *
		 * @since 2.0.0
		 *
		 * @var int
		 */
		public $signup_counts = 0;
		/**
		 * Signup profile fields.
		 *
		 * @since 10.0.0
		 *
		 * @var array
		 */
		public $signup_field_labels = array();
		/**
		 * Constructor.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set up items for display in the list table.
		 *
		 * Handles filtering of data, sorting, pagination, and any other data
		 * manipulation required prior to rendering.
		 *
		 * @since 2.0.0
		 *
		 * @global string $usersearch The users search terms.
		 * @global string $mode       The display mode.
		 */
		public function prepare_items()
		{
		}
		/**
		 * Display the users screen views
		 *
		 * @since 2.5.0
		 *
		 * @global string $role The name of role the users screens is filtered by
		 */
		public function views()
		{
		}
		/**
		 * Specific signups columns.
		 *
		 * @since 2.0.0
		 *
		 * @return array
		 */
		public function get_columns()
		{
		}
		/**
		 * Specific bulk actions for signups.
		 *
		 * @since 2.0.0
		 */
		public function get_bulk_actions()
		{
		}
		/**
		 * The text shown when no items are found.
		 *
		 * Nice job, clean sheet!
		 *
		 * @since 2.0.0
		 */
		public function no_items()
		{
		}
		/**
		 * The columns signups can be reordered with.
		 *
		 * @since 2.0.0
		 */
		public function get_sortable_columns()
		{
		}
		/**
		 * Display signups rows.
		 *
		 * @since 2.0.0
		 */
		public function display_rows()
		{
		}
		/**
		 * Display a signup row.
		 *
		 * @since 2.0.0
		 *
		 * @see WP_List_Table::single_row() for explanation of params.
		 *
		 * @param object|null $signup_object Signup user object.
		 * @param string      $style         Styles for the row.
		 */
		public function single_row($signup_object = \null, $style = '')
		{
		}
		/**
		 * Prevents regular users row actions to be output.
		 *
		 * @since 2.4.0
		 *
		 * @param object|null $signup_object Signup being acted upon.
		 * @param string      $column_name   Current column name.
		 * @param string      $primary       Primary column name.
		 * @return string
		 */
		protected function handle_row_actions($signup_object = \null, $column_name = '', $primary = '')
		{
		}
		/**
		 * Markup for the checkbox used to select items for bulk actions.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_cb($signup_object = \null)
		{
		}
		/**
		 * The row actions (delete/activate/email).
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_username($signup_object = \null)
		{
		}
		/**
		 * Display user name, if any.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_name($signup_object = \null)
		{
		}
		/**
		 * Display user email.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_email($signup_object = \null)
		{
		}
		/**
		 * Display registration date.
		 *
		 * @since 2.0.0
		 *
		 * @global string $mode The display mode.
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_registered($signup_object = \null)
		{
		}
		/**
		 * Display the last time an activation email has been sent.
		 *
		 * @since 2.0.0
		 *
		 * @global string $mode The display mode.
		 *
		 * @param object|null $signup_object Signup object instance.
		 */
		public function column_date_sent($signup_object = \null)
		{
		}
		/**
		 * Display number of time an activation email has been sent.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object Signup object instance.
		 */
		public function column_count_sent($signup_object = \null)
		{
		}
		/**
		 * Allow plugins to add their custom column.
		 *
		 * @since 2.1.0
		 *
		 * @param object|null $signup_object The signup data object.
		 * @param string      $column_name   The column name.
		 * @return string
		 */
		function column_default($signup_object = \null, $column_name = '')
		{
		}
	}
	/**
	 * The main theme compat class for BuddyPress Registration.
	 *
	 * This class sets up the necessary theme compatibility actions to safely output
	 * registration template parts to the_title and the_content areas of a theme.
	 *
	 * @since 1.7.0
	 */
	class BP_Registration_Theme_Compat
	{
		/**
		 * Setup the groups component theme compatibility.
		 *
		 * @since 1.7.0
		 */
		public function __construct()
		{
		}
		/**
		 * Are we looking at either the registration or activation pages?
		 *
		 * @since 1.7.0
		 */
		public function is_registration()
		{
		}
		/** Template ***********************************************************/
		/**
		 * Add template hierarchy to theme compat for registration/activation pages.
		 *
		 * This is to mirror how WordPress has
		 * {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param string $templates The templates from bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function template_hierarchy($templates)
		{
		}
		/**
		 * Update the global $post with dummy data.
		 *
		 * @since 1.7.0
		 */
		public function dummy_post()
		{
		}
		/**
		 * Filter the_content with either the register or activate templates.
		 *
		 * @since 1.7.0
		 */
		public function dummy_content()
		{
		}
	}
	/**
	 * The main membership invitations template loop class.
	 *
	 * Responsible for loading a group of membership invitations into a loop for display.
	 *
	 * @since 8.0.0
	 */
	class BP_Members_Invitations_Template
	{
		/**
		 * The loop iterator.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $current_invitation = -1;
		/**
		 * The number of invitations returned by the paged query.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $current_invitation_count;
		/**
		 * Total number of invitations matching the query.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $total_invitation_count;
		/**
		 * Array of network invitations located by the query.
		 *
		 * @since 8.0.0
		 * @var array
		 */
		public $invitations;
		/**
		 * The invitation object currently being iterated on.
		 *
		 * @since 8.0.0
		 * @var object
		 */
		public $invitation;
		/**
		 * A flag for whether the loop is currently being iterated.
		 *
		 * @since 8.0.0
		 * @var bool
		 */
		public $in_the_loop;
		/**
		 * The ID of the user to whom the displayed invitations were sent.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $user_id;
		/**
		 * The ID of the user to whom the displayed invitations belong.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $inviter_id;
		/**
		 * The page number being requested.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $pag_page;
		/**
		 * The $_GET argument used in URLs for determining pagination.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $pag_arg;
		/**
		 * The number of items to display per page of results.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $pag_num;
		/**
		 * An HTML string containing pagination links.
		 *
		 * @since 8.0.0
		 * @var string
		 */
		public $pag_links;
		/**
		 * A string to match against.
		 *
		 * @since 8.0.0
		 * @var string
		 */
		public $search_terms;
		/**
		 * A database column to order the results by.
		 *
		 * @since 8.0.0
		 * @var string
		 */
		public $order_by;
		/**
		 * The direction to sort the results (ASC or DESC).
		 *
		 * @since 8.0.0
		 * @var string
		 */
		public $sort_order;
		/**
		 * Array of variables used in this invitation query.
		 *
		 * @since 8.0.0
		 * @var array
		 */
		public $query_vars;
		/**
		 * Constructor method.
		 *
		 * @see bp_has_members_invitations() For information on the array format.
		 *
		 * @since 8.0.0
		 *
		 * @param array $args {
		 *     An array of arguments. See {@link bp_has_members_invitations()}
		 *     for more details.
		 * }
		 */
		public function __construct($args = array())
		{
		}
		/**
		 * Whether there are invitations available in the loop.
		 *
		 * @since 8.0.0
		 *
		 * @see bp_has_members_invitations()
		 *
		 * @return bool True if there are items in the loop, otherwise false.
		 */
		public function has_invitations()
		{
		}
		/**
		 * Set up the next invitation and iterate index.
		 *
		 * @since 8.0.0
		 *
		 * @return object The next invitation to iterate over.
		 */
		public function next_invitation()
		{
		}
		/**
		 * Rewind the blogs and reset blog index.
		 *
		 * @since 8.0.0
		 */
		public function rewind_invitations()
		{
		}
		/**
		 * Whether there are invitations left in the loop to iterate over.
		 *
		 * This method is used by {@link bp_members_invitations()} as part of the
		 * while loop that controls iteration inside the invitations loop, eg:
		 *     while ( bp_members_invitations() ) { ...
		 *
		 * @since 8.0.0
		 *
		 * @see bp_members_invitations()
		 *
		 * @return bool True if there are more invitations to show,
		 *              otherwise false.
		 */
		public function invitations()
		{
		}
		/**
		 * Set up the current invitation inside the loop.
		 *
		 * Used by {@link bp_the_invitation()} to set up the current
		 * invitation data while looping, so that template tags used during
		 * that iteration make reference to the current invitation.
		 *
		 * @since 8.0.0
		 *
		 * @see bp_the_invitation()
		 */
		public function the_invitation()
		{
		}
	}
	/**
	 * List table class for signups admin page.
	 *
	 * @since 2.0.0
	 */
	class BP_Members_List_Table extends \WP_Users_List_Table
	{
		/**
		 * Signup counts.
		 *
		 * @since 2.0.0
		 *
		 * @var int
		 */
		public $signup_counts = 0;
		/**
		 * Signup profile fields.
		 *
		 * @since 10.0.0
		 *
		 * @var array
		 */
		public $signup_field_labels = array();
		/**
		 * Constructor.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set up items for display in the list table.
		 *
		 * Handles filtering of data, sorting, pagination, and any other data
		 * manipulation required prior to rendering.
		 *
		 * @since 2.0.0
		 *
		 * @global string $usersearch The users search terms.
		 */
		public function prepare_items()
		{
		}
		/**
		 * Display the users screen views
		 *
		 * @since 2.5.0
		 *
		 * @global string $role The name of role the users screens is filtered by.
		 */
		public function views()
		{
		}
		/**
		 * Get rid of the extra nav.
		 *
		 * WP_Users_List_Table will add an extra nav to change user's role.
		 * As we're dealing with signups, we don't need this.
		 *
		 * @since 2.0.0
		 *
		 * @param array $which Current table nav item.
		 */
		public function extra_tablenav($which)
		{
		}
		/**
		 * Specific signups columns.
		 *
		 * @since 2.0.0
		 *
		 * @return array
		 */
		public function get_columns()
		{
		}
		/**
		 * Specific bulk actions for signups.
		 *
		 * @since 2.0.0
		 */
		public function get_bulk_actions()
		{
		}
		/**
		 * The text shown when no items are found.
		 *
		 * Nice job, clean sheet!
		 *
		 * @since 2.0.0
		 */
		public function no_items()
		{
		}
		/**
		 * The columns signups can be reordered with.
		 *
		 * @since 2.0.0
		 */
		public function get_sortable_columns()
		{
		}
		/**
		 * Display signups rows.
		 *
		 * @since 2.0.0
		 */
		public function display_rows()
		{
		}
		/**
		 * Display a signup row.
		 *
		 * @since 2.0.0
		 *
		 * @see WP_List_Table::single_row() for explanation of params.
		 *
		 * @param object|null $signup_object Signup user object.
		 * @param string      $style         Styles for the row.
		 * @param string      $role          Role to be assigned to user.
		 * @param int         $numposts      Numper of posts.
		 */
		public function single_row($signup_object = \null, $style = '', $role = '', $numposts = 0)
		{
		}
		/**
		 * Markup for the checkbox used to select items for bulk actions.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_cb($signup_object = \null)
		{
		}
		/**
		 * The row actions (delete/activate/email).
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_username($signup_object = \null)
		{
		}
		/**
		 * Display user name, if any.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_name($signup_object = \null)
		{
		}
		/**
		 * Display user email.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_email($signup_object = \null)
		{
		}
		/**
		 * Display registration date.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_registered($signup_object = \null)
		{
		}
		/**
		 * Display the last time an activation email has been sent.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object The signup data object.
		 */
		public function column_date_sent($signup_object = \null)
		{
		}
		/**
		 * Display number of times an activation email has been sent.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $signup_object Signup object instance.
		 */
		public function column_count_sent($signup_object = \null)
		{
		}
		/**
		 * Allow plugins to add their custom column.
		 *
		 * @since 2.1.0
		 *
		 * @param object|null $signup_object The signup data object.
		 * @param string      $column_name   The column name.
		 * @return string
		 */
		function column_default($signup_object = \null, $column_name = '')
		{
		}
	}
	/**
	 * Members Widget.
	 *
	 * @since 1.0.3
	 * @deprecated 12.0.0
	 */
	class BP_Core_Members_Widget
	{
		/**
		 * Constructor method.
		 *
		 * @since 1.5.0
		 * @since 9.0.0 Adds the `show_instance_in_rest` property to Widget options.
		 * @deprecated 12.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Enqueue scripts.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		public function enqueue_scripts()
		{
		}
		/**
		 * Display the Members widget.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @see WP_Widget::widget() for description of parameters.
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Widget settings, as saved by the user.
		 */
		public function widget($args, $instance)
		{
		}
		/**
		 * Update the Members widget options.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @param array $new_instance The new instance options.
		 * @param array $old_instance The old instance options.
		 */
		public function update($new_instance, $old_instance)
		{
		}
		/**
		 * Output the Members widget options form.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @param array $instance Widget instance settings.
		 */
		public function form($instance)
		{
		}
		/**
		 * Merge the widget settings into defaults array.
		 *
		 * @since 2.3.0
		 * @deprecated 12.0.0
		 *
		 * @param array $instance Widget instance settings.
		 */
		public function parse_settings($instance = array())
		{
		}
	}
	/**
	 * BuddyPress Members endpoints.
	 *
	 * /members/
	 * /members/{id}
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Members_Endpoint extends \WP_REST_Users_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Registers the routes for the objects of the controller.
		 *
		 * @since 7.0.0
		 *
		 * @see register_rest_route()
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve users.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Checks if a given request has access to get all users.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Retrieves a single member.
		 *
		 * @since 7.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error Response object on success, or WP_Error object on failure.
		 */
		public function get_item($request)
		{
		}
		/**
		 * Checks if a given request has access to read a user.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Checks if a given request has access create members.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Check if a given request has access to update a member.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Check if a given request has access to delete a member.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Checks if a given request has access to delete the current user.
		 *
		 * @since 5.0.0
		 * @since 0.7.0 Do implement this method.
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error True if the request has access to delete the item, WP_Error object otherwise.
		 */
		public function delete_current_item_permissions_check($request)
		{
		}
		/**
		 * Deletes the current user.
		 *
		 * @since 5.0.0
		 * @since 0.7.0 Do implement this method.
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error Response object on success, or WP_Error object on failure.
		 */
		public function delete_current_item($request)
		{
		}
		/**
		 * Prepares a single user output for response.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_User         $user    User object.
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($user, $request)
		{
		}
		/**
		 * Prepares links for the user request.
		 *
		 * @since 11.0.0
		 *
		 * @param WP_User $user      User object.
		 * @param array   $user_data User data.
		 * @return array
		 */
		protected function prepare_links($user, $user_data = array())
		{
		}
		/**
		 * Method to facilitate fetching of user data.
		 *
		 * This was abstracted to be used in other BuddyPress endpoints.
		 *
		 * @since 5.0.0
		 * @since 7.0.0 Add the `$request` parameter.
		 *
		 * @param WP_User         $user    User object.
		 * @param string          $context The context of the request. Defaults to 'view'.
		 * @param WP_REST_Request $request Full details about the request.
		 * @return array
		 */
		public function user_data($user, $context, $request)
		{
		}
		/**
		 * Prepares a single user for creation or update.
		 *
		 * @todo Improve sanitization and schema verification.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Request object.
		 * @return stdClass
		 */
		protected function prepare_item_for_database($request)
		{
		}
		/**
		 * Get XProfile info from the user.
		 *
		 * @since 5.0.0
		 *
		 * @param  int $user_id User ID.
		 * @return array
		 */
		protected function xprofile_data($user_id)
		{
		}
		/**
		 * Can user manage (delete/update) a member?
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_User $user User object.
		 * @param  string  $action The action to perform (update or delete).
		 * @return bool
		 */
		protected function can_manage_member($user, $action = 'delete')
		{
		}
		/**
		 * Updates the values of additional fields added to a data object.
		 *
		 * This function makes sure updating the field value thanks to the `id` property of
		 * the created/updated object type is consistent accross BuddyPress components.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_User         $user    The WordPress user object.
		 * @param WP_REST_Request $request Full details about the request.
		 * @return bool|WP_Error True on success, WP_Error object if a field cannot be updated.
		 */
		protected function update_additional_fields_for_object($user, $request)
		{
		}
		/**
		 * Make sure to retrieve the needed arguments for the endpoint CREATABLE method.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the members schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for collections.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * Member Avatar endpoints.
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Attachments_Member_Avatar_Endpoint extends \WP_REST_Controller
	{
		use \BP_REST_Attachments;
		/**
		 * BP_Attachment_Avatar Instance.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_Attachment_Avatar
		 */
		protected $avatar_instance;
		/**
		 * Member object.
		 *
		 * @since 5.0.0
		 *
		 * @var WP_User
		 */
		protected $user;
		/**
		 * Member object type.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		protected $object = 'user';
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Fetch an existing member avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Checks if a given request has access to get a member avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Upload a member avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to upload a member avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Delete an existing member avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Checks if a given request has access to delete member avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares avatar data to return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param object          $avatar  Avatar object.
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($avatar, $request)
		{
		}
		/**
		 * Get the member avatar schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for the `get_item`.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_collection_params()
		{
		}
	}
	/**
	 * List table class for Invitations admin page.
	 *
	 * @since 8.0.0
	 */
	class BP_Members_Invitations_List_Table extends \WP_Users_List_Table
	{
		/**
		 * The type of view currently being displayed.
		 *
		 * E.g. "All", "Pending", "Sent", "Unsent"...
		 *
		 * @since 8.0.0
		 * @var string
		 */
		public $active_filters = array();
		/**
		 * Invitation counts.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $total_items = 0;
		/**
		 * Constructor.
		 *
		 * @since 8.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set up items for display in the list table.
		 *
		 * Handles filtering of data, sorting, pagination, and any other data
		 * manipulation required prior to rendering.
		 *
		 * @since 8.0.0
		 */
		public function prepare_items()
		{
		}
		/**
		 * Gets the name of the default primary column.
		 *
		 * @since 10.1.0
		 *
		 * @return string Name of the default primary column, in this case, 'invitee_email'.
		 */
		protected function get_default_primary_column_name()
		{
		}
		/**
		 * Get the list of views available on this table (e.g. "all", "public").
		 *
		 * @since 8.0.0
		 */
		public function views()
		{
		}
		/**
		 * Get rid of the extra nav.
		 *
		 * WP_Users_List_Table will add an extra nav to change user's role.
		 * As we're dealing with invitations, we don't need this.
		 *
		 * @since 8.0.0
		 *
		 * @param array $which Current table nav item.
		 */
		public function extra_tablenav($which)
		{
		}
		/**
		 * Specific signups columns.
		 *
		 * @since 8.0.0
		 *
		 * @return array
		 */
		public function get_columns()
		{
		}
		/**
		 * Specific bulk actions for signups.
		 *
		 * @since 8.0.0
		 */
		public function get_bulk_actions()
		{
		}
		/**
		 * The text shown when no items are found.
		 *
		 * Nice job, clean sheet!
		 *
		 * @since 8.0.0
		 */
		public function no_items()
		{
		}
		/**
		 * The columns invitations can be reordered by.
		 *
		 * @since 8.0.0
		 */
		public function get_sortable_columns()
		{
		}
		/**
		 * Display invitation rows.
		 *
		 * @since 8.0.0
		 */
		public function display_rows()
		{
		}
		/**
		 * Display an invitation row.
		 *
		 * @since 8.0.0
		 *
		 * @see WP_List_Table::single_row() for explanation of params.
		 *
		 * @param BP_Invitation $invite   BP_Invitation object.
		 * @param string        $style    Styles for the row.
		 * @param string        $role     Role to be assigned to user.
		 * @param int           $numposts Number of posts.
		 */
		public function single_row($invite = \null, $style = '', $role = '', $numposts = 0)
		{
		}
		/**
		 * Markup for the checkbox used to select items for bulk actions.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Invitation $invite BP_Invitation object.
		 */
		public function column_cb($invite = \null)
		{
		}
		/**
		 * Markup for the checkbox used to select items for bulk actions.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Invitation $invite BP_Invitation object.
		 */
		public function column_invitee_email($invite = \null)
		{
		}
		/**
		 * Display invited user's email address.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Invitation $invite BP_Invitation object.
		 */
		public function column_email($invite = \null)
		{
		}
		/**
		 * The inviter.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Invitation $invite BP_Invitation object.
		 */
		public function column_username($invite = \null)
		{
		}
		/**
		 * Display invitation date.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Invitation $invite BP_Invitation object.
		 */
		public function column_inviter_registered_date($invite = \null)
		{
		}
		/**
		 * Display invitation date.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Invitation $invite BP_Invitation object.
		 */
		public function column_invitation_date_modified($invite = \null)
		{
		}
		/**
		 * Display invitation date.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Invitation $invite BP_Invitation object.
		 */
		public function column_invitation_sent($invite = \null)
		{
		}
		/**
		 * Display invitation acceptance status.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Invitation $invite BP_Invitation object.
		 */
		public function column_invitation_accepted($invite = \null)
		{
		}
		/**
		 * Allow plugins to add their custom column.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Invitation $invite      BP_Invitation object.
		 * @param string        $column_name The column name.
		 * @return string
		 */
		function column_default($invite = \null, $column_name = '')
		{
		}
	}
	/**
	 * Defines the BuddyPress Members Component.
	 *
	 * @since 1.5.0
	 */
	#[\AllowDynamicProperties]
	class BP_Members_Component extends \BP_Component
	{
		/**
		 * Member types.
		 *
		 * @see bp_register_member_type()
		 *
		 * @since 2.2.0
		 * @var array
		 */
		public $types = array();
		/**
		 * Main nav arguments.
		 *
		 * @since 2.2.0
		 * @var array
		 */
		public $main_nav = array();
		/**
		 * Main nav arguments.
		 *
		 * @since 2.2.0
		 * @var array
		 */
		public $sub_nav = array();
		/**
		 * Nav for the members component.
		 *
		 * @since 2.2.0
		 * @var BP_Core_Nav
		 */
		public $nav;
		/**
		 * Member admin.
		 *
		 * @since 2.0.0
		 * @var BP_Members_Admin
		 */
		public $admin;
		/**
		 * Invitations.
		 *
		 * @var stdClass
		 */
		public $invitations;
		/**
		 * Start the members component creation process.
		 *
		 * @since 1.5.0
		 */
		public function __construct()
		{
		}
		/**
		 * Include bp-members files.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::includes() for description of parameters.
		 *
		 * @param array $includes See {@link BP_Component::includes()}.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Only load up certain code when on specific pages.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Set up the component actions.
		 *
		 * @since 12.0.0
		 */
		public function setup_actions()
		{
		}
		/**
		 * Set up additional globals for the component.
		 *
		 * @since 10.0.0
		 */
		public function setup_additional_globals()
		{
		}
		/**
		 * Set up bp-members global settings.
		 *
		 * The BP_MEMBERS_SLUG constant is deprecated.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_globals() for description of parameters.
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param array $args See {@link BP_Component::setup_globals()}.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Set up canonical stack for this component.
		 *
		 * @since 2.1.0
		 */
		public function setup_canonical_stack()
		{
		}
		/**
		 * Get the Avatar and Cover image subnavs.
		 *
		 * @since 6.0.0
		 * @deprecated 12.0.0
		 *
		 * @return array The Avatar and Cover image subnavs.
		 */
		public function get_avatar_cover_image_subnavs()
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @see `BP_Component::register_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up a profile nav in case the xProfile
		 * component is not active and a front template is
		 * used.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		public function setup_profile_nav()
		{
		}
		/**
		 * Set up the xProfile nav.
		 *
		 * @since 6.0.0
		 * @deprecated 12.0.0
		 */
		public function setup_xprofile_nav()
		{
		}
		/**
		 * Get the Avatar and Cover image admin navs.
		 *
		 * @since 6.0.0
		 *
		 * @param  string $admin_bar_menu_id The Admin bar menu ID to attach sub items to.
		 * @return array                     The Avatar and Cover image admin navs.
		 */
		public function get_avatar_cover_image_admin_navs($admin_bar_menu_id = '')
		{
		}
		/**
		 * Set up the Admin Bar.
		 *
		 * @since 6.0.0
		 *
		 * @param array $wp_admin_nav Admin Bar items.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Adds "Profile > Change Avatar" & "Profile > Change Cover Image" subnav item
		 * under the "Profile" adminbar menu.
		 *
		 * @since 6.0.0
		 *
		 * @param array $wp_admin_nav The Profile adminbar nav array.
		 * @return array
		 */
		public function setup_xprofile_admin_nav($wp_admin_nav)
		{
		}
		/**
		 * Set up the title for pages and <title>.
		 *
		 * @since 1.5.0
		 */
		public function setup_title()
		{
		}
		/**
		 * Setup cache groups.
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Adds the Members directory type, Registration and Activation rewrite tags.
		 *
		 * @since 12.0.0
		 *
		 * @param array $rewrite_tags Optional. See BP_Component::add_rewrite_tags() for
		 *                            description.
		 */
		public function add_rewrite_tags($rewrite_tags = array())
		{
		}
		/**
		 * Adds the Registration and Activation rewrite rules.
		 *
		 * @since 12.0.0
		 *
		 * @param array $rewrite_rules Optional. See BP_Component::add_rewrite_rules() for
		 *                             description.
		 */
		public function add_rewrite_rules($rewrite_rules = array())
		{
		}
		/**
		 * Adds the Registration and Activation permastructs.
		 *
		 * @since 12.0.0
		 *
		 * @param array $permastructs Optional. See BP_Component::add_permastructs() for
		 *                            description.
		 */
		public function add_permastructs($permastructs = array())
		{
		}
		/**
		 * Parse the WP_Query and eventually display the component's directory or single item.
		 *
		 * @since 12.0.0
		 *
		 * @param WP_Query $query Required. See BP_Component::parse_query() for
		 *                        description.
		 */
		public function parse_query($query)
		{
		}
		/**
		 * Check the parsed query is consistent with Members navigation.
		 *
		 * As the members’ component pages need a valid screen function to load the right BP Template,
		 * we need to make sure the current single item action exists inside the Members navigation and
		 * that the corresponding screen function is a valid callback.
		 *
		 * @since 12.0.0
		 */
		public function check_parsed_query()
		{
		}
		/**
		 * Init the BP REST API.
		 *
		 * @since 5.0.0
		 * @since 6.0.0 Adds the Member Cover and Signup REST endpoints.
		 * @since 9.0.0 Moves the `BP_REST_Components_Endpoint` controller in `BP_Core` component.
		 *
		 * @param array $controllers Optional. See BP_Component::rest_api_init() for
		 *                           description.
		 */
		public function rest_api_init($controllers = array())
		{
		}
		/**
		 * Register the BP Members Blocks.
		 *
		 * @since 6.0.0
		 * @since 12.0.0 Use the WP Blocks API v2.
		 *
		 * @param array $blocks Optional. See BP_Component::blocks_init() for
		 *                      description.
		 */
		public function blocks_init($blocks = array())
		{
		}
	}
	/**
	 * Load Members admin area.
	 *
	 * @since 2.0.0
	 */
	class BP_Members_Admin
	{
		/** Directory *************************************************************/
		/**
		 * Path to the BP Members Admin directory.
		 *
		 * @var string $admin_dir
		 */
		public $admin_dir = '';
		/** URLs ******************************************************************/
		/**
		 * URL to the BP Members Admin directory.
		 *
		 * @var string $admin_url
		 */
		public $admin_url = '';
		/**
		 * URL to the BP Members Admin CSS directory.
		 *
		 * @var string $css_url
		 */
		public $css_url = '';
		/**
		 * URL to the BP Members Admin JS directory.
		 *
		 * @var string
		 */
		public $js_url = '';
		/** Other *****************************************************************/
		/**
		 * Support forum link.
		 *
		 * @since 14.0.0
		 * @var string
		 */
		private $bp_forum = '';
		/**
		 * Redirect.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $redirect;
		/**
		 * Screen id for edit user's profile page.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $user_page = '';
		/**
		 * User capability.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $capability;
		/**
		 * Show Profile Screen id.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $user_profile;
		/**
		 * Current user ID.
		 *
		 * @since 2.0.0
		 * @var int
		 */
		public $current_user_id;
		/**
		 * User ID being edited.
		 *
		 * @since 2.0.0
		 * @var int
		 */
		public $user_id = 0;
		/**
		 * Is a member editing their own profile.
		 *
		 * @since 2.0.0
		 * @var bool
		 */
		public $is_self_profile = \false;
		/**
		 * The screen ids to load specific css for.
		 *
		 * @since 2.0.0
		 * @var array
		 */
		public $screen_id = array();
		/**
		 * The stats metabox default position.
		 *
		 * @since 2.0.0
		 * @var stdClass
		 */
		public $stats_metabox;
		/**
		 * Edit user's profile args.
		 *
		 * @since 2.0.0
		 * @var array
		 */
		public $edit_profile_args;
		/**
		 * Edit user's profile URL.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $edit_profile_url = '';
		/**
		 * Edit URL.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $edit_url = '';
		/**
		 * Users page.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $users_page = '';
		/**
		 * Signups page.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $signups_page = '';
		/**
		 * Users URL.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $users_url;
		/**
		 * Users screen.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $users_screen;
		/**
		 * Members' Invite Page.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $members_invites_page = '';
		/**
		 * Status of BuddyPress network.
		 *
		 * @since 2.0.0
		 * @var bool
		 */
		public $subsite_activated;
		/**
		 * Tools menu.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $tools_parent = 'tools.php';
		/**
		 * Constructor method.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set admin-related globals.
		 *
		 * @since 2.0.0
		 */
		private function setup_globals()
		{
		}
		/**
		 * Set admin-related actions and filters.
		 *
		 * @since 2.0.0
		 */
		private function setup_actions()
		{
		}
		/**
		 * Create registration pages when multisite user registration is turned on.
		 *
		 * @since 2.7.0
		 *
		 * @param string $option_name Current option name; value is always 'registration'.
		 * @param string $value
		 */
		public function multisite_registration_on($option_name, $value)
		{
		}
		/**
		 * Create registration pages when single site registration is turned on.
		 *
		 * @since 2.7.0
		 *
		 * @param string $old_value
		 * @param string $value
		 */
		public function single_site_registration_on($old_value, $value)
		{
		}
		/**
		 * Setup BP Members Admin.
		 *
		 * @since 2.0.0
		 *
		 * @return BP_Members_Admin|null
		 */
		public static function register_members_admin()
		{
		}
		/**
		 * Get the user ID.
		 *
		 * Look for $_GET['user_id']. If anything else, force the user ID to the
		 * current user's ID so they aren't left without a user to edit.
		 *
		 * @since 2.1.0
		 *
		 * @return int
		 */
		private function get_user_id()
		{
		}
		/**
		 * Can the current user edit the one displayed.
		 *
		 * Self profile editing / or bp_moderate check.
		 * This might be replaced by more granular capabilities
		 * in the future.
		 *
		 * @since 2.1.0
		 *
		 * @param int $user_id ID of the user being checked for edit ability.
		 *
		 * @return bool
		 */
		private function member_can_edit($user_id = 0)
		{
		}
		/**
		 * Get admin notice when saving a user or member profile.
		 *
		 * @since 2.1.0
		 *
		 * @return array
		 */
		private function get_user_notice()
		{
		}
		/**
		 * Create the /user/ admin Profile submenus for all members.
		 *
		 * @since 2.1.0
		 */
		public function user_profile_menu()
		{
		}
		/**
		 * Create the All Users / Profile > Edit Profile and All Users Signups submenus.
		 *
		 * @since 2.0.0
		 */
		public function admin_menus()
		{
		}
		/**
		 * Include the Members Invitations tab to the Admin tabs needing specific inline styles.
		 *
		 * @since 10.0.0
		 *
		 * @param array $submenu_pages The BP_Admin submenu pages passed by reference.
		 */
		public function set_submenu_page(&$submenu_pages)
		{
		}
		/**
		 * Highlight the Users menu if on Edit Profile and check if on the user's admin profile.
		 *
		 * @since 2.1.0
		 *
		 * @global string $submenu_file The name of the submenu file.
		 * @global string $parent_file  The name of the parent file.
		 */
		public function profile_admin_head()
		{
		}
		/**
		 * Remove the Edit Profile page.
		 *
		 * We add these pages in order to integrate with WP's Users panel, but
		 * we want them to show up as a row action of the WP panel, not as separate
		 * subnav items under the Users menu.
		 *
		 * @since 2.0.0
		 */
		public function admin_head()
		{
		}
		/** Community Profile *****************************************************/
		/**
		 * Add some specific styling to the Edit User and Edit User's Profile page.
		 *
		 * @since 2.0.0
		 */
		public function enqueue_scripts()
		{
		}
		/**
		 * Create the Profile navigation in Edit User & Edit Profile pages.
		 *
		 * @since 2.0.0
		 *
		 * @param object|null $user   User to create profile navigation for.
		 * @param string      $active Which profile to highlight.
		 * @return string|null
		 */
		public function profile_nav($user = \null, $active = 'WordPress')
		{
		}
		/**
		 * Set up the user's profile admin page.
		 *
		 * Loaded before the page is rendered, this function does all initial
		 * setup, including: processing form requests, registering contextual
		 * help, and setting up screen options.
		 *
		 * @since 2.0.0
		 * @since 6.0.0 The `delete_avatar` action is now managed into this method.
		 */
		public function user_admin_load()
		{
		}
		/**
		 * Display the user's profile.
		 *
		 * @since 2.0.0
		 */
		public function user_admin()
		{
		}
		/**
		 * Render the Status metabox for user's profile screen.
		 *
		 * Actions are:
		 * - Update profile fields if xProfile component is active
		 * - Spam/Unspam user
		 *
		 * @since 2.0.0
		 *
		 * @param WP_User|null $user The WP_User object to be edited.
		 */
		public function user_admin_status_metabox($user = \null)
		{
		}
		/**
		 * Render the fallback metabox in case a user has been marked as a spammer.
		 *
		 * @since 2.0.0
		 *
		 * @param WP_User|null $user The WP_User object to be edited.
		 */
		public function user_admin_spammer_metabox($user = \null)
		{
		}
		/**
		 * Render the Stats metabox to moderate inappropriate images.
		 *
		 * @since 2.0.0
		 *
		 * @param WP_User|null $user The WP_User object to be edited.
		 */
		public function user_admin_stats_metabox($user = \null)
		{
		}
		/**
		 * Render the Avatar metabox to moderate inappropriate images.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_User|null $user The WP_User object for the user being edited.
		 */
		public function user_admin_avatar_metabox($user = \null)
		{
		}
		/**
		 * Render the Member Type metabox.
		 *
		 * @since 2.2.0
		 *
		 * @param WP_User|null $user The WP_User object to be edited.
		 */
		public function user_admin_member_type_metabox($user = \null)
		{
		}
		/**
		 * Process changes from the Member Type metabox.
		 *
		 * @since 2.2.0
		 */
		public function process_member_type_update()
		{
		}
		/**
		 * Add a link to Profile in Users listing row actions.
		 *
		 * @since 2.0.0
		 *
		 * @param array|string $actions WordPress row actions (edit, delete).
		 * @param object|null  $user    The object for the user row.
		 * @return null|string|array Merged actions.
		 */
		public function row_actions($actions = '', $user = \null)
		{
		}
		/**
		 * Add a filter to edit profile url in WP Admin Bar.
		 *
		 * @since 2.1.0
		 */
		public function add_edit_profile_url_filter()
		{
		}
		/**
		 * Filter the profile url.
		 *
		 * @since 2.1.0
		 *
		 *
		 * @param string $profile_link Profile Link for admin bar.
		 * @param string $url          Profile URL.
		 * @param int    $user_id      User ID.
		 * @return string
		 */
		public function filter_adminbar_profile_link($profile_link = '', $url = '', $user_id = 0)
		{
		}
		/**
		 * Remove the filter to edit profile url in WP Admin Bar.
		 *
		 * @since 2.1.0
		 */
		public function remove_edit_profile_url_filter()
		{
		}
		/** Signups Management ****************************************************/
		/**
		 * Display the admin preferences about signups pagination.
		 *
		 * @since 2.0.0
		 *
		 * @param int    $value     Value for signup option.
		 * @param string $option    Value for the option key.
		 * @param int    $new_value Value for the saved option.
		 * @return int The pagination preferences.
		 */
		public function signup_screen_options($value = 0, $option = '', $new_value = 0)
		{
		}
		/**
		 * Make sure no signups will show in users list.
		 *
		 * This is needed to handle signups that may have not been activated
		 * before the 2.0.0 upgrade.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param WP_User_Query|null $query The users query.
		 * @return WP_User_Query|null The users query without the signups.
		 */
		public function remove_signups_from_user_query($query = \null)
		{
		}
		/**
		 * Filter the WP Users List Table views to include 'bp-signups'.
		 *
		 * @since 2.0.0
		 *
		 * @global string $role The name of the WP Role.
		 *
		 * @param array $views WP List Table views.
		 * @return array The views with the signup view added.
		 */
		public function signup_filter_view($views = array())
		{
		}
		/**
		 * Load the Signup WP Users List table.
		 *
		 * @since 2.0.0
		 *
		 * @param string $class    The name of the class to use.
		 * @param string $required The parent class.
		 * @return WP_List_Table|null The List table.
		 */
		public static function get_list_table_class($class = '', $required = '')
		{
		}
		/**
		 * Set up the signups admin page.
		 *
		 * Loaded before the page is rendered, this function does all initial
		 * setup, including: processing form requests, registering contextual
		 * help, and setting up screen options.
		 *
		 * @since 2.0.0
		 *
		 * @global object $bp_members_signup_list_table
		 */
		public function signups_admin_load()
		{
		}
		/**
		 * Display any activation errors.
		 *
		 * @since 2.0.0
		 */
		public function signups_display_errors()
		{
		}
		/**
		 * Get admin notice when viewing the sign-up page.
		 *
		 * @since 2.1.0
		 *
		 * @return array
		 */
		private function get_signup_notice()
		{
		}
		/**
		 * Signups admin page router.
		 *
		 * Depending on the context, display
		 * - the list of signups,
		 * - or the delete confirmation screen,
		 * - or the activate confirmation screen,
		 * - or the "resend" email confirmation screen.
		 *
		 * Also prepare the admin notices.
		 *
		 * @since 2.0.0
		 */
		public function signups_admin()
		{
		}
		/**
		 * This is the list of the Pending accounts (signups).
		 *
		 * @since 2.0.0
		 *
		 * @global string $plugin_page
		 * @global object $bp_members_signup_list_table
		 */
		public function signups_admin_index()
		{
		}
		/**
		 * This is the confirmation screen for actions.
		 *
		 * @since 2.0.0
		 *
		 * @param string $action Delete, activate, or resend activation link.
		 *
		 * @return null|false
		 */
		public function signups_admin_manage($action = '')
		{
		}
		/** Users List Management ****************************************************/
		/**
		 * Display a dropdown to bulk change the member type of selected user(s).
		 *
		 * @since 2.7.0
		 *
		 * @param string $which Where this dropdown is displayed - top or bottom.
		 */
		public function users_table_output_type_change_select($which = 'top')
		{
		}
		/**
		 * Process bulk member type change submission from the WP admin users list table.
		 *
		 * @since 2.7.0
		 */
		public function users_table_process_bulk_type_change()
		{
		}
		/**
		 * Display an admin notice upon member type bulk update.
		 *
		 * @since 2.7.0
		 */
		public function users_type_change_notice()
		{
		}
		/**
		 * Add member type column to the WordPress admin users list table.
		 *
		 * @since 2.7.0
		 *
		 * @param array $columns Users table columns.
		 *
		 * @return array $columns
		 */
		public function users_table_add_type_column($columns = array())
		{
		}
		/**
		 * Return member's type for display in the WP admin users list table.
		 *
		 * @since 2.7.0
		 *
		 * @param string $retval
		 * @param string $column_name
		 * @param int $user_id
		 *
		 * @return string Member type as a link to filter all users.
		 */
		public function users_table_populate_type_cell($retval = '', $column_name = '', $user_id = 0)
		{
		}
		/**
		 * Filter WP Admin users list table to include users of the specified type.
		 *
		 * @since 2.7.0
		 *
		 * @global string $pagenow The filename of the current screen.
		 *
		 * @param WP_Query $query The WordPress Query object.
		 */
		public function users_table_filter_by_type($query)
		{
		}
		/**
		 * Formats a signup's xprofile field data for display.
		 *
		 * Operates recursively on arrays, which are then imploded with commas.
		 *
		 * @since 2.8.0
		 * @deprecated 10.0.0
		 *
		 * @param string|array $value Field value.
		 * @return string
		 */
		protected function format_xprofile_field_for_display($value)
		{
		}
		/**
		 * Set up the signups admin page.
		 *
		 * Loaded before the page is rendered, this function does all initial
		 * setup, including: processing form requests, registering contextual
		 * help, and setting up screen options.
		 *
		 * @since 8.0.0
		 *
		 * @global object $bp_members_invitations_list_table
		 */
		public function members_invitations_admin_load()
		{
		}
		/**
		 * Get admin notice when viewing the invitations management page.
		 *
		 * @since 8.0.0
		 *
		 * @return array
		 */
		private function get_members_invitations_notice()
		{
		}
		/**
		 * Member invitations admin page router.
		 *
		 * Depending on the context, display
		 * - the list of invitations,
		 * - or the delete confirmation screen,
		 * - or the "resend" email confirmation screen.
		 *
		 * Also prepare the admin notices.
		 *
		 * @since 8.0.0
		 */
		public function invitations_admin()
		{
		}
		/**
		 * This is the list of invitations.
		 *
		 * @since 8.0.0
		 *
		 * @global string $plugin_page
		 * @global object $bp_members_invitations_list_table
		 */
		public function invitations_admin_index()
		{
		}
		/**
		 * This is the confirmation screen for actions.
		 *
		 * @since 8.0.0
		 *
		 * @param string $action Delete or resend invitation.
		 * @return null|false
		 */
		public function invitations_admin_manage($action = '')
		{
		}
	}
	/**
	 * Member Cover endpoints.
	 *
	 * /members/<user_id>/cover
	 *
	 * @since 6.0.0
	 */
	class BP_REST_Attachments_Member_Cover_Endpoint extends \WP_REST_Controller
	{
		use \BP_REST_Attachments;
		/**
		 * BP_Attachment_Cover_Image Instance.
		 *
		 * @since 6.0.0
		 *
		 * @var BP_Attachment_Cover_Image
		 */
		protected $attachment_instance;
		/**
		 * Member object.
		 *
		 * @since 6.0.0
		 *
		 * @var WP_User
		 */
		protected $user;
		/**
		 * Member object type.
		 *
		 * @since 6.0.0
		 *
		 * @var string
		 */
		protected $object = 'user';
		/**
		 * Constructor.
		 *
		 * @since 6.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 6.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Fetch an existing user cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Checks if a given request has access to get a user cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Upload a user cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to upload a user cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Delete an existing user cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Checks if a given request has access to delete a user cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares user cover to return as an object.
		 *
		 * @since 6.0.0
		 *
		 * @param string          $cover_url User cover url.
		 * @param WP_REST_Request $request   Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($cover_url, $request)
		{
		}
		/**
		 * Get the plugin schema, conforming to JSON Schema.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
	}
	/**
	 * Signups Management class.
	 *
	 * @package BuddyPress
	 * @subpackage coreClasses
	 * @since 2.0.0
	 */
	/**
	 * Class used to handle Signups.
	 *
	 * @since 2.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Signup
	{
		/**
		 * ID of the signup which the object relates to.
		 *
		 * @since 2.0.0
		 * @var integer
		 */
		public $id;
		/**
		 * ID of the signup which the object relates to.
		 *
		 * @since 2.0.0
		 * @var integer
		 */
		public $signup_id;
		/**
		 * The URL to the full size of the avatar for the user.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $avatar;
		/**
		 * The username for the user.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $user_login;
		/**
		 * The email for the user.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $user_email;
		/**
		 * The full name of the user.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $user_name;
		/**
		 * Metadata associated with the signup.
		 *
		 * @since 2.0.0
		 * @var array
		 */
		public $meta;
		/**
		 * The registered date for the user.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $registered;
		/**
		 * The activation key for the user.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $activation_key;
		/**
		 * The activated date for the user.
		 *
		 * @since 10.0.0
		 * @var string
		 */
		public $activated;
		/**
		 * Whether the user account is activated or not.
		 *
		 * @since 10.0.0
		 * @var bool
		 */
		public $active;
		/**
		 * The date that the last activation email was sent.
		 *
		 * @since 10.0.0
		 * @var string
		 */
		public $date_sent;
		/**
		 * Was the last activation email sent in the last 24 hours?
		 *
		 * @since 10.0.0
		 * @var bool
		 */
		public $recently_sent;
		/**
		 * The number of activation emails sent to this user.
		 *
		 * @since 10.0.0
		 * @var int
		 */
		public $count_sent;
		/**
		 * The domain for the signup.
		 *
		 * @since 10.0.0
		 * @var string
		 */
		public $domain;
		/**
		 * The path for the signup.
		 *
		 * @since 10.0.0
		 * @var string
		 */
		public $path;
		/**
		 * The title for the signup.
		 *
		 * @since 10.0.0
		 * @var string
		 */
		public $title;
		/** Public Methods *******************************************************/
		/**
		 * Class constructor.
		 *
		 * @since 2.0.0
		 *
		 * @param integer $signup_id The ID for the signup being queried.
		 */
		public function __construct($signup_id = 0)
		{
		}
		/**
		 * Populate the instantiated class with data based on the signup_id provided.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 */
		public function populate()
		{
		}
		/** Static Methods *******************************************************/
		/**
		 * Fetch signups based on parameters.
		 *
		 * @since 2.0.0
		 * @since 6.0.0 Added a list of allowed orderby parameters.
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param array $args {
		 *     The argument to retrieve desired signups.
		 *     @type int         $offset         Offset amount. Default 0.
		 *     @type int         $number         How many to fetch. Pass -1 to fetch all. Default 1.
		 *     @type bool|string $usersearch     Whether or not to search for a username. Default false.
		 *     @type string      $orderby        Order By parameter. Possible values are `signup_id`, `login`, `email`,
		 *                                       `registered`, `activated`. Default `signup_id`.
		 *     @type string      $order          Order direction. Default 'DESC'.
		 *     @type bool        $include        Whether or not to include more specific query params.
		 *     @type string      $activation_key Activation key to search for. If specified, all other
		 *                                       parameters will be ignored.
		 *     @type int|bool    $active         Pass 0 for inactive signups, 1 for active signups,
		 *                                       and `false` to ignore.
		 *     @type string      $user_login     Specific user login to return.
		 *     @type string      $fields         Which fields to return. Specify 'ids' to fetch a list of signups IDs.
		 *                                       Default: 'all' (return BP_Signup objects).
		 * }
		 * @return array {
		 *     @type array $signups Located signups. (IDs only if `fields` is set to `ids`.)
		 *     @type int   $total   Total number of signups matching params.
		 * }
		 */
		public static function get($args = array())
		{
		}
		/**
		 * Add a signup.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param array $args {
		 *     Array of arguments for signup addition.
		 *     @type string     $domain         New user's domain.
		 *     @type string     $path           New user's path.
		 *     @type string     $title          New user's title.
		 *     @type string     $user_login     New user's user_login.
		 *     @type string     $user_email     New user's email address.
		 *     @type int|string $registered     Time the user registered.
		 *     @type string     $activation_key New user's activation key.
		 *     @type string     $meta           New user's user meta.
		 * }
		 * @return int|bool ID of newly created signup on success, false on failure.
		 */
		public static function add($args = array())
		{
		}
		/**
		 * Create a WP user at signup.
		 *
		 * Since BP 2.0, non-multisite configurations have stored signups in
		 * the same way as Multisite configs traditionally have: in the
		 * wp_signups table. However, because some plugins may be looking
		 * directly in the wp_users table for non-activated signups, we
		 * mirror signups there by creating "phantom" users, mimicking WP's
		 * default behavior.
		 *
		 * @since 2.0.0
		 * @deprecated 14.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param string $user_login    User login string.
		 * @param string $user_password User password.
		 * @param string $user_email    User email address.
		 * @param array  $usermeta      Metadata associated with the signup.
		 * @return int User id.
		 */
		public static function add_backcompat($user_login = '', $user_password = '', $user_email = '', $usermeta = array())
		{
		}
		/**
		 * Check a user status (from wp_users) on a non-multisite config.
		 *
		 * @since 2.0.0
		 *
		 * @param  int      $user_id ID of the user being checked.
		 * @return int|bool          The status if found, otherwise false.
		 */
		public static function check_user_status($user_id = 0)
		{
		}
		/**
		 * Activate a signup.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param string $key Activation key.
		 * @return bool
		 */
		public static function validate($key = '')
		{
		}
		/**
		 * How many inactive signups do we have?
		 *
		 * @since 2.0.0
		 *
		 * @return int The number of signups.
		 */
		public static function count_signups()
		{
		}
		/**
		 * Update the meta for a signup.
		 *
		 * This is the way we use to "trace" the last date an activation
		 * email was sent and how many times activation was sent.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param array $args {
		 *     Array of arguments for the signup update.
		 *     @type int $signup_id User signup ID.
		 *     @type array $meta Meta to update.
		 * }
		 * @return int The signup id.
		 */
		public static function update($args = array())
		{
		}
		/**
		 * Resend an activation email.
		 *
		 * @since 2.0.0
		 *
		 * @param array $signup_ids Single ID or list of IDs to resend.
		 * @return array
		 */
		public static function resend($signup_ids = array())
		{
		}
		/**
		 * Activate a pending account.
		 *
		 * @since 2.0.0
		 *
		 * @param array $signup_ids Single ID or list of IDs to activate.
		 * @return array
		 */
		public static function activate($signup_ids = array())
		{
		}
		/**
		 * Delete a pending account.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param array $signup_ids Single ID or list of IDs to delete.
		 * @return array
		 */
		public static function delete($signup_ids = array())
		{
		}
	}
	/**
	 * The main theme compat class for BuddyPress Members.
	 *
	 * This class sets up the necessary theme compatibility actions to safely output
	 * member template parts to the_title and the_content areas of a theme.
	 *
	 * @since 1.7.0
	 */
	class BP_Members_Theme_Compat
	{
		/**
		 * Set up the members component theme compatibility.
		 *
		 * @since 1.7.0
		 */
		public function __construct()
		{
		}
		/**
		 * Are we looking at something that needs members theme compatibility?
		 *
		 * @since 1.7.0
		 */
		public function is_members()
		{
		}
		/** Directory *************************************************************/
		/**
		 * Add template hierarchy to theme compat for the members directory page.
		 *
		 * This is to mirror how WordPress has
		 * {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param array $templates The templates from bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function directory_template_hierarchy($templates = array())
		{
		}
		/**
		 * Update the global $post with directory data.
		 *
		 * @since 1.7.0
		 */
		public function directory_dummy_post()
		{
		}
		/**
		 * Filter the_content with the members index template part.
		 *
		 * @since 1.7.0
		 */
		public function directory_content()
		{
		}
		/** Single ****************************************************************/
		/**
		 * Add custom template hierarchy to theme compat for member pages.
		 *
		 * This is to mirror how WordPress has
		 * {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param string $templates The templates from
		 *                          bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function single_template_hierarchy($templates)
		{
		}
		/**
		 * Update the global $post with the displayed user's data.
		 *
		 * @since 1.7.0
		 */
		public function single_dummy_post()
		{
		}
		/**
		 * Filter the_content with the members' single home template part.
		 *
		 * @since 1.7.0
		 */
		public function single_dummy_content()
		{
		}
	}
	/**
	 * Signup endpoints.
	 *
	 * Use /signup
	 * Use /signup/{id}
	 * Use /signup/resend
	 * Use /signup/activate/{activation_key}
	 *
	 * @since 6.0.0
	 */
	class BP_REST_Signup_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 6.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 6.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve signups.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to signup items.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Retrieve single signup.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to get a signup.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Create signup.
		 *
		 * @since 6.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to create a signup.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Delete a signup.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete a signup.
		 *
		 * @since 6.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Activate a signup.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function activate_item($request)
		{
		}
		/**
		 * Check if a given request has access to activate a signup.
		 *
		 * @since 6.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function activate_item_permissions_check($request)
		{
		}
		/**
		 * Resend the activation email.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function signup_resend_activation_email($request)
		{
		}
		/**
		 * Check if a given request has access to resend the activation email.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function signup_resend_activation_email_permissions_check($request)
		{
		}
		/**
		 * Prepares signup to return as an object.
		 *
		 * @since 6.0.0
		 *
		 * @param  BP_Signup       $signup  Signup object.
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($signup, $request)
		{
		}
		/**
		 * Prepares links for the signup request.
		 *
		 * @param BP_Signup $signup The signup object.
		 * @return array
		 */
		protected function prepare_links($signup)
		{
		}
		/**
		 * Get signup object.
		 *
		 * @since 6.0.0
		 *
		 * @param int|string $identifier Signup identifier.
		 * @return BP_Signup|false
		 */
		public function get_signup_object($identifier)
		{
		}
		/**
		 * Check a user password for the REST API.
		 *
		 * @since 6.0.0
		 *
		 * @param string $value The password submitted in the request.
		 * @return string|WP_Error The sanitized password, if valid, otherwise an error.
		 */
		public function check_user_password($value)
		{
		}
		/**
		 * Is it possible to signup with a blog?
		 *
		 * @since 6.0.0
		 *
		 * @return bool True if blog signup is allowed. False otherwise.
		 */
		public function is_blog_signup_allowed()
		{
		}
		/**
		 * Get site's available locales.
		 *
		 * @since 6.0.0
		 *
		 * @return array The list of available locales.
		 */
		public function get_available_languages()
		{
		}
		/**
		 * Edit the type of the some properties for the CREATABLE & EDITABLE methods.
		 *
		 * @since 6.0.0
		 *
		 * @param string $method HTTP method of the request. Default is WP_REST_Server::CREATABLE.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the signup schema, conforming to JSON Schema.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for collections.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * Recently Active Members Widget.
	 *
	 * @since 1.0.3
	 * @deprecated 12.0.0
	 */
	class BP_Core_Recently_Active_Widget extends \WP_Widget
	{
		/**
		 * Constructor method.
		 *
		 * @since 1.5.0
		 * @since 9.0.0 Adds the `show_instance_in_rest` property to Widget options.
		 * @deprecated 12.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Display the Recently Active widget.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @see WP_Widget::widget() for description of parameters.
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Widget settings, as saved by the user.
		 */
		public function widget($args, $instance)
		{
		}
		/**
		 * Update the Recently Active widget options.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @param array $new_instance The new instance options.
		 * @param array $old_instance The old instance options.
		 */
		public function update($new_instance, $old_instance)
		{
		}
		/**
		 * Output the Recently Active widget options form.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @param array $instance Widget instance settings.
		 */
		public function form($instance)
		{
		}
		/**
		 * Merge the widget settings into defaults array.
		 *
		 * @since 2.3.0
		 * @deprecated 12.0.0
		 *
		 * @param array $instance Widget instance settings.
		 */
		public function parse_settings($instance = array())
		{
		}
	}
	class BP_Members_Invitations_Component extends \BP_Component
	{
		function __construct()
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @see `BP_Component::register_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up component navigation.
		 *
		 * @since 12.0.0 Used to customize the default subnavigation slug.
		 *
		 * @see `BP_Component::setup_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 */
		public function setup_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up the component entries in the WordPress Admin Bar.
		 *
		 * @since 1.0.0
		 *
		 * @see BP_Component::setup_admin_bar() for a description of arguments.
		 *
		 * @param array $wp_admin_nav See BP_Component::setup_admin_bar()
		 *                            for description.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
	}
	/**
	 * BP Invitations class.
	 *
	 * Extend it to manage your class's invitations.
	 * Your extension class, must, at a minimum, provide the
	 * run_send_action() and run_acceptance_action() methods.
	 *
	 * @since 5.0.0
	 */
	abstract class BP_Invitation_Manager
	{
		/**
		 * The name of the related class.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		protected $class_name;
		/**
		 * Construct parameters.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Get the invitations table name.
		 *
		 * @since 5.0.0
		 *
		 * @return string
		 */
		public static function get_table_name()
		{
		}
		/** Create ********************************************************************/
		/**
		 * Add an invitation to a specific user, from a specific user, related to a
		 * specific class.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {
		 *     Array of arguments describing the invitation. All are optional.
		 *     @type int    $user_id           ID of the invited user.
		 *     @type int    $inviter_id        ID of the user who created the invitation.
		 *     @type string $invitee_email     Email address of the invited user.
		 *     @type int    $item_id           ID associated with the invitation and class.
		 *     @type int    $secondary_item_id Secondary ID associated with the
		 *                                     invitation and class.
		 *     @type string $type              Type of record this is: 'invite' or 'request'.
		 *     @type string $content           Extra information provided by the requester
		 *                                     or inviter.
		 *     @type string $date_modified     Date the invitation was last modified.
		 *     @type int    $send_invite       Should the invitation also be sent, or is it a
		 *                                     draft invite?
		 * }
		 * @return int|bool ID of the newly created invitation on success, false
		 *                  on failure.
		 */
		public function add_invitation($args = array())
		{
		}
		/**
		 * Send an invitation notification.
		 *
		 * @since 5.0.0
		 *
		 * @param int   $invitation_id ID of invitation to send.
		 * @param array $args          See BP_Invitation::mark_sent().
		 * @return bool
		 */
		public function send_invitation_by_id($invitation_id = 0, $args = array())
		{
		}
		/**
		 * Add a request to an item for a specific user, related to a
		 * specific class.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {
		 *     Array of arguments describing the invitation. All are optional.
		 *     @type int    $user_id ID of the invited user.
		 *     @type int    $inviter_id ID of the user who created the invitation.
		 *     @type string $class Name of the invitations class.
		 *     @type int    $item_id ID associated with the invitation and class.
		 *     @type int    $secondary_item_id secondary ID associated with the
		 *                  invitation and class.
		 *     @type string $type    Type of record this is: 'invite' or 'request'.
		 *     @type string $content Extra information provided by the requester
		 *                  or inviter.
		 *     @type string $date_modified Date the invitation was last modified.
		 *     @type int    $invite_sent Has the invitation been sent, or is it a
		 *           draft invite?
		 * }
		 * @return int|bool ID of the newly created invitation on success, false
		 *                  on failure.
		 */
		public function add_request($args = array())
		{
		}
		/**
		 * Send a request notification.
		 *
		 * @since 5.0.0
		 *
		 * @param int   $request_id ID of request to send.
		 * @param array $args       See BP_Invitation::mark_sent().
		 * @return bool
		 */
		public function send_request_notification_by_id($request_id = 0, $args = array())
		{
		}
		/** Retrieve ******************************************************************/
		/**
		 * Get a specific invitation by its ID.
		 *
		 * @since 5.0.0
		 *
		 * @param int $id ID of the invitation.
		 * @return BP_Invitation object
		 */
		public function get_by_id($id = 0)
		{
		}
		/**
		 * Get invitations, based on provided filter parameters.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {@see BP_Invitation::get()}.
		 * @return array Located invitations.
		 */
		public function get_invitations($args = array())
		{
		}
		/**
		 * Get a count of the number of invitations that match provided filter parameters.
		 *
		 * @since 8.0.0
		 *
		 * @param array $args {@see BP_Invitation::get_total_count()}.
		 * @return int Total number of invitations.
		 */
		public function get_invitations_total_count($args = array())
		{
		}
		/**
		 * Get requests, based on provided filter parameters.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {@see BP_Invitation::get()}.
		 * @return array Located invitations.
		 */
		public function get_requests($args = array())
		{
		}
		/**
		 * Check whether an invitation exists matching the passed arguments.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {@see BP_Invitation::get()}.
		 * @return int|bool ID of first found invitation or false if none found.
		 */
		public function invitation_exists($args = array())
		{
		}
		/**
		 * Check whether a request exists matching the passed arguments.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {@see BP_Invitation::get()}.
		 * @return int|bool ID of existing request or false if none found.
		 */
		public function request_exists($args = array())
		{
		}
		/** Update ********************************************************************/
		/**
		 * Accept invitation, based on provided filter parameters.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {BP_Invitation::get()}.
		 * @return int|bool Number of rows updated on success, false on failure.
		 */
		public function accept_invitation($args = array())
		{
		}
		/**
		 * Accept invitation, based on provided filter parameters.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {BP_Invitation::get()}.
		 * @return bool Number of rows updated on success, false on failure.
		 */
		public function accept_request($args = array())
		{
		}
		/**
		 * Update invitation, based on provided filter parameters.
		 *
		 * @since 5.0.0
		 *
		 * @see BP_Invitation::update() for a description of
		 *      accepted update/where arguments.
		 *
		 * @param array $update_args Associative array of fields to update,
		 *              and the values to update them to. Of the format
		 *              array( 'user_id' => 4 ).
		 * @param array $where_args Associative array of columns/values, to
		 *              determine which invitations should be updated. Formatted as
		 *              array( 'item_id' => 7 ).
		 * @return int|bool Number of rows updated on success, false on failure.
		 */
		public function update_invitation($update_args = array(), $where_args = array())
		{
		}
		/**
		 * This is where custom actions are added (in child classes)
		 * to run when an invitation or request needs to be "sent."
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Invitation $invitation The invitation to send.
		 * @return bool
		 */
		public abstract function run_send_action(\BP_Invitation $invitation);
		/**
		 * Mark invitations as sent that are found by user_id, inviter_id,
		 * invitee_email, class name, optional item id,
		 * optional secondary item id.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {
		 *     Associative array of arguments. All arguments but $page and
		 *     $per_page can be treated as filter values for get_where_sql()
		 *     and get_query_clauses(). All items are optional.
		 *     @type int|array    $user_id ID of user being queried. Can be an
		 *                        array of user IDs.
		 *     @type int|array    $inviter_id ID of user who created the
		 *                        invitation. Can be an array of user IDs.
		 *                        Special cases
		 *     @type string|array $invitee_email Email address of invited users
		 *                        being queried. Can be an array of addresses.
		 *     @type string|array $class Name of the class to
		 *                        filter by. Can be an array of class names.
		 *     @type int|array    $item_id ID of associated item. Can be an array
		 *                        of multiple item IDs.
		 *     @type int|array    $secondary_item_id ID of secondary associated
		 *                        item. Can be an array of multiple IDs.
		 * }
		 */
		public function mark_sent($args)
		{
		}
		/**
		 * This is where custom actions are added (in child classes)
		 * to run when an invitation or request is accepted.
		 *
		 * @since 5.0.0
		 *
		 * @param string $type The type of record being accepted: 'invite' or 'request'.
		 * @param array  $r    Associative array of arguments.
		 * @return bool
		 */
		public abstract function run_acceptance_action($type, $r);
		/**
		 * Mark invitation as accepted by invitation ID.
		 *
		 * @since 5.0.0
		 *
		 * @param int   $id   ID of the invitation to mark as accepted.
		 * @param array $args {@see BP_Invitation::mark_accepted()}.
		 * @return int|bool Number of rows updated on success, false on failure.
		 */
		public function mark_accepted_by_id($id, $args)
		{
		}
		/**
		 * Mark invitations as sent that are found by user_id, inviter_id,
		 * invitee_email, class name, item id, and
		 * optional secondary item id.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {BP_Invitation::mark_accepted_by_data()}.
		 * @return int|bool Number of rows updated on success, false on failure.
		 */
		public function mark_accepted($args)
		{
		}
		/** Delete ********************************************************************/
		/**
		 * Delete an invitation or invitations by query data.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {BP_Invitation::delete()}.
		 * @return int|bool Number of rows deleted on success, false on failure.
		 */
		public function delete($args)
		{
		}
		/**
		 * Delete a request or requests by query data.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args {BP_Invitation::delete()}.
		 * @return int|bool Number of rows deleted on success, false on failure.
		 */
		public function delete_requests($args)
		{
		}
		/**
		 * Delete all invitations by class.
		 *
		 * Used when clearing out invitations for an entire class. Possibly used
		 * when deactivating a component related to a class that created invitations.
		 *
		 * @since 5.0.0
		 *
		 * @return int|bool Number of rows deleted on success, false on failure.
		 */
		public function delete_all()
		{
		}
		/**
		 * Delete an invitation by id.
		 *
		 * @since 8.0.0
		 *
		 * @param int $id ID of the invitation to delete.
		 * @return int|bool Number of rows deleted on success, false on failure.
		 */
		public function delete_by_id($id)
		{
		}
		/**
		 * This is where custom actions are added (in child classes)
		 * to determine whether an invitation should be allowed.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args The parameters that describe the invitation.
		 * @return bool
		 */
		public function allow_invitation($args)
		{
		}
		/**
		 * This is where custom actions are added (in child classes)
		 * to determine whether a request should be allowed.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args The parameters describing the request.
		 * @return bool
		 */
		public function allow_request($args)
		{
		}
	}
	/**
	 * Membership invitations class.
	 *
	 * An extension of the core Invitations class that adapts the
	 * core logic to accommodate site membership invitation behavior.
	 *
	 * @since 8.0.0
	 */
	class BP_Members_Invitation_Manager extends \BP_Invitation_Manager
	{
		/**
		 * Construct parameters.
		 *
		 * @since 8.0.0
		 *
		 * @param array|string $args.
		 */
		public function __construct($args = '')
		{
		}
		/**
		 * This is where custom actions are added to run when notifications of an
		 * invitation or request need to be generated & sent.
		 *
		 * @since 8.0.0
		 *
		 * @param obj BP_Invitation $invitation The invitation to send.
		 * @return bool
		 */
		public function run_send_action(\BP_Invitation $invitation)
		{
		}
		/**
		 * This is where custom actions are added to run when an invitation
		 * or request is accepted.
		 *
		 * @since 8.0.0
		 *
		 * @param string $type Are we accepting an invitation or request?
		 * @param array  $r    Parameters that describe the invitation being accepted.
		 * @return bool
		 */
		public function run_acceptance_action($type, $r)
		{
		}
		/**
		 * Should this invitation be created?
		 *
		 * @since 8.0.0
		 *
		 * @param array $args Array of arguments.
		 * @return bool
		 */
		public function allow_invitation($args)
		{
		}
		/**
		 * Should this request be created?
		 *
		 * @since 8.0.0
		 *
		 * @param array $args.
		 * @return bool.
		 */
		public function allow_request($args)
		{
		}
	}
	/**
	 * Who's Online Widget.
	 *
	 * @since 1.0.3
	 * @since 9.0.0 Adds the `show_instance_in_rest` property to Widget options.
	 * @deprecated 12.0.0
	 */
	class BP_Core_Whos_Online_Widget extends \WP_Widget
	{
		/**
		 * Constructor method.
		 *
		 * @since 1.5.0
		 * @since 9.0.0 Adds the `show_instance_in_rest` property to Widget options.
		 * @deprecated 12.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Display the Who's Online widget.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @see WP_Widget::widget() for description of parameters.
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Widget settings, as saved by the user.
		 */
		public function widget($args, $instance)
		{
		}
		/**
		 * Update the Who's Online widget options.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @param array $new_instance The new instance options.
		 * @param array $old_instance The old instance options.
		 */
		public function update($new_instance, $old_instance)
		{
		}
		/**
		 * Output the Who's Online widget options form.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @param array $instance Widget instance settings.
		 */
		public function form($instance)
		{
		}
		/**
		 * Merge the widget settings into defaults array.
		 *
		 * @since 2.3.0
		 * @deprecated 12.0.0
		 *
		 * @param array $instance Widget instance settings.
		 */
		public function parse_settings($instance = array())
		{
		}
	}
	/**
	 * The main member template loop class.
	 *
	 * Responsible for loading a group of members into a loop for display.
	 *
	 * @since 1.0.0
	 */
	class BP_Core_Members_Template
	{
		/**
		 * The loop iterator.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $current_member = -1;
		/**
		 * The number of members returned by the paged query.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $member_count;
		/**
		 * Array of members located by the query.
		 *
		 * @since 1.0.0
		 * @var array
		 */
		public $members;
		/**
		 * The member object currently being iterated on.
		 *
		 * @since 1.0.0
		 * @var object
		 */
		public $member;
		/**
		 * A flag for whether the loop is currently being iterated.
		 *
		 * @since 1.0.0
		 * @var bool
		 */
		public $in_the_loop;
		/**
		 * The type of member being requested. Used for ordering results.
		 *
		 * @since 2.3.0
		 * @var string
		 */
		public $type;
		/**
		 * The unique string used for pagination queries.
		 *
		 * @since 2.2.0
		 * @var string
		 */
		public $pag_arg;
		/**
		 * The page number being requested.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $pag_page;
		/**
		 * The number of items being requested per page.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $pag_num;
		/**
		 * An HTML string containing pagination links.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $pag_links;
		/**
		 * The total number of members matching the query parameters.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $total_member_count;
		/**
		 * Constructor method.
		 *
		 * @since 1.5.0
		 * @since 7.0.0 Added `$xprofile_query` parameter. Added `$user_ids` parameter.
		 * @since 10.0.0 Added `$date_query` parameter.
		 *
		 * @see BP_User_Query for an in-depth description of parameters.
		 *
		 * @param array ...$args {
		 *     Array of arguments. Supports all arguments of BP_User_Query. Additional
		 *     arguments, or those with different defaults, are described below.
		 *
		 *     @type int    $page_number Page of results. Accepted for legacy reasons. Use 'page' instead.
		 *     @type int    $max         Max number of results to return.
		 *     @type string $page_arg    Optional. The string used as a query parameter in pagination links.
		 * }
		 */
		public function __construct(...$args)
		{
		}
		/**
		 * Whether there are members available in the loop.
		 *
		 * @since 1.0.0
		 *
		 * @see bp_has_members()
		 *
		 * @return bool True if there are items in the loop, otherwise false.
		 */
		public function has_members()
		{
		}
		/**
		 * Set up the next member and iterate index.
		 *
		 * @since 1.0.0
		 *
		 * @return object The next member to iterate over.
		 */
		public function next_member()
		{
		}
		/**
		 * Rewind the members and reset member index.
		 *
		 * @since 1.0.0
		 */
		public function rewind_members()
		{
		}
		/**
		 * Whether there are members left in the loop to iterate over.
		 *
		 * This method is used by {@link bp_members()} as part of the while loop
		 * that controls iteration inside the members loop, eg:
		 *     while ( bp_members() ) { ...
		 *
		 * @since 1.2.0
		 *
		 * @see bp_members()
		 *
		 * @return bool True if there are more members to show, otherwise false.
		 */
		public function members()
		{
		}
		/**
		 * Set up the current member inside the loop.
		 *
		 * Used by {@link bp_the_member()} to set up the current member data
		 * while looping, so that template tags used during that iteration make
		 * reference to the current member.
		 *
		 * @since 1.0.0
		 *
		 * @see bp_the_member()
		 */
		public function the_member()
		{
		}
	}
	/**
	 * BuddyPress Friendship object.
	 *
	 * @since 1.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Friends_Friendship
	{
		/**
		 * ID of the friendship.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $id;
		/**
		 * User ID of the friendship initiator.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $initiator_user_id;
		/**
		 * User ID of the 'friend' - the one invited to the friendship.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $friend_user_id;
		/**
		 * Has the friendship been confirmed/accepted?
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $is_confirmed;
		/**
		 * Is this a "limited" friendship?
		 *
		 * Not currently used by BuddyPress.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $is_limited;
		/**
		 * Date the friendship was created.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $date_created;
		/**
		 * Is this a request?
		 *
		 * Not currently used in BuddyPress.
		 *
		 * @since 1.0.0
		 * @var bool
		 */
		public $is_request;
		/**
		 * Should additional friend details be queried?
		 *
		 * @since 1.0.0
		 * @var bool
		 */
		public $populate_friend_details;
		/**
		 * Details about the friend.
		 *
		 * @since 1.0.0
		 * @var BP_Core_User
		 */
		public $friend;
		/**
		 * Constructor method.
		 *
		 * @since 1.5.0
		 * @since 10.0.0 Updated to add deprecated notice for `$is_request`.
		 *
		 * @param int|null $id                      Optional. The ID of an existing friendship.
		 * @param bool     $is_request              Deprecated.
		 * @param bool     $populate_friend_details Optional. True if friend details should be queried.
		 */
		public function __construct($id = \null, $is_request = \false, $populate_friend_details = \true)
		{
		}
		/**
		 * Set up data about the current friendship.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function populate()
		{
		}
		/**
		 * Save the current friendship to the database.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Delete the current friendship from the database.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool|int
		 */
		public function delete()
		{
		}
		/** Static Methods ********************************************************/
		/**
		 * Get the friendships for a given user.
		 *
		 * @since 2.6.0
		 *
		 * @param int    $user_id  ID of the user whose friends are being retrieved.
		 * @param array  $args     {
		 *        Optional. Filter parameters.
		 *        @type int    $id                ID of specific friendship to retrieve.
		 *        @type int    $initiator_user_id ID of friendship initiator.
		 *        @type int    $friend_user_id    ID of specific friendship to retrieve.
		 *        @type int    $is_confirmed      Whether the friendship has been accepted.
		 *        @type int    $is_limited        Whether the friendship is limited.
		 *        @type string $order_by          Column name to order by.
		 *        @type string $sort_order        Optional. ASC or DESC. Default: 'DESC'.
		 * }
		 * @param string $operator Optional. Operator to use in `wp_list_filter()`.
		 *
		 * @return array $friendships Array of friendship objects.
		 */
		public static function get_friendships($user_id, $args = array(), $operator = 'AND')
		{
		}
		/**
		 * Get all friendship IDs for a user.
		 *
		 * @since 2.7.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id ID of the user.
		 * @return array
		 */
		public static function get_friendship_ids_for_user($user_id)
		{
		}
		/**
		 * Get the IDs of a given user's friends.
		 *
		 * @since 1.0.0
		 *
		 * @param int  $user_id              ID of the user whose friends are being retrieved.
		 * @param bool $friend_requests_only Optional. Whether to fetch
		 *                                   unaccepted requests only. Default: false.
		 * @param bool $assoc_arr            Optional. True to receive an array of arrays
		 *                                   keyed as 'user_id' => $user_id; false to get a one-dimensional
		 *                                   array of user IDs. Default: false.
		 * @return array $fids IDs of friends for provided user.
		 */
		public static function get_friend_user_ids($user_id, $friend_requests_only = \false, $assoc_arr = \false)
		{
		}
		/**
		 * Get the ID of the friendship object, if any, between a pair of users.
		 *
		 * @since 1.0.0
		 *
		 * @param int $user_id   The ID of the first user.
		 * @param int $friend_id The ID of the second user.
		 * @return int|null The ID of the friendship object if found, otherwise null.
		 */
		public static function get_friendship_id($user_id, $friend_id)
		{
		}
		/**
		 * Get a list of IDs of users who have requested friendship of a given user.
		 *
		 * @since 1.2.0
		 *
		 * @param int $user_id The ID of the user who has received the
		 *                     friendship requests.
		 * @return array|bool An array of user IDs or false if none are found.
		 */
		public static function get_friendship_request_user_ids($user_id)
		{
		}
		/**
		 * Get a total friend count for a given user.
		 *
		 * @since 1.0.0
		 *
		 * @param int $user_id Optional. ID of the user whose friendships you
		 *                     are counting. Default: displayed user (if any), otherwise
		 *                     logged-in user.
		 * @return int Friend count for the user.
		 */
		public static function total_friend_count($user_id = 0)
		{
		}
		/**
		 * Search the friends of a user by a search string.
		 *
		 * @todo Optimize this function.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string   $filter  The search string, matched against xprofile
		 *                        fields (if available), or usermeta 'nickname' field.
		 * @param int      $user_id ID of the user whose friends are being searched.
		 * @param int|null $limit   Optional. Max number of friends to return.
		 * @param int|null $page    Optional. The page of results to return. Default:
		 *                          null (no pagination - return all results).
		 * @return array|bool On success, an array: {
		 *     @type array $friends IDs of friends returned by the query.
		 *     @type int   $count   Total number of friends (disregarding
		 *                          pagination) who match the search.
		 * }. Returns false on failure.
		 */
		public static function search_friends($filter, $user_id, $limit = \null, $page = \null)
		{
		}
		/**
		 * Check friendship status between two users.
		 *
		 * Note that 'pending' means that $initiator_userid has sent a friend
		 * request to $possible_friend_userid that has not yet been approved,
		 * while 'awaiting_response' is the other way around ($possible_friend_userid
		 * sent the initial request).
		 *
		 * @since 1.0.0
		 *
		 * @param int $initiator_userid       The ID of the user who is the initiator
		 *                                    of the potential friendship/request.
		 * @param int $possible_friend_userid The ID of the user who is the
		 *                                    recipient of the potential friendship/request.
		 * @return string|false $value The friendship status, from among 'not_friends',
		 *                             'is_friend', 'pending', and 'awaiting_response'.
		 */
		public static function check_is_friend($initiator_userid, $possible_friend_userid)
		{
		}
		/**
		 * Find uncached friendships between a user and one or more other users and cache them.
		 *
		 * @since 3.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int              $user_id             The ID of the primary user for whom we want
		 *                                              to check friendships statuses.
		 * @param int|array|string $possible_friend_ids The IDs of the one or more users
		 *                                              to check friendship status with primary user.
		 */
		public static function update_bp_friends_cache($user_id, $possible_friend_ids)
		{
		}
		/**
		 * Get the last active date of many users at once.
		 *
		 * @todo Why is this in the Friends component?
		 *
		 * @since 1.0.0
		 *
		 * @param array $user_ids IDs of users whose last_active meta is
		 *                        being queried.
		 * @return array $retval Array of last_active values + user_ids.
		 */
		public static function get_bulk_last_active($user_ids)
		{
		}
		/**
		 * Mark a friendship as accepted.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $friendship_id ID of the friendship to be accepted.
		 * @return int Number of database rows updated.
		 */
		public static function accept($friendship_id)
		{
		}
		/**
		 * Remove a friendship or a friendship request INITIATED BY the logged-in user.
		 *
		 * @since 1.6.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $friendship_id ID of the friendship to be withdrawn.
		 * @return int Number of database rows deleted.
		 */
		public static function withdraw($friendship_id)
		{
		}
		/**
		 * Remove a friendship or a friendship request MADE OF the logged-in user.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $friendship_id ID of the friendship to be rejected.
		 * @return int Number of database rows deleted.
		 */
		public static function reject($friendship_id)
		{
		}
		/**
		 * Search users.
		 *
		 * @todo Why does this exist, and why is it in bp-friends?
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string   $filter  String to search by.
		 * @param int      $user_id A user ID param that is unused.
		 * @param int|null $limit   Optional. Max number of records to return.
		 * @param int|null $page    Optional. Number of the page to return. Default:
		 *                          false (no pagination - return all results).
		 * @return array $filtered_ids IDs of users who match the query.
		 */
		public static function search_users($filter, $user_id, $limit = \null, $page = \null)
		{
		}
		/**
		 * Get a count of users who match a search term.
		 *
		 * @todo Why does this exist, and why is it in bp-friends?
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string $filter Search term.
		 * @return int Count of users matching the search term.
		 */
		public static function search_users_count($filter)
		{
		}
		/**
		 * Sort a list of user IDs by their display names.
		 *
		 * @todo Why does this exist, and why is it in bp-friends?
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $user_ids Array of user IDs.
		 * @return array|bool User IDs, sorted by the associated display names.
		 *                    False if XProfile component is not active.
		 */
		public static function sort_by_name($user_ids)
		{
		}
		/**
		 * Get a list of random friend IDs.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id       ID of the user whose friends are being retrieved.
		 * @param int $total_friends Optional. Number of random friends to get.
		 *                           Default: 5.
		 * @return array|false An array of random friend user IDs on success;
		 *                     false if none are found.
		 */
		public static function get_random_friends($user_id, $total_friends = 5)
		{
		}
		/**
		 * Get a count of a user's friends who can be invited to a given group.
		 *
		 * Users can invite any of their friends except:
		 *
		 * - users who are already in the group
		 * - users who have a pending invite to the group
		 * - users who have been banned from the group
		 *
		 * @todo Need to do a group component check before using group functions.
		 *
		 * @since 1.0.0
		 *
		 * @param int $user_id  ID of the user whose friends are being counted.
		 * @param int $group_id ID of the group friends are being invited to.
		 * @return bool|int False if group component is not active, and friend count.
		 */
		public static function get_invitable_friend_count($user_id, $group_id)
		{
		}
		/**
		 * Get friendship objects by ID (or an array of IDs).
		 *
		 * @since 2.7.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int|string|array $friendship_ids Single friendship ID or comma-separated/array list of friendship IDs.
		 * @return array
		 */
		public static function get_friendships_by_id($friendship_ids)
		{
		}
		/**
		 * Get the friend user IDs for a given friendship.
		 *
		 * @since 1.0.0
		 *
		 * @param int $friendship_id ID of the friendship.
		 * @return null|stdClass
		 */
		public static function get_user_ids_for_friendship($friendship_id)
		{
		}
		/**
		 * Delete all friendships and friend notifications related to a user.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id ID of the user being expunged.
		 */
		public static function delete_all_for_user($user_id)
		{
		}
	}
	/**
	 * The User Friends widget class.
	 *
	 * @since 1.9.0
	 * @deprecated 12.0.0
	 */
	class BP_Core_Friends_Widget
	{
		/**
		 * Class constructor.
		 *
		 * @since 1.9.0
		 * @since 9.0.0 Adds the `show_instance_in_rest` property to Widget options.
		 * @deprecated 12.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Enqueue scripts.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		public function enqueue_scripts()
		{
		}
		/**
		 * Display the widget.
		 *
		 * @since 1.9.0
		 * @deprecated 12.0.0
		 *
		 * @global BP_Core_Members_Template $members_template The main member template loop class.
		 *
		 * @param array $args Widget arguments.
		 * @param array $instance The widget settings, as saved by the user.
		 */
		public function widget($args, $instance)
		{
		}
		/**
		 * Process a widget save.
		 *
		 * @since 1.9.0
		 * @deprecated 12.0.0
		 *
		 * @param array $new_instance The parameters saved by the user.
		 * @param array $old_instance The parameters as previously saved to the database.
		 * @return array $instance The processed settings to save.
		 */
		public function update($new_instance, $old_instance)
		{
		}
		/**
		 * Render the widget edit form.
		 *
		 * @since 1.9.0
		 * @deprecated 12.0.0
		 *
		 * @param array $instance The saved widget settings.
		 */
		public function form($instance)
		{
		}
	}
	/**
	 * Friendship endpoints.
	 *
	 * /friends/
	 * /friends/{id}
	 *
	 * @since 6.0.0
	 */
	class BP_REST_Friends_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 6.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 6.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve friendships.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to friendship items.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Retrieve single friendship.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to get a friendship.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Create a new friendship.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Check if a given request has access to create a friendship.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Update, accept, friendship.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to update a friendship.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Reject/withdraw/remove friendship.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete a friendship.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares friendship data to return as an object.
		 *
		 * @since 6.0.0
		 *
		 * @param BP_Friends_Friendship $friendship Friendship object.
		 * @param WP_REST_Request       $request    Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($friendship, $request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 6.0.0
		 *
		 * @param BP_Friends_Friendship $friendship Friendship object.
		 * @return array
		 */
		protected function prepare_links($friendship)
		{
		}
		/**
		 * Get friendship object.
		 *
		 * @since 6.0.0
		 *
		 * @param int $friendship_id Friendship ID.
		 * @return BP_Friends_Friendship
		 */
		public function get_friendship_object($friendship_id)
		{
		}
		/**
		 * Edit some arguments for the endpoint's methods.
		 *
		 * @since 6.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the friends schema, conforming to JSON Schema.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for friends collections.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * Defines the BuddyPress Friends Component.
	 *
	 * @since 1.5.0
	 */
	#[\AllowDynamicProperties]
	class BP_Friends_Component extends \BP_Component
	{
		/**
		 * Start the friends component creation process.
		 *
		 * @since 1.5.0
		 */
		public function __construct()
		{
		}
		/**
		 * Include bp-friends files.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::includes() for description of parameters.
		 *
		 * @param array $includes See {@link BP_Component::includes()}.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Only load up certain code when on specific pages.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Set up bp-friends global settings.
		 *
		 * The BP_FRIENDS_SLUG constant is deprecated.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_globals() for description of parameters.
		 *
		 * @param array $args See {@link BP_Component::setup_globals()}.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @see `BP_Component::register_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up component navigation.
		 *
		 * @since 1.5.0
		 *
		 * @see `BP_Component::setup_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 */
		public function setup_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up bp-friends integration with the WordPress admin bar.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_admin_bar() for a description of arguments.
		 *
		 * @param array $wp_admin_nav See BP_Component::setup_admin_bar()
		 *                            for description.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Set up the title for pages and <title>.
		 *
		 * @since 1.5.0
		 */
		public function setup_title()
		{
		}
		/**
		 * Setup cache groups.
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Init the BP REST API.
		 *
		 * @since 6.0.0
		 *
		 * @param array $controllers Optional. See BP_Component::rest_api_init() for
		 *                           description.
		 */
		public function rest_api_init($controllers = array())
		{
		}
		/**
		 * Register the BP Friends Blocks.
		 *
		 * @since 9.0.0
		 * @since 12.0.0 Use the WP Blocks API v2.
		 *
		 * @param array $blocks Optional. See BP_Component::blocks_init() for
		 *                      description.
		 */
		public function blocks_init($blocks = array())
		{
		}
	}
}
namespace Buddypress\CLI\Command {
	/**
	 * Base component class.
	 *
	 * @since 1.0
	 */
	abstract class BuddyPressCommand extends \WP_CLI\CommandWithDBObject
	{
		/**
		 * Default dependency check for a BuddyPress CLI command.
		 *
		 * @since 2.0
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Get Formatter object based on supplied parameters.
		 *
		 * @since 2.0
		 *
		 * @param array $assoc_args Parameters passed to command. Determines formatting.
		 * @return \WP_CLI\Formatter
		 */
		protected function get_formatter(&$assoc_args)
		{
		}
		/**
		 * Get a random user id.
		 *
		 * @global wpdb $wpdb WordPress database abstraction object.
		 *
		 * @since 1.1
		 *
		 * @return int
		 */
		protected function get_random_user_id()
		{
		}
		/**
		 * Get an activity ID.
		 *
		 * @since 2.0
		 *
		 * @param int  $activity_id     Activity ID.
		 * @param bool $activity_object Return BP_Activity_Activity object.
		 * @return int|BP_Activity_Activity
		 */
		protected function get_activity_id_from_identifier($activity_id, $activity_object = false)
		{
		}
		/**
		 * Get a group ID from its identifier (ID or slug).
		 *
		 * @since 1.5.0
		 *
		 * @param int|string $group_id Group ID or slug.
		 * @return int|bool
		 */
		protected function get_group_id_from_identifier($group_id)
		{
		}
		/**
		 * Verify a user ID by the passed identifier.
		 *
		 * @since 1.2.0
		 *
		 * @param mixed $identifier User ID, email, or login.
		 * @return WP_User
		 */
		protected function get_user_id_from_identifier($identifier)
		{
		}
		/**
		 * Generate random text
		 *
		 * @since 1.1
		 *
		 * @return string
		 */
		protected function generate_random_text()
		{
		}
		/**
		 * Get field from an ID.
		 *
		 * @since 1.5.0
		 *
		 * @param int|string $field_id Field ID or Field name.
		 * @return int Field ID.
		 */
		protected function get_field_id($field_id)
		{
		}
		/**
		 * String sanitization.
		 *
		 * @since 1.5.0
		 *
		 * @param  string $type String to sanitize.
		 * @return string Sanitized string.
		 */
		protected function sanitize_string($type)
		{
		}
		/**
		 * Pull up a random active component.
		 *
		 * @since 1.1
		 *
		 * @return string
		 */
		protected function get_random_component()
		{
		}
		/**
		 * Get a list of activity components and actions.
		 *
		 * @since 1.1
		 *
		 * @return array
		 */
		protected function get_components_and_actions()
		{
		}
		/**
		 * Generate callback.
		 *
		 * @param string   $message Message to display.
		 * @param array    $assoc_args Command arguments.
		 * @param callable $callback Callback to execute.
		 */
		protected function generate_callback($message, $assoc_args, $callback)
		{
		}
	}
	/**
	 * Manage BuddyPress Emails.
	 *
	 * ## EXAMPLES
	 *
	 *     # Create email post
	 *     $ wp bp email create --type=new-event --type-description="Send an email when a new event is created" --subject="[{{{site.name}}}] A new event was created" --content="<a href='{{{some.custom-token-url}}}'></a>A new event</a> was created" --plain-text-content="A new event was created"
	 *     Success: Email post created for type "new-event".
	 *
	 *     # Create email post with content from given file
	 *     $ wp bp email create ./email-content.txt --type=new-event --type-description="Send an email when a new event is created" --subject="[{{{site.name}}}] A new event was created" --plain-text-content="A new event was created"
	 *     Success: Email post created for type "new-event".
	 *
	 * @since 1.6.0
	 */
	class Email extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Create a new email post connected to an email type.
		 *
		 * ## OPTIONS
		 *
		 * --type=<type>
		 * : Email type for the email (should be unique identifier, sanitized like a post slug).
		 *
		 * --type-description=<type-description>
		 * : Email type description.
		 *
		 * --subject=<subject>
		 * : Email subject line. Email tokens allowed. View https://codex.buddypress.org/emails/email-tokens/ for more info.
		 *
		 * [--content=<content>]
		 * : Email content. Email tokens allowed. View https://codex.buddypress.org/emails/email-tokens/ for more info.
		 *
		 * [--plain-text-content=<plain-text-content>]
		 * : Plain-text email content. Email tokens allowed. View https://codex.buddypress.org/emails/email-tokens/ for more info.
		 *
		 * [<file>]
		 * : Read content from <file>. If this value is present, the
		 *     `--content` argument will be ignored.
		 *
		 *   Passing `-` as the filename will cause post content to
		 *   be read from STDIN.
		 *
		 * [--edit]
		 * : Immediately open system's editor to write or edit email content.
		 *
		 *   If content is read from a file, from STDIN, or from the `--content`
		 *   argument, that text will be loaded into the editor.
		 *
		 * ## EXAMPLES
		 *
		 *     # Create email post
		 *     $ wp bp email create --type=new-event --type-description="Send an email when a new event is created" --subject="[{{{site.name}}}] A new event was created" --content="<a href='{{{some.custom-token-url}}}'></a>A new event</a> was created" --plain-text-content="A new event was created"
		 *     Success: Email post created for type "new-event".
		 *
		 *     # Create email post with content from given file
		 *     $ wp bp email create ./email-content.txt --type=new-event --type-description="Send an email when a new event is created" --subject="[{{{site.name}}}] A new event was created" --plain-text-content="A new event was created"
		 *     Success: Email post created for type "new-event".
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Get details for a post connected to an email type.
		 *
		 * ## OPTIONS
		 *
		 * <type>
		 * : The email type to fetch the post details for.
		 *
		 * [--field=<field>]
		 * : Instead of returning the whole post, returns the value of a single field.
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific fields.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - csv
		 *   - json
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLE
		 *
		 *     # Output the post ID for the 'activity-at-message' email type
		 *     $ wp bp email get-post activity-at-message --fields=ID
		 *
		 * @alias get-post
		 * @alias see
		 */
		public function get_post($args, $assoc_args)
		{
		}
		/**
		 * Reinstall BuddyPress default emails.
		 *
		 * ## OPTIONS
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLE
		 *
		 *     # Reinstall BuddyPress default emails.
		 *     $ wp bp email reinstall --yes
		 *     Success: Emails have been successfully reinstalled.
		 */
		public function reinstall($args, $assoc_args)
		{
		}
		/**
		 * Helper method to use the '--edit' flag.
		 *
		 * Copied from Post_Command::_edit().
		 *
		 * @param  string $content Post content.
		 * @param  string $title   Post title.
		 * @return mixed
		 */
		protected function edit_email($content, $title)
		{
		}
	}
	/**
	 * Manage BuddyPress Tools.
	 *
	 * ## EXAMPLES
	 *
	 *     # Repair the friend count.
	 *     $ wp bp tool repair friend-count
	 *     Success: Counting the number of friends for each user. Complete!
	 *
	 *     # Display BuddyPress version.
	 *     $ wp bp tool version
	 *     BuddyPress: 6.0.0
	 *
	 *     # Activate the signup tool.
	 *     $ wp bp tool signup 1
	 *     Success: Signup tool updated.
	 *
	 * @since 1.5.0
	 */
	class Tool extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Dependency check for this CLI command.
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Repair.
		 *
		 * ## OPTIONS
		 *
		 * <type>
		 * : Name of the repair tool.
		 * ---
		 * options:
		 *   - friend-count
		 *   - group-count
		 *   - blog-records
		 *   - count-members
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Repair the friend count.
		 *     $ wp bp tool repair friend-count
		 *     Success: Counting the number of friends for each user. Complete!
		 *
		 * @alias fix
		 */
		public function repair($args)
		{
		}
		/**
		 * Display BuddyPress version currently installed.
		 *
		 * ## EXAMPLE
		 *
		 *     # Display BuddyPress version.
		 *     $ wp bp tool version
		 *     BuddyPress: 6.0.0
		 */
		public function version()
		{
		}
		/**
		 * (De)Activate the signup feature.
		 *
		 * <status>
		 * : Status of the feature.
		 *
		 * ## EXAMPLES
		 *
		 *     # Activate the signup tool.
		 *     $ wp bp tool signup 1
		 *     Success: Signup tool updated.
		 *
		 *     # Deactivate the signup tool.
		 *     $ wp bp tool signup 0
		 *     Success: Signup tool updated.
		 */
		public function signup($args)
		{
		}
	}
	/**
	 * Adds, updates, deletes, and lists activity custom fields.
	 *
	 * ## EXAMPLES
	 *
	 *     # Set activity meta
	 *     $ wp bp activity meta set 123 description "Mary is a activity user."
	 *     Success: Updated custom field 'description'.
	 *
	 *     # Get activity meta
	 *     $ wp bp activity meta get 123 description
	 *     Mary is a Activity user.
	 *
	 *     # Update activity meta
	 *     $ wp bp activity meta update 123 description "Mary is an awesome activity user."
	 *     Success: Updated custom field 'description'.
	 *
	 *     # Delete activity meta
	 *     $ wp bp activity meta delete 123 description
	 *     Success: Deleted custom field.
	 *
	 * @since 2.0.0
	 */
	class Activity_Meta extends \WP_CLI\CommandWithMeta
	{
		/**
		 * Type of the meta.
		 *
		 * @var string
		 */
		protected $meta_type = 'activity';
		/**
		 * Wrapper method for add_metadata that can be overridden in sub classes.
		 *
		 * @param int    $object_id  ID of the object the metadata is for.
		 * @param string $meta_key   Metadata key to use.
		 * @param mixed  $meta_value Metadata value. Must be serializable if
		 *                           non-scalar.
		 * @param bool   $unique     Optional, default is false. Whether the
		 *                           specified metadata key should be unique for the
		 *                           object. If true, and the object already has a
		 *                           value for the specified metadata key, no change
		 *                           will be made.
		 *
		 * @return int|false The meta ID on success, false on failure.
		 */
		protected function add_metadata($object_id, $meta_key, $meta_value, $unique = false)
		{
		}
		/**
		 * Wrapper method for update_metadata that can be overridden in sub classes.
		 *
		 * @param int    $object_id  ID of the object the metadata is for.
		 * @param string $meta_key   Metadata key to use.
		 * @param mixed  $meta_value Metadata value. Must be serializable if
		 *                           non-scalar.
		 * @param mixed  $prev_value Optional. If specified, only update existing
		 *                           metadata entries with the specified value.
		 *                           Otherwise, update all entries.
		 *
		 * @return int|bool Meta ID if the key didn't exist, true on successful
		 *                  update, false on failure.
		 */
		protected function update_metadata($object_id, $meta_key, $meta_value, $prev_value = '')
		{
		}
		/**
		 * Wrapper method for get_metadata that can be overridden in sub classes.
		 *
		 * @param int    $object_id ID of the object the metadata is for.
		 * @param string $meta_key  Optional. Metadata key. If not specified,
		 *                          retrieve all metadata for the specified object.
		 * @param bool   $single    Optional, default is false. If true, return only
		 *                          the first value of the specified meta_key. This
		 *                          parameter has no effect if meta_key is not
		 *                          specified.
		 *
		 * @return mixed Single metadata value, or array of values.
		 */
		protected function get_metadata($object_id, $meta_key = '', $single = true)
		{
		}
		/**
		 * Wrapper method for delete_metadata that can be overridden in sub classes.
		 *
		 * @param int    $object_id  ID of the object metadata is for
		 * @param string $meta_key   Metadata key
		 * @param mixed $meta_value  Optional. Metadata value. Must be serializable
		 *                           if non-scalar. If specified, only delete
		 *                           metadata entries with this value. Otherwise,
		 *                           delete all entries with the specified meta_key.
		 *                           Pass `null, `false`, or an empty string to skip
		 *                           this check. For backward compatibility, it is
		 *                           not possible to pass an empty string to delete
		 *                           those entries with an empty string for a value.
		 *
		 * @return bool True on successful delete, false on failure.
		 */
		protected function delete_metadata($object_id, $meta_key, $meta_value = '')
		{
		}
		/**
		 * Check that the activity ID exists.
		 *
		 * @param int $object_id Object ID.
		 * @return int
		 */
		protected function check_object_id($object_id)
		{
		}
	}
	/**
	 * Manage BuddyPress activity favorites.
	 *
	 * ## EXAMPLES
	 *
	 *     # Add an activity item as a favorite for a user.
	 *     $ wp bp activity favorite add 100 500
	 *     Success: Activity item added as a favorite for the user.
	 *
	 *     # Add an activity item as a favorite for a user using user_login.
	 *     $ wp bp activity favorite create 100 user_test
	 *     Success: Activity item added as a favorite for the user.
	 *
	 * @since 1.5.0
	 */
	class Activity_Favorite extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'user_id', 'component', 'type', 'action', 'item_id', 'primary_link', 'secondary_item_id', 'date_recorded', 'hide_sitewide', 'is_spam'];
		/**
		 * Add an activity item as a favorite for a user.
		 *
		 * ## OPTIONS
		 *
		 * <activity-id>
		 * : ID of the activity.
		 *
		 * <user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLES
		 *
		 *     # Add an activity item as a favorite.
		 *     $ wp bp activity favorite add 100 500
		 *     Success: Activity item added as a favorite for the user.
		 *
		 *     # Add an activity item as a favorite using a user_login identifier.
		 *     $ wp bp activity favorite create 100 user_test
		 *     Success: Activity item added as a favorite for the user.
		 *
		 * @alias add
		 */
		public function create($args)
		{
		}
		/**
		 * Remove an activity item as a favorite for a user.
		 *
		 * ## OPTIONS
		 *
		 * <activity-id>
		 * : ID of the activity.
		 *
		 * <user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Remove an activity item as a favorite for a user.
		 *     $ wp bp activity favorite remove 100 500
		 *     Success: Activity item removed as a favorite for the user.
		 *
		 *     # Remove an activity item as a favorite for a user.
		 *     $ wp bp activity favorite delete 100 user_test --yes
		 *     Success: Activity item removed as a favorite for the user.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
		/**
		 * Get a user's favorite activity items.
		 *
		 * ## OPTIONS
		 *
		 * <user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--<field>=<value>]
		 * : One or more parameters to pass to \BP_Activity_Activity::get()
		 *
		 * [--count=<number>]
		 * : How many activity favorites to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 *  ---
		 * default: table
		 * options:
		 *   - table
		 *   - csv
		 *   - ids
		 *   - json
		 *   - count
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLE
		 *
		 *     # Get a user's favorite activity items.
		 *     $ wp bp activity favorite list 315
		 *
		 * @subcommand list
		 * @alias user-items
		 */
		public function list_($args, $assoc_args)
		{
		}
	}
	/**
	 * Manage BuddyPress Groups.
	 *
	 * ## EXAMPLES
	 *
	 *     # Create a public group.
	 *     $ wp bp group create --name="Totally Cool Group"
	 *     Success: Group (ID 5465) created: http://example.com/groups/totally-cool-group/
	 *
	 *     # Create a private group.
	 *     $ wp bp group create --name="Another Cool Group" --description="Cool Group" --creator-id=54 --status=private
	 *     Success: Group (ID 6454)6 created: http://example.com/groups/another-cool-group/
	 *
	 * @since 1.5.0
	 */
	class Group extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'name', 'slug', 'status', 'date_created'];
		/**
		 * Group ID Object Key
		 *
		 * @var string
		 */
		protected $obj_id_key = 'group_id';
		/**
		 * Group Object Type
		 *
		 * @var string
		 */
		protected $obj_type = 'group';
		/**
		 * Dependency check for this CLI command.
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Create a group.
		 *
		 * ## OPTIONS
		 *
		 * --name=<name>
		 * : Name of the group.
		 *
		 * [--slug=<slug>]
		 * : URL-safe slug for the group. If not provided, one will be generated automatically.
		 *
		 * [--description=<description>]
		 * : Group description.
		 *
		 * [--creator-id=<creator-id>]
		 * : ID of the group creator.
		 * ---
		 * default: 1
		 * ---
		 *
		 * [--slug=<slug>]
		 * : URL-safe slug for the group.
		 *
		 * [--status=<status>]
		 * : Group status.
		 * ---
		 * default: public
		 * options:
		 *   - public
		 *   - private
		 *   - hidden
		 * ---
		 *
		 * [--enable-forum=<enable-forum>]
		 * : Whether to enable legacy bbPress forums.
		 *
		 * [--date-created=<date-created>]
		 * : GMT timestamp, in Y-m-d h:i:s format.
		 *
		 * [--silent]
		 * : Whether to silent the group creation.
		 *
		 * [--porcelain]
		 * : Return only the new group id.
		 *
		 * ## EXAMPLES
		 *
		 *     # Create a public group.
		 *     $ wp bp group create --name="Totally Cool Group"
		 *     Success: Successfully created new group (ID 5465)
		 *
		 *     # Create a private group.
		 *     $ wp bp group create --name="Another Cool Group" --description="Cool Group" --creator-id=54 --status=private
		 *     Success: Successfully created new group (ID 6454)
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Generate random groups.
		 *
		 * ## OPTIONS
		 *
		 * [--count=<number>]
		 * : How many groups to generate.
		 * ---
		 * default: 100
		 * ---
		 *
		 * [--status=<status>]
		 * : The status of the generated groups.
		 * ---
		 * default: mixed
		 * options:
		 *   - public
		 *   - private
		 *   - hidden
		 *   - mixed
		 * ---
		 *
		 * [--creator-id=<creator-id>]
		 * : ID of the group creator.
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: progress
		 * options:
		 *   - progress
		 *   - ids
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Generate 50 random groups.
		 *     $ wp bp group generate --count=50
		 *     Generating groups  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 5 groups with mixed status.
		 *     $ wp bp group generate --count=5 --status=mixed
		 *     Generating groups  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 10 hidden groups with a specific creator.
		 *     $ wp bp group generate --count=10 --status=hidden --creator-id=30
		 *     Generating groups  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 5 random groups and output only the IDs.
		 *     $ wp bp group generate --count=5 --format=ids
		 *     70 71 72 73 74
		 */
		public function generate($args, $assoc_args)
		{
		}
		/**
		 * Get a group.
		 *
		 * ## OPTIONS
		 *
		 * <group-id>
		 * : Identifier for the group. Can be a numeric ID or the group slug.
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific fields.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - json
		 *   - csv
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Get group by ID.
		 *     $ wp bp group get 500
		 *
		 *     # Get group by group slug.
		 *     $ wp bp group get group-slug
		 *
		 * @alias see
		 */
		public function get($args, $assoc_args)
		{
		}
		/**
		 * Delete a group.
		 *
		 * ## OPTIONS
		 *
		 * <group-id>...
		 * : ID or IDs of group(s) to delete. Can be a numeric ID or the group slug.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete a group.
		 *     $ wp bp group delete 500 --yes
		 *     Success: Deleted group 500.
		 *
		 *     # Delete a group and its metadata.
		 *     $ wp bp group delete group-slug --yes
		 *     Success: Deleted group group-slug.
		 *
		 *     # Delete multiple groups.
		 *     $ wp bp group delete 55654 54564 --yes
		 *     Success: Deleted group 55654.
		 *     Success: Deleted group 54564.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
		/**
		 * Update a group.
		 *
		 * ## OPTIONS
		 *
		 * <group-id>...
		 * : Identifier(s) for the group(s). Can be a numeric ID or the group slug.
		 *
		 * [--<field>=<value>]
		 * : One or more fields to update. See groups_create_group()
		 *
		 * ## EXAMPLES
		 *
		 *     # Update a group.
		 *     $ wp bp group update 35 --description="What a cool group!" --name="Group of Cool People"
		 *     Success: Group updated.
		 */
		public function update($args, $assoc_args)
		{
		}
		/**
		 * Get a list of groups.
		 *
		 * ## OPTIONS
		 *
		 * [--<field>=<value>]
		 * : One or more parameters to pass. See groups_get_groups()
		 *
		 * [--fields=<fields>]
		 * : Fields to display.
		 *
		 * [--user-id=<user>]
		 * : Limit results to groups of which a specific user is a member. Accepts either a user_login or a numeric ID.
		 *
		 * [--orderby=<orderby>]
		 * : Sort order for results.
		 * ---
		 * default: name
		 * options:
		 *   - name
		 *   - date_created
		 *   - last_activity
		 *   - total_member_count
		 *
		 * [--count=<number>]
		 * : Number of group to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - ids
		 *   - count
		 *   - csv
		 *   - json
		 *   - yaml
		 * ---
		 *
		 * ## AVAILABLE FIELDS
		 *
		 * These fields will be displayed by default for each group:
		 *
		 * * id
		 * * name
		 * * slug
		 * * status
		 * * date_created
		 *
		 * ## EXAMPLES
		 *
		 *     # List groups and get the count.
		 *     $ wp bp group list --format=count
		 *     100
		 *
		 *     # List groups and get the IDs.
		 *     $ wp bp group list --format=ids
		 *     70 71 72 73 74
		 *
		 *     # List groups.
		 *     $ wp bp group list
		 *     +----+------------+---------+---------+---------------------+
		 *     | id | name       | slug    | status  | date_created        |
		 *     +----+------------+---------+---------+---------------------+
		 *     | 1  | Group - #0 | group-0 | hidden  | 2022-07-04 02:12:02 |
		 *     | 2  | Group - #1 | group-1 | hidden  | 2022-07-04 02:12:02 |
		 *     | 4  | Group - #3 | group-3 | private | 2022-07-04 02:12:02 |
		 *     | 5  | Group - #4 | group-4 | private | 2022-07-04 02:12:02 |
		 *     | 3  | Group – #2 | group-2 | public  | 2022-07-04 02:12:02 |
		 *     +----+------------+---------+---------+---------------------+
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Gets a randon group status.
		 *
		 * @since 1.5.0
		 *
		 * @param string $status Group status.
		 * @return string
		 */
		protected function random_group_status($status)
		{
		}
	}
	/**
	 * Manage BuddyPress Sitewide Notices.
	 *
	 * ## EXAMPLES
	 *
	 *   # Get a sitewide notice.
	 *   $ wp bp notice get 500
	 *   +-----------+---------------------+
	 *   | Field     | Value               |
	 *   +-----------+---------------------+
	 *   | id        | 4                   |
	 *   | subject   | Important message   |
	 *   | message   | Let's talk!         |
	 *   | date_sent | 2023-01-11 12:47:00 |
	 *   | is_active | 1                   |
	 *   +-----------+---------------------+
	 *
	 *   # Get a sitewide notice in JSON format.
	 *   $ wp bp notice get 56 --format=json
	 *   {"id":4,"subject":"Important message","message":"Let's talk!","date_sent":"2023-01-11 12:47:00","is_active":1}
	 *
	 *   $ wp bp notice delete 55654 54564 --yes
	 *   Success: Deleted notice 55654.
	 *   Success: Deleted notice 54564.
	 */
	class Sitewide_Notice extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'subject', 'message', 'is_active', 'date_sent'];
		/**
		 * Dependency check for this CLI command.
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Create a sitewide notice.
		 *
		 * ## OPTIONS
		 *
		 * --subject=<subject>
		 * : Notice subject text.
		 *
		 * --message=<message>
		 * : Notice message text.
		 *
		 * [--silent]
		 * : Whether to silent the notice creation.
		 *
		 * [--porcelain]
		 * : Output the new notice id only.
		 *
		 * ## EXAMPLES
		 *
		 *    # Create a sitewide notice.
		 *    $ wp bp notice create --subject=Hello --message=Folks!
		 *    Success: Successfully created new sitewide notice. (ID #5464)
		 *
		 *    # Create a sitewide notice and return its ID.
		 *    $ wp bp notice create --subject=Hello --message=Folks! --porcelain
		 *    36565
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Get specific sitewide notice.
		 *
		 * ## OPTIONS
		 *
		 * <notice-id>
		 * : Identifier for the notice.
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific fields.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 *  ---
		 * default: table
		 * options:
		 *   - table
		 *   - json
		 *   - csv
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Get a sitewide notice.
		 *     $ wp bp notice get 500
		 *     +-----------+---------------------+
		 *     | Field     | Value               |
		 *     +-----------+---------------------+
		 *     | id        | 4                   |
		 *     | subject   | Important message   |
		 *     | message   | Let's talk!         |
		 *     | date_sent | 2023-01-11 12:47:00 |
		 *     | is_active | 1                   |
		 *     +-----------+---------------------+
		 *
		 *     # Get a sitewide notice in JSON format.
		 *     $ wp bp notice get 56 --format=json
		 *     {"id":4,"subject":"Important message","message":"Let's talk!","date_sent":"2023-01-11 12:47:00","is_active":1}
		 *
		 * @alias see
		 */
		public function get($args, $assoc_args)
		{
		}
		/**
		 * Delete sitewide notice(s).
		 *
		 * ## OPTIONS
		 *
		 * <notice-id>...
		 * : ID or IDs of sitewide notices to delete.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete a sitewide notice.
		 *     $ wp bp notice delete 520 --yes
		 *     Success: Sitewide notice deleted 520.
		 *
		 *     # Delete multiple sitewide notices.
		 *     $ wp bp notice delete 55654 54564 --yes
		 *     Success: Sitewide notice deleted 55654.
		 *     Success: Sitewide notice deleted 54564.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
		/**
		 * Activate a sitewide notice.
		 *
		 * ## OPTIONS
		 *
		 * <notice-id>
		 * : Identifier for the notice.
		 *
		 * ## EXAMPLE
		 *
		 *     $ wp bp notice activate 123
		 *     Success: Sitewide notice activated.
		 */
		public function activate($args)
		{
		}
		/**
		 * Deactivate a sitewide notice.
		 *
		 * ## OPTIONS
		 *
		 * <notice-id>
		 * : Identifier for the notice.
		 *
		 * ## EXAMPLE
		 *
		 *     $ wp bp notice deactivate 123
		 *     Success: Sitewide notice has been deactivated.
		 */
		public function deactivate($args)
		{
		}
		/**
		 * Get a list of sitewide notices.
		 *
		 * ## OPTIONS
		 *
		 * [--fields=<fields>]
		 * : Fields to display.
		 *
		 * [--count=<number>]
		 * : How many notices to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - ids
		 *   - count
		 *   - csv
		 *   - json
		 *   - yaml
		 * ---
		 * ## EXAMPLES
		 *
		 *     # List all sitewide notices, and output only the IDs.
		 *     $ wp bp notice list --format=ids
		 *     15 25 34 37 198
		 *
		 *     # List all sitewide notices, and output the count.
		 *     $ wp bp notice list --format=count
		 *     10
		 *
		 *     # List all sitewide notices, and output the IDs.
		 *     $ wp bp notice list --fields=id
		 *     | id     |
		 *     | 66546  |
		 *     | 54554  |
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
	}
	/**
	 * Scaffold BuddyPress unit tests.
	 *
	 * ## EXAMPLE
	 *
	 *     # Scaffold BuddyPress specific tests.
	 *     $ wp bp scaffold tests sample-plugin
	 *     Success: Created BuddyPress test files.
	 *
	 * @since 2.0
	 */
	class Scaffold extends \Scaffold_Command
	{
		/**
		 * Default dependency check for a BuddyPress CLI command.
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Plugin scaffold command.
		 *
		 * ## OPTIONS
		 *
		 * <slug>
		 * : The slug of the BuddyPress plugin.
		 *
		 * [--force]
		 * : Whether to overwrite files.
		 *
		 * ## EXAMPLES
		 *
		 *     # Scaffold BuddyPress specific tests.
		 *     $ wp bp scaffold plugin sample-test
		 *     Success: Created BuddyPress test files.
		 *
		 *     # Scaffold BuddyPress specific tests.
		 *     $ wp bp scaffold tests another-sample-test
		 *     Success: Created BuddyPress test files.
		 *
		 * @subcommand tests
		 */
		public function plugin($args, $assoc_args)
		{
		}
		/**
		 * Checks that the `$target_dir` is a child directory of the WP themes or plugins directory, depending on `$type`.
		 *
		 * @param string $type       "theme" or "plugin"
		 * @param string $target_dir The theme/plugin directory to check.
		 * @return null|string Returns null on success, error message on error.
		 */
		public function check_target_directory($target_dir)
		{
		}
		/**
		 * Canonicalizes a path.
		 *
		 * @param string $path Path.
		 * @return string
		 */
		public static function canonicalize_path($path)
		{
		}
		/**
		 * Gets the template path based on installation type.
		 *
		 * @return string Template path.
		 */
		public static function get_template_path($template)
		{
		}
	}
	/**
	 * Manage BuddyPress Members.
	 *
	 * ## EXAMPLES
	 *
	 *   # Generate 50 members.
	 *   $ wp bp member generate --count=50
	 *
	 *   # Add meta to every generated users.
	 *   $ wp user generate --format=ids --count=3 | xargs -d ' ' -I % wp user meta add % foo bar
	 *   Success: Added custom field.
	 *   Success: Added custom field.
	 *   Success: Added custom field.
	 *
	 * @since 1.0.0
	 */
	class Member extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Generate BuddyPress members. See documentation for `wp_user_generate`.
		 *
		 * ## OPTIONS
		 *
		 * [--count=<number>]
		 * : How many members to generate.
		 * ---
		 * default: 100
		 * ---
		 *
		 * [--role=<role>]
		 * : The role of the generated users. Defaults to role from WP.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: progress
		 * options:
		 *   - progress
		 *   - ids
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Generate 50 members.
		 *     $ wp bp member generate --count=50
		 *     Generating users  100% [======================] 0:00 / 0:00
		 *
		 *     # Add meta to every generated users.
		 *     $ wp user generate --format=ids --count=3 | xargs -d ' ' -I % wp user meta add % foo bar
		 *     Success: Added custom field.
		 *     Success: Added custom field.
		 *     Success: Added custom field.
		 */
		public function generate($args, $assoc_args)
		{
		}
		/**
		 * Update the last user activity with a random date.
		 *
		 * @since 1.0
		 *
		 * @param int $user_id User ID.
		 */
		public static function update_user_last_activity_random($user_id)
		{
		}
	}
	/**
	 * Manage BuddyPress group invites.
	 *
	 * ## EXAMPLES
	 *
	 *     # Invite a member to a group.
	 *     $ wp bp group invite add --group-id=40 --user-id=10 --inviter-id=1331
	 *     Success: Member invited to the group.
	 *
	 *     # Invite a member to a group.
	 *     $ wp bp group invite create --group-id=40 --user-id=user_slug --inviter-id=804
	 *     Success: Member invited to the group.
	 *
	 * @since 1.5.0
	 */
	class Group_Invite extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Group ID Object Key
		 *
		 * @var string
		 */
		protected $obj_id_key = 'group_id';
		/**
		 * Group Object Type
		 *
		 * @var string
		 */
		protected $obj_type = 'group';
		/**
		 * Invite a member to a group.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * --inviter-id=<user>
		 * : Identifier for the inviter. Accepts either a user_login or a numeric ID.
		 *
		 * [--message=<value>]
		 * : Message to send with the invitation.
		 *
		 * [--porcelain]
		 * : Return only the invitation id.
		 *
		 * [--silent]
		 * : Whether to silent the invite creation.
		 *
		 * ## EXAMPLES
		 *
		 *     # Invite a member to a group.
		 *     $ wp bp group invite add --group-id=40 --user-id=10 --inviter-id=1331
		 *     Success: Member invited to the group.
		 *
		 *     # Invite a member to a group.
		 *     $ wp bp group invite create --group-id=40 --user-id=user_slug --inviter-id=804
		 *     Success: Member invited to the group.
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Uninvite a user from a group.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLES
		 *
		 *     # Uninvite a user from a group.
		 *     $ wp bp group invite uninvite --group-id=3 --user-id=10
		 *     Success: User uninvited from the group.
		 *
		 *     # Uninvite a user from a group.
		 *     $ wp bp group invite uninvite --group-id=foo --user-id=admin
		 *     Success: User uninvited from the group.
		 */
		public function uninvite($args, $assoc_args)
		{
		}
		/**
		 * Get a list of invitations from a group.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--count=<number>]
		 * : How many invitations to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - csv
		 *   - ids
		 *   - json
		 *   - count
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLE
		 *
		 *     # Get a list of invitations from a group.
		 *     $ wp bp group invite list --group-id=56 --user-id=30
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Generate group invitations.
		 *
		 * ## OPTIONS
		 *
		 * [--count=<number>]
		 * : How many group invitations to generate.
		 * ---
		 * default: 100
		 * ---
		 *
		 * [--user-id=<user>]
		 * : ID of the first user. Accepts either a user_login or a numeric ID.
		 *
		 * [--inviter-id=<user>]
		 * : ID for the inviter. Accepts either a user_login or a numeric ID.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: progress
		 * options:
		 *   - progress
		 *   - ids
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Generate random group invitations.
		 *     $ wp bp group invite generate --count=50
		 *     Generating group invitations  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate random group invitations with a specific user.
		 *     $ wp bp group invite generate --inviter-id=121 --count=5
		 *     Generating group invitations  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 5 random group invitations and output only the IDs.
		 *     $ wp bp group invite generate --count=5 --format=ids
		 *     70 71 72 73 74
		 */
		public function generate($args, $assoc_args)
		{
		}
		/**
		 * Accept a group invitation.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLES
		 *
		 *     # Accept a group invitation.
		 *     $ wp bp group invite accept --group-id=3 --user-id=10
		 *     Success: User is now a "member" of the group.
		 *
		 *     # Accept a group invitation.
		 *     $ wp bp group invite accept --group-id=foo --user-id=admin
		 *     Success: User is now a "member" of the group.
		 */
		public function accept($args, $assoc_args)
		{
		}
		/**
		 * Reject a group invitation.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLES
		 *
		 *     # Reject a group invitation.
		 *     $ wp bp group invite reject --group-id=3 --user-id=10
		 *     Success: Member invitation rejected.
		 *
		 *     # Reject a group invitation.
		 *     $ wp bp group invite reject --group-id=foo --user-id=admin
		 *     Success: Member invitation rejected.
		 */
		public function reject($args, $assoc_args)
		{
		}
		/**
		 * Delete a group invitation.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete a group invitation.
		 *     $ wp bp group invite delete --group-id=3 --user-id=10 --yes
		 *     Success: Group invitation deleted.
		 *
		 *     # Delete a group invitation.
		 *     $ wp bp group invite delete --group-id=foo --user-id=admin --yes
		 *     Success: Group invitation deleted.
		 *
		 * @alias delete
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
	}
	/**
	 * Manage BuddyPress group members.
	 *
	 * ## EXAMPLES
	 *
	 *     # Add a user to a group as a member.
	 *     $ wp bp group member add --group-id=3 --user-id=10
	 *     Success: Added user #3 to group #3 as member.
	 *
	 *     # Add a user to a group as a mod.
	 *     $ wp bp group member create --group-id=bar --user-id=20 --role=mod
	 *     Success: Added user #20 to group #45 as mod.
	 *
	 * @since 1.5.0
	 */
	class Group_Member extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Group ID Object Key
		 *
		 * @var string
		 */
		protected $obj_id_key = 'group_id';
		/**
		 * Group Object Type
		 *
		 * @var string
		 */
		protected $obj_type = 'group';
		/**
		 * Add a member to a group.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--role=<role>]
		 * : Group member role (member, mod, admin).
		 * ---
		 * default: member
		 * options:
		 *   - member
		 *   - mod
		 *   - admin
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Add a user to a group as a member.
		 *     $ wp bp group member add --group-id=3 --user-id=10
		 *     Success: Added user #3 to group #3 as member.
		 *
		 *     # Add a user to a group as a moderator.
		 *     $ wp bp group member create --group-id=bar --user-id=20 --role=mod
		 *     Success: Added user #20 to group #45 as mod.
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Remove a member from a group.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLES
		 *
		 *     # Remove a member from a group.
		 *     $ wp bp group member remove --group-id=3 --user-id=10
		 *     Success: Member #10 removed from the group #3.
		 *
		 *     # Remove a member from a group.
		 *     $ wp bp group member delete --group-id=foo --user-id=admin
		 *     Success: Member #545 removed from the group #12.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
		/**
		 * Get a list of group memberships.
		 *
		 * This command can be used to fetch a list of a user's groups (using the --user-id
		 * parameter) or a group's members (using the --group-id flag).
		 *
		 * ## OPTIONS
		 *
		 * <group-id>
		 * : Identifier for the group. Can be a numeric ID or the group slug.
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific signup fields.
		 *
		 * [--<field>=<value>]
		 * : One or more parameters to pass. See groups_get_group_members()
		 *
		 * [--role=<role>]
		 * : Limit the output to members with a specific role.
		 * ---
		 * default: members
		 * options:
		 *  - members
		 *  - mod
		 *  - admin
		 *  - banned
		 * ---
		 *
		 * [--count=<number>]
		 * : How many members to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - csv
		 *   - ids
		 *   - json
		 *   - count
		 *   - yaml
		 * ---
		 *
		 * ## AVAILABLE FIELDS
		 *
		 * These fields will be displayed by default for each group member:
		 *
		 * * id
		 * * user_login
		 * * fullname
		 * * date_modified
		 * * role
		 *
		 * ## EXAMPLE
		 *
		 *     # Get a list of group members.
		 *     $ wp bp group member list 3
		 *     +---------+------------+----------+---------------------+-------+
		 *     | id      | user_login | fullname | date_modified       | role  |
		 *     +---------+------------+----------+---------------------+-------+
		 *     | 1       | user       | User     | 2022-07-04 02:12:02 | admin |
		 *     +---------+------------+----------+---------------------+-------+
		 *
		 *     # Get a list of group members and get the count.
		 *     $ wp bp group member list 65465 --format=count
		 *     100
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Promote a member to a new status within a group.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * --role=<role>
		 * : Group role to promote the member.
		 * ---
		 * options:
		 *   - mod
		 *   - admin
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Promote a member to a new role.
		 *     $ wp bp group member promote --group-id=3 --user-id=10 --role=admin
		 *     Success: Member promoted to new role successfully.
		 *
		 *     # Promote a member to a new role.
		 *     $ wp bp group member promote --group-id=foo --user-id=admin --role=mod
		 *     Success: Member promoted to new role successfully.
		 */
		public function promote($args, $assoc_args)
		{
		}
		/**
		 * Demote user to the 'member' status.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLES
		 *
		 *     # Demote a user to the "member" status using numeric IDs.
		 *     $ wp bp group member demote --group-id=3 --user-id=10
		 *     Success: User demoted to the "member" status.
		 *
		 *     # Demote a user to the "member" status using slugs.
		 *     $ wp bp group member demote --group-id=foo --user-id=admin
		 *     Success: User demoted to the "member" status.
		 *
		 *     # Demote a user not part of the group.
		 *     $ wp bp group member demote --group-id=foo --user-id=admin
		 *     Error: User is not a member of the group.
		 */
		public function demote($args, $assoc_args)
		{
		}
		/**
		 * Ban a member from a group.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLES
		 *
		 *     # Ban a member from a group.
		 *     $ wp bp group member ban --group-id=3 --user-id=10
		 *     Success: Member banned from the group.
		 *
		 *     # Ban a member from a group.
		 *     $ wp bp group member ban --group-id=foo --user-id=admin
		 *     Success: Member banned from the group.
		 */
		public function ban($args, $assoc_args)
		{
		}
		/**
		 * Unban a member from a group.
		 *
		 * ## OPTIONS
		 *
		 * --group-id=<group>
		 * : Identifier for the group. Accepts either a slug or a numeric ID.
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLES
		 *
		 *     # Unban a member from a group.
		 *     $ wp bp group member unban --group-id=3 --user-id=10
		 *     Success: Member unbanned from the group.
		 *
		 *     # Unban a member from a group.
		 *     $ wp bp group member unban --group-id=foo --user-id=admin
		 *     Success: Member unbanned from the group.
		 */
		public function unban($args, $assoc_args)
		{
		}
	}
	/**
	 * Fetch a BuddyPress group based on one of its attributes.
	 */
	class Group_Fetcher extends \WP_CLI\Fetchers\Base
	{
		/**
		 * @var string $msg Error message to use when invalid data is provided.
		 */
		protected $msg = 'Could not find the group with ID %d.';
		/**
		 * Get a group ID from its identifier (ID or slug).
		 *
		 * @param int|string $arg Group ID or slug.
		 * @return BP_Groups_Group|bool
		 */
		public function get($arg)
		{
		}
	}
	/**
	 * Adds, updates, deletes, and lists group custom fields.
	 *
	 * ## EXAMPLES
	 *
	 *     # Set group meta
	 *     $ wp bp group meta set 123 description "Mary is a Group user."
	 *     Success: Updated custom field 'description'.
	 *
	 *     # Get group meta
	 *     $ wp bp group meta get 123 description
	 *     Mary is a Group user.
	 *
	 *     # Update group meta
	 *     $ wp bp group meta update 123 description "Mary is an awesome Group user."
	 *     Success: Updated custom field 'description'.
	 *
	 *     # List group meta.
	 *     $ wp bp group meta list 123
	 *
	 *     # Delete group meta
	 *     $ wp bp group meta delete 123 description
	 *     Success: Deleted custom field.
	 *
	 * @since 2.0.0
	 */
	class Group_Meta extends \WP_CLI\CommandWithMeta
	{
		protected $meta_type = 'group';
		/**
		 * Wrapper method for add_metadata that can be overridden in sub classes.
		 *
		 * @param int    $object_id  ID of the object the metadata is for.
		 * @param string $meta_key   Metadata key to use.
		 * @param mixed  $meta_value Metadata value. Must be serializable if
		 *                           non-scalar.
		 * @param bool   $unique     Optional, default is false. Whether the
		 *                           specified metadata key should be unique for the
		 *                           object. If true, and the object already has a
		 *                           value for the specified metadata key, no change
		 *                           will be made.
		 *
		 * @return int|false The meta ID on success, false on failure.
		 */
		protected function add_metadata($object_id, $meta_key, $meta_value, $unique = false)
		{
		}
		/**
		 * Wrapper method for update_metadata that can be overridden in sub classes.
		 *
		 * @param int    $object_id  ID of the object the metadata is for.
		 * @param string $meta_key   Metadata key to use.
		 * @param mixed  $meta_value Metadata value. Must be serializable if
		 *                           non-scalar.
		 * @param mixed  $prev_value Optional. If specified, only update existing
		 *                           metadata entries with the specified value.
		 *                           Otherwise, update all entries.
		 *
		 * @return int|bool Meta ID if the key didn't exist, true on successful
		 *                  update, false on failure.
		 */
		protected function update_metadata($object_id, $meta_key, $meta_value, $prev_value = '')
		{
		}
		/**
		 * Wrapper method for get_metadata that can be overridden in sub classes.
		 *
		 * @param int    $object_id ID of the object the metadata is for.
		 * @param string $meta_key  Optional. Metadata key. If not specified,
		 *                          retrieve all metadata for the specified object.
		 * @param bool   $single    Optional, default is false. If true, return only
		 *                          the first value of the specified meta_key. This
		 *                          parameter has no effect if meta_key is not
		 *                          specified.
		 *
		 * @return mixed Single metadata value, or array of values.
		 */
		protected function get_metadata($object_id, $meta_key = '', $single = true)
		{
		}
		/**
		 * Wrapper method for delete_metadata that can be overridden in sub classes.
		 *
		 * @param int    $object_id  ID of the object metadata is for
		 * @param string $meta_key   Metadata key
		 * @param mixed $meta_value  Optional. Metadata value. Must be serializable
		 *                           if non-scalar. If specified, only delete
		 *                           metadata entries with this value. Otherwise,
		 *                           delete all entries with the specified meta_key.
		 *                           Pass `null, `false`, or an empty string to skip
		 *                           this check. For backward compatibility, it is
		 *                           not possible to pass an empty string to delete
		 *                           those entries with an empty string for a value.
		 *
		 * @return bool True on successful delete, false on failure.
		 */
		protected function delete_metadata($object_id, $meta_key, $meta_value = '')
		{
		}
		/**
		 * Check that the group ID exists.
		 *
		 * @param int $object_id Object ID.
		 * @return int
		 */
		protected function check_object_id($object_id)
		{
		}
	}
	/**
	 * Manage BuddyPress Friends.
	 *
	 * ## EXAMPLES
	 *
	 *     $ wp bp friend create user1 another_use
	 *     Success: Friendship successfully created.
	 *
	 *     $ wp bp friend create user1 another_use --force-accept
	 *     Success: Friendship successfully created.
	 *
	 * @since 1.6.0
	 */
	class Friends extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'initiator_user_id', 'friend_user_id', 'is_confirmed', 'is_limited'];
		/**
		 * Dependency check for this CLI command.
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Create a new friendship.
		 *
		 * ## OPTIONS
		 *
		 * <initiator>
		 * : ID of the user who is sending the friendship request. Accepts either a user_login or a numeric ID.
		 *
		 * <friend>
		 * : ID of the user whose friendship is being requested. Accepts either a user_login or a numeric ID.
		 *
		 * [--force-accept]
		 * : Whether to force acceptance.
		 *
		 * [--silent]
		 * : Whether to silent the message creation.
		 *
		 * [--porcelain]
		 * : Return only the friendship id.
		 *
		 * ## EXAMPLES
		 *
		 *     # Create a new friendship.
		 *     $ wp bp friend create user1 another_use
		 *     Success: Friendship successfully created.
		 *
		 *     # Create a new friendship, forcing acceptance.
		 *     $ wp bp friend create user1 another_use --force-accept
		 *     Success: Friendship successfully created.
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Remove a friendship.
		 *
		 * ## OPTIONS
		 *
		 * <initiator>
		 * : ID of the friendship initiator. Accepts either a user_login or a numeric ID.
		 *
		 * <friend>
		 * : ID of the friend user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLE
		 *
		 *     # Remove a friendship.
		 *     $ wp bp friend remove user_1 user_2
		 *     Success: Friendship successfully removed.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args)
		{
		}
		/**
		 * Mark a friendship request as accepted.
		 *
		 * ## OPTIONS
		 *
		 * <friendship>...
		 * : ID(s) of the friendship(s).
		 *
		 * ## EXAMPLES
		 *
		 *     $ wp bp friend accept-invitation 2161
		 *     Success: Friendship successfully accepted.
		 *
		 *     $ wp bp friend accept 2161
		 *     Success: Friendship successfully accepted.
		 *
		 * @alias accept-invitation
		 */
		public function accept($args, $assoc_args)
		{
		}
		/**
		 * Mark a friendship request as rejected.
		 *
		 * ## OPTIONS
		 *
		 * <friendship>...
		 * : ID(s) of the friendship(s).
		 *
		 * ## EXAMPLES
		 *
		 *     $ wp bp friend reject-invitation 2161
		 *     Success: Friendship successfully accepted.
		 *
		 *     $ wp bp friend reject 2161 151 2121
		 *     Success: Friendship successfully accepted.
		 *
		 * @alias reject-invitation
		 */
		public function reject($args, $assoc_args)
		{
		}
		/**
		 * Check whether two users are friends.
		 *
		 * ## OPTIONS
		 *
		 * <user>
		 * : ID of the first user. Accepts either a user_login or a numeric ID.
		 *
		 * <friend>
		 * : ID of the other user. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLES
		 *
		 *     $ wp bp friend check 2161 65465
		 *     Success: Yes, they are friends.
		 *
		 *     $ wp bp friend see 2121 65456
		 *     Success: Yes, they are friends.
		 *
		 * @alias see
		 */
		public function check($args)
		{
		}
		/**
		 * Get a list of user's friends.
		 *
		 * ## OPTIONS
		 *
		 * <user>
		 * : ID of the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--fields=<fields>]
		 * : Fields to display.
		 *
		 * [--count=<number>]
		 * : How many user's friends to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - ids
		 *   - count
		 *   - csv
		 *   - json
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # List a user's friends and get the count.
		 *     $ wp bp friend list 65465 --format=count
		 *     100
		 *
		 *     # List a user's friends and get the IDs.
		 *     $ wp bp friend list 2422 --format=ids
		 *     70 71 72 73 74
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Generate random friendships.
		 *
		 * ## OPTIONS
		 *
		 * [--initiator=<user>]
		 * : ID of the first user. Accepts either a user_login or a numeric ID.
		 *
		 * [--friend=<user>]
		 * : ID of the second user. Accepts either a user_login or a numeric ID.
		 *
		 * [--count=<number>]
		 * : How many friendships to generate.
		 * ---
		 * default: 100
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: progress
		 * options:
		 *   - progress
		 *   - ids
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Generate 50 random friendships.
		 *     $ wp bp friend generate --count=50
		 *     Generating friendships  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 50 friendships with a specific user.
		 *     $ wp bp friend generate --initiator=121 --count=50
		 *     Generating friendships  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 5 random friendships and output only the IDs.
		 *     $ wp bp friend generate --count=5 --format=ids
		 *     70 71 72 73 74
		 */
		public function generate($args, $assoc_args)
		{
		}
	}
	/**
	 * Manage XProfile Fields.
	 *
	 * @since 1.5.0
	 */
	class XProfile_Field extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * XProfile object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'name', 'description', 'type', 'group_id', 'is_required'];
		/**
		 * Get a list of XProfile fields.
		 *
		 * ## OPTIONS
		 *
		 * [--<field>=<value>]
		 * : One or more parameters to pass. See bp_xprofile_get_groups()
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 *  ---
		 * default: table
		 * options:
		 *   - table
		 *   - csv
		 *   - ids
		 *   - json
		 *   - count
		 *   - yaml
		 * ---
		 *
		 *  * ## AVAILABLE FIELDS
		 *
		 * These fields will be displayed by default for each field:
		 *
		 * * id
		 * * name
		 * * description
		 * * type
		 * * group_id
		 * * is_required
		 *
		 * ## EXAMPLE
		 *
		 *     # List XProfile fields.
		 *     $ wp bp xprofile field list
		 *     +----+------+-------------+---------+----------+-------------+
		 *     | id | name | description | type    | group_id | is_required |
		 *     +----+------+-------------+---------+----------+-------------+
		 *     | 1  | Name |             | textbox | 1        | 1           |
		 *     +----+------+-------------+---------+----------+-------------+
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Create a XProfile field.
		 *
		 * ## OPTIONS
		 *
		 * --field-group-id=<field-group-id>
		 * : ID of the field group where the new field will be created.
		 *
		 * --name=<name>
		 * : Name of the new field.
		 *
		 * [--type=<type>]
		 * : Field type.
		 * ---
		 * default: textbox
		 * ---
		 *
		 * [--silent]
		 * : Whether to silent the XProfile field creation.
		 *
		 * [--porcelain]
		 * : Output just the new field id.
		 *
		 * ## EXAMPLES
		 *
		 *     # Create a XProfile field.
		 *     $ wp bp xprofile field create --type=checkbox --field-group-id=508 --name="Field Name"
		 *     Success: Created XProfile field "Field Name" (ID 24564).
		 *
		 *     # Create a XProfile field.
		 *     $ wp bp xprofile field add --field-group-id=165 --name="Another Field"
		 *     Success: Created XProfile field "Another Field" (ID 5465).
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Get an XProfile field.
		 *
		 * ## OPTIONS
		 *
		 * <field-id>
		 * : Identifier for the field. Accepts either the name of the field or a numeric ID.
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific fields.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 *  ---
		 * default: table
		 * options:
		 *   - table
		 *   - json
		 *   - csv
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Get a xprofile field.
		 *     $ wp bp xprofile field get 500
		 *
		 *     # Get a xprofile field in JSON format.
		 *     $ wp bp xprofile field see 56 --format=json
		 *
		 * @alias see
		 */
		public function get($args, $assoc_args)
		{
		}
		/**
		 * Delete an XProfile field.
		 *
		 * ## OPTIONS
		 *
		 * <field-id>...
		 * : ID or IDs for the field. Accepts either the name of the field or a numeric ID.
		 *
		 * [--delete-data]
		 * : Delete user data for the field as well.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete a field.
		 *     $ wp bp xprofile field delete 500 --yes
		 *     Success: Deleted XProfile field "Field Name" (ID 500).
		 *
		 *     # Delete a field and its data.
		 *     $ wp bp xprofile field remove 458 --delete-data --yes
		 *     Success: Deleted XProfile field "Another Field Name" (ID 458).
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
	}
	/**
	 * Manage BuddyPress Components.
	 *
	 * ## EXAMPLES
	 *
	 *     # Activate a component.
	 *     $ wp bp component activate groups
	 *     Success: The Groups component has been activated.
	 *
	 *     # Deactive a component.
	 *     $ wp bp component deactivate groups
	 *     Success: The Groups component has been deactivated.
	 *
	 *     # List required components.
	 *     $ wp bp component list --type=required
	 *     +--------+---------+--------+------------------------+--------------------------------------------+
	 *     | number | id      | status | title                  | description                                |
	 *     +--------+---------+--------+------------------------------------------+--------------------------+
	 *     | 1      | core    | Active | BuddyPress Core        | It's what makes <del>time travel</del>     |
	 *     |        |         |        |                        | BuddyPress possible!                       |
	 *     | 2      | members | Active | Community Members      | Everything in a BuddyPress community       |
	 *     |        |         |        |                        | revolves around its members.               |
	 *     +--------+---------+--------+------------------------------------------+--------------------------+
	 *
	 * @since 1.6.0
	 */
	class Components extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['number', 'id', 'status', 'title', 'description'];
		/**
		 * Activate a component.
		 *
		 * ## OPTIONS
		 *
		 * <component>
		 * : Name of the component to activate.
		 *
		 * ## EXAMPLE
		 *
		 *     # Activate a component.
		 *     $ wp bp component activate groups
		 *     Success: The Groups component has been activated.
		 */
		public function activate($args)
		{
		}
		/**
		 * Deactivate a component.
		 *
		 * ## OPTIONS
		 *
		 * <component>
		 * : Name of the component to deactivate.
		 *
		 * ## EXAMPLE
		 *
		 *     # Deactive a component.
		 *     $ wp bp component deactivate groups
		 *     Success: The Groups component has been deactivated.
		 */
		public function deactivate($args)
		{
		}
		/**
		 * Get a list of components.
		 *
		 * ## OPTIONS
		 *
		 * [--type=<type>]
		 * : Type of the component (all, optional, retired, required).
		 * ---
		 * default: all
		 * options:
		 *   - all
		 *   - optional
		 *   - retired
		 *   - required
		 * ---
		 *
		 * [--status=<status>]
		 * : Status of the component (all, active, inactive).
		 * ---
		 * default: all
		 * options:
		 *   - all
		 *   - active
		 *   - inactive
		 * ---
		 *
		 * [--fields=<fields>]
		 * : Fields to display (id, title, description).
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - csv
		 *   - ids
		 *   - json
		 *   - count
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # List components and get the count.
		 *     $ wp bp component list --format=count
		 *     10
		 *
		 *     # List components and get the ids.
		 *     $ wp bp component list --format=ids
		 *     core members xprofile settings friends messages activity notifications groups
		 *
		 *     # List components.
		 *     $ wp bp component list
		 *     +--------+---------------+--------+--------------------+---------------------------------------------------------------------------------+
		 *     | number | id            | status | title              | description                                                                     |
		 *     +--------+---------------+--------+--------------------+---------------------------------------------------------------------------------+
		 *     | 1      | core          | active | BuddyPress Core    | It‘s what makes <del>time travel</del> BuddyPress possible!                     |
		 *     | 2      | members       | active | Community Members  | Everything in a BuddyPress community revolves around its members.               |
		 *     | 3      | xprofile      | active | Extended Profiles  | Customize your community with fully editable profile fields that allow your use |
		 *     |        |               |        |                    | rs to describe themselves.                                                      |
		 *     | 4      | settings      | active | Account Settings   | Allow your users to modify their account and notification settings directly fro |
		 *     |        |               |        |                    | m within their profiles.                                                        |
		 *     | 5      | friends       | active | Friend Connections | Let your users make connections so they can track the activity of others and fo |
		 *     |        |               |        |                    | cus on the people they care about the most.                                     |
		 *     | 6      | messages      | active | Private Messaging  | Allow your users to talk to each other directly and in private. Not just limite |
		 *     |        |               |        |                    | d to one-on-one discussions, messages can be sent between any number of members |
		 *     |        |               |        |                    | .                                                                               |
		 *     | 7      | activity      | active | Activity Streams   | Global, personal, and group activity streams with threaded commenting, direct p |
		 *     |        |               |        |                    | osting, favoriting, and @mentions, all with full RSS feed and email notificatio |
		 *     |        |               |        |                    | n support.                                                                      |
		 *     | 8      | notifications | active | Notifications      | Notify members of relevant activity with a toolbar bubble and/or via email, and |
		 *     |        |               |        |                    |  allow them to customize their notification settings.                           |
		 *     | 9      | groups        | active | User Groups        | Groups allow your users to organize themselves into specific public, private or |
		 *     |        |               |        |                    |  hidden sections with separate activity streams and member listings.            |
		 *     | 10     | blogs         | active | Site Tracking      | Record activity for new sites, posts, and comments across your network.         |
		 *     +--------+---------------+--------+--------------------+---------------------------------------------------------------------------------+
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Does the component exist?
		 *
		 * @param string $component_key Component key.
		 * @return bool
		 */
		protected function component_exists($component_key)
		{
		}
		/**
		 * Verify Component Status.
		 *
		 * @since 1.7.0
		 *
		 * @param string $component_key Component key.
		 * @return string
		 */
		protected function verify_component_status($component_key)
		{
		}
	}
	/**
	 * Fetch a BuddyPress activity based on one of its attributes.
	 *
	 * @since 2.0.0
	 */
	class Activity_Fetcher extends \WP_CLI\Fetchers\Base
	{
		/**
		 * @var string $msg Error message to use when invalid data is provided.
		 */
		protected $msg = 'Could not find the activity with ID %d.';
		/**
		 * Get an activity ID.
		 *
		 * @param int $activity_id Activity ID.
		 * @return BP_Activity_Activity|bool
		 */
		public function get($activity_id)
		{
		}
	}
	/**
	 * Manage BuddyPress Signups.
	 *
	 * ## EXAMPLES
	 *
	 *     # Add a signup.
	 *     $ wp bp signup create --user-login=test_user --user-email=teste@site.com
	 *     Success: Successfully added new user signup (ID #345).
	 *
	 *     # Activate a signup.
	 *     $ wp bp signup activate ee48ec319fef3nn4
	 *     Success: Signup activated, new user (ID #545).
	 *
	 * @since 1.5.0
	 */
	class Signup extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Signup object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'user_name', 'user_login', 'user_email', 'registered', 'meta', 'activation_key', 'count_sent'];
		/**
		 * Dependency check for this CLI command.
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Add a signup.
		 *
		 * ## OPTIONS
		 *
		 * [--user-login=<user-login>]
		 * : User login for the signup.
		 *
		 * [--user-email=<user-email>]
		 * : User email for the signup.
		 *
		 * [--activation-key=<activation-key>]
		 * : Activation key for the signup. If none is provided, a random one will be used.
		 *
		 * [--silent]
		 * : Whether to silent the signup creation.
		 *
		 * [--porcelain]
		 * : Output only the new signup id.
		 *
		 * ## EXAMPLES
		 *
		 *     # Add a signup.
		 *     $ wp bp signup create --user-login=test_user --user-email=teste@site.com
		 *     Success: Successfully added new user signup (ID #345).
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Get a signup.
		 *
		 * ## OPTIONS
		 *
		 * <signup-id>
		 * : Identifier for the signup. Can be a signup ID, an email address, or a user_login.
		 *
		 * [--match-field=<match-field>]
		 * : Field to match the signup-id to. Use if there is ambiguity between, eg, signup ID and user_login.
		 * ---
		 * options:
		 *   - signup_id
		 *   - user_email
		 *   - user_login
		 * ---
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific signup fields.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - json
		 *   - csv
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Get a signup.
		 *     $ wp bp signup get 35 --fields=id,user_login,user_name,count_sent
		 *     +------------+------------+
		 *     | Field      | Value      |
		 *     +------------+------------+
		 *     | id         | 35         |
		 *     | user_login | user897616 |
		 *     | user_name  | Test user  |
		 *     | count_sent | 4          |
		 *     +------------+------------+
		 */
		public function get($args, $assoc_args)
		{
		}
		/**
		 * Delete a signup.
		 *
		 * ## OPTIONS
		 *
		 * <signup-id>...
		 * : ID or IDs of signup to delete.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete a signup.
		 *     $ wp bp signup delete 520 --yes
		 *     Success: Signup deleted 54565.
		 *
		 *     # Delete multiple signups.
		 *     $ wp bp signup delete 55654 54565 --yes
		 *     Success: Signup deleted 55654.
		 *     Success: Signup deleted 54565.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
		/**
		 * Activate a signup.
		 *
		 * ## OPTIONS
		 *
		 * <signup-id>
		 * : Identifier for the signup. Can be a signup ID, an email address, or a user_login.
		 *
		 * ## EXAMPLES
		 *
		 *     # Activate a signup.
		 *     $ wp bp signup activate ee48ec319fef3nn4
		 *     Success: Signup activated, new user (ID #545).
		 */
		public function activate($args, $assoc_args)
		{
		}
		/**
		 * Generate random signups.
		 *
		 * ## OPTIONS
		 *
		 * [--count=<number>]
		 * : How many signups to generate.
		 * ---
		 * default: 100
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: progress
		 * options:
		 *   - progress
		 *   - ids
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Generate 50 random signups.
		 *     $ wp bp signup generate --count=50
		 *     Generating signups  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 5 random signups and return their IDs.
		 *     $ wp bp signup generate --count=5 --format=ids
		 *     70 71 72 73 74
		 */
		public function generate($args, $assoc_args)
		{
		}
		/**
		 * Resend activation e-mail to a newly registered user.
		 *
		 * ## OPTIONS
		 *
		 * <signup-id>
		 * : Identifier for the signup. Can be a signup ID, an email address, or a user_login.
		 *
		 * ## EXAMPLES
		 *
		 *     # Resend activation e-mail to a newly registered user.
		 *     $ wp bp signup resend test@example.com
		 *     Success: Email sent successfully.
		 *
		 * @alias send
		 */
		public function resend($args, $assoc_args)
		{
		}
		/**
		 * Get a list of signups.
		 *
		 * ## OPTIONS
		 *
		 * [--<field>=<value>]
		 * : One or more parameters to pass. See \BP_Signup::get()
		 *
		 * [--fields=<fields>]
		 * : Fields to display.
		 *
		 * [--count=<number>]
		 * : How many signups to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<value>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - csv
		 *   - ids
		 *   - json
		 *   - count
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # List signups and get the IDs.
		 *     $ wp bp signup list --format=ids
		 *     70 71 72 73 74
		 *
		 *     # List 100 signups and return the count.
		 *     $ wp bp signup list --count=100 --format=count
		 *     100
		 *
		 *     # List active signups.
		 *     $ wp bp signup list --active=1 --count=10
		 *     50
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Look up a signup by the provided identifier.
		 *
		 * @since 1.5.0
		 *
		 * @return mixed
		 */
		protected function get_signup_by_identifier($identifier, $assoc_args)
		{
		}
	}
	/**
	 * Manage BuddyPress XProfile.
	 *
	 * ## EXAMPLES
	 *
	 *     # Save a xprofile data to a user with its field and value.
	 *     $ wp bp xprofile data set --user-id=45 --field-id=120 --value=test
	 *     Success: Updated XProfile field "Field Name" (ID 120) with value "test" for user user_login (ID 45).
	 *
	 *     # Create a xprofile group.
	 *     $ wp bp xprofile group create --name="Group Name" --description="Xprofile Group Description"
	 *     Success: Created XProfile field group "Group Name" (ID 123).
	 *
	 *     # List xprofile fields.
	 *     $ wp bp xprofile field list
	 *     +----+------+-------------+---------+----------+-------------+
	 *     | id | name | description | type    | group_id | is_required |
	 *     +----+------+-------------+---------+----------+-------------+
	 *     | 1  | Name |             | textbox | 1        | 1           |
	 *     +----+------+-------------+---------+----------+-------------+
	 */
	class XProfile extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Dependency check for this CLI command.
		 */
		public static function check_dependencies()
		{
		}
	}
	/**
	 * Manage BuddyPress Activities.
	 *
	 * ## EXAMPLES
	 *
	 *     # Create an activity marked as spam.
	 *     $ wp bp activity create --is-spam=1
	 *     Success: Successfully created new activity item (ID #5464)
	 *
	 *     # Create an activity in a group.
	 *     $ wp bp activity add --component=groups --item-id=2 --user-id=10
	 *     Success: Successfully created new activity item (ID #48949)
	 *
	 * @since 1.5.0
	 */
	class Activity extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'user_id', 'component', 'type', 'action', 'item_id', 'primary_link', 'secondary_item_id', 'date_recorded', 'hide_sitewide', 'is_spam'];
		/**
		 * Dependency check for this CLI command.
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Create an activity item.
		 *
		 * ## OPTIONS
		 *
		 * [--component=<component>]
		 * : The component for the activity item (groups, activity, etc). If
		 * none is provided, a component will be randomly selected from the
		 * active components.
		 *
		 * [--type=<type>]
		 * : Activity type (activity_update, group_created, etc). If none is
		 * provided, a type will be randomly chose from those natively
		 * associated with your <component>.
		 *
		 * [--action=<action>]
		 * : Action text (eg "Joe created a new group Foo"). If none is
		 * provided, one will be generated automatically based on other params.
		 *
		 * [--content=<content>]
		 * : Activity content text. If none is provided, default text will be
		 * generated.
		 *
		 * [--primary-link=<primary-link>]
		 * : URL of the item, as used in RSS feeds. If none is provided, a URL
		 * will be generated based on passed parameters.
		 *
		 * [--user-id=<user>]
		 * : ID of the user associated with the new item. If none is provided,
		 * a user will be randomly selected.
		 *
		 * [--item-id=<item-id>]
		 * : ID of the associated item. If none is provided, one will be
		 * generated automatically, if your activity type requires it.
		 *
		 * [--secondary-item-id=<secondary-item-id>]
		 * : ID of the secondary associated item. If none is provided, one will
		 * be generated automatically, if your activity type requires it.
		 *
		 * [--date-recorded=<date-recorded>]
		 * : GMT timestamp, in Y-m-d h:i:s format.
		 *
		 * [--hide-sitewide=<hide-sitewide>]
		 * : Whether to hide in sitewide streams.
		 *
		 * [--is-spam=<is-spam>]
		 * : Whether the item should be marked as spam.
		 *
		 * [--silent]
		 * : Whether to silent the activity creation.
		 *
		 * [--porcelain]
		 * : Output only the new activity id.
		 *
		 * ## EXAMPLES
		 *
		 *     # Create an activity marked as spam.
		 *     $ wp bp activity create --is-spam=1
		 *     Success: Successfully created new activity item (ID #5464)
		 *
		 *     # Create an activity.
		 *     $ wp bp activity add --component=groups --item-id=564 --user-id=10
		 *     Success: Successfully created new activity item (ID #48949)
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Retrieve a list of activities.
		 *
		 * ## OPTIONS
		 *
		 * [--<field>=<value>]
		 * : One or more parameters to pass to \BP_Activity_Activity::get()
		 *
		 * [--user-id=<user>]
		 * : Limit activities to a specific user id. Accepts a numeric ID.
		 *
		 * [--component=<component>]
		 * : Limit activities to a specific or certain components.
		 *
		 * [--type=<type>]
		 * : Type of the activity. Ex.: activity_update, profile_updated.
		 *
		 * [--primary-id=<primary-id>]
		 * : Object ID to filter the activities. Ex.: group_id or forum_id or blog_id, etc.
		 *
		 * [--secondary-id=<secondary-id>]
		 * : Secondary object ID to filter the activities. Ex.: a post_id.
		 *
		 * [--count=<number>]
		 * : How many activities to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 *  ---
		 * default: table
		 * options:
		 *   - table
		 *   - csv
		 *   - ids
		 *   - json
		 *   - count
		 *   - yaml
		 * ---
		 *
		 * ## AVAILABLE FIELDS
		 *
		 * These fields will be displayed by default for each activity:
		 *
		 * * id
		 * * user_id
		 * * component
		 * * type
		 * * action
		 * * content
		 * * item_id
		 * * secondary_item_id
		 * * primary_link
		 * * date_recorded
		 * * is_spam
		 * * user_email
		 * * user_nicename
		 * * user_login
		 * * display_name
		 * * user_fullname
		 *
		 * ## EXAMPLES
		 *
		 *     # List activities and get the count.
		 *     $ wp bp activity list --format=count
		 *     100
		 *
		 *     # List activities and get the IDs.
		 *     $ wp bp activity list --format=ids
		 *     70 71 72 73 74
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Generate random activity items.
		 *
		 * ## OPTIONS
		 *
		 * [--count=<number>]
		 * : How many activities to generate.
		 * ---
		 * default: 100
		 * ---
		 *
		 * [--skip-activity-comments=<skip-activity-comments>]
		 * : Whether to skip activity comments. Recording activity_comment
		 * items requires a resource-intensive tree rebuild.
		 * ---
		 * default: 1
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: progress
		 * options:
		 *   - progress
		 *   - ids
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Generate 5 activity items.
		 *     $ wp bp activity generate --count=5
		 *     Generating activities  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 5 activity items and output only the IDs.
		 *     $ wp bp activity generate --count=5 --format=ids
		 *     70 71 72 73 74
		 */
		public function generate($args, $assoc_args)
		{
		}
		/**
		 * Fetch specific activity.
		 *
		 * ## OPTIONS
		 *
		 * <activity-id>
		 * : Identifier for the activity.
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific fields.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 *  ---
		 * default: table
		 * options:
		 *   - table
		 *   - json
		 *   - csv
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLE
		 *
		 *     # Get activity by ID.
		 *     $ wp bp activity get 58
		 *     +-------------------+----------------------------------------------------------------------------------------------+
		 *     | Field             | Value                                                                                        |
		 *     +-------------------+----------------------------------------------------------------------------------------------+
		 *     | id                | 58                                                                                           |
		 *     | user_id           | 7                                                                                            |
		 *     | component         | xprofile                                                                                     |
		 *     | type              | updated_profile                                                                              |
		 *     | action            | <a href="https://wp.test/members/user_1_4/profile/">User 4</a>&#039;s profile was updated    |
		 *     | content           | Here is some random text                                                                     |
		 *     | primary_link      |                                                                                              |
		 *     | item_id           | 0                                                                                            |
		 *     | secondary_item_id | 0                                                                                            |
		 *     | date_recorded     | 2024-02-08 01:53:59                                                                          |
		 *     | hide_sitewide     | 0                                                                                            |
		 *     | mptt_left         | 0                                                                                            |
		 *     | mptt_right        | 0                                                                                            |
		 *     | is_spam           | 0                                                                                            |
		 *     | user_email        |                                                                                              |
		 *     | user_nicename     | user_1_4                                                                                     |
		 *     | user_login        | user_1_4                                                                                     |
		 *     | display_name      | User 4                                                                                       |
		 *     | user_fullname     | User 4                                                                                       |
		 *     | children          | []                                                                                           |
		 *     | url               | https://wp.test/activity/p/58/                                                               |
		 *     +-------------------+----------------------------------------------------------------------------------------------+
		 *
		 * @alias see
		 */
		public function get($args, $assoc_args)
		{
		}
		/**
		 * Delete an activity.
		 *
		 * ## OPTIONS
		 *
		 * <activity-id>...
		 * : ID or IDs of activities to delete.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete an activity.
		 *     $ wp bp activity delete 958695 --yes
		 *     Success: Deleted activity 958695.
		 *
		 *     # Delete multiple activities.
		 *     $ wp bp activity delete 500 600 --yes
		 *     Success: Deleted activity 500.
		 *     Success: Deleted activity 600.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
		/**
		 * Spam an activity.
		 *
		 * ## OPTIONS
		 *
		 * <activity-id>
		 * : Identifier for the activity.
		 *
		 * ## EXAMPLES
		 *
		 *     # Spam an activity.
		 *     $ wp bp activity spam 500
		 *     Success: Activity marked as spam.
		 *
		 *     # Spam an activity.
		 *     $ wp bp activity unham 165165
		 *     Success: Activity marked as spam.
		 *
		 * @alias unham
		 */
		public function spam($args)
		{
		}
		/**
		 * Ham an activity.
		 *
		 * ## OPTIONS
		 *
		 * <activity-id>
		 * : Identifier for the activity.
		 *
		 * ## EXAMPLES
		 *
		 *     # Mark an activity as ham.
		 *     $ wp bp activity ham 500
		 *     Success: Activity marked as ham.
		 *
		 *     # Mark an activity as ham.
		 *     $ wp bp activity unspam 4679
		 *     Success: Activity marked as ham.
		 *
		 * @alias unspam
		 */
		public function ham($args)
		{
		}
		/**
		 * Post an activity update.
		 *
		 * ## OPTIONS
		 *
		 * --user-id=<user>
		 * : ID of the user.
		 *
		 * --content=<content>
		 * : Activity content text.
		 *
		 * [--silent]
		 * : Whether to silent the activity update.
		 *
		 * [--porcelain]
		 * : Output only the new activity id.
		 *
		 * ## EXAMPLES
		 *
		 *     # Post an activity update.
		 *     $ wp bp activity post-update --user-id=50 --content="Content to update"
		 *     Success: Successfully updated with a new activity item (ID #13165)
		 *
		 *     # Post an activity update.
		 *     $ wp bp activity post-update --user-id=140
		 *     Success: Successfully updated with a new activity item (ID #4548)
		 *
		 * @alias post-update
		 */
		public function post_update($args, $assoc_args)
		{
		}
		/**
		 * Add an activity comment.
		 *
		 * ## OPTIONS
		 *
		 * <activity-id>
		 * : ID of the activity to add the comment.
		 *
		 * --user-id=<user>
		 * : ID of the user. If none is provided, a user will be randomly selected.
		 *
		 * --content=<content>
		 * : Activity content text. If none is provided, default text will be generated.
		 *
		 * [--skip-notification]
		 * : Whether to skip notification.
		 *
		 * [--silent]
		 * : Whether to silent the activity comment.
		 *
		 * [--porcelain]
		 * : Output only the new activity comment id.
		 *
		 * ## EXAMPLES
		 *
		 *     # Add an activity comment.
		 *     $ wp bp activity comment 560 --user-id=50 --content="New activity comment"
		 *     Success: Successfully added a new activity comment (ID #4645)
		 *
		 *     # Add an activity comment, skipping notification.
		 *     $ wp bp activity comment 459 --user-id=140 --skip-notification=1
		 *     Success: Successfully added a new activity comment (ID #494)
		 */
		public function comment($args, $assoc_args)
		{
		}
		/**
		 * Delete an activity comment.
		 *
		 * ## OPTIONS
		 *
		 * <activity-id>
		 * : Identifier for the activity.
		 *
		 * --comment-id=<comment-id>
		 * : ID of the comment to delete.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete an activity comment.
		 *     $ wp bp activity delete-comment 100 --comment-id=500 --yes
		 *     Success: Activity comment deleted.
		 *
		 *     # Delete an activity comment.
		 *     $ wp bp activity delete-comment 165 --comment-id=35435 --yes
		 *     Success: Activity comment deleted.
		 *
		 * @alias remove-comment
		 * @alias delete-comment
		 */
		public function delete_comment($args, $assoc_args)
		{
		}
		/**
		 * Get a random type from a component.
		 *
		 * @since 1.1
		 *
		 * @param string $component Component name.
		 * @return string
		 */
		protected function get_random_type_from_component($component)
		{
		}
		/**
		 * Generate item details.
		 *
		 * @global wpdb $wpdb WordPress database abstraction object.
		 *
		 * @since 1.1
		 *
		 * @param array $r Params.
		 * @return array
		 */
		protected function generate_item_details($r)
		{
		}
	}
	/**
	 * Manage XProfile Data.
	 *
	 * @since 1.5.0
	 */
	class XProfile_Data extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * XProfile object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'field_id', 'user_id', 'value', 'last_updated'];
		/**
		 * Set profile data for a user.
		 *
		 * ## OPTIONS
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * --field-id=<field>
		 * : Identifier for the field. Accepts either the name of the field or a numeric ID.
		 *
		 * --value=<value>
		 * : Value to set.
		 *
		 * [--silent]
		 * : Whether to silent the success message.
		 *
		 * ## EXAMPLE
		 *
		 *     # Set profile data for a user.
		 *     $ wp bp xprofile data set --user-id=45 --field-id=120 --value=test
		 *     Success: Updated XProfile field "Field Name" (ID 120) with value  "test" for user user_login (ID 45).
		 *
		 * @alias set
		 * @alias add
		 * @alias update
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Get profile data for a user.
		 *
		 * ## OPTIONS
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--field-id=<field>]
		 * : Identifier for the field. Accepts either the name of the field or a numeric ID.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - json
		 *   - csv
		 *   - yaml
		 * ---
		 *
		 * [--multi-format=<value>]
		 * : The format for the array data.
		 * ---
		 * default: array
		 * options:
		 *   - array
		 *   - comma
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Get profile data for a user.
		 *     $ wp bp xprofile data get --user-id=45 --field-id=120
		 *
		 *     # Get profile data for a user, formatting the data.
		 *     $ wp bp xprofile data see --user-id=user_test --field-id=Hometown --multi-format=comma
		 *
		 * @alias see
		 */
		public function get($args, $assoc_args)
		{
		}
		/**
		 * Delete XProfile data for a user.
		 *
		 * ## OPTIONS
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--field-id=<field>]
		 * : Identifier for the field. Accepts either the name of the field or a numeric ID.
		 *
		 * [--delete-all]
		 * : Delete all data for the user.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete a specific XProfile field data.
		 *     $ wp bp xprofile data delete --user-id=45 --field-id=120 --yes
		 *     Success: XProfile data removed.
		 *
		 *     # Delete all XProfile data for a user.
		 *     $ wp bp xprofile data remove --user-id=user_test --delete-all --yes
		 *     Success: XProfile data removed.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
	}
	/**
	 * Manage XProfile Groups.
	 *
	 * @since 1.5.0
	 */
	class XProfile_Group extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * XProfile object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'name', 'description', 'group_order', 'can_delete'];
		/**
		 * Object ID key.
		 *
		 * @var string
		 */
		protected $obj_id_key = 'id';
		/**
		 * Create an XProfile group.
		 *
		 * ## OPTIONS
		 *
		 * --name=<name>
		 * : The name for this field group.
		 *
		 * [--description=<description>]
		 * : The description for this field group.
		 *
		 * [--can-delete=<can-delete>]
		 * : Whether the group can be deleted.
		 * ---
		 * default: 1
		 * ---
		 *
		 * [--silent]
		 * : Whether to silent the XProfile group creation.
		 *
		 * [--porcelain]
		 * : Output just the new group id.
		 *
		 * ## EXAMPLES
		 *
		 *     # Create XProfile field group.
		 *     $ wp bp xprofile group create --name="Group Name" --description="Xprofile Group Description"
		 *     Success: Created XProfile field group "Group Name" (ID 123).
		 *
		 *     # Create XProfile field group that can't be deleted.
		 *     $ wp bp xprofile group add --name="Another Group" --can-delete=false
		 *     Success: Created XProfile field group "Another Group" (ID 21212).
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Fetch specific XProfile field group.
		 *
		 * ## OPTIONS
		 *
		 * <field-group-id>
		 * : Identifier for the field group.
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific fields.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - json
		 *   - csv
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Get a specific field group.
		 *     $ wp bp xprofile group get 500
		 *     +-------------+---------------+
		 *     | Field       | Value         |
		 *     +-------------+---------------+
		 *     | id          | 2             |
		 *     | name        | Group         |
		 *     | description |               |
		 *     | can_delete  | 1             |
		 *     | group_order | 0             |
		 *     | fields      | null          |
		 *     +-------------+---------------+
		 *
		 *     # Get a specific field group in JSON format.
		 *     $ wp bp xprofile group see 56 --format=json
		 *     {"id":2,"name":"Group","description":"","can_delete":1,"group_order":0,"fields":null}
		 *
		 * @alias see
		 */
		public function get($args, $assoc_args)
		{
		}
		/**
		 * Delete specific XProfile field group(s).
		 *
		 * ## OPTIONS
		 *
		 * <field-group-id>...
		 * : ID or IDs of field groups to delete.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete a specific field group.
		 *     $ wp bp xprofile group delete 500 --yes
		 *     Success: Field group deleted 500.
		 *
		 *     $ wp bp xprofile group delete 55654 54564 --yes
		 *     Success: Field group deleted 55654.
		 *     Success: Field group deleted 54564.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
	}
	/**
	 * Manage BuddyPress Notifications.
	 *
	 * ## EXAMPLES
	 *
	 *     # Create notification item.
	 *     $ wp bp notification create
	 *     Success: Successfully created new notification. (ID #5464)
	 *
	 *     # Delete a notification item.
	 *     $ wp bp notification delete 520
	 *     Success: Notification deleted.
	 *
	 * @since 1.8.0
	 */
	class Notification extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'user_id', 'item_id', 'secondary_item_id', 'component_name', 'component_action', 'date_notified', 'is_new'];
		/**
		 * Dependency check for this CLI command.
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Create a notification.
		 *
		 * ## OPTIONS
		 *
		 * [--component=<component>]
		 * : The component for the notification item (groups, activity, etc). If
		 * none is provided, a component will be randomly selected from the
		 * active components.
		 *
		 * [--action=<action>]
		 * : Name of the action to associate the notification. (comment_reply, update_reply, etc).
		 *
		 * [--user-id=<user>]
		 * : ID of the user associated with the new notification.
		 *
		 * [--item-id=<item>]
		 * : ID of the associated notification.
		 *
		 * [--secondary-item-id=<item>]
		 * : ID of the secondary associated notification.
		 *
		 * [--date=<date>]
		 * : GMT timestamp, in Y-m-d h:i:s format.
		 *
		 * [--silent]
		 * : Whether to silent the notification creation.
		 *
		 * [--porcelain]
		 * : Output only the new notification id.
		 *
		 * ## EXAMPLES
		 *
		 *     # Create a `update_reply` notification.
		 *     $ wp bp notification create --component=messages --action=update_reply --user-id=523
		 *     Success: Successfully created new notification. (ID #5464)
		 *
		 *     # Create a `comment_reply` notification.
		 *     $ wp bp notification add --component=groups --action=comment_reply --user-id=10
		 *     Success: Successfully created new notification (ID #48949)
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Get specific notification.
		 *
		 * ## OPTIONS
		 *
		 * <notification-id>
		 * : Identifier for the notification.
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific fields.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 *  ---
		 * default: table
		 * options:
		 *   - table
		 *   - json
		 *   - csv
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Get a notification by ID.
		 *     $ wp bp notification get 10071
		 *     +-------------------+---------------------+
		 *     | Field             | Value               |
		 *     +-------------------+---------------------+
		 *     | id                | 10071               |
		 *     | item_id           | 0                   |
		 *     | secondary_item_id | 0                   |
		 *     | user_id           | 7                   |
		 *     | component_name    | activity            |
		 *     | component_action  | comment_reply       |
		 *     | date_notified     | 2024-02-06 00:28:45 |
		 *     | is_new            | 1                   |
		 *     +-------------------+---------------------+
		 *
		 *     # Get a notification in JSON format.
		 *     $ wp bp notification get 10071 --format=json
		 *     {"id":10071,"item_id":0,"secondary_item_id":0,"user_id":7,"component_name":"activity","component_action":"comment_reply","date_notified":"2024-02-06 00:28:45","is_new":1}
		 *
		 *     # Get a notification using a invalid ID.
		 *     $ wp bp notification see buddypress
		 *     Error: Please provide a numeric notification ID.
		 *
		 * @alias see
		 */
		public function get($args, $assoc_args)
		{
		}
		/**
		 * Delete a notification.
		 *
		 * ## OPTIONS
		 *
		 * <notification-id>...
		 * : ID or IDs of notification to delete.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Delete a notification.
		 *     $ wp bp notification delete 520 --yes
		 *     Success: Deleted notification 520.
		 *
		 *     # Delete multiple notifications.
		 *     $ wp bp notification delete 55654 54564 --yes
		 *     Success: Deleted notification 55654.
		 *     Success: Deleted notification 54564.
		 *
		 * @alias remove
		 * @alias trash
		 */
		public function delete($args, $assoc_args)
		{
		}
		/**
		 * Generate random notifications.
		 *
		 * ## OPTIONS
		 *
		 * [--count=<number>]
		 * : How many notifications to generate.
		 * ---
		 * default: 100
		 * ---
		 *
		 * [--user-id=<user>]
		 * : ID of the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: progress
		 * options:
		 *   - progress
		 *   - ids
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Generate 5 random notifications.
		 *     $ wp bp notification generate --count=5
		 *     Generating notifications  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 5 random notifications and output only the IDs.
		 *     $ wp bp notification generate --count=5 --format=ids
		 *     70 71 72 73 74
		 */
		public function generate($args, $assoc_args)
		{
		}
		/**
		 * Get a list of notifications.
		 *
		 * ## OPTIONS
		 *
		 * [--<field>=<value>]
		 * : One or more parameters to pass.
		 *
		 * [--fields=<fields>]
		 * : Fields to display.
		 *
		 * [--user-id=<user>]
		 * : Limit results to a specific member. Accepts either a user_login or a numeric ID.
		 *
		 * [--component=<component>]
		 * : The component to fetch notifications (groups, activity, etc).
		 *
		 * [--action=<action>]
		 * : Name of the action to fetch notifications. (comment_reply, update_reply, etc).
		 *
		 * [--count=<number>]
		 * : How many notification items to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - ids
		 *   - count
		 *   - csv
		 *   - json
		 *   - yaml
		 * ---
		 * ## EXAMPLES
		 *
		 *     # List all notifications and output only the IDs.
		 *     $ wp bp notification list --format=ids
		 *     15 25 34 37 198
		 *
		 *     # List all notifications and output the count.
		 *     $ wp bp notification list --format=count
		 *     10
		 *
		 *     # List all notifications and output the IDs and user_id.
		 *     $ wp bp notification list --fields=id,user_id
		 *     | id     | user_id  |
		 *     | 66546  | 656      |
		 *     | 54554  | 646546   |
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Get random notification actions based on component.
		 *
		 * @since 1.8.0
		 *
		 * @param string $component BuddyPress Component.
		 * @return string
		 */
		protected function get_random_action($component)
		{
		}
	}
	/**
	 * Manage BuddyPress through the command-line.
	 *
	 * ## EXAMPLES
	 *
	 *     # Create a user signup.
	 *     $ wp bp signup create --user-login=test_user --user-email=teste@site.com
	 *     Success: Successfully added new user signup (ID #345).
	 *
	 *     # Activate a component.
	 *     $ wp bp component activate groups
	 *     Success: The Groups component has been activated.
	 *
	 *     # List xprofile fields.
	 *     $ wp bp xprofile field list
	 *     +----+------+-------------+---------+----------+-------------+
	 *     | id | name | description | type    | group_id | is_required |
	 *     +----+------+-------------+---------+----------+-------------+
	 *     | 1  | Name |             | textbox | 1        | 1           |
	 *     +----+------+-------------+---------+----------+-------------+
	 */
	class BuddyPress extends \Buddypress\CLI\Command\BuddyPressCommand
	{
	}
	/**
	 * Manage BuddyPress Messages.
	 *
	 *  ## EXAMPLES
	 *
	 *     # Create message.
	 *     $ wp bp message create --from=user1 --to=user2 --subject="Message Title" --content="We are ready"
	 *     Success: Message successfully created.
	 *
	 *     # Delete a thread.
	 *     $ wp bp message delete-thread 564 5465465 456456 --user-id=user_login --yes
	 *     Success: Thread successfully deleted.
	 *
	 * @since 1.6.0
	 */
	class Messages extends \Buddypress\CLI\Command\BuddyPressCommand
	{
		/**
		 * Dependency check for this CLI command.
		 */
		public static function check_dependencies()
		{
		}
		/**
		 * Object fields.
		 *
		 * @var array
		 */
		protected $obj_fields = ['id', 'subject', 'message', 'thread_id', 'sender_id', 'date_sent'];
		/**
		 * Add a message.
		 *
		 * ## OPTIONS
		 *
		 * --from=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--to=<user>]
		 * : Identifier for the recipient. To is not required when thread id is set.
		 *  Accepts either a user_login or a numeric ID.
		 *
		 * --subject=<subject>
		 * : Subject of the message.
		 *
		 * --content=<content>
		 * : Content of the message.
		 *
		 * [--thread-id=<thread-id>]
		 * : Thread ID.
		 *
		 * [--date-sent=<date-sent>]
		 * : GMT timestamp, in Y-m-d h:i:s format.
		 *
		 * [--silent]
		 * : Whether to silent the message creation.
		 *
		 * [--porcelain]
		 * : Return the thread id of the message.
		 *
		 * ## EXAMPLES
		 *
		 *     # Add a message.
		 *     $ wp bp message add --from=user1 --to=user2 --subject="Message Title" --content="We are ready"
		 *     Success: Message successfully created.
		 *
		 *     # Create a message.
		 *     $ wp bp message create --from=545 --to=313 --subject="Another Message Title" --content="Message OK"
		 *     Success: Message successfully created.
		 *
		 * @alias add
		 */
		public function create($args, $assoc_args)
		{
		}
		/**
		 * Delete thread(s) for a given user.
		 *
		 * ## OPTIONS
		 *
		 * <thread-id>...
		 * : Thread ID(s).
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--yes]
		 * : Answer yes to the confirmation message.
		 *
		 * ## EXAMPLES
		 *
		 *     $ wp bp message delete-thread 500 687867 --user-id=40
		 *     Success: Thread successfully deleted.
		 *
		 *     $ wp bp message delete-thread 564 5465465 456456 --user-id=user_logon --yes
		 *     Success: Thread successfully deleted.
		 *
		 * @alias delete-thread
		 * @alias remove-thread
		 */
		public function delete_thread($args, $assoc_args)
		{
		}
		/**
		 * Get a message.
		 *
		 * ## OPTIONS
		 *
		 * <message-id>
		 * : Identifier for the message.
		 *
		 * [--fields=<fields>]
		 * : Limit the output to specific fields.
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - json
		 *   - csv
		 *   - yaml
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Get message by ID.
		 *     $ wp bp message get 5465
		 *
		 *     # Get message with a string
		 *     $ wp bp message get invalid-id
		 *     Error: Please provide a numeric message ID.
		 *
		 * @alias see
		 */
		public function get($args, $assoc_args)
		{
		}
		/**
		 * Get a list of messages for a specific user.
		 *
		 * ## OPTIONS
		 *
		 * --user-id=<user>
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--<field>=<value>]
		 * : One or more parameters to pass. See \BP_Messages_Box_Template()
		 *
		 * [--fields=<fields>]
		 * : Fields to display.
		 *
		 * [--box=<box>]
		 * : Box of the message.
		 * ---
		 * default: sentbox
		 * options:
		 *   - sentbox
		 *   - inbox
		 *   - notices
		 * ---
		 *
		 * [--type=<type>]
		 * : Type of the message.
		 * ---
		 * default: all
		 * options:
		 *   - unread
		 *   - read
		 *   - all
		 * ---
		 *
		 * [--count=<number>]
		 * : How many messages to list.
		 * ---
		 * default: 50
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: table
		 * options:
		 *   - table
		 *   - ids
		 *   - count
		 *   - csv
		 *   - json
		 *   - yaml
		 * ---
		 *
		 * ## AVAILABLE FIELDS
		 *
		 * These fields will be displayed by default for each message:
		 *
		 * * id
		 * * subject
		 * * message
		 * * thread_id
		 * * sender_id
		 * * date_sent
		 *
		 * ## EXAMPLES
		 *
		 *     # Get a list of messages for a specific user.
		 *     $ wp bp message list --user-id=544 --format=count
		 *     10
		 *
		 *     # Get a list of messages for a specific user and output only the IDs.
		 *     $ wp bp message list --user-id=user_login --count=3 --format=ids
		 *     5454 45454 4545 465465
		 *
		 *     # Get a list of messages.
		 *     # wp bp message list --user-id=1 --count=2
		 *     +----+----------------------+--------------------------+-----------+-----------+---------------------+
		 *     | id | subject              | message                  | thread_id | sender_id | date_sent           |
		 *     +----+----------------------+--------------------------+-----------+-----------+---------------------+
		 *     | 35 | Another Thread       | <p>Another thread</p>    | 2         | 1         | 2022-10-27 16:29:29 |
		 *     | 37 | Message Subject - #0 | Here is some random text | 2         | 7         | 2022-10-27 19:06:54 |
		 *     +----+----------------------+--------------------------+-----------+-----------+---------------------+
		 *
		 * @subcommand list
		 */
		public function list_($args, $assoc_args)
		{
		}
		/**
		 * Generate random messages.
		 *
		 * ## OPTIONS
		 *
		 * [--count=<number>]
		 * : How many messages to generate.
		 * ---
		 * default: 100
		 * ---
		 *
		 * [--from=<user>]
		 * : Identifier for the user. Accepts either a user_login or a numeric ID.
		 *
		 * [--to=<user>]
		 * : Identifier for the recipient. To is not required when thread id is set.
		 *  Accepts either a user_login or a numeric ID.
		 *
		 * [--thread-id=<thread-id>]
		 * : Thread ID to generate messages against.
		 * ---
		 *
		 * [--format=<format>]
		 * : Render output in a particular format.
		 * ---
		 * default: progress
		 * options:
		 *   - progress
		 *   - ids
		 * ---
		 *
		 * ## EXAMPLES
		 *
		 *     # Generate messages against a thread with a specific user.
		 *     $ wp bp message generate --from=1 --to=2 --thread-id=6465 --count=30
		 *     Generating messages  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate messages against a thread.
		 *     $ wp bp message generate --thread-id=6465 --count=10
		 *     Generating messages  100% [======================] 0:00 / 0:00
		 *
		 *     # Generate 5 messages against a thread and output only the IDs.
		 *     $ wp bp message generate --thread-id=5665456 --count=5 --format=ids
		 *     70 71 72 73 74
		 */
		public function generate($args, $assoc_args)
		{
		}
		/**
		 * Star a message.
		 *
		 * ## OPTIONS
		 *
		 * <message-id>
		 * : Message ID to star.
		 *
		 * --user-id=<user>
		 * : User that is starring the message. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLE
		 *
		 *     # Star a message.
		 *     $ wp bp message star 3543 --user-id=user_login
		 *     Success: Message was successfully starred.
		 */
		public function star($args, $assoc_args)
		{
		}
		/**
		 * Unstar a message.
		 *
		 * ## OPTIONS
		 *
		 * <message-id>
		 * : Message ID to unstar.
		 *
		 * --user-id=<user>
		 * : User that is unstarring the message. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLE
		 *
		 *     # Unstar a message.
		 *     $ wp bp message unstar 212 --user-id=another_user_login
		 *     Success: Message was successfully unstarred.
		 */
		public function unstar($args, $assoc_args)
		{
		}
		/**
		 * Star a thread.
		 *
		 * ## OPTIONS
		 *
		 * <thread-id>
		 * : Thread ID to star.
		 *
		 * --user-id=<user>
		 * : User that is starring the thread. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLE
		 *
		 *     # Star a thread.
		 *     $ wp bp message star-thread 212 --user-id=another_user_login
		 *     Success: Thread was successfully starred.
		 *
		 * @alias star-thread
		 */
		public function star_thread($args, $assoc_args)
		{
		}
		/**
		 * Unstar a thread.
		 *
		 * ## OPTIONS
		 *
		 * <thread-id>
		 * : Thread ID to unstar.
		 *
		 * --user-id=<user>
		 * : User that is unstarring the thread. Accepts either a user_login or a numeric ID.
		 *
		 * ## EXAMPLE
		 *
		 *     # Unstar a thread.
		 *     $ wp bp message unstar-thread 212 --user-id=another_user_login
		 *     Success: Thread was successfully unstarred.
		 *
		 * @alias unstar-thread
		 */
		public function unstar_thread($args, $assoc_args)
		{
		}
		/**
		 * Send a notice.
		 *
		 * ## OPTIONS
		 *
		 * --subject=<subject>
		 * : Subject of the notice/message.
		 *
		 * --content=<content>
		 * : Content of the notice.
		 *
		 * ## EXAMPLE
		 *
		 *     # Send a notice.
		 *     $ wp bp message send-notice --subject="Important notice" --content="We need to improve"
		 *     Success: Notice was successfully sent.
		 *
		 * @alias send-notice
		 */
		public function send_notice($args, $assoc_args)
		{
		}
	}
}
namespace {
	/**
	 * Class to help set up XProfile fields.
	 *
	 * @since 1.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_XProfile_Field
	{
		/**
		 * Field ID.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $id;
		/**
		 * Field group ID.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $group_id;
		/**
		 * Field parent ID.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $parent_id;
		/**
		 * Field type.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $type = '';
		/**
		 * Field name.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $name = '';
		/**
		 * Field description.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $description = '';
		/**
		 * Required field?
		 *
		 * @since 1.0.0
		 * @var bool
		 */
		public $is_required;
		/**
		 * Deletable field?
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $can_delete = '1';
		/**
		 * Field position.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $field_order;
		/**
		 * Option order.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $option_order;
		/**
		 * Order child fields.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $order_by = '';
		/**
		 * Is this the default option?
		 *
		 * @since 1.0.0
		 * @var bool
		 */
		public $is_default_option;
		/**
		 * Field data visibility.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $visibility;
		/**
		 * Field data visibility.
		 *
		 * @since 1.9.0
		 * @since 2.4.0 Property marked protected. Now accessible by magic method or by `get_default_visibility()`.
		 * @var string
		 */
		protected $default_visibility;
		/**
		 * Is the visibility able to be modified?
		 *
		 * @since 2.3.0
		 * @since 2.4.0 Property marked protected. Now accessible by magic method or by `get_allow_custom_visibility()`.
		 * @var string
		 */
		protected $allow_custom_visibility;
		/**
		 * Whether values from this field are autolinked to directory searches.
		 *
		 * @since 2.5.0
		 * @var bool
		 */
		public $do_autolink;
		/**
		 * The signup position of the field into the signups form.
		 *
		 * @since 8.0.0
		 * @var int
		 */
		public $signup_position;
		/**
		 * Field type option.
		 *
		 * @since 2.0.0
		 * @var BP_XProfile_Field_Type Field type object used for validation.
		 */
		public $type_obj = \null;
		/**
		 * Field data for user ID.
		 *
		 * @since 2.0.0
		 * @var BP_XProfile_ProfileData Field data for user ID.
		 */
		public $data;
		/**
		 * Member types to which the profile field should be applied.
		 *
		 * @since 2.4.0
		 * @var array Array of member types.
		 */
		protected $member_types;
		/**
		 * Initialize and/or populate profile field.
		 *
		 * @since 1.1.0
		 *
		 * @param int|null $id Field ID.
		 * @param int|null $user_id User ID.
		 * @param bool     $get_data Get data.
		 */
		public function __construct($id = \null, $user_id = \null, $get_data = \true)
		{
		}
		/**
		 * Populate a profile field object.
		 *
		 * @since 1.1.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 * @global object $userdata
		 *
		 * @param int      $id Field ID.
		 * @param int|null $user_id User ID.
		 * @param bool     $get_data Get data.
		 */
		public function populate($id, $user_id = \null, $get_data = \true)
		{
		}
		/**
		 * Retrieve a `BP_XProfile_Field` instance.
		 *
		 * @since 2.4.0
		 * @since 2.8.0 Added `$user_id` and `$get_data` parameters.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @static
		 *
		 * @param int      $field_id ID of the field.
		 * @param int|null $user_id  Optional. ID of the user associated with the field.
		 *                           Ignored if `$get_data` is false. If `$get_data` is
		 *                           true, but no `$user_id` is provided, defaults to
		 *                           logged-in user ID.
		 * @param bool     $get_data Whether to fetch data for the specified `$user_id`.
		 * @return BP_XProfile_Field|false Field object if found, otherwise false.
		 */
		public static function get_instance($field_id, $user_id = \null, $get_data = \true)
		{
		}
		/**
		 * Fill object vars based on data passed to the method.
		 *
		 * @since 2.4.0
		 *
		 * @param array|object $args Array or object representing the `BP_XProfile_Field` properties.
		 *                           Generally, this is a row from the fields database table.
		 */
		public function fill_data($args)
		{
		}
		/**
		 * Magic getter.
		 *
		 * @since 2.4.0
		 *
		 * @param string $key Property name.
		 * @return string|null
		 */
		public function __get($key)
		{
		}
		/**
		 * Magic issetter.
		 *
		 * @since 2.4.0
		 *
		 * @param string $key Property name.
		 * @return bool
		 */
		public function __isset($key)
		{
		}
		/**
		 * Delete a profile field.
		 *
		 * @since 1.1.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param boolean $delete_data Whether or not to delete data.
		 * @return bool
		 */
		public function delete($delete_data = \false)
		{
		}
		/**
		 * Save a profile field.
		 *
		 * @since 1.1.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Get field data for a user ID.
		 *
		 * @since 1.2.0
		 *
		 * @param int $user_id ID of the user to get field data for.
		 * @return BP_XProfile_ProfileData
		 */
		public function get_field_data($user_id = 0)
		{
		}
		/**
		 * Get all child fields for this field ID.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param bool $for_editing Whether or not the field is for editing. Default to false.
		 * @return array
		 */
		public function get_children($for_editing = \false)
		{
		}
		/**
		 * Delete all field children for this field.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function delete_children()
		{
		}
		/**
		 * Gets the member types to which this field should be available.
		 *
		 * Will not return inactive member types, even if associated metadata is found.
		 *
		 * 'null' is a special pseudo-type, which represents users that do not have a member type.
		 *
		 * @since 2.4.0
		 *
		 * @return array Array of member type names.
		 */
		public function get_member_types()
		{
		}
		/**
		 * Sets the member types for this field.
		 *
		 * @since 2.4.0
		 *
		 * @param array $member_types Array of member types. Can include 'null' (users with no type) in addition to any
		 *                            registered types.
		 * @param bool  $append       Whether to append to existing member types. If false, all existing member type
		 *                            associations will be deleted before adding your `$member_types`. Default false.
		 * @return array Member types for the current field, after being saved.
		 */
		public function set_member_types($member_types, $append = \false)
		{
		}
		/**
		 * Gets a label representing the field's member types.
		 *
		 * This label is displayed alongside the field's name on the Profile Fields Dashboard panel.
		 *
		 * @since 2.4.0
		 *
		 * @return string
		 */
		public function get_member_type_label()
		{
		}
		/**
		 * Get the field's default visibility setting.
		 *
		 * Lazy-loaded to reduce overhead.
		 *
		 * Defaults to 'public' if no visibility setting is found in the database.
		 *
		 * @since 2.4.0
		 *
		 * @return string
		 */
		public function get_default_visibility()
		{
		}
		/**
		 * Get whether the field's default visibility can be overridden by users.
		 *
		 * Lazy-loaded to reduce overhead.
		 *
		 * Defaults to 'allowed'.
		 *
		 * @since 4.4.0
		 *
		 * @return string 'disabled' or 'allowed'.
		 */
		public function get_allow_custom_visibility()
		{
		}
		/**
		 * Get the field's signup position.
		 *
		 * @since 8.0.0
		 *
		 * @return int the field's signup position.
		 *             0 if the field has not been added to the signup form.
		 */
		public function get_signup_position()
		{
		}
		/**
		 * Get whether the field values should be auto-linked to a directory search.
		 *
		 * Lazy-loaded to reduce overhead.
		 *
		 * Defaults to true for multi and default fields, false for single fields.
		 *
		 * @since 2.5.0
		 *
		 * @return bool
		 */
		public function get_do_autolink()
		{
		}
		/* Static Methods ********************************************************/
		/**
		 * Get the type for provided field ID.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $field_id Field ID to get type of.
		 * @return bool|null|string
		 */
		public static function get_type($field_id = 0)
		{
		}
		/**
		 * Delete all fields in a field group.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $group_id ID of the field group to delete fields from.
		 * @return bool
		 */
		public static function delete_for_group($group_id = 0)
		{
		}
		/**
		 * Get field ID from field name.
		 *
		 * @since 1.5.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string $field_name Name of the field to query the ID for.
		 * @return int|null Field ID on success; null on failure.
		 */
		public static function get_id_from_name($field_name = '')
		{
		}
		/**
		 * Update field position and/or field group when relocating.
		 *
		 * @since 1.5.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int      $field_id       ID of the field to update.
		 * @param int|null $position       Field position to update.
		 * @param int|null $field_group_id ID of the field group.
		 * @return bool
		 */
		public static function update_position($field_id, $position = \null, $field_group_id = \null)
		{
		}
		/**
		 * Gets the IDs of fields applicable for a given member type or array of member types.
		 *
		 * @since 2.4.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string|array $member_types Member type or array of member types. Use 'any' to return unrestricted
		 *                                   fields (those available for anyone, regardless of member type).
		 * @return array Multi-dimensional array, with field IDs as top-level keys, and arrays of member types
		 *               associated with each field as values.
		 */
		public static function get_fields_for_member_type($member_types)
		{
		}
		/**
		 * Validate form field data on submission.
		 *
		 * @since 2.2.0
		 *
		 * @global string $message The feedback message to show.
		 *
		 * @return bool
		 */
		public static function admin_validate()
		{
		}
		/**
		 * Save miscellaneous settings for this field.
		 *
		 * Some field types have type-specific settings, which are saved here.
		 *
		 * @since 2.7.0
		 *
		 * @param array $settings Array of settings.
		 */
		public function admin_save_settings($settings)
		{
		}
		/**
		 * Populates the items for radio buttons, checkboxes, and dropdown boxes.
		 */
		public function render_admin_form_children()
		{
		}
		/**
		 * Oupput the admin form for this field.
		 *
		 * @since 1.9.0
		 *
		 * @param string $message Message to display.
		 */
		public function render_admin_form($message = '')
		{
		}
		/**
		 * Gets field type supports.
		 *
		 * @since 8.0.0
		 *
		 * @return bool[] Supported features.
		 */
		public function get_field_type_supports()
		{
		}
		/**
		 * Checks whether the field type supports the requested feature.
		 *
		 * @since 8.0.0
		 *
		 * @param string $support The name of the feature.
		 * @return bool True if the field type supports the feature. False otherwise.
		 */
		public function field_type_supports($support = '')
		{
		}
		/**
		 * Private method used to display the submit metabox.
		 *
		 * @since 2.3.0
		 *
		 * @param string $button_text Text to put on button.
		 */
		private function submit_metabox($button_text = '')
		{
		}
		/**
		 * Private method used to output field name and description fields.
		 *
		 * @since 2.3.0
		 */
		private function name_and_description()
		{
		}
		/**
		 * Private method used to output field Member Type metabox.
		 *
		 * @since 2.4.0
		 */
		private function member_type_metabox()
		{
		}
		/**
		 * Private method used to output field visibility metaboxes.
		 *
		 * @since 2.3.0
		 */
		private function visibility_metabox()
		{
		}
		/**
		 * Output the metabox for setting if field is required or not.
		 *
		 * @since 2.3.0
		 */
		private function required_metabox()
		{
		}
		/**
		 * Private method used to output autolink metabox.
		 *
		 * @since 2.5.0
		 */
		private function autolink_metabox()
		{
		}
		/**
		 * Output the metabox for setting what type of field this is.
		 *
		 * @since 2.3.0
		 */
		private function type_metabox()
		{
		}
		/**
		 * Output the metabox for setting the field's position into the signup form.
		 *
		 * @since 8.0.0
		 */
		private function signup_position_metabox()
		{
		}
		/**
		 * Output hidden fields used by default field.
		 *
		 * @since 2.3.0
		 */
		private function default_field_hidden_inputs()
		{
		}
		/**
		 * Return if a field ID is the default field.
		 *
		 * @since 2.3.0
		 *
		 * @param int $field_id ID of field to check.
		 * @return bool
		 */
		private function is_default_field($field_id = 0)
		{
		}
	}
	/**
	 * Represents a type of XProfile field and holds meta information about the type of value that it accepts.
	 *
	 * @since 2.0.0
	 */
	abstract class BP_XProfile_Field_Type
	{
		/**
		 * Validation regex rules for field type.
		 *
		 * @since 2.0.0
		 * @var array Field type validation regexes.
		 */
		protected $validation_regex = array();
		/**
		 * Allowed values for field type.
		 *
		 * @since 2.0.0
		 * @var array Field type allowed values.
		 */
		protected $validation_allowed_values = array();
		/**
		 * Name for field type.
		 *
		 * @since 2.0.0
		 * @var string The name of this field type.
		 */
		public $name = '';
		/**
		 * The name of the category that this field type should be grouped with. Used on the [Users > Profile Fields] screen in wp-admin.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $category = '';
		/**
		 * If allowed to store null/empty values.
		 *
		 * @since 2.0.0
		 * @var bool If this is set, allow BP to store null/empty values for this field type.
		 */
		public $accepts_null_value = \false;
		/**
		 * If this is set, BP will set this field type's list of allowed values from the field's options (e.g checkbox, selectbox).
		 *
		 * @since 2.0.0
		 * @var bool Does this field support options? e.g. selectbox, radio buttons, etc.
		 */
		public $supports_options = \false;
		/**
		 * If allowed to support multiple options as default.
		 *
		 * @since 2.0.0
		 * @var bool Does this field type support multiple options being set as default values? e.g. multiselectbox, checkbox.
		 */
		public $supports_multiple_defaults = \false;
		/**
		 * If the field type supports rich text by default.
		 *
		 * @since 2.4.0
		 * @var bool
		 */
		public $supports_richtext = \false;
		/**
		 * If the field type has a type-specific settings section on the Edit Field panel.
		 *
		 * @since 2.7.0
		 * @var bool|null Boolean if set explicitly by the type object, otherwise null.
		 */
		protected $do_settings_section = \null;
		/**
		 * If object is created by an BP_XProfile_Field object.
		 *
		 * @since 2.0.0
		 * @var BP_XProfile_Field If this object is created by instantiating a {@link BP_XProfile_Field},
		 *                        this is a reference back to that object.
		 */
		public $field_obj = \null;
		/**
		 * Field data visibility.
		 *
		 * @since 2.0.0
		 * @var string
		 */
		public $visibility;
		/**
		 * Constructor.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set a regex that profile data will be asserted against.
		 *
		 * You can call this method multiple times to set multiple formats. When validation is performed,
		 * it's successful as long as the new value matches any one of the registered formats.
		 *
		 * @since 2.0.0
		 *
		 * @param string $format         Regex string.
		 * @param string $replace_format Optional; if 'replace', replaces the format instead of adding to it.
		 *                               Defaults to 'add'.
		 * @return BP_XProfile_Field_Type
		 */
		public function set_format($format, $replace_format = 'add')
		{
		}
		/**
		 * Add a value to this type's list of allowed values that profile data will be asserted against.
		 *
		 * @since 2.0.0
		 * @deprecated 7.0.0 Use set_allowed_values() instead.
		 *
		 * @param string|array $values Whitelisted values.
		 * @return BP_XProfile_Field_Type
		 */
		public function set_whitelist_values($values)
		{
		}
		/**
		 * Add a value to this type's list of allowed values that profile data will be asserted against.
		 *
		 * You can call this method multiple times to set multiple formats. When validation is performed,
		 * it's successful as long as the new value matches any one of the registered formats.
		 *
		 * @since 7.0.0
		 *
		 * @param string|array $values Allowed values.
		 * @return BP_XProfile_Field_Type
		 */
		public function set_allowed_values($values)
		{
		}
		/**
		 * Check the given string against the registered formats for this field type.
		 *
		 * This method doesn't support chaining.
		 *
		 * @since 2.0.0
		 *
		 * @param string|array $values Value to check against the registered formats.
		 * @return bool True if the value validates
		 */
		public function is_valid($values)
		{
		}
		/**
		 * Check whether the current field type should have a settings ("options") section on the Edit Field panel.
		 *
		 * Falls back on `supports_options` if no value is set by the field type.
		 *
		 * @since 2.7.0
		 *
		 * @return bool
		 */
		public function do_settings_section()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public abstract function edit_field_html(array $raw_properties = array());
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public abstract function admin_field_html(array $raw_properties = array());
		/**
		 * Output the edit field options HTML for this field type.
		 *
		 * BuddyPress considers a field's "options" to be, for example, the items in a selectbox.
		 * These are stored separately in the database, and their templating is handled separately.
		 * Populate this method in a child class if it's required. Otherwise, you can leave it out.
		 *
		 * This templating is separate from {@link BP_XProfile_Field_Type::edit_field_html()} because
		 * it's also used in the wp-admin screens when creating new fields, and for backwards compatibility.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $args Optional. The arguments passed to {@link bp_the_profile_field_options()}.
		 */
		public function edit_field_options_html(array $args = array())
		{
		}
		/**
		 * Output HTML for this field type's children options on the wp-admin Profile Fields "Add Field" and "Edit Field" screens.
		 *
		 * You don't need to implement this method for all field types. It's used in core by the
		 * selectbox, multi selectbox, checkbox, and radio button fields, to allow the admin to
		 * enter the child option values (e.g. the choices in a select box).
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                          field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
		/**
		 * Allow field types to modify submitted values before they are validated.
		 *
		 * In some cases, it may be appropriate for a field type to catch
		 * submitted values and modify them before they are passed to the
		 * is_valid() method. For example, URL validation requires the
		 * 'http://' scheme (so that the value saved in the database is always
		 * a fully-formed URL), but in order to allow users to enter a URL
		 * without this scheme, BP_XProfile_Field_Type_URL prepends 'http://'
		 * when it's not present.
		 *
		 * By default, this is a pass-through method that does nothing. Only
		 * override in your own field type if you need this kind of pre-
		 * validation filtering.
		 *
		 * @since 2.1.0
		 * @since 2.4.0 Added the `$field_id` parameter.
		 *
		 * @param mixed      $field_value Submitted field value.
		 * @param string|int $field_id    Optional. ID of the field.
		 * @return mixed
		 */
		public static function pre_validate_filter($field_value, $field_id = '')
		{
		}
		/**
		 * Allow field types to modify the appearance of their values.
		 *
		 * By default, this is a pass-through method that does nothing. Only
		 * override in your own field type if you need to provide custom
		 * filtering for output values.
		 *
		 * @since 2.1.0
		 * @since 2.4.0 Added `$field_id` parameter.
		 *
		 * @param mixed      $field_value Field value.
		 * @param string|int $field_id    ID of the field.
		 * @return mixed
		 */
		public static function display_filter($field_value, $field_id = '')
		{
		}
		/**
		 * Save miscellaneous settings related to this field type.
		 *
		 * Override in a specific field type if it requires an admin save routine.
		 *
		 * @since 2.7.0
		 *
		 * @param int   $field_id Field ID.
		 * @param array $settings Array of settings.
		 */
		public function admin_save_settings($field_id, $settings)
		{
		}
		/** Protected *************************************************************/
		/**
		 * Get a sanitized and escaped string of the edit field's HTML elements and attributes.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 * This method was intended to be static but couldn't be because php.net/lsb/ requires PHP >= 5.3.
		 *
		 * @since 2.0.0
		 *
		 * @param array $properties Optional key/value array of attributes for this edit field.
		 * @return string
		 */
		protected function get_edit_field_html_elements(array $properties = array())
		{
		}
		/**
		 * Output a sanitized and escaped string of the edit field's HTML elements and attributes.
		 *
		 * @since 12.4.1
		 *
		 * @param array $properties Optional key/value array of attributes for this edit field.
		 */
		protected function output_edit_field_html_elements(array $properties = array())
		{
		}
	}
	/**
	 * Checkbox xprofile field type.
	 *
	 * @since 2.0.0
	 */
	class BP_XProfile_Field_Type_Checkbox extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the checkbox field type.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/input.checkbox.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output the edit field options HTML for this field type.
		 *
		 * BuddyPress considers a field's "options" to be, for example, the items in a selectbox.
		 * These are stored separately in the database, and their templating is handled separately.
		 *
		 * This templating is separate from {@link BP_XProfile_Field_Type::edit_field_html()} because
		 * it's also used in the wp-admin screens when creating new fields, and for backwards compatibility.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $args Optional. The arguments passed to {@link bp_the_profile_field_options()}.
		 */
		public function edit_field_options_html(array $args = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type's children options on the wp-admin Profile Fields "Add Field" and "Edit Field" screens.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                                         field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
	}
	/**
	 * XProfile Field Groups Endpoints.
	 *
	 * Use /xprofile/groups
	 * Use /xprofile/groups/{id}
	 *
	 * @since 5.0.0
	 */
	class BP_REST_XProfile_Field_Groups_Endpoint extends \WP_REST_Controller
	{
		/**
		 * XProfile Fields Class.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_REST_XProfile_Fields_Endpoint
		 */
		protected $fields_endpoint;
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Edit some properties for the CREATABLE & EDITABLE methods.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Retrieve XProfile groups.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to XProfile field groups items.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Retrieve single XProfile field group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to get information about a specific field group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Create a XProfile field group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Check if a given request has access to create a XProfile field group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Update a XProfile field group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to create a XProfile field group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Delete a XProfile field group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete a field group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares single XProfile field group data for return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_XProfile_Group $group   XProfile field group data.
		 * @param WP_REST_Request   $request Full data about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($group, $request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_XProfile_Group $group XProfile field group.
		 * @return array
		 */
		protected function prepare_links($group)
		{
		}
		/**
		 * Get XProfile field group object.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return BP_XProfile_Group|string XProfile field group object.
		 */
		public function get_xprofile_field_group_object($request)
		{
		}
		/**
		 * Get the XProfile field group schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for XProfile field groups.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * Telephone number xprofile field type.
	 *
	 * @since 3.0.0
	 */
	class BP_XProfile_Field_Type_Telephone extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the telephone number field type.
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 3.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/input.text.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 3.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * This method usually outputs HTML for this field type's children options on the wp-admin Profile Fields
		 * "Add Field" and "Edit Field" screens, but for this field type, we don't want it, so it's stubbed out.
		 *
		 * @since 3.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the
		 *                                         current field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
		/**
		 * Format URL values for display.
		 *
		 * @since 3.0.0
		 *
		 * @param string     $field_value The URL value, as saved in the database.
		 * @param string|int $field_id    Optional. ID of the field.
		 *
		 * @return string URL converted to a link.
		 */
		public static function display_filter($field_value, $field_id = '')
		{
		}
	}
	/**
	 * Textarea xprofile field type.
	 *
	 * @since 2.0.0
	 */
	class BP_XProfile_Field_Type_Textarea extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the textarea field type.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/textarea.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * This method usually outputs HTML for this field type's children options on the wp-admin Profile Fields
		 * "Add Field" and "Edit Field" screens, but for this field type, we don't want it, so it's stubbed out.
		 *
		 * @since 2.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                                         field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
	}
	/**
	 * Textbox xprofile field type.
	 *
	 * @since 2.0.0
	 */
	class BP_XProfile_Field_Type_Textbox extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the textbox field type.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/input.text.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * This method usually outputs HTML for this field type's children options on the wp-admin Profile Fields
		 * "Add Field" and "Edit Field" screens, but for this field type, we don't want it, so it's stubbed out.
		 *
		 * @since 2.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the
		 *                                         current field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
	}
	/**
	 * URL xprofile field type.
	 *
	 * @since 2.1.0
	 */
	class BP_XProfile_Field_Type_URL extends \BP_XProfile_Field_Type
	{
		/**
		 * Supported features for the URL field type.
		 *
		 * @since 8.0.0
		 * @var bool[] The URL field type supported features.
		 */
		public static $supported_features = array('do_autolink' => \false);
		/**
		 * Constructor for the URL field type
		 *
		 * @since 2.1.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.1.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/input.number.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.1.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted
		 *                              attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * This method usually outputs HTML for this field type's children options
		 * on the wp-admin Profile Fields "Add Field" and "Edit Field" screens, but
		 * for this field type, we don't want it, so it's stubbed out.
		 *
		 * @since 2.1.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                                         field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
		/**
		 * Modify submitted URL values before validation.
		 *
		 * The URL validation regex requires a http(s) protocol, so that all
		 * values saved in the database are fully-formed URLs. However, we
		 * still want to allow users to enter URLs without a protocol, for a
		 * better user experience. So we catch submitted URL values, and if
		 * the protocol is missing, we prepend 'http://' before passing to
		 * is_valid().
		 *
		 * @since 2.1.0
		 * @since 2.4.0 Added the `$field_id` parameter.
		 *
		 * @param string     $submitted_value Raw value submitted by the user.
		 * @param string|int $field_id        Optional. ID of the field.
		 * @return string
		 */
		public static function pre_validate_filter($submitted_value = '', $field_id = '')
		{
		}
		/**
		 * Format URL values for display.
		 *
		 * @since 2.1.0
		 * @since 2.4.0 Added the `$field_id` parameter.
		 *
		 * @param string     $field_value The URL value, as saved in the database.
		 * @param string|int $field_id    Optional. ID of the field.
		 * @return string URL converted to a link.
		 */
		public static function display_filter($field_value, $field_id = '')
		{
		}
	}
	/**
	 * XProfile Fields endpoints.
	 *
	 * Use /xprofile/fields
	 * Use /xprofile/fields/{id}
	 *
	 * @since 5.0.0
	 */
	class BP_REST_XProfile_Fields_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve XProfile fields.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to XProfile fields.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Retrieve single XProfile field.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to get information about a specific XProfile field.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Set additional field properties.
		 *
		 * @since 5.0.0
		 *
		 * @param integer         $field_id The profile field object ID.
		 * @param WP_REST_Request $request  The request sent to the API.
		 */
		public function set_additional_field_properties($field_id, \WP_REST_Request $request)
		{
		}
		/**
		 * Create a XProfile field.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Check if a given request has access to create a XProfile field.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Update a XProfile field.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to update a XProfile field.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Delete a XProfile field.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete a XProfile field.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares single XProfile field data to return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_XProfile_Field $field   XProfile field object.
		 * @param WP_REST_Request   $request Full data about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($field, $request)
		{
		}
		/**
		 * Assembles single XProfile field data to return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_XProfile_Field $field   XProfile field object.
		 * @param WP_REST_Request   $request Full data about the request.
		 * @return array
		 */
		public function assemble_response_data($field, $request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_XProfile_Field $field XProfile field object.
		 * @return array
		 */
		protected function prepare_links($field)
		{
		}
		/**
		 * Get XProfile field object.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request|int $request Request info or integer.
		 * @return BP_XProfile_Field|string
		 */
		public function get_xprofile_field_object($request)
		{
		}
		/**
		 * Retrieve the rendered value of a profile field.
		 *
		 * @since 5.0.0
		 *
		 * @param  string                    $value         The raw value of the field.
		 * @param  integer|BP_XProfile_Field $profile_field The ID or the full object for the field.
		 * @return string                                   The field value for the display context.
		 */
		public function get_profile_field_rendered_value($value = '', $profile_field = \null)
		{
		}
		/**
		 * Retrieve the unserialized value of a profile field.
		 *
		 * @since 5.0.0
		 *
		 * @param  string $value The raw value of the field.
		 * @return array The unserialized field value.
		 */
		public function get_profile_field_unserialized_value($value = '')
		{
		}
		/**
		 * Edit some properties for the CREATABLE & EDITABLE methods.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the XProfile field schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for the XProfile fields.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * Datebox xprofile field type.
	 *
	 * @since 2.0.0
	 */
	class BP_XProfile_Field_Type_Datebox extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the datebox field type.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/input.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output the edit field options HTML for this field type.
		 *
		 * BuddyPress considers a field's "options" to be, for example, the items in a selectbox.
		 * These are stored separately in the database, and their templating is handled separately.
		 *
		 * This templating is separate from {@link BP_XProfile_Field_Type::edit_field_html()} because
		 * it's also used in the wp-admin screens when creating new fields, and for backwards compatibility.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $args Optional. The arguments passed to {@link bp_the_profile_field_options()}.
		 */
		public function edit_field_options_html(array $args = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Get settings for a given date field.
		 *
		 * @since 2.7.0
		 *
		 * @param int $field_id ID of the field.
		 * @return array
		 */
		public static function get_field_settings($field_id)
		{
		}
		/**
		 * Validate date field settings.
		 *
		 * @since 2.7.0
		 *
		 * @param array $settings Raw settings.
		 * @return array Validated settings.
		 */
		public static function validate_settings($settings)
		{
		}
		/**
		 * Save settings from the field edit screen in the Dashboard.
		 *
		 * @param int   $field_id ID of the field.
		 * @param array $settings Array of settings.
		 * @return bool
		 */
		public function admin_save_settings($field_id, $settings)
		{
		}
		/**
		 * Generate the settings markup for Date fields.
		 *
		 * @since 2.7.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                                         field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
		/**
		 * Format Date values for display.
		 *
		 * @since 2.1.0
		 * @since 2.4.0 Added the `$field_id` parameter.
		 *
		 * @param string     $field_value The date value, as saved in the database. Typically, this is a MySQL-formatted
		 *                                date string (Y-m-d H:i:s).
		 * @param string|int $field_id    Optional. ID of the field.
		 * @return string Date formatted by bp_format_time().
		 */
		public static function display_filter($field_value, $field_id = '')
		{
		}
		/**
		 * Gets the default date formats available when configuring a Date field.
		 *
		 * @since 2.7.0
		 *
		 * @return array
		 */
		public function get_date_formats()
		{
		}
	}
	/**
	 * Base class for xprofile field types that set/get WordPress profile data from usermeta.
	 *
	 * @since 8.0.0
	 */
	abstract class BP_XProfile_Field_Type_WordPress extends \BP_XProfile_Field_Type
	{
		/**
		 * The usermeta key for the WordPress field.
		 *
		 * @since 8.0.0
		 * @var string The meta key name of this WordPress field.
		 */
		public $wp_user_key = '';
		/**
		 * The WordPress supported user keys.
		 *
		 * @since 8.0.0
		 * @var string[] The WordPress supported user keys.
		 */
		public $supported_keys = array();
		/**
		 * WordPress field's visibility setting.
		 *
		 * Defaults to 'public'. This property enforces Field's default visibility.
		 *
		 * @since 8.0.0
		 *
		 * @return string The WordPress field's visibility setting.
		 */
		public $visibility = 'public';
		/**
		 * Supported features for the WordPress field type.
		 *
		 * @since 8.0.0
		 * @var bool[] The WordPress field supported features.
		 */
		public static $supported_features = array('switch_fieldtype' => \false, 'required' => \false, 'do_autolink' => \false, 'allow_custom_visibility' => \false, 'member_types' => \false, 'signup_position' => \true);
		/**
		 * Constructor for the WordPress field type.
		 *
		 * @since 8.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Sanitize the user field before inserting it into db.
		 *
		 * @since 8.0.0
		 *
		 * @param string $value The user field value.
		 */
		public abstract function sanitize_for_db($value);
		/**
		 * Sanitize the user field before displaying it as an attribute.
		 *
		 * @since 8.0.0
		 *
		 * @param string $value The user field value.
		 * @param integer $user_id The user ID.
		 */
		public abstract function sanitize_for_output($value, $user_id = 0);
		/**
		 * Sets the WordPress field value.
		 *
		 * @since 8.0.0
		 *
		 * @param boolean $retval Whether to shortcircuit the $bp->profile->table_name_data table.
		 *                        Default `false`.
		 * @param array $field_args {
		 *     An array of arguments.
		 *
		 *     @type object            $field_type_obj Field type object.
		 *     @type BP_XProfile_Field $field          Field object.
		 *     @type integer           $user_id        The user ID.
		 *     @type mixed             $value          Value passed to xprofile_set_field_data().
		 *     @type boolean           $is_required    Whether or not the field is required.
		 * }
		 * @return bool Whether to shortcircuit the $bp->profile->table_name_data table.
		 */
		public function set_field_value($retval = \false, $field_args = array())
		{
		}
		/**
		 * Gets the WordPress field value during an xProfile fields loop.
		 *
		 * This function is used inside `BP_XProfile_ProfileData::get_data_for_user()`
		 * to include the WordPress field value into the xProfile fields loop.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param integer $user_id The user ID.
		 * @param integer $field_id The xProfile field ID.
		 * @return array An array containing the metadata `id`, `value` and `table_name`.
		 */
		public function get_field_value($user_id, $field_id = 0)
		{
		}
	}
	/**
	 * Class to help set up XProfile Groups.
	 *
	 * @since 1.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_XProfile_Group
	{
		/**
		 * Field group ID.
		 *
		 * @since 1.1.0
		 * @var int ID of field group.
		 */
		public $id = \null;
		/**
		 * Field group name.
		 *
		 * @since 1.1.0
		 * @var string Name of field group.
		 */
		public $name;
		/**
		 * Field group Description.
		 *
		 * @since 1.1.0
		 * @var string Description of field group.
		 */
		public $description;
		/**
		 * Group deletion boolean.
		 *
		 * @since 1.1.0
		 * @var bool Can this group be deleted?
		 */
		public $can_delete;
		/**
		 * Group order.
		 *
		 * @since 1.1.0
		 * @var int Group order relative to other groups.
		 */
		public $group_order;
		/**
		 * Group fields.
		 *
		 * @since 1.1.0
		 * @var array Fields of group.
		 */
		public $fields;
		/**
		 * Initialize and/or populate profile field group.
		 *
		 * @since 1.1.0
		 *
		 * @param int|null $id Field group ID.
		 */
		public function __construct($id = \null)
		{
		}
		/**
		 * Populate a profile field group.
		 *
		 * @since 1.0.0
		 *
		 * @param int $id Field group ID.
		 * @return bool
		 */
		public function populate($id)
		{
		}
		/**
		 * Save a profile field group.
		 *
		 * @since 1.1.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Delete a profile field group
		 *
		 * @since 1.1.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function delete()
		{
		}
		/** Static Methods ********************************************************/
		/**
		 * Populates the BP_XProfile_Group object with profile field groups, fields,
		 * and field data.
		 *
		 * @since 1.2.0
		 * @since 2.4.0  Introduced `$member_type` argument.
		 * @since 8.0.0  Introduced `$hide_field_types` & `$signup_fields_only` arguments.
		 * @since 11.0.0 `$profile_group_id` accepts an array of profile group ids.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *      Array of optional arguments.
		 *
		 *      @type int|int[]|bool $profile_group_id   Limit results to a single profile group or a comma-separated list or array of
		 *                                               profile group ids. Default: false.
		 *      @type int            $user_id            Required if you want to load a specific user's data.
		 *                                               Default: displayed user's ID.
		 *      @type array|string   $member_type        Limit fields by those restricted to a given member type, or array of
		 *                                               member types. If `$user_id` is provided, the value of `$member_type`
		 *                                               will be overridden by the member types of the provided user. The
		 *                                               special value of 'any' will return only those fields that are
		 *                                               unrestricted by member type - i.e., those applicable to any type.
		 *      @type bool           $hide_empty_groups  True to hide groups that don't have any fields. Default: false.
		 *      @type bool           $hide_empty_fields  True to hide fields where the user has not provided data.
		 *                                               Default: false.
		 *      @type bool           $fetch_fields       Whether to fetch each group's fields. Default: false.
		 *      @type bool           $fetch_field_data   Whether to fetch data for each field. Requires a $user_id.
		 *                                               Default: false.
		 *      @type int[]|bool     $exclude_groups     Comma-separated list or array of group IDs to exclude.
		 *      @type int[]|bool     $exclude_fields     Comma-separated list or array of field IDs to exclude.
		 *      @type string[]       $hide_field_types   List of field types to hide form loop. Default: empty array.
		 *      @type bool           $signup_fields_only Whether to only return signup fields. Default: false.
		 *      @type bool           $update_meta_cache  Whether to pre-fetch xprofilemeta for all retrieved groups, fields,
		 *                                               and data. Default: true.
		 * }
		 * @return array
		 */
		public static function get($args = array())
		{
		}
		/**
		 * Gets group IDs, based on passed parameters.
		 *
		 * @since 5.0.0
		 * @since 11.0.0 `$profile_group_id` accepts an array of profile group ids.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *    Array of optional arguments.
		 *
		 *    @type int|int[]|bool $profile_group_id  Limit results to a single profile group or a comma-separated list or array of
		 *                                       profile group ids. Default: false.
		 *    @type int[]          $exclude_groups    Comma-separated list or array of group IDs to exclude. Default: false.
		 *    @type bool           $hide_empty_groups True to hide groups that don't have any fields. Default: false.
		 * }
		 * @return array
		 */
		public static function get_group_ids($args = array())
		{
		}
		/**
		 * Gets group field IDs, based on passed parameters.
		 *
		 * @since 5.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $group_ids Array of group IDs.
		 * @param array $args {
		 *    Array of optional arguments:
		 *      @type array        $exclude_fields    Comma-separated list or array of field IDs to exclude.
		 *                                            Default empty.
		 *      @type int          $user_id           Limit results to fields associated with a given user's
		 *                                            member type. Default empty.
		 *      @type array|string $member_type       Limit fields by those restricted to a given member type, or array of
		 *                                            member types. If `$user_id` is provided, the value of `$member_type`
		 *                                            is honored.
		 * }
		 * @return array
		 */
		public static function get_group_field_ids($group_ids, $args = array())
		{
		}
		/**
		 * Get data about a set of groups, based on IDs.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $group_ids Array of IDs.
		 * @return array
		 */
		protected static function get_group_data($group_ids)
		{
		}
		/**
		 * Validate field group when form submitted.
		 *
		 * @since 1.0.0
		 *
		 * @global string $message The feedback message to show.
		 *
		 * @return bool
		 */
		public static function admin_validate()
		{
		}
		/**
		 * Update field group position.
		 *
		 * @since 1.5.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param  int $field_group_id ID of the group the field belongs to.
		 * @param  int $position       Field group position.
		 * @return bool
		 */
		public static function update_position($field_group_id, $position)
		{
		}
		/**
		 * Fetch the field visibility level for the fields returned by the query.
		 *
		 * @since 1.6.0
		 *
		 * @param int   $user_id The profile owner's user_id.
		 * @param array $fields  The database results returned by the get() query.
		 * @return array $fields The database results, with field_visibility added
		 */
		public static function fetch_visibility_level($user_id = 0, $fields = array())
		{
		}
		/**
		 * Fetch the admin-set preferences for all fields.
		 *
		 * @since 1.6.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return array $default_visibility_levels An array, keyed by field_id, of default
		 *                                          visibility level + allow_custom
		 *                                          (whether the admin allows this
		 *                                          field to be set by user)
		 */
		public static function fetch_default_visibility_levels()
		{
		}
		/** Admin Output **********************************************************/
		/**
		 * Output the admin area field group form.
		 *
		 * @since 1.0.0
		 *
		 * @global string $message The feedback message to show.
		 */
		public function render_admin_form()
		{
		}
	}
	/**
	 * Multi-selectbox xprofile field type.
	 *
	 * @since 2.0.0
	 */
	class BP_XProfile_Field_Type_Multiselectbox extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the multi-selectbox field type.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/select.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output the edit field options HTML for this field type.
		 *
		 * BuddyPress considers a field's "options" to be, for example, the items in a selectbox.
		 * These are stored separately in the database, and their templating is handled separately.
		 *
		 * This templating is separate from {@link BP_XProfile_Field_Type::edit_field_html()} because
		 * it's also used in the wp-admin screens when creating new fields, and for backwards compatibility.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $args Optional. The arguments passed to {@link bp_the_profile_field_options()}.
		 */
		public function edit_field_options_html(array $args = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type's children options on the wp-admin Profile Fields,
		 * "Add Field" and "Edit Field" screens.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                                         field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
	}
	/**
	 * WordPress xProfile regular field type.
	 *
	 * @since 8.0.0
	 */
	class BP_XProfile_Field_Type_WordPress_Textbox extends \BP_XProfile_Field_Type_WordPress
	{
		/**
		 * Constructor for the WordPress regular field type.
		 *
		 * @since 8.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Sets the WordPress field wp_user_key property before saving the xProfile field.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_XProfile_Field $field Field object.
		 */
		public function set_wp_user_key($field)
		{
		}
		/**
		 * Gets the WordPress field value during an xProfile fields loop.
		 *
		 * This function is used inside `BP_XProfile_ProfileData::get_data_for_user()`
		 * to include the WordPress field value into the xProfile fields loop.
		 *
		 * @since 8.0.0
		 *
		 * @param integer $user_id The user ID.
		 * @param integer $field_id The xProfile field ID.
		 * @return array An array containing the metadata `id`, `value` and `table_name`.
		 */
		public function get_field_value($user_id, $field_id = 0)
		{
		}
		/**
		 * Sanitize the user field before saving it to db.
		 *
		 * @since 8.0.0
		 *
		 * @param string $value The user field value.
		 * @return string The sanitized field value.
		 */
		public function sanitize_for_db($value)
		{
		}
		/**
		 * Sanitize the user field before displaying it as an attribute.
		 *
		 * @since 8.0.0
		 *
		 * @param string $value The user field value.
		 * @return string The sanitized field value.
		 */
		public function sanitize_for_output($value, $user_id = 0)
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 8.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/textarea.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 8.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Get settings for a given WordPress field.
		 *
		 * @since 8.0.0
		 *
		 * @param int $field_id ID of the field.
		 * @return string The meta_key used for this field.
		 */
		public static function get_field_settings($field_id)
		{
		}
		/**
		 * Save settings from the field edit screen in the Dashboard.
		 *
		 * @since 8.0.0
		 *
		 * @param int   $field_id ID of the field.
		 * @param array $settings Array of settings.
		 * @return bool
		 */
		public function admin_save_settings($field_id, $settings)
		{
		}
		/**
		 * This method usually outputs HTML for this field type's children options on the wp-admin Profile Fields
		 * "Add Field" and "Edit Field" screens, but for this field type, we don't want it, so it's stubbed out.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the
		 *                                         current field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
		/**
		 * Format WordPress field values for display.
		 *
		 * @since 8.0.0
		 *
		 * @param string     $field_value The field value, as saved in the database.
		 * @param string|int $field_id    Optional. ID of the field.
		 * @return string The sanitized WordPress field.
		 */
		public static function display_filter($field_value, $field_id = '')
		{
		}
	}
	/**
	 * Selectbox xprofile field type.
	 *
	 * @since 2.0.0
	 */
	class BP_XProfile_Field_Type_Selectbox extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the selectbox field type.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/select.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output the edit field options HTML for this field type.
		 *
		 * BuddyPress considers a field's "options" to be, for example, the items in a selectbox.
		 * These are stored separately in the database, and their templating is handled separately.
		 *
		 * This templating is separate from {@link BP_XProfile_Field_Type::edit_field_html()} because
		 * it's also used in the wp-admin screens when creating new fields, and for backwards compatibility.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $args Optional. The arguments passed to {@link bp_the_profile_field_options()}.
		 */
		public function edit_field_options_html(array $args = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type's children options on the wp-admin Profile Fields "Add Field" and "Edit Field" screens.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                                         field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
	}
	/**
	 * Load xProfile Profile admin area.
	 *
	 * @since 2.0.0
	 */
	class BP_XProfile_User_Admin
	{
		/**
		 * Setup xProfile User Admin.
		 *
		 * @since 2.0.0
		 *
		 * @return BP_XProfile_User_Admin
		 */
		public static function register_xprofile_user_admin()
		{
		}
		/**
		 * Constructor method.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set admin-related actions and filters.
		 *
		 * @since 2.0.0
		 */
		private function setup_actions()
		{
		}
		/**
		 * Register the xProfile metabox on Community Profile admin page.
		 *
		 * @since 2.0.0
		 *
		 * @param int         $user_id       ID of the user being edited.
		 * @param string      $screen_id     Screen ID to load the metabox in.
		 * @param object|null $stats_metabox Context and priority for the stats metabox.
		 */
		public function register_metaboxes($user_id = 0, $screen_id = '', $stats_metabox = \null)
		{
		}
		/**
		 * Save the profile fields in Members community profile page.
		 *
		 * Loaded before the page is rendered, this function is processing form
		 * requests.
		 *
		 * @since 2.0.0
		 * @since 6.0.0 The `delete_avatar` action is now managed into BP_Members_Admin::user_admin_load().
		 *
		 * @param string $doaction    Action being run.
		 * @param int    $user_id     ID for the user whose profile is being saved.
		 * @param array  $request     Request being made.
		 * @param string $redirect_to Where to redirect user to.
		 */
		public function user_admin_load($doaction = '', $user_id = 0, $request = array(), $redirect_to = '')
		{
		}
		/**
		 * Render the xprofile metabox for Community Profile screen.
		 *
		 * @since 2.0.0
		 *
		 * @param WP_User|null $user The WP_User object for the user being edited.
		 * @param array        $args Array of arguments for metaboxes.
		 */
		public function user_admin_profile_metaboxes($user = \null, $args = array())
		{
		}
		/**
		 * Render the fallback metabox in case a user has been marked as a spammer.
		 *
		 * @since 2.0.0
		 *
		 * @param WP_User|null $user The WP_User object for the user being edited.
		 */
		public function user_admin_spammer_metabox($user = \null)
		{
		}
	}
	/**
	 * WordPress Biography xProfile field type.
	 *
	 * @since 8.0.0
	 */
	class BP_XProfile_Field_Type_WordPress_Biography extends \BP_XProfile_Field_Type_WordPress
	{
		/**
		 * Constructor for the WordPress biography field type.
		 *
		 * @since 8.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Sanitize the user field before saving it to db.
		 *
		 * @since 8.0.0
		 *
		 * @param string $value The user field value.
		 * @return string The sanitized field value.
		 */
		public function sanitize_for_db($value)
		{
		}
		/**
		 * Sanitize the user field before displaying it as an attribute.
		 *
		 * @since 8.0.0
		 *
		 * @param string $value The user field value.
		 * @param integer $user_id The user ID.
		 * @return string The sanitized field value.
		 */
		public function sanitize_for_output($value, $user_id = 0)
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 8.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/textarea.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 8.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * This method usually outputs HTML for this field type's children options on the wp-admin Profile Fields
		 * "Add Field" and "Edit Field" screens, but for this field type, we don't want it, so it's stubbed out.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the
		 *                                         current field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
		/**
		 * Format WordPress Biography for display.
		 *
		 * @since 8.0.0
		 *
		 * @param string     $field_value The field value, as saved in the database.
		 * @param string|int $field_id    Optional. ID of the field.
		 * @return string The sanitized WordPress field.
		 */
		public static function display_filter($field_value, $field_id = '')
		{
		}
	}
	/**
	 * Class for generating SQL clauses to filter a user query by xprofile data.
	 *
	 * @since 2.2.0
	 */
	class BP_XProfile_Query
	{
		/**
		 * Array of xprofile queries.
		 *
		 * See {@see WP_XProfile_Query::__construct()} for information on parameters.
		 *
		 * @since 2.2.0
		 * @var array
		 */
		public $queries = array();
		/**
		 * Database table that where the metadata's objects are stored (eg $wpdb->users).
		 *
		 * @since 2.2.0
		 * @var string
		 */
		public $primary_table;
		/**
		 * Column in primary_table that represents the ID of the object.
		 *
		 * @since 2.2.0
		 * @var string
		 */
		public $primary_id_column;
		/**
		 * A flat list of table aliases used in JOIN clauses.
		 *
		 * @since 2.2.0
		 * @var array
		 */
		protected $table_aliases = array();
		/**
		 * Constructor.
		 *
		 * @since 2.2.0
		 *
		 * @param array $xprofile_query {
		 *     Array of xprofile query clauses.
		 *
		 *     @type string $relation Optional. The MySQL keyword used to join the clauses of the query.
		 *                            Accepts 'AND', or 'OR'. Default 'AND'.
		 *     @type array {
		 *         Optional. An array of first-order clause parameters, or another fully-formed xprofile query.
		 *
		 *         @type string|int $field   XProfile field to filter by. Accepts a field name or ID.
		 *         @type string     $value   XProfile value to filter by.
		 *         @type string     $compare MySQL operator used for comparing the $value. Accepts '=', '!=', '>',
		 *                                   '>=', '<', '<=', 'LIKE', 'NOT LIKE', 'IN', 'NOT IN', 'BETWEEN',
		 *                                   'NOT BETWEEN', 'REGEXP', 'NOT REGEXP', or 'RLIKE'. Default is 'IN'
		 *                                   when `$value` is an array, '=' otherwise.
		 *         @type string     $type    MySQL data type that the `value` column will be CAST to for comparisons.
		 *                                   Accepts 'NUMERIC', 'BINARY', 'CHAR', 'DATE', 'DATETIME', 'DECIMAL',
		 *                                   'SIGNED', 'TIME', or 'UNSIGNED'. Default is 'CHAR'.
		 *     }
		 * }
		 */
		public function __construct($xprofile_query)
		{
		}
		/**
		 * Ensure the `xprofile_query` argument passed to the class constructor is well-formed.
		 *
		 * Eliminates empty items and ensures that a 'relation' is set.
		 *
		 * @since 2.2.0
		 *
		 * @param array $queries Array of query clauses.
		 * @return array Sanitized array of query clauses.
		 */
		public function sanitize_query($queries)
		{
		}
		/**
		 * Determine whether a query clause is first-order.
		 *
		 * A first-order query clause is one that has either a 'key' or a 'value' array key.
		 *
		 * @since 2.2.0
		 *
		 * @param  array $query XProfile query arguments.
		 * @return bool  Whether the query clause is a first-order clause.
		 */
		protected function is_first_order_clause($query)
		{
		}
		/**
		 * Return the appropriate alias for the given field type if applicable.
		 *
		 * @since 2.2.0
		 *
		 * @param string $type MySQL type to cast `value`.
		 * @return string MySQL type.
		 */
		public function get_cast_for_type($type = '')
		{
		}
		/**
		 * Generate SQL clauses to be appended to a main query.
		 *
		 * Called by the public {@see BP_XProfile_Query::get_sql()}, this method is abstracted out to maintain parity
		 * with WP's Query classes.
		 *
		 * @since 2.2.0
		 *
		 * @return array {
		 *     Array containing JOIN and WHERE SQL clauses to append to the main query.
		 *
		 *     @type string $join  SQL fragment to append to the main JOIN clause.
		 *     @type string $where SQL fragment to append to the main WHERE clause.
		 * }
		 */
		protected function get_sql_clauses()
		{
		}
		/**
		 * Generate SQL clauses for a single query array.
		 *
		 * If nested subqueries are found, this method recurses the tree to produce the properly nested SQL.
		 *
		 * @since 2.2.0
		 *
		 * @param  array $query Query to parse. Passed by reference.
		 * @param  int   $depth Optional. Number of tree levels deep we currently are. Used to calculate indentation.
		 * @return array {
		 *     Array containing JOIN and WHERE SQL clauses to append to a single query array.
		 *
		 *     @type string $join  SQL fragment to append to the main JOIN clause.
		 *     @type string $where SQL fragment to append to the main WHERE clause.
		 * }
		 */
		protected function get_sql_for_query(&$query, $depth = 0)
		{
		}
		/**
		 * Generates SQL clauses to be appended to a main query.
		 *
		 * @since 2.2.0
		 *
		 * @param string $primary_table     Database table where the object being filtered is stored (eg wp_users).
		 * @param string $primary_id_column ID column for the filtered object in $primary_table.
		 * @return array {
		 *     Array containing JOIN and WHERE SQL clauses to append to the main query.
		 *
		 *     @type string $join  SQL fragment to append to the main JOIN clause.
		 *     @type string $where SQL fragment to append to the main WHERE clause.
		 * }
		 */
		public function get_sql($primary_table, $primary_id_column)
		{
		}
		/**
		 * Generate SQL JOIN and WHERE clauses for a first-order query clause.
		 *
		 * "First-order" means that it's an array with a 'field' or 'value'.
		 *
		 * @since 2.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $clause       Query clause.
		 * @param array $parent_query Parent query array.
		 * @return array {
		 *     Array containing JOIN and WHERE SQL clauses to append to a first-order query.
		 *
		 *     @type string $join  SQL fragment to append to the main JOIN clause.
		 *     @type string $where SQL fragment to append to the main WHERE clause.
		 * }
		 */
		public function get_sql_for_clause(&$clause, $parent_query)
		{
		}
		/**
		 * Identify an existing table alias that is compatible with the current query clause.
		 *
		 * We avoid unnecessary table joins by allowing each clause to look for an existing table alias that is
		 * compatible with the query that it needs to perform. An existing alias is compatible if (a) it is a
		 * sibling of $clause (ie, it's under the scope of the same relation), and (b) the combination of
		 * operator and relation between the clauses allows for a shared table join. In the case of BP_XProfile_Query,
		 * this * only applies to IN clauses that are connected by the relation OR.
		 *
		 * @since 2.2.0
		 *
		 * @param array $clause       Query clause.
		 * @param array $parent_query Parent query of $clause.
		 * @return string|bool Table alias if found, otherwise false.
		 */
		protected function find_compatible_table_alias($clause, $parent_query)
		{
		}
	}
	/**
	 * Creates our XProfile component.
	 *
	 * @since 1.5.0
	 */
	#[\AllowDynamicProperties]
	class BP_XProfile_Component extends \BP_Component
	{
		/**
		 * Profile field types.
		 *
		 * @since 1.5.0
		 * @var array
		 */
		public $field_types;
		/**
		 * The acceptable visibility levels for xprofile fields.
		 *
		 * @see bp_xprofile_get_visibility_levels()
		 *
		 * @since 1.6.0
		 * @var array
		 */
		public $visibility_levels = array();
		/**
		 * Start the xprofile component creation process.
		 *
		 * @since 1.5.0
		 */
		public function __construct()
		{
		}
		/**
		 * Include files.
		 *
		 * @since 1.5.0
		 *
		 * @param array $includes Array of files to include.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Only load up certain code when on specific pages.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Setup globals.
		 *
		 * The BP_XPROFILE_SLUG constant is deprecated.
		 *
		 * @since 1.5.0
		 *
		 * @param array $args Array of globals to set up.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @param array $main_nav See `BP_Component::register_nav()` for details.
		 * @param array $sub_nav  See `BP_Component::register_nav()` for details.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up the Settings > Profile nav item.
		 *
		 * Loaded in a separate method because the Settings component may not
		 * be loaded in time for BP_XProfile_Component::setup_nav().
		 *
		 * @since 2.1.0
		 * @deprecated 12.0.0
		 */
		public function setup_settings_nav()
		{
		}
		/**
		 * Set up the Admin Bar.
		 *
		 * @since 1.5.0
		 *
		 * @param array $wp_admin_nav Admin Bar items.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Add custom hooks.
		 *
		 * @since 2.0.0
		 */
		public function setup_hooks()
		{
		}
		/**
		 * Sets up the title for pages and <title>.
		 *
		 * @since 1.5.0
		 */
		public function setup_title()
		{
		}
		/**
		 * Setup cache groups.
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Adds "Settings > Profile" subnav item under the "Settings" adminbar menu.
		 *
		 * @since 2.0.0
		 *
		 * @param array $wp_admin_nav The settings adminbar nav array.
		 * @return array
		 */
		public function setup_settings_admin_nav($wp_admin_nav)
		{
		}
		/**
		 * Init the BP REST API.
		 *
		 * @since 5.0.0
		 *
		 * @param array $controllers Optional. See BP_Component::rest_api_init() for
		 *                           description.
		 */
		public function rest_api_init($controllers = array())
		{
		}
		/**
		 * Register the BP xProfile Blocks.
		 *
		 * @since 9.0.0
		 *
		 * @param array $blocks Optional. See BP_Component::blocks_init() for
		 *                      description.
		 */
		public function blocks_init($blocks = array())
		{
		}
	}
	/**
	 * XProfile Data endpoints.
	 *
	 * Use /xprofile/{field_id}/data/{user_id}
	 *
	 * @since 5.0.0
	 */
	class BP_REST_XProfile_Data_Endpoint extends \WP_REST_Controller
	{
		/**
		 * XProfile Fields Class.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_REST_XProfile_Fields_Endpoint
		 */
		protected $fields_endpoint;
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve single XProfile field data.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to get users's data.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Save XProfile data.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to save XProfile field data.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Delete user's XProfile data.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete users's data.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares XProfile data to return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param  BP_XProfile_ProfileData $field_data XProfile field data object.
		 * @param  WP_REST_Request         $request    Full data about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($field_data, $request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_XProfile_ProfileData $field_data XProfile field data object.
		 * @return array
		 */
		protected function prepare_links($field_data)
		{
		}
		/**
		 * Get XProfile field object.
		 *
		 * @since 5.0.0
		 *
		 * @param int $field_id Field id.
		 * @return BP_XProfile_Field
		 */
		public function get_xprofile_field_object($field_id)
		{
		}
		/**
		 * Get XProfile field data object.
		 *
		 * @since 5.0.0
		 *
		 * @param int $field_id Field id.
		 * @param int $user_id User id.
		 * @return BP_XProfile_ProfileData
		 */
		public function get_xprofile_field_data_object($field_id, $user_id)
		{
		}
		/**
		 * Can this user see the XProfile data?
		 *
		 * @since 5.0.0
		 *
		 * @param int $field_user_id User ID of the field.
		 * @return bool
		 */
		protected function can_see($field_user_id)
		{
		}
		/**
		 * Get the XProfile data schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
	}
	/**
	 * Class for XProfile Profile Data setup.
	 *
	 * @since 1.6.0
	 */
	#[\AllowDynamicProperties]
	class BP_XProfile_ProfileData
	{
		/**
		 * XProfile ID.
		 *
		 * @since 1.6.0
		 * @var int $id
		 */
		public $id;
		/**
		 * User ID.
		 *
		 * @since 1.6.0
		 * @var int $user_id
		 */
		public $user_id;
		/**
		 * XProfile field ID.
		 *
		 * @since 1.6.0
		 * @var int $field_id
		 */
		public $field_id;
		/**
		 * XProfile field value.
		 *
		 * @since 1.6.0
		 * @var string $value
		 */
		public $value;
		/**
		 * XProfile field last updated time.
		 *
		 * @since 1.6.0
		 * @var string $last_updated
		 */
		public $last_updated;
		/**
		 * BP_XProfile_ProfileData constructor.
		 *
		 * @since 1.5.0
		 *
		 * @param int|null $field_id Field ID to instantiate.
		 * @param int|null $user_id  User ID to instantiate for.
		 */
		public function __construct($field_id = \null, $user_id = \null)
		{
		}
		/**
		 * Populates the XProfile profile data.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $field_id Field ID to populate.
		 * @param int $user_id  User ID to populate for.
		 */
		public function populate($field_id, $user_id)
		{
		}
		/**
		 * Check if there is data already for the user.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function exists()
		{
		}
		/**
		 * Check if this data is for a valid field.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function is_valid_field()
		{
		}
		/**
		 * Save the data for the XProfile field.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Delete specific XProfile field data.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function delete()
		{
		}
		/** Static Methods ********************************************************/
		/**
		 * Get a user's profile data for a set of fields.
		 *
		 * @since 2.0.0
		 * @since 8.0.0 Checks if a null field data is an xProfile WP Field.
		 *              Adds a new parameter `$field_type_objects` to pass the list of field type objects.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int   $user_id            ID of user whose data is being queried.
		 * @param array $field_ids          Array of field IDs to query for.
		 * @param array $field_type_objects Array of field type objects keyed by the queried filed IDs.
		 * @return array
		 */
		public static function get_data_for_user($user_id, $field_ids, $field_type_objects = array())
		{
		}
		/**
		 * Get all of the profile information for a specific user.
		 *
		 * @since 1.2.0
		 * @since 8.0.0 Checks if a null field data is an xProfile WP Field.
		 *
		 * @param int $user_id ID of the user.
		 * @return array
		 */
		public static function get_all_for_user($user_id)
		{
		}
		/**
		 * Get the user's field data id by the id of the xprofile field.
		 *
		 * @since 1.6.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $field_id Field ID being queried for.
		 * @param int $user_id  User ID associated with field.
		 * @return int $fielddata_id
		 */
		public static function get_fielddataid_byid($field_id, $user_id)
		{
		}
		/**
		 * Get profile field values by field ID and user IDs.
		 *
		 * Supports multiple user IDs.
		 *
		 * @since 1.0.0
		 * @since 8.0.0 Checks if a null field data is an xProfile WP Field.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int            $field_id ID of the field.
		 * @param int|array|null $user_ids ID or IDs of user(s).
		 * @return string|array Single value if a single user is queried,
		 *                      otherwise an array of results.
		 */
		public static function get_value_byid($field_id, $user_ids = \null)
		{
		}
		/**
		 * Get profile field values by field name and user ID.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @deprecated 8.0.0 This function is not used anymore.
		 *
		 * @param array|string $fields  Field(s) to get.
		 * @param int|null     $user_id User ID to get field data for.
		 * @return array|bool
		 */
		public static function get_value_byfieldname($fields, $user_id = \null)
		{
		}
		/**
		 * Delete field.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $field_id ID of the field to delete.
		 * @return bool
		 */
		public static function delete_for_field($field_id)
		{
		}
		/**
		 * Get time for last XProfile field data update by user.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id User ID to get time for.
		 * @return null|string
		 */
		public static function get_last_updated($user_id)
		{
		}
		/**
		 * Delete all data for provided user ID.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id User ID to remove data for.
		 * @return false|int
		 */
		public static function delete_data_for_user($user_id)
		{
		}
		/**
		 * Get random field type by user ID.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int    $user_id          User ID to query for.
		 * @param string $exclude_fullname SQL portion used to exclude by field ID.
		 * @return array|null|object
		 */
		public static function get_random($user_id, $exclude_fullname)
		{
		}
		/**
		 * Get fullname for provided user ID.
		 *
		 * @since 1.0.0
		 *
		 * @param int $user_id ID of the user to query.
		 * @return mixed
		 */
		public static function get_fullname($user_id = 0)
		{
		}
	}
	/**
	 * Radio button xprofile field type.
	 *
	 * @since 2.0.0
	 */
	class BP_XProfile_Field_Type_Radiobutton extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the radio button field type.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/input.radio.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output the edit field options HTML for this field type.
		 *
		 * BuddyPress considers a field's "options" to be, for example, the items in a selectbox.
		 * These are stored separately in the database, and their templating is handled separately.
		 *
		 * This templating is separate from {@link BP_XProfile_Field_Type::edit_field_html()} because
		 * it's also used in the wp-admin screens when creating new fields, and for backwards compatibility.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $args Optional. The arguments passed to {@link bp_the_profile_field_options()}.
		 */
		public function edit_field_options_html(array $args = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type's children options on the wp-admin Profile Fields "Add Field" and "Edit Field" screens.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                                         field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
	}
	/**
	 * Number xprofile field type.
	 *
	 * @since 2.0.0
	 */
	class BP_XProfile_Field_Type_Number extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the number field type.
		 *
		 * @since 2.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/input.number.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Output HTML for this field type on the wp-admin Profile Fields screen.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * This method usually outputs HTML for this field type's children options on the wp-admin Profile Fields
		 * "Add Field" and "Edit Field" screens, but for this field type, we don't want it, so it's stubbed out.
		 *
		 * @since 2.0.0
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                                         field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
	}
	/**
	 * Checkbox Acceptance xProfile field type.
	 *
	 * @since 8.0.0
	 */
	class BP_XProfile_Field_Type_Checkbox_Acceptance extends \BP_XProfile_Field_Type
	{
		/**
		 * Checkbox Acceptance field's visibility setting.
		 *
		 * Defaults to 'adminsonly'. This property enforces Field's default visibility.
		 *
		 * @since 8.0.0
		 *
		 * @return string The Checkbox Acceptance field's visibility setting.
		 */
		public $visibility = 'adminsonly';
		/**
		 * Supported features for the Checkbox Acceptance field type.
		 *
		 * @since 8.0.0
		 * @var bool[] The WordPress field supported features.
		 */
		public static $supported_features = array('switch_fieldtype' => \false, 'required' => \true, 'do_autolink' => \false, 'allow_custom_visibility' => \false, 'member_types' => \false);
		/**
		 * Constructor for the Checkbox Acceptance field type.
		 *
		 * @since 8.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Output the edit field HTML for this field type.
		 *
		 * Must be used inside the {@link bp_profile_fields()} template loop.
		 *
		 * @since 8.0.0
		 *
		 * @param array $raw_properties Optional key/value array of
		 * {@link http://dev.w3.org/html5/markup/textarea.html permitted attributes}
		 *  that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Field html for Admin-> User->Profile Fields screen.
		 *
		 * @since 8.0.0
		 *
		 * @param array $raw_properties properties.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Admin new field screen.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_XProfile_Field $current_field Profile field object.
		 * @param string            $control_type  Control type.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
		/**
		 * Save settings from the field edit screen in the Dashboard.
		 *
		 * @since 8.0.0
		 *
		 * @param int   $field_id ID of the field.
		 * @param array $settings Array of settings.
		 * @return bool
		 */
		public function admin_save_settings($field_id, $settings)
		{
		}
		/**
		 * Profile edit/register options html.
		 *
		 * @since 8.0.0
		 *
		 * @param array $args args.
		 */
		public function edit_field_options_html(array $args = array())
		{
		}
		/**
		 * Enforces the field value if it has been already accepted.
		 *
		 * As it's always possible to edit HTML source and remove the `readonly="readonly"` attribute
		 * of the checkbox, we may need to enforce the field value.
		 *
		 * @since 8.0.0
		 *
		 * @param mixed             $value Value passed to xprofile_set_field_data().
		 * @param BP_XProfile_Field $field Field object.
		 * @return mixed The field value.
		 */
		public function enforce_field_value($value, \BP_XProfile_Field $field)
		{
		}
		/**
		 * Check if field is valid?
		 *
		 * @since 8.0.0
		 *
		 * @param string|int $values value.
		 * @return bool
		 */
		public function is_valid($value)
		{
		}
		/**
		 * Modify the appearance of value.
		 *
		 * @since 8.0.0
		 *
		 * @param string $field_value Original value of field.
		 * @param int    $field_id field id.
		 *
		 * @return string   Value formatted
		 */
		public static function display_filter($field_value, $field_id = 0)
		{
		}
	}
	/**
	 * The main profile template loop class.
	 *
	 * This is responsible for loading profile field, group, and data and displaying it.
	 *
	 * @since 1.0.0
	 */
	class BP_XProfile_Data_Template
	{
		/**
		 * The loop iterator.
		 *
		 * @since 1.5.0
		 * @var int
		 */
		public $current_group = -1;
		/**
		 * The number of groups returned by the paged query.
		 *
		 * @since 1.5.0
		 * @var int
		 */
		public $group_count;
		/**
		 * Array of groups located by the query.
		 *
		 * @since 1.5.0
		 * @var array
		 */
		public $groups;
		/**
		 * The group object currently being iterated on.
		 *
		 * @since 1.5.0
		 * @var object
		 */
		public $group;
		/**
		 * The current field.
		 *
		 * @since 1.5.0
		 * @var int
		 */
		public $current_field = -1;
		/**
		 * The field count.
		 *
		 * @since 1.5.0
		 * @var int
		 */
		public $field_count;
		/**
		 * Field has data.
		 *
		 * @since 1.5.0
		 * @var bool
		 */
		public $field_has_data;
		/**
		 * The field.
		 *
		 * @since 1.5.0
		 * @var int
		 */
		public $field;
		/**
		 * A flag for whether the loop is currently being iterated.
		 *
		 * @since 1.5.0
		 * @var bool
		 */
		public $in_the_loop;
		/**
		 * The user ID.
		 *
		 * @since 1.5.0
		 * @var int
		 */
		public $user_id;
		/**
		 * Get activity items, as specified by parameters.
		 *
		 * @see BP_XProfile_Group::get() for more details about parameters.
		 *
		 * @since 1.5.0
		 * @since 2.4.0  Introduced `$member_type` argument.
		 * @since 8.0.0  Introduced `$hide_field_types` & `$signup_fields_only` arguments.
		 * @since 11.0.0 `$profile_group_id` accepts an array of profile group ids.
		 *
		 * @param array|string $args {
		 *     An array of arguments. All items are optional.
		 *
		 *     @type int            $user_id                 Fetch field data for this user ID.
		 *     @type string|array   $member_type             Limit results to those matching member type(s).
		 *     @type int|int[]|bool $profile_group_id        Field group(s) to fetch fields & data for. Default: false.
		 *     @type int|bool       $hide_empty_groups       Should empty field groups be skipped.
		 *     @type int|bool       $fetch_fields            Fetch fields for field group.
		 *     @type int|bool       $fetch_field_data        Fetch field data for fields in group.
		 *     @type array          $exclude_groups          Exclude these field groups.
		 *     @type array          $exclude_fields          Exclude these fields.
		 *     @type int|bool       $hide_empty_fields       Should empty fields be skipped.
		 *     @type int|bool       $fetch_visibility_level  Fetch visibility levels.
		 *     @type string[]       $hide_field_types        List of field types to hide form loop. Default: empty array.
		 *     @type bool           $signup_fields_only      Whether to only return signup fields. Default: false.
		 *     @type int|bool       $update_meta_cache       Should metadata cache be updated.
		 * }
		 */
		public function __construct($args = '')
		{
		}
		/**
		 * Whether or not the loop has field groups.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function has_groups()
		{
		}
		/**
		 * Increments to the next group of fields.
		 *
		 * @since 1.0.0
		 *
		 * @return object
		 */
		public function next_group()
		{
		}
		/**
		 * Rewinds to the start of the groups list.
		 *
		 * @since 1.0.0
		 */
		public function rewind_groups()
		{
		}
		/**
		 * Kicks off the profile groups.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function profile_groups()
		{
		}
		/**
		 * Sets up the profile group.
		 *
		 * @since 1.0.0
		 *
		 * @global object $group Current group of profile fields.
		 *
		 */
		public function the_profile_group()
		{
		}
		/** Fields ****************************************************************/
		/**
		 * Increments to the next field.
		 *
		 * @since 1.0.0
		 *
		 * @return int
		 */
		public function next_field()
		{
		}
		/**
		 * Rewinds to the start of the fields.
		 *
		 * @since 1.0.0
		 */
		public function rewind_fields()
		{
		}
		/**
		 * Whether or not the loop has fields.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function has_fields()
		{
		}
		/**
		 * Kick off the profile fields.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function profile_fields()
		{
		}
		/**
		 * Set up the profile fields.
		 *
		 * @since 1.0.0
		 *
		 * @global object $field Current profile field.
		 *
		 */
		public function the_profile_field()
		{
		}
	}
	/**
	 * A placeholder xprofile field type. Doesn't do anything.
	 *
	 * Used if an existing field has an unknown type (e.g. one provided by a missing third-party plugin).
	 *
	 * @since 2.0.1
	 */
	class BP_XProfile_Field_Type_Placeholder extends \BP_XProfile_Field_Type
	{
		/**
		 * Constructor for the placeholder field type.
		 *
		 * @since 2.0.1
		 */
		public function __construct()
		{
		}
		/**
		 * Prevent any HTML being output for this field type.
		 *
		 * @since 2.0.1
		 *
		 * @param array $raw_properties Optional key/value array of
		 *                              {@link http://dev.w3.org/html5/markup/input.text.html permitted attributes}
		 *                              that you want to add.
		 */
		public function edit_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Prevent any HTML being output for this field type.
		 *
		 * @since 2.0.1
		 *
		 * @param array $raw_properties Optional key/value array of permitted attributes that you want to add.
		 */
		public function admin_field_html(array $raw_properties = array())
		{
		}
		/**
		 * Prevent any HTML being output for this field type.
		 *
		 * @since 2.0.1
		 *
		 * @param BP_XProfile_Field $current_field The current profile field on the add/edit screen.
		 * @param string            $control_type  Optional. HTML input type used to render the current
		 *                                         field's child options.
		 */
		public function admin_new_field_html(\BP_XProfile_Field $current_field, $control_type = '')
		{
		}
	}
	/**
	 * Class for generating SQL clauses that filter a primary query according to
	 * XProfile metadata keys and values.
	 *
	 * `BP_XProfile_Meta_Query` is a helper that allows primary query classes, such
	 * as {@see WP_Query} and {@see WP_User_Query}, to filter their results by object
	 * metadata, by generating `JOIN` and `WHERE` subclauses to be attached
	 * to the primary SQL query string.
	 *
	 * @since 2.3.0
	 */
	class BP_XProfile_Meta_Query extends \WP_Meta_Query
	{
		/**
		 * Determine whether a query clause is first-order.
		 *
		 * A first-order meta query clause is one that has either a 'key', 'value',
		 * or 'object' array key.
		 *
		 * @since 2.3.0
		 *
		 * @param array $query Meta query arguments.
		 * @return bool Whether the query clause is a first-order clause.
		 */
		protected function is_first_order_clause($query)
		{
		}
		/**
		 * Constructs a meta query based on 'meta_*' query vars.
		 *
		 * @since 2.3.0
		 *
		 * @param array $qv The query variables.
		 */
		public function parse_query_vars($qv)
		{
		}
		/**
		 * Generates SQL clauses to be appended to a main query.
		 *
		 * @since 2.3.0
		 *
		 * @param string      $type              Type of meta, eg 'user', 'post'.
		 * @param string      $primary_table     Database table where the object being filtered is stored (eg wp_users).
		 * @param string      $primary_id_column ID column for the filtered object in $primary_table.
		 * @param object|null $context           Optional. The main query object.
		 * @return array {
		 *     Array containing JOIN and WHERE SQL clauses to append to the main query.
		 *
		 *     @type string $join  SQL fragment to append to the main JOIN clause.
		 *     @type string $where SQL fragment to append to the main WHERE clause.
		 * }
		 */
		public function get_sql($type, $primary_table, $primary_id_column, $context = \null)
		{
		}
		/**
		 * Generate SQL JOIN and WHERE clauses for a first-order query clause.
		 *
		 * "First-order" means that it's an array with a 'key' or 'value'.
		 *
		 * @since 2.3.0
		 * 
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array  $clause       Query clause, passed by reference.
		 * @param array  $parent_query Parent query array.
		 * @param string $clause_key   Optional. The array key used to name the clause in the original `$meta_query`
		 *                             parameters. If not provided, a key will be generated automatically.
		 * @return array {
		 *     Array containing JOIN and WHERE SQL clauses to append to a first-order query.
		 *
		 *     @type string $join  SQL fragment to append to the main JOIN clause.
		 *     @type string $where SQL fragment to append to the main WHERE clause.
		 * }
		 */
		public function get_sql_for_clause(&$clause, $parent_query, $clause_key = '')
		{
		}
	}
	/**
	 * BuddyPress User Query class.
	 *
	 * Used for querying users in a BuddyPress context, in situations where WP_User_Query won't do the trick:
	 * Member directories, the Friends component, etc.
	 *
	 * @since 1.7.0
	 * @since 10.0.0 Added `$date_query` parameter.
	 *
	 * @param array $query {
	 *     Query arguments. All items are optional.
	 *     @type string            $type                Determines sort order. Select from 'newest', 'active', 'online',
	 *                                                  'random', 'popular', 'alphabetical'. Default: 'newest'.
	 *     @type int               $per_page            Number of results to return. Default: 0 (no limit).
	 *     @type int               $page                Page offset (together with $per_page). Default: 1.
	 *     @type int               $user_id             ID of a user. If present, and if the friends component is activated,
	 *                                                  results will be limited to the friends of that user. Default: 0.
	 *     @type string|bool       $search_terms        Terms to search by. Search happens across xprofile fields. Requires
	 *                                                  XProfile component. Default: false.
	 *     @type string            $search_wildcard     When searching with $search_terms, set where wildcards around the
	 *                                                  term should be positioned. Accepts 'both', 'left', 'right'.
	 *                                                  Default: 'both'.
	 *     @type array|string|bool $include             An array or comma-separated list of user IDs to which query should
	 *                                                  be limited. Default: false.
	 *     @type array|string|bool $exclude             An array or comma-separated list of user IDs that will be excluded
	 *                                                  from query results. Default: false.
	 *     @type array|string|bool $user_ids            An array or comma-separated list of IDs corresponding to the users
	 *                                                  that should be returned. When this parameter is passed, it will
	 *                                                  override all others; BP User objects will be constructed using these
	 *                                                  IDs only. Default: false.
	 *     @type array|string      $member_type         Array or comma-separated list of member types to limit results to.
	 *     @type array|string      $member_type__in     Array or comma-separated list of member types to limit results to.
	 *     @type array|string      $member_type__not_in Array or comma-separated list of member types that will be
	 *                                                       excluded from results.
	 *     @type string|bool       $meta_key            Limit results to users that have usermeta associated with this meta_key.
	 *                                                  Usually used with $meta_value. Default: false.
	 *     @type string|bool       $meta_value          When used with $meta_key, limits results to users whose usermeta value
	 *                                                  associated with $meta_key matches $meta_value. Default: false.
	 *     @type array             $xprofile_query      Filter results by xprofile data. Requires the xprofile component.
	 *                                                  See {@see BP_XProfile_Query} for details.
	 *     @type array             $date_query          Filter results by member last activity date. See first parameter of
	 *                                                  {@link WP_Date_Query::__construct()} for syntax. Only applicable if
	 *                                                  $type is either 'active', 'random', 'newest', or 'online'.
	 *     @type bool              $populate_extras     True if you want to fetch extra metadata
	 *                                                  about returned users, such as total group and friend counts.
	 *     @type string            $count_total         Determines how BP_User_Query will do a count of total users matching
	 *                                                  the other filter criteria. Default value is 'count_query', which
	 *                                                  does a separate SELECT COUNT query to determine the total.
	 *                                                  'sql_count_found_rows' uses SQL_COUNT_FOUND_ROWS and
	 *                                                  SELECT FOUND_ROWS(). Pass an empty string to skip the total user
	 *                                                  count query.
	 * }
	 */
	class BP_User_Query
	{
		/** Variables *************************************************************/
		/**
		 * Unaltered params as passed to the constructor.
		 *
		 * @since 1.8.0
		 *
		 * @var array
		 */
		public $query_vars_raw = array();
		/**
		 * Array of variables to query with.
		 *
		 * @since 1.7.0
		 *
		 * @var array
		 */
		public $query_vars = array();
		/**
		 * List of found users and their respective data.
		 *
		 * @since 1.7.0
		 *
		 * @var array
		 */
		public $results = array();
		/**
		 * Total number of found users for the current query.
		 *
		 * @since 1.7.0
		 *
		 * @var int
		 */
		public $total_users = 0;
		/**
		 * List of found user IDs.
		 *
		 * @since 1.7.0
		 *
		 * @var array
		 */
		public $user_ids = array();
		/**
		 * SQL clauses for the user ID query.
		 *
		 * @since 1.7.0
		 *
		 * @var array
		 */
		public $uid_clauses = array();
		/**
		 * SQL table where the user ID is being fetched from.
		 *
		 * @since 2.2.0
		 *
		 * @var string
		 */
		public $uid_table = '';
		/**
		 * SQL database column name to order by.
		 *
		 * @since 1.7.0
		 *
		 * @var string
		 */
		public $uid_name = '';
		/**
		 * Standard response when the query should not return any rows.
		 *
		 * @since 1.7.0
		 *
		 * @var array
		 */
		protected $no_results = array('join' => '', 'where' => '0 = 1');
		/** Methods ***************************************************************/
		/**
		 * Constructor.
		 *
		 * @since 1.7.0
		 *
		 * @param string|array|null $query See {@link BP_User_Query}.
		 */
		public function __construct($query = \null)
		{
		}
		/**
		 * Allow extending classes to set up action/filter hooks.
		 *
		 * When extending BP_User_Query, you may need to use some of its
		 * internal hooks to modify the output. It's not convenient to call
		 * add_action() or add_filter() in your class constructor, because
		 * BP_User_Query::__construct() contains a fair amount of logic that
		 * you may not want to override in your class. Define this method in
		 * your own class if you need a place where your extending class can
		 * add its hooks early in the query-building process. See
		 * {@link BP_Group_Member_Query::setup_hooks()} for an example.
		 *
		 * @since 1.8.0
		 */
		public function setup_hooks()
		{
		}
		/**
		 * Prepare the query for user_ids.
		 *
		 * @since 1.7.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function prepare_user_ids_query()
		{
		}
		/**
		 * Query for IDs of users that match the query parameters.
		 *
		 * Perform a database query to specifically get only user IDs, using
		 * existing query variables set previously in the constructor.
		 *
		 * Also used to quickly perform user total counts.
		 *
		 * @since 1.7.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function do_user_ids_query()
		{
		}
		/**
		 * Use WP_User_Query() to pull data for the user IDs retrieved in the main query.
		 *
		 * @since 1.7.0
		 */
		public function do_wp_user_query()
		{
		}
		/**
		 * Fetch the IDs of users to put in the IN clause of the main query.
		 *
		 * By default, returns the value passed to it
		 * ($this->query_vars['include']). Having this abstracted into a
		 * standalone method means that extending classes can override the
		 * logic, parsing together their own user_id limits with the 'include'
		 * ids passed to the class constructor. See {@link BP_Group_Member_Query}
		 * for an example.
		 *
		 * @since 1.8.0
		 *
		 * @param array $include_ids Sanitized array of user IDs, as passed to the 'include'
		 *                           parameter of the class constructor.
		 * @return array The list of users to which the main query should be
		 *               limited.
		 */
		public function get_include_ids($include_ids = array())
		{
		}
		/**
		 * Perform a database query to populate any extra metadata we might need.
		 *
		 * Different components will hook into the 'bp_user_query_populate_extras'
		 * action to loop in the things they want.
		 *
		 * @since 1.7.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function populate_extras()
		{
		}
		/**
		 * Get a SQL clause representing member_type include/exclusion.
		 *
		 * @since 2.4.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string|array $member_types Array or comma-separated list of member types.
		 * @param string       $operator     'IN' or 'NOT IN'.
		 * @return string
		 */
		protected function get_sql_clause_for_member_types($member_types, $operator)
		{
		}
	}
	/**
	 * Query for the members of a group.
	 *
	 * Special notes about the group members data schema:
	 * - *Members* are entries with is_confirmed = 1.
	 * - *Pending requests* are entries with is_confirmed = 0 and inviter_id = 0.
	 * - *Pending and sent invitations* are entries with is_confirmed = 0 and
	 *   inviter_id != 0 and invite_sent = 1.
	 * - *Pending and unsent invitations* are entries with is_confirmed = 0 and
	 *   inviter_id != 0 and invite_sent = 0.
	 * - *Membership requests* are entries with is_confirmed = 0 and
	 *   inviter_id = 0 (and invite_sent = 0).
	 *
	 * @since 1.8.0
	 * @since 3.0.0 $group_id now supports multiple values.
	 *
	 * @param array $args  {
	 *     Array of arguments. Accepts all arguments from
	 *     {@link BP_User_Query}, with the following additions:
	 *
	 *     @type int|array|string $group_id     ID of the group to limit results to. Also accepts multiple values
	 *                                          either as an array or as a comma-delimited string.
	 *     @type array            $group_role   Array of group roles to match ('member', 'mod', 'admin', 'banned').
	 *                                          Default: array( 'member' ).
	 *     @type bool             $is_confirmed Whether to limit to confirmed members. Default: true.
	 *     @type string           $type         Sort order. Accepts any value supported by {@link BP_User_Query}, in
	 *                                          addition to 'last_joined' and 'first_joined'. Default: 'last_joined'.
	 * }
	 */
	class BP_Group_Member_Query extends \BP_User_Query
	{
		/**
		 * Array of group member ids, cached to prevent redundant lookups.
		 *
		 * @since 1.8.1
		 * @var null|array Null if not yet defined, otherwise an array of ints.
		 */
		protected $group_member_ids;
		/**
		 * Constructor.
		 *
		 * @since 10.3.0
		 *
		 * @param string|array|null $query See {@link BP_User_Query}.
		 */
		public function __construct($query = \null)
		{
		}
		/**
		 * Set up action hooks.
		 *
		 * @since 1.8.0
		 */
		public function setup_hooks()
		{
		}
		/**
		 * Use WP_User_Query() to pull data for the user IDs retrieved in the main query.
		 *
		 * If a `count` query is performed, the function is used to validate existing users.
		 *
		 * @since 10.3.0
		 */
		public function do_wp_user_query()
		{
		}
		/**
		 * Get a list of user_ids to include in the IN clause of the main query.
		 *
		 * Overrides BP_User_Query::get_include_ids(), adding our additional
		 * group-member logic.
		 *
		 * @since 1.8.0
		 *
		 * @param array $include Existing group IDs in the $include parameter,
		 *                       as calculated in BP_User_Query.
		 * @return array
		 */
		public function get_include_ids($include = array())
		{
		}
		/**
		 * Get the members of the queried group.
		 *
		 * @since 1.8.0
		 *
		 * @return array $ids User IDs of relevant group member ids.
		 */
		protected function get_group_member_ids()
		{
		}
		/**
		 * Tell BP_User_Query to order by the order of our query results.
		 *
		 * We only override BP_User_Query's native ordering in case of the
		 * 'last_joined' and 'first_joined' $type parameters.
		 *
		 * @since 1.8.1
		 *
		 * @param BP_User_Query $query BP_User_Query object.
		 */
		public function set_orderby($query)
		{
		}
		/**
		 * Fetch additional data required in bp_group_has_members() loops.
		 *
		 * Additional data fetched:
		 *      - is_banned
		 *      - date_modified
		 *
		 * @since 1.8.0
		 *
		 * @param BP_User_Query $query        BP_User_Query object. Because we're
		 *                                    filtering the current object, we use
		 *                                    $this inside of the method instead.
		 * @param string        $user_ids_sql Sanitized, comma-separated string of
		 *                                    the user ids returned by the main query.
		 */
		public function populate_group_member_extras($query, $user_ids_sql)
		{
		}
		/**
		 * Sort user IDs by how recently they have generated activity within a given group.
		 *
		 * @since 2.1.0
		 *
		 * @param BP_User_Query $query  BP_User_Query object.
		 * @param array         $gm_ids array of group member ids.
		 * @return array
		 */
		public function get_gm_ids_ordered_by_activity($query, $gm_ids = array())
		{
		}
		/**
		 * Perform a database query to populate any extra metadata we might need.
		 *
		 * If a `count` query is performed, the function is used to validate active users.
		 *
		 * @since 10.3.0
		 * @since 11.0.0 Include inactive users added by a community administrators to the group members count.
		 */
		public function populate_extras()
		{
		}
	}
	/**
	 * Group membership endpoints.
	 *
	 * Use /groups/{group_id}/members
	 * Use /groups/{group_id}/members/{user_id}
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Group_Membership_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Reuse some parts of the BP_REST_Groups_Endpoint class.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_REST_Groups_Endpoint
		 */
		protected $groups_endpoint;
		/**
		 * Reuse some parts of the BP_REST_Members_Endpoint class.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_REST_Members_Endpoint
		 */
		protected $members_endpoint;
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve group members.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to group members.
		 *
		 * We are using the same permissions check done on group access.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Add member to a group.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to join a group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Update user status on a group (add, remove, promote, demote or ban).
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to update a group member.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Delete a group membership.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete a group member.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares group member data for return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Groups_Member $group_member Group member object.
		 * @param WP_REST_Request  $request      Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($group_member, $request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Groups_Member $group_member Group member object.
		 * @return array
		 */
		protected function prepare_links($group_member)
		{
		}
		/**
		 * GET arguments for the endpoint's CREATABLE, EDITABLE & DELETABLE methods.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_method($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the group member schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for collections of group memberships.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * Group Membership Request Endpoint.
	 *
	 * Use /groups/{group_id}/membership-request
	 * Use /groups/membership-request/{request_id}
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Group_Membership_Request_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Reuse some parts of the BP_REST_Groups_Endpoint class.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_REST_Groups_Endpoint
		 */
		protected $groups_endpoint;
		/**
		 * Reuse some parts of the BP_REST_Group_Invites_Endpoint class.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_REST_Group_Invites_Endpoint
		 */
		protected $invites_endpoint;
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Fetch pending group membership requests.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to fetch group membership requests.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Fetch a sepcific pending group membership request by ID.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to fetch group membership request.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Request membership to a group.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to make a group membership request.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Accept or reject a pending group membership request.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Checks if a given request has access to accept a group membership request.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Reject a pending group membership request.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Checks if a given request has access to reject a group membership request.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares group invitation data to return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Invitation   $invite  Invite object.
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($invite, $request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Invitation $invite Invite object.
		 * @return array
		 */
		protected function prepare_links($invite)
		{
		}
		/**
		 * Helper function to fetch a single group invite.
		 *
		 * @since 5.0.0
		 *
		 * @param int $request_id The ID of the request you wish to fetch.
		 * @return BP_Invitation|bool $group_request Membership request if found, false otherwise.
		 */
		public function fetch_single_membership_request($request_id = 0)
		{
		}
		/**
		 * Endpoint args.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the group membership request schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for collections of group invites.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * API for creating group extensions without having to hardcode the content into
	 * the theme.
	 *
	 * To implement, extend this class. In your constructor, pass an optional array
	 * of arguments to parent::init() to configure your widget. The config array
	 * supports the following values:
	 *   - 'slug' A unique identifier for your extension. This value will be used
	 *     to build URLs, so make it URL-safe.
	 *   - 'name' A translatable name for your extension. This value is used to
	 *     populate the navigation tab, as well as the default titles for admin/
	 *     edit/create tabs.
	 *   - 'visibility' Set to 'public' (default) for your extension (the main tab
	 *     as well as the widget) to be available to anyone who can access the
	 *     group, 'private' otherwise.
	 *   - 'nav_item_position' An integer explaining where the nav item should
	 *     appear in the tab list.
	 *   - 'enable_nav_item' Set to true for your extension's main tab to be
	 *     available to anyone who can access the group.
	 *   - 'nav_item_name' The translatable text you want to appear in the nav tab.
	 *     Defaults to the value of 'name'.
	 *   - 'display_hook' The WordPress action that the widget_display() method is
	 *     hooked to.
	 *   - 'template_file' The template file that will be used to load the content
	 *     of your main extension tab. Defaults to 'groups/single/plugins.php'.
	 *   - 'screens' A multi-dimensional array, described below.
	 *   - 'access' Which users can visit the plugin's tab.
	 *   - 'show_tab' Which users can see the plugin's navigation tab.
	 *
	 * BP_Group_Extension uses the concept of "settings screens". There are three
	 * contexts for settings screens:
	 *   - 'create', which inserts a new step into the group creation process
	 *   - 'edit', which adds a tab for your extension into the Admin section of
	 *     a group
	 *   - 'admin', which adds a metabox to the Groups administration panel in the
	 *     WordPress Dashboard
	 * Each of these settings screens is populated by a pair of methods: one that
	 * creates the markup for the screen, and one that processes form data
	 * submitted from the screen. If your plugin needs screens in all three
	 * contexts, and if the markup and form processing logic will be the same in
	 * each case, you can define two methods to handle all of the screens:
	 *   function settings_screen() {}
	 *   function settings_screen_save() {}
	 * If one or more of your settings screen needs separate logic, you may define
	 * context-specific methods, for example:
	 *   function edit_screen() {}
	 *   function edit_screen_save() {}
	 * BP_Group_Extension will use the more specific methods if they are available.
	 *
	 * You can further customize the settings screens (tab names, etc) by passing
	 * an optional 'screens' parameter to the init array. The format is as follows:
	 *   'screens' => array(
	 *       'create' => array(
	 *       'slug' => 'foo',
	 *       'name' => 'Foo',
	 *       'position' => 55,
	 *       'screen_callback' => 'my_create_screen_callback',
	 *       'screen_save_callback' => 'my_create_screen_save_callback',
	 *   ),
	 *   'edit' => array( // ...
	 *   ),
	 * Only provide those arguments that you actually want to change from the
	 * default configuration. BP_Group_Extension will do the rest.
	 *
	 * Note that the 'edit' screen accepts an additional parameter: 'submit_text',
	 * which defines the text of the Submit button automatically added to the Edit
	 * screen of the extension (defaults to 'Save Changes'). Also, the 'admin'
	 * screen accepts two additional parameters: 'metabox_priority' and
	 * 'metabox_context'. See the docs for add_meta_box() for more details on these
	 * arguments.
	 *
	 * Prior to BuddyPress 1.7, group extension configurations were set slightly
	 * differently. The legacy method is still supported, though deprecated.
	 *
	 * @since 1.1.0
	 */
	class BP_Group_Extension
	{
		/** Public ************************************************************/
		/**
		 * Information about this extension's screens.
		 *
		 * @since 1.8.0
		 * @var array
		 */
		public $screens = array();
		/**
		 * The name of the extending class.
		 *
		 * @since 1.8.0
		 * @var string
		 */
		public $class_name = '';
		/**
		 * A ReflectionClass object of the current extension.
		 *
		 * @since 1.8.0
		 * @var ReflectionClass
		 */
		public $class_reflection = \null;
		/**
		 * Parsed configuration parameters for the extension.
		 *
		 * @since 1.8.0
		 * @var array
		 */
		public $params = array();
		/**
		 * Raw config params, as passed by the extending class.
		 *
		 * @since 2.1.0
		 * @var array
		 */
		public $params_raw = array();
		/**
		 * The ID of the current group.
		 *
		 * @since 1.8.0
		 * @var int
		 */
		public $group_id = 0;
		/**
		 * The slug of the current extension.
		 *
		 * @since 1.1.0
		 * @var string
		 */
		public $slug = '';
		/**
		 * The translatable name of the current extension.
		 *
		 * @since 1.1.0
		 * @var string
		 */
		public $name = '';
		/**
		 * The visibility of the extension tab. 'public' or 'private'.
		 *
		 * @since 1.1.0
		 * @var string
		 */
		public $visibility = 'public';
		/**
		 * The numeric position of the main nav item.
		 *
		 * @since 1.1.0
		 * @var int
		 */
		public $nav_item_position = 81;
		/**
		 * Whether to show the nav item.
		 *
		 * @since 1.1.0
		 * @var bool
		 */
		public $enable_nav_item = \true;
		/**
		 * Whether the current user should see the navigation item.
		 *
		 * @since 2.1.0
		 * @var bool
		 */
		public $user_can_see_nav_item;
		/**
		 * The Callback function to use before showing the navigation item.
		 *
		 * @since 12.0.0
		 * @var string
		 */
		public $show_tab_callback = '';
		/**
		 * Whether the current user can visit the tab.
		 *
		 * @since 2.1.0
		 * @var bool
		 */
		public $user_can_visit;
		/**
		 * The text of the nav item. Defaults to self::name.
		 *
		 * @since 1.1.0
		 * @var string
		 */
		public $nav_item_name = '';
		/**
		 * The WP action that self::widget_display() is attached to.
		 *
		 * Default: 'groups_custom_group_boxes'.
		 *
		 * @since 1.1.0
		 * @var string
		 */
		public $display_hook = 'groups_custom_group_boxes';
		/**
		 * The template file used to load the plugin content.
		 *
		 * Default: 'groups/single/plugins'.
		 *
		 * @since 1.1.0
		 * @var string
		 */
		public $template_file = 'groups/single/plugins';
		/**
		 * The template file.
		 *
		 * @since 1.1.0
		 * @var string
		 */
		public $edit_screen_template;
		/** Protected *********************************************************/
		/**
		 * Has the extension been initialized?
		 *
		 * @since 1.8.0
		 * @var bool
		 */
		protected $initialized = \false;
		/**
		 * Extension properties as set by legacy extensions.
		 *
		 * @since 1.8.0
		 * @var array
		 */
		protected $legacy_properties = array();
		/**
		 * Converted legacy parameters.
		 *
		 * These are the extension properties as set by legacy extensions, but
		 * then converted to match the new format for params.
		 *
		 * @since 1.8.0
		 * @var array
		 */
		protected $legacy_properties_converted = array();
		/**
		 * Redirect location as defined by post-edit save callback.
		 *
		 * @since 2.1.0
		 * @var string
		 */
		protected $post_save_redirect;
		/**
		 * Miscellaneous data as set by the __set() magic method.
		 *
		 * @since 1.8.0
		 * @var array
		 */
		protected $data = array();
		/** Screen Overrides **************************************************/
		/*
		 * Screen override methods are how your extension will display content
		 * and handle form submits. Your extension should only override those
		 * methods that it needs for its purposes.
		 */
		/**
		 * The content of the group tab.
		 *
		 * @since 1.1.0
		 *
		 * @param int|null $group_id ID of the group to display.
		 */
		public function display($group_id = \null)
		{
		}
		/**
		 * Content displayed in a widget sidebar, if applicable.
		 *
		 * @since 1.1.0
		 */
		public function widget_display()
		{
		}
		/*
		 * *_screen() displays the settings form for the given context
		 * *_screen_save() processes data submitted via the settings form
		 * The settings_* methods are generic fallbacks, which can optionally
		 * be overridden by the more specific edit_*, create_*, and admin_*
		 * versions.
		 */
		/**
		 * Provide the fallback markup for Group's Create/Admin/Edit screens.
		 *
		 * @since 1.8.0
		 *
		 * @param int|null $group_id ID of the group to display.
		 */
		public function settings_screen($group_id = \null)
		{
		}
		/**
		 * Group's Fallback handler for the Create/Admin/Edit screens.
		 *
		 * @since 1.8.0
		 *
		 * @param int|null $group_id ID of the group to display.
		 */
		public function settings_screen_save($group_id = \null)
		{
		}
		/**
		 * The content of the Manage sub tab.
		 *
		 * @since 1.1.0
		 *
		 * @param int|null $group_id ID of the group to display.
		 */
		public function edit_screen($group_id = \null)
		{
		}
		/**
		 * Group Manage sub tab handler.
		 *
		 * @since 1.1.0
		 *
		 * @param int|null $group_id ID of the group to display.
		 */
		public function edit_screen_save($group_id = \null)
		{
		}
		/**
		 * The content of the group create step tab.
		 *
		 * @since 1.1.0
		 *
		 * @param int|null $group_id ID of the group to display.
		 */
		public function create_screen($group_id = \null)
		{
		}
		/**
		 * Group create step tab handler.
		 *
		 * @since 1.1.0
		 *
		 * @param int|null $group_id ID of the group to display.
		 */
		public function create_screen_save($group_id = \null)
		{
		}
		/**
		 * The content of Group's WP Administration screen metabox.
		 *
		 * @since 1.8.0
		 *
		 * @param int|null $group_id ID of the group to display.
		 */
		public function admin_screen($group_id = \null)
		{
		}
		/**
		 * Group's WP Administration screen handler.
		 *
		 * @since 1.8.0
		 *
		 * @param int|null $group_id ID of the group to display.
		 */
		public function admin_screen_save($group_id = \null)
		{
		}
		/** Setup *************************************************************/
		/**
		 * Initialize the extension, using your config settings.
		 *
		 * Your plugin should call this method at the very end of its
		 * constructor, like so:
		 *
		 *   public function __construct() {
		 *       $args = array(
		 *           'slug' => 'my-group-extension',
		 *           'name' => 'My Group Extension',
		 *           // ...
		 *       );
		 *
		 *       parent::init( $args );
		 *   }
		 *
		 * @since 1.8.0
		 * @since 2.1.0 Added 'access' and 'show_tab' arguments to `$args`.
		 * @since 12.0.0 Set the Group Extension screens.
		 *
		 * @param array $args {
		 *     Array of initialization arguments.
		 *     @type string       $slug              Unique, URL-safe identifier for your extension.
		 *     @type string       $name              Translatable name for your extension. Used to populate
		 *                                           navigation items.
		 *     @type string       $visibility        Optional. Set to 'public' for your extension (the main tab as well
		 *                                           as the widget) to be available to anyone who can access the group;
		 *                                           set to 'private' otherwise. Default: 'public'.
		 *     @type int          $nav_item_position Optional. Location of the nav item in the tab list.
		 *                                           Default: 81.
		 *     @type bool         $enable_nav_item   Optional. Whether the extension's tab should be accessible to
		 *                                           anyone who can view the group. Default: true.
		 *     @type string       $nav_item_name     Optional. The translatable text you want to appear in the nav tab.
		 *                                           Default: the value of `$name`.
		 *     @type string       $display_hook      Optional. The WordPress action that the widget_display() method is
		 *                                           hooked to. Default: 'groups_custom_group_boxes'.
		 *     @type string       $template_file     Optional. Theme-relative path to the template file BP should use
		 *                                           to load the content of your main extension tab.
		 *                                           Default: 'groups/single/plugins.php'.
		 *     @type array        $screens           A multi-dimensional array of configuration information for the
		 *                                           extension screens. See docblock of {@link BP_Group_Extension}
		 *                                           for more details.
		 *     @type string|array $access            Which users can visit the plugin's tab. Possible values: 'anyone',
		 *                                           'loggedin', 'member', 'mod', 'admin' or 'noone'. ('member', 'mod',
		 *                                           'admin' refer to user's role in group.) Note that 'mod' targets
		 *                                           only group moderators. If you want to allow access to group moderators
		 *                                           and admins, specify `array( 'mod', 'admin' )`. Defaults to 'anyone'
		 *                                           for public groups and 'member' for private groups.
		 *     @type string|array $show_tab          Which users can see the plugin's navigation tab. Possible values:
		 *                                           'anyone', 'loggedin', 'member', 'mod', 'admin' or 'noone'.
		 *                                           ('member', 'mod', 'admin' refer to user's role in group.) Note
		 *                                           that 'mod' targets only group moderators. If you want to show the
		 *                                           tab to group moderators and admins, specify
		 *                                           `array( 'mod', 'admin' )`. Defaults to 'anyone' for public groups
		 *                                           and 'member' for private groups.
		 *    @type string|array  $show_tab_callback The function to execute to set the $show_tab argument.
		 * }
		 */
		public function init($args = array())
		{
		}
		/**
		 * The main setup routine for the extension.
		 *
		 * This method contains the primary logic for setting up an extension's
		 * configuration, setting up backward compatibility for legacy plugins,
		 * and hooking the extension's screen functions into WP and BP.
		 *
		 * Marked 'public' because it must be accessible to add_action().
		 * However, you should never need to invoke this method yourself - it
		 * is called automatically at the right point in the load order by
		 * bp_register_group_extension().
		 *
		 * @since 1.1.0
		 */
		public function _register()
		{
		}
		/**
		 * Set up some basic info about the Extension.
		 *
		 * Here we collect the name of the extending class, as well as a
		 * ReflectionClass that is used in get_screen_callback() to determine
		 * whether your extension overrides certain callback methods.
		 *
		 * @since 1.8.0
		 */
		protected function setup_class_info()
		{
		}
		/**
		 * Get the current group ID.
		 *
		 * Check for:
		 *   - current group
		 *   - new group
		 *   - group admin
		 *
		 * @since 1.8.0
		 *
		 * @return int
		 */
		public static function get_group_id()
		{
		}
		/**
		 * Gather configuration data about your screens.
		 *
		 * @since 1.8.0
		 *
		 * @return array
		 */
		protected function get_default_screens()
		{
		}
		/**
		 * Set up screens array based on params.
		 *
		 * @since 1.8.0
		 */
		protected function setup_screens()
		{
		}
		/**
		 * Set up access-related settings for this extension.
		 *
		 * @since 2.1.0
		 */
		protected function setup_access_settings()
		{
		}
		/**
		 * Check whether the current user meets an access condition.
		 *
		 * @since 2.1.0
		 *
		 * @param string $access_condition 'anyone', 'loggedin', 'member',
		 *                                 'mod', 'admin' or 'noone'.
		 * @return bool
		 */
		protected function user_meets_access_condition($access_condition)
		{
		}
		/** Display ***********************************************************/
		/**
		 * Returns the Rewrite ID of the Group Extension Item according to the context.
		 *
		 * @since 12.0.0
		 *
		 * @param string $context One of these contexts: 'create', 'manage', 'read'.
		 * @return string         The found Rewrite ID, an empty string otherwise.
		 */
		protected function get_rewrite_id_for($context = '')
		{
		}
		/**
		 * Hook this extension's group tab into BuddyPress, if necessary.
		 *
		 * @since 1.8.0
		 */
		protected function setup_display_hooks()
		{
		}
		/**
		 * Hook the main display method, and loads the template file.
		 *
		 * @since 1.1.0
		 */
		public function _display_hook()
		{
		}
		/**
		 * Call the display() method.
		 *
		 * We use this wrapper so that we can pass the group_id to the
		 * display() callback.
		 *
		 * @since 2.1.1
		 */
		public function call_display()
		{
		}
		/**
		 * Determine whether the current user should see this nav tab.
		 *
		 * Note that this controls only the display of the navigation item.
		 * Access to the tab is controlled by the user_can_visit() check.
		 *
		 * @since 2.1.0
		 *
		 * @param bool $user_can_see_nav_item Whether or not the user can see the nav item.
		 * @return bool
		 */
		public function user_can_see_nav_item($user_can_see_nav_item = \false)
		{
		}
		/**
		 * Determine whether the current user has access to visit this tab.
		 *
		 * Note that this controls the ability of a user to access a tab.
		 * Display of the navigation item is controlled by user_can_see_nav_item().
		 *
		 * @since 2.1.0
		 *
		 * @param bool $user_can_visit Whether or not the user can visit the tab.
		 * @return bool
		 */
		public function user_can_visit($user_can_visit = \false)
		{
		}
		/**
		 * Filter the access check in bp_groups_group_access_protection() for this extension.
		 *
		 * Note that $no_access_args is passed by reference, as there are some
		 * circumstances where the bp_core_no_access() arguments need to be
		 * modified before the redirect takes place.
		 *
		 * @since 2.1.0
		 *
		 * @param bool  $user_can_visit Whether or not the user can visit the tab.
		 * @param array $no_access_args Array of args to help determine access.
		 * @return bool
		 */
		public function group_access_protection($user_can_visit, &$no_access_args)
		{
		}
		/** Create ************************************************************/
		/**
		 * Hook this extension's Create step into BuddyPress, if necessary.
		 *
		 * @since 1.8.0
		 */
		protected function setup_create_hooks()
		{
		}
		/**
		 * Call the create_screen() method, if we're on the right page.
		 *
		 * @since 1.8.0
		 */
		public function maybe_create_screen()
		{
		}
		/**
		 * Call the create_screen_save() method, if we're on the right page.
		 *
		 * @since 1.8.0
		 */
		public function maybe_create_screen_save()
		{
		}
		/** Edit **************************************************************/
		/**
		 * Hook this extension's Edit panel into BuddyPress, if necessary.
		 *
		 * @since 1.8.0
		 */
		protected function setup_edit_hooks()
		{
		}
		/**
		 * Call the edit_screen() method.
		 *
		 * Previous versions of BP_Group_Extension required plugins to provide
		 * their own Submit button and nonce fields when building markup. In
		 * BP 1.8, this requirement was lifted - BP_Group_Extension now handles
		 * all required submit buttons and nonces.
		 *
		 * We put the edit screen markup into an output buffer before echoing.
		 * This is so that we can check for the presence of a hardcoded submit
		 * button, as would be present in legacy plugins; if one is found, we
		 * do not auto-add our own button.
		 *
		 * @since 1.8.0
		 */
		public function call_edit_screen()
		{
		}
		/**
		 * Check the nonce, and call the edit_screen_save() method.
		 *
		 * @since 1.8.0
		 */
		public function call_edit_screen_save()
		{
		}
		/**
		 * Load the template that houses the Edit screen.
		 *
		 * Separated out into a callback so that it can run after all other
		 * Group Extensions have had a chance to register their navigation, to
		 * avoid missing tabs.
		 *
		 * Hooked to 'bp_screens'.
		 *
		 * @since 1.8.0
		 *
		 * @see BP_Group_Extension::setup_edit_hooks()
		 */
		public function call_edit_screen_template_loader()
		{
		}
		/**
		 * Add a submit button to the edit form, if it needs one.
		 *
		 * There's an inconsistency in the way that the group Edit and Create
		 * screens are rendered: the Create screen has a submit button built
		 * in, but the Edit screen does not. This function allows plugin
		 * authors to write markup that does not contain the submit button for
		 * use on both the Create and Edit screens - BP will provide the button
		 * if one is not found.
		 *
		 * @since 1.8.0
		 *
		 * @param string $screen The screen markup, captured in the output
		 *                       buffer.
		 * @return string $screen The same markup, with a submit button added.
		 */
		protected function maybe_add_submit_button($screen = '')
		{
		}
		/**
		 * Does the given markup have a submit button?
		 *
		 * @since 1.8.0
		 *
		 * @param string $screen The markup to check.
		 * @return bool True if a Submit button is found, otherwise false.
		 */
		public static function has_submit_button($screen = '')
		{
		}
		/**
		 * Detect redirects hardcoded into edit_screen_save() callbacks.
		 *
		 * @since 2.1.0
		 *
		 * @param string $redirect Redirect string.
		 * @return string
		 */
		public function detect_post_save_redirect($redirect = '')
		{
		}
		/** Admin *************************************************************/
		/**
		 * Hook this extension's Admin metabox into BuddyPress, if necessary.
		 *
		 * @since 1.8.0
		 */
		protected function setup_admin_hooks()
		{
		}
		/**
		 * Call the admin_screen() method, and add a nonce field.
		 *
		 * @since 1.8.0
		 */
		public function call_admin_screen()
		{
		}
		/**
		 * Check the nonce, and call the admin_screen_save() method.
		 *
		 * @since 1.8.0
		 */
		public function call_admin_screen_save()
		{
		}
		/**
		 * Create the Dashboard meta box for this extension.
		 *
		 * @since 1.7.0
		 */
		public function _meta_box_display_callback()
		{
		}
		/** Utilities *********************************************************/
		/**
		 * Generate the nonce fields for a settings form.
		 *
		 * The nonce field name (the second param passed to wp_nonce_field)
		 * contains this extension's slug and is thus unique to this extension.
		 * This is necessary because in some cases (namely, the Dashboard),
		 * more than one extension may generate nonces on the same page, and we
		 * must avoid name clashes.
		 *
		 * @since 1.8.0
		 *
		 * @param string $context Screen context. 'create', 'edit', or 'admin'.
		 */
		public function nonce_field($context = '')
		{
		}
		/**
		 * Check the nonce on a submitted settings form.
		 *
		 * @since 1.8.0
		 *
		 * @param string $context Screen context. 'create', 'edit', or 'admin'.
		 */
		public function check_nonce($context = '')
		{
		}
		/**
		 * Is the specified screen enabled?
		 *
		 * To be enabled, a screen must both have the 'enabled' key set to true
		 * (legacy: $this->enable_create_step, etc), and its screen_callback
		 * must also exist and be callable.
		 *
		 * @since 1.8.0
		 *
		 * @param string $context Screen context. 'create', 'edit', or 'admin'.
		 * @return bool True if the screen is enabled, otherwise false.
		 */
		public function is_screen_enabled($context = '')
		{
		}
		/**
		 * Get the appropriate screen callback for the specified context/type.
		 *
		 * BP Group Extensions have three special "screen contexts": create,
		 * admin, and edit. Each of these contexts has a corresponding
		 * _screen() and _screen_save() method, which allow group extension
		 * plugins to define different markup and logic for each context.
		 *
		 * BP also supports fallback settings_screen() and
		 * settings_screen_save() methods, which can be used to define markup
		 * and logic that is shared between context. For each context, you may
		 * either provide context-specific methods, or you can let BP fall back
		 * on the shared settings_* callbacks.
		 *
		 * For example, consider a BP_Group_Extension implementation that looks
		 * like this:
		 *
		 *   // ...
		 *   function create_screen( $group_id ) { ... }
		 *   function create_screen_save( $group_id ) { ... }
		 *   function settings_screen( $group_id ) { ... }
		 *   function settings_screen_save( $group_id ) { ... }
		 *   // ...
		 *
		 * BP_Group_Extension will use your create_* methods for the Create
		 * steps, and will use your generic settings_* methods for the Edit
		 * and Admin contexts. This schema allows plugin authors maximum
		 * flexibility without having to repeat themselves.
		 *
		 * The get_screen_callback() method uses a ReflectionClass object to
		 * determine whether your extension has provided a given callback.
		 *
		 * @since 1.8.0
		 *
		 * @param string $context Screen context. 'create', 'edit', or 'admin'.
		 * @param string $type    Screen type. 'screen' or 'screen_save'. Default:
		 *                        'screen'.
		 * @return callable A callable function handle.
		 */
		public function get_screen_callback($context = '', $type = 'screen')
		{
		}
		/**
		 * Recursive argument parsing.
		 *
		 * This acts like a multi-dimensional version of wp_parse_args() (minus
		 * the querystring parsing - you must pass arrays).
		 *
		 * Values from $a override those from $b; keys in $b that don't exist
		 * in $a are passed through.
		 *
		 * This is different from array_merge_recursive(), both because of the
		 * order of preference ($a overrides $b) and because of the fact that
		 * array_merge_recursive() combines arrays deep in the tree, rather
		 * than overwriting the b array with the a array.
		 *
		 * The implementation of this function is specific to the needs of
		 * BP_Group_Extension, where we know that arrays will always be
		 * associative, and that an argument under a given key in one array
		 * will be matched by a value of identical depth in the other one. The
		 * function is NOT designed for general use, and will probably result
		 * in unexpected results when used with data in the wild. See, eg,
		 * https://core.trac.wordpress.org/ticket/19888
		 *
		 * @since 1.8.0
		 *
		 * @param array $a First set of arguments.
		 * @param array $b Second set of arguments.
		 * @return array Parsed arguments.
		 */
		public static function parse_args_r(&$a, $b)
		{
		}
		/** Legacy Support ********************************************************/
		/*
		 * In BuddyPress 1.8, the recommended technique for configuring
		 * extensions changed from directly setting various object properties
		 * in the class constructor, to passing a configuration array to
		 * parent::init(). The following methods ensure that extensions created
		 * in the old way continue to work, by converting legacy configuration
		 * data to the new format.
		 */
		/**
		 * Provide access to otherwise unavailable object properties.
		 *
		 * This magic method is here for backward compatibility with plugins
		 * that refer to config properties that have moved to a different
		 * location (such as enable_create_step, which is now at
		 * $this->screens['create']['enabled']
		 *
		 * The legacy_properties array is set up in
		 * self::setup_legacy_properties().
		 *
		 * @since 1.8.0
		 *
		 * @param string $key Property name.
		 * @return mixed The value if found, otherwise null.
		 */
		public function __get($key)
		{
		}
		/**
		 * Provide a fallback for isset( $this->foo ) when foo is unavailable.
		 *
		 * This magic method is here for backward compatibility with plugins
		 * that have set their class config options directly in the class
		 * constructor. The parse_legacy_properties() method of the current
		 * class needs to check whether any legacy keys have been put into the
		 * $this->data array.
		 *
		 * @since 1.8.0
		 *
		 * @param string $key Property name.
		 * @return bool True if the value is set, otherwise false.
		 */
		public function __isset($key)
		{
		}
		/**
		 * Allow plugins to set otherwise unavailable object properties.
		 *
		 * This magic method is here for backward compatibility with plugins
		 * that may attempt to modify the group extension by manually assigning
		 * a value to an object property that no longer exists, such as
		 * $this->enable_create_step.
		 *
		 * @since 1.8.0
		 *
		 * @param string $key Property name.
		 * @param mixed  $value Property value.
		 */
		public function __set($key, $value)
		{
		}
		/**
		 * Return a list of legacy properties.
		 *
		 * The legacy implementation of BP_Group_Extension used all of these
		 * object properties for configuration. Some have been moved.
		 *
		 * @since 1.8.0
		 *
		 * @return array List of legacy property keys.
		 */
		protected function get_legacy_property_list()
		{
		}
		/**
		 * Parse legacy properties.
		 *
		 * The old standard for BP_Group_Extension was for plugins to register
		 * their settings as properties in their constructor. The new method is
		 * to pass a config array to the init() method. In order to support
		 * legacy plugins, we slurp up legacy properties, and later on we'll
		 * parse them into the new init() array.
		 *
		 * @since 1.8.0
		 */
		protected function parse_legacy_properties()
		{
		}
		/**
		 * Set up legacy properties.
		 *
		 * This method is responsible for ensuring that all legacy config
		 * properties are stored in an array $this->legacy_properties, so that
		 * they remain available to plugins that reference the variables at
		 * their old locations.
		 *
		 * @since 1.8.0
		 *
		 * @see BP_Group_Extension::__get()
		 */
		protected function setup_legacy_properties()
		{
		}
	}
	/**
	 * Base class for the BuddyPress Suggestions API.
	 *
	 * Originally built to power BuddyPress' at-mentions suggestions, it's flexible enough to be used
	 * for similar kinds of future core requirements, or those desired by third-party developers.
	 *
	 * To implement a new suggestions service, create a new class that extends this one, and update
	 * the list of default services in {@link bp_core_get_suggestions()}. If you're building a plugin,
	 * it's recommend that you use the `bp_suggestions_services` filter to do this. :)
	 *
	 * While the implementation of the query logic is left to you, it should be as quick and efficient
	 * as possible. When implementing the abstract methods in this class, pay close attention to the
	 * recommendations provided in the phpDoc blocks, particularly the expected return types.
	 *
	 * @since 2.1.0
	 */
	abstract class BP_Suggestions
	{
		/**
		 * Default arguments common to all suggestions services.
		 *
		 * If your custom service requires further defaults, add them here.
		 *
		 * @since 2.1.0
		 * @var array
		 */
		protected $default_args = array('limit' => 16, 'term' => '', 'type' => '');
		/**
		 * Holds the arguments for the query (about to made to the suggestions service).
		 *
		 * This includes `$default_args`, as well as the user-supplied values.
		 *
		 * @since 2.1.0
		 * @var array
		 */
		protected $args = array();
		/**
		 * Constructor.
		 *
		 * @since 2.1.0
		 *
		 * @param array $args Optional. If set, used as the parameters for the suggestions service query.
		 */
		public function __construct(array $args = array())
		{
		}
		/**
		 * Set the parameters for the suggestions service query.
		 *
		 * @since 2.1.0
		 *
		 * @param array $args {
		 *     Array of arguments for the suggestions service query.
		 *
		 *     @type int    $limit Maximum number of results to display. Optional, default: 16.
		 *     @type string $type  The name of the suggestion service to use for the request. Mandatory.
		 *     @type string $term  The suggestion service will try to find results that contain this string.
		 *                         Mandatory.
		 * }
		 */
		public function set_query(array $args = array())
		{
		}
		/**
		 * Validate and sanitise the parameters for the suggestion service query.
		 *
		 * Be sure to call this class' version of this method when implementing it in your own service.
		 * If validation fails, you must return a WP_Error object.
		 *
		 * @since 2.1.0
		 *
		 * @return true|WP_Error If validation fails, return a WP_Error object. On success, return true (bool).
		 */
		public function validate()
		{
		}
		/**
		 * Find and return a list of suggestions that match the query.
		 *
		 * The return type is important. If no matches are found, an empty array must be returned.
		 * Matches must be returned as objects in an array.
		 *
		 * The object format for each match must be: { 'ID': string, 'image': string, 'name': string }
		 * For example: { 'ID': 'admin', 'image': 'http://example.com/logo.png', 'name': 'Name Surname' }
		 *
		 * @since 2.1.0
		 *
		 * @return array|WP_Error Array of results. If there were problems, returns a WP_Error object.
		 */
		public abstract function get_suggestions();
	}
	/**
	 * Adds support for user at-mentions to the Suggestions API.
	 *
	 * This class is in the Core component because it's required by a class in the Groups component,
	 * and Groups is loaded before Members (alphabetical order).
	 *
	 * @since 2.1.0
	 */
	class BP_Members_Suggestions extends \BP_Suggestions
	{
		/**
		 * Default arguments for this suggestions service.
		 *
		 * @since 2.1.0
		 * @var array $args {
		 *     @type int    $limit        Maximum number of results to display. Default: 16.
		 *     @type bool   $only_friends If true, only match the current user's friends. Default: false.
		 *     @type string $term         The suggestion service will try to find results that contain this string.
		 *                                Mandatory.
		 * }
		 */
		protected $default_args = array('limit' => 10, 'only_friends' => \false, 'term' => '', 'type' => '');
		/**
		 * Validate and sanitise the parameters for the suggestion service query.
		 *
		 * @since 2.1.0
		 *
		 * @return true|WP_Error If validation fails, return a WP_Error object. On success, return true (bool).
		 */
		public function validate()
		{
		}
		/**
		 * Find and return a list of username suggestions that match the query.
		 *
		 * @since 2.1.0
		 *
		 * @return array|WP_Error Array of results. If there were problems, returns a WP_Error object.
		 */
		public function get_suggestions()
		{
		}
	}
	/**
	 * Adds support for user at-mentions (for users in a specific Group) to the Suggestions API.
	 *
	 * @since 2.1.0
	 */
	class BP_Groups_Member_Suggestions extends \BP_Members_Suggestions
	{
		/**
		 * Default arguments for this suggestions service.
		 *
		 * @since 2.1.0
		 * @var array $args {
		 *     @type int    $group_id     Positive integers will restrict the search to members in that group.
		 *                                Negative integers will restrict the search to members in every other group.
		 *     @type int    $limit        Maximum number of results to display. Default: 16.
		 *     @type bool   $only_friends If true, only match the current user's friends. Default: false.
		 *     @type string $term         The suggestion service will try to find results that contain this string.
		 *                                Mandatory.
		 * }
		 */
		protected $default_args = array('group_id' => 0, 'limit' => 16, 'only_friends' => \false, 'term' => '', 'type' => '');
		/**
		 * Validate and sanitise the parameters for the suggestion service query.
		 *
		 * @since 2.1.0
		 *
		 * @return true|WP_Error If validation fails, return a WP_Error object. On success, return true (bool).
		 */
		public function validate()
		{
		}
		/**
		 * Find and return a list of username suggestions that match the query.
		 *
		 * @since 2.1.0
		 *
		 * @return array|WP_Error Array of results. If there were problems, returns a WP_Error object.
		 */
		public function get_suggestions()
		{
		}
	}
	/**
	 * BuddyPress Group Membership object.
	 */
	class BP_Groups_Member
	{
		/**
		 * ID of the membership.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $id;
		/**
		 * ID of the group associated with the membership.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $group_id;
		/**
		 * ID of the user associated with the membership.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $user_id;
		/**
		 * ID of the user whose invitation initiated the membership.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $inviter_id;
		/**
		 * Whether the member is an admin of the group.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $is_admin;
		/**
		 * Whether the member is a mod of the group.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $is_mod;
		/**
		 * Whether the member is banned from the group.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $is_banned;
		/**
		 * Title used to describe the group member's role in the group.
		 *
		 * Eg, 'Group Admin'.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $user_title;
		/**
		 * Last modified date of the membership.
		 *
		 * This value is updated when, eg, invitations are accepted.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		var $date_modified;
		/**
		 * Whether the membership has been confirmed.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $is_confirmed;
		/**
		 * Comments associated with the membership.
		 *
		 * In BP core, these are limited to the optional message users can
		 * include when requesting membership to a private group.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		var $comments;
		/**
		 * Whether an invitation has been sent for this membership.
		 *
		 * The purpose of this flag is to mark when an invitation has been
		 * "drafted" (the user has been added via the interface at Send
		 * Invites), but the Send button has not been pressed, so the
		 * invitee has not yet been notified.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $invite_sent;
		/**
		 * WP_User object representing the membership's user.
		 *
		 * @since 1.6.0
		 * @var WP_User
		 */
		protected $user;
		/**
		 * Constructor method.
		 *
		 * @since 1.6.0
		 *
		 * @param int      $user_id  Optional. Along with $group_id, can be used to
		 *                           look up a membership.
		 * @param int      $group_id Optional. Along with $user_id, can be used to
		 *                           look up a membership.
		 * @param int|bool $id       Optional. The unique ID of the membership object.
		 * @param bool     $populate Whether to populate the properties of the
		 *                           located membership. Default: true.
		 */
		public function __construct($user_id = 0, $group_id = 0, $id = \false, $populate = \true)
		{
		}
		/**
		 * Populate the object's properties.
		 *
		 * @since 1.6.0
		 */
		public function populate()
		{
		}
		/**
		 * Magic getter.
		 *
		 * @since 2.8.0
		 *
		 * @param string $key Key.
		 * @return BP_Core_User|null
		 */
		public function __get($key)
		{
		}
		/**
		 * Magic issetter.
		 *
		 * @since 2.8.0
		 *
		 * @param string $key Key.
		 * @return bool
		 */
		public function __isset($key)
		{
		}
		/**
		 * Get the user object corresponding to this membership.
		 *
		 * Used for lazyloading the protected `user` property.
		 *
		 * @since 2.8.0
		 *
		 * @return BP_Core_User
		 */
		protected function get_user_object()
		{
		}
		/**
		 * Save the membership data to the database.
		 *
		 * @since 1.6.0
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Promote a member to a new status.
		 *
		 * @since 1.6.0
		 *
		 * @param string $status The new status. 'mod' or 'admin'.
		 * @return bool
		 */
		public function promote($status = 'mod')
		{
		}
		/**
		 * Demote membership to Member status (non-admin, non-mod).
		 *
		 * @since 1.6.0
		 *
		 * @return bool
		 */
		public function demote()
		{
		}
		/**
		 * Ban the user from the group.
		 *
		 * @since 1.6.0
		 *
		 * @return bool
		 */
		public function ban()
		{
		}
		/**
		 * Unban the user from the group.
		 *
		 * @since 1.6.0
		 *
		 * @return bool
		 */
		public function unban()
		{
		}
		/**
		 * Mark a pending invitation as accepted.
		 *
		 * @since 1.6.0
		 */
		public function accept_invite()
		{
		}
		/**
		 * Confirm a membership request.
		 *
		 * @since 1.6.0
		 */
		public function accept_request()
		{
		}
		/**
		 * Remove the current membership.
		 *
		 * @since 1.6.0
		 *
		 * @return bool
		 */
		public function remove()
		{
		}
		/** Static Methods ****************************************************/
		/**
		 * Refresh the `total_group_count` for a user.
		 *
		 * @since 1.8.0
		 *
		 * @param int $user_id ID of the user.
		 */
		public static function refresh_total_group_count_for_user($user_id)
		{
		}
		/**
		 * Refresh the `total_member_count` for a group.
		 *
		 * The request skip the current cache so that we always grab the lastest total count.
		 *
		 * @since 1.8.0
		 * @since 10.0.0 Updated to use `BP_Groups_Group::get_total_member_count`
		 *
		 * @param int $group_id ID of the group.
		 */
		public static function refresh_total_member_count_for_group($group_id)
		{
		}
		/**
		 * Delete a membership, based on user + group IDs.
		 *
		 * @since 1.6.0
		 *
		 * @param int $user_id  ID of the user.
		 * @param int $group_id ID of the group.
		 * @return bool
		 */
		public static function delete($user_id, $group_id)
		{
		}
		/**
		 * Get the IDs of the groups of which a specified user is a member.
		 *
		 * @since 1.6.0
		 *
		 * @param int      $user_id ID of the user.
		 * @param int|bool $limit   Optional. Max number of results to return.
		 *                          Default: false (no limit).
		 * @param int|bool $page    Optional. Page offset of results to return.
		 *                          Default: false (no limit).
		 * @return array {
		 *     @type array $groups Array of groups returned by paginated query.
		 *     @type int   $total  Count of groups matching query.
		 * }
		 */
		public static function get_group_ids($user_id, $limit = \false, $page = \false)
		{
		}
		/**
		 * Get the IDs of the groups of which a specified user is a member, sorted by the date joined.
		 *
		 * @since 1.6.0
		 *
		 * @param int         $user_id ID of the user.
		 * @param int|bool    $limit   Optional. Max number of results to return.
		 *                             Default: false (no limit).
		 * @param int|bool    $page    Optional. Page offset of results to return.
		 *                             Default: false (no limit).
		 * @param string|bool $filter  Optional. Limit results to groups whose name or
		 *                             description field matches search terms.
		 * @return array {
		 *     @type array $groups Array of groups returned by paginated query.
		 *     @type int   $total  Count of groups matching query.
		 * }
		 */
		public static function get_recently_joined($user_id, $limit = \false, $page = \false, $filter = \false)
		{
		}
		/**
		 * Get the IDs of the groups of which a specified user is an admin.
		 *
		 * @since 1.6.0
		 *
		 * @param int         $user_id ID of the user.
		 * @param int|bool    $limit   Optional. Max number of results to return.
		 *                             Default: false (no limit).
		 * @param int|bool    $page    Optional. Page offset of results to return.
		 *                             Default: false (no limit).
		 * @param string|bool $filter  Optional. Limit results to groups whose name or
		 *                             description field matches search terms.
		 * @return array {
		 *     @type array $groups Array of groups returned by paginated query.
		 *     @type int   $total  Count of groups matching query.
		 * }
		 */
		public static function get_is_admin_of($user_id, $limit = \false, $page = \false, $filter = \false)
		{
		}
		/**
		 * Get the IDs of the groups of which a specified user is a moderator.
		 *
		 * @since 1.6.0
		 *
		 * @param int         $user_id ID of the user.
		 * @param int|bool    $limit   Optional. Max number of results to return.
		 *                             Default: false (no limit).
		 * @param int|bool    $page    Optional. Page offset of results to return.
		 *                             Default: false (no limit).
		 * @param string|bool $filter  Optional. Limit results to groups whose name or
		 *                             description field matches search terms.
		 * @return array {
		 *     @type array $groups Array of groups returned by paginated query.
		 *     @type int   $total  Count of groups matching query.
		 * }
		 */
		public static function get_is_mod_of($user_id, $limit = \false, $page = \false, $filter = \false)
		{
		}
		/**
		 * Get the groups of which a specified user is banned from.
		 *
		 * @since 2.4.0
		 *
		 * @param int         $user_id ID of the user.
		 * @param int|bool    $limit   Optional. Max number of results to return.
		 *                             Default: false (no limit).
		 * @param int|bool    $page    Optional. Page offset of results to return.
		 *                             Default: false (no limit).
		 * @param string|bool $filter  Optional. Limit results to groups whose name or
		 *                             description field matches search terms.
		 * @return array {
		 *     @type array $groups Array of groups returned by paginated query.
		 *     @type int   $total  Count of groups matching query.
		 * }
		 */
		public static function get_is_banned_of($user_id, $limit = \false, $page = \false, $filter = \false)
		{
		}
		/**
		 * Get the count of groups of which the specified user is a member.
		 *
		 * @since 1.6.0
		 *
		 * @param int $user_id Optional. Default: ID of the displayed user.
		 * @return int Group count.
		 */
		public static function total_group_count($user_id = 0)
		{
		}
		/**
		 * Get group objects for groups that a user is currently invited to.
		 *
		 * @since 1.6.0
		 *
		 * @param int               $user_id ID of the invitee.
		 * @param int|bool          $limit   Optional. Max number of results to return.
		 *                                   Default: false (no limit).
		 * @param int|bool          $page    Optional. Page offset of results to return.
		 *                                   Default: false (no limit).
		 * @param string|array|bool $exclude Optional. Array or comma-separated list
		 *                                   of group IDs to exclude from results.
		 * @return array {
		 *     @type array $groups Array of groups returned by paginated query.
		 *     @type int   $total  Count of groups matching query.
		 * }
		 */
		public static function get_invites($user_id, $limit = \false, $page = \false, $exclude = \false)
		{
		}
		/**
		 * Gets the total group invite count for a user.
		 *
		 * @since 2.0.0
		 *
		 * @param int $user_id The user ID.
		 * @return int
		 */
		public static function get_invite_count_for_user($user_id = 0)
		{
		}
		/**
		 * Gets memberships of a user for purposes of a personal data export.
		 *
		 * @since 4.0.0
		 *
		 * @param int $user_id ID of the user.
		 * @param array $args {
		 *    Array of optional arguments.
		 *    @type int    $page     Page of memberships being requested. Default 1.
		 *    @type int    $per_page Memberships to return per page. Default 20.
		 *    @type string $type     Membership type being requested. Accepts 'membership',
		 *                           'pending_request', 'pending_received_invitation',
		 *                           'pending_sent_invitation'. Default 'membership'.
		 * }
		 *
		 * @return array
		 */
		public static function get_user_memberships($user_id, $args = array())
		{
		}
		/**
		 * Check whether a user has an outstanding invitation to a given group.
		 *
		 * @since 1.6.0
		 *
		 * @param int    $user_id  ID of the potential invitee.
		 * @param int    $group_id ID of the group.
		 * @param string $type     If 'sent', results are limited to those invitations
		 *                         that have actually been sent (non-draft). Default: 'sent'.
		 * @return int|null The ID of the invitation if found; null if not found.
		 */
		public static function check_has_invite($user_id, $group_id, $type = 'sent')
		{
		}
		/**
		 * Delete an invitation, by specifying user ID and group ID.
		 *
		 * @since 1.6.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param  int $user_id    ID of the user.
		 * @param  int $group_id   ID of the group.
		 * @param  int $inviter_id ID of the inviter. Specify if you want to delete
		 *                         a specific invite. Leave false if you want to
		 *                         delete all invites to this group.
		 * @return int Number of records deleted.
		 */
		public static function delete_invite($user_id, $group_id, $inviter_id = \false)
		{
		}
		/**
		 * Delete an unconfirmed membership request, by user ID and group ID.
		 *
		 * @since 1.6.0
		 *
		 * @param int $user_id  ID of the user.
		 * @param int $group_id ID of the group.
		 * @return int Number of records deleted.
		 */
		public static function delete_request($user_id, $group_id)
		{
		}
		/**
		 * Check whether a user is an admin of a given group.
		 *
		 * @since 1.6.0
		 *
		 * @param int $user_id  ID of the user.
		 * @param int $group_id ID of the group.
		 * @return mixed
		 */
		public static function check_is_admin($user_id, $group_id)
		{
		}
		/**
		 * Check whether a user is a mod of a given group.
		 *
		 * @since 1.6.0
		 *
		 * @param int $user_id  ID of the user.
		 * @param int $group_id ID of the group.
		 * @return mixed
		 */
		public static function check_is_mod($user_id, $group_id)
		{
		}
		/**
		 * Check whether a user is a member of a given group.
		 *
		 * @since 1.6.0
		 *
		 * @param int $user_id  ID of the user.
		 * @param int $group_id ID of the group.
		 * @return mixed
		 */
		public static function check_is_member($user_id, $group_id)
		{
		}
		/**
		 * Check whether a user is banned from a given group.
		 *
		 * @since 1.6.0
		 *
		 * @param int $user_id  ID of the user.
		 * @param int $group_id ID of the group.
		 * @return int|null int 1 if user is banned; int 0 if user is not banned;
		 *                  null if user is not part of the group or if group doesn't exist.
		 */
		public static function check_is_banned($user_id, $group_id)
		{
		}
		/**
		 * Is the specified user the creator of the group?
		 *
		 * @since 1.2.6
		 *
		 * @param int $user_id  ID of the user.
		 * @param int $group_id ID of the group.
		 * @return int|null int of group ID if user is the creator; null on failure.
		 */
		public static function check_is_creator($user_id, $group_id)
		{
		}
		/**
		 * Check whether a user has an outstanding membership request for a given group.
		 *
		 * @since 1.6.0
		 *
		 * @param int $user_id  ID of the user.
		 * @param int $group_id ID of the group.
		 * @return int Database ID of the membership if found; int 0 on failure.
		 */
		public static function check_for_membership_request($user_id, $group_id)
		{
		}
		/**
		 * Get a list of randomly selected IDs of groups that the member belongs to.
		 *
		 * @since 1.6.0
		 *
		 * @param int $user_id      ID of the user.
		 * @param int $total_groups Max number of group IDs to return. Default: 5.
		 * @return array Group IDs.
		 */
		public static function get_random_groups($user_id = 0, $total_groups = 5)
		{
		}
		/**
		 * Get the IDs of all a given group's members.
		 *
		 * @since 1.6.0
		 *
		 * @param int $group_id ID of the group.
		 * @return array IDs of all group members.
		 */
		public static function get_group_member_ids($group_id)
		{
		}
		/**
		 * Get a list of all a given group's admins.
		 *
		 * @since 1.6.0
		 *
		 * @param  int   $group_id ID of the group.
		 * @return array           Info about group admins (user_id + date_modified).
		 */
		public static function get_group_administrator_ids($group_id)
		{
		}
		/**
		 * Prime the bp_group_admins cache for one or more groups.
		 *
		 * @since 2.7.0
		 *
		 * @param array $group_ids IDs of the groups.
		 * @return bool
		 */
		public static function prime_group_admins_mods_cache($group_ids)
		{
		}
		/**
		 * Get a list of all a given group's moderators.
		 *
		 * @since 1.6.0
		 *
		 * @param int $group_id ID of the group.
		 * @return array Info about group mods (user_id + date_modified).
		 */
		public static function get_group_moderator_ids($group_id)
		{
		}
		/**
		 * Get group membership objects by ID (or an array of IDs).
		 *
		 * @since 2.6.0
		 *
		 * @param int|string|array $membership_ids Single membership ID or comma-separated/array list of membership IDs.
		 * @return array
		 */
		public static function get_memberships_by_id($membership_ids)
		{
		}
		/**
		 * Get the IDs users with outstanding membership requests to the group.
		 *
		 * @since 1.6.0
		 *
		 * @param int $group_id ID of the group.
		 * @return array IDs of users with outstanding membership requests.
		 */
		public static function get_all_membership_request_user_ids($group_id)
		{
		}
		/**
		 * Get members of a group.
		 *
		 * @deprecated 1.6.0
		 *
		 * @param int        $group_id            ID of the group being queried for.
		 * @param bool|int   $limit               Max amount to return.
		 * @param bool|int   $page                Pagination value.
		 * @param bool       $exclude_admins_mods Whether or not to exclude admins and moderators.
		 * @param bool       $exclude_banned      Whether or not to exclude banned members.
		 * @param bool|array $exclude             Array of user IDs to exclude.
		 * @return false|array
		 */
		public static function get_all_for_group($group_id, $limit = \false, $page = \false, $exclude_admins_mods = \true, $exclude_banned = \true, $exclude = \false)
		{
		}
		/**
		 * Get all membership IDs for a user.
		 *
		 * @since 2.6.0
		 *
		 * @param int $user_id ID of the user.
		 * @return array
		 */
		public static function get_membership_ids_for_user($user_id)
		{
		}
		/**
		 * Delete all memberships for a given group.
		 *
		 * @since 1.6.0
		 *
		 * @param int $group_id ID of the group.
		 * @return int Number of records deleted.
		 */
		public static function delete_all($group_id)
		{
		}
		/**
		 * Delete all group membership information for the specified user.
		 *
		 * In cases where the user is the sole member of a group, a site administrator is
		 * assigned to be the group's administrator. Unhook `groups_remove_data_for_user()`
		 * to modify this behavior.
		 *
		 * @since 1.0.0
		 * @since 4.0.0 The method behavior was changed so that single-member groups are not deleted.
		 *
		 * @param int $user_id ID of the user.
		 * @return bool
		 */
		public static function delete_all_for_user($user_id)
		{
		}
	}
	/**
	 * The main Groups template loop class.
	 *
	 * Responsible for loading a group of groups into a loop for display.
	 *
	 * @since 1.2.0
	 */
	class BP_Groups_Template
	{
		/**
		 * The loop iterator.
		 *
		 * @since 1.2.0
		 * @var int
		 */
		public $current_group = -1;
		/**
		 * The number of groups returned by the paged query.
		 *
		 * @since 1.2.0
		 * @var int
		 */
		public $group_count;
		/**
		 * Array of groups located by the query.
		 *
		 * @since 1.2.0
		 * @var array
		 */
		public $groups;
		/**
		 * The group object currently being iterated on.
		 *
		 * @since 1.2.0
		 * @var object
		 */
		public $group;
		/**
		 * A flag for whether the loop is currently being iterated.
		 *
		 * @since 1.2.0
		 * @var bool
		 */
		public $in_the_loop;
		/**
		 * The page number being requested.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		public $pag_page;
		/**
		 * The number of items being requested per page.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		public $pag_num;
		/**
		 * URL argument used for the pagination param.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		public $pag_arg;
		/**
		 * An HTML string containing pagination links.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		public $pag_links;
		/**
		 * The total number of groups matching the query parameters.
		 *
		 * @since 1.2.0
		 * @var int
		 */
		public $total_group_count;
		/**
		 * Whether the template loop is for a single group page.
		 *
		 * @since 1.2.0
		 * @var bool
		 */
		public $single_group = \false;
		/**
		 * Field to sort by.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		public $sort_by;
		/**
		 * Sort order.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		public $order;
		/**
		 * Constructor method.
		 *
		 * @see BP_Groups_Group::get() for an in-depth description of arguments.
		 *
		 * @param array $args {
		 *     Array of arguments. Accepts all arguments accepted by
		 *     {@link BP_Groups_Group::get()}. In cases where the default
		 *     values of the params differ, they have been discussed below.
		 *     @type int $per_page Default: 20.
		 *     @type int $page Default: 1.
		 * }
		 */
		function __construct(...$args)
		{
		}
		/**
		 * Whether there are groups available in the loop.
		 *
		 * @since 1.2.0
		 *
		 * @see bp_has_groups()
		 *
		 * @return bool True if there are items in the loop, otherwise false.
		 */
		function has_groups()
		{
		}
		/**
		 * Set up the next group and iterate index.
		 *
		 * @since 1.2.0
		 *
		 * @return object The next group to iterate over.
		 */
		function next_group()
		{
		}
		/**
		 * Rewind the groups and reset member index.
		 *
		 * @since 1.2.0
		 */
		function rewind_groups()
		{
		}
		/**
		 * Whether there are groups left in the loop to iterate over.
		 *
		 * This method is used by {@link bp_groups()} as part of the while loop
		 * that controls iteration inside the groups loop, eg:
		 *     while ( bp_groups() ) { ...
		 *
		 * @since 1.2.0
		 *
		 * @see bp_groups()
		 *
		 * @return bool True if there are more groups to show, otherwise false.
		 */
		function groups()
		{
		}
		/**
		 * Set up the current group inside the loop.
		 *
		 * Used by {@link bp_the_group()} to set up the current group data
		 * while looping, so that template tags used during that iteration make
		 * reference to the current member.
		 *
		 * @since 1.2.0
		 *
		 * @see bp_the_group()
		 */
		function the_group()
		{
		}
	}
	/**
	 * Creates our Groups component.
	 *
	 * @since 1.5.0
	 */
	#[\AllowDynamicProperties]
	class BP_Groups_Component extends \BP_Component
	{
		/**
		 * Auto-join group when non group member performs group activity.
		 *
		 * @since 1.5.0
		 * @var bool
		 */
		public $auto_join;
		/**
		 * The group being currently accessed.
		 *
		 * @since 1.5.0
		 * @var BP_Groups_Group
		 */
		public $current_group;
		/**
		 * Default group extension.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $default_extension;
		/**
		 * Illegal group names/slugs.
		 *
		 * @since 1.5.0
		 * @var array
		 */
		public $forbidden_names;
		/**
		 * Group creation/edit steps (e.g. Details, Settings, Avatar, Invites).
		 *
		 * @since 1.5.0
		 * @var array
		 */
		public $group_creation_steps;
		/**
		 * Types of group statuses (Public, Private, Hidden).
		 *
		 * @since 1.5.0
		 * @var array
		 */
		public $valid_status;
		/**
		 * Group types.
		 *
		 * @see bp_groups_register_group_type()
		 *
		 * @since 2.6.0
		 * @var array
		 */
		public $types = array();
		/**
		 * Nav for the Group component.
		 *
		 * @since 2.6.0
		 * @var BP_Core_Nav
		 */
		public $nav;
		/**
		 * Current directory group type.
		 *
		 * @see groups_directory_groups_setup()
		 *
		 * @since 2.7.0
		 * @var string
		 */
		public $current_directory_type = '';
		/**
		 * List of registered Group extensions.
		 *
		 * @see bp_register_group_extension()
		 *
		 * @since 10.0.0
		 * @var array
		 */
		public $group_extensions = array();
		/**
		 * Start the groups component creation process.
		 *
		 * @since 1.5.0
		 */
		public function __construct()
		{
		}
		/**
		 * Include Groups component files.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::includes() for a description of arguments.
		 *
		 * @param array $includes See BP_Component::includes() for a description.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Only load up certain code when on specific pages.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Sets up the current (displayed) group it it exists.
		 *
		 * @since 12.0.0
		 *
		 * @param string $group_slug The current action which is possibly a group slug.
		 * @return BP_Groups_Group|Object|integer A group's object or 0 if no groups were found.
		 */
		public function setup_current_group($group_slug = '')
		{
		}
		/**
		 * Set up the component actions.
		 *
		 * @since 12.0.0
		 */
		public function setup_actions()
		{
		}
		/**
		 * Set up additional globals for the component.
		 *
		 * @since 10.0.0
		 */
		public function setup_additional_globals()
		{
		}
		/**
		 * Set up component global data.
		 *
		 * The BP_GROUPS_SLUG constant is deprecated.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_globals() for a description of arguments.
		 *
		 * @param array $args See BP_Component::setup_globals() for a description.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Set up canonical stack for this component.
		 *
		 * @since 2.1.0
		 */
		public function setup_canonical_stack()
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @see `BP_Component::register_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::register_nav()` for description.
		 * @param array $sub_nav  Optional. See `BP_Component::register_nav()` for description.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up component navigation.
		 *
		 * @since 1.5.0
		 * @since 12.0.0 Used to customize the main navigation name and set
		 *               a Groups single item navigation.
		 *
		 * @see `BP_Component::setup_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 */
		public function setup_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up the component entries in the WordPress Admin Bar.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_nav() for a description of the $wp_admin_nav
		 *      parameter array.
		 *
		 * @param array $wp_admin_nav See BP_Component::setup_admin_bar() for a description.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Set up the title for pages and <title>.
		 *
		 * @since 1.5.0
		 */
		public function setup_title()
		{
		}
		/**
		 * Setup cache groups
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Set up taxonomies.
		 *
		 * @since 2.6.0
		 * @since 7.0.0 The Group Type taxonomy is registered using the `bp_groups_register_group_type_taxonomy()` function.
		 */
		public function register_taxonomies()
		{
		}
		/**
		 * Adds the Groups directory type & Group create rewrite tags.
		 *
		 * @since 12.0.0
		 *
		 * @param array $rewrite_tags Optional. See BP_Component::add_rewrite_tags() for
		 *                            description.
		 */
		public function add_rewrite_tags($rewrite_tags = array())
		{
		}
		/**
		 * Adds the Groups directory type & Group create rewrite rules.
		 *
		 * @since 12.0.0
		 *
		 * @param array $rewrite_rules Optional. See BP_Component::add_rewrite_rules() for
		 *                             description.
		 */
		public function add_rewrite_rules($rewrite_rules = array())
		{
		}
		/**
		 * Parse the WP_Query and eventually display the component's directory or single item.
		 *
		 * @since 12.0.0
		 *
		 * @param WP_Query $query Required. See BP_Component::parse_query() for
		 *                        description.
		 */
		public function parse_query($query)
		{
		}
		/**
		 * Check the parsed query is consistent with Group’s registered screens.
		 *
		 * @since 12.0.0
		 */
		public function check_parsed_query()
		{
		}
		/**
		 * Init the BP REST API.
		 *
		 * @since 5.0.0
		 * @since 6.0.0 Adds the Group Cover REST endpoint.
		 *
		 * @param array $controllers Optional. See BP_Component::rest_api_init() for
		 *                           description.
		 */
		public function rest_api_init($controllers = array())
		{
		}
		/**
		 * Register the BP Groups Blocks.
		 *
		 * @since 6.0.0
		 * @since 12.0.0 Use the WP Blocks API v2.
		 *
		 * @param array $blocks Optional. See BP_Component::blocks_init() for
		 *                      description.
		 */
		public function blocks_init($blocks = array())
		{
		}
	}
	/**
	 * Membership request template loop class.
	 *
	 * @since 1.0.0
	 */
	class BP_Groups_Membership_Requests_Template
	{
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $current_request = -1;
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $request_count;
		/**
		 * @since 1.0.0
		 * @var array
		 */
		public $requests;
		/**
		 * @since 1.0.0
		 * @var object
		 */
		public $request;
		/**
		 * @sine 1.0.0
		 * @var bool
		 */
		public $in_the_loop;
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $pag_page;
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $pag_num;
		/**
		 * @since 1.0.0
		 * @var array|string|null
		 */
		public $pag_links;
		/**
		 * URL argument used for the pagination param.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $pag_arg;
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $total_request_count;
		/**
		 * Constructor method.
		 *
		 * @since 1.5.0
		 *
		 * @param array $args {
		 *     @type int $group_id ID of the group whose membership requests
		 *                         are being queried. Default: current group id.
		 *     @type int $per_page Number of records to return per page of
		 *                         results. Default: 10.
		 *     @type int $page     Page of results to show. Default: 1.
		 *     @type int $max      Max items to return. Default: false (show all)
		 * }
		 */
		public function __construct($args = array())
		{
		}
		/**
		 * Whether or not there are requests to show.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function has_requests()
		{
		}
		/**
		 * Moves up to the next request.
		 *
		 * @since 1.0.0
		 *
		 * @return object
		 */
		public function next_request()
		{
		}
		/**
		 * Rewinds the requests to the first in the list.
		 *
		 * @since 1.0.0
		 */
		public function rewind_requests()
		{
		}
		/**
		 * Finishes up the requests to display.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function requests()
		{
		}
		/**
		 * Sets up the request to display.
		 *
		 * @since 1.0.0
		 */
		public function the_request()
		{
		}
	}
	/**
	 * Group Cover endpoints.
	 *
	 * /groups/<group_id>/cover
	 *
	 * @since 6.0.0
	 */
	class BP_REST_Attachments_Group_Cover_Endpoint extends \WP_REST_Controller
	{
		use \BP_REST_Attachments;
		/**
		 * BP_Attachment_Cover_Image Instance.
		 *
		 * @since 6.0.0
		 *
		 * @var BP_Attachment_Cover_Image
		 */
		protected $attachment_instance;
		/**
		 * Reuse some parts of the BP_REST_Groups_Endpoint class.
		 *
		 * @since 6.0.0
		 *
		 * @var BP_REST_Groups_Endpoint
		 */
		protected $groups_endpoint;
		/**
		 * Hold the group object.
		 *
		 * @since 6.0.0
		 *
		 * @var BP_Groups_Group
		 */
		protected $group;
		/**
		 * Group object type.
		 *
		 * @since 6.0.0
		 *
		 * @var string
		 */
		protected $object = 'group';
		/**
		 * Constructor.
		 *
		 * @since 6.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 6.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Fetch an existing group cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Checks if a given request has access to get a group cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Upload a group cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to upload a group cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Delete an existing group cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Checks if a given request has access to delete a group cover.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares group cover to return as an object.
		 *
		 * @since 6.0.0
		 *
		 * @param string          $cover_url Group cover url.
		 * @param WP_REST_Request $request   Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($cover_url, $request)
		{
		}
		/**
		 * Get the plugin schema, conforming to JSON Schema.
		 *
		 * @since 6.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
	}
	/**
	 * Group invitations class.
	 *
	 * An extension of the core Invitations class that adapts the
	 * core logic to accommodate group invitation behavior.
	 *
	 * @since 5.0.0
	 */
	class BP_Groups_Invitation_Manager extends \BP_Invitation_Manager
	{
		/**
		 * Construct parameters.
		 *
		 * @since 5.0.0
		 *
		 * @param array|string $args.
		 */
		public function __construct($args = '')
		{
		}
		/**
		 * This is where custom actions are added to run when notifications of an
		 * invitation or request need to be generated & sent.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Invitation $invitation The invitation to send.
		 * @return bool
		 */
		public function run_send_action(\BP_Invitation $invitation)
		{
		}
		/**
		 * This is where custom actions are added to run when an invitation
		 * or request is accepted.
		 *
		 * @since 5.0.0
		 *
		 * @param string $type Are we accepting an invitation or request?
		 * @param array  $r    Parameters that describe the invitation being accepted.
		 * @return bool
		 */
		public function run_acceptance_action($type, $r)
		{
		}
		/**
		 * With group invitations, we don't need to keep the old record, so we delete rather than
		 * mark invitations as "accepted."
		 *
		 * @since 5.0.0
		 *
		 * @see BP_Invitation::mark_accepted_by_data()
		 *      for a description of arguments.
		 *
		 * @param array $args.
		 */
		public function mark_accepted($args)
		{
		}
		/**
		 * Should this invitation be created?
		 *
		 * @since 5.0.0
		 *
		 * @param array $args Array of arguments.
		 * @return bool
		 */
		public function allow_invitation($args)
		{
		}
		/**
		 * Should this request be created?
		 *
		 * @since 5.0.0
		 *
		 * @param array $args.
		 * @return bool.
		 */
		public function allow_request($args)
		{
		}
	}
	/**
	 * Groups endpoints.
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Groups_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve groups.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Request List of groups object data.
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to group items.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Retrieve a group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to get information about a specific group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Create a group.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to create a group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Update a group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to update a group.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Delete a group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete a group.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Retrieves the current user groups.
		 *
		 * @since 7.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error Response object on success, or WP_Error object on failure.
		 */
		public function get_current_user_groups($request)
		{
		}
		/**
		 * Check if a given request has access to fetch the user's groups.
		 *
		 * @since 7.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_current_user_groups_permissions_check($request)
		{
		}
		/**
		 * Prepares group data for return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Groups_Group $item     The group object.
		 * @param WP_REST_Request $request  Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($item, $request)
		{
		}
		/**
		 * Prepare a group for create or update.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return stdClass|WP_Error
		 */
		protected function prepare_item_for_database($request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Groups_Group $group Group object.
		 * @return array
		 */
		protected function prepare_links($group)
		{
		}
		/**
		 * See if user can delete or update a group.
		 *
		 * @since 5.0.0
		 *
		 * @param  BP_Groups_Group $group Group item.
		 * @return bool
		 */
		protected function can_user_delete_or_update($group)
		{
		}
		/**
		 * Can a user see a group?
		 *
		 * @since 5.0.0
		 *
		 * @param  BP_Groups_Group $group Group object.
		 * @return bool
		 */
		public function can_see($group)
		{
		}
		/**
		 * Can this user see hidden groups?
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return bool
		 */
		protected function can_see_hidden_groups($request)
		{
		}
		/**
		 * Get group object.
		 *
		 * @since 5.0.0
		 *
		 * @param  int|WP_REST_Request $request Full details about the request or an group integer.
		 * @return false|BP_Groups_Group
		 */
		public function get_group_object($request)
		{
		}
		/**
		 * Edit some arguments for the endpoint's CREATABLE and EDITABLE methods.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the group schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for collections of groups.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * Group Invites endpoints.
	 *
	 * Use /groups/{group_id}/invites
	 * Use /groups/{group_id}/invites/{invite_id}
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Group_Invites_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Reuse some parts of the BP_REST_Groups_Endpoint class.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_REST_Groups_Endpoint
		 */
		protected $groups_endpoint;
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve group invitations.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to group invitations.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return bool|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Fetch a specific group invitation by ID.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to fetch group invitation.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Invite a member to a group.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to invite a member to a group.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Accept a group invitation.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to accept a group invitation.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Remove (reject/delete) a group invitation.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete a group invitation.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return bool|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares group invitation data to return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Invitation   $invite  The invitation object.
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($invite, $request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Invitation $invite Invite object.
		 * @return array
		 */
		protected function prepare_links($invite)
		{
		}
		/**
		 * Check access.
		 *
		 * @param int $group_id Group ID.
		 * @return bool
		 */
		protected function can_see($group_id)
		{
		}
		/**
		 * Helper function to fetch a single group invite.
		 *
		 * @since 5.0.0
		 *
		 * @param int $invite_id The ID of the invitation you wish to fetch.
		 * @return BP_Invitation|bool $invite Invitation if found, false otherwise.
		 */
		public function fetch_single_invite($invite_id = 0)
		{
		}
		/**
		 * Edit the type of the some properties for the CREATABLE & EDITABLE methods.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the group invite schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for collections of group invites.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * BuddyPress Group object.
	 *
	 * @since 1.6.0
	 */
	#[\AllowDynamicProperties]
	class BP_Groups_Group
	{
		/**
		 * ID of the group.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		public $id;
		/**
		 * User ID of the group's creator.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		public $creator_id;
		/**
		 * Name of the group.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $name;
		/**
		 * Group slug.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $slug;
		/**
		 * Group description.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $description;
		/**
		 * Group status.
		 *
		 * Core statuses are 'public', 'private', and 'hidden'.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $status;
		/**
		 * Parent ID.
		 *
		 * ID of parent group, if applicable.
		 *
		 * @since 2.7.0
		 * @var int
		 */
		public $parent_id;
		/**
		 * Controls whether the group has a forum enabled.
		 *
		 * @since 1.6.0
		 * @since 3.0.0 Previously, this referred to Legacy Forums. It's still used by bbPress 2 for integration.
		 *
		 * @var int
		 */
		public $enable_forum;
		/**
		 * Date the group was created.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $date_created;
		/**
		 * Data about the group's admins.
		 *
		 * @since 1.6.0
		 * @var array
		 */
		protected $admins;
		/**
		 * Data about the group's moderators.
		 *
		 * @since 1.6.0
		 * @var array
		 */
		protected $mods;
		/**
		 * Total count of group members.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		protected $total_member_count;
		/**
		 * Is the current user a member of this group?
		 *
		 * @since 1.2.0
		 * @var bool
		 */
		protected $is_member;
		/**
		 * Is the current user a member of this group?
		 * Alias of $is_member for backward compatibility.
		 *
		 * @since 2.9.0
		 * @var bool
		 */
		protected $is_user_member;
		/**
		 * Does the current user have an outstanding invitation to this group?
		 *
		 * @since 1.9.0
		 * @var bool
		 */
		protected $is_invited;
		/**
		 * Does the current user have a pending membership request to this group?
		 *
		 * @since 1.9.0
		 * @var bool
		 */
		protected $is_pending;
		/**
		 * Timestamp of the last activity that happened in this group.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		protected $last_activity;
		/**
		 * If this is a private or hidden group, does the current user have access?
		 *
		 * @since 1.6.0
		 * @var bool
		 */
		protected $user_has_access;
		/**
		 * Can the current user know that this group exists?
		 *
		 * @since 2.9.0
		 * @var bool
		 */
		protected $is_visible;
		/**
		 * Raw arguments passed to the constructor.
		 *
		 * Not currently used by BuddyPress.
		 *
		 * @since 2.0.0
		 * @var array
		 */
		public $args;
		/**
		 * Constructor method.
		 *
		 * @since 1.6.0
		 *
		 * @param int|null $id   Optional. If the ID of an existing group is provided,
		 *                       the object will be pre-populated with info about that group.
		 * @param array    $args {
		 *     Array of optional arguments.
		 *     @type bool $populate_extras Deprecated.
		 * }
		 */
		public function __construct($id = \null, $args = array())
		{
		}
		/**
		 * Set up data about the current group.
		 *
		 * @since 1.6.0
		 */
		public function populate()
		{
		}
		/**
		 * Save the current group to the database.
		 *
		 * @since 1.6.0
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Delete the current group.
		 *
		 * @since 1.6.0
		 *
		 * @return bool
		 */
		public function delete()
		{
		}
		/**
		 * Magic getter.
		 *
		 * @since 2.7.0
		 *
		 * @param string $key Property name.
		 * @return mixed
		 */
		public function __get($key)
		{
		}
		/**
		 * Magic issetter.
		 *
		 * Used to maintain backward compatibility for properties that are now
		 * accessible only via magic method.
		 *
		 * @since 2.7.0
		 *
		 * @param string $key Property name.
		 * @return bool
		 */
		public function __isset($key)
		{
		}
		/**
		 * Magic setter.
		 *
		 * Used to maintain backward compatibility for properties that are now
		 * accessible only via magic method.
		 *
		 * @since 2.7.0
		 *
		 * @param string $key   Property name.
		 * @param mixed  $value Property value.
		 * @return bool
		 */
		public function __set($key, $value)
		{
		}
		/**
		 * Get a list of the group's admins.
		 *
		 * Used to provide cache-friendly access to the 'admins' property of
		 * the group object.
		 *
		 * @since 2.7.0
		 *
		 * @return array|null
		 */
		protected function get_admins()
		{
		}
		/**
		 * Get a list of the group's mods.
		 *
		 * Used to provide cache-friendly access to the 'mods' property of
		 * the group object.
		 *
		 * @since 2.7.0
		 *
		 * @return array|null
		 */
		protected function get_mods()
		{
		}
		/**
		 * Set up admins and mods for the current group object.
		 *
		 * Called only when the 'admins' or 'mods' property is accessed.
		 *
		 * @since 2.7.0
		 */
		protected function set_up_admins_and_mods()
		{
		}
		/**
		 * Checks whether the logged-in user is a member of the group.
		 *
		 * @since 2.7.0
		 *
		 * @return bool|int
		 */
		protected function get_is_member()
		{
		}
		/**
		 * Checks whether the logged-in user has access to the group.
		 *
		 * @since 2.7.0
		 *
		 * @return bool
		 */
		protected function get_user_has_access()
		{
		}
		/**
		 * Checks whether the current user can know the group exists.
		 *
		 * @since 2.9.0
		 *
		 * @return bool
		 */
		protected function is_visible()
		{
		}
		/** Static Methods ****************************************************/
		/**
		 * Get whether a group exists for a given slug.
		 *
		 * @since 1.6.0
		 * @since 10.0.0 Updated to add the deprecated notice.
		 *
		 * @param string      $slug       Slug to check.
		 * @param string|bool $table_name Deprecated.
		 * @return int|null|bool False if empty slug, group ID if found; `null` if not.
		 */
		public static function group_exists($slug, $table_name = \false)
		{
		}
		/**
		 * Get the ID of a group by the group's slug.
		 *
		 * Alias of {@link BP_Groups_Group::group_exists()}.
		 *
		 * @since 1.6.0
		 *
		 * @param string $slug See {@link BP_Groups_Group::group_exists()}.
		 * @return int|null|bool See {@link BP_Groups_Group::group_exists()}.
		 */
		public static function get_id_from_slug($slug)
		{
		}
		/**
		 * Get whether a group exists for an old slug.
		 *
		 * @since 2.9.0
		 *
		 * @param  string         $slug Slug to check.
		 * @return int|null|false       Group ID if found; null if not; false if missing parameters.
		 */
		public static function get_id_by_previous_slug($slug)
		{
		}
		/**
		 * Get IDs of users with outstanding invites to a given group from a specified user.
		 *
		 * @since 1.6.0
		 * @since 2.9.0 Added $sent as a parameter.
		 *
		 * @param  int      $user_id  ID of the inviting user.
		 * @param  int      $group_id ID of the group.
		 * @param  int|null $sent     Query for a specific invite sent status. If 0, this will query for users
		 *                            that haven't had an invite sent to them yet. If 1, this will query for
		 *                            users that have had an invite sent to them. If null, no invite status will
		 *                            queried. Default: null.
		 * @return array    IDs of users who have been invited to the group by the user but have not
		 *                  yet accepted.
		 */
		public static function get_invites($user_id, $group_id, $sent = \null)
		{
		}
		/**
		 * Get a list of a user's groups, filtered by a search string.
		 *
		 * @since 1.6.0
		 *
		 * @param string   $filter  Search term. Matches against 'name' and
		 *                          'description' fields.
		 * @param int      $user_id ID of the user whose groups are being searched.
		 *                          Default: the displayed user.
		 * @param mixed    $order   Not used.
		 * @param int|null $limit   Optional. The max number of results to return.
		 *                          Default: null (no limit).
		 * @param int|null $page    Optional. The page offset of results to return.
		 *                          Default: null (no limit).
		 * @return false|array {
		 *     @type array $groups Array of matched and paginated group IDs.
		 *     @type int   $total  Total count of groups matching the query.
		 * }
		 */
		public static function filter_user_groups($filter, $user_id = 0, $order = \false, $limit = \null, $page = \null)
		{
		}
		/**
		 * Get a list of groups, filtered by a search string.
		 *
		 * @since 1.6.0
		 *
		 * @param string      $filter  Search term. Matches against 'name' and
		 *                             'description' fields.
		 * @param int|null    $limit   Optional. The max number of results to return.
		 *                             Default: null (no limit).
		 * @param int|null    $page    Optional. The page offset of results to return.
		 *                             Default: null (no limit).
		 * @param string|bool $sort_by Column to sort by. Default: false (default
		 *        sort).
		 * @param string|bool $order   ASC or DESC. Default: false (default sort).
		 * @return array {
		 *     @type array $groups Array of matched and paginated group IDs.
		 *     @type int   $total  Total count of groups matching the query.
		 * }
		 */
		public static function search_groups($filter, $limit = \null, $page = \null, $sort_by = \false, $order = \false)
		{
		}
		/**
		 * Check for the existence of a slug.
		 *
		 * @since 1.6.0
		 *
		 * @param string $slug Slug to check.
		 * @return string|null The slug, if found. Otherwise null.
		 */
		public static function check_slug($slug)
		{
		}
		/**
		 * Get the slug for a given group ID.
		 *
		 * @since 1.6.0
		 *
		 * @param int $group_id ID of the group.
		 * @return string|null The slug, if found. Otherwise null.
		 */
		public static function get_slug($group_id)
		{
		}
		/**
		 * Check whether a given group has any members.
		 *
		 * @since 1.6.0
		 *
		 * @param int $group_id ID of the group.
		 * @return bool True if the group has members, otherwise false.
		 */
		public static function has_members($group_id)
		{
		}
		/**
		 * Check whether a group has outstanding membership requests.
		 *
		 * @since 1.6.0
		 *
		 * @param int $group_id ID of the group.
		 * @return int|null The number of outstanding requests, or null if
		 *                  none are found.
		 */
		public static function has_membership_requests($group_id)
		{
		}
		/**
		 * Get outstanding membership requests for a group.
		 *
		 * @since 1.6.0
		 *
		 * @param int      $group_id ID of the group.
		 * @param int|null $limit    Optional. Max number of results to return.
		 *                           Default: null (no limit).
		 * @param int|null $page     Optional. Page offset of results returned. Default:
		 *                           null (no limit).
		 * @return array {
		 *     @type array $requests The requested page of located requests.
		 *     @type int   $total    Total number of requests outstanding for the
		 *                           group.
		 * }
		 */
		public static function get_membership_requests($group_id, $limit = \null, $page = \null)
		{
		}
		/**
		 * Query for groups.
		 *
		 * @see WP_Meta_Query::queries for a description of the 'meta_query'
		 *      parameter format.
		 *
		 * @since 1.6.0
		 * @since 2.6.0 Added `$group_type`, `$group_type__in`, and `$group_type__not_in` parameters.
		 * @since 2.7.0 Added `$update_admin_cache` and `$parent_id` parameters.
		 * @since 2.8.0 Changed `$search_terms` parameter handling and added `$search_columns` parameter.
		 * @since 2.9.0 Added `$slug` parameter.
		 * @since 10.0.0 Added `$date_query` parameter.
		 *
		 * @param array $args {
		 *     Array of parameters. All items are optional.
		 *     @type string       $type               Optional. Shorthand for certain orderby/order combinations.
		 *                                            'newest', 'active', 'popular', 'alphabetical', 'random'.
		 *                                            When present, will override orderby and order params.
		 *                                            Default: null.
		 *     @type string       $orderby            Optional. Property to sort by. 'date_created', 'last_activity',
		 *                                            'total_member_count', 'name', 'random', 'meta_id'.
		 *                                            Default: 'date_created'.
		 *     @type string       $order              Optional. Sort order. 'ASC' or 'DESC'. Default: 'DESC'.
		 *     @type int          $per_page           Optional. Number of items to return per page of results.
		 *                                            Default: null (no limit).
		 *     @type int          $page               Optional. Page offset of results to return.
		 *                                            Default: null (no limit).
		 *     @type int          $user_id            Optional. If provided, results will be limited to groups
		 *                                            of which the specified user is a member. Default: null.
		 *     @type array|string $slug               Optional. Array or comma-separated list of group slugs to limit
		 *                                            results to.
		 *                                            Default: false.
		 *     @type string       $search_terms       Optional. If provided, only groups whose names or descriptions
		 *                                            match the search terms will be returned. Allows specifying the
		 *                                            wildcard position using a '*' character before or after the
		 *                                            string or both. Works in concert with $search_columns.
		 *                                            Default: false.
		 *     @type string       $search_columns     Optional. If provided, only apply the search terms to the
		 *                                            specified columns. Works in concert with $search_terms.
		 *                                            Default: empty array.
		 *     @type array|string $group_type         Array or comma-separated list of group types to limit results to.
		 *     @type array|string $group_type__in     Array or comma-separated list of group types to limit results to.
		 *     @type array|string $group_type__not_in Array or comma-separated list of group types that will be
		 *                                            excluded from results.
		 *     @type array        $meta_query         Optional. An array of meta_query conditions.
		 *                                            See {@link WP_Meta_Query::queries} for description.
		 *     @type array        $date_query         Optional. Filter results by group last activity date. See first
		 *                                            paramter of {@link WP_Date_Query::__construct()} for syntax. Only
		 *                                            applicable if $type is either 'newest' or 'active'.
		 *     @type array|string $value              Optional. Array or comma-separated list of group IDs. Results
		 *                                            will be limited to groups within the list. Default: false.
		 *     @type array|string $parent_id          Optional. Array or comma-separated list of group IDs. Results
		 *                                            will be limited to children of the specified groups. Default: null.
		 *     @type array|string $exclude            Optional. Array or comma-separated list of group IDs.
		 *                                            Results will exclude the listed groups. Default: false.
		 *     @type bool         $update_meta_cache  Whether to pre-fetch groupmeta for the returned groups.
		 *                                            Default: true.
		 *     @type bool         $update_admin_cache Whether to pre-fetch administrator IDs for the returned
		 *                                            groups. Default: false.
		 *     @type bool         $show_hidden        Whether to include hidden groups in results. Default: false.
		 *     @type array|string $status             Optional. Array or comma-separated list of group statuses to limit
		 *                                            results to. If specified, $show_hidden is ignored.
		 *                                            Default: empty array.
		 *     @type string       $fields             Which fields to return. Specify 'ids' to fetch a list of IDs.
		 *                                            Default: 'all' (return BP_Groups_Group objects).
		 *                                            If set, meta and admin caches will not be prefetched.
		 * }
		 * @return array {
		 *     @type array $groups Array of group objects returned by the
		 *                         paginated query. (IDs only if `fields` is set to `ids`.)
		 *     @type int   $total  Total count of all groups matching non-
		 *                         paginated query params.
		 * }
		 */
		public static function get($args = array())
		{
		}
		/**
		 * Get the SQL for the 'meta_query' param in BP_Groups_Group::get()
		 *
		 * We use WP_Meta_Query to do the heavy lifting of parsing the
		 * meta_query array and creating the necessary SQL clauses.
		 *
		 * @since 1.8.0
		 *
		 * @param array $meta_query An array of meta_query filters. See the
		 *                          documentation for {@link WP_Meta_Query} for details.
		 * @return array $sql_array 'join' and 'where' clauses.
		 */
		protected static function get_meta_query_sql($meta_query = array())
		{
		}
		/**
		 * Convert the 'type' parameter to 'order' and 'orderby'.
		 *
		 * @since 1.8.0
		 *
		 * @param string $type The 'type' shorthand param.
		 *
		 * @return array {
		 *     @type string $order   SQL-friendly order string.
		 *     @type string $orderby SQL-friendly orderby column name.
		 * }
		 */
		protected static function convert_type_to_order_orderby($type = '')
		{
		}
		/**
		 * Convert the 'orderby' param into a proper SQL term/column.
		 *
		 * @since 1.8.0
		 *
		 * @param string $orderby Orderby term as passed to get().
		 * @return string $order_by_term SQL-friendly orderby term.
		 */
		protected static function convert_orderby_to_order_by_term($orderby)
		{
		}
		/**
		 * Get a list of groups whose names start with a given letter.
		 *
		 * @since 1.6.0
		 *
		 * @param string            $letter          The letter.
		 * @param int|null          $limit           Optional. The max number of results to return.
		 *                                           Default: null (no limit).
		 * @param int|null          $page            Optional. The page offset of results to return.
		 *                                           Default: null (no limit).
		 * @param bool              $populate_extras Deprecated.
		 * @param string|array|bool $exclude         Optional. Array or comma-separated list of group
		 *                                           IDs to exclude from results.
		 * @return false|array {
		 *     @type array $groups Array of group objects returned by the
		 *                         paginated query.
		 *     @type int   $total  Total count of all groups matching non-
		 *                         paginated query params.
		 * }
		 */
		public static function get_by_letter($letter, $limit = \null, $page = \null, $populate_extras = \true, $exclude = \false)
		{
		}
		/**
		 * Get a list of random groups.
		 *
		 * Use BP_Groups_Group::get() with 'type' = 'random' instead.
		 *
		 * @since 1.6.0
		 * @since 10.0.0 Deprecate the `$populate_extras` arg.
		 *
		 * @param int|null          $limit           Optional. The max number of results to return.
		 *                                           Default: null (no limit).
		 * @param int|null          $page            Optional. The page offset of results to return.
		 *                                           Default: null (no limit).
		 * @param int               $user_id         Optional. If present, groups will be limited to
		 *                                           those of which the specified user is a member.
		 * @param string|bool       $search_terms    Optional. Limit groups to those whose name
		 *                                           or description field contain the search string.
		 * @param bool              $populate_extras Deprecated.
		 * @param string|array|bool $exclude         Optional. Array or comma-separated list of group
		 *                                           IDs to exclude from results.
		 * @return array {
		 *     @type array $groups Array of group objects returned by the
		 *                         paginated query.
		 *     @type int   $total  Total count of all groups matching non-
		 *                         paginated query params.
		 * }
		 */
		public static function get_random($limit = \null, $page = \null, $user_id = 0, $search_terms = \false, $populate_extras = \true, $exclude = \false)
		{
		}
		/**
		 * Fetch extra data for a list of groups.
		 *
		 * This method is used throughout the class, by methods that take a
		 * $populate_extras parameter.
		 *
		 * Data fetched:
		 *     - Logged-in user's status within each group (is_member,
		 *       is_confirmed, is_pending, is_banned)
		 *
		 * @since 1.6.0
		 *
		 * @param array        $paged_groups Array of groups.
		 * @param string|array $group_ids    Array or comma-separated list of IDs matching
		 *                                   $paged_groups.
		 * @param string|bool  $type         Not used.
		 * @return array $paged_groups
		 */
		public static function get_group_extras(&$paged_groups, &$group_ids, $type = \false)
		{
		}
		/**
		 * Delete all invitations to a given group.
		 *
		 * @since 1.6.0
		 *
		 * @param int $group_id ID of the group whose invitations are being deleted.
		 * @return int|null Number of rows records deleted on success, null on
		 *                  failure.
		 */
		public static function delete_all_invites($group_id)
		{
		}
		/**
		 * Get a total group count for the site.
		 *
		 * Will include hidden groups in the count only if
		 * bp_current_user_can( 'bp_moderate' ).
		 *
		 * @since 1.6.0
		 * @since 10.0.0 Added the `$skip_cache` parameter.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param bool $skip_cache Optional. Skip getting count from cache.
		 *                         Defaults to false.
		 * @return int
		 */
		public static function get_total_group_count($skip_cache = \false)
		{
		}
		/**
		 * Get the member count for a group.
		 *
		 * @since 1.6.0
		 * @since 10.0.0 Updated to use the `groups_get_group_members`.
		 *
		 * @param int  $group_id   Group ID.
		 * @param bool $skip_cache Optional. Skip getting count from cache. Defaults to false.
		 * @return int Count of confirmed members for the group.
		 */
		public static function get_total_member_count($group_id, $skip_cache = \false)
		{
		}
		/**
		 * Get an array containing ids for each group type.
		 *
		 * A bit of a kludge workaround for some issues
		 * with bp_has_groups().
		 *
		 * @since 1.7.0
		 *
		 * @return array
		 */
		public static function get_group_type_ids()
		{
		}
		/**
		 * Get SQL clause for group type(s).
		 *
		 * @since 2.6.0
		 *
		 * @param  string|array $group_types Group type(s).
		 * @param  string       $operator    'IN' or 'NOT IN'.
		 * @return string       $clause      SQL clause.
		 */
		protected static function get_sql_clause_for_group_types($group_types, $operator)
		{
		}
		/**
		 * Strips the leading AND and any surrounding whitespace from a string.
		 *
		 * Used here to normalize SQL fragments generated by `WP_Meta_Query` and
		 * other utility classes.
		 *
		 * @since 2.7.0
		 *
		 * @param string $s String.
		 * @return string
		 */
		protected static function strip_leading_and($s)
		{
		}
	}
	/**
	 * Group Members Loop template class.
	 *
	 * @since 1.0.0
	 */
	class BP_Groups_Group_Members_Template
	{
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $current_member = -1;
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $member_count;
		/**
		 * @since 1.0.0
		 * @var array
		 */
		public $members;
		/**
		 * @since 1.0.0
		 * @var object
		 */
		public $member;
		/**
		 * @since 1.0.0
		 * @var bool
		 */
		public $in_the_loop;
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $pag_page;
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $pag_num;
		/**
		 * @since 1.0.0
		 * @var array|string|null
		 */
		public $pag_links;
		/**
		 * URL argument used for the pagination param.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $pag_arg;
		/**
		 * The type of member being requested. Used for ordering results.
		 *
		 * @since 2.3.0
		 * @var string
		 */
		public $type = '';
		/**
		 * The total number of members.
		 *
		 * @var int
		 */
		public $total_member_count;
		/**
		 * @since 1.0.0
		 * @var int
		 */
		public $total_group_count;
		/**
		 * Constructor.
		 *
		 * @since 1.5.0
		 *
		 * @param array $args {
		 *     An array of optional arguments.
		 *     @type int      $group_id           ID of the group whose members are being
		 *                                        queried. Default: current group ID.
		 *     @type int      $page               Page of results to be queried. Default: 1.
		 *     @type int      $per_page           Number of items to return per page of
		 *                                        results. Default: 20.
		 *     @type int      $max                Optional. Max number of items to return.
		 *     @type array    $exclude            Optional. Array of user IDs to exclude.
		 *     @type bool|int $exclude_admin_mods True (or 1) to exclude admins and mods from
		 *                                        results. Default: 1.
		 *     @type bool|int $exclude_banned     True (or 1) to exclude banned users from results.
		 *                                        Default: 1.
		 *     @type array    $group_role         Optional. Array of group roles to include.
		 *     @type string   $search_terms       Optional. Search terms to match.
		 * }
		 */
		public function __construct($args = array())
		{
		}
		/**
		 * Whether or not there are members to display.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function has_members()
		{
		}
		/**
		 * Increments to the next member to display.
		 *
		 * @since 1.0.0
		 *
		 * @return object
		 */
		public function next_member()
		{
		}
		/**
		 * Rewinds to the first member to display.
		 *
		 * @since 1.0.0
		 */
		public function rewind_members()
		{
		}
		/**
		 * Finishes up the members for display.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function members()
		{
		}
		/**
		 * Sets up the member to display.
		 *
		 * @since 1.0.0
		 */
		public function the_member()
		{
		}
	}
	/**
	 * The main theme compat class for BuddyPress Groups.
	 *
	 * This class sets up the necessary theme compatibility actions to safely output
	 * group template parts to the_title and the_content areas of a theme.
	 *
	 * @since 1.7.0
	 */
	class BP_Groups_Theme_Compat
	{
		/**
		 * Set up theme compatibility for the Groups component.
		 *
		 * @since 1.7.0
		 */
		public function __construct()
		{
		}
		/**
		 * Are we looking at something that needs group theme compatibility?
		 *
		 * @since 1.7.0
		 */
		public function is_group()
		{
		}
		/** Directory *********************************************************/
		/**
		 * Add template hierarchy to theme compat for the group directory page.
		 *
		 * This is to mirror how WordPress has
		 * {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param string $templates The templates from bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function directory_template_hierarchy($templates)
		{
		}
		/**
		 * Update the global $post with directory data.
		 *
		 * @since 1.7.0
		 */
		public function directory_dummy_post()
		{
		}
		/**
		 * Filter the_content with the groups index template part.
		 *
		 * @since 1.7.0
		 */
		public function directory_content()
		{
		}
		/** Create ************************************************************/
		/**
		 * Add custom template hierarchy to theme compat for the group create page.
		 *
		 * This is to mirror how WordPress has
		 * {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param string $templates The templates from bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function create_template_hierarchy($templates)
		{
		}
		/**
		 * Update the global $post with create screen data.
		 *
		 * @since 1.7.0
		 */
		public function create_dummy_post()
		{
		}
		/**
		 * Filter the_content with the create screen template part.
		 *
		 * @since 1.7.0
		 */
		public function create_content()
		{
		}
		/** Single ************************************************************/
		/**
		 * Add custom template hierarchy to theme compat for group pages.
		 *
		 * This is to mirror how WordPress has
		 * {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param string $templates The templates from bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function single_template_hierarchy($templates)
		{
		}
		/**
		 * Update the global $post with single group data.
		 *
		 * @since 1.7.0
		 */
		public function single_dummy_post()
		{
		}
		/**
		 * Filter the_content with the single group template part.
		 *
		 * @since 1.7.0
		 */
		public function single_content()
		{
		}
	}
	/**
	 * Group Avatar endpoints.
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Attachments_Group_Avatar_Endpoint extends \WP_REST_Controller
	{
		use \BP_REST_Attachments;
		/**
		 * Reuse some parts of the BP_REST_Groups_Endpoint class.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_REST_Groups_Endpoint
		 */
		protected $groups_endpoint;
		/**
		 * BP_Attachment_Avatar Instance.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_Attachment_Avatar
		 */
		protected $avatar_instance;
		/**
		 * Hold the group object.
		 *
		 * @since 5.0.0
		 *
		 * @var BP_Groups_Group
		 */
		protected $group;
		/**
		 * Group object type.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		protected $object = 'group';
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Fetch an existing group avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Checks if a given request has access to get a group avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Upload a group avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to upload a group avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Delete an existing group avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Checks if a given request has access to delete a group avatar.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares avatar data to return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param stdClass|string $avatar  Avatar object or string with url or image with html.
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($avatar, $request)
		{
		}
		/**
		 * Get the plugin schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for the `get_item`.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_collection_params()
		{
		}
	}
	/**
	 * Groups widget.
	 *
	 * @since 1.0.3
	 * @deprecated 12.0.0
	 */
	class BP_Groups_Widget
	{
		/**
		 * Working as a group, we get things done better.
		 *
		 * @since 1.0.3
		 * @since 9.0.0 Adds the `show_instance_in_rest` property to Widget options.
		 * @deprecated 12.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Enqueue scripts.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		public function enqueue_scripts()
		{
		}
		/**
		 * Extends our front-end output method.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @param array $args     Array of arguments for the widget.
		 * @param array $instance Widget instance data.
		 */
		public function widget($args, $instance)
		{
		}
		/**
		 * Extends our update method.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @param array $new_instance New instance data.
		 * @param array $old_instance Original instance data.
		 * @return array
		 */
		public function update($new_instance, $old_instance)
		{
		}
		/**
		 * Extends our form method.
		 *
		 * @since 1.0.3
		 * @deprecated 12.0.0
		 *
		 * @param array $instance Current instance.
		 * @return mixed
		 */
		public function form($instance)
		{
		}
	}
	/**
	 * Group invitation template loop class.
	 *
	 * @since 1.1.0
	 */
	class BP_Groups_Invite_Template
	{
		/**
		 * @since 1.1.0
		 * @var int
		 */
		public $current_invite = -1;
		/**
		 * @since 1.1.0
		 * @var int
		 */
		public $invite_count;
		/**
		 * @since 1.1.0
		 * @var array
		 */
		public $invites;
		/**
		 * @since 1.1.0
		 * @var object
		 */
		public $invite;
		/**
		 * List of invites found and their respective data.
		 *
		 * @since 1.1.0
		 * @var array
		 */
		public $invite_data = array();
		/**
		 * @since 1.1.0
		 * @var bool
		 */
		public $in_the_loop;
		/**
		 * @since 1.1.0
		 * @var int
		 */
		public $pag_page;
		/**
		 * @since 1.1.0
		 * @var int
		 */
		public $pag_num;
		/**
		 * @since 1.1.0
		 * @var string
		 */
		public $pag_links;
		/**
		 * URL argument used for the pagination param.
		 *
		 * @since 1.1.0
		 * @var string
		 */
		public $pag_arg;
		/**
		 * @since 1.1.0
		 * @var int
		 */
		public $total_invite_count;
		/**
		 * BP_Groups_Invite_Template constructor.
		 *
		 * @since 1.5.0
		 *
		 * @param array $args
		 */
		public function __construct($args = array())
		{
		}
		/**
		 * Whether or not there are invites to show.
		 *
		 * @since 1.1.0
		 *
		 * @return bool
		 */
		public function has_invites()
		{
		}
		/**
		 * Increments up to the next invite to show.
		 *
		 * @since 1.1.0
		 *
		 * @return object
		 */
		public function next_invite()
		{
		}
		/**
		 * Rewinds to the first invite to show.
		 *
		 * @since 1.1.0
		 */
		public function rewind_invites()
		{
		}
		/**
		 * Finishes up the invites to show.
		 *
		 * @since 1.1.0
		 *
		 * @return bool
		 */
		public function invites()
		{
		}
		/**
		 * Sets up the invite to show.
		 *
		 * @since 1.1.0
		 */
		public function the_invite()
		{
		}
	}
	/**
	 * List table class for the Groups component admin page.
	 *
	 * @since 1.7.0
	 */
	class BP_Groups_List_Table extends \WP_List_Table
	{
		/**
		 * The type of view currently being displayed.
		 *
		 * E.g. "All", "Pending", "Approved", "Spam"...
		 *
		 * @since 1.7.0
		 * @var string
		 */
		public $view = 'all';
		/**
		 * Group counts for each group type.
		 *
		 * @since 1.7.0
		 * @var int
		 */
		public $group_counts = 0;
		/**
		 * Multidimensional array of group visibility (status) types and their groups.
		 *
		 * @link https://buddypress.trac.wordpress.org/ticket/6277
		 * @var array
		 */
		public $group_type_ids = array();
		/**
		 * Constructor
		 *
		 * @since 1.7.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set up items for display in the list table.
		 *
		 * Handles filtering of data, sorting, pagination, and any other data
		 * manipulation required prior to rendering.
		 *
		 * @since 1.7.0
		 */
		public function prepare_items()
		{
		}
		/**
		 * Get an array of all the columns on the page.
		 *
		 * @since 1.7.0
		 *
		 * @return array Array of column headers.
		 */
		public function get_column_info()
		{
		}
		/**
		 * Get name of default primary column
		 *
		 * @since 2.3.3
		 *
		 * @return string
		 */
		protected function get_default_primary_column_name()
		{
		}
		/**
		 * Display a message on screen when no items are found ("No groups found").
		 *
		 * @since 1.7.0
		 */
		public function no_items()
		{
		}
		/**
		 * Output the Groups data table.
		 *
		 * @since 1.7.0
		 */
		public function display()
		{
		}
		/**
		 * Extra controls to be displayed between bulk actions and pagination
		 *
		 * @since 2.7.0
		 * @access protected
		 *
		 * @param string $which
		 */
		protected function extra_tablenav($which)
		{
		}
		/**
		 * Generate content for a single row of the table.
		 *
		 * @since 1.7.0
		 *
		 * @param object|array $item The current group item in the loop.
		 */
		public function single_row($item = array())
		{
		}
		/**
		 * Get the list of views available on this table (e.g. "all", "public").
		 *
		 * @since 1.7.0
		 */
		public function get_views()
		{
		}
		/**
		 * Get bulk actions for single group row.
		 *
		 * @since 1.7.0
		 *
		 * @return array Key/value pairs for the bulk actions dropdown.
		 */
		public function get_bulk_actions()
		{
		}
		/**
		 * Get the table column titles.
		 *
		 * @since 1.7.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @return array Array of column titles.
		 */
		public function get_columns()
		{
		}
		/**
		 * Get the column names for sortable columns.
		 *
		 * Note: It's not documented in WP, but the second item in the
		 * nested arrays below is $desc_first. Normally, we would set
		 * last_active to be desc_first (since you're generally interested in
		 * the *most* recently active group, not the *least*). But because
		 * the default sort for the Groups admin screen is DESC by last_active,
		 * we want the first click on the Last Active column header to switch
		 * the sort order - ie, to make it ASC. Thus last_active is set to
		 * $desc_first = false.
		 *
		 * @since 1.7.0
		 *
		 * @return array Array of sortable column names.
		 */
		public function get_sortable_columns()
		{
		}
		/**
		 * Override WP_List_Table::row_actions().
		 *
		 * Basically a duplicate of the row_actions() method, but removes the
		 * unnecessary <button> addition.
		 *
		 * @since 2.3.3
		 * @since 2.3.4 Visibility set to public for compatibility with WP < 4.0.0.
		 *
		 * @param array $actions        The list of actions.
		 * @param bool  $always_visible Whether the actions should be always visible.
		 * @return string
		 */
		public function row_actions($actions, $always_visible = \false)
		{
		}
		/**
		 * Markup for the Checkbox column.
		 *
		 * @since 1.7.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @param array $item A singular item (one full row).
		 */
		public function column_cb($item = array())
		{
		}
		/**
		 * Markup for the Group ID column.
		 *
		 * @since 1.7.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @param array $item A singular item (one full row).
		 */
		public function column_gid($item = array())
		{
		}
		/**
		 * Name column, and "quick admin" rollover actions.
		 *
		 * Called "comment" in the CSS so we can re-use some WP core CSS.
		 *
		 * @since 1.7.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @param array $item A singular item (one full row).
		 */
		public function column_comment($item = array())
		{
		}
		/**
		 * Markup for the Description column.
		 *
		 * @since 1.7.0
		 *
		 * @param array $item Information about the current row.
		 */
		public function column_description($item = array())
		{
		}
		/**
		 * Markup for the Status column.
		 *
		 * @since 1.7.0
		 *
		 * @param array $item Information about the current row.
		 */
		public function column_status($item = array())
		{
		}
		/**
		 * Markup for the Number of Members column.
		 *
		 * @since 1.7.0
		 * @since 10.0.0 Updated to use `groups_get_total_member_count`.
		 *
		 * @param array $item Information about the current row.
		 */
		public function column_members($item = array())
		{
		}
		/**
		 * Markup for the Last Active column.
		 *
		 * @since 1.7.0
		 *
		 * @param array $item Information about the current row.
		 */
		public function column_last_active($item = array())
		{
		}
		/**
		 * Allow plugins to add their custom column.
		 *
		 * @since 2.0.0
		 *
		 * @param array  $item        Information about the current row.
		 * @param string $column_name The column name.
		 * @return string
		 */
		public function column_default($item = array(), $column_name = '')
		{
		}
		// Group Types
		/**
		 * Add group type column to the WordPress admin groups list table.
		 *
		 * @since 2.7.0
		 *
		 * @param array $columns Groups table columns.
		 *
		 * @return array $columns
		 */
		public function add_type_column($columns = array())
		{
		}
		/**
		 * Markup for the Group Type column.
		 *
		 * @since 2.7.0
		 *
		 * @param string $retval      Empty string.
		 * @param string $column_name Name of the column being rendered.
		 * @param array  $item        The current group item in the loop.
		 * @return string
		 */
		public function column_content_group_type($retval = '', $column_name = '', $item = array())
		{
		}
		/**
		 * Filters the group type list permalink in the Group Type column.
		 *
		 * Changes the group type permalink to use the admin URL.
		 *
		 * @since 2.7.0
		 *
		 * @param  string $retval Current group type permalink.
		 * @param  object $type   Group type object.
		 * @return string
		 */
		public function group_type_permalink_use_admin_filter($retval, $type)
		{
		}
		/**
		 * Markup for the Group Type bulk change select.
		 *
		 * @since 2.7.0
		 *
		 * @param string $which The location of the extra table nav markup: 'top' or 'bottom'.
		 */
		public function add_group_type_bulk_change_select($which)
		{
		}
	}
	/**
	 * Messages endpoints.
	 *
	 * /messages/
	 * /messages/{thread_id}
	 * /messages/starred/{message_id}
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Messages_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve threads.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to thread items.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Get a single thread.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to a thread item.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Init a Messages Thread or add a reply to an existing Thread.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Check if a given request has access to create a message.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Update metadata for one of the messages of the thread.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to update a message.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Adds or removes the message from the current user's starred box.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_starred($request)
		{
		}
		/**
		 * Check if a given request has access to update user starred messages.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_starred_permissions_check($request)
		{
		}
		/**
		 * Delete a thread.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete a thread.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepare a message for create.
		 *
		 * @since 6.0.0
		 *
		 * @param WP_REST_Request $request The request sent to the API.
		 * @return stdClass
		 */
		protected function prepare_item_for_database($request)
		{
		}
		/**
		 * Prepares message data for the REST response.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Messages_Message $message The Message object.
		 * @param WP_REST_Request     $request Full details about the request.
		 * @return array The Message data for the REST response.
		 */
		public function prepare_message_for_response($message, $request)
		{
		}
		/**
		 * Prepares recipient data for the REST response.
		 *
		 * @since 5.0.0
		 *
		 * @param object          $recipient The recipient object.
		 * @param WP_REST_Request $request   Full details about the request.
		 * @return array                     The recipient data for the REST response.
		 */
		public function prepare_recipient_for_response($recipient, $request)
		{
		}
		/**
		 * Prepares thread data for return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Messages_Thread $thread  The thread object.
		 * @param WP_REST_Request    $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($thread, $request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Messages_Thread $thread  Thread object.
		 * @return array
		 */
		protected function prepare_links($thread)
		{
		}
		/**
		 * Get the thread object.
		 *
		 * @since 5.0.0
		 *
		 * @param int $thread_id Thread ID.
		 * @param int $user_id   User ID.
		 * @return BP_Messages_Thread|string
		 */
		public function get_thread_object($thread_id, $user_id = 0)
		{
		}
		/**
		 * Get the message object.
		 *
		 * @since 5.0.0
		 *
		 * @param int $message_id Message ID.
		 * @return BP_Messages_Message|string
		 */
		public function get_message_object($message_id)
		{
		}
		/**
		 * Select the item schema arguments needed for the CREATABLE, EDITABLE and DELETABLE methods.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the message schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for Messages collections.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * A widget that displays sitewide notices.
	 *
	 * @since 1.9.0
	 * @deprecated 12.0.0
	 */
	class BP_Messages_Sitewide_Notices_Widget extends \WP_Widget
	{
		/**
		 * Constructor method.
		 *
		 * @since 1.9.0
		 * @since 9.0.0 Adds the `show_instance_in_rest` property to Widget options.
		 * @deprecated 12.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Render the widget.
		 *
		 * @deprecated 12.0.0
		 *
		 * @see WP_Widget::widget() for a description of parameters.
		 *
		 * @param array $args     See {@WP_Widget::widget()}.
		 * @param array $instance See {@WP_Widget::widget()}.
		 */
		public function widget($args, $instance)
		{
		}
		/**
		 * Process the saved settings for the widget.
		 *
		 * @deprecated 12.0.0
		 *
		 * @see WP_Widget::update() for a description of parameters and
		 *      return values.
		 *
		 * @param array $new_instance See {@WP_Widget::update()}.
		 * @param array $old_instance See {@WP_Widget::update()}.
		 * @return array $instance See {@WP_Widget::update()}.
		 */
		public function update($new_instance, $old_instance)
		{
		}
		/**
		 * Render the settings form for Appearance > Widgets.
		 *
		 * @deprecated 12.0.0
		 *
		 * @see WP_Widget::form() for a description of parameters.
		 *
		 * @param array $instance See {@WP_Widget::form()}.
		 */
		public function form($instance)
		{
		}
	}
	/**
	 * BuddyPress Notices Admin class.
	 */
	#[\AllowDynamicProperties]
	class BP_Messages_Notices_Admin
	{
		/**
		 * The ID returned by `add_users_page()`.
		 *
		 * @since 3.0.0
		 * @var string
		 */
		public $screen_id = '';
		/**
		 * The URL of the admin screen.
		 *
		 * @since 3.0.0
		 * @var string
		 */
		public $url = '';
		/**
		 * The current instance of the BP_Messages_Notices_List_Table class.
		 *
		 * @since 3.0.0
		 * @var BP_Messages_Notices_List_Table|string
		 */
		public $list_table = '';
		/**
		 * Create a new instance or access the current instance of this class.
		 *
		 * @since 3.0.0
		 *
		 * @return BP_Messages_Notices_Admin
		 */
		public static function register_notices_admin()
		{
		}
		/**
		 * Constructor.
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Populate the classs variables.
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Add action hooks.
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Add the 'Site Notices' admin menu item.
		 *
		 * @since 3.0.0
		 */
		public function admin_menu()
		{
		}
		/**
		 * Catch save/update requests or load the screen.
		 *
		 * @since 3.0.0
		 */
		public function admin_load()
		{
		}
		/**
		 * Generate content for the bp-notices admin screen.
		 *
		 * @since 3.0.0
		 */
		public function admin_index()
		{
		}
	}
	/**
	 * BuddyPress Notices class.
	 *
	 * Use this class to create, activate, deactivate or delete notices.
	 *
	 * @since 1.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Messages_Notice
	{
		/**
		 * The notice ID.
		 *
		 * @var int|null
		 */
		public $id = \null;
		/**
		 * The subject line for the notice.
		 *
		 * @var string
		 */
		public $subject;
		/**
		 * The content of the notice.
		 *
		 * @var string
		 */
		public $message;
		/**
		 * The date the notice was created.
		 *
		 * @var string
		 */
		public $date_sent;
		/**
		 * Whether the notice is active or not.
		 *
		 * @var int
		 */
		public $is_active;
		/**
		 * Constructor.
		 *
		 * @since 1.0.0
		 *
		 * @param int|null $id Optional. The ID of the current notice.
		 */
		public function __construct($id = \null)
		{
		}
		/**
		 * Populate method.
		 *
		 * Runs during constructor.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function populate()
		{
		}
		/**
		 * Saves a notice.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Activates a notice.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function activate()
		{
		}
		/**
		 * Deactivates a notice.
		 *
		 * @since 1.0.0
		 *
		 * @return bool
		 */
		public function deactivate()
		{
		}
		/**
		 * Deletes a notice.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function delete()
		{
		}
		/** Static Methods ********************************************************/
		/**
		 * Pulls up a list of notices.
		 *
		 * To get all notices, pass a value of -1 to pag_num.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *     Array of parameters.
		 *     @type int $pag_num  Number of notices per page. Defaults to 20.
		 *     @type int $pag_page The page number.  Defaults to 1.
		 * }
		 * @return array List of notices to display.
		 */
		public static function get_notices($args = array())
		{
		}
		/**
		 * Returns the total number of recorded notices.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return int
		 */
		public static function get_total_notice_count()
		{
		}
		/**
		 * Returns the active notice that should be displayed on the front end.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return BP_Messages_Notice
		 */
		public static function get_active()
		{
		}
	}
	/**
	 * BuddyPress Message Thread class.
	 *
	 * @since 1.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Messages_Thread
	{
		/**
		 * The message thread ID.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $thread_id;
		/**
		 * The current messages in the message thread.
		 *
		 * @since 1.0.0
		 * @var array
		 */
		public $messages;
		/**
		 * The current messages count in the message thread.
		 *
		 * @since 12.0.0
		 * @var int
		 */
		public $messages_total_count;
		/**
		 * The current recipients in the message thread.
		 *
		 * @since 1.0.0
		 * @var array
		 */
		public $recipients;
		/**
		 * The user IDs of all messages in the message thread.
		 *
		 * @since 1.2.0
		 * @var array
		 */
		public $sender_ids;
		/**
		 * The unread count for the logged-in user.
		 *
		 * @since 1.2.0
		 * @var int
		 */
		public $unread_count;
		/**
		 * The content of the last message in this thread.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		public $last_message_content;
		/**
		 * The date of the last message in this thread.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		public $last_message_date;
		/**
		 * The ID of the last message in this thread.
		 *
		 * @since 1.2.0
		 * @var int
		 */
		public $last_message_id;
		/**
		 * The subject of the last message in this thread.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		public $last_message_subject;
		/**
		 * The user ID of the author of the last message in this thread.
		 *
		 * @since 1.2.0
		 * @var int
		 */
		public $last_sender_id;
		/**
		 * Sort order of the messages in this thread (ASC or DESC).
		 *
		 * @since 1.5.0
		 * @var string
		 */
		public $messages_order;
		/**
		 * Constructor.
		 *
		 * @since 1.0.0
		 * @since 10.0.0 Updated the `$args` with new paremeters.
		 *
		 * @param int    $thread_id          The message thread ID.
		 * @param string $order              The order to sort the messages. Either 'ASC' or 'DESC'.
		 *                                   Defaults to 'ASC'.
		 * @param array  $args               {
		 *     Array of arguments.
		 *     @type int         $user_id             ID of the user to get the unread count.
		 *     @type bool        $update_meta_cache   Whether to pre-fetch metadata for
		 *                                            queried message items. Default: true.
		 *     @type int|null    $page                Page of messages being requested. Default to null, meaning all.
		 *     @type int|null    $per_page            Messages to return per page. Default to null, meaning all.
		 *     @type string      $order               Optional. The order to sort the messages. Either 'ASC' or 'DESC'.
		 *                                            Defaults to 'ASC'.
		 *     @type int|null    $recipients_page     Page of recipients being requested. Default to null, meaning all.
		 *     @type int|null    $recipients_per_page Recipients to return per page. Defaults to null, meaning all.
		 * }
		 */
		public function __construct($thread_id = 0, $order = 'ASC', $args = array())
		{
		}
		/**
		 * Populate method.
		 *
		 * Used in the constructor.
		 *
		 * @since 1.0.0
		 * @since 10.0.0 Updated the `$args` with new paremeters.
		 *
		 * @param int    $thread_id                   The message thread ID.
		 * @param string $order                       The order to sort the messages. Either 'ASC' or 'DESC'.
		 *                                            Defaults to 'ASC'.
		 * @param array  $args                        {
		 *     Array of arguments.
		 *     @type int         $user_id             ID of the user to get the unread count.
		 *     @type bool        $update_meta_cache   Whether to pre-fetch metadata for
		 *                                            queried message items. Default: true.
		 *     @type int|null    $page                Page of messages being requested. Default to null, meaning all.
		 *     @type int|null    $per_page            Messages to return per page. Default to null, meaning all.
		 *     @type string      $order               The order to sort the messages. Either 'ASC' or 'DESC'.
		 *                                            Defaults to 'ASC'.
		 *     @type int|null    $recipients_page     Page of recipients being requested. Default to null, meaning all.
		 *     @type int|null    $recipients_per_page Recipients to return per page. Defaults to null, meaning all.
		 * }
		 * @return bool False if there are no messages.
		 */
		public function populate($thread_id = 0, $order = 'ASC', $args = array())
		{
		}
		/**
		 * Mark a thread initialized in this class as read.
		 *
		 * @since 1.0.0
		 *
		 * @see BP_Messages_Thread::mark_as_read()
		 */
		public function mark_read()
		{
		}
		/**
		 * Mark a thread initialized in this class as unread.
		 *
		 * @since 1.0.0
		 *
		 * @see BP_Messages_Thread::mark_as_unread()
		 */
		public function mark_unread()
		{
		}
		/**
		 * Returns recipients for a message thread.
		 *
		 * @since 1.0.0
		 * @since 2.3.0  Added `$thread_id` as a parameter.
		 * @since 10.0.0 Added `$args` as a parameter.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int   $thread_id Message thread ID.
		 * @param array $args      {
		 *     Array of arguments.
		 *     @type int|null $recipients_page     Page of recipients being requested. Default to all.
		 *     @type int|null $recipients_per_page Recipients to return per page. Defaults to all.
		 * }
		 * @return array
		 */
		public function get_recipients($thread_id = 0, $args = array())
		{
		}
		/** Static Functions ******************************************************/
		/**
		 * Get messages associated with a thread.
		 *
		 * @since 2.3.0
		 * @since 10.0.0 Added `$args` as a parameter.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int   $thread_id The message thread ID.
		 * @param array $args      {
		 *     Array of arguments.
		 *     @type int|null    $page     Page of messages being requested. Default to all.
		 *     @type int|null    $per_page Messages to return per page. Default to all.
		 *     @type string      $order    The order to sort the messages. Either 'ASC' or 'DESC'.
		 *                                 Defaults to 'ASC'.
		 * }
		 * @return array
		 */
		public static function get_messages($thread_id = 0, $args = array())
		{
		}
		/**
		 * Get latest thread message.
		 *
		 * @since 12.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param integer $thread_id The message thread ID.
		 * @return object|null
		 */
		public static function get_latest_thread_message($thread_id)
		{
		}
		/**
		 * Static method to get message recipients by thread ID.
		 *
		 * @since 2.3.0
		 *
		 * @param int $thread_id The thread ID.
		 * @return array
		 */
		public static function get_recipients_for_thread($thread_id = 0)
		{
		}
		/**
		 * Mark messages in a thread as deleted or delete all messages in a thread.
		 *
		 * Note: All messages in a thread are deleted once every recipient in a thread
		 * has marked the thread as deleted.
		 *
		 * @since 1.0.0
		 * @since 2.7.0 The $user_id parameter was added. Previously the current user
		 *              was always assumed.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $thread_id The message thread ID.
		 * @param int $user_id The ID of the user in the thread to mark messages as
		 *                     deleted for. Defaults to the current logged-in user.
		 *
		 * @return bool
		 */
		public static function delete($thread_id = 0, $user_id = 0)
		{
		}
		/**
		 * Exit a user from a thread.
		 *
		 * @since 10.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $thread_id The message thread ID.
		 * @param int $user_id The ID of the user in the thread.
		 *                     Defaults to the current logged-in user.
		 *
		 * @return bool
		 */
		public static function exit_thread($thread_id = 0, $user_id = 0)
		{
		}
		/**
		 * Get current message threads for a user.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *     Array of arguments.
		 *     @type int      $user_id             The user ID.
		 *     @type string   $box                 The type of mailbox to get. Either 'inbox' or 'sentbox'.
		 *                                         Defaults to 'inbox'.
		 *     @type string   $type                The type of messages to get. Either 'all' or 'unread'
		 *                                         or 'read'. Defaults to 'all'.
		 *     @type int      $limit               The number of messages to get. Defaults to null.
		 *     @type int      $page                The page number to get. Defaults to null.
		 *     @type string   $search_terms        The search term to use. Defaults to ''.
		 *     @type array    $meta_query          Meta query arguments. See WP_Meta_Query for more details.
		 *     @type int|null $recipients_page     Page of recipients being requested. Default to null, meaning all.
		 *     @type int|null $recipients_per_page Recipients to return per page. Defaults to null, meaning all.
		 *     @type int|null $messages_page       Page of messages being requested. Default to null, meaning all.
		 *     @type int|null $messages_per_page   Messages to return per page. Defaults to null, meaning all.
		 * }
		 * @return array|bool Array on success. False on failure.
		 */
		public static function get_current_threads_for_user($args = array())
		{
		}
		/**
		 * Get the SQL for the 'meta_query' param in BP_Messages_Thread::get_current_threads_for_user().
		 *
		 * We use WP_Meta_Query to do the heavy lifting of parsing the meta_query array
		 * and creating the necessary SQL clauses.
		 *
		 * @since 2.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $meta_query An array of meta_query filters. See the
		 *                          documentation for WP_Meta_Query for details.
		 * @return array $sql_array 'join' and 'where' clauses.
		 */
		public static function get_meta_query_sql($meta_query = array())
		{
		}
		/**
		 * Mark a thread as read.
		 *
		 * @since 1.0.0
		 * @since 9.0.0 Added the `user_id` parameter.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $thread_id The message thread ID.
		 * @param int $user_id   The user the thread will be marked as read.
		 *
		 * @return bool|int Number of threads marked as read or false on error.
		 */
		public static function mark_as_read($thread_id = 0, $user_id = 0)
		{
		}
		/**
		 * Mark a thread as unread.
		 *
		 * @since 1.0.0
		 * @since 9.0.0 Added the `user_id` parameter.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $thread_id The message thread ID.
		 * @param int $user_id   The user the thread will be marked as unread.
		 *
		 * @return bool|int Number of threads marked as unread or false on error.
		 */
		public static function mark_as_unread($thread_id = 0, $user_id = 0)
		{
		}
		/**
		 * Returns the total number of message threads for a user.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param int    $user_id The user ID.
		 * @param string $box     The type of mailbox to get. Either 'inbox' or 'sentbox'.
		 *                        Defaults to 'inbox'.
		 * @param string $type    The type of messages to get. Either 'all' or 'unread'.
		 *                        or 'read'. Defaults to 'all'.
		 * @return int Total thread count for the provided user.
		 */
		public static function get_total_threads_for_user($user_id, $box = 'inbox', $type = 'all')
		{
		}
		/**
		 * Returns the total number of messages in a thread.
		 *
		 * @since 12.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param integer $thread_id The message thread ID.
		 * @return integer Total thread message count
		 */
		public static function get_total_thread_message_count($thread_id)
		{
		}
		/**
		 * Determine if the logged-in user is a sender of any message in a thread.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $thread_id The message thread ID.
		 * @return bool
		 */
		public static function user_is_sender($thread_id)
		{
		}
		/**
		 * Returns the userlink of the last sender in a message thread.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $thread_id The message thread ID.
		 * @return string|bool The user link on success. Boolean false on failure.
		 */
		public static function get_last_sender($thread_id)
		{
		}
		/**
		 * Gets the unread message count for a user.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id The user ID.
		 * @return int Total inbox unread count for user.
		 */
		public static function get_inbox_count($user_id = 0)
		{
		}
		/**
		 * Checks whether a user is a part of a message thread discussion.
		 *
		 * @since 1.0.0
		 *
		 * @param int $thread_id The message thread ID.
		 * @param int $user_id   The user ID. Default: ID of the logged-in user.
		 * @return int|null The recorded recipient ID on success, null on failure.
		 */
		public static function check_access($thread_id, $user_id = 0)
		{
		}
		/**
		 * Checks whether a message thread exists.
		 *
		 * @since 1.0.0
		 *
		 * @param int $thread_id The message thread ID.
		 * @return bool|int|null The message thread ID on success, null on failure.
		 */
		public static function is_valid($thread_id = 0)
		{
		}
		/**
		 * Returns a string containing all the message recipient userlinks.
		 *
		 * String is comma-delimited.
		 *
		 * If a message thread has more than four users, the returned string is simply
		 * "X Recipients" where "X" is the number of recipients in the message thread.
		 *
		 * @since 1.0.0
		 *
		 * @param array $recipients Array containing the message recipients (array of objects).
		 * @return string String of message recipent userlinks.
		 */
		public static function get_recipient_links($recipients)
		{
		}
		/**
		 * Upgrade method for the older BP message thread DB table.
		 *
		 * @todo We should remove this. No one is going to upgrade from v1.1, right?
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public static function update_tables()
		{
		}
	}
	/**
	 * Message Thread Template Class
	 */
	class BP_Messages_Thread_Template
	{
		/**
		 * The loop iterator.
		 *
		 * @var int
		 */
		public $current_message = -1;
		/**
		 * Number of messages returned by the paged query.
		 *
		 * @var int
		 */
		public $message_count = 0;
		/**
		 * The message object currently being iterated on.
		 *
		 * @var object
		 */
		public $message;
		/**
		 * Thread that the current messages belong to.
		 *
		 * @var BP_Messages_Thread
		 */
		public $thread;
		/**
		 * A flag for whether the loop is currently being iterated.
		 *
		 * @var bool
		 */
		public $in_the_loop = \false;
		/**
		 * The page number being requested.
		 *
		 * @var int
		 */
		public $pag_page = 1;
		/**
		 * The number of items being requested per page.
		 *
		 * @var int
		 */
		public $pag_num = 10;
		/**
		 * An HTML string containing pagination links.
		 *
		 * @var string
		 */
		public $pag_links = '';
		/**
		 * The total number of messages matching the query.
		 *
		 * @var int
		 */
		public $total_message_count = 0;
		/**
		 * Constructor method.
		 *
		 * @see BP_Messages_Thread::populate() for full parameter info.
		 *
		 * @param int    $thread_id ID of the message thread to display.
		 * @param string $order     Optional. Order to show the thread's messages in.
		 *                          Default: 'ASC'.
		 * @param array  $args      Array of arguments for the query.
		 */
		public function __construct($thread_id = 0, $order = 'ASC', $args = array())
		{
		}
		/**
		 * Whether there are messages available in the loop.
		 *
		 * @see bp_thread_has_messages()
		 *
		 * @return bool True if there are items in the loop, otherwise false.
		 */
		public function has_messages()
		{
		}
		/**
		 * Set up the next message and iterate index.
		 *
		 * @return object The next message to iterate over.
		 */
		public function next_message()
		{
		}
		/**
		 * Rewind the messages and reset message index.
		 */
		public function rewind_messages()
		{
		}
		/**
		 * Whether there are messages left in the loop to iterate over.
		 *
		 * This method is used by {@link bp_thread_messages()} as part of the
		 * while loop that controls iteration inside the messages loop, eg:
		 *     while ( bp_thread_messages() ) { ...
		 *
		 * @see bp_thread_messages()
		 *
		 * @return bool True if there are more messages to show, otherwise false.
		 */
		public function messages()
		{
		}
		/**
		 * Set up the current message inside the loop.
		 *
		 * Used by {@link bp_thread_the_message()} to set up the current
		 * message data while looping, so that template tags used during
		 * that iteration make reference to the current message.
		 *
		 * @see bp_thread_the_message()
		 */
		public function the_message()
		{
		}
	}
	/**
	 * BuddyPress Notices List Table class.
	 */
	class BP_Messages_Notices_List_Table extends \WP_List_Table
	{
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 *
		 * @param array $args Arguments passed to the WP_List_Table::constructor.
		 */
		public function __construct($args = array())
		{
		}
		/**
		 * Checks the current user's permissions
		 *
		 * @since 3.0.0
		 */
		public function ajax_user_can()
		{
		}
		/**
		 * Set up items for display in the list table.
		 *
		 * Handles filtering of data, sorting, pagination, and any other data
		 * manipulation required prior to rendering.
		 *
		 * @since 3.0.0
		 */
		public function prepare_items()
		{
		}
		/**
		 * Get a list of columns. The format is:
		 * 'internal-name' => 'Title'
		 *
		 * @since 3.0.0
		 *
		 * @return array
		 */
		public function get_columns()
		{
		}
		/**
		 * Generates content for a single row of the table
		 *
		 * @since 3.0.0
		 *
		 * @param object $item The current item
		 */
		public function single_row($item)
		{
		}
		/**
		 * Generates content for the "subject" column.
		 *
		 * @since 3.0.0
		 *
		 * @param object $item The current item
		 */
		public function column_subject($item)
		{
		}
		/**
		 * Generates content for the "message" column.
		 *
		 * @since 3.0.0
		 *
		 * @param object $item The current item
		 */
		public function column_message($item)
		{
		}
		/**
		 * Generates content for the "date_sent" column.
		 *
		 * @since 3.0.0
		 *
		 * @param object $item The current item
		 */
		public function column_date_sent($item)
		{
		}
	}
	/**
	 * Implementation of BP_Component for the Messages component.
	 *
	 * @since 1.5.0
	 */
	#[\AllowDynamicProperties]
	class BP_Messages_Component extends \BP_Component
	{
		/**
		 * If this is true, the Message autocomplete will return friends only, unless
		 * this is set to false, in which any matching users will be returned.
		 *
		 * @since 1.5.0
		 * @var bool
		 */
		public $autocomplete_all;
		/**
		 * Start the messages component creation process.
		 *
		 * @since 1.5.0
		 */
		public function __construct()
		{
		}
		/**
		 * Include files.
		 *
		 * @since 1.5.0
		 *
		 * @param array $includes See {BP_Component::includes()} for details.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Only load up certain code when on specific pages.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Set up globals for the Messages component.
		 *
		 * The BP_MESSAGES_SLUG constant is deprecated.
		 *
		 * @since 1.5.0
		 *
		 * @param array $args Not used.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @param array $main_nav See `BP_Component::register_nav()` for details.
		 * @param array $sub_nav  See `BP_Component::register_nav()` for details.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up component navigation.
		 *
		 * @since 1.5.0
		 * @since 12.0.0 Used to customize the main navigation name.
		 *
		 * @see `BP_Component::setup_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 */
		public function setup_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up the Toolbar.
		 *
		 * @param array $wp_admin_nav See {BP_Component::setup_admin_bar()} for details.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Set up the title for pages and <title>.
		 */
		public function setup_title()
		{
		}
		/**
		 * Setup cache groups
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Init the BP REST API.
		 *
		 * @since 5.0.0
		 *
		 * @param array $controllers Optional. See BP_Component::rest_api_init() for
		 *                           description.
		 */
		public function rest_api_init($controllers = array())
		{
		}
		/**
		 * Register the BP Messages Blocks.
		 *
		 * @since 9.0.0
		 * @since 12.0.0 Use the WP Blocks API v2.
		 *
		 * @param array $blocks Optional. See BP_Component::blocks_init() for
		 *                      description.
		 */
		public function blocks_init($blocks = array())
		{
		}
	}
	/**
	 * Single message class.
	 */
	#[\AllowDynamicProperties]
	class BP_Messages_Message
	{
		/**
		 * ID of the message.
		 *
		 * @var int
		 */
		public $id;
		/**
		 * ID of the message thread.
		 *
		 * @var int
		 */
		public $thread_id;
		/**
		 * ID of the sender.
		 *
		 * @var int
		 */
		public $sender_id;
		/**
		 * Subject line of the message.
		 *
		 * @var string
		 */
		public $subject;
		/**
		 * Content of the message.
		 *
		 * @var string
		 */
		public $message;
		/**
		 * Date the message was sent.
		 *
		 * @var string
		 */
		public $date_sent;
		/**
		 * Message recipients.
		 *
		 * @var array
		 */
		public $recipients = array();
		/**
		 * Constructor.
		 *
		 * @param int|null $id Optional. ID of the message.
		 */
		public function __construct($id = \null)
		{
		}
		/**
		 * Set up data related to a specific message object.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $id ID of the message.
		 */
		public function populate($id)
		{
		}
		/**
		 * Send a message.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return int|bool ID of the newly created message on success, false on failure.
		 */
		public function send()
		{
		}
		/**
		 * Get a list of recipients for a message.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return object $value List of recipients for a message.
		 */
		public function get_recipients()
		{
		}
		/** Static Functions **************************************************/
		/**
		 * Get list of recipient IDs from their usernames.
		 *
		 * @param array $recipient_usernames Usernames of recipients.
		 *
		 * @return bool|array $recipient_ids Array of Recepient IDs.
		 */
		public static function get_recipient_ids($recipient_usernames)
		{
		}
		/**
		 * Get the ID of the message last sent by the logged-in user for a given thread.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $thread_id ID of the thread.
		 *
		 * @return int|null ID of the message if found, otherwise null.
		 */
		public static function get_last_sent_for_user($thread_id)
		{
		}
		/**
		 * Check whether a user is the sender of a message.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id ID of the user.
		 * @param int $message_id ID of the message.
		 *
		 * @return int|null Returns the ID of the message if the user is the
		 *                  sender, otherwise null.
		 */
		public static function is_user_sender($user_id, $message_id)
		{
		}
		/**
		 * Get the ID of the sender of a message.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $message_id ID of the message.
		 *
		 * @return int|null The ID of the sender if found, otherwise null.
		 */
		public static function get_message_sender($message_id)
		{
		}
	}
	/**
	 * Sitewide Notices endpoints.
	 *
	 * @since 9.0.0
	 */
	class BP_REST_Sitewide_Notices_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 9.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 9.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve sitewide notices.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request is allowed to get notices.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_Error|bool
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Get a single notice by ID.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request is allowed to get a sitewide notice.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_Error|bool
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Create a sitewide notice.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Check if a given request has access to create a notice.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_Error|bool
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Update a notice.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to update a notice.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_Error|bool
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Dismisses the currently active notice for the current user.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function dismiss_notice($request)
		{
		}
		/**
		 * Check if a given request has access to dismiss the current notice.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_Error|bool
		 */
		public function dismiss_notice_permissions_check($request)
		{
		}
		/**
		 * Delete a sitewide notice.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to generally manage a notice.
		 * Granular filters are provided in the edit_, create_, and delete_
		 * permissions checks.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_Error|bool
		 */
		public function manage_item_permissions_check($request)
		{
		}
		/**
		 * Check if a given request has access to delete a notice.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_Error|bool
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 9.0.0
		 *
		 * @param BP_Messages_Notice $notice Notice object.
		 * @return array
		 */
		protected function prepare_links($notice)
		{
		}
		/**
		 * Prepares sitewide notice data for return as an object.
		 *
		 * @since 9.0.0
		 *
		 * @param BP_Messages_Notice $notice  The notice object.
		 * @param WP_REST_Request    $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($notice, $request)
		{
		}
		/**
		 * Get sitewide notice object.
		 *
		 * @since 9.0.0
		 *
		 * @param int $id Notice ID.
		 * @return BP_Messages_Notice
		 */
		public function get_notice_object($id)
		{
		}
		/**
		 * Select the item schema arguments needed for the CREATABLE, EDITABLE and DELETABLE methods.
		 *
		 * @since 9.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the message schema, conforming to JSON Schema.
		 *
		 * @since 9.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for sitewide notices collections.
		 *
		 * @since 9.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
		/**
		 * Prepare a notice for creation or update.
		 *
		 * @since 9.0.0
		 *
		 * @param WP_REST_Request $request Request object.
		 * @return BP_Messages_Notice|WP_Error Object or WP_Error.
		 */
		protected function prepare_item_for_database($request)
		{
		}
	}
	/**
	 * Message Box Template Class
	 */
	#[\AllowDynamicProperties]
	class BP_Messages_Box_Template
	{
		/**
		 * The loop iterator.
		 *
		 * @var int
		 */
		public $current_thread = -1;
		/**
		 * The number of threads returned by the paged query.
		 *
		 * @var int
		 */
		public $current_thread_count = 0;
		/**
		 * Total number of threads matching the query params.
		 *
		 * @var int
		 */
		public $total_thread_count = 0;
		/**
		 * Total number of threads available to iterate on.
		 *
		 * @var int
		 */
		public $thread_count = 0;
		/**
		 * Array of threads located by the query.
		 *
		 * @var array
		 */
		public $threads = array();
		/**
		 * The thread object currently being iterated on.
		 *
		 * @var BP_Messages_Thread|bool
		 */
		public $thread = \false;
		/**
		 * A flag for whether the loop is currently being iterated.
		 *
		 * @var bool
		 */
		public $in_the_loop = \false;
		/**
		 * User ID of the current inbox.
		 *
		 * @var int
		 */
		public $user_id = 0;
		/**
		 * The current "box" view ('notices', 'sentbox', 'inbox').
		 *
		 * @var string
		 */
		public $box = 'inbox';
		/**
		 * The page number being requested.
		 *
		 * @var int
		 */
		public $pag_page = 1;
		/**
		 * The number of items (threads) being requested per page.
		 *
		 * @var int
		 */
		public $pag_num = 10;
		/**
		 * An HTML string containing pagination links.
		 *
		 * @var string
		 */
		public $pag_links = '';
		/**
		 * URL argument used for the pagination param.
		 *
		 * @var string
		 */
		public $pag_arg = '';
		/**
		 * Search terms for limiting the thread query.
		 *
		 * @var string
		 */
		public $search_terms = '';
		/**
		 * Type of messages to return. Values: 'all', 'read', 'unread'.
		 *
		 * @var string
		 */
		public $type = '';
		/**
		 * Constructor method.
		 *
		 * @param array $args {
		 *     Array of arguments. See bp_has_message_threads() for full description.
		 * }.
		 */
		public function __construct($args = array())
		{
		}
		/**
		 * Whether there are threads available in the loop.
		 *
		 * @see bp_has_message_threads()
		 *
		 * @return bool True if there are items in the loop, otherwise false.
		 */
		public function has_threads()
		{
		}
		/**
		 * Set up the next member and iterate index.
		 *
		 * @return BP_Messages_Thread The next member to iterate over.
		 */
		public function next_thread()
		{
		}
		/**
		 * Rewind the threads and reset thread index.
		 */
		public function rewind_threads()
		{
		}
		/**
		 * Whether there are threads left in the loop to iterate over.
		 *
		 * This method is used by {@link bp_message_threads()} as part of the
		 * while loop that controls iteration inside the threads loop, eg:
		 *     while ( bp_message_threads() ) { ...
		 *
		 * @see bp_message_threads()
		 *
		 * @return bool True if there are more threads to show, otherwise false.
		 */
		public function message_threads()
		{
		}
		/**
		 * Set up the current thread inside the loop.
		 *
		 * Used by {@link bp_message_thread()} to set up the current thread data
		 * while looping, so that template tags used during that iteration make
		 * reference to the current thread.
		 *
		 * @see bp_message_thread()
		 */
		public function the_message_thread()
		{
		}
	}
	/**
	 * Theme Compatibility base class.
	 *
	 * This is only intended to be extended, and is included here as a basic guide
	 * for future Theme Packs to use. {@link BP_Legacy} is a good example of
	 * extending this class.
	 *
	 * @since 1.7.0
	 *
	 * @todo We should probably do something similar to BP_Component::start().
	 * @todo If this is only intended to be extended, it should be abstract.
	 *
	 * @param array $properties {
	 *     An array of properties describing the theme compat package.
	 *     @type string $id      ID of the package. Must be unique.
	 *     @type string $name    Name of the theme. This should match the name given
	 *                           in style.css.
	 *     @type string $version Theme version. Used for busting script and style
	 *                           browser caches.
	 *     @type string $dir     Filesystem path of the theme.
	 *     @type string $url     Base URL of the theme.
	 * }
	 */
	class BP_Theme_Compat
	{
		/**
		 * Template package properties, as passed to the constructor.
		 *
		 * @since 1.7.0
		 *
		 * @var array
		 */
		protected $_data = array();
		/**
		 * Pass the $properties to the object on creation.
		 *
		 * @since 1.7.0
		 *
		 * @param array $properties Array of properties for BP_Theme_Compat.
		 */
		public function __construct(array $properties = array())
		{
		}
		/**
		 * Set up the BuddyPress-specific theme compat methods.
		 *
		 * Themes should use this method in their constructor.
		 *
		 * @since 1.7.0
		 */
		protected function start()
		{
		}
		/**
		 * Set up global data for your template package.
		 *
		 * Meant to be overridden in your class. See
		 * {@link BP_Legacy::setup_globals()} for an example.
		 *
		 * @since 1.7.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Set up theme hooks for your template package.
		 *
		 * Meant to be overridden in your class. See
		 * {@link BP_Legacy::setup_actions()} for an example.
		 *
		 * @since 1.7.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Set a theme's property.
		 *
		 * @since 1.7.0
		 *
		 * @param string $property Property name.
		 * @param mixed  $value    Property value.
		 * @return bool
		 */
		public function __set($property, $value)
		{
		}
		/**
		 * Get a theme's property.
		 *
		 * @since 1.7.0
		 *
		 * @param string $property Property name.
		 * @return mixed The value of the property if it exists, otherwise an
		 *               empty string.
		 */
		public function __get($property)
		{
		}
		/**
		 * Check a theme's property exists.
		 *
		 * @since 9.0.0
		 *
		 * @param string $property Property name.
		 * @return bool True if the property exists. False otherwise.
		 */
		public function __isset($property)
		{
		}
	}
	/**
	 * Loads BuddyPress Legacy Theme functionality.
	 *
	 * This is not a real theme by WordPress standards, and is instead used as the
	 * fallback for any WordPress theme that does not have BuddyPress templates in it.
	 *
	 * To make your custom theme BuddyPress compatible and customize the templates, you
	 * can copy these files into your theme without needing to merge anything
	 * together; BuddyPress should safely handle the rest.
	 *
	 * See @link BP_Theme_Compat() for more.
	 *
	 * @since 1.7.0
	 *
	 * @package BuddyPress
	 * @subpackage BP_Theme_Compat
	 */
	class BP_Legacy extends \BP_Theme_Compat
	{
		/** Functions *************************************************************/
		/**
		 * The main BuddyPress (Legacy) Loader.
		 *
		 * @since 1.7.0
		 *
		 */
		public function __construct()
		{
		}
		/**
		 * Component global variables.
		 *
		 * You'll want to customize the values in here, so they match whatever your
		 * needs are.
		 *
		 * @since 1.7.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Setup the theme hooks.
		 *
		 * @since 1.7.0
		 *
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Load the theme CSS
		 *
		 * @since 1.7.0
		 * @since 2.3.0 Support custom CSS file named after the current theme or parent theme.
		 *
		 */
		public function enqueue_styles()
		{
		}
		/**
		 * Enqueue the required JavaScript files
		 *
		 * @since 1.7.0
		 */
		public function enqueue_scripts()
		{
		}
		/**
		 * Get the URL and handle of a web-accessible CSS or JS asset
		 *
		 * We provide two levels of customizability with respect to where CSS
		 * and JS files can be stored: (1) the child theme/parent theme/theme
		 * compat hierarchy, and (2) the "template stack" of /buddypress/css/,
		 * /community/css/, and /css/. In this way, CSS and JS assets can be
		 * overloaded, and default versions provided, in exactly the same way
		 * as corresponding PHP templates.
		 *
		 * We are duplicating some of the logic that is currently found in
		 * bp_locate_template() and the _template_stack() functions. Those
		 * functions were built with PHP templates in mind, and will require
		 * refactoring in order to provide "stack" functionality for assets
		 * that must be accessible both using file_exists() (the file path)
		 * and at a public URI.
		 *
		 * This method is marked private, with the understanding that the
		 * implementation is subject to change or removal in an upcoming
		 * release, in favor of a unified _template_stack() system. Plugin
		 * and theme authors should not attempt to use what follows.
		 *
		 * @since 1.8.0
		 * @param string $file A filename like buddypress.css.
		 * @param string $type Optional. Either "js" or "css" (the default).
		 * @param string $script_handle Optional. If set, used as the script name in `wp_enqueue_script`.
		 * @return array An array of data for the wp_enqueue_* function:
		 *   'handle' (eg 'bp-child-css') and a 'location' (the URI of the
		 *   asset)
		 */
		private function locate_asset_in_stack($file, $type = 'css', $script_handle = '')
		{
		}
		/**
		 * Adds the no-js class to the body tag.
		 *
		 * This function ensures that the <body> element will have the 'no-js' class by default. If you're
		 * using JavaScript for some visual functionality in your theme, and you want to provide noscript
		 * support, apply those styles to body.no-js.
		 *
		 * The no-js class is removed by the JavaScript created in buddypress.js.
		 *
		 * @since 1.7.0
		 *
		 * @param array $classes Array of classes to append to body tag.
		 * @return array $classes
		 */
		public function add_nojs_body_class($classes)
		{
		}
		/**
		 * Load localizations for topic script.
		 *
		 * These localizations require information that may not be loaded even by init.
		 *
		 * @since 1.7.0
		 */
		public function localize_scripts()
		{
		}
		/**
		 * Outputs sitewide notices markup in the footer.
		 *
		 * @since 1.7.0
		 *
		 * @see https://buddypress.trac.wordpress.org/ticket/4802
		 */
		public function sitewide_notices()
		{
		}
		/**
		 * Add secondary avatar image to this activity stream's record, if supported.
		 *
		 * @since 1.7.0
		 *
		 * @param string               $action   The text of this activity.
		 * @param BP_Activity_Activity $activity Activity object.
		 * @return string
		 */
		function secondary_avatars($action, $activity)
		{
		}
		/**
		 * Filter the default theme compatibility root template hierarchy, and prepend
		 * a page template to the front if it's set.
		 *
		 * @see https://buddypress.trac.wordpress.org/ticket/6065
		 *
		 * @since 2.2.0
		 *
		 * @param  array $templates Array of templates.
		 *                         to use the defined page template for component's directory and its single items
		 * @return array
		 */
		public function theme_compat_page_templates($templates = array())
		{
		}
	}
	/**
	 * Blogs Loader class
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Nouveau_Blogs
	{
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Globals
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Include needed files
		 *
		 * @since 3.0.0
		 */
		protected function includes()
		{
		}
		/**
		 * Register do_action() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Register add_filter() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_filters()
		{
		}
	}
	/**
	 * Messages Loader class
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Nouveau_Messages
	{
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Globals
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Include needed files
		 *
		 * @since 3.0.0
		 */
		protected function includes()
		{
		}
		/**
		 * Register do_action() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Register add_filter() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_filters()
		{
		}
	}
	/**
	 * Builds a group of BP_Button
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Buttons_Group
	{
		/**
		 * The parameters of the Group of buttons
		 *
		 * @var array
		 */
		protected $group = array();
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 *
		 * @param array $args Optional array having the following parameters {
		 *     @type string $id                A string to use as the unique ID for the button. Required.
		 *     @type int    $position          Where to insert the Button. Defaults to 99.
		 *     @type string $component         The Component's the button is build for (eg: Activity, Groups..). Required.
		 *     @type bool   $must_be_logged_in Whether the button should only be displayed to logged in users. Defaults to True.
		 *     @type bool   $block_self        Optional. True if the button should be hidden when a user is viewing his own profile.
		 *                                     Defaults to False.
		 *     @type string $parent_element    Whether to use a wrapper. Defaults to false.
		 *     @type string $parent_attr       set an array of attributes for the parent element.
		 *     @type string $button_element    Set this to 'button', 'img', or 'a', defaults to anchor.
		 *     @type string $button_attr       Any attributes required for the button_element
		 *     @type string $link_text         The text of the link. Required.
		 * }
		 */
		public function __construct($args = array())
		{
		}
		/**
		 * Sort the Buttons of the group according to their position attribute
		 *
		 * @since 3.0.0
		 *
		 * @param array the list of buttons to sort.
		 *
		 * @return array the list of buttons sorted.
		 */
		public function sort($buttons)
		{
		}
		/**
		 * Get the BuddyPress buttons for the group
		 *
		 * @since 3.0.0
		 *
		 * @param bool $sort whether to sort the buttons or not.
		 *
		 * @return array An array of HTML links.
		 */
		public function get($sort = \true)
		{
		}
		/**
		 * Update the group of buttons
		 *
		 * @since 3.0.0
		 *
		 * @param array $args Optional. See the __constructor for a description of this argument.
		 */
		public function update($args = array())
		{
		}
		/**
		 * Adds a button.
		 *
		 * @since 9.0.0
		 *
		 * @param array $args Required. See the __constructor for a description of this argument.
		 * @return bool
		 */
		private function add($args)
		{
		}
	}
	/**
	 * Activity Loader class
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Nouveau_Activity
	{
		/**
		 * Nouveau Activity directory.
		 *
		 * @since 3.0.0
		 * @var string
		 */
		public $dir = '';
		/**
		 * RSS feed link data.
		 *
		 * @since 3.0.0
		 * @var string
		 */
		public $current_rss_feed = array();
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Globals
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Include needed files
		 *
		 * @since 3.0.0
		 */
		protected function includes()
		{
		}
		/**
		 * Register do_action() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Register add_filter() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_filters()
		{
		}
	}
	/**
	 * Groups Loader class
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Nouveau_Groups
	{
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Globals
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Include needed files
		 *
		 * @since 3.0.0
		 */
		protected function includes()
		{
		}
		/**
		 * Register do_action() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Register add_filter() hooks
		 *
		 * @since 3.0.0
		 * @since 6.0.0 Removes the BP Core number formatting filter on total groups count.
		 */
		protected function setup_filters()
		{
		}
		/**
		 * Add filters to be sure the (BuddyPress) widgets display will be consistent
		 * with the current group's default front page.
		 *
		 * @since 3.0.0
		 *
		 * @param string $sidebar_index The Sidebar identifier.
		 */
		public function group_home_sidebar_set($sidebar_index = '')
		{
		}
		/**
		 * Remove filters to be sure the (BuddyPress) widgets display will no more take
		 * the current group displayed in account.
		 *
		 * @since 3.0.0
		 *
		 * @param string $sidebar_index The Sidebar identifier.
		 */
		public function group_home_sidebar_unset($sidebar_index = '')
		{
		}
	}
	/**
	 * Query to get members that are not already members of the group
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Nouveau_Group_Invite_Query extends \BP_User_Query
	{
		/**
		 * Array of group member ids, cached to prevent redundant lookups
		 *
		 * @var null|array Null if not yet defined, otherwise an array of ints
		 * @since 3.0.0
		 */
		protected $group_member_ids;
		/**
		 * Set up action hooks
		 *
		 * @since 3.0.0
		 */
		public function setup_hooks()
		{
		}
		/**
		 * Exclude group members from the user query as it's not needed to invite members to join the group.
		 *
		 * @since 3.0.0
		 */
		public function build_exclude_args()
		{
		}
		/**
		 * Get the members of the queried group
		 *
		 * @since 3.0.0
		 *
		 * @return array $ids User IDs of relevant group member ids
		 */
		protected function get_group_member_ids()
		{
		}
		/**
		 * Build the Meta Query to get all members list.
		 *
		 * @since 3.0.0
		 *
		 * @param BP_User_Query $bp_user_query The User Query object.
		 */
		public function build_meta_query(\BP_User_Query $bp_user_query)
		{
		}
		/**
		 * Get the list of group invites.
		 *
		 * @since 3.0.0
		 *
		 * @param integer $user_id  The User ID.
		 * @param integer $group_id The Group ID.
		 * @return array            Matching BP_Invitation objects.
		 */
		public static function get_inviter_ids($user_id = 0, $group_id = 0)
		{
		}
	}
	/**
	 * BuddyPress Nav.
	 *
	 * This class is used to build each component's navigation.
	 *
	 * @since 2.6.0
	 */
	class BP_Core_Nav
	{
		/**
		 * An associative array containing the nav items for the object ID.
		 *
		 * @since 2.6.0
		 *
		 * @var array
		 */
		protected $nav;
		/**
		 * The current object ID.
		 *
		 * @since 2.6.0
		 *
		 * @var int
		 */
		private $object_id;
		/**
		 * The component ID.
		 *
		 * @since 12.0.0
		 *
		 * @var string
		 */
		private $component_id;
		/**
		 * Initializes the Nav belonging to the specified object.
		 *
		 * @since 2.6.0
		 *
		 * @param int    $object_id The item ID to build the nav for. Default is the displayed user ID.
		 * @param string $component_id Optional. The component ID. Default is 'members'.
		 */
		public function __construct($object_id = 0, $component_id = 'members')
		{
		}
		/**
		 * Checks whether a nav item is set.
		 *
		 * @since 2.6.0
		 *
		 * @param string $key The requested nav slug.
		 * @return bool True if the nav item is set, false otherwise.
		 */
		public function __isset($key)
		{
		}
		/**
		 * Gets a nav item.
		 *
		 * @since 2.6.0
		 *
		 * @param string $key The requested nav slug.
		 * @return mixed The value corresponding to the requested nav item.
		 */
		public function __get($key)
		{
		}
		/**
		 * Sets a nav item.
		 *
		 * @since 2.6.0
		 *
		 * @param string $key   The requested nav slug.
		 * @param mixed  $value The value of the nav item.
		 */
		public function __set($key, $value)
		{
		}
		/**
		 * Gets a specific nav item or array of nav items.
		 *
		 * @since 2.6.0
		 *
		 * @param string $key The nav item slug to get. Optional.
		 * @return mixed An array of nav item, a single nav item, or null if none found.
		 */
		public function get($key = '')
		{
		}
		/**
		 * Adds a new nav item.
		 *
		 * @since 2.6.0
		 *
		 * @param array $args The nav item's arguments.
		 * @return BP_Core_Nav_Item
		 */
		public function add_nav($args)
		{
		}
		/**
		 * Edits a nav item.
		 *
		 * @since 2.6.0
		 *
		 * @param array  $args        The nav item's arguments.
		 * @param string $slug        The slug of the nav item.
		 * @param string $parent_slug The slug of the parent nav item (required to edit a child).
		 * @return BP_Core_Nav_Item
		 */
		public function edit_nav($args = array(), $slug = '', $parent_slug = '')
		{
		}
		/**
		 * Unset an item or a subitem of the nav.
		 *
		 * @since 2.6.0
		 *
		 * @param string $slug        The slug of the main item.
		 * @param string $parent_slug The slug of the sub item.
		 * @return false|callable|array False on failure, the screen function(s) on success.
		 */
		public function delete_nav($slug = '', $parent_slug = '')
		{
		}
		/**
		 * Sorts a list of nav items.
		 *
		 * @since 2.6.0
		 *
		 * @param array $items The nav items to sort.
		 * @return array
		 */
		public function sort_nav($items)
		{
		}
		/**
		 * Gets the primary nav items.
		 *
		 * @since 2.6.0
		 *
		 * @param array $args Filters to select the specific primary items. See wp_list_filter().
		 * @param bool  $sort True to sort the nav items. False otherwise.
		 * @return array The list of primary objects nav
		 */
		public function get_primary($args = array(), $sort = \true)
		{
		}
		/**
		 * Gets the secondary nav items.
		 *
		 * @since 2.6.0
		 *
		 * @param array $args Filters to select the specific secondary items. See wp_list_filter().
		 * @param bool  $sort True to sort the nav items. False otherwise.
		 * @return bool|array The list of secondary objects nav, or false if none set.
		 */
		public function get_secondary($args = array(), $sort = \true)
		{
		}
		/**
		 * Gets a nested list of visible nav items.
		 *
		 * @since 2.6.0
		 *
		 * @return array The list of visible nav items.
		 */
		public function get_item_nav()
		{
		}
	}
	/**
	 * A specific Group Nav class to make it possible to set new positions for
	 * buddypress()->groups->nav.
	 *
	 * @since 3.0.0
	 */
	class BP_Nouveau_Customizer_Group_Nav extends \BP_Core_Nav
	{
		/**
		 * The group being requested.
		 *
		 * @since 3.0.0
		 * @var BP_Groups_Group
		 */
		public $group = \null;
		/**
		 * Constructor
		 *
		 * @param int $object_id Optional. The random group ID used to generate the nav.
		 */
		public function __construct($object_id = 0)
		{
		}
		/**
		 * Checks whether a property is set.
		 *
		 * Overrides BP_Core_Nav::__isset() to avoid looking into its nav property.
		 *
		 * @since 3.0.0
		 *
		 * @param string $key The property.
		 *
		 * @return bool True if the property is set, false otherwise.
		 */
		public function __isset($key)
		{
		}
		/**
		 * Gets a property.
		 *
		 * Overrides BP_Core_Nav::__isset() to avoid looking into its nav property.
		 *
		 * @since 3.0.0
		 *
		 * @param string $key The property.
		 *
		 * @return mixed The value corresponding to the property.
		 */
		public function __get($key)
		{
		}
		/**
		 * Sets a property.
		 *
		 * Overrides BP_Core_Nav::__isset() to avoid adding a value to its nav property.
		 *
		 * @since 3.0.0
		 *
		 * @param string $key The property.
		 *
		 * @param mixed $value The value of the property.
		 */
		public function __set($key, $value)
		{
		}
		/**
		 * Setup a temporary nav with only the needed parameters.
		 *
		 * @since 3.0.0
		 */
		protected function setup_nav()
		{
		}
		/**
		 * Front template: do not look into group's template hierarchy.
		 *
		 * @since 3.0.0
		 *
		 * @param array $templates The list of possible group front templates.
		 *
		 * @return array The list of "global" group front templates.
		 */
		public function all_groups_fronts($templates = array())
		{
		}
		/**
		 * Get the original order for the group navigation.
		 *
		 * @since 3.0.0
		 *
		 * @return array a list of nav items slugs ordered.
		 */
		public function get_default_value()
		{
		}
		/**
		 * Get the list of nav items ordered according to the Site owner preferences.
		 *
		 * @since 3.0.0
		 *
		 * @return array the nav items ordered.
		 */
		public function get_group_nav()
		{
		}
	}
	/**
	 * Group template meta backwards compatibility class.
	 *
	 * @since 7.0.0
	 */
	class BP_Nouveau_Group_Meta
	{
		/**
		 * Used to get the template meta used in Groups loop.
		 *
		 * @since 7.0.0
		 * @var string $meta The template meta used in Groups loop.
		 */
		public $meta = '';
		/**
		 * Magic getter.
		 *
		 * This exists specifically for supporting deprecated object vars.
		 *
		 * @since 7.0.0
		 *
		 * @param string $key
		 * @return string
		 */
		public function __get($key = '')
		{
		}
		/**
		 * Constructor
		 *
		 * @since 7.0.0
		 */
		public function __construct()
		{
		}
	}
	/**
	 * This control let users change the order of the BuddyPress
	 * single items navigation items.
	 *
	 * NB: this is a first pass to improve by using Javascript templating as explained here:
	 * https://developer.wordpress.org/themes/advanced-topics/customizer-api/#putting-the-pieces-together
	 *
	 * @since 3.0.0
	 */
	class BP_Nouveau_Nav_Customize_Control extends \WP_Customize_Control
	{
		/**
		 * @var string
		 */
		public $type = '';
		/**
		 * Render the control's content.
		 *
		 * @since 3.0.0
		 */
		public function render_content()
		{
		}
	}
	/**
	 * Members Loader class
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Nouveau_Members
	{
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Globals
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Include needed files
		 *
		 * @since 3.0.0
		 */
		protected function includes()
		{
		}
		/**
		 * Register do_action() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Register add_filter() hooks
		 *
		 * @since 3.0.0
		 * @since 6.0.0 Removes the BP Core number formatting filter on total members count.
		 */
		protected function setup_filters()
		{
		}
		/**
		 * Add filters to be sure the (BuddyPress) widgets display will be consistent
		 * with the displayed user's default front page.
		 *
		 * @since 3.0.0
		 *
		 * @param string $sidebar_index The Sidebar identifier.
		 */
		public function user_home_sidebar_set($sidebar_index = '')
		{
		}
		/**
		 * Remove filters to be sure the (BuddyPress) widgets display will no more take
		 * the displayed user in account.
		 *
		 * @since 3.0.0
		 *
		 * @param  string $sidebar_index The Sidebar identifier.
		 */
		public function user_home_sidebar_unset($sidebar_index = '')
		{
		}
	}
	/**
	 * xProfile Loader class
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Nouveau_xProfile
	{
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Globals
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Include needed files
		 *
		 * @since 3.0.0
		 */
		protected function includes()
		{
		}
		/**
		 * Register do_action() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Register add_filter() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_filters()
		{
		}
	}
	/**
	 * Friends Loader class
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Nouveau_Friends
	{
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Globals
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Include needed files
		 *
		 * @since 3.0.0
		 */
		protected function includes()
		{
		}
		/**
		 * Register do_action() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Register add_filter() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_filters()
		{
		}
		/**
		 * Register notifications filters for the friends component.
		 *
		 * @since 3.0.0
		 */
		public function notification_filters()
		{
		}
		/**
		 * Register Friends Ajax actions.
		 *
		 * @since 12.0.0
		 */
		public function register_ajax_actions()
		{
		}
	}
	/**
	 * Notifications Loader class
	 *
	 * @since 3.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Nouveau_Notifications
	{
		/**
		 * Constructor
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Globals
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Include needed files
		 *
		 * @since 3.0.0
		 */
		protected function includes()
		{
		}
		/**
		 * Register do_action() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Register add_filter() hooks
		 *
		 * @since 3.0.0
		 */
		protected function setup_filters()
		{
		}
	}
	/** Theme Setup ***************************************************************/
	/**
	 * Loads BuddyPress Nouveau Template pack functionality.
	 *
	 * See @link BP_Theme_Compat() for more.
	 *
	 * @since 3.0.0
	 */
	class BP_Nouveau extends \BP_Theme_Compat
	{
		/**
		 * Instance of this class.
		 *
		 * @var BP_Nouveau|null
		 */
		protected static $instance = \null;
		/**
		 * Return the instance of this class.
		 *
		 * @since 3.0.0
		 *
		 * @return BP_Nouveau
		 */
		public static function get_instance()
		{
		}
		/**
		 * The BP Nouveau constructor.
		 *
		 * @since 3.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * BP Nouveau global variables.
		 *
		 * @since 3.0.0
		 */
		protected function setup_globals()
		{
		}
		/**
		 * Includes!
		 *
		 * @since 3.0.0
		 */
		protected function includes()
		{
		}
		/**
		 * Setup the Template Pack features support.
		 *
		 * @since 3.0.0
		 */
		protected function setup_support()
		{
		}
		/**
		 * Setup the Template Pack common actions.
		 *
		 * @since 3.0.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Enqueue the template pack css files
		 *
		 * @since 3.0.0
		 */
		public function enqueue_styles()
		{
		}
		/**
		 * Register Template Pack JavaScript files
		 *
		 * @since 3.0.0
		 */
		public function register_scripts()
		{
		}
		/**
		 * Enqueue the required JavaScript files
		 *
		 * @since 3.0.0
		 */
		public function enqueue_scripts()
		{
		}
		/**
		 * Adds the no-js class to the body tag.
		 *
		 * This function ensures that the <body> element will have the 'no-js' class by default. If you're
		 * using JavaScript for some visual functionality in your theme, and you want to provide noscript
		 * support, apply those styles to body.no-js.
		 *
		 * The no-js class is removed by the JavaScript created in buddypress.js.
		 *
		 * @since 3.0.0
		 *
		 * @param array $classes Array of classes to append to body tag.
		 *
		 * @return array $classes
		 */
		public function add_nojs_body_class($classes)
		{
		}
		/**
		 * Load localizations for topic script.
		 *
		 * These localizations require information that may not be loaded even by init.
		 *
		 * @since 3.0.0
		 */
		public function localize_scripts()
		{
		}
		/**
		 * Filter the default theme compatibility root template hierarchy, and prepend
		 * a page template to the front if it's set.
		 *
		 * @see https://buddypress.trac.wordpress.org/ticket/6065
		 *
		 * @since 3.0.0
		 *
		 * @param array $templates Array of templates.
		 *
		 * @return array
		 */
		public function theme_compat_page_templates($templates = array())
		{
		}
		/**
		 * Add our special 'buddypress' div wrapper to the theme compat template part.
		 *
		 * @since 3.0.0
		 *
		 * @see bp_buffer_template_part()
		 *
		 * @param string $retval Current template part contents.
		 *
		 * @return string
		 */
		public function theme_compat_wrapper($retval)
		{
		}
		/**
		 * Define the directory nav items
		 *
		 * @since 3.0.0
		 */
		public function setup_directory_nav()
		{
		}
		/**
		 * We'll handle template notices from BP Nouveau.
		 *
		 * @since 3.0.0
		 */
		public function neutralize_core_template_notices()
		{
		}
		/**
		 * Set the BP Uri for the customizer in case of Ajax requests.
		 *
		 * @since 3.0.0
		 * @deprecated 12.0.0
		 *
		 * @param  string $path The BP Uri.
		 * @return string       The BP Uri.
		 */
		public function customizer_set_uri($path)
		{
		}
		/**
		 * Modify "registration disabled" message in Nouveau template pack.
		 * Modify welcome message in Nouveau template pack.
		 *
		 * @since 8.0.0
		 *
		 * @param array $messages The list of feedback messages.
		 *
		 * @return array $messages
		 */
		public function filter_registration_messages($messages)
		{
		}
	}
	/**
	 * Creates our Settings component.
	 *
	 * @since 1.5.0
	 */
	#[\AllowDynamicProperties]
	class BP_Settings_Component extends \BP_Component
	{
		/**
		 * Start the settings component creation process.
		 *
		 * @since 1.5.0
		 */
		public function __construct()
		{
		}
		/**
		 * Include files.
		 *
		 * @since 1.5.0
		 *
		 * @param array $includes Array of values to include. Not used.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Only load up certain code when on specific pages.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Setup globals.
		 *
		 * The BP_SETTINGS_SLUG constant is deprecated.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_globals() for a description of arguments.
		 *
		 * @param array $args See BP_Component::setup_globals() for a description.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @see `BP_Component::register_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up the component entries in the WordPress Admin Bar.
		 *
		 * @since 1.5.0
		 *
		 * @see `BP_Component::setup_admin_bar()` for a description of the $wp_admin_nav
		 *      parameter array.
		 *
		 * @param array $wp_admin_nav See `BP_Component::setup_admin_bar()` for a
		 *                            description.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Register the BP Settings Blocks.
		 *
		 * @since 9.0.0
		 *
		 * @param array $blocks Optional. See BP_Component::blocks_init() for the description.
		 */
		public function blocks_init($blocks = array())
		{
		}
	}
	/**
	 * Load BuddyPress plugin admin area.
	 *
	 * @todo Break this apart into each applicable Component.
	 *
	 * @since 1.6.0
	 */
	#[\AllowDynamicProperties]
	class BP_Admin
	{
		/** Directory *************************************************************/
		/**
		 * Path to the BuddyPress admin directory.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $admin_dir = '';
		/** URLs ******************************************************************/
		/**
		 * URL to the BuddyPress admin directory.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $admin_url = '';
		/**
		 * URL to the BuddyPress images directory.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $images_url = '';
		/**
		 * URL to the BuddyPress admin CSS directory.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $css_url = '';
		/**
		 * URL to the BuddyPress admin JS directory.
		 *
		 * @since 1.6.0
		 * @var string
		 */
		public $js_url = '';
		/** Other *****************************************************************/
		/**
		 * Notices used for user feedback, like saving settings.
		 *
		 * @since 1.9.0
		 * @var array
		 */
		public $notices = array();
		/**
		 * BuddyPress admin screens nav tabs.
		 *
		 * @since 10.0.0
		 * @var array
		 */
		public $nav_tabs = array();
		/**
		 * BuddyPress admin active nav tab.
		 *
		 * @since 10.0.0
		 * @var string
		 */
		public $active_nav_tab = '';
		/**
		 * BuddyPress admin screens submenu pages.
		 *
		 * @since 10.0.0
		 * @var array
		 */
		public $submenu_pages = array();
		/** Methods ***************************************************************/
		/**
		 * The main BuddyPress admin loader.
		 *
		 * @since 1.6.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set admin-related globals.
		 *
		 * @since 1.6.0
		 */
		private function setup_globals()
		{
		}
		/**
		 * Include required files.
		 *
		 * @since 1.6.0
		 */
		private function includes()
		{
		}
		/**
		 * Set up the admin hooks, actions, and filters.
		 *
		 * @since 1.6.0
		 */
		private function setup_actions()
		{
		}
		/**
		 * Register site- or network-admin nav menu elements.
		 *
		 * Contextually hooked to site or network-admin depending on current configuration.
		 *
		 * @since 1.6.0
		 */
		public function admin_menus()
		{
		}
		/**
		 * Register site-admin nav menu elements.
		 *
		 * @since 2.5.0
		 */
		public function site_admin_menus()
		{
		}
		/**
		 * Register the settings.
		 *
		 * @since 1.6.0
		 */
		public function register_admin_settings()
		{
		}
		/**
		 * Add a link to BuddyPress Hello to the admin bar.
		 *
		 * @since 1.9.0
		 * @since 3.0.0 Hooked at priority 100 (was 15).
		 *
		 * @param WP_Admin_Bar $wp_admin_bar WordPress object implementing a Toolbar API.
		 */
		public function admin_bar_about_link($wp_admin_bar)
		{
		}
		/**
		 * Add Settings link to plugins area.
		 *
		 * @since 1.6.0
		 *
		 * @param array  $links Links array in which we would prepend our link.
		 * @param string $file  Current plugin basename.
		 * @return array Processed links.
		 */
		public function modify_plugin_action_links($links, $file)
		{
		}
		/**
		 * Displays an admin notice to inform settings have been saved.
		 *
		 * The notice is only displayed inside the Network Admin when
		 * BuddyPress is network activated.
		 *
		 * @since 10.0.0
		 */
		public function admin_load()
		{
		}
		/**
		 * Add some general styling to the admin area.
		 *
		 * @since 1.6.0
		 */
		public function admin_head()
		{
		}
		/**
		 * Add some general styling to the admin area.
		 *
		 * @since 1.6.0
		 */
		public function enqueue_scripts()
		{
		}
		/**
		 * Registers BuddyPress's suggested privacy policy language.
		 *
		 * @since 4.0.0
		 */
		public function add_privacy_policy_content()
		{
		}
		/** About *****************************************************************/
		/**
		 * Output the BuddyPress Hello template.
		 *
		 * @since 1.7.0 Screen content.
		 * @since 3.0.0 Now outputs BuddyPress Hello template.
		 */
		public function about_screen()
		{
		}
		/**
		 * Output the credits screen.
		 *
		 * Hardcoding this in here is pretty janky. It's fine for now, but we'll
		 * want to leverage api.wordpress.org eventually.
		 *
		 * @since 1.7.0
		 */
		public function credits_screen()
		{
		}
		/** Emails ****************************************************************/
		/**
		 * Registers 'Situations' column on Emails dashboard page.
		 *
		 * @since 2.6.0
		 *
		 * @param array $columns Current column data.
		 * @return array
		 */
		public function emails_register_situation_column($columns = array())
		{
		}
		/**
		 * Output column data for our custom 'Situations' column.
		 *
		 * @since 2.6.0
		 *
		 * @param string $column  Current column name.
		 * @param int    $post_id Current post ID.
		 */
		public function emails_display_situation_column_data($column = '', $post_id = 0)
		{
		}
		/**
		 * Adds BP Custom Post Types Admin screen's help tab.
		 *
		 * @since 14.0.0
		 */
		public function post_type_load_admin_screen()
		{
		}
		/** Helpers ***************************************************************/
		/**
		 * Return true/false based on whether a query argument is set.
		 *
		 * @see bp_do_activation_redirect()
		 *
		 * @since 2.2.0
		 *
		 * @return bool
		 */
		public static function is_new_install()
		{
		}
		/**
		 * Return a user-friendly version-number string, for use in translations.
		 *
		 * @since 2.2.0
		 *
		 * @return string
		 */
		public static function display_version()
		{
		}
		/**
		 * Add Emails menu item to custom menus array.
		 *
		 * Several BuddyPress components have top-level menu items in the Dashboard,
		 * which all appear together in the middle of the Dashboard menu. This function
		 * adds the Emails screen to the array of these menu items.
		 *
		 * @since 2.4.0
		 *
		 * @param array $custom_menus The list of top-level BP menu items.
		 * @return array $custom_menus List of top-level BP menu items, with Emails added.
		 */
		public function emails_admin_menu_order($custom_menus = array())
		{
		}
		/**
		 * Register styles commonly used by BuddyPress wp-admin screens.
		 *
		 * @since 2.5.0
		 */
		public function admin_register_styles()
		{
		}
		/**
		 * Register JS commonly used by BuddyPress wp-admin screens.
		 *
		 * @since 2.5.0
		 */
		public function admin_register_scripts()
		{
		}
		/**
		 * Adds inline styles to adapt the number of grid columns according to the number of BP Admin tabs.
		 *
		 * @since 10.0.0
		 */
		public function add_inline_styles()
		{
		}
		/**
		 * Add a "BuddyPress Add-ons" tab to the Add Plugins Admin screen.
		 *
		 * @since 10.0.0
		 *
		 * @param array $tabs The list of "Add Plugins" Tabs (Featured, Recommended, etc..).
		 * @return array      The same list including the "BuddyPress Add-ons" tab.
		 */
		public function addons_tab($tabs = array())
		{
		}
		/**
		 * Customize the Plugins API query arguments.
		 *
		 * The most important argument is the $user one which is set to "buddypress".
		 * Using this key and value will fetch the plugins the w.org "buddypress" user favorited.
		 *
		 * @since 10.0.0
		 *
		 * @global int $paged The current page of the Plugin results.
		 *
		 * @return array The "BuddyPress add-ons" args.
		 */
		public function addons_args()
		{
		}
		/**
		 * Displays the list of "BuddyPress Add-ons".
		 *
		 * @since 10.0.0
		 */
		public function display_addons_table()
		{
		}
		/**
		 * Display the Admin Notifications screen.
		 *
		 * @since 11.4.0
		 */
		public function admin_notifications()
		{
		}
	}
	/**
	 * BP_Email_Address Interface.
	 *
	 * @since 2.5.0
	 */
	interface BP_Email_Address
	{
		/**
		 * Gets the email address of the user.
		 *
		 * @since 5.0.0
		 *
		 * @return string
		 */
		public function get_address();
		/**
		 * Gets the display name of the user.
		 *
		 * @since 5.0.0
		 *
		 * @return string
		 */
		public function get_name();
		/**
		 * Sets the email address of the user.
		 *
		 * @since 5.0.0
		 *
		 * @param string $email_address Email address.
		 */
		public function set_address($email_address);
		/**
		 * Sets the name of the user.
		 *
		 * @since 5.0.0
		 *
		 * @param string $name Name.
		 */
		public function set_name($name);
	}
	/**
	 * BP_Email_Participant class.
	 *
	 * @since 5.0.0
	 */
	abstract class BP_Email_Participant implements \BP_Email_Address
	{
		/**
		 * Recipient's email address.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		protected $address = '';
		/**
		 * Recipient's name.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		protected $name = '';
		/**
		 * Gets the email address of the user.
		 *
		 * @since 5.0.0
		 *
		 * @return string
		 */
		public function get_address()
		{
		}
		/**
		 * Gets the email name of the user.
		 *
		 * @since 5.0.0
		 *
		 * @return string
		 */
		public function get_name()
		{
		}
		/**
		 * Sets the email address of the user.
		 *
		 * @since 5.0.0
		 *
		 * @param string $email_address Email address.
		 */
		public function set_address($email_address)
		{
		}
		/**
		 * Sets the name of the user.
		 *
		 * @since 5.0.0
		 *
		 * @param string $name Name.
		 */
		public function set_name($name)
		{
		}
	}
	/**
	 * This class is used to provide backward compatibility for extensions that access and modify
	 * the $bp->bp_nav global.
	 *
	 * Backward compatibility class for `bp_nav`.
	 *
	 * @since 2.6.0
	 * @deprecated 12.0.0
	 */
	class BP_Core_BP_Nav_BackCompat implements \ArrayAccess
	{
		/**
		 * Nav items.
		 *
		 * @since 2.6.0
		 *
		 * @var array
		 */
		public $backcompat_nav = array();
		/**
		 * Component to which nav items belong.
		 *
		 * @since 2.6.0
		 *
		 * @var array
		 */
		public $component;
		/**
		 * Constructor.
		 *
		 * @since 2.6.0
		 *
		 * @param array $backcompat_nav Optional. Array of nav items.
		 */
		public function __construct($backcompat_nav = array())
		{
		}
		/**
		 * Assign a value to the nav array at the specified offset.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 *
		 * @param mixed $offset Array offset.
		 * @param array $value  Nav item.
		 */
		#[\ReturnTypeWillChange]
		public function offsetSet($offset, $value)
		{
		}
		/**
		 * Get a value of the nav array at the specified offset.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 *
		 * @param mixed $offset Array offset.
		 */
		#[\ReturnTypeWillChange]
		public function offsetGet($offset)
		{
		}
		/**
		 * Check whether nav array has a value at the specified offset.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 *
		 * @param mixed $offset Array offset.
		 */
		#[\ReturnTypeWillChange]
		public function offsetExists($offset)
		{
		}
		/**
		 * Unset a nav array value at the specified offset.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 *
		 * @param mixed $offset Array offset.
		 */
		#[\ReturnTypeWillChange]
		public function offsetUnset($offset)
		{
		}
		/**
		 * Set the component to which the nav belongs.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		public function set_component()
		{
		}
		/**
		 * Get the component to which the a nav item belongs.
		 *
		 * We use the following heuristic to guess, based on an offset, which component the item belongs to:
		 *   - If this is a group, and the offset is the same as the current group's slug, it's a group nav item.
		 *   - Otherwise, it's a member nav item.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		public function get_component()
		{
		}
		/**
		 * Reset the cached nav items.
		 *
		 * Called when the nav API removes items from the nav array.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		public function reset()
		{
		}
		/**
		 * Get the nav object corresponding to the specified offset.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 *
		 * @param mixed $offset Array offset.
		 */
		protected function get_nav($offset)
		{
		}
		/**
		 * Get the BP_Core_Nav object corresponding to the component, based on a nav item name.
		 *
		 * The way bp_nav was previously organized makes it impossible to know for sure which component's nav is
		 * being referenced by a given nav item name. We guess in the following manner:
		 *   - If we're looking at a group, and the nav item name (`$offset`) is the same as the slug of the current
		 *     group, we assume that the proper component nav is 'groups'.
		 *   - Otherwise, fall back on 'members'.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 *
		 * @param string $offset Nav item name.
		 */
		protected function get_component_nav($offset = '')
		{
		}
		/**
		 * Get the nav data, formatted as a flat array.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		protected function to_array()
		{
		}
	}
	/**
	 * BuddyPress date query class.
	 *
	 * Extends the {@see WP_Date_Query} class for use with BuddyPress.
	 *
	 * @since 2.1.0
	 *
	 * @param array $date_query {
	 *     Date query arguments.  See first parameter of {@see WP_Date_Query::__construct()}.
	 * }
	 * @param string $column The DB column to query against.
	 */
	class BP_Date_Query extends \WP_Date_Query
	{
		/**
		 * The column to query against. Can be changed via the query arguments.
		 *
		 * @var string
		 */
		public $column;
		/**
		 * Whether to prepend the 'AND' operator to the WHERE SQL clause.
		 *
		 * @since 10.0.0
		 *
		 * @var bool
		 */
		public $prepend_and = \false;
		/**
		 * Constructor.
		 *
		 * @since 2.1.0
		 * @since 10.0.0 Added `$prepend_and` argument.
		 *
		 * @see WP_Date_Query::__construct()
		 *
		 * @param array  $date_query  Date query arguments.
		 * @param string $column      The DB column to query against.
		 * @param bool   $prepend_and Whether to prepend the 'AND' operator to the WHERE SQL clause.
		 */
		public function __construct($date_query, $column = '', $prepend_and = \false)
		{
		}
		/**
		 * Destructor.
		 */
		public function __destruct()
		{
		}
		/**
		 * Registers our date column with WP Date Query to pass validation.
		 *
		 * @param array $retval Current DB columns.
		 * @return array
		 */
		public function register_date_column($retval = array())
		{
		}
		/**
		 * Generate SQL clauses to be appended to a main query.
		 *
		 * Since BuddyPress builds its SQL queries differently than WP_Query, we have
		 * to override the parent method to remove the leading 'AND' operator from the
		 * WHERE clause.
		 *
		 * @since 10.0.0
		 *
		 * @return array {
		 *     Array containing JOIN and WHERE SQL clauses to append to the main query.
		 *
		 *     @type string $join  SQL fragment to append to the main JOIN clause.
		 *     @type string $where SQL fragment to append to the main WHERE clause.
		 * }
		 */
		protected function get_sql_clauses()
		{
		}
		/**
		 * Helper method to generate and fetch the WHERE SQL clause for a date query.
		 *
		 * See {@link BP_Date_Query::__construct()} for all argument documentation.
		 *
		 * @since 10.0.0
		 *
		 * @param  array  $date_query  Date query arguments.
		 * @param  string $column      DB column to query against date.
		 * @param  bool   $prepend_and Whether to prepend the 'AND' operator to the WHERE clause.
		 * @return string
		 */
		public static function get_where_sql($date_query = array(), $column = '', $prepend_and = \false)
		{
		}
	}
	/**
	 * List table class for nonmember opt-outs admin page.
	 *
	 * @since 8.0.0
	 */
	class BP_Optouts_List_Table extends \WP_Users_List_Table
	{
		/**
		 * Opt-out count.
		 *
		 * @since 8.0.0
		 *
		 * @var int
		 */
		public $total_items = 0;
		/**
		 * Constructor.
		 *
		 * @since 8.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set up items for display in the list table.
		 *
		 * Handles filtering of data, sorting, pagination, and any other data
		 * manipulation required prior to rendering.
		 *
		 * @since 8.0.0
		 */
		public function prepare_items()
		{
		}
		/**
		 * Gets the name of the default primary column.
		 *
		 * @since 10.1.0
		 *
		 * @return string Name of the default primary column, in this case, 'email_address'.
		 */
		protected function get_default_primary_column_name()
		{
		}
		/**
		 * Get the list of views available on this table.
		 *
		 * @since 8.0.0
		 */
		public function views()
		{
		}
		/**
		 * Get rid of the extra nav.
		 *
		 * WP_Users_List_Table will add an extra nav to change user's role.
		 * As we're dealing with opt-outs, we don't need this.
		 *
		 * @since 8.0.0
		 *
		 * @param array $which Current table nav item.
		 */
		public function extra_tablenav($which)
		{
		}
		/**
		 * Specific opt-out columns.
		 *
		 * @since 8.0.0
		 *
		 * @return array
		 */
		public function get_columns()
		{
		}
		/**
		 * Specific bulk actions for opt-outs.
		 *
		 * @since 8.0.0
		 */
		public function get_bulk_actions()
		{
		}
		/**
		 * The text shown when no items are found.
		 *
		 * Nice job, clean sheet!
		 *
		 * @since 8.0.0
		 */
		public function no_items()
		{
		}
		/**
		 * The columns opt-outs can be reordered by.
		 *
		 * @since 8.0.0
		 */
		public function get_sortable_columns()
		{
		}
		/**
		 * Display opt-out rows.
		 *
		 * @since 8.0.0
		 */
		public function display_rows()
		{
		}
		/**
		 * Display an opt-out row.
		 *
		 * @since 8.0.0
		 *
		 * @see WP_List_Table::single_row() for explanation of params.
		 *
		 * @param BP_Optout $optout   BP_Optout object.
		 * @param string    $style    Styles for the row.
		 * @param string    $role     Role to be assigned to user.
		 * @param int       $numposts Number of posts.
		 */
		public function single_row($optout = \null, $style = '', $role = '', $numposts = 0)
		{
		}
		/**
		 * Markup for the checkbox used to select items for bulk actions.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Optout $optout BP_Optout object.
		 */
		public function column_cb($optout = \null)
		{
		}
		/**
		 * Markup for the checkbox used to select items for bulk actions.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Optout|null $optout BP_Optout object.
		 */
		public function column_email_address($optout = \null)
		{
		}
		/**
		 * The inviter/site member who sent the email that prompted the opt-out.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Optout|null $optout BP_Optout object.
		 */
		public function column_username($optout = \null)
		{
		}
		/**
		 * Display registration date of user whose communication prompted opt-out.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Optout|null $optout BP_Optout object.
		 */
		public function column_user_registered($optout = \null)
		{
		}
		/**
		 * Display type of email that prompted opt-out.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Optout|null $optout BP_Optout object.
		 */
		public function column_email_type($optout = \null)
		{
		}
		/**
		 * Display description of bp-email-type that prompted opt-out.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Optout|null $optout BP_Optout object.
		 */
		public function column_email_type_description($optout = \null)
		{
		}
		/**
		 * Display opt-out date.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Optout|null $optout BP_Optout object.
		 */
		public function column_optout_date_modified($optout = \null)
		{
		}
		/**
		 * Allow plugins to add custom columns.
		 *
		 * @since 8.0.0
		 *
		 * @param BP_Optout|null $optout      BP_Optout object.
		 * @param string         $column_name The column name.
		 * @return string
		 */
		public function column_default($optout = \null, $column_name = '')
		{
		}
	}
	/**
	 * Navigation item.
	 *
	 * @since 2.6.0
	 */
	class BP_Core_Nav_Item extends \ArrayObject
	{
		/**
		 * Constructor.
		 *
		 * @param array $data Data to populate the nav item.
		 */
		public function __construct($data)
		{
		}
	}
	/**
	 * BP Attachment class.
	 *
	 * Extend it to manage your component's uploads.
	 *
	 * @since 2.3.0
	 */
	abstract class BP_Attachment
	{
		/** Upload properties *****************************************************/
		/**
		 * The file being uploaded.
		 *
		 * @var array
		 */
		public $attachment = array();
		/**
		 * The default args to be merged with the
		 * ones passed by the child class.
		 *
		 * @var array
		 */
		protected $default_args = array('original_max_filesize' => 0, 'allowed_mime_types' => array(), 'base_dir' => '', 'action' => '', 'file_input' => '', 'upload_error_strings' => array(), 'required_wp_files' => array('file'), 'upload_dir_filter_args' => 0);
		/**
		 * Construct Upload parameters.
		 *
		 * @since 2.3.0
		 * @since 2.4.0 Add the $upload_dir_filter_args argument to the $arguments array
		 *
		 * @param array|string $args {
		 *     Array of upload parameters.
		 *
		 *     @type int    $original_max_filesize  Maximum file size in kilobytes. Defaults to php.ini settings.
		 *     @type array  $allowed_mime_types     List of allowed file extensions (eg: array( 'jpg', 'gif', 'png' ) ).
		 *                                          Defaults to WordPress allowed mime types.
		 *     @type string $base_dir               Component's upload base directory. Defaults to WordPress 'uploads'.
		 *     @type string $action                 The upload action used when uploading a file, $_POST['action'] must be set
		 *                                          and its value must equal $action {@link wp_handle_upload()} (required).
		 *     @type string $file_input             The name attribute used in the file input. (required).
		 *     @type array  $upload_error_strings   A list of specific error messages (optional).
		 *     @type array  $required_wp_files      The list of required WordPress core files. Default: array( 'file' ).
		 *     @type int    $upload_dir_filter_args 1 to receive the original Upload dir array in the Upload dir filter, 0 otherwise.
		 *                                          Defaults to 0 (optional).
		 * }
		 */
		public function __construct($args = '')
		{
		}
		/**
		 * Set upload path and url for the component.
		 *
		 * @since 2.3.0
		 */
		public function set_upload_dir()
		{
		}
		/**
		 * Set Upload error messages.
		 *
		 * Used into the $overrides argument of BP_Attachment->upload()
		 *
		 * @since 2.3.0
		 *
		 * @param array $param A list of error messages to add to BuddyPress core ones.
		 * @return array $upload_errors The list of upload errors.
		 */
		public function set_upload_error_strings($param = array())
		{
		}
		/**
		 * Include the WordPress core needed files.
		 *
		 * @since 2.3.0
		 */
		public function includes()
		{
		}
		/**
		 * Upload the attachment.
		 *
		 * @since 2.3.0
		 *
		 * @param array       $file              The appropriate entry the from $_FILES superglobal.
		 * @param string      $upload_dir_filter A specific filter to be applied to 'upload_dir' (optional).
		 * @param string|null $time              Optional. Time formatted in 'yyyy/mm'. Default null.
		 * @return false|array On success, returns an associative array of file attributes.
		 *               On failure, returns an array containing the error message
		 *               (eg: array( 'error' => $message ) )
		 */
		public function upload($file, $upload_dir_filter = '', $time = \null)
		{
		}
		/**
		 * Helper to convert utf-8 characters in filenames to their ASCII equivalent.
		 *
		 * @since 2.9.0
		 *
		 * @param string $retval Filename.
		 * @return string
		 */
		public function sanitize_utf8_filename($retval)
		{
		}
		/**
		 * Validate the allowed mime types using WordPress allowed mime types.
		 *
		 * In case of a multisite, the mime types are already restricted by
		 * the 'upload_filetypes' setting. BuddyPress will respect this setting.
		 *
		 * @since 2.3.0
		 *
		 * @see check_upload_mimes()
		 *
		 * @return array Valid mime types.
		 */
		protected function validate_mime_types()
		{
		}
		/**
		 * Specific upload rules.
		 *
		 * Override this function from your child class to build your specific rules
		 * By default, if an original_max_filesize is provided, a check will be done
		 * on the file size.
		 *
		 * @see BP_Attachment_Avatar->validate_upload() for an example of use
		 *
		 * @since 2.3.0
		 *
		 * @param array $file The temporary file attributes (before it has been moved).
		 * @return array The file.
		 */
		public function validate_upload($file = array())
		{
		}
		/**
		 * Default filter to save the attachments.
		 *
		 * @since 2.3.0
		 * @since 2.4.0 Add the $upload_dir parameter to the method
		 *
		 *       regarding to context
		 *
		 * @param array $upload_dir The original Uploads dir.
		 * @return array The upload directory data.
		 */
		public function upload_dir_filter($upload_dir = array())
		{
		}
		/**
		 * Create the custom base directory for the component uploads.
		 *
		 * Override this function in your child class to run specific actions.
		 * (eg: add an .htaccess file)
		 *
		 * @since 2.3.0
		 *
		 * @return bool
		 */
		public function create_dir()
		{
		}
		/**
		 * Crop an image file.
		 *
		 * @since 2.3.0
		 *
		 * @param array $args {
		 *     Array of arguments for the crop method.
		 *
		 *     @type string $original_file The source file (absolute path) for the Attachment.
		 *     @type int    $crop_x        The start x position to crop from.
		 *     @type int    $crop_y        The start y position to crop from.
		 *     @type int    $crop_w        The width to crop.
		 *     @type int    $crop_h        The height to crop.
		 *     @type int    $dst_w         The destination width.
		 *     @type int    $dst_h         The destination height.
		 *     @type int    $src_abs       Optional. If the source crop points are absolute.
		 *     @type string $dst_file      Optional. The destination file to write to.
		 * }
		 *
		 * @return string|WP_Error New filepath on success, WP_Error on failure.
		 */
		public function crop($args = array())
		{
		}
		/**
		 * Build script datas for the Uploader UI.
		 *
		 * Override this method from your child class to build the script datas.
		 *
		 * @since 2.3.0
		 *
		 * @return array The javascript localization data.
		 */
		public function script_data()
		{
		}
		/**
		 * Adds a new revision of a file.
		 *
		 * @since 10.0.0
		 *
		 * @param string $attachment_type The attachement type (eg: avatar).
		 * @param array  $args {
		 *     Optional. Array of arguments for the add_revision method.
		 *
		 *     @type string $file_abspath The source file (absolute path) for the attachment.
		 *     @type string $file_id      Optional. The file ID to use as a suffix for the revision directory.
		 * }
		 * @return object|WP_Error An object informing about the URL an Path to a revision file, a WP_Error object on failure.
		 */
		public function add_revision($attachment_type, $args = array())
		{
		}
		/**
		 * Get full data for an image
		 *
		 * @since 2.4.0
		 *
		 * @param string $file Absolute path to the uploaded image.
		 * @return bool|array   An associate array containing the width, height and metadatas.
		 *                      False in case an important image attribute is missing.
		 */
		public static function get_image_data($file)
		{
		}
		/**
		 * Edit an image file to resize it or rotate it
		 *
		 * @since 2.4.0
		 *
		 * @param string $attachment_type The attachment type (eg: avatar or cover_image). Required.
		 * @param array  $args {
		 *     Optional. Array of arguments for the edit_image method.
		 *
		 *     @type string $file     Absolute path to the image file (required).
		 *     @type int    $max_w    Max width attribute for the editor's resize method (optional).
		 *     @type int    $max_h    Max height attribute for the editor's resize method (optional).
		 *     @type bool   $crop     Crop attribute for the editor's resize method (optional).
		 *     @type float  $rotate   Angle for the editor's rotate method (optional).
		 *     @type int    $quality  Compression quality on a 1-100% scale (optional).
		 *     @type bool   $save     Whether to use the editor's save method or not (optional).
		 * }
		 * @return string|WP_Image_Editor|WP_Error The edited image path or the WP_Image_Editor object in case of success,
		 *                                         an WP_Error object otherwise.
		 */
		public static function edit_image($attachment_type, $args = array())
		{
		}
	}
	/**
	 * BP Attachment Avatar class.
	 *
	 * Extends BP Attachment to manage the avatar uploads.
	 *
	 * @since 2.3.0
	 */
	#[\AllowDynamicProperties]
	class BP_Attachment_Avatar extends \BP_Attachment
	{
		/**
		 * Construct Upload parameters.
		 *
		 * @since 2.3.0
		 *
		 * @see  BP_Attachment::__construct() for list of parameters
		 */
		public function __construct()
		{
		}
		/**
		 * Gets the available avatar types.
		 *
		 * @since 2.3.0
		 *
		 * @param array $allowed_types Array of allowed avatar types.
		 * @return string comma separated list of allowed avatar types.
		 */
		public static function get_avatar_types($allowed_types = array())
		{
		}
		/**
		 * Set Upload Dir data for avatars.
		 *
		 * @since 2.3.0
		 */
		public function set_upload_dir()
		{
		}
		/**
		 * Avatar specific rules.
		 *
		 * Adds an error if the avatar size or type don't match BuddyPress needs.
		 * The error code is the index of $upload_error_strings.
		 *
		 * @since 2.3.0
		 *
		 * @param array $file the temporary file attributes (before it has been moved).
		 * @return array the file with extra errors if needed.
		 */
		public function validate_upload($file = array())
		{
		}
		/**
		 * Maybe shrink the attachment to fit maximum allowed width.
		 *
		 * @since 2.3.0
		 * @since 2.4.0 Add the $ui_available_width parameter, to inform about the Avatar UI width.
		 *
		 * @param string $file               The absolute path to the file.
		 * @param int    $ui_available_width Available width for the UI.
		 * @return false|string|WP_Image_Editor|WP_Error
		 */
		public static function shrink($file = '', $ui_available_width = 0)
		{
		}
		/**
		 * Check if the image dimensions are smaller than full avatar dimensions.
		 *
		 * @since 2.3.0
		 *
		 * @param string $file the absolute path to the file.
		 * @return bool
		 */
		public static function is_too_small($file = '')
		{
		}
		/**
		 * Crop the avatar.
		 *
		 * @since 2.3.0
		 *
		 * @see BP_Attachment::crop() for the list of parameters
		 *
		 * @param array $args Array of arguments for the cropping.
		 * @return array The cropped avatars (full, thumb and the timestamp).
		 */
		public function crop($args = array())
		{
		}
		/**
		 * Get the user id to set its avatar.
		 *
		 * @since 2.3.0
		 *
		 * @return integer The user ID.
		 */
		private function get_user_id()
		{
		}
		/**
		 * Get the group id to set its avatar.
		 *
		 * @since 2.3.0
		 *
		 * @return integer The group ID.
		 */
		private function get_group_id()
		{
		}
		/**
		 * Build script data for the Uploader UI.
		 *
		 * @since 2.3.0
		 *
		 * @return array The javascript localization data.
		 */
		public function script_data()
		{
		}
	}
	/**
	 * BP_Email_Delivery Interface.
	 *
	 * When implementing support for an email delivery service into BuddyPress,
	 * you are required to create a class that implements this interface.
	 *
	 * @since 2.5.0
	 */
	interface BP_Email_Delivery
	{
		/**
		 * Send email(s).
		 *
		 * @since 2.5.0
		 *
		 * @param BP_Email $email Email to send.
		 * @return bool|WP_Error Returns true if email send, else a descriptive WP_Error.
		 */
		public function bp_email(\BP_Email $email);
	}
	/**
	 * BuddyPress Customizer font size control.
	 *
	 * @since 2.5.0
	 */
	class BP_Customizer_Control_Range extends \WP_Customize_Control
	{
		/**
		 * Control type.
		 *
		 * @var string
		 */
		public $type = 'range';
		/**
		 * Enqueue scripts/styles for the color picker.
		 *
		 * @since 2.5.0
		 */
		public function enqueue()
		{
		}
		/**
		 * Render the control.
		 *
		 * @since 2.5.0
		 */
		public function render_content()
		{
		}
	}
	/**
	 * This class is used to provide backward compatibility for extensions that access and modify
	 * the $bp->bp_options_nav global.
	 *
	 * Backward compatibility class for `bp_options_nav`.
	 *
	 * @since 2.6.0
	 * @deprecated 12.0.0
	 */
	class BP_Core_BP_Options_Nav_BackCompat extends \BP_Core_BP_Nav_BackCompat
	{
		/**
		 * Parent slug of the current nav item.
		 *
		 * @since 2.6.0
		 *
		 * @var string
		 */
		protected $parent_slug = '';
		/**
		 * Get a value of the nav array at the specified offset.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 *
		 * @param mixed $offset Array offset.
		 */
		public function offsetGet($offset)
		{
		}
		/**
		 * Unset a nav array value at the specified offset.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 *
		 * @param mixed $offset Array offset.
		 */
		#[\ReturnTypeWillChange]
		public function offsetUnset($offset)
		{
		}
		/**
		 * Get the parent slug of the current nav item.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		public function get_parent_slug()
		{
		}
		/**
		 * Set the parent slug of the current nav item.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 */
		public function set_parent_slug()
		{
		}
		/**
		 * Get the nav object corresponding to the specified offset.
		 *
		 * @since 2.6.0
		 * @deprecated 12.0.0
		 *
		 * @param mixed $offset Array offset.
		 */
		public function get_nav($offset)
		{
		}
	}
	/**
	 * BuddyPress Invitations.
	 *
	 * Use this class to create, access, edit, or delete BuddyPress Invitations.
	 *
	 * @since 5.0.0
	 */
	class BP_Invitation
	{
		/**
		 * The invitation ID.
		 *
		 * @since 5.0.0
		 *
		 * @var int
		 */
		public $id;
		/**
		 * The ID of the invited user.
		 *
		 * @since 5.0.0
		 *
		 * @var int
		 */
		public $user_id;
		/**
		 * The ID of the user who created the invitation.
		 *
		 * @since 5.0.0
		 *
		 * @var int
		 */
		public $inviter_id;
		/**
		 * The email address of the invited user.
		 * Used when extending an invitation to someone who does not belong to the site.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		public $invitee_email;
		/**
		 * The name of the related class.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		public $class;
		/**
		 * The ID associated with the invitation and component.
		 * Example: the group ID if a group invitation
		 *
		 * @since 5.0.0
		 *
		 * @var int
		 */
		public $item_id;
		/**
		 * The secondary ID associated with the invitation and component.
		 * Example: a taxonomy term ID if invited to a site's category-specific RSS feed
		 *
		 * @since 5.0.0
		 *
		 * @var int|null
		 */
		public $secondary_item_id = \null;
		/**
		 * Invite or request.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		public $type;
		/**
		 * Extra information provided by the requester or inviter.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		public $content;
		/**
		 * The date the invitation was last modified.
		 *
		 * @since 5.0.0
		 *
		 * @var string
		 */
		public $date_modified;
		/**
		 * Has the invitation been sent, or is it a draft invite?
		 *
		 * @since 5.0.0
		 *
		 * @var bool
		 */
		public $invite_sent;
		/**
		 * Has the invitation been accepted by the invitee?
		 *
		 * @since 5.0.0
		 *
		 * @var bool
		 */
		public $accepted;
		/**
		 * Columns in the invitations table.
		 *
		 * @since 9.0.0
		 *
		 * @var array
		 */
		public static $columns = array('id', 'user_id', 'inviter_id', 'invitee_email', 'class', 'item_id', 'secondary_item_id', 'type', 'content', 'date_modified', 'invite_sent', 'accepted');
		/** Public Methods ****************************************************/
		/**
		 * Constructor method.
		 *
		 * @since 5.0.0
		 *
		 * @param int $id Optional. Provide an ID to access an existing invitation item.
		 */
		public function __construct($id = 0)
		{
		}
		/**
		 * Update or insert invitation details into the database.
		 *
		 * @since 5.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Fetch data for an existing invitation from the database.
		 *
		 * @since 5.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function populate()
		{
		}
		/** Protected Static Methods ******************************************/
		/**
		 * Create an invitation entry.
		 *
		 * @since 5.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $data {
		 *     Array of invitation data, passed to {@link wpdb::insert()}.
		 *     @type int    $user_id           ID of the invited user.
		 *     @type int    $inviter_id        ID of the user who created the invitation.
		 *     @type string $invitee_email     Email address of the invited user.
		 *     @type string $class             Name of the related class.
		 *     @type int    $item_id           ID associated with the invitation and component.
		 *     @type int    $secondary_item_id Secondary ID associated with the invitation and
		 *                                     component.
		 *     @type string $content           Extra information provided by the requester
		 *                                     or inviter.
		 *     @type string $date_modified     Date the invitation was last modified.
		 *     @type int    $invite_sent       Has the invitation been sent, or is it a draft
		 *                                     invite?
		 * }
		 * @param array $data_format See {@link wpdb::insert()}.
		 * @return int|false The number of rows inserted, or false on error.
		 */
		protected static function _insert($data = array(), $data_format = array())
		{
		}
		/**
		 * Update invitations.
		 *
		 * @since 5.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see wpdb::update() for further description of paramater formats.
		 *
		 * @param array $data         Array of invitation data to update, passed to
		 *                            {@link wpdb::update()}. Accepts any property of a
		 *                            BP_Invitation object.
		 * @param array $where        The WHERE params as passed to wpdb::update().
		 *                            Typically consists of array( 'ID' => $id ) to specify the ID
		 *                            of the item being updated. See {@link wpdb::update()}.
		 * @param array $data_format  See {@link wpdb::insert()}.
		 * @param array $where_format See {@link wpdb::insert()}.
		 * @return int|false The number of rows updated, or false on error.
		 */
		protected static function _update($data = array(), $where = array(), $data_format = array(), $where_format = array())
		{
		}
		/**
		 * Delete invitations.
		 *
		 * @since 5.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see wpdb::update() for further description of paramater formats.
		 *
		 * @param array $where        Array of WHERE clauses to filter by, passed to
		 *                            {@link wpdb::delete()}. Accepts any property of a
		 *                            BP_Invitation object.
		 * @param array $where_format See {@link wpdb::insert()}.
		 * @return int|false The number of rows updated, or false on error.
		 */
		protected static function _delete($where = array(), $where_format = array())
		{
		}
		/**
		 * Assemble the WHERE clause of a get() SQL statement.
		 *
		 * Used by BP_Invitation::get() to create its WHERE
		 * clause.
		 *
		 * @since 5.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args See {@link BP_Invitation::get()} for more details.
		 * @return string WHERE clause.
		 */
		protected static function get_where_sql($args = array())
		{
		}
		/**
		 * Assemble the ORDER BY clause of a get() SQL statement.
		 *
		 * Used by BP_Invitation::get() to create its ORDER BY
		 * clause.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args See {@link BP_Invitation::get()} for more details.
		 * @return string ORDER BY clause.
		 */
		protected static function get_order_by_sql($args = array())
		{
		}
		/**
		 * Assemble the LIMIT clause of a get() SQL statement.
		 *
		 * Used by BP_Invitation::get() to create its LIMIT clause.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args See {@link BP_Invitation::get()} for more details.
		 * @return string LIMIT clause.
		 */
		protected static function get_paged_sql($args = array())
		{
		}
		/**
		 * Assemble query clauses, based on arguments, to pass to $wpdb methods.
		 *
		 * The insert(), update(), and delete() methods of {@link wpdb} expect
		 * arguments of the following forms:
		 *
		 * - associative arrays whose key/value pairs are column => value, to
		 *   be used in WHERE, SET, or VALUES clauses
		 * - arrays of "formats", which tell $wpdb->prepare() which type of
		 *   value to expect when sanitizing (eg, array( '%s', '%d' ))
		 *
		 * This utility method can be used to assemble both kinds of params,
		 * out of a single set of associative array arguments, such as:
		 *
		 *     $args = array(
		 *         'user_id' => 4,
		 *         'class'   => 'BP_Groups_Invitation_Manager',
		 *     );
		 *
		 * This will be converted to:
		 *
		 *     array(
		 *         'data' => array(
		 *             'user_id' => 4,
		 *             'class'   => 'BP_Groups_Invitation_Manager',
		 *         ),
		 *         'format' => array(
		 *             '%d',
		 *             '%s',
		 *         ),
		 *     )
		 *
		 * which can easily be passed as arguments to the $wpdb methods.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args Associative array of filter arguments.
		 *                    See {@BP_Invitation::get()} for a breakdown.
		 * @return array Associative array of 'data' and 'format' args.
		 */
		protected static function get_query_clauses($args = array())
		{
		}
		/** Public Static Methods *********************************************/
		/**
		 * Get invitations, based on provided filter parameters.
		 *
		 * @since 5.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *     Associative array of arguments. All arguments but $page and
		 *     $per_page can be treated as filter values for get_where_sql()
		 *     and get_query_clauses(). All items are optional.
		 *     @type int|array    $id                ID of invitation being fetched.
		 *                                           Can be an array of IDs.
		 *     @type int|array    $user_id           ID of user being queried. Can be an
		 *                                           Can be an array of IDs.
		 *     @type int|array    $inviter_id        ID of user who created the
		 *                                           invitation. Can be an array of IDs.
		 *     @type string|array $invitee_email     Email address of invited users
		 *                                           being queried. Can be an array of
		 *                                           addresses.
		 *     @type string|array $class             Name of the class to filter by.
		 *                                           Can be an array of class names.
		 *     @type int|array    $item_id           ID of associated item.
		 *                                           Can be an array of multiple item IDs.
		 *     @type int|array    $secondary_item_id ID of secondary associated item.
		 *                                           Can be an array of multiple IDs.
		 *     @type string|array $type              Type of item. An "invite" is sent
		 *                                           from one user to another.
		 *                                           A "request" is submitted by a
		 *                                           user and no inviter is required.
		 *                                           'all' returns all. Default: 'all'.
		 *     @type string       $invite_sent       Limit to draft, sent or all
		 *                                           'draft' limits to unsent invites,
		 *                                           'sent' returns only sent invites,
		 *                                           'all' returns all. Default: 'all'.
		 *     @type bool         $accepted          Limit to accepted or
		 *                                           not-yet-accepted invitations.
		 *                                           'accepted' returns accepted invites,
		 *                                           'pending' returns pending invites,
		 *                                           'all' returns all. Default: 'pending'
		 *     @type string       $search_terms      Term to match against class field.
		 *     @type string       $order_by          Database column to order by.
		 *     @type string       $sort_order        Either 'ASC' or 'DESC'.
		 *     @type string       $order_by          Field to order results by.
		 *     @type string       $sort_order        ASC or DESC.
		 *     @type int          $page              Number of the current page of results.
		 *                                           Default: false (no pagination,
		 *                                           all items).
		 *     @type int          $per_page          Number of items to show per page.
		 *                                           Default: false (no pagination,
		 *                                           all items).
		 *     @type string       $fields            Which fields to return. Specify 'item_ids' to fetch a list of Item_IDs.
		 *                                           Specify 'ids' to fetch a list of Invitation IDs.
		 *                                           Default: 'all' (return BP_Invitation objects).
		 * }
		 *
		 * @return int[]|BP_Invitation[] BP_Invitation objects | IDs of found invite.
		 */
		public static function get($args = array())
		{
		}
		/**
		 * Get a count of total invitations matching a set of arguments.
		 *
		 * @since 5.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see BP_Invitation::get() for a description of
		 *      arguments.
		 *
		 * @param array $args See {@link BP_Invitation::get()}.
		 * @return int Count of located items.
		 */
		public static function get_total_count($args)
		{
		}
		/**
		 * Update invitations.
		 *
		 * @since 5.0.0
		 *
		 * @see BP_Invitation::get() for a description of
		 *      accepted update/where arguments.
		 *
		 * @param array $update_args Associative array of fields to update,
		 *                           and the values to update them to. Of the format
		 *                           array( 'user_id' => 4, 'class' => 'BP_Groups_Invitation_Manager', ).
		 * @param array $where_args  Associative array of columns/values, to
		 *                           determine which rows should be updated. Of the format
		 *                           array( 'item_id' => 7, 'class' => 'BP_Groups_Invitation_Manager', ).
		 * @return int|bool Number of rows updated on success, false on failure.
		 */
		public static function update($update_args = array(), $where_args = array())
		{
		}
		/**
		 * Delete invitations.
		 *
		 * @since 5.0.0
		 *
		 * @see BP_Invitation::get() for a description of
		 *      accepted where arguments.
		 *
		 * @param array $args Associative array of columns/values, to determine
		 *                    which rows should be deleted.  Of the format
		 *                    array( 'item_id' => 7, 'class' => 'BP_Groups_Invitation_Manager', ).
		 * @return int|bool Number of rows deleted on success, false on failure.
		 */
		public static function delete($args = array())
		{
		}
		/** Convenience methods ***********************************************/
		/**
		 * Delete a single invitation by ID.
		 *
		 * @since 5.0.0
		 *
		 * @see BP_Invitation::delete() for explanation of
		 *      return value.
		 *
		 * @param int $id ID of the invitation item to be deleted.
		 * @return bool|int Number of rows deleted on success, false on failure.
		 */
		public static function delete_by_id($id)
		{
		}
		/** Sent status ***********************************************************/
		/**
		 * Mark specific invitations as sent by invitation ID.
		 *
		 * @since 5.0.0
		 *
		 * @param int   $id   The ID of the invitation to mark as sent.
		 * @param array $args {
		 *     Optional. Invitation characteristics used
		 *     to override certain sending behaviors.
		 *
		 *     @type string $date_modified Modified time in 'Y-m-d h:i:s' format, GMT.
		 *                                 Defaults to current time if not specified.
		 * }
		 * @return int|bool The number of rows updated, or false on error.
		 */
		public static function mark_sent($id = 0, $args = array())
		{
		}
		/**
		 * Mark invitations as sent that are found by user_id, inviter_id, item id, and optional
		 * secondary item id, and class name.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args See BP_Invitation::update().
		 * @return int|bool The number of rows updated, or false on error.
		 */
		public static function mark_sent_by_data($args)
		{
		}
		/** Accepted status ***********************************************************/
		/**
		 * Mark specific invitations as accepted by invitation ID.
		 *
		 * @since 5.0.0
		 *
		 * @param int   $id   The ID of the invitation to mark as sent.
		 * @param array $args {
		 *     Optional. Invitation characteristics used
		 *     to override certain sending behaviors.
		 *
		 *     @type string $date_modified Modified time in 'Y-m-d h:i:s' format, GMT.
		 *                                 Defaults to current time if not specified.
		 * }
		 * @return int|bool The number of rows updated, or false on error.
		 */
		public static function mark_accepted($id = 0, $args = array())
		{
		}
		/**
		 * Mark invitations as accepted that are found by user_id, inviter_id,
		 * item id, and optional secondary item id, and class name.
		 *
		 * @since 5.0.0
		 *
		 * @param array $args See BP_Invitation::update().
		 * @return int|bool The number of rows updated, or false on error.
		 */
		public static function mark_accepted_by_data($args)
		{
		}
	}
	/**
	 * BP Block Class.
	 *
	 * @since 6.0.0
	 */
	class BP_Block
	{
		/**
		 * WP Block Type object.
		 *
		 * @since 6.0.0
		 *
		 * @var WP_Block_Type|WP_Error
		 */
		public $block;
		/**
		 * The script types registered.
		 *
		 * @since 6.0.0
		 *
		 * @var array
		 */
		private $registered_scripts;
		/**
		 * The style types registered.
		 *
		 * @since 6.0.0
		 *
		 * @var array
		 */
		private $registered_styles;
		/**
		 * Construct the BuddyPress Block.
		 *
		 * @since 6.0.0
		 * @since 11.0.0 Add support for WP Block API v2 { apiVersion: 2 }.
		 *
		 * @param array $args {
		 *     The registration arguments for the BP Block. Part of the arguments are the ones
		 *     used by `WP_Block_Type`. Below are BP specific arguments.
		 *
		 *     @type string $editor_script_url   URL to the JavaScript main file of the BP Block
		 *                                       to load into the Block Editor.
		 *     @type array  $editor_script_deps  The list of JavaScript dependency handles for the
		 *                                       BP Block main file.
		 *     @type string $script_url          URL to the JavaScript file to load into the Block
		 *                                       Editor and on front-end.
		 *     @type array  $script_deps         The list of JavaScript dependency handles for the
		 *                                       JavaScript file to load into the Block Editor and
		 *                                       on front-end.
		 *     @type string $view_script_url     URL to the JavaScript file to load on front-end.
		 *     @type array  $view_script_deps    The list of JavaScript dependency handles for the
		 *                                       JavaScript file to load on front-end.
		 *     @type string $editor_style_url    URL to the CSS main file of the BP Block to load
		 *                                       into the Block Editor.
		 *     @type array  $editor_style_deps   The list of CSS dependency handles for the
		 *                                       CSS main file.
		 *     @type string $style_url           URL to the CSS file to load into the Block Editor
		 *                                       and on front-end.
		 *     @type array  $style_deps          The list of CSS dependency handles for the CSS file
		 *                                       to load into the Block Editor and on front-end.
		 *     @type string $domain_path         The path to the folder where custom block translations
		 *                                       are located.
		 *     @type array  $buddypress_contexts The list of BuddyPress contexts a block can be loaded into.
		 * }
		 */
		public function __construct($args)
		{
		}
	}
	/**
	 * Create HTML list of BP nav items.
	 *
	 * @since 1.7.0
	 */
	class BP_Walker_Nav_Menu extends \Walker_Nav_Menu
	{
		/**
		 * Description of fields indexes for building markup.
		 *
		 * @since 1.7.0
		 *
		 * @var array
		 */
		public $db_fields = array('id' => 'css_id', 'parent' => 'parent');
		/**
		 * Tree type.
		 *
		 * @since 1.7.0
		 *
		 * @var string
		 */
		public $tree_type = array();
		/**
		 * Display array of elements hierarchically.
		 *
		 * This method is almost identical to the version in {@link Walker::walk()}.
		 * The only change is on one line which has been commented. An IF was
		 * comparing 0 to a non-empty string which was preventing child elements
		 * being grouped under their parent menu element.
		 *
		 * This caused a problem for BuddyPress because our primary/secondary
		 * navigations don't have a unique numerical ID that describes a
		 * hierarchy (we use a slug). Obviously, WordPress Menus use Posts, and
		 * those have ID/post_parent.
		 *
		 * @since 1.7.0
		 * @since 5.1.0 Method was renamed from `walk` to `do_walk` to ensure PHP 5.3 compatibility
		 *
		 * @see Walker::walk()
		 *
		 * @param array $elements  See {@link Walker::walk()}.
		 * @param int   $max_depth See {@link Walker::walk()}.
		 * @param array $args      Optional additional arguments.
		 * @return string See {@link Walker::walk()}.
		 */
		public function do_walk($elements, $max_depth, $args = array())
		{
		}
		/**
		 * Overrides Walker::walk() method.
		 *
		 * @since 6.0.0 Formalized the existing `...$args` parameter by adding it
		 *              to the function signature to match WordPress 5.3.
		 *
		 * @param array $elements  See {@link Walker::walk()}.
		 * @param int   $max_depth See {@link Walker::walk()}.
		 * @param mixed ...$args   See {@link Walker::walk()}.
		 */
		public function walk($elements, $max_depth, ...$args)
		{
		}
		/**
		 * Display the current <li> that we are on.
		 *
		 * @see Walker::start_el() for complete description of parameters.
		 *
		 * @since 1.7.0
		 *
		 * @param string   $output Passed by reference. Used to append
		 *                         dditional content.
		 * @param object   $item   Menu item data object.
		 * @param int      $depth  Optional. Depth of menu item. Used for padding.
		 *                         Defaults to 0.
		 * @param stdClass $args   Optional. See {@link Walker::start_el()}.
		 * @param int      $id     Menu item ID. Optional.
		 */
		public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
		{
		}
	}
	/**
	 * Enable oEmbeds in BuddyPress contexts.
	 *
	 * Extends WP_Embed class for use with BuddyPress.
	 *
	 * @since 1.5.0
	 *
	 * @see WP_Embed
	 */
	class BP_Embed extends \WP_Embed
	{
		/**
		 * Constructor
		 *
		 * @global WP_Embed $wp_embed
		 */
		public function __construct()
		{
		}
		/**
		 * The {@link do_shortcode()} callback function.
		 *
		 * Attempts to convert a URL into embed HTML. Starts by checking the
		 * URL against the regex of the registered embed handlers. Next, checks
		 * the URL against the regex of registered {@link WP_oEmbed} providers
		 * if oEmbed discovery is false. If none of the regex matches and it's
		 * enabled, then the URL will be passed to {@link BP_Embed::parse_oembed()}
		 * for oEmbed parsing.
		 *
		 * @param array  $attr Shortcode attributes.
		 * @param string $url  The URL attempting to be embeded.
		 * @return string The embed HTML on success, otherwise the original URL.
		 */
		public function shortcode($attr, $url = '')
		{
		}
		/**
		 * Base function so BP components/plugins can parse links to be embedded.
		 *
		 * View an example to add support in {@link bp_activity_embed()}.
		 *
		 *       on success.
		 *       oEmbed failure.
		 *
		 * @param int    $id      ID to do the caching for.
		 * @param string $url     The URL attempting to be embedded.
		 * @param array  $attr    Shortcode attributes from {@link WP_Embed::shortcode()}.
		 * @param array  $rawattr Untouched shortcode attributes from
		 *                        {@link WP_Embed::shortcode()}.
		 * @return string The embed HTML on success, otherwise the original URL.
		 */
		public function parse_oembed($id, $url, $attr, $rawattr)
		{
		}
	}
	/**
	 * API for responding and returning a custom oEmbed request.
	 *
	 * @since 2.6.0
	 */
	abstract class BP_Core_oEmbed_Extension
	{
		/** START PROPERTIES ****************************************************/
		/**
		 * (required) The slug endpoint.
		 *
		 * Should be your component id.
		 *
		 * @since 2.6.0
		 *
		 * @var string
		 */
		public $slug_endpoint = '';
		/** END PROPERTIES ******************************************************/
		/**
		 * Constructor.
		 */
		public final function __construct()
		{
		}
		/** REQUIRED METHODS ****************************************************/
		/**
		 * Add content for your oEmbed response here.
		 *
		 * @since 2.6.0
		 */
		protected abstract function content();
		/**
		 * Add a check for when you are on the page you want to oEmbed.
		 *
		 * You'll want to return a boolean here. eg. bp_is_single_activity().
		 *
		 * @since 2.6.0
		 *
		 * @return bool
		 */
		protected abstract function is_page();
		/**
		 * Validate the URL to see if it matches your item ID.
		 *
		 * @since 2.6.0
		 *
		 * @param string $url URL to validate.
		 * @return int Your item ID
		 */
		protected abstract function validate_url_to_item_id($url);
		/**
		 * Set the oEmbed response data.
		 *
		 * @since 2.6.0
		 *
		 * @param int $item_id Your item ID to do checks against.
		 * @return array Should contain 'content', 'title', 'author_url', 'author_name' as array
		 *               keys. 'author_url' and 'author_name' is optional; the rest are required.
		 */
		protected abstract function set_oembed_response_data($item_id);
		/**
		 * Sets the fallback HTML for the oEmbed response.
		 *
		 * In a WordPress oEmbed item, the fallback HTML is a <blockquote>.  This is
		 * usually hidden after the <iframe> is loaded.
		 *
		 * @since 2.6.0
		 *
		 * @param int $item_id Your item ID to do checks against.
		 * @return string Fallback HTML you want to output.
		 */
		protected abstract function set_fallback_html($item_id);
		/** OPTIONAL METHODS ****************************************************/
		/**
		 * If your oEmbed endpoint requires additional arguments, set them here.
		 *
		 * @see register_rest_route() View the $args parameter for more info.
		 *
		 * @since 2.6.0
		 *
		 * @return array
		 */
		protected function set_route_args()
		{
		}
		/**
		 * Set the iframe title.
		 *
		 * If not set, this will fallback to WP's 'Embedded WordPress Post'.
		 *
		 * @since 2.6.0
		 *
		 * @param int $item_id The item ID to do checks for.
		 */
		protected function set_iframe_title($item_id)
		{
		}
		// phpcs:ignore Generic.CodeAnalysis.UnusedFunctionParameter.Found
		/**
		 * Do what you need to do here to initialize any custom hooks.
		 *
		 * @since 2.6.0
		 */
		protected function custom_hooks()
		{
		}
		/**
		 * Set permalink for oEmbed link discovery.
		 *
		 * This method will be called on the page we want to oEmbed.  In most cases,
		 * you will not need to override this method.  However, if you need to, do
		 * override in your extended class.
		 *
		 * @since 2.6.0
		 *
		 * @return string
		 */
		protected function set_permalink()
		{
		}
		/** HELPERS *************************************************************/
		/**
		 * Get the item ID when filtering the oEmbed HTML.
		 *
		 * Should only be used during the 'embed_html' hook.
		 *
		 * @since 2.6.0
		 *
		 * @return int
		 */
		protected function get_item_id()
		{
		}
		/** SET UP **************************************************************/
		/**
		 * Set up properties.
		 *
		 * @since 2.6.0
		 */
		protected function setup_properties()
		{
		}
		/**
		 * Hooks! We do the dirty work here, so you don't have to! :)
		 *
		 * More hooks are available in the setup_template_parts() method.
		 *
		 * @since 2.6.0
		 */
		protected function setup_hooks()
		{
		}
		/** HOOKS ***************************************************************/
		/**
		 * Register the oEmbed REST API route.
		 *
		 * @since 2.6.0
		 */
		public function register_route()
		{
		}
		/**
		 * Set up custom embed template parts for BuddyPress use.
		 *
		 * @since 2.6.0
		 *
		 * @param string $template File path to current embed template.
		 * @return string
		 */
		public function setup_template_parts($template)
		{
		}
		/**
		 * Start object buffer.
		 *
		 * We're going to override WP's get_template_part( 'embed, 'content' ) call
		 * and inject our own template for BuddyPress use.
		 *
		 * @since 2.6.0
		 *
		 * @param string $slug Template slug.
		 * @param string $name Template name.
		 */
		public function content_buffer_start($slug, $name)
		{
		}
		/**
		 * End object buffer.
		 *
		 * We're going to override WP's get_template_part( 'embed, 'content' ) call
		 * and inject our own template for BuddyPress use.
		 *
		 * @since 2.6.0
		 *
		 * @param string $name Template name.
		 */
		public function content_buffer_end($name)
		{
		}
		/**
		 * Adds oEmbed discovery links on single activity pages.
		 *
		 * @since 2.6.0
		 *
		 * @param string $retval Current discovery links.
		 * @return string
		 */
		public function add_oembed_discovery_links($retval)
		{
		}
		/**
		 * Fetch our oEmbed response data to return.
		 *
		 * A simplified version of {@see get_oembed_response_data()}.
		 *
		 * @since 2.6.0
		 *
		 * @link http://oembed.com/ View the 'Response parameters' section for more details.
		 *
		 * @param array $item  Custom oEmbed response data.
		 * @param int   $width The requested width.
		 * @return array
		 */
		protected function get_oembed_response_data($item, $width)
		{
		}
		/**
		 * Callback for the API endpoint.
		 *
		 * Returns the JSON object for the item.
		 *
		 * @since 2.6.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return WP_Error|array oEmbed response data or WP_Error on failure.
		 */
		public function get_item($request)
		{
		}
		/**
		 * If oEmbed request wants XML, return XML instead of JSON.
		 *
		 * Basically a copy of {@link _oembed_rest_pre_serve_request()}. Unfortunate
		 * that we have to duplicate this just for a URL check.
		 *
		 * @since 2.6.0
		 *
		 * @param bool                      $served  Whether the request has already been served.
		 * @param WP_HTTP_ResponseInterface $result  Result to send to the client. Usually a WP_REST_Response.
		 * @param WP_REST_Request           $request Request used to generate the response.
		 * @param WP_REST_Server            $server  Server instance.
		 * @return bool
		 */
		public function oembed_xml_request($served, $result, $request, $server)
		{
		}
		/**
		 * Pass our BuddyPress activity permalink for embedding.
		 *
		 * @since 2.6.0
		 *
		 * @see bp_activity_embed_rest_route_callback()
		 *
		 * @param string $retval Current embed URL.
		 * @return string
		 */
		public function filter_embed_url($retval)
		{
		}
		/**
		 * Filters the embed HTML for our BP oEmbed endpoint.
		 *
		 * @since 2.6.0
		 *
		 * @param string $retval Current embed HTML.
		 * @return string
		 */
		public function filter_embed_html($retval)
		{
		}
		/**
		 * Append our custom slug endpoint to oEmbed endpoint URL.
		 *
		 * Meant to be used as a filter on 'rest_url' before any call to
		 * {@link get_oembed_endpoint_url()} is used.
		 *
		 * @since 2.6.0
		 *
		 * @see add_oembed_discovery_links()
		 *
		 * @param string $retval Current oEmbed endpoint URL.
		 * @return string
		 */
		public function filter_rest_url($retval = '')
		{
		}
		/**
		 * Inject content into the embed template.
		 *
		 * @since 2.6.0
		 */
		public function inject_content()
		{
		}
	}
	/**
	 * BP Attachment Cover Image class.
	 *
	 * Extends BP Attachment to manage the cover images uploads.
	 *
	 * @since 2.4.0
	 */
	#[\AllowDynamicProperties]
	class BP_Attachment_Cover_Image extends \BP_Attachment
	{
		/**
		 * The constuctor.
		 *
		 * @since 2.4.0
		 */
		public function __construct()
		{
		}
		/**
		 * Gets the available cover image types.
		 *
		 * @since 2.4.0
		 *
		 * @param array $allowed_types Array of allowed cover image types.
		 * @return string $value Comma-separated list of allowed cover image types.
		 */
		public static function get_cover_image_types($allowed_types = array())
		{
		}
		/**
		 * Cover image specific rules.
		 *
		 * Adds an error if the cover image size or type don't match BuddyPress needs.
		 * The error code is the index of $upload_error_strings.
		 *
		 * @since 2.4.0
		 *
		 * @param array $file The temporary file attributes (before it has been moved).
		 * @return array $file The file with extra errors if needed.
		 */
		public function validate_upload($file = array())
		{
		}
		/**
		 * Set the directory when uploading a file.
		 *
		 * @since 2.4.0
		 *
		 * @param array $upload_dir The original Uploads dir.
		 * @return array $value Upload data (path, url, basedir...).
		 */
		public function upload_dir_filter($upload_dir = array())
		{
		}
		/**
		 * Adjust the cover image to fit with advised width & height.
		 *
		 * @since 2.4.0
		 *
		 * @param string $file       The absolute path to the file.
		 * @param array  $dimensions Array of dimensions for the cover image.
		 * @return mixed
		 */
		public function fit($file = '', $dimensions = array())
		{
		}
		/**
		 * Generate a filename for the cover image.
		 *
		 * @since 2.4.0
		 *
		 * @param string $file The absolute path to the file.
		 * @return false|string
		 */
		public function generate_filename($file = '')
		{
		}
		/**
		 * Build script datas for the Uploader UI.
		 *
		 * @since 2.4.0
		 *
		 * @return array The javascript localization data
		 */
		public function script_data()
		{
		}
	}
	/**
	 * Base class for creating query classes that generate SQL fragments for filtering results based on recursive query params.
	 *
	 * @since 2.2.0
	 */
	abstract class BP_Recursive_Query
	{
		/**
		 * Query arguments passed to the constructor.
		 *
		 * @since 2.2.0
		 *
		 * @var array
		 */
		public $queries = array();
		/**
		 * Generate SQL clauses to be appended to a main query.
		 *
		 * Extending classes should call this method from within a publicly
		 * accessible get_sql() method, and manipulate the SQL as necessary.
		 * For example, {@link BP_XProfile_Query::get_sql()} is merely a wrapper for
		 * get_sql_clauses(), while {@link BP_Activity_Query::get_sql()} discards
		 * the empty 'join' clause, and only passes the 'where' clause.
		 *
		 * @since 2.2.0
		 *
		 * @return array
		 */
		protected function get_sql_clauses()
		{
		}
		/**
		 * Generate SQL clauses for a single query array.
		 *
		 * If nested subqueries are found, this method recurses the tree to
		 * produce the properly nested SQL.
		 *
		 * Subclasses generally do not need to call this method. It is invoked
		 * automatically from get_sql_clauses().
		 *
		 * @since 2.2.0
		 *
		 * @param  array $query Query to parse.
		 * @param  int   $depth Optional. Number of tree levels deep we
		 *                      currently are. Used to calculate indentation.
		 * @return array
		 */
		protected function get_sql_for_query($query, $depth = 0)
		{
		}
		/**
		 * Recursive-friendly query sanitizer.
		 *
		 * Ensures that each query-level clause has a 'relation' key, and that
		 * each first-order clause contains all the necessary keys from
		 * $defaults.
		 *
		 * Extend this method if your class uses different sanitizing logic.
		 *
		 * @since 2.2.0
		 *
		 * @param array $queries Array of query clauses.
		 *
		 * @return array Sanitized array of query clauses.
		 */
		protected function sanitize_query($queries)
		{
		}
		/**
		 * Generate JOIN and WHERE clauses for a first-order clause.
		 *
		 * Must be overridden in a subclass.
		 *
		 * @since 2.2.0
		 *
		 * @param array $clause       Array of arguments belonging to the clause.
		 * @param array $parent_query Parent query to which the clause belongs.
		 *
		 * @return array {
		 *     @type array $join  Array of subclauses for the JOIN statement.
		 *     @type array $where Array of subclauses for the WHERE statement.
		 * }
		 */
		protected abstract function get_sql_for_clause($clause, $parent_query);
		/**
		 * Determine whether a clause is first-order.
		 *
		 * Must be overridden in a subclass.
		 *
		 * @since 2.2.0
		 *
		 * @param array $query Clause to check.
		 *
		 * @return bool
		 */
		protected abstract function is_first_order_clause($query);
	}
	/**
	 * Creates the Core component.
	 *
	 * @since 1.5.0
	 */
	#[\AllowDynamicProperties]
	class BP_Core extends \BP_Component
	{
		/**
		 * Start the members component creation process.
		 *
		 * @since 1.5.0
		 */
		public function __construct()
		{
		}
		/**
		 * Magic getter.
		 *
		 * This exists specifically for supporting deprecated object vars.
		 *
		 * @since 7.0.0
		 *
		 * @param string $key The object var to get.
		 * @return mixed
		 */
		public function __get($key = '')
		{
		}
		/**
		 * Populate the global data needed before BuddyPress can continue.
		 *
		 * This involves figuring out the currently required, activated, deactivated,
		 * and optional components.
		 *
		 * @since 1.5.0
		 */
		private function bootstrap()
		{
		}
		/**
		 * Include bp-core files.
		 *
		 * @since 1.6.0
		 *
		 * @see BP_Component::includes() for description of parameters.
		 *
		 * @param array $includes See {@link BP_Component::includes()}.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Set up bp-core global settings.
		 *
		 * Sets up a majority of the BuddyPress globals that require a minimal
		 * amount of processing, meaning they cannot be set in the BuddyPress class.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_globals() for description of parameters.
		 *
		 * @param array $args See {@link BP_Component::setup_globals()}.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Setup cache groups
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Set up post types.
		 *
		 * @since 2.4.0
		 * @since 12.0.0 Registers the 'buddypress' post type for component directories.
		 */
		public function register_post_types()
		{
		}
		/**
		 * Parse the WP_Query and eventually set the BP Search mechanism.
		 *
		 * Search doesn't have an associated page, so we check for it separately.
		 *
		 * @since 12.0.0
		 *
		 * @param WP_Query $query Required. See BP_Component::parse_query() for
		 *                        description.
		 */
		public function parse_query($query)
		{
		}
		/**
		 * Init the Core controllers of the BP REST API.
		 *
		 * @since 9.0.0
		 *
		 * @param array $controllers Optional. See BP_Component::rest_api_init() for
		 *                           description.
		 */
		public function rest_api_init($controllers = array())
		{
		}
		/**
		 * Register the BP Core Blocks.
		 *
		 * @since 9.0.0
		 * @since 12.0.0 Use the WP Blocks API v2.
		 *
		 * @param array $blocks Optional. See BP_Component::blocks_init() for
		 *                      description.
		 */
		public function blocks_init($blocks = array())
		{
		}
	}
	/**
	 * BuddyPress opt-outs.
	 *
	 * Use this class to create, access, edit, or delete BuddyPress Nonmember Opt-outs.
	 *
	 * @since 8.0.0
	 */
	class BP_Optout
	{
		/**
		 * The opt-out ID.
		 *
		 * @since 8.0.0
		 *
		 * @var int
		 */
		public $id;
		/**
		 * The hashed email address of the user that wishes to opt out of
		 * communications from this site.
		 *
		 * @since 8.0.0
		 *
		 * @var string
		 */
		public $email_address;
		/**
		 * The ID of the user that generated the contact that resulted in the opt-out.
		 *
		 * @since 8.0.0
		 *
		 * @var int
		 */
		public $user_id;
		/**
		 * The type of email contact that resulted in the opt-out.
		 * This should be one of the known BP_Email types.
		 *
		 * @since 8.0.0
		 *
		 * @var string
		 */
		public $email_type;
		/**
		 * The date the opt-out was last modified.
		 *
		 * @since 8.0.0
		 *
		 * @var string
		 */
		public $date_modified;
		/** Public Methods ****************************************************/
		/**
		 * Constructor method.
		 *
		 * @since 8.0.0
		 *
		 * @param int $id Optional. Provide an ID to access an existing optout item.
		 */
		public function __construct($id = 0)
		{
		}
		/**
		 * Get the opt-outs table name.
		 *
		 * @since 8.0.0
		 *
		 * @return string
		 */
		public static function get_table_name()
		{
		}
		/**
		 * Update or insert opt-out details into the database.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Fetch data for an existing opt-out from the database.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function populate()
		{
		}
		/** Protected Static Methods ******************************************/
		/**
		 * Create an opt-out entry.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $data {
		 *     Array of optout data, passed to {@link wpdb::insert()}.
		 *     @type string $email_address     The hashed email address of the user that wishes to opt out of
		 *                                     communications from this site.
		 *     @type int    $user_id           The ID of the user that generated the contact that resulted in the opt-out.
		 *     @type string $email_type        The type of email contact that resulted in the opt-out.
		 *     @type string $date_modified     Date the opt-out was last modified.
		 * }
		 * @param array $data_format See {@link wpdb::insert()}.
		 * @return int|false The number of rows inserted, or false on error.
		 */
		protected static function _insert($data = array(), $data_format = array())
		{
		}
		/**
		 * Update opt-outs.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see wpdb::update() for further description of paramater formats.
		 *
		 * @param array $data         Array of opt-out data to update, passed to
		 *                            {@link wpdb::update()}. Accepts any property of a
		 *                            BP_optout object.
		 * @param array $where        The WHERE params as passed to wpdb::update().
		 *                            Typically consists of array( 'ID' => $id ) to specify the ID
		 *                            of the item being updated. See {@link wpdb::update()}.
		 * @param array $data_format  See {@link wpdb::insert()}.
		 * @param array $where_format See {@link wpdb::insert()}.
		 * @return int|false The number of rows updated, or false on error.
		 */
		protected static function _update($data = array(), $where = array(), $data_format = array(), $where_format = array())
		{
		}
		/**
		 * Delete opt-outs.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see wpdb::update() for further description of paramater formats.
		 *
		 * @param array $where        Array of WHERE clauses to filter by, passed to
		 *                            {@link wpdb::delete()}. Accepts any property of a
		 *                            BP_optout object.
		 * @param array $where_format See {@link wpdb::insert()}.
		 * @return int|false The number of rows updated, or false on error.
		 */
		protected static function _delete($where = array(), $where_format = array())
		{
		}
		/**
		 * Assemble the WHERE clause of a get() SQL statement.
		 *
		 * Used by BP_optout::get() to create its WHERE
		 * clause.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args See {@link BP_optout::get()} for more details.
		 * @return string WHERE clause.
		 */
		protected static function get_where_sql($args = array())
		{
		}
		/**
		 * Assemble the ORDER BY clause of a get() SQL statement.
		 *
		 * Used by BP_Optout::get() to create its ORDER BY
		 * clause.
		 *
		 * @since 8.0.0
		 *
		 * @param array $args See {@link BP_optout::get()} for more details.
		 * @return string ORDER BY clause.
		 */
		protected static function get_order_by_sql($args = array())
		{
		}
		/**
		 * Assemble the LIMIT clause of a get() SQL statement.
		 *
		 * Used by BP_Optout::get() to create its LIMIT clause.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args See {@link BP_optout::get()} for more details.
		 * @return string LIMIT clause.
		 */
		protected static function get_paged_sql($args = array())
		{
		}
		/**
		 * Assemble query clauses, based on arguments, to pass to $wpdb methods.
		 *
		 * The insert(), update(), and delete() methods of {@link wpdb} expect
		 * arguments of the following forms:
		 *
		 * - associative arrays whose key/value pairs are column => value, to
		 *   be used in WHERE, SET, or VALUES clauses
		 * - arrays of "formats", which tell $wpdb->prepare() which type of
		 *   value to expect when sanitizing (eg, array( '%s', '%d' ))
		 *
		 * This utility method can be used to assemble both kinds of params,
		 * out of a single set of associative array arguments, such as:
		 *
		 *     $args = array(
		 *         'user_id'    => 4,
		 *         'email_type' => 'type_string',
		 *     );
		 *
		 * This will be converted to:
		 *
		 *     array(
		 *         'data' => array(
		 *             'user_id' => 4,
		 *             'email_type'   => 'type_string',
		 *         ),
		 *         'format' => array(
		 *             '%d',
		 *             '%s',
		 *         ),
		 *     )
		 *
		 * which can easily be passed as arguments to the $wpdb methods.
		 *
		 * @since 8.0.0
		 *
		 * @param array $args Associative array of filter arguments.
		 *                    See {@BP_optout::get()} for a breakdown.
		 * @return array Associative array of 'data' and 'format' args.
		 */
		protected static function get_query_clauses($args = array())
		{
		}
		/** Public Static Methods *********************************************/
		/**
		 * Get opt-outs, based on provided filter parameters.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *     Associative array of arguments. All arguments but $page and
		 *     $per_page can be treated as filter values for get_where_sql()
		 *     and get_query_clauses(). All items are optional.
		 *     @type int|array    $id                ID of opt-out.
		 *                                           Can be an array of IDs.
		 *     @type string|array $email_address     Email address of users who have opted out
		 *                                           being queried. Can be an array of addresses.
		 *     @type int|array    $user_id           ID of user whose communication prompted the
		 *                                           opt-out. Can be an array of IDs.
		 *     @type string|array $email_type        Name of the emil type to filter by.
		 *                                           Can be an array of email types.
		 *     @type string       $search_terms      Term to match against email_address field.
		 *     @type string       $order_by          Database column to order by.
		 *     @type string       $sort_order        Either 'ASC' or 'DESC'.
		 *     @type int          $page              Number of the current page of results.
		 *                                           Default: false (no pagination,
		 *                                           all items).
		 *     @type int          $per_page          Number of items to show per page.
		 *                                           Default: false (no pagination,
		 *                                           all items).
		 *     @type string       $fields            Which fields to return. Specify 'email_addresses' to
		 *                                           fetch a list of opt-out email_addresses.
		 *                                           Specify 'user_ids' to
		 *                                           fetch a list of opt-out user_ids.
		 *                                           Specify 'ids' to fetch a list of opt-out IDs.
		 *                                           Default: 'all' (return BP_Optout objects).
		 * }
		 *
		 * @return array BP_Optout objects | IDs of found opt-outs | Email addresses of matches.
		 */
		public static function get($args = array())
		{
		}
		/**
		 * Get a count of total optouts matching a set of arguments.
		 *
		 * @since 8.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see BP_optout::get() for a description of
		 *      arguments.
		 *
		 * @param array $args See {@link BP_optout::get()}.
		 * @return int Count of located items.
		 */
		public static function get_total_count($args)
		{
		}
		/**
		 * Update optouts.
		 *
		 * @since 8.0.0
		 *
		 * @see BP_optout::get() for a description of
		 *      accepted update/where arguments.
		 *
		 * @param array $update_args Associative array of fields to update,
		 *                           and the values to update them to. Of the format
		 *                           array( 'user_id' => 4, 'email_address' => 'bar@foo.com', ).
		 * @param array $where_args  Associative array of columns/values, to
		 *                           determine which rows should be updated. Of the format
		 *                           array( 'user_id' => 7, 'email_address' => 'bar@foo.com', ).
		 * @return int|bool Number of rows updated on success, false on failure.
		 */
		public static function update($update_args = array(), $where_args = array())
		{
		}
		/**
		 * Delete opt-outs.
		 *
		 * @since 8.0.0
		 *
		 * @see BP_optout::get() for a description of
		 *      accepted where arguments.
		 *
		 * @param array $args Associative array of columns/values, to determine
		 *                    which rows should be deleted.  Of the format
		 *                    array( 'user_id' => 7, 'email_address' => 'bar@foo.com', ).
		 * @return int|bool Number of rows deleted on success, false on failure.
		 */
		public static function delete($args = array())
		{
		}
		/** Convenience methods ***********************************************/
		/**
		 * Check whether an invitation exists matching the passed arguments.
		 *
		 * @since 5.0.0
		 *
		 * @see BP_Optout::get() for a description of accepted parameters.
		 *
		 * @param array $args Arguments to pass to BP_optout::get().
		 * @return int|bool ID of first found invitation or false if none found.
		 */
		public function optout_exists($args = array())
		{
		}
		/**
		 * Delete a single opt-out by ID.
		 *
		 * @since 8.0.0
		 *
		 * @see BP_optout::delete() for explanation of
		 *      return value.
		 *
		 * @param int $id ID of the opt-out item to be deleted.
		 * @return bool|int Number of rows deleted on success, false on failure.
		 */
		public static function delete_by_id($id)
		{
		}
	}
	/**
	 * BP_Email_Recipient class.
	 *
	 * @since 2.5.0
	 */
	class BP_Email_Recipient extends \BP_Email_Participant
	{
		/**
		 * Optional. A `WP_User` object relating to this recipient.
		 *
		 * @since 2.5.0
		 *
		 * @var WP_User|null
		 */
		protected $user_object = \null;
		/**
		 * Constructor.
		 *
		 * @since 2.5.0
		 *
		 * @param string|array|int|WP_User $email_or_user Either a email address, user ID, WP_User object,
		 *                                                or an array containing any combination of the above.
		 * @param string                   $name          Optional. If $email_or_user is a string, this is the
		 *                                                recipient's name.
		 */
		public function __construct($email_or_user, $name = '')
		{
		}
		/**
		 * Get recipient's address.
		 *
		 * @since 2.5.0
		 *
		 * @return string
		 */
		public function get_address()
		{
		}
		/**
		 * Get recipient's name.
		 *
		 * @since 2.5.0
		 *
		 * @return string
		 */
		public function get_name()
		{
		}
		/**
		 * Get WP_User object for this recipient.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'search-email'.
		 * @return WP_User|null WP_User object, or null if not set.
		 */
		public function get_user($transform = 'raw')
		{
		}
	}
	/**
	 * BP_Email_Sender class.
	 */
	class BP_Email_Sender extends \BP_Email_Participant
	{
	}
	/**
	 * BuddyPress Login Widget.
	 *
	 * @since 1.9.0
	 * @deprecated 12.0.0
	 */
	class BP_Core_Login_Widget
	{
		/**
		 * Constructor method.
		 *
		 * @since 1.9.0
		 * @since 9.0.0 Adds the `show_instance_in_rest` property to Widget options.
		 * @deprecated 12.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Display the login widget.
		 *
		 * @since 1.9.0
		 * @deprecated 12.0.0
		 *
		 * @see WP_Widget::widget() for description of parameters.
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Widget settings, as saved by the user.
		 */
		public function widget($args, $instance)
		{
		}
		/**
		 * Update the login widget options.
		 *
		 * @since 1.9.0
		 * @deprecated 12.0.0
		 *
		 * @param array $new_instance The new instance options.
		 * @param array $old_instance The old instance options.
		 */
		public function update($new_instance, $old_instance)
		{
		}
		/**
		 * Output the login widget options form.
		 *
		 * @since 1.9.0
		 * @deprecated 12.0.0
		 *
		 * @param array $instance Settings for this widget.
		 */
		public function form($instance = array())
		{
		}
	}
	/**
	 * Extracts media from text. Use {@link extract()}.
	 *
	 * @since 2.3.0
	 *
	 * The supported types are links, mentions, images, shortcodes, embeds, audio, video, and "all".
	 * This is what each type extracts:
	 *
	 * Links:      <a href="http://example.com">
	 * Mentions:   @name
	 *             If the Activity component is enabled, we use it to parse out any at-names. A consequence
	 *             to note is that the "name" mentioned must match a real user account. If it's a made-up
	 *             at-name, then it isn't extracted.
	 *             If the Activity component is disabled, any at-name is extracted (both those matching
	 *             real accounts, and those made-up).
	 * Images:     <img src="image.gif">, [gallery], [gallery ids="2,3"], featured images (Post thumbnails).
	 *             If an extracted image is in the Media Library, then its resolution will be included.
	 * Shortcodes: Extract information about any (registered) shortcodes.
	 *             This includes any shortcodes indirectly covered by any of the other media extraction types.
	 *             For example, [gallery].
	 * Embeds:     Extract any URL matching a registered oEmbed handler.
	 * Audio:      <a href="*.mp3"">, [audio]
	 *             See wp_get_audio_extensions() for supported audio formats.
	 * Video:      [video]
	 *             See wp_get_video_extensions() for supported video formats.
	 *
	 * @see BP_Media_Extractor::extract() Use this to extract media.
	 */
	class BP_Media_Extractor
	{
		/**
		 * Media type.
		 *
		 * @since 2.3.0
		 * @var int
		 */
		const ALL = 255;
		const LINKS = 1;
		const MENTIONS = 2;
		const IMAGES = 4;
		const SHORTCODES = 8;
		const EMBEDS = 16;
		const AUDIO = 32;
		const VIDEOS = 64;
		/**
		 * Extract media from text.
		 *
		 * @since 2.3.0
		 *
		 * @param string|WP_Post $richtext        Content to parse.
		 * @param int            $what_to_extract Media type to extract (optional).
		 * @param array          $extra_args      Bespoke data for a particular extractor (optional).
		 * @return array {
		 *     @type array $has Extracted media counts. {
		 *         @type int $audio
		 *         @type int $embeds
		 *         @type int $images
		 *         @type int $links
		 *         @type int $mentions
		 *         @type int $shortcodes
		 *         @type int $video
		 *     }
		 *     @type array $audio Extracted audio. {
		 *         Array of extracted media.
		 *
		 *         @type string $source Media source. Either "html" or "shortcodes".
		 *         @type string $url    Link to audio.
		 *     }
		 *     @type array $embeds Extracted oEmbeds. {
		 *         Array of extracted media.
		 *
		 *         @type string $url oEmbed link.
		 *     }
		 *     @type array $images Extracted images. {
		 *         Array of extracted media.
		 *
		 *         @type int    $gallery_id Gallery ID. Optional, not always set.
		 *         @type int    $height     Width of image. If unknown, set to 0.
		 *         @type string $source     Media source. Either "html" or "galleries".
		 *         @type string $url        Link to image.
		 *         @type int    $width      Width of image. If unknown, set to 0.
		 *     }
		 *     @type array $links Extracted URLs. {
		 *         Array of extracted media.
		 *
		 *         @type string $url Link.
		 *     }
		 *     @type array $mentions Extracted mentions. {
		 *         Array of extracted media.
		 *
		 *         @type string $name    @mention.
		 *         @type string $user_id User ID. Optional, only set if Activity component enabled.
		 *     }
		 *     @type array $shortcodes Extracted shortcodes. {
		 *         Array of extracted media.
		 *
		 *         @type array  $attributes Key/value pairs of the shortcodes attributes (if any).
		 *         @type string $content    Text wrapped by the shortcode.
		 *         @type string $type       Shortcode type.
		 *         @type string $original   The entire shortcode.
		 *     }
		 *     @type array $videos Extracted video. {
		 *         Array of extracted media.
		 *
		 *         @type string $source Media source. Currently only "shortcodes".
		 *         @type string $url    Link to audio.
		 *     }
		 * }
		 */
		public function extract($richtext, $what_to_extract = self::ALL, $extra_args = array())
		{
		}
		/**
		 * Content type specific extraction methods.
		 *
		 * You shouldn't need to use these directly; just use {@link BP_Media_Extractor::extract()}.
		 */
		/**
		 * Extract `<a href>` tags from text.
		 *
		 * @since 2.3.0
		 *
		 * @param string $richtext   Content to parse.
		 * @param string $plaintext  Sanitized version of the content.
		 * @param array  $extra_args Bespoke data for a particular extractor (optional).
		 * @return array {
		 *     @type array $has Extracted media counts. {
		 *         @type int $links
		 *     }
		 *     @type array $links Extracted URLs. {
		 *         Array of extracted media.
		 *
		 *         @type string $url Link.
		 *     }
		 * }
		 */
		protected function extract_links($richtext, $plaintext, $extra_args = array())
		{
		}
		/**
		 * Extract @mentions tags from text.
		 *
		 * If the Activity component is enabled, it is used to parse @mentions.
		 * The mentioned "name" must match a user account, otherwise it is discarded.
		 *
		 * If the Activity component is disabled, any @mentions are extracted.
		 *
		 * @since 2.3.0
		 *
		 * @param string $richtext   Content to parse.
		 * @param string $plaintext  Sanitized version of the content.
		 * @param array  $extra_args Bespoke data for a particular extractor.
		 * @return array {
		 *     @type array $has Extracted media counts. {
		 *         @type int $mentions
		 *     }
		 *     @type array $mentions Extracted mentions. {
		 *         Array of extracted media.
		 *
		 *         @type string $name    @mention.
		 *         @type string $user_id User ID. Optional, only set if Activity component enabled.
		 *     }
		 * }
		 */
		protected function extract_mentions($richtext, $plaintext, $extra_args = array())
		{
		}
		/**
		 * Extract images from `<img src>` tags, [galleries], and featured images from a Post.
		 *
		 * If an image is in the Media Library, then its resolution is included in the results.
		 *
		 * @since 2.3.0
		 *
		 * @param string $richtext   Content to parse.
		 * @param string $plaintext  Sanitized version of the content.
		 * @param array  $extra_args Bespoke data for a particular extractor (optional).
		 * @return array {
		 *     @type array $has Extracted media counts. {
		 *         @type int $images
		 *     }
		 *     @type array $images Extracted images. {
		 *         Array of extracted media.
		 *
		 *         @type int    $gallery_id Gallery ID. Optional, not always set.
		 *         @type int    $height     Width of image. If unknown, set to 0.
		 *         @type string $source     Media source. Either "html" or "galleries".
		 *         @type string $url        Link to image.
		 *         @type int    $width      Width of image. If unknown, set to 0.
		 *     }
		 * }
		 */
		protected function extract_images($richtext, $plaintext, $extra_args = array())
		{
		}
		/**
		 * Extract shortcodes from text.
		 *
		 * This includes any shortcodes indirectly used by other media extraction types.
		 * For example, [gallery] and [audio].
		 *
		 * @since 2.3.0
		 *
		 * @param string $richtext   Content to parse.
		 * @param string $plaintext  Sanitized version of the content.
		 * @param array  $extra_args Bespoke data for a particular extractor (optional).
		 * @return array {
		 *     @type array $has Extracted media counts. {
		 *         @type int $shortcodes
		 *     }
		 *     @type array $shortcodes Extracted shortcodes. {
		 *         Array of extracted media.
		 *
		 *         @type array  $attributes Key/value pairs of the shortcodes attributes (if any).
		 *         @type string $content    Text wrapped by the shortcode.
		 *         @type string $type       Shortcode type.
		 *         @type string $original   The entire shortcode.
		 *     }
		 * }
		 */
		protected function extract_shortcodes($richtext, $plaintext, $extra_args = array())
		{
		}
		/**
		 * Extract any URL, matching a registered oEmbed endpoint, from text.
		 *
		 * @since 2.3.0
		 *
		 * @param string $richtext   Content to parse.
		 * @param string $plaintext  Sanitized version of the content.
		 * @param array  $extra_args Bespoke data for a particular extractor (optional).
		 * @return array {
		 *     @type array $has Extracted media counts. {
		 *         @type int $embeds
		 *     }
		 *     @type array $embeds Extracted oEmbeds. {
		 *         Array of extracted media.
		 *
		 *         @type string $url oEmbed link.
		 *     }
		 * }
		 */
		protected function extract_embeds($richtext, $plaintext, $extra_args = array())
		{
		}
		/**
		 * Extract [audio] shortcodes and `<a href="*.mp3">` tags, from text.
		 *
		 * @since 2.3.0
		 *
		 * @see wp_get_audio_extensions() for supported audio formats.
		 *
		 * @param string $richtext   Content to parse.
		 * @param string $plaintext  Sanitized version of the content.
		 * @param array  $extra_args Bespoke data for a particular extractor (optional).
		 * @return array {
		 *     @type array $has Extracted media counts. {
		 *         @type int $audio
		 *     }
		 *     @type array $audio Extracted audio. {
		 *         Array of extracted media.
		 *
		 *         @type string $original The entire shortcode.
		 *         @type string $source   Media source. Either "html" or "shortcodes".
		 *         @type string $url      Link to audio.
		 *     }
		 * }
		 */
		protected function extract_audio($richtext, $plaintext, $extra_args = array())
		{
		}
		/**
		 * Extract [video] shortcodes from text.
		 *
		 * @since 2.3.0
		 *
		 * @see wp_get_video_extensions() for supported video formats.
		 *
		 * @param string $richtext   Content to parse.
		 * @param string $plaintext  Sanitized version of the content.
		 * @param array  $extra_args Bespoke data for a particular extractor (optional).
		 * @return array {
		 *     @type array $has Extracted media counts. {
		 *         @type int $video
		 *     }
		 *     @type array $videos Extracted video. {
		 *         Array of extracted media.
		 *
		 *         @type string $source Media source. Currently only "shortcodes".
		 *         @type string $url    Link to audio.
		 *     }
		 * }
		 */
		protected function extract_video($richtext, $plaintext, $extra_args = array())
		{
		}
		/**
		 * Helpers and utility methods.
		 */
		/**
		 * Extract images in [galleries] shortcodes from text.
		 *
		 * @since 2.3.0
		 *
		 * @param string $richtext   Content to parse.
		 * @param string $plaintext  Sanitized version of the content.
		 * @param array  $extra_args Bespoke data for a particular extractor (optional).
		 * @return array
		 */
		protected function extract_images_from_galleries($richtext, $plaintext, $extra_args = array())
		{
		}
		/**
		 * Extract the featured image from a Post.
		 *
		 * @since 2.3.0
		 *
		 * @param string $richtext   Content to parse.
		 * @param string $plaintext  Sanitized version of the content.
		 * @param array  $extra_args Contains data that an implementation might need beyond the defaults.
		 * @return array
		 */
		protected function extract_images_from_featured_images($richtext, $plaintext, $extra_args)
		{
		}
		/**
		 * Sanitize and format raw content to prepare for content extraction.
		 *
		 * HTML tags and shortcodes are removed, and HTML entities are decoded.
		 *
		 * @since 2.3.0
		 *
		 * @param string $richtext Content to sanitize.
		 * @return string
		 */
		protected function strip_markup($richtext)
		{
		}
	}
	/**
	 * Components endpoints.
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Components_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve components.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to list components.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Activate/Deactivate a component.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to update a component.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Prepares component data for return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param array           $component The component and its values.
		 * @param WP_REST_Request $request   Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($component, $request)
		{
		}
		/**
		 * Verify Component Status.
		 *
		 * @since 5.0.0
		 * @since 9.0.0 Adds the `$return_type` parameter.
		 *
		 * @param string $name        Component name.
		 * @param string $return_type Use `string` to get the l10n string. Default.
		 *                            Use `bool` to get whether the component is active or not.
		 *                            Use `array` to get both information.
		 * @return string|bool|array By default a l10n string is returned.
		 *                           True if the component is active, false otherwise when 'bool' is requested.
		 *                           An array containing both information when 'array' is requested.
		 */
		protected function verify_component_status($name, $return_type = 'string')
		{
		}
		/**
		 * Deactivate component helper.
		 *
		 * @since 5.0.0
		 *
		 * @param string $component Component id.
		 * @return array
		 */
		protected function deactivate_helper($component)
		{
		}
		/**
		 * Activate component helper.
		 *
		 * @since 5.0.0
		 *
		 * @param string $component Component id.
		 * @return array
		 */
		protected function activate_helper($component)
		{
		}
		/**
		 * Get component info helper.
		 *
		 * @since 5.0.0
		 * @since 9.0.0 Adds a `features` property to component's info.
		 *
		 * @param string $component Component id.
		 * @return array
		 */
		public function get_component_info($component)
		{
		}
		/**
		 * Does the component exist?
		 *
		 * @since 5.0.0
		 *
		 * @param string $component Component.
		 * @return bool
		 */
		protected function component_exists($component)
		{
		}
		/**
		 * Get the components schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for collections.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * BP_Core_Notification is deprecated.
	 *
	 * Use BP_Notifications_Notification instead.
	 *
	 * @deprecated since 1.9.0
	 */
	class BP_Core_Notification
	{
		/**
		 * The notification id.
		 *
		 * @var int
		 */
		public $id = 0;
		/**
		 * The ID to which the notification relates to within the component.
		 *
		 * @var int
		 */
		public $item_id = 0;
		/**
		 * The secondary ID to which the notification relates to within the component.
		 *
		 * @var int
		 */
		public $secondary_item_id = \null;
		/**
		 * The user ID for who the notification is for.
		 *
		 * @var int
		 */
		public $user_id = 0;
		/**
		 * The name of the component that the notification is for.
		 *
		 * @var string
		 */
		public $component_name = '';
		/**
		 * The action within the component which the notification is related to.
		 *
		 * @var string
		 */
		public $component_action = '';
		/**
		 * The date the notification was created.
		 *
		 * @var string
		 */
		public $date_notified = '';
		/**
		 * Is the notification new or has it already been read.
		 *
		 * @var boolean
		 */
		public $is_new = \false;
		/** Public Methods ********************************************************/
		/**
		 * Constructor
		 *
		 * @param int $id ID for the notification.
		 */
		public function __construct($id = 0)
		{
		}
		/**
		 * Update or insert notification details into the database.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/** Private Methods *******************************************************/
		/**
		 * Fetches the notification data from the database.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function populate()
		{
		}
		/** Static Methods ********************************************************/
		/**
		 * Check the access for a user.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id         ID to check access for.
		 * @param int $notification_id Notification ID to check for.
		 * @return string
		 */
		public static function check_access($user_id = 0, $notification_id = 0)
		{
		}
		/**
		 * Fetches all the notifications in the database for a specific user.
		 *
		 * @global wpdb $wpdb WordPress database object
		 *
		 * @param int    $user_id User ID.
		 * @param string $status 'is_new' or 'all'.
		 * @return array Associative array
		 */
		public static function get_all_for_user($user_id, $status = 'is_new')
		{
		}
		/**
		 * Delete all the notifications for a user based on the component name and action.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int    $user_id          ID of the user to delet notification for.
		 * @param string $component_name   Component name.
		 * @param string $component_action Component action.
		 * @return mixed
		 */
		public static function delete_for_user_by_type($user_id, $component_name, $component_action)
		{
		}
		/**
		 * Delete all the notifications that have a specific item id, component name and action.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int    $user_id           The ID of the user who the notifications are for.
		 * @param int    $item_id           The item ID of the notifications we wish to delete.
		 * @param string $component_name    The name of the component that the notifications we wish to delete.
		 * @param string $component_action  The action of the component that the notifications we wish to delete.
		 * @param int    $secondary_item_id (optional) The secondary item id of the notifications that we wish to
		 *                                  use to delete.
		 * @return mixed
		 */
		public static function delete_for_user_by_item_id($user_id, $item_id, $component_name, $component_action, $secondary_item_id = 0)
		{
		}
		/**
		 * Deletes all the notifications sent by a specific user, by component and action.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int    $user_id          The ID of the user whose sent notifications we wish to delete.
		 * @param string $component_name   The name of the component the notification was sent from.
		 * @param string $component_action The action of the component the notification was sent from.
		 * @return mixed
		 */
		public static function delete_from_user_by_type($user_id, $component_name, $component_action)
		{
		}
		/**
		 * Deletes all the notifications for all users by item id, and optional secondary item id,
		 * and component name and action.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int    $item_id           The item id that they notifications are to be for.
		 * @param string $component_name    The component that the notifications are to be from.
		 * @param string $component_action  The action that the notifications are to be from.
		 * @param int    $secondary_item_id Optional secondary item id that the notifications are to have.
		 * @return mixed
		 */
		public static function delete_all_by_type($item_id, $component_name, $component_action = '', $secondary_item_id = 0)
		{
		}
	}
	/**
	 * BP_Email class.
	 *
	 * @since 2.5.0
	 */
	class BP_Email
	{
		/**
		 * Addressee details (BCC).
		 *
		 * @since 2.5.0
		 *
		 * @var BP_Email_Recipient[] BCC recipients.
		 */
		protected $bcc = array();
		/**
		 * Addressee details (CC).
		 *
		 * @since 2.5.0
		 *
		 * @var BP_Email_Recipient[] CC recipients.
		 */
		protected $cc = array();
		/**
		 * Email content (HTML).
		 *
		 * @since 2.5.0
		 *
		 * @var string
		 */
		protected $content_html = '';
		/**
		 * Email content (plain text).
		 *
		 * @since 2.5.0
		 *
		 * @var string
		 */
		protected $content_plaintext = '';
		/**
		 * The content type to send the email in ("html" or "plaintext").
		 *
		 * @since 2.5.0
		 *
		 * @var string
		 */
		protected $content_type = 'html';
		/**
		 * Sender details.
		 *
		 * @since 2.5.0
		 *
		 * @var BP_Email_Sender
		 */
		protected $from = \null;
		/**
		 * Email preheader.
		 *
		 * @since 4.0.0
		 *
		 * @var string
		 */
		protected $preheader = \null;
		/**
		 * Email headers.
		 *
		 * Associative pairing of email header name/value.
		 *
		 * @since 2.5.0
		 *
		 * @var string[]
		 */
		protected $headers = array();
		/**
		 * The Post object (the source of the email's content and subject).
		 *
		 * @since 2.5.0
		 *
		 * @var WP_Post|null
		 */
		protected $post_object = \null;
		/**
		 * Reply To details.
		 *
		 * @since 2.5.0
		 *
		 * @var BP_Email_Sender|null
		 */
		protected $reply_to = \null;
		/**
		 * Email subject.
		 *
		 * @since 2.5.0
		 *
		 * @var string
		 */
		protected $subject = '';
		/**
		 * Email template (the HTML wrapper around the email content).
		 *
		 * @since 2.5.0
		 *
		 * @var string
		 */
		protected $template = '{{{content}}}';
		/**
		 * Addressee details (to).
		 *
		 * @since 2.5.0
		 *
		 * @var BP_Email_Recipient[] Email recipients.
		 * }
		 */
		protected $to = array();
		/**
		 * Unique identifier for this particular type of email.
		 *
		 * @since 2.5.0
		 *
		 * @var string
		 */
		protected $type = '';
		/**
		 * Token names and replacement values for this email.
		 *
		 * Associative pairing of token name (key) and replacement value (value).
		 *
		 * @since 2.5.0
		 *
		 * @var string[]
		 */
		protected $tokens = array();
		/**
		 * Constructor.
		 *
		 * Set the email type and default "from" and "reply to" name and address.
		 *
		 * @since 2.5.0
		 *
		 * @param string $email_type Unique identifier for a particular type of email.
		 */
		public function __construct($email_type)
		{
		}
		/*
		 * Setters/getters.
		 */
		/**
		 * Getter function to expose object properties.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $property_name Property to access.
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return mixed Returns null if property does not exist, otherwise the value.
		 */
		public function get($property_name, $transform = 'raw')
		{
		}
		/**
		 * Get email preheader.
		 *
		 * @since 4.0.0
		 *
		 * @return string
		 */
		public function get_preheader()
		{
		}
		/**
		 * Get email headers.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return string[] Associative pairing of email header name/value.
		 */
		public function get_headers($transform = 'raw')
		{
		}
		/**
		 * Get the email's "bcc" address and name.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return BP_Email_Recipient[] BCC recipients.
		 */
		public function get_bcc($transform = 'raw')
		{
		}
		/**
		 * Get the email's "cc" address and name.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return BP_Email_Recipient[] CC recipients.
		 */
		public function get_cc($transform = 'raw')
		{
		}
		/**
		 * Get the email content.
		 *
		 * HTML or plaintext is returned, depending on the email's $content_type.
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return string HTML or plaintext, depending on $content_type.
		 */
		public function get_content($transform = 'raw')
		{
		}
		/**
		 * Get the email content (in HTML).
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return string HTML email content.
		 */
		public function get_content_html($transform = 'raw')
		{
		}
		/**
		 * Get the email content (in plaintext).
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return string Plain text email content.
		 */
		public function get_content_plaintext($transform = 'raw')
		{
		}
		/**
		 * Get the email content type (HTML or plain text) that the email will be sent in.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return string Email content type ("html" or "plaintext").
		 */
		public function get_content_type($transform = 'raw')
		{
		}
		/**
		 * Get the email's "from" address and name.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return BP_Email_Sender "From" recipient.
		 */
		public function get_from($transform = 'raw')
		{
		}
		/**
		 * Get the Post associated with the email.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value. Defaults to 'raw'.
		 * @return WP_Post|null WP_Post object, or null if not set.
		 */
		public function get_post_object($transform = 'raw')
		{
		}
		/**
		 * Get the email's "reply to" address and name.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return BP_Email_Recipient|null "Reply to" recipient, or null if not set.
		 */
		public function get_reply_to($transform = 'raw')
		{
		}
		/**
		 * Get the email subject.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return string|null Email subject, or null if not set.
		 */
		public function get_subject($transform = 'raw')
		{
		}
		/**
		 * Get the email template (the HTML wrapper around the email content).
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return string|null Email template. Assumed to be HTML. Or null if not set.
		 */
		public function get_template($transform = 'raw')
		{
		}
		/**
		 * Get the email's "to" address and name.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return BP_Email_Recipient[]|null "To" recipients. Or null if not set.
		 */
		public function get_to($transform = 'raw')
		{
		}
		/**
		 * Get token names and replacement values for this email.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @param string $transform Optional. How to transform the return value.
		 *                          Accepts 'raw' (default) or 'replace-tokens'.
		 * @return string[]|null Associative pairing of token name (key) and replacement value (value).
		 *                       Or null if not set.
		 */
		public function get_tokens($transform = 'raw')
		{
		}
		/**
		 * Set email headers.
		 *
		 * Does NOT let you override to/from, etc. Use the methods provided to set those.
		 *
		 * @since 2.5.0
		 *
		 * @param string[] $headers Key/value pairs of header name/values (strings).
		 * @return BP_Email
		 */
		public function set_headers(array $headers)
		{
		}
		/**
		 * Set the email's "bcc" address and name.
		 *
		 * To set a single address, the first parameter is the address and the second the name.
		 * You can also pass a user ID or a WP_User object.
		 *
		 * To set multiple addresses, for each array item, the key is the email address and
		 * the value is the name.
		 *
		 * @since 2.5.0
		 *
		 * @param string|array|int|WP_User $bcc_address Either a email address, user ID, WP_User object,
		 *                                              or an array containing any combination of the above.
		 * @param string                   $name Optional. If $bcc_address is a string, this is the recipient's name.
		 * @param string                   $operation Optional. If "replace", $to_address replaces current setting (default).
		 *                                            If "add", $to_address is added to the current setting.
		 * @return BP_Email
		 */
		public function set_bcc($bcc_address, $name = '', $operation = 'replace')
		{
		}
		/**
		 * Set the email's "cc" address and name.
		 *
		 * To set a single address, the first parameter is the address and the second the name.
		 * You can also pass a user ID or a WP_User object.
		 *
		 * To set multiple addresses, for each array item, the key is the email address and
		 * the value is the name.
		 *
		 * @since 2.5.0
		 *
		 * @param string|array|int|WP_User $cc_address Either a email address, user ID, WP_User object,
		 *                                             or an array containing any combination of the above.
		 * @param string                   $name Optional. If $cc_address is a string, this is the recipient's name.
		 * @param string                   $operation Optional. If "replace", $to_address replaces current setting (default).
		 *                                            If "add", $to_address is added to the current setting.
		 * @return BP_Email
		 */
		public function set_cc($cc_address, $name = '', $operation = 'replace')
		{
		}
		/**
		 * Set the email content (HTML).
		 *
		 * @since 2.5.0
		 *
		 * @param string $content HTML email content.
		 * @return BP_Email
		 */
		public function set_content_html($content)
		{
		}
		/**
		 * Set the email content (plain text).
		 *
		 * @since 2.5.0
		 *
		 * @param string $content Plain text email content.
		 * @return BP_Email
		 */
		public function set_content_plaintext($content)
		{
		}
		/**
		 * Set the content type (HTML or plain text) to send the email in.
		 *
		 * @since 2.5.0
		 *
		 * @param string $content_type Email content type ("html" or "plaintext").
		 * @return BP_Email
		 */
		public function set_content_type($content_type)
		{
		}
		/**
		 * Set the email's "from" address and name.
		 *
		 * @since 2.5.0
		 *
		 * @param string|array|int|WP_User $email_address Either a email address, user ID, or WP_User object.
		 * @param string                   $name Optional. If $email_address is a string, this is the recipient's name.
		 * @return BP_Email
		 */
		public function set_from($email_address, $name = '')
		{
		}
		/**
		 * Set the Post object containing the email content template.
		 *
		 * Also sets the email's subject, content, and template from the Post, for convenience.
		 *
		 * @since 2.5.0
		 *
		 * @param WP_Post $post Post object.
		 * @return BP_Email
		 */
		public function set_post_object(\WP_Post $post)
		{
		}
		/**
		 * Set the email's "reply to" address and name.
		 *
		 * @since 2.5.0
		 *
		 * @param string|array|int|WP_User $email_address Either a email address, user ID, WP_User object,
		 *                                                or an array containing any combination of the above.
		 * @param string                   $name Optional. If $email_address is a string, this is the recipient's name.
		 * @return BP_Email
		 */
		public function set_reply_to($email_address, $name = '')
		{
		}
		/**
		 * Set the email subject.
		 *
		 * @since 2.5.0
		 *
		 * @param string $subject Email subject.
		 * @return BP_Email
		 */
		public function set_subject($subject)
		{
		}
		/**
		 * Set the email template (the HTML wrapper around the email content).
		 *
		 * This needs to include the string "{{{content}}}" to have the post content added
		 * when the email template is rendered.
		 *
		 * @since 2.5.0
		 *
		 * @param string $template Email template. Assumed to be HTML.
		 * @return BP_Email
		 */
		public function set_template($template)
		{
		}
		/**
		 * Set the email's "to" address and name.
		 *
		 * IMPORTANT NOTE: the assumption with all emails sent by (and belonging to) BuddyPress itself
		 * is that there will only be a single `$to_address`. This is to simplify token and templating
		 * logic (for example, if multiple recipients, the "unsubscribe" link in the emails will all
		 * only link to the first recipient).
		 *
		 * To set a single address, the first parameter is the address and the second the name.
		 * You can also pass a user ID or a WP_User object.
		 *
		 * To set multiple addresses, for each array item, the key is the email address and
		 * the value is the name.
		 *
		 * @since 2.5.0
		 *
		 * @param string|array|int|WP_User $to_address Either a email address, user ID, WP_User object,
		 *                                             or an array containing any combination of the above.
		 * @param string                   $name Optional. If $to_address is a string, this is the recipient's name.
		 * @param string                   $operation Optional. If "replace", $to_address replaces current setting (default).
		 *                                            If "add", $to_address is added to the current setting.
		 * @return BP_Email
		 */
		public function set_to($to_address, $name = '', $operation = 'replace')
		{
		}
		/**
		 * Set token names and replacement values for this email.
		 *
		 * In templates, tokens are inserted with a Handlebars-like syntax, e.g. `{{token_name}}`.
		 * { and } are reserved characters. There's no need to specify these brackets in your token names.
		 *
		 * @since 2.5.0
		 *
		 * @param string[] $tokens Associative array, contains key/value pairs of token name/value.
		 *                         Values are a string or a callable function.
		 * @return BP_Email
		 */
		public function set_tokens(array $tokens)
		{
		}
		/*
		 * Sanitisation and validation logic.
		 */
		/**
		 * Check that we'd be able to send this email.
		 *
		 * Unlike most other methods in this class, this one is not chainable.
		 *
		 * @since 2.5.0
		 *
		 * @return bool|WP_Error Returns true if validation succesful, else a descriptive WP_Error.
		 */
		public function validate()
		{
		}
	}
	/**
	 * Load BuddyPress Types admin area.
	 *
	 * @since 7.O.0
	 */
	class BP_Admin_Types
	{
		/**
		 * Current BuddyPress taxonomy.
		 *
		 * @since 7.0.0
		 * @var string
		 */
		public $taxonomy = '';
		/**
		 * All registered BuddyPress taxonomies.
		 *
		 * @since 7.0.0
		 * @var array
		 */
		public $taxonomies = array();
		/**
		 * Current screen ID.
		 *
		 * @since 7.0.0
		 * @var string
		 */
		public $screen_id = '';
		/**
		 * The main BuddyPress Types admin loader.
		 *
		 * @since 7.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register BP Types Admin.
		 *
		 * @since 7.0.0
		 *
		 * @return BP_Admin_Types|null The BP Types Admin object or null if not in admin.
		 */
		public static function register_types_admin()
		{
		}
		/**
		 * Set the globals.
		 *
		 * @since 7.0.0
		 */
		private function setup_globals()
		{
		}
		/**
		 * Include Admin functions.
		 *
		 * @since 7.0.0
		 */
		private function includes()
		{
		}
		/**
		 * Set hooks.
		 *
		 * @since 7.0.0
		 */
		private function setup_hooks()
		{
		}
		/**
		 * Handle BP Type actions.
		 *
		 * @since 7.0.0
		 *
		 * @param string $action Required. The action to handle ('add-tag', 'editedtag' or 'delete' ).
		 */
		private function handle_action($action)
		{
		}
		/**
		 * Override the Admin parent file to highlight the right menu.
		 *
		 * @since 7.0.0
		 *
		 * @global string $parent_file The parent file of the current admin screen.
		 */
		public function screen_head()
		{
		}
		/**
		 * Registers script.
		 *
		 * @since 7.0.0
		 *
		 * @param array $scripts The registered scripts.
		 */
		public function register_scripts($scripts = array())
		{
		}
		/**
		 * Enqueues script.
		 *
		 * @since 7.0.0
		 */
		public function screen_scripts()
		{
		}
		/**
		 * Outputs the BP type add form.
		 *
		 * @since 7.0.0
		 *
		 * @param string      $taxonomy The type taxonomy name.
		 * @param null|object $type     The type object, `null` if not passed to the method.
		 */
		public function add_form_fields($taxonomy = '', $type = \null)
		{
		}
		/**
		 * Outputs the BP type edit form.
		 *
		 * @since 7.0.0
		 *
		 * @param WP_Term|null $term     The term object for the BP Type.
		 * @param string       $taxonomy The type taxonomy name.
		 */
		public function edit_form_fields($term = \null, $taxonomy = '')
		{
		}
		/**
		 * Filters the terms list table column headers to customize them for BuddyPress Types.
		 *
		 * @since 7.0.0
		 *
		 * @param array $column_headers The column header labels keyed by column ID.
		 * @return arrayThe column header labels keyed by column ID.
		 */
		public function column_headers($column_headers = array())
		{
		}
		/**
		 * Sets the content for the Plural name & Counts columns.
		 *
		 * @since 7.0.0
		 *
		 * @param string $column_content The column content.
		 * @param string $column_name    Name of the column.
		 * @param int    $type_id        The type's term ID.
		 * @return string|null|int
		 */
		public function column_contents($column_content = '', $column_name = '', $type_id = 0)
		{
		}
		/**
		 * Customizes the Types Admin list table row actions.
		 *
		 * @since 7.0.0
		 *
		 * @param array        $actions The table row actions.
		 * @param WP_Term|null $type    The current BP Type for the row.
		 * @return array The table row actions for the current BP type.
		 */
		public function row_actions($actions = array(), $type = \null)
		{
		}
	}
	/**
	 * BP_PHPMailer class.
	 *
	 * @since 2.5.0
	 */
	class BP_PHPMailer implements \BP_Email_Delivery
	{
		/**
		 * Send email(s).
		 *
		 * @since 2.5.0
		 *
		 * @param BP_Email $email Email to send.
		 * @return bool|WP_Error Returns true if email send, else a descriptive WP_Error.
		 */
		public function bp_email(\BP_Email $email)
		{
		}
		/**
		 * Get an appropriate hostname for the email. Varies depending on site configuration.
		 *
		 * @since 2.5.0
		 *
		 * @deprecated 2.5.3 No longer used.
		 *
		 * @return string
		 */
		public static function get_hostname()
		{
		}
	}
	/**
	 * Core component classes.
	 *
	 * @package BuddyPress
	 * @subpackage Core
	 * @since 2.7.0
	 */
	/**
	 * Generate markup for an HTML element.
	 *
	 * @since 2.7.0
	 */
	class BP_Core_HTML_Element
	{
		/**
		 * Open tag for an element.
		 *
		 * This would include attributes if applicable. eg. '<a href="" class="">'
		 *
		 * @since 2.7.0
		 *
		 * @var string
		 */
		public $open_tag = '';
		/**
		 * Inner HTML for an element.
		 *
		 * For example, this could be anchor text within an <a> element.
		 *
		 * @since 2.7.0
		 *
		 * @var string
		 */
		public $inner_html = '';
		/**
		 * Closing tag for an element.
		 *
		 * For example, "</a>".
		 *
		 * @since 2.7.0
		 *
		 * @var string
		 */
		public $close_tag = '';
		/**
		 * Constructor.
		 *
		 * @since 2.7.0
		 *
		 * @param array $r {
		 *     An array of arguments.
		 *     @type string $element    The element to render. eg. 'a' for the anchor element.
		 *     @type array  $attr       Optional. The element's attributes set as key/value pairs. eg.
		 *                              array( 'href' => 'http://example.com', 'class' => 'my-class' )
		 *     @type string $inner_html Optional. The inner HTML for the element if applicable. Please note that
		 *                              this isn't sanitized, so you should use your own sanitization routine
		 *                              before using this parameter.
		 * }
		 */
		public function __construct($r = array())
		{
		}
		/**
		 * Returns a property from this class.
		 *
		 * @since 2.7.0
		 *
		 * @param string $prop Property name. Either 'open_tag', 'inner_html', 'close_tag'.
		 * @return string
		 */
		public function get($prop = '')
		{
		}
		/**
		 * Returns full contents of HTML element.
		 *
		 * @since 2.7.0
		 *
		 * @return string
		 */
		public function contents()
		{
		}
	}
	/**
	 * Walker class to output an unordered list of category checkbox input elements.
	 *
	 * A modification of WordPress 4.4.1's Walker_Category_Checklist class which prints term description
	 * instead of term name, and makes it work for non-hierarchical taxonomys. Some lines have undergone
	 * slight adjustment to meet modern coding standards, but any improvements should be contributed upstream.
	 *
	 * @since 2.5.0
	 */
	class BP_Walker_Category_Checklist extends \Walker
	{
		/**
		 * Tree type.
		 *
		 * @since 2.5.0
		 *
		 * @var string
		 */
		public $tree_type = 'category';
		/**
		 * DB Fields.
		 *
		 * @since 2.5.0
		 *
		 * @var array
		 */
		public $db_fields = array('parent' => 'parent', 'id' => 'term_id');
		/**
		 * Starts the list before the elements are added.
		 *
		 * @since 2.5.0
		 *
		 * @param string $output Passed by reference. Used to append additional content.
		 * @param int    $depth  Depth of category. Used for tab indentation.
		 * @param array  $args   An array of arguments.
		 */
		public function start_lvl(&$output, $depth = 0, $args = array())
		{
		}
		/**
		 * Ends the list of after the elements are added.
		 *
		 * @since 2.5.0
		 *
		 * @param string $output Passed by reference. Used to append additional content.
		 * @param int    $depth  Depth of category. Used for tab indentation.
		 * @param array  $args   An array of arguments.
		 */
		public function end_lvl(&$output, $depth = 0, $args = array())
		{
		}
		/**
		 * Start the element output.
		 *
		 * @param string $output   Passed by reference. Used to append additional content.
		 * @param object $category The current term object.
		 * @param int    $depth    Depth of the term in reference to parents. Default 0.
		 * @param array  $args     An array of arguments.
		 * @param int    $id       ID of the current term.
		 */
		public function start_el(&$output, $category, $depth = 0, $args = array(), $id = 0)
		{
		}
		/**
		 * Ends the element output, if needed.
		 *
		 * @see Walker::end_el()
		 *
		 * @since 2.5.0
		 *
		 * @param string $output   Passed by reference. Used to append additional content.
		 * @param object $category The current term object.
		 * @param int    $depth    Depth of the term in reference to parents. Default 0.
		 * @param array  $args     An array of arguments.
		 */
		public function end_el(&$output, $category, $depth = 0, $args = array())
		{
		}
	}
	/**
	 * Fetch data about a BuddyPress user.
	 *
	 * BP_Core_User class can be used by any component. It will fetch useful
	 * details for any user when provided with a user_id.
	 *
	 * Example:
	 *    $user = new BP_Core_User( $user_id );
	 *    $user_avatar = $user->avatar;
	 *    $user_email = $user->email;
	 *    $user_status = $user->status;
	 *    etc.
	 */
	class BP_Core_User
	{
		/**
		 * ID of the user which the object relates to.
		 *
		 * @var integer
		 */
		public $id;
		/**
		 * The URL to the full size of the avatar for the user.
		 *
		 * @var string
		 */
		public $avatar;
		/**
		 * The URL to the thumb size of the avatar for the user.
		 *
		 * @var string
		 */
		public $avatar_thumb;
		/**
		 * The URL to the mini size of the avatar for the user.
		 *
		 * @var string
		 */
		public $avatar_mini;
		/**
		 * The full name of the user.
		 *
		 * @var string
		 */
		public $fullname;
		/**
		 * The email for the user.
		 *
		 * @var string
		 */
		public $email;
		/**
		 * The absolute url for the user's profile.
		 *
		 * @var string
		 */
		public $user_url;
		/**
		 * The HTML for the user link, with the link text being the user's full name.
		 *
		 * @var string
		 */
		public $user_link;
		/**
		 * Contains a formatted string when the last time the user was active.
		 *
		 * Example: "active 2 hours and 50 minutes ago"
		 *
		 * @var string
		 */
		public $last_active;
		/* Extras */
		/**
		 * The total number of "Friends" the user has on site.
		 *
		 * @var integer
		 */
		public $total_friends;
		/**
		 * The total number of blog posts posted by the user.
		 *
		 * @var integer
		 * @deprecated No longer used
		 */
		public $total_blogs;
		/**
		 * The total number of groups the user is a part of.
		 *
		 * Example: "1 group", "2 groups"
		 *
		 * @var string
		 */
		public $total_groups;
		/**
		 * Profile information for the specific user.
		 *
		 * @since 1.2.0
		 * @var array
		 */
		public $profile_data;
		/** Public Methods *******************************************************/
		/**
		 * Class constructor.
		 *
		 * @param integer $user_id         The ID for the user being queried.
		 * @param bool    $populate_extras Optional. Whether to fetch extra information such as
		 *                                 group/friendship counts or not. Default: false.
		 */
		public function __construct($user_id, $populate_extras = \false)
		{
		}
		/**
		 * Populate the instantiated class with data based on the User ID provided.
		 */
		public function populate()
		{
		}
		/**
		 * Populates extra fields such as group and friendship counts.
		 */
		public function populate_extras()
		{
		}
		/**
		 * Fetch xprofile data for the current user.
		 *
		 * @see BP_XProfile_ProfileData::get_all_for_user() for description of
		 *      return value.
		 *
		 * @return array See {@link BP_XProfile_Profile_Data::get_all_for_user()}.
		 */
		public function get_profile_data()
		{
		}
		/** Static Methods ********************************************************/
		/**
		 * Get a list of users that match the query parameters.
		 *
		 * Since BuddyPress 1.7, use {@link BP_User_Query} instead.
		 *
		 * @deprecated 1.7.0 Use {@link BP_User_Query}.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see BP_User_Query for a description of parameters, most of which
		 *      are used there in the same way.
		 *
		 * @param string      $type            See {@link BP_User_Query}.
		 * @param int         $limit           See {@link BP_User_Query}. Default: 0.
		 * @param int         $page            See {@link BP_User_Query}. Default: 1.
		 * @param int         $user_id         See {@link BP_User_Query}. Default: 0.
		 * @param mixed       $include         See {@link BP_User_Query}. Default: false.
		 * @param string|bool $search_terms    See {@link BP_User_Query}.
		 *                                     Default: false.
		 * @param bool        $populate_extras See {@link BP_User_Query}.
		 *                                     Default: true.
		 * @param mixed       $exclude         See {@link BP_User_Query}. Default: false.
		 * @param string|bool $meta_key        See {@link BP_User_Query}.
		 *                                     Default: false.
		 * @param string|bool $meta_value      See {@link BP_User_Query}.
		 *                                     Default: false.
		 * @return false|array {
		 *     @type int   $total_users Total number of users matched by query
		 *                              params.
		 *     @type array $paged_users The current page of users matched by
		 *                              query params.
		 * }
		 */
		public static function get_users($type, $limit = 0, $page = 1, $user_id = 0, $include = \false, $search_terms = \false, $populate_extras = \true, $exclude = \false, $meta_key = \false, $meta_value = \false)
		{
		}
		/**
		 * Fetch the details for all users whose usernames start with the given letter.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string   $letter          The letter the users names are to start with.
		 * @param int|null $limit           The number of users we wish to retrive.
		 * @param int      $page            The page number we are currently on, used in conjunction
		 *                                  with $limit to get the start position for the limit.
		 * @param bool     $populate_extras If we should populate extra user fields.
		 * @param string   $exclude         Comma-separated IDs of users whose results
		 *                                  aren't to be fetched.
		 * @return false|array False on error, otherwise associative array of results.
		 */
		public static function get_users_by_letter($letter, $limit = \null, $page = 1, $populate_extras = \true, $exclude = '')
		{
		}
		/**
		 * Get details of specific users from the database.
		 *
		 * Use {@link BP_User_Query} with the 'user_ids' param instead.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array    $user_ids        The user IDs of the users who we wish to
		 *                                  fetch information on.
		 * @param int|null $limit           The limit of results we want.
		 * @param int      $page            The page we are on for pagination.
		 * @param bool     $populate_extras If we should populate extra user fields.
		 * @return array Associative array.
		 */
		public static function get_specific_users($user_ids, $limit = \null, $page = 1, $populate_extras = \true)
		{
		}
		/**
		 * Find users who match on the value of an xprofile data.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string   $search_terms    The terms to search the profile table
		 *                                  value column for.
		 * @param int|null $limit           The limit of results we want.
		 * @param int      $page            The page we are on for pagination.
		 * @param boolean  $populate_extras If we should populate extra user fields.
		 * @return array Associative array.
		 */
		public static function search_users($search_terms, $limit = \null, $page = 1, $populate_extras = \true)
		{
		}
		/**
		 * Fetch extra user information, such as friend count and last profile update message.
		 *
		 * Accepts multiple user IDs to fetch data for.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array       $paged_users An array of stdClass containing the users.
		 * @param string      $user_ids    The user ids to select information about.
		 * @param string|bool $type        The type of fields we wish to get.
		 * @return mixed False on error, otherwise associative array of results.
		 */
		public static function get_user_extras(&$paged_users, &$user_ids, $type = \false)
		{
		}
		/**
		 * Get WordPress user details for a specified user.
		 *
		 * @since 3.0.0 Results might be from cache
		 *
		 * @param int $user_id User ID.
		 * @return false|object User object if successful, false on failure.
		 */
		public static function get_core_userdata($user_id)
		{
		}
		/**
		 * Get last activity data for a user or set of users.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int|array $user_id User IDs or multiple user IDs.
		 * @return false|array
		 */
		public static function get_last_activity($user_id)
		{
		}
		/**
		 * Set a user's last_activity value.
		 *
		 * Will create a new entry if it does not exist. Otherwise updates the
		 * existing entry.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int    $user_id ID of the user whose last_activity you are updating.
		 * @param string $time    MySQL-formatted time string.
		 * @return bool
		 */
		public static function update_last_activity($user_id, $time)
		{
		}
		/**
		 * Delete a user's last_activity value.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id ID of the user whose activity should be deleted.
		 * @return bool
		 */
		public static function delete_last_activity($user_id)
		{
		}
	}
	/**
	 * API to create BuddyPress buttons.
	 *
	 * @since 1.2.6
	 * @since 2.7.0 Introduced $parent_element, $parent_attr, $button_element, $button_attr as
	 *              $args parameters.
	 *              Deprecated $wrapper, $wrapper_id, $wrapper_class, $link_href, $link_class,
	 *              $link_id, $link_rel, $link_title as $args params.
	 *
	 * @param array $args {
	 *     Array of arguments.
	 *
	 *     @type string      $id                String describing the button type.
	 *     @type string      $component         The name of the component the button belongs to. Default: 'core'.
	 *     @type bool        $must_be_logged_in Optional. Does the user need to be logged in to see this button? Default:
	 *                                          true.
	 *     @type bool        $block_self        Optional. True if the button should be hidden when a user is viewing his
	 *                                          own profile. Default: true.
	 *     @type string      $parent_element    Optional. Parent element to wrap button around. Default: 'div'.
	 *     @type array       $parent_attr       Optional. Element attributes for parent element. Set whatever attributes
	 *                                          like 'id', 'class' as array keys.
	 *     @type string      $button_element    Optional. Button element. Default: 'a'.
	 *     @type array       $button_attr       Optional. Button attributes. Set whatever attributes like 'id', 'class' as
	 *                                          array keys.
	 *     @type string      $link_text         Optional. Text to appear on the button. Default: ''.
	 *     @type string|bool $wrapper           Deprecated. Use $parent_element instead.
	 *     @type string      $wrapper_id        Deprecated. Use $parent_attr and set 'id' as array key.
	 *     @type string      $wrapper_class     Deprecated. Use $parent_attr and set 'class' as array key.
	 *     @type string      $link_href         Deprecated. Use $button_attr and set 'href' as array key.
	 *     @type string      $link_class        Deprecated. Use $button_attr and set 'class' as array key.
	 *     @type string      $link_id           Deprecated. Use $button_attr and set 'id' as array key.
	 *     @type string      $link_rel          Deprecated. Use $button_attr and set 'rel' as array key.
	 *     @type string      $link_title        Deprecated. Use $button_attr and set 'title' as array key.
	 * }
	 */
	class BP_Button
	{
		/** Button properties *****************************************************/
		/**
		 * The button ID.
		 *
		 * @since 1.2.6
		 *
		 * @var string
		 */
		public $id = '';
		/**
		 * The name of the component that the button belongs to.
		 *
		 * @since 1.2.6
		 *
		 * @var string
		 */
		public $component = 'core';
		/**
		 * Does the user need to be logged in to see this button?
		 *
		 * @since 1.2.6
		 *
		 * @var bool
		 */
		public $must_be_logged_in = \true;
		/**
		 * Whether the button should be hidden when viewing your own profile.
		 *
		 * @since 1.2.6
		 *
		 * @var bool
		 */
		public $block_self = \true;
		/** Wrapper ***************************************************************/
		/**
		 * Parent element to wrap button around.
		 *
		 * @since 2.7.0
		 *
		 * @var string Default: 'div'.
		 */
		public $parent_element = '';
		/**
		 * Element attributes for parent element.
		 *
		 * @since 2.7.0
		 *
		 * @var array Set whatever attributes like 'id', 'class' as array key.
		 */
		public $parent_attr = array();
		/** Button ****************************************************************/
		/**
		 * Button element.
		 *
		 * @since 2.7.0
		 *
		 * @var string Default: 'a'.
		 */
		public $button_element = 'a';
		/**
		 * Button attributes.
		 *
		 * @since 2.7.0
		 *
		 * @var array Set whatever attributes like 'id', 'href' as array key.
		 */
		public $button_attr = array();
		/**
		 * The contents of the button link.
		 *
		 * @since 1.2.6
		 *
		 * @var string
		 */
		public $link_text = '';
		/**
		 * HTML result.
		 *
		 * @since 1.2.6
		 *
		 * @var string
		 */
		public $contents = '';
		/** Deprecated ***********************************************************/
		/**
		 * The type of DOM element to use for a wrapper.
		 *
		 * @since      1.2.6
		 * @deprecated 2.7.0 Use $parent_element instead.
		 *
		 * @var string|bool
		 */
		public $wrapper = 'div';
		/**
		 * The DOM class of the button wrapper.
		 *
		 * @since      1.2.6
		 * @deprecated 2.7.0 Set 'class' key in $parent_attr instead.
		 *
		 * @var string
		 */
		public $wrapper_class = '';
		/**
		 * The DOM ID of the button wrapper.
		 *
		 * @since      1.2.6
		 * @deprecated 2.7.0 Set 'id' key in $parent_attr instead.
		 *
		 * @var string
		 */
		public $wrapper_id = '';
		/**
		 * The destination link of the button.
		 *
		 * @since      1.2.6
		 * @deprecated 2.7.0 Set 'href' key in $button_attr instead.
		 *
		 * @var string
		 */
		public $link_href = '';
		/**
		 * The DOM class of the button link.
		 *
		 * @since      1.2.6
		 * @deprecated 2.7.0 Set 'class' key in $button_attr instead.
		 *
		 * @var string
		 */
		public $link_class = '';
		/**
		 * The DOM ID of the button link.
		 *
		 * @since      1.2.6
		 * @deprecated 2.7.0 Set 'id' key in $button_attr instead.
		 *
		 * @var string
		 */
		public $link_id = '';
		/**
		 * The DOM rel value of the button link.
		 *
		 * @since      1.2.6
		 * @deprecated 2.7.0 Set 'rel' key in $button_attr instead.
		 *
		 * @var string
		 */
		public $link_rel = '';
		/**
		 * Title of the button link.
		 *
		 * @since      1.2.6
		 * @deprecated 2.7.0 Set 'title' key in $button_attr instead.
		 *
		 * @var string
		 */
		public $link_title = '';
		/** Methods ***************************************************************/
		/**
		 * Builds the button based on class parameters.
		 *
		 * @since 1.2.6
		 *
		 * @param array|string $args See `BP_Button`.
		 */
		public function __construct($args = '')
		{
		}
		/**
		 * Provide backward compatibility for deprecated button arguments.
		 *
		 * @since 2.7.0.
		 *
		 * @param  array $r See {@see BP_Button} class for full documentation.
		 * @return array
		 */
		protected function backward_compatibility_args($r = array())
		{
		}
		/**
		 * Return the markup for the generated button.
		 *
		 * @since 1.2.6
		 *
		 * @return string Button markup.
		 */
		public function contents()
		{
		}
		/**
		 * Output the markup of button.
		 *
		 * @since 1.2.6
		 */
		public function display()
		{
		}
	}
	/**
	 * Main BuddyPress Class.
	 *
	 * Tap tap tap... Is this thing on?
	 *
	 * @since 1.6.0
	 */
	class BuddyPress
	{
		/** Magic *****************************************************************/
		/**
		 * BuddyPress uses many variables, most of which can be filtered to
		 * customize the way that it works. To prevent unauthorized access,
		 * these variables are stored in a private array that is magically
		 * updated using PHP 5.2+ methods. This is to prevent third party
		 * plugins from tampering with essential information indirectly, which
		 * would cause issues later.
		 *
		 * @see BuddyPress::setup_globals()
		 * @var array
		 */
		private $data;
		/** Not Magic *************************************************************/
		/**
		 * Primary BuddyPress navigation.
		 *
		 * @var BP_Core_BP_Nav_BackCompat
		 */
		public $bp_nav;
		/**
		 * Options for the BuddyPress navigation.
		 *
		 * @var BP_Core_BP_Options_Nav_BackCompat
		 */
		public $bp_options_nav;
		/**
		 * Unfiltered URI.
		 *
		 * The unfiltered URI broken down into chunks.
		 *
		 * @var array
		 */
		public $unfiltered_uri = array();
		/**
		 * The canonical URI stack.
		 *
		 * @see bp_redirect_canonical()
		 * @see bp_core_new_nav_item()
		 * @var array
		 */
		public $canonical_stack = array();
		/**
		 * Current action variables.
		 *
		 * @var array
		 */
		public $action_variables = array();
		/**
		 * Current member directory type.
		 *
		 * @var string
		 */
		public $current_member_type = '';
		/**
		 * BuddyPress required components (core, members).
		 *
		 * @var array
		 */
		public $required_components = array();
		/**
		 * BuddyPress loaded components.
		 *
		 * @var array
		 */
		public $loaded_components = array();
		/**
		 * BuddyPress active components.
		 *
		 * @var array
		 */
		public $active_components = array();
		/**
		 * Whether autoload is in use.
		 *
		 * @since 2.5.0
		 * @var bool
		 */
		public $do_autoload = \true;
		/**
		 * Activity component.
		 *
		 * @since 1.6.0
		 * @var BP_Activity_Component
		 */
		public $activity;
		/**
		 * Blogs component.
		 *
		 * @since 1.5.0
		 * @var BP_Blogs_Component
		 */
		public $blogs;
		/**
		 * Core component.
		 *
		 * @since 1.6.0
		 * @var BP_Core
		 */
		public $core;
		/**
		 * Forums component.
		 *
		 * @since 1.5.0
		 * @var BP_Forums_Component
		 */
		public $forums;
		/**
		 * Friends component.
		 *
		 * @since 1.6.0
		 * @var BP_Friends_Component
		 */
		public $friends;
		/**
		 * Groups component.
		 *
		 * @since 1.5.0
		 * @var BP_Groups_Component
		 */
		public $groups;
		/**
		 * Members component.
		 *
		 * @since 1.5.0
		 * @var BP_Members_Component
		 */
		public $members;
		/**
		 * Messages component.
		 *
		 * @since 1.5.0
		 * @var BP_Messages_Component
		 */
		public $messages;
		/**
		 * Notifications component.
		 *
		 * @since 1.9.0
		 * @var BP_Notifications_Component
		 */
		public $notifications;
		/**
		 * Settings component.
		 *
		 * @since 1.6.0
		 * @var BP_Settings_Component
		 */
		public $settings;
		/**
		 * XProfile component.
		 *
		 * @since 1.6.0
		 * @var BP_XProfile_Component
		 */
		public $profile;
		/**
		 * BuddyPress Ajax actions.
		 *
		 * @since 12.0.0
		 *
		 * @var array The list of registered Ajax actions.
		 */
		public $ajax_actions = array();
		/** Option Overload *******************************************************/
		/**
		 * BuddyPress options.
		 *
		 * Overloads default options retrieved from get_option().
		 *
		 * @var array
		 */
		public $options = array();
		/** Singleton *************************************************************/
		/**
		 * Main BuddyPress Instance.
		 *
		 * BuddyPress is great.
		 * Please load it only one time.
		 * For this, we thank you.
		 *
		 * Insures that only one instance of BuddyPress exists in memory at any
		 * one time. Also prevents needing to define globals all over the place.
		 *
		 * @since 1.7.0
		 *
		 * @static object $instance
		 * @see buddypress()
		 *
		 * @return BuddyPress|null The one true BuddyPress.
		 */
		public static function instance()
		{
		}
		/** Magic Methods *********************************************************/
		/**
		 * A dummy constructor to prevent BuddyPress from being loaded more than once.
		 *
		 * @since 1.7.0
		 *
		 * @see BuddyPress::instance()
		 * @see buddypress()
		 */
		private function __construct()
		{
		}
		/**
		 * A dummy magic method to prevent BuddyPress from being cloned.
		 *
		 * @since 1.7.0
		 */
		public function __clone()
		{
		}
		/**
		 * A dummy magic method to prevent BuddyPress from being unserialized.
		 *
		 * @since 1.7.0
		 */
		public function __wakeup()
		{
		}
		/**
		 * Magic method for checking the existence of a certain custom field.
		 *
		 * @since 1.7.0
		 *
		 * @param string $key Key to check the set status for.
		 *
		 * @return bool
		 */
		public function __isset($key)
		{
		}
		/**
		 * Magic method for getting BuddyPress variables.
		 *
		 * @since 1.7.0
		 *
		 * @param string $key Key to return the value for.
		 *
		 * @return mixed
		 */
		public function __get($key)
		{
		}
		/**
		 * Magic method for setting BuddyPress variables.
		 *
		 * @since 1.7.0
		 *
		 * @param string $key   Key to set a value for.
		 * @param mixed  $value Value to set.
		 */
		public function __set($key, $value)
		{
		}
		/**
		 * Magic method for unsetting BuddyPress variables.
		 *
		 * @since 1.7.0
		 *
		 * @param string $key Key to unset a value for.
		 */
		public function __unset($key)
		{
		}
		/**
		 * Magic method to prevent notices and errors from invalid method calls.
		 *
		 * @since 1.7.0
		 *
		 * @param string $name
		 * @param array  $args
		 *
		 * @return null
		 */
		public function __call($name = '', $args = array())
		{
		}
		/** Private Methods *******************************************************/
		/**
		 * Bootstrap constants.
		 *
		 * @since 1.6.0
		 */
		private function constants()
		{
		}
		/**
		 * Component global variables.
		 *
		 * @since 1.6.0
		 */
		private function setup_globals()
		{
		}
		/**
		 * Legacy BuddyPress constants.
		 *
		 * Try to avoid using these. Their values have been moved into variables
		 * in the instance, and have matching functions to get/set their values.
		 *
		 * @since 1.7.0
		 */
		private function legacy_constants()
		{
		}
		/**
		 * Include required files.
		 *
		 * @since 1.6.0
		 */
		private function includes()
		{
		}
		/**
		 * Autoload classes.
		 *
		 * @since 2.5.0
		 *
		 * @param string $class Classes to be autoloaded.
		 * @return string Path of a class.
		 */
		public function autoload($class)
		{
		}
		/**
		 * Set up the default hooks and actions.
		 *
		 * @since 1.6.0
		 */
		private function setup_actions()
		{
		}
		/**
		 * Private method to align the active and database versions.
		 *
		 * @since 1.7.0
		 */
		private function versions()
		{
		}
		/** Public Methods ********************************************************/
		/**
		 * Set up BuddyPress's legacy theme directory.
		 *
		 * Starting with version 1.2, and ending with version 1.8, BuddyPress
		 * registered a custom theme directory - bp-themes - which contained
		 * the bp-default theme. Since BuddyPress 1.9, bp-themes is no longer
		 * registered (and bp-default no longer offered) on new installations.
		 * Sites using bp-default (or a child theme of bp-default) will
		 * continue to have bp-themes registered as before.
		 * Since 12.0, BuddyPress is no longer including BP Default. To find it
		 * back, you need to install and activate the BP Classic plugin.
		 *
		 * @since 1.5.0
		 * @deprecated 12.0.0
		 */
		public function register_theme_directory()
		{
		}
		/**
		 * Register bundled theme packages.
		 *
		 * Note that since we currently have complete control over bp-themes and
		 * the bp-legacy folders, it's fine to hardcode these here. If at a
		 * later date we need to automate this, an API will need to be built.
		 *
		 * @since 1.7.0
		 */
		public function register_theme_packages()
		{
		}
		/**
		 * Set up the default BuddyPress theme compatibility location.
		 *
		 * @since 1.7.0
		 */
		public function setup_theme()
		{
		}
	}
	/**
	 * Notifications endpoints.
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Notifications_Endpoint extends \WP_REST_Controller
	{
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve notifications.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to the notifications.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Retrieve a notification.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to get information about a specific notification.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Create a notification.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to create a notification.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Update a notification.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to update a notification.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error|bool
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Delete a notification.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete a notification.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Prepares notification data to return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Notifications_Notification $notification Notification object.
		 * @param WP_REST_Request               $request      Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($notification, $request)
		{
		}
		/**
		 * Prepare a notification for create or update.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return stdClass
		 */
		protected function prepare_item_for_database($request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Notifications_Notification $notification Notification item.
		 * @return array
		 */
		protected function prepare_links($notification)
		{
		}
		/**
		 * Can this user see the notification?
		 *
		 * @since 5.0.0
		 *
		 * @param int $notification_id Notification ID.
		 * @return bool
		 */
		protected function can_see($notification_id = 0)
		{
		}
		/**
		 * Get a notification object.
		 *
		 * @since 5.0.0
		 *
		 * @param  int|WP_REST_Request $request Full details about the request or an integer.
		 * @return BP_Notifications_Notification|string A notification object|Empty string.
		 */
		public function get_notification_object($request)
		{
		}
		/**
		 * Select the item schema arguments needed for the EDITABLE method.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the notification schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for the notifications collections.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * BuddyPress Notification items.
	 *
	 * Use this class to create, access, edit, or delete BuddyPress Notifications.
	 *
	 * @since 1.9.0
	 */
	#[\AllowDynamicProperties]
	class BP_Notifications_Notification
	{
		/**
		 * The notification ID.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $id;
		/**
		 * The ID of the item associated with the notification.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $item_id;
		/**
		 * The ID of the secondary item associated with the notification.
		 *
		 * @since 1.9.0
		 * @var int|null
		 */
		public $secondary_item_id = \null;
		/**
		 * The ID of the user the notification is associated with.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $user_id;
		/**
		 * The name of the component that the notification is for.
		 *
		 * @since 1.9.0
		 * @var string
		 */
		public $component_name;
		/**
		 * The component action which the notification is related to.
		 *
		 * @since 1.9.0
		 * @var string
		 */
		public $component_action;
		/**
		 * The date the notification was created.
		 *
		 * @since 1.9.0
		 * @var string
		 */
		public $date_notified;
		/**
		 * Is the notification new, or has it already been read.
		 *
		 * @since 1.9.0
		 * @var bool
		 */
		public $is_new;
		/**
		 * Columns in the notifications table.
		 *
		 * @since 9.1.0
		 * @var array
		 */
		public static $columns = array('id', 'user_id', 'item_id', 'secondary_item_id', 'component_name', 'component_action', 'date_notified', 'is_new');
		/** Public Methods ********************************************************/
		/**
		 * Constructor method.
		 *
		 * @since 1.9.0
		 *
		 * @param int $id Optional. Provide an ID to access an existing
		 *                notification item.
		 */
		public function __construct($id = 0)
		{
		}
		/**
		 * Update or insert notification details into the database.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return bool
		 */
		public function save()
		{
		}
		/**
		 * Fetch data for an existing notification from the database.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function populate()
		{
		}
		/** Protected Static Methods **********************************************/
		/**
		 * Create a notification entry.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see wpdb::insert() for further description of parameter formats.
		 *
		 * @param array $data {
		 *     Array of notification data, passed to {@link wpdb::insert()}.
		 *     @type int    $user_id           ID of the associated user.
		 *     @type int    $item_id           ID of the associated item.
		 *     @type int    $secondary_item_id ID of the secondary associated item.
		 *     @type string $component_name    Name of the associated component.
		 *     @type string $component_action  Name of the associated component
		 *                                     action.
		 *     @type string $date_notified     Timestamp of the notification.
		 *     @type bool   $is_new            True if the notification is unread, otherwise false.
		 * }
		 * @param array $data_format See {@link wpdb::insert()}.
		 * @return int|false The number of rows inserted, or false on error.
		 */
		protected static function _insert($data = array(), $data_format = array())
		{
		}
		/**
		 * Update notifications.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see wpdb::update() for further description of parameter formats.
		 *
		 * @param array $data         Array of notification data to update, passed to
		 *                            {@link wpdb::update()}. Accepts any property of a
		 *                            BP_Notification_Notification object.
		 * @param array $where        The WHERE params as passed to wpdb::update().
		 *                            Typically consists of array( 'ID' => $id ) to specify the ID
		 *                            of the item being updated. See {@link wpdb::update()}.
		 * @param array $data_format  See {@link wpdb::insert()}.
		 * @param array $where_format See {@link wpdb::insert()}.
		 * @return int|false The number of rows updated, or false on error.
		 */
		protected static function _update($data = array(), $where = array(), $data_format = array(), $where_format = array())
		{
		}
		/**
		 * Delete notifications.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @see wpdb::delete() for further description of parameter formats.
		 *
		 * @param array $where        Array of WHERE clauses to filter by, passed to
		 *                            {@link wpdb::delete()}. Accepts any property of a
		 *                            BP_Notification_Notification object.
		 * @param array $where_format See {@link wpdb::insert()}.
		 * @return int|false The number of rows updated, or false on error.
		 */
		protected static function _delete($where = array(), $where_format = array())
		{
		}
		/**
		 * Assemble the WHERE clause of a get() SQL statement.
		 *
		 * Used by BP_Notifications_Notification::get() to create its WHERE
		 * clause.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array  $args           See {@link BP_Notifications_Notification::get()}
		 *                               for more details.
		 * @param string $select_sql     SQL SELECT fragment.
		 * @param string $from_sql       SQL FROM fragment.
		 * @param string $join_sql       SQL JOIN fragment.
		 * @param string $meta_query_sql SQL meta query fragment.
		 * @return string WHERE clause.
		 */
		protected static function get_where_sql($args = array(), $select_sql = '', $from_sql = '', $join_sql = '', $meta_query_sql = '')
		{
		}
		/**
		 * Assemble the ORDER BY clause of a get() SQL statement.
		 *
		 * Used by BP_Notifications_Notification::get() to create its ORDER BY
		 * clause.
		 *
		 * @since 1.9.0
		 *
		 * @param array $args See {@link BP_Notifications_Notification::get()}
		 *                    for more details.
		 * @return string ORDER BY clause.
		 */
		protected static function get_order_by_sql($args = array())
		{
		}
		/**
		 * Assemble the LIMIT clause of a get() SQL statement.
		 *
		 * Used by BP_Notifications_Notification::get() to create its LIMIT clause.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args See {@link BP_Notifications_Notification::get()}
		 *                    for more details.
		 * @return string $retval LIMIT clause.
		 */
		protected static function get_paged_sql($args = array())
		{
		}
		/**
		 * Assemble query clauses, based on arguments, to pass to $wpdb methods.
		 *
		 * The insert(), update(), and delete() methods of {@link wpdb} expect
		 * arguments of the following forms:
		 *
		 * - associative arrays whose key/value pairs are column => value, to
		 *   be used in WHERE, SET, or VALUES clauses.
		 * - arrays of "formats", which tell $wpdb->prepare() which type of
		 *   value to expect when sanitizing (eg, array( '%s', '%d' ))
		 *
		 * This utility method can be used to assemble both kinds of params,
		 * out of a single set of associative array arguments, such as:
		 *
		 *     $args = array(
		 *         'user_id' => 4,
		 *         'component_name' => 'groups',
		 *     );
		 *
		 * This will be converted to:
		 *
		 *     array(
		 *         'data' => array(
		 *             'user_id' => 4,
		 *             'component_name' => 'groups',
		 *         ),
		 *         'format' => array(
		 *             '%d',
		 *             '%s',
		 *         ),
		 *     )
		 *
		 * which can easily be passed as arguments to the $wpdb methods.
		 *
		 * @since 1.9.0
		 *
		 * @param array $args Associative array of filter arguments.
		 *                    See {@BP_Notifications_Notification::get()}
		 *                    for a breakdown.
		 * @return array Associative array of 'data' and 'format' args.
		 */
		protected static function get_query_clauses($args = array())
		{
		}
		/** Public Static Methods *************************************************/
		/**
		 * Check that a specific notification is for a specific user.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id         ID of the user being checked.
		 * @param int $notification_id ID of the notification being checked.
		 * @return bool True if the notification belongs to the user, otherwise false.
		 */
		public static function check_access($user_id = 0, $notification_id = 0)
		{
		}
		/**
		 * Parse notifications query arguments.
		 *
		 * @since 2.3.0
		 *
		 * @param array|string $args Args to parse.
		 * @return array
		 */
		public static function parse_args($args = '')
		{
		}
		/**
		 * Get notifications, based on provided filter parameters.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *     Associative array of arguments. All arguments but $page and
		 *     $per_page can be treated as filter values for get_where_sql()
		 *     and get_query_clauses(). All items are optional.
		 *     @type int|array    $id                ID of notification being updated. Can be an
		 *                                           array of IDs.
		 *     @type int|array    $user_id           ID of user being queried. Can be an
		 *                                           array of user IDs.
		 *     @type int|array    $item_id           ID of associated item. Can be an array
		 *                                           of multiple item IDs.
		 *     @type int|array    $secondary_item_id ID of secondary associated
		 *                                           item. Can be an array of multiple IDs.
		 *     @type string|array $component_name    Name of the component to
		 *                                           filter by. Can be an array of component names.
		 *     @type string|array $component_action  Name of the action to
		 *                                           filter by. Can be an array of actions.
		 *     @type bool         $is_new            Whether to limit to new notifications. True
		 *                                           returns only new notifications, false returns only non-new
		 *                                           notifications. 'both' returns all. Default: true.
		 *     @type string       $search_terms      Term to match against component_name
		 *                                           or component_action fields.
		 *     @type string       $order_by          Database column to order notifications by.
		 *     @type string       $sort_order        Either 'ASC' or 'DESC'.
		 *     @type int          $page              Number of the current page of results. Default:
		 *                                           false (no pagination - all items).
		 *     @type int          $per_page          Number of items to show per page. Default:
		 *                                           false (no pagination - all items).
		 *     @type array        $meta_query        Array of meta_query conditions. See WP_Meta_Query::queries.
		 *     @type array        $date_query        Array of date_query conditions. See first parameter of
		 *                                           WP_Date_Query::__construct().
		 *     @type bool         $update_meta_cache Whether to update meta cache. Default: true.
		 * }
		 * @return array Located notifications.
		 */
		public static function get($args = array())
		{
		}
		/**
		 * Get a count of total notifications matching a set of arguments.
		 *
		 * @since 1.9.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array|string $args See {@link BP_Notifications_Notification::get()}.
		 * @return int Count of located items.
		 */
		public static function get_total_count($args)
		{
		}
		/**
		 * Get the SQL for the 'meta_query' param in BP_Notifications_Notification::get().
		 *
		 * We use WP_Meta_Query to do the heavy lifting of parsing the
		 * meta_query array and creating the necessary SQL clauses. However,
		 * since BP_Notifications_Notification::get() builds its SQL differently than
		 * WP_Query, we have to alter the return value (stripping the leading
		 * AND keyword from the 'where' clause).
		 *
		 * @since 2.3.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param  array $meta_query An array of meta_query filters. See the
		 *                           documentation for WP_Meta_Query for details.
		 * @return array $sql_array 'join' and 'where' clauses.
		 */
		public static function get_meta_query_sql($meta_query = array())
		{
		}
		/**
		 * Get the SQL for the 'date_query' param in BP_Notifications_Notification::get().
		 *
		 * We use BP_Date_Query, which extends WP_Date_Query, to do the heavy lifting
		 * of parsing the date_query array and creating the necessary SQL clauses.
		 *
		 * @since 2.3.0
		 *
		 * @param array $date_query An array of date_query parameters. See the
		 *                          documentation for the first parameter of WP_Date_Query.
		 * @return string
		 */
		public static function get_date_query_sql($date_query = array())
		{
		}
		/**
		 * Update notifications.
		 *
		 * @since 1.9.0
		 *
		 * @see BP_Notifications_Notification::get() for a description of
		 *      accepted update/where arguments.
		 *
		 * @param array $update_args Associative array of fields to update,
		 *                           and the values to update them to. Of the format
		 *                           array( 'user_id' => 4, 'component_name' => 'groups', ).
		 * @param array $where_args  Associative array of columns/values, to
		 *                           determine which rows should be updated. Of the format
		 *                           array( 'item_id' => 7, 'component_action' => 'members', ).
		 * @return int|false Number of rows updated on success, false on failure.
		 */
		public static function update($update_args = array(), $where_args = array())
		{
		}
		/**
		 * Update notifications using a list of ids/items_ids.
		 *
		 * @since 10.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param string $field The name of the db field of the items to update.
		 *                      Possible values are `id` or `item_id`.
		 * @param int[]  $items The list of items to update.
		 * @param array  $data  Array of notification data to update.
		 * @param array  $where The WHERE params to use to specify the item IDs to update.
		 * @return int|false    The number of updated rows. False on error.
		 */
		public static function update_id_list($field, $items = array(), $data = array(), $where = array())
		{
		}
		/**
		 * Delete notifications.
		 *
		 * @since 1.9.0
		 *
		 * @see BP_Notifications_Notification::get() for a description of
		 *      accepted where arguments.
		 *
		 * @param array $args Associative array of columns/values, to determine
		 *                    which rows should be deleted.  Of the format
		 *                    array( 'item_id' => 7, 'component_action' => 'members', ).
		 * @return int|false Number of rows deleted on success, false on failure.
		 */
		public static function delete($args = array())
		{
		}
		/**
		 * Delete notifications using a list of ids/items_ids.
		 *
		 * @since 10.0.0
		 *
		 * @global wpdb $wpdb The WordPress database object.
		 *
		 * @param string $field The name of the db field of the items to delete.
		 *                      Possible values are `id` or `item_id`.
		 * @param int[]  $items The list of items to delete.
		 * @param array  $args  The WHERE arguments to use to specify the item IDs to delete.
		 * @return int|false    The number of deleted rows. False on error.
		 */
		public static function delete_by_id_list($field, $items = array(), $args = array())
		{
		}
		/** Convenience methods ***************************************************/
		/**
		 * Delete a single notification by ID.
		 *
		 * @since 1.9.0
		 *
		 * @see BP_Notifications_Notification::delete() for explanation of
		 *      return value.
		 *
		 * @param int $id ID of the notification item to be deleted.
		 * @return int|false True on success, false on failure.
		 */
		public static function delete_by_id($id)
		{
		}
		/**
		 * Fetch all the notifications in the database for a specific user.
		 *
		 * @since 1.9.0
		 *
		 * @param int    $user_id ID of the user whose notifications are being
		 *                        fetched.
		 * @param string $status  Optional. Status of notifications to fetch.
		 *                        'is_new' to get only unread items, 'all' to get all.
		 * @return array Associative array of notification items.
		 */
		public static function get_all_for_user($user_id, $status = 'is_new')
		{
		}
		/**
		 * Fetch all the unread notifications in the database for a specific user.
		 *
		 * @since 1.9.0
		 *
		 * @param int $user_id ID of the user whose notifications are being
		 *                     fetched.
		 * @return array Associative array of unread notification items.
		 */
		public static function get_unread_for_user($user_id = 0)
		{
		}
		/**
		 * Fetch all the read notifications in the database for a specific user.
		 *
		 * @since 1.9.0
		 *
		 * @param int $user_id ID of the user whose notifications are being
		 *                     fetched.
		 * @return array Associative array of unread notification items.
		 */
		public static function get_read_for_user($user_id = 0)
		{
		}
		/**
		 * Get unread notifications for a user, in a pagination-friendly format.
		 *
		 * @since 1.9.0
		 *
		 * @param array $args {
		 *     Array of arguments.
		 *     @type int    $user_id      ID of the user for whom the notifications are
		 *                                being fetched. Default: logged-in user ID.
		 *     @type bool   $is_new       Whether to limit the query to unread
		 *                                notifications. Default: true.
		 *     @type int    $page         Number of the page to return. Default: 1.
		 *     @type int    $per_page     Number of results to display per page.
		 *                                Default: 10.
		 *     @type string $search_terms Optional. A term to search against in
		 *                                the 'component_name' and 'component_action' columns.
		 * }
		 * @return array {
		 *     @type array $notifications Array of notification results.
		 *     @type int   $total         Count of all located notifications matching
		 *                                the query params.
		 * }
		 */
		public static function get_current_notifications_for_user($args = array())
		{
		}
		/** Mark ******************************************************************/
		/**
		 * Mark all user notifications as read.
		 *
		 * @since 1.9.0
		 *
		 * @param int    $user_id           The ID of the user who the notifications are for.
		 * @param int    $is_new            Mark as read (1) or unread (0).
		 * @param int    $item_id           Item ID being acted on.
		 * @param string $component_name    Name of component the notifications are for.
		 * @param string $component_action  Name of the component action.
		 * @param int    $secondary_item_id The ID of the secondary item.
		 * @return int|false False on failure to update. ID on success.
		 */
		public static function mark_all_for_user($user_id, $is_new = 0, $item_id = 0, $component_name = '', $component_action = '', $secondary_item_id = 0)
		{
		}
		/**
		 * Mark all notifications from a user as read.
		 *
		 * @since 1.9.0
		 *
		 * @param int    $user_id           The ID of the user who the notifications are from.
		 * @param int    $is_new            Mark as read (1) or unread (0).
		 * @param string $component_name    Name of component the notifications are for.
		 * @param string $component_action  Name of the component action.
		 * @param int    $secondary_item_id The ID of the secondary item.
		 * @return int|false
		 */
		public static function mark_all_from_user($user_id, $is_new = 0, $component_name = '', $component_action = '', $secondary_item_id = 0)
		{
		}
		/**
		 * Mark all notifications for all users as read by item id, and optional
		 * secondary item id, and component name and action.
		 *
		 * @since 1.9.0
		 *
		 * @param int    $item_id           The ID of the item associated with the
		 *                                  notifications.
		 * @param int    $is_new            Mark as read (1) or unread (0).
		 * @param string $component_name    The component that the notifications
		 *                                  are associated with.
		 * @param string $component_action  The action that the notifications
		 *                                  are associated with.
		 * @param int    $secondary_item_id Optional. ID of the secondary
		 *                                  associated item.
		 * @return int|false
		 */
		public static function mark_all_by_type($item_id, $is_new = 0, $component_name = '', $component_action = '', $secondary_item_id = 0)
		{
		}
		/**
		 * Get a user's unread notifications, grouped by component and action.
		 *
		 * Multiple notifications of the same type (those that share the same component_name
		 * and component_action) are collapsed for formatting as "You have 5 pending
		 * friendship requests", etc. See bp_notifications_get_notifications_for_user().
		 * For a full-fidelity list of user notifications, use
		 * bp_notifications_get_all_notifications_for_user().
		 *
		 * @since 3.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id ID of the user whose notifications are being fetched.
		 * @return array Notifications items for formatting into a list.
		 */
		public static function get_grouped_notifications_for_user($user_id)
		{
		}
	}
	/**
	 * The main notifications template loop class.
	 *
	 * Responsible for loading a group of notifications into a loop for display.
	 *
	 * @since 1.9.0
	 */
	class BP_Notifications_Template
	{
		/**
		 * The loop iterator.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $current_notification = -1;
		/**
		 * The number of notifications returned by the paged query.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $current_notification_count;
		/**
		 * Total number of notifications matching the query.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $total_notification_count;
		/**
		 * Array of notifications located by the query.
		 *
		 * @since 1.9.0
		 * @var array
		 */
		public $notifications;
		/**
		 * The notification object currently being iterated on.
		 *
		 * @since 1.9.0
		 * @var object
		 */
		public $notification;
		/**
		 * A flag for whether the loop is currently being iterated.
		 *
		 * @since 1.9.0
		 * @var bool
		 */
		public $in_the_loop;
		/**
		 * The ID of the user to whom the displayed notifications belong.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $user_id;
		/**
		 * The status of the notification.
		 *
		 * @since 1.9.0
		 * @var bool
		 */
		public $is_new;
		/**
		 * The total notification count.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $notification_count;
		/**
		 * The page number being requested.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $pag_page;
		/**
		 * The $_GET argument used in URLs for determining pagination.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $pag_arg;
		/**
		 * The number of items to display per page of results.
		 *
		 * @since 1.9.0
		 * @var int
		 */
		public $pag_num;
		/**
		 * An HTML string containing pagination links.
		 *
		 * @since 1.9.0
		 * @var string
		 */
		public $pag_links;
		/**
		 * A string to match against.
		 *
		 * @since 1.9.0
		 * @var string
		 */
		public $search_terms;
		/**
		 * A database column to order the results by.
		 *
		 * @since 1.9.0
		 * @var string
		 */
		public $order_by;
		/**
		 * The direction to sort the results (ASC or DESC).
		 *
		 * @since 1.9.0
		 * @var string
		 */
		public $sort_order;
		/**
		 * Array of variables used in this notification query.
		 *
		 * @since 2.2.2
		 * @var array
		 */
		public $query_vars;
		/**
		 * Constructor method.
		 *
		 * @since 1.9.0
		 *
		 * @param array $args {
		 *     An array of arguments. See {@link bp_has_notifications()}
		 *     for more details.
		 * }
		 */
		public function __construct($args = array())
		{
		}
		/**
		 * Whether there are notifications available in the loop.
		 *
		 * @since 1.9.0
		 *
		 * @see bp_has_notifications()
		 *
		 * @return bool True if there are items in the loop, otherwise false.
		 */
		public function has_notifications()
		{
		}
		/**
		 * Set up the next notification and iterate index.
		 *
		 * @since 1.9.0
		 *
		 * @return object The next notification to iterate over.
		 */
		public function next_notification()
		{
		}
		/**
		 * Rewind the blogs and reset blog index.
		 *
		 * @since 1.9.0
		 */
		public function rewind_notifications()
		{
		}
		/**
		 * Whether there are notifications left in the loop to iterate over.
		 *
		 * This method is used by {@link bp_notifications()} as part of the
		 * while loop that controls iteration inside the notifications loop, eg:
		 *     while ( bp_notifications() ) { ...
		 *
		 * @since 1.9.0
		 *
		 * @see bp_notifications()
		 *
		 * @return bool True if there are more notifications to show,
		 *              otherwise false.
		 */
		public function notifications()
		{
		}
		/**
		 * Set up the current notification inside the loop.
		 *
		 * Used by {@link bp_the_notification()} to set up the current
		 * notification data while looping, so that template tags used during
		 * that iteration make reference to the current notification.
		 *
		 * @since 1.9.0
		 *
		 * @see bp_the_notification()
		 */
		public function the_notification()
		{
		}
	}
	/**
	 * Extends the component class to set up the Notifications component.
	 *
	 * @since 1.9.0
	 */
	#[\AllowDynamicProperties]
	class BP_Notifications_Component extends \BP_Component
	{
		/**
		 * Start the notifications component creation process.
		 *
		 * @since 1.9.0
		 */
		public function __construct()
		{
		}
		/**
		 * Include notifications component files.
		 *
		 * @since 1.9.0
		 *
		 * @see BP_Component::includes() for a description of arguments.
		 *
		 * @param array $includes See BP_Component::includes() for a description.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Only load up certain code when on specific pages.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Set up component global data.
		 *
		 * @since 1.9.0
		 *
		 * @see BP_Component::setup_globals() for a description of arguments.
		 *
		 * @param array $args See BP_Component::setup_globals() for a description.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @see `BP_Component::register_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::register_nav()` for
		 *                        description.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up component navigation.
		 *
		 * @since 1.9.0
		 * @since 12.0.0 Used to customize the main navigation name.
		 *
		 * @see `BP_Component::setup_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 * @param array $sub_nav  Optional. See `BP_Component::setup_nav()` for
		 *                        description.
		 */
		public function setup_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up the component entries in the WordPress Admin Bar.
		 *
		 * @since 1.9.0
		 *
		 * @see BP_Component::setup_nav() for a description of the $wp_admin_nav
		 *      parameter array.
		 *
		 * @param array $wp_admin_nav See BP_Component::setup_admin_bar() for a
		 *                            description.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Set up the title for pages and <title>.
		 *
		 * @since 1.9.0
		 */
		public function setup_title()
		{
		}
		/**
		 * Setup cache groups.
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Init the BP REST API.
		 *
		 * @since 5.0.0
		 *
		 * @param array $controllers Optional. See BP_Component::rest_api_init() for
		 *                           description.
		 */
		public function rest_api_init($controllers = array())
		{
		}
	}
	/**
	 * Class for generating the WHERE SQL clause for advanced activity fetching.
	 *
	 * This is notably used in {@link BP_Activity_Activity::get()} with the
	 * 'filter_query' parameter.
	 *
	 * @since 2.2.0
	 */
	class BP_Activity_Query extends \BP_Recursive_Query
	{
		/**
		 * Array of activity queries.
		 *
		 * See {@see BP_Activity_Query::__construct()} for information on query arguments.
		 *
		 * @since 2.2.0
		 * @var array
		 */
		public $queries = array();
		/**
		 * Table alias.
		 *
		 * @since 2.2.0
		 * @var string
		 */
		public $table_alias = '';
		/**
		 * Supported DB columns.
		 *
		 * See the 'wp_bp_activity' DB table schema.
		 *
		 * @since 2.2.0
		 * @var array
		 */
		public $db_columns = array('id', 'user_id', 'component', 'type', 'action', 'content', 'primary_link', 'item_id', 'secondary_item_id', 'hide_sitewide', 'is_spam');
		/**
		 * Constructor.
		 *
		 * @since 2.2.0
		 *
		 * @param array $query {
		 *     Array of query clauses.
		 *     @type array {
		 *         @type string $column   Required. The column to query against. Basically, any DB column in the main
		 *                                'wp_bp_activity' table.
		 *         @type string $value    Required. Value to filter by.
		 *         @type string $compare  Optional. The comparison operator. Default '='.
		 *                                Accepts '=', '!=', '>', '>=', '<', '<=', 'IN', 'NOT IN', 'LIKE',
		 *                                'NOT LIKE', BETWEEN', 'NOT BETWEEN', 'REGEXP', 'NOT REGEXP', 'RLIKE'.
		 *         @type string $relation Optional. The boolean relationship between the activity queries.
		 *                                Accepts 'OR', 'AND'. Default 'AND'.
		 *         @type array {
		 *             Optional. Another fully-formed activity query. See parameters above.
		 *         }
		 *     }
		 * }
		 */
		public function __construct($query = array())
		{
		}
		/**
		 * Generates WHERE SQL clause to be appended to a main query.
		 *
		 * @since 2.2.0
		 *
		 * @param string $alias An existing table alias that is compatible with the current query clause.
		 *                      Default: 'a'. BP_Activity_Activity::get() uses 'a', so we default to that.
		 * @return string SQL fragment to append to the main WHERE clause.
		 */
		public function get_sql($alias = 'a')
		{
		}
		/**
		 * Generate WHERE clauses for a first-order clause.
		 *
		 * @since 2.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param  array $clause       Array of arguments belonging to the clause.
		 * @param  array $parent_query Parent query to which the clause belongs.
		 * @return array {
		 *     @type array $where Array of subclauses for the WHERE statement.
		 *     @type array $join  Empty array. Not used.
		 * }
		 */
		protected function get_sql_for_clause($clause, $parent_query)
		{
		}
		/**
		 * Determine whether a clause is first-order.
		 *
		 * @since 2.2.0
		 *
		 * @param array $query Clause to check.
		 * @return bool
		 */
		protected function is_first_order_clause($query)
		{
		}
		/**
		 * Validates a column name parameter.
		 *
		 * Column names are checked against a list of known tables.
		 * See {@link BP_Activity_Query::db_tables}.
		 *
		 * @since 2.2.0
		 *
		 * @param string $column The user-supplied column name.
		 * @return string A validated column name value.
		 */
		public function validate_column($column = '')
		{
		}
	}
	/**
	 * Create a RSS feed using the activity component.
	 *
	 * You should only construct a new feed when you've validated that you're on
	 * the appropriate screen.
	 *
	 * @since 1.8.0
	 *
	 * See {@link bp_activity_action_sitewide_feed()} as an example.
	 *
	 * @param array $args {
	 *   @type string $id               Required. Internal id for the feed; should be alphanumeric only.
	 *   @type string $title            Optional. RSS feed title.
	 *   @type string $link             Optional. Relevant link for the RSS feed.
	 *   @type string $description      Optional. RSS feed description.
	 *   @type string $ttl              Optional. Time-to-live. (see inline doc in constructor)
	 *   @type string $update_period    Optional. Part of the syndication module.
	 *                                            (see inline doc in constructor for more info)
	 *   @type string $update_frequency Optional. Part of the syndication module.
	 *                                            (see inline doc in constructor for more info)
	 *   @type string $max              Optional. Number of feed items to display.
	 *   @type array  $activity_args    Optional. Arguments passed to {@link bp_has_activities()}
	 * }
	 */
	class BP_Activity_Feed
	{
		/**
		 * Holds our custom class properties.
		 *
		 * These variables are stored in a protected array that is magically
		 * updated using PHP 5.2+ methods.
		 *
		 * @see BP_Feed::__construct() This is where $data is added.
		 *
		 * @since 1.8.0
		 * @var array
		 */
		protected $data;
		/**
		 * Magic method for checking the existence of a certain data variable.
		 *
		 * @since 1.8.0
		 *
		 * @param string $key Property to check.
		 * @return bool Whether or not data variable exists.
		 */
		public function __isset($key)
		{
		}
		/**
		 * Magic method for getting a certain data variable.
		 *
		 * @since 1.8.0
		 *
		 * @param string $key Property to get.
		 * @return mixed Data in variable if available or null.
		 */
		public function __get($key)
		{
		}
		/**
		 * Magic method for setting a certain data variable.
		 *
		 * @since 2.4.0
		 *
		 * @param string $key   The property to set.
		 * @param mixed  $value The value to set.
		 */
		public function __set($key, $value)
		{
		}
		/**
		 * Constructor.
		 *
		 * @since 1.8.0
		 *
		 * @global WP_Query $wp_query WordPress query object.
		 *
		 * @param array $args Optional.
		 */
		public function __construct($args = array())
		{
		}
		/** SETUP ****************************************************************/
		/**
		 * Setup and validate the class properties.
		 *
		 * @since 1.8.0
		 */
		protected function setup_properties()
		{
		}
		/**
		 * Setup some hooks that are used in the feed.
		 *
		 * Currently, these hooks are used to maintain backwards compatibility with
		 * the RSS feeds previous to BP 1.8.
		 *
		 * @since 1.8.0
		 */
		protected function setup_hooks()
		{
		}
		/** BACKPAT HOOKS ********************************************************/
		/**
		 * Fire a hook to ensure backward compatibility for RSS attributes.
		 *
		 * @since 1.8.0
		 */
		public function backpat_rss_attributes()
		{
		}
		/**
		 * Fire a hook to ensure backward compatibility for channel elements.
		 *
		 * @since 1.8.0
		 */
		public function backpat_channel_elements()
		{
		}
		/**
		 * Fire a hook to ensure backward compatibility for item elements.
		 *
		 * @since 1.8.0
		 */
		public function backpat_item_elements()
		{
		}
		/** HELPERS **************************************************************/
		/**
		 * Output the feed's item content.
		 *
		 * @since 1.8.0
		 */
		protected function feed_content()
		{
		}
		/**
		 * Sets various HTTP headers related to Content-Type and browser caching.
		 *
		 * Most of this class method is derived from {@link WP::send_headers()}.
		 *
		 * @since 1.9.0
		 *
		 * @global WP_Query $wp_query WordPress query object.
		 */
		protected function http_headers()
		{
		}
		/** OUTPUT ***************************************************************/
		/**
		 * Output the RSS feed.
		 *
		 * @since 1.8.0
		 */
		protected function output()
		{
		}
	}
	/**
	 * Activity endpoints.
	 *
	 * @since 5.0.0
	 */
	class BP_REST_Activity_Endpoint extends \WP_REST_Controller
	{
		/**
		 * User favorites.
		 *
		 * @since 5.0.0
		 *
		 * @var array|null
		 */
		protected $user_favorites = \null;
		/**
		 * Constructor.
		 *
		 * @since 5.0.0
		 */
		public function __construct()
		{
		}
		/**
		 * Register the component routes.
		 *
		 * @since 5.0.0
		 */
		public function register_routes()
		{
		}
		/**
		 * Retrieve activities.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response List of activities response data.
		 */
		public function get_items($request)
		{
		}
		/**
		 * Check if a given request has access to activity items.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_items_permissions_check($request)
		{
		}
		/**
		 * Retrieve an activity.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function get_item($request)
		{
		}
		/**
		 * Check if a given request has access to get information about a specific activity.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full data about the request.
		 * @return true|WP_Error
		 */
		public function get_item_permissions_check($request)
		{
		}
		/**
		 * Create an activity.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full data about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function create_item($request)
		{
		}
		/**
		 * Checks if a given request has access to create an activity.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function create_item_permissions_check($request)
		{
		}
		/**
		 * Update an activity.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_item($request)
		{
		}
		/**
		 * Check if a given request has access to update an activity.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_item_permissions_check($request)
		{
		}
		/**
		 * Delete activity.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function delete_item($request)
		{
		}
		/**
		 * Check if a given request has access to delete an activity.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function delete_item_permissions_check($request)
		{
		}
		/**
		 * Gets the current user's favorites.
		 *
		 * @since 5.0.0
		 *
		 * @return array Array of activity IDs.
		 */
		public function get_user_favorites()
		{
		}
		/**
		 * Adds or removes the activity from the current user's favorites.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return WP_REST_Response|WP_Error
		 */
		public function update_favorite($request)
		{
		}
		/**
		 * Check if a given request has access to update user favorites.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return true|WP_Error
		 */
		public function update_favorite_permissions_check($request)
		{
		}
		/**
		 * Renders the content of an activity.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Activity_Activity $activity Activity data.
		 * @return string The rendered activity content.
		 */
		public function render_item($activity)
		{
		}
		/**
		 * Prepares activity data for return as an object.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Activity_Activity $activity Activity object.
		 * @param WP_REST_Request      $request  Full details about the request.
		 * @return WP_REST_Response
		 */
		public function prepare_item_for_response($activity, $request)
		{
		}
		/**
		 * Prepare activity comments.
		 *
		 * @since 5.0.0
		 *
		 * @param  array           $comments Array of comments.
		 * @param  WP_REST_Request $request  Full details about the request.
		 * @return array           An array of activity comments.
		 */
		protected function prepare_activity_comments($comments, $request)
		{
		}
		/**
		 * Prepare an activity for create or update.
		 *
		 * @since 5.0.0
		 *
		 * @param WP_REST_Request $request Full details about the request.
		 * @return stdClass|WP_Error Object or WP_Error.
		 */
		protected function prepare_item_for_database($request)
		{
		}
		/**
		 * Prepare links for the request.
		 *
		 * @since 5.0.0
		 *
		 * @param BP_Activity_Activity $activity Activity object.
		 * @return array
		 */
		protected function prepare_links($activity)
		{
		}
		/**
		 * Can this user see the activity?
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return boolean
		 */
		protected function can_see($request)
		{
		}
		/**
		 * Show hidden activity?
		 *
		 * @since 5.0.0
		 *
		 * @param  string $component The component the activity is from.
		 * @param  int    $item_id   The activity item ID.
		 * @return boolean
		 */
		protected function show_hidden($component, $item_id)
		{
		}
		/**
		 * Get activity object.
		 *
		 * @since 5.0.0
		 *
		 * @param  WP_REST_Request $request Full details about the request.
		 * @return BP_Activity_Activity|string An activity object.
		 */
		public function get_activity_object($request)
		{
		}
		/**
		 * Edit the type of the some properties for the CREATABLE & EDITABLE methods.
		 *
		 * @since 5.0.0
		 *
		 * @param string $method Optional. HTTP method of the request.
		 * @return array Endpoint arguments.
		 */
		public function get_endpoint_args_for_item_schema($method = \WP_REST_Server::CREATABLE)
		{
		}
		/**
		 * Get the plugin schema, conforming to JSON Schema.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_item_schema()
		{
		}
		/**
		 * Get the query params for collections of plugins.
		 *
		 * @since 5.0.0
		 *
		 * @return array
		 */
		public function get_collection_params()
		{
		}
	}
	/**
	 * Akismet support for the Activity component.
	 *
	 * @since 1.6.0
	 * @since 2.3.0 We only support Akismet 3+.
	 */
	class BP_Akismet
	{
		/**
		 * The activity last marked as spam.
		 *
		 * @since 1.6.0
		 * @var BP_Activity_Activity
		 */
		protected $last_activity = \null;
		/**
		 * Constructor.
		 *
		 * @since 1.6.0
		 */
		public function __construct()
		{
		}
		/**
		 * Hook Akismet into the activity stream.
		 *
		 * @since 1.6.0
		 */
		protected function setup_actions()
		{
		}
		/**
		 * Add a history item to the hover links in an activity's row.
		 *
		 * This function lifted with love from the Akismet WordPress plugin's
		 * akismet_comment_row_action() function. Thanks!
		 *
		 * @since 1.6.0
		 *
		 * @param array $actions  The hover links.
		 * @param array $activity The activity for the current row being processed.
		 * @return array The hover links.
		 */
		function comment_row_action($actions, $activity)
		{
		}
		/**
		 * Generate nonces for activity forms.
		 *
		 * These nonces appear in the member profile status form, as well as in
		 * the reply form of each activity item. The nonces are, in turn, used
		 * by Akismet to help detect spam activity.
		 *
		 * @since 1.6.0
		 *
		 * @see https://plugins.trac.wordpress.org/ticket/1232
		 */
		public function add_activity_stream_nonce()
		{
		}
		/**
		 * Clean up the bp_latest_update usermeta in case of spamming.
		 *
		 * Run just after an update is posted, this method check to see whether
		 * the newly created update has been marked as spam by Akismet. If so,
		 * the cached update is cleared from the user's 'bp_latest_update'
		 * usermeta, ensuring that it won't appear in the member header and
		 * elsewhere in the theme.
		 *
		 * This can't be done in BP_Akismet::check_activity() due to the
		 * default AJAX implementation; see bp_dtheme_post_update().
		 *
		 * @since 1.6.0
		 *
		 * @see bp_dtheme_post_update()
		 *
		 * @param string $content     Activity update text.
		 * @param int    $user_id     User ID.
		 * @param int    $activity_id Activity ID.
		 */
		public function check_member_activity_update($content, $user_id, $activity_id)
		{
		}
		/**
		 * Adds a "mark as spam" button to each activity item for site admins.
		 *
		 * This function is intended to be used inside the activity stream loop.
		 *
		 * @since 1.6.0
		 */
		public function add_activity_spam_button()
		{
		}
		/**
		 * Adds a "mark as spam" button to each activity COMMENT item for site admins.
		 *
		 * This function is intended to be used inside the activity stream loop.
		 *
		 * @since 1.6.0
		 */
		public function add_activity_comment_spam_button()
		{
		}
		/**
		 * Get a filterable list of activity types that Akismet should automatically check for spam.
		 *
		 * @since 1.6.0
		 *
		 * @static
		 *
		 * @return array $value List of activity types.
		 */
		public static function get_activity_types()
		{
		}
		/**
		 * Mark activity item as spam.
		 *
		 * @since 1.6.0
		 *
		 * @param BP_Activity_Activity $activity Activity item being spammed.
		 * @param string               $source   Either "by_a_person" (e.g. a person has
		 *                                       manually marked the activity as spam) or
		 *                                       "by_akismet" (automatically spammed).
		 */
		public function mark_as_spam($activity, $source)
		{
		}
		/**
		 * Mark activity item as ham.
		 *
		 * @since 1.6.0
		 *
		 * @param BP_Activity_Activity $activity Activity item being hammed.
		 * @param string               $source   Either "by_a_person" (e.g. a person has
		 *                                       manually marked the activity as ham) or
		 *                                       "by_akismet" (automatically hammed).
		 */
		public function mark_as_ham($activity, $source)
		{
		}
		/**
		 * Build a data package for the Akismet service to inspect.
		 *
		 * @since 1.6.0
		 *
		 * @see http://akismet.com/development/api/#comment-check
		 * @static
		 *
		 * @param BP_Activity_Activity $activity Activity item data.
		 * @return array $activity_data
		 */
		public static function build_akismet_data_package($activity)
		{
		}
		/**
		 * Check if the activity item is spam or ham.
		 *
		 * @since 1.6.0
		 *
		 * @see http://akismet.com/development/api/
		 * @todo Spam counter?
		 * @todo Auto-delete old spam?
		 *
		 * @param BP_Activity_Activity $activity The activity item to check.
		 */
		public function check_activity($activity)
		{
		}
		/**
		 * Update activity meta after a manual spam change (user-initiated).
		 *
		 * @since 1.6.0
		 *
		 * @param BP_Activity_Activity $activity The activity to check.
		 */
		public function update_activity_spam_meta($activity)
		{
		}
		/**
		 * Update activity meta after a manual ham change (user-initiated).
		 *
		 * @since 1.6.0
		 *
		 * @param BP_Activity_Activity $activity The activity to check.
		 */
		public function update_activity_ham_meta($activity)
		{
		}
		/**
		 * Update activity meta after an automatic spam check (not user-initiated).
		 *
		 * @since 1.6.0
		 *
		 * @param BP_Activity_Activity $activity The activity to check.
		 */
		public function update_activity_akismet_meta($activity)
		{
		}
		/**
		 * Contact Akismet to check if this is spam or ham.
		 *
		 * Props to WordPress core Akismet plugin for a lot of this.
		 *
		 * @since 1.6.0
		 *
		 * @param array  $activity_data Packet of information to submit to Akismet.
		 * @param string $check         "check" or "submit".
		 * @param string $spam          "spam" or "ham".
		 * @return array $activity_data Activity data, with Akismet data added.
		 */
		public function send_akismet_request($activity_data, $check = 'check', $spam = 'spam')
		{
		}
		/**
		 * Filters user agent when sending to Akismet to add BuddyPress info.
		 *
		 * @since 1.6.0
		 *
		 * @param string $user_agent User agent string, as generated by Akismet.
		 * @return string $user_agent Modified user agent string.
		 */
		public function buddypress_ua($user_agent)
		{
		}
		/**
		 * Adds a "History" meta box to the activity edit screen.
		 *
		 * @since 1.6.0
		 *
		 * @param string $screen_action The type of screen that has been requested.
		 */
		function add_history_metabox($screen_action)
		{
		}
		/**
		 * History meta box for the Activity admin edit screen.
		 *
		 * @since 1.6.0
		 *
		 * @see https://buddypress.trac.wordpress.org/ticket/3907
		 * @todo Update activity meta to allow >1 record with the same key (iterate through $history).
		 *
		 * @param object $item Activity item.
		 */
		function history_metabox($item)
		{
		}
		/**
		 * Update an activity item's Akismet history.
		 *
		 * @since 1.6.0
		 *
		 * @param int    $activity_id Activity item ID.
		 * @param string $message     Human-readable description of what's changed.
		 * @param string $event       The type of check we were carrying out.
		 */
		public function update_activity_history($activity_id = 0, $message = '', $event = '')
		{
		}
		/**
		 * Get an activity item's Akismet history.
		 *
		 * @since 1.6.0
		 *
		 * @param int $activity_id Activity item ID.
		 * @return array The activity item's Akismet history.
		 */
		public function get_activity_history($activity_id = 0)
		{
		}
	}
	/**
	 * Database interaction class for the BuddyPress activity component.
	 * Instance methods are available for creating/editing an activity,
	 * static methods for querying activities.
	 *
	 * @since 1.0.0
	 */
	#[\AllowDynamicProperties]
	class BP_Activity_Activity
	{
		/** Properties ************************************************************/
		/**
		 * ID of the activity item.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		var $id;
		/**
		 * ID of the associated item.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		var $item_id;
		/**
		 * ID of the associated secondary item.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		var $secondary_item_id;
		/**
		 * ID of user associated with the activity item.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		var $user_id;
		/**
		 * The primary URL for the activity in RSS feeds.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		var $primary_link = '';
		/**
		 * BuddyPress component the activity item relates to.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		var $component = '';
		/**
		 * Activity type, eg 'new_blog_post'.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		var $type = '';
		/**
		 * Description of the activity, eg 'Alex updated his profile.'.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		var $action = '';
		/**
		 * The content of the activity item.
		 *
		 * @since 1.2.0
		 * @var string
		 */
		var $content = '';
		/**
		 * The date the activity item was recorded, in 'Y-m-d h:i:s' format.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		var $date_recorded = '';
		/**
		 * Whether the item should be hidden in sitewide streams.
		 *
		 * @since 1.1.0
		 * @var int
		 */
		var $hide_sitewide = 0;
		/**
		 * Node boundary start for activity or activity comment.
		 *
		 * @since 1.5.0
		 * @var int
		 */
		var $mptt_left;
		/**
		 * Node boundary end for activity or activity comment.
		 *
		 * @since 1.5.0
		 * @var int
		 */
		var $mptt_right;
		/**
		 * Whether this item is marked as spam.
		 *
		 * @since 1.6.0
		 * @var int
		 */
		var $is_spam;
		/**
		 * Error holder.
		 *
		 * @since 2.6.0
		 *
		 * @var WP_Error
		 */
		public $errors;
		/**
		 * Error type to return. Either 'bool' or 'wp_error'.
		 *
		 * @since 2.6.0
		 *
		 * @var string
		 */
		public $error_type = 'bool';
		/**
		 * Constructor method.
		 *
		 * @since 1.5.0
		 *
		 * @param int|bool $id Optional. The ID of a specific activity item.
		 */
		public function __construct($id = \false)
		{
		}
		/**
		 * Populate the object with data about the specific activity item.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 */
		public function populate()
		{
		}
		/**
		 * Save the activity item to the database.
		 *
		 * @since 1.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return WP_Error|bool True on success.
		 */
		public function save()
		{
		}
		/** Static Methods ***************************************************/
		/**
		 * Get activity items, as specified by parameters.
		 *
		 * @since 1.2.0
		 * @since 2.4.0 Introduced the `$fields` parameter.
		 * @since 2.9.0 Introduced the `$order_by` parameter.
		 * @since 10.0.0 Introduced the `$count_total_only` parameter.
		 * @since 11.0.0 Introduced the `$user_id__in` and `$user_id__not_in` parameters.
		 *
		 * @see BP_Activity_Activity::get_filter_sql() for a description of the
		 *      'filter' parameter.
		 * @see WP_Meta_Query::queries for a description of the 'meta_query'
		 *      parameter format.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *     An array of arguments. All items are optional.
		 *     @type int          $page              Which page of results to fetch. Using page=1 without per_page will result
		 *                                           in no pagination. Default: 1.
		 *     @type int|bool     $per_page          Number of results per page. Default: 25.
		 *     @type int|bool     $max               Maximum number of results to return. Default: false (unlimited).
		 *     @type string       $fields            Activity fields to return. Pass 'ids' to get only the activity IDs.
		 *                                           'all' returns full activity objects.
		 *     @type string       $sort              ASC or DESC. Default: 'DESC'.
		 *     @type string       $order_by          Column to order results by.
		 *     @type array        $exclude           Array of activity IDs to exclude. Default: false.
		 *     @type array        $in                Array of ids to limit query by (IN). Default: false.
		 *     @type array        $meta_query        Array of meta_query conditions. See WP_Meta_Query::queries.
		 *     @type array        $date_query        Array of date_query conditions. See first parameter of
		 *                                           WP_Date_Query::__construct().
		 *     @type array        $filter_query      Array of advanced query conditions. See BP_Activity_Query::__construct().
		 *     @type string|array $scope             Pre-determined set of activity arguments.
		 *     @type array        $filter            See BP_Activity_Activity::get_filter_sql().
		 *     @type array        $user_id__in       An array of user ids to include. Activity posted by users matching one of these
		 *                                           user ids will be included in results. Default empty array.
		 *     @type array        $user_id__not_in   An array of user ids to exclude. Activity posted by users matching one of these
		 *                                           user ids will not be included in results. Default empty array.
		 *     @type string       $search_terms      Limit results by a search term. Default: false.
		 *     @type bool         $display_comments  Whether to include activity comments. Default: false.
		 *     @type bool         $show_hidden       Whether to show items marked hide_sitewide. Default: false.
		 *     @type string       $spam              Spam status. Default: 'ham_only'.
		 *     @type bool         $update_meta_cache Whether to pre-fetch metadata for queried activity items. Default: true.
		 *     @type string|bool  $count_total       If true, an additional DB query is run to count the total activity items
		 *                                           for the query. Default: false.
		 *     @type bool         $count_total_only  If true, only the DB query to count the total activity items is run.
		 *                                           Default: false.
		 * }
		 * @return array The array returned has two keys:
		 *               - 'total' is the count of located activities
		 *               - 'activities' is an array of the located activities
		 */
		public static function get($args = array())
		{
		}
		/**
		 * Convert activity IDs to activity objects, as expected in template loop.
		 *
		 * @since 2.0.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $activity_ids Array of activity IDs.
		 * @return array
		 */
		protected static function get_activity_data($activity_ids = array())
		{
		}
		/**
		 * Append xProfile fullnames to an activity array.
		 *
		 * @since 2.0.0
		 *
		 * @param array $activities Activities array.
		 * @return array
		 */
		protected static function append_user_fullnames($activities)
		{
		}
		/**
		 * Pre-fetch data for objects associated with activity items.
		 *
		 * Activity items are associated with users, and often with other
		 * BuddyPress data objects. Here, we pre-fetch data about these
		 * associated objects, so that inline lookups - done primarily when
		 * building action strings - do not result in excess database queries.
		 *
		 * The only object data required for activity component activity types
		 * (activity_update and activity_comment) is related to users, and that
		 * info is fetched separately in BP_Activity_Activity::get_activity_data().
		 * So this method contains nothing but a filter that allows other
		 * components, such as bp-friends and bp-groups, to hook in and prime
		 * their own caches at the beginning of an activity loop.
		 *
		 * @since 2.0.0
		 *
		 * @param array $activities Array of activities.
		 * @return array $activities Array of activities.
		 */
		protected static function prefetch_object_data($activities)
		{
		}
		/**
		 * Generate action strings for the activities located in BP_Activity_Activity::get().
		 *
		 * If no string can be dynamically generated for a given item
		 * (typically because the activity type has not been properly
		 * registered), the static 'action' value pulled from the database will
		 * be left in place.
		 *
		 * @since 2.0.0
		 *
		 * @param array $activities Array of activities.
		 * @return array
		 */
		protected static function generate_action_strings($activities)
		{
		}
		/**
		 * Get the SQL for the 'meta_query' param in BP_Activity_Activity::get().
		 *
		 * We use WP_Meta_Query to do the heavy lifting of parsing the
		 * meta_query array and creating the necessary SQL clauses. However,
		 * since BP_Activity_Activity::get() builds its SQL differently than
		 * WP_Query, we have to alter the return value (stripping the leading
		 * AND keyword from the 'where' clause).
		 *
		 * @since 1.8.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $meta_query An array of meta_query filters. See the
		 *                          documentation for WP_Meta_Query for details.
		 * @return array $sql_array 'join' and 'where' clauses.
		 */
		public static function get_meta_query_sql($meta_query = array())
		{
		}
		/**
		 * Get the SQL for the 'date_query' param in BP_Activity_Activity::get().
		 *
		 * We use BP_Date_Query, which extends WP_Date_Query, to do the heavy lifting
		 * of parsing the date_query array and creating the necessary SQL clauses.
		 *
		 * @since 2.1.0
		 *
		 * @param array $date_query An array of date_query parameters. See the
		 *                          documentation for the first parameter of WP_Date_Query.
		 * @return string
		 */
		public static function get_date_query_sql($date_query = array())
		{
		}
		/**
		 * Get the SQL for the 'scope' param in BP_Activity_Activity::get().
		 *
		 * A scope is a predetermined set of activity arguments.  This method is used
		 * to grab these activity arguments and override any existing args if needed.
		 *
		 * Can handle multiple scopes.
		 *
		 * @since 2.2.0
		 *
		 * @param  mixed $scope  The activity scope. Accepts string or array of scopes.
		 * @param  array $r      Current activity arguments. Same as those of BP_Activity_Activity::get(),
		 *                       but merged with defaults.
		 * @return false|array 'sql' WHERE SQL string and 'override' activity args.
		 */
		public static function get_scope_query_sql($scope = \false, $r = array())
		{
		}
		/**
		 * In BuddyPress 1.2.x, this was used to retrieve specific activity stream items (for example, on an activity's permalink page).
		 *
		 * As of 1.5.x, use BP_Activity_Activity::get() with an 'in' parameter instead.
		 *
		 * @since 1.2.0
		 *
		 * @deprecated 1.5
		 * @deprecated Use BP_Activity_Activity::get() with an 'in' parameter instead.
		 *
		 * @param mixed    $activity_ids     Array or comma-separated string of activity IDs to retrieve.
		 * @param int|bool $max              Maximum number of results to return. (Optional; default is no maximum).
		 * @param int      $page             The set of results that the user is viewing. Used in pagination. (Optional; default is 1).
		 * @param int      $per_page         Specifies how many results per page. Used in pagination. (Optional; default is 25).
		 * @param string   $sort             MySQL column sort; ASC or DESC. (Optional; default is DESC).
		 * @param bool     $display_comments Retrieve an activity item's associated comments or not. (Optional; default is false).
		 * @return array
		 */
		public static function get_specific($activity_ids, $max = \false, $page = 1, $per_page = 25, $sort = 'DESC', $display_comments = \false)
		{
		}
		/**
		 * Get the first activity ID that matches a set of criteria.
		 *
		 * @since 1.2.0
		 * @since 10.0.0 Parameters were made optional.
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *     An array of arguments. All items are optional.
		 *     @type int    $user_id           User ID to filter by.
		 *     @type string $component         Component to filter by.
		 *     @type string $type              Activity type to filter by.
		 *     @type int    $item_id           Associated item to filter by.
		 *     @type int    $secondary_item_id Secondary associated item to filter by.
		 *     @type string $action            Action to filter by.
		 *     @type string $content           Content to filter by.
		 *     @type string $date_recorded     Date to filter by.
		 * }
		 * @return int|false Activity ID on success, false if none is found.
		 */
		public static function get_id($args = array())
		{
		}
		/**
		 * Delete activity items from the database.
		 *
		 * To delete a specific activity item, pass an 'id' parameter.
		 * Otherwise use the filters.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array $args {
		 *     @int    $id                Optional. The ID of a specific item to delete.
		 *     @string $action            Optional. The action to filter by.
		 *     @string $content           Optional. The content to filter by.
		 *     @string $component         Optional. The component name to filter by.
		 *     @string $type              Optional. The activity type to filter by.
		 *     @string $primary_link      Optional. The primary URL to filter by.
		 *     @int    $user_id           Optional. The user ID to filter by.
		 *     @int    $item_id           Optional. The associated item ID to filter by.
		 *     @int    $secondary_item_id Optional. The secondary associated item ID to filter by.
		 *     @string $date_recorded     Optional. The date to filter by.
		 *     @int    $hide_sitewide     Optional. Default: false.
		 * }
		 * @return array|bool An array of deleted activity IDs on success, false on failure.
		 */
		public static function delete($args = array())
		{
		}
		/**
		 * Delete the comments associated with a set of activity items.
		 *
		 * This method is no longer used by BuddyPress, and it is recommended not to
		 * use it going forward, and use BP_Activity_Activity::delete() instead.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @deprecated 2.3.0
		 *
		 * @param array $activity_ids Activity IDs whose comments should be deleted.
		 * @param bool  $delete_meta  Should we delete the activity meta items for these comments.
		 * @return bool
		 */
		public static function delete_activity_item_comments($activity_ids = array(), $delete_meta = \true)
		{
		}
		/**
		 * Delete the meta entries associated with a set of activity items.
		 *
		 * @since 1.2.0
		 *
		 * @param array $activity_ids Activity IDs whose meta should be deleted.
		 * @return bool
		 */
		public static function delete_activity_meta_entries($activity_ids = array())
		{
		}
		/**
		 * Append activity comments to their associated activity items.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param array  $activities Activities to fetch comments for.
		 * @param string $spam       Optional. 'ham_only' (default), 'spam_only' or 'all'.
		 * @return array The updated activities with nested comments.
		 */
		public static function append_comments($activities, $spam = 'ham_only')
		{
		}
		/**
		 * Get activity comments that are associated with a specific activity ID.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int    $activity_id         Activity ID to fetch comments for.
		 * @param int    $left                Left-most node boundary.
		 * @param int    $right               Right-most node boundary.
		 * @param string $spam                Optional. 'ham_only' (default), 'spam_only' or 'all'.
		 * @param int    $top_level_parent_id Optional. The id of the root-level parent activity item.
		 * @return array The updated activities with nested comments.
		 */
		public static function get_activity_comments($activity_id, $left, $right, $spam = 'ham_only', $top_level_parent_id = 0)
		{
		}
		/**
		 * Rebuild nested comment tree under an activity or activity comment.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $parent_id ID of an activity or activity comment.
		 * @param int $left      Node boundary start for activity or activity comment.
		 * @return int Right Node boundary of activity or activity comment.
		 */
		public static function rebuild_activity_comment_tree($parent_id, $left = 1)
		{
		}
		/**
		 * Get child comments of an activity or activity comment.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $parent_id ID of an activity or activity comment.
		 * @return object Numerically indexed array of child comments.
		 */
		public static function get_child_comments($parent_id)
		{
		}
		/**
		 * Get a list of components that have recorded activity associated with them.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param bool $skip_last_activity If true, components will not be
		 *                                 included if the only activity type associated with them is
		 *                                 'last_activity'. (Since 2.0.0, 'last_activity' is stored in
		 *                                 the activity table, but these items are not full-fledged
		 *                                 activity items.) Default: true.
		 * @return array List of component names.
		 */
		public static function get_recorded_components($skip_last_activity = \true)
		{
		}
		/**
		 * Get sitewide activity items for use in an RSS feed.
		 *
		 * @since 1.0.0
		 *
		 * @param int $limit Optional. Number of items to fetch. Default: 35.
		 * @return array $activity_feed List of activity items, with RSS data added.
		 */
		public static function get_sitewide_items_for_feed($limit = 35)
		{
		}
		/**
		 * Create SQL IN clause for filter queries.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Activity_Activity::get_filter_sql()
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string     $field The database field.
		 * @param array|bool $items The values for the IN clause, or false when none are found.
		 * @return string|false
		 */
		public static function get_in_operator_sql($field, $items)
		{
		}
		/**
		 * Create filter SQL clauses.
		 *
		 * @since 1.5.0
		 *
		 * @param array $filter_array {
		 *     Fields and values to filter by.
		 *
		 *     @type array|string|int $user_id      User ID(s).
		 *     @type array|string     $object       Corresponds to the 'component'
		 *                                          column in the database.
		 *     @type array|string     $action       Corresponds to the 'type' column
		 *                                          in the database.
		 *     @type array|string|int $primary_id   Corresponds to the 'item_id'
		 *                                          column in the database.
		 *     @type array|string|int $secondary_id Corresponds to the
		 *                                          'secondary_item_id' column in the database.
		 *     @type int              $offset       Return only those items with an ID greater
		 *                                          than the offset value.
		 *     @type int              $offset_lower Return only those items with an ID lower
		 *                                          than the offset value.
		 *     @type string           $since        Return only those items that have a
		 *                                          date_recorded value greater than a
		 *                                          given MySQL-formatted date.
		 * }
		 * @return string The filter clause, for use in a SQL query.
		 */
		public static function get_filter_sql($filter_array)
		{
		}
		/**
		 * Get the date/time of last recorded activity.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @return string ISO timestamp.
		 */
		public static function get_last_updated()
		{
		}
		/**
		 * Get favorite count for a given user.
		 *
		 * @since 1.2.0
		 *
		 * @param int $user_id The ID of the user whose favorites you're counting.
		 * @return int $value A count of the user's favorites.
		 */
		public static function total_favorite_count($user_id)
		{
		}
		/**
		 * Check whether an activity item exists with a given string content.
		 *
		 * @since 1.1.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param string $content The content to filter by.
		 * @return int|false The ID of the first matching item if found, otherwise false.
		 */
		public static function check_exists_by_content($content)
		{
		}
		/**
		 * Hide all activity for a given user.
		 *
		 * @since 1.2.0
		 *
		 * @global wpdb $wpdb WordPress database object.
		 *
		 * @param int $user_id The ID of the user whose activity you want to mark hidden.
		 * @return mixed
		 */
		public static function hide_all_for_user($user_id)
		{
		}
	}
	/**
	 * The main activity template loop class.
	 *
	 * This is responsible for loading a group of activity items and displaying them.
	 *
	 * @since 1.0.0
	 */
	class BP_Activity_Template
	{
		/**
		 * The loop iterator.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $current_activity = -1;
		/**
		 * The activity count.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $activity_count;
		/**
		 * The total activity count.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $total_activity_count;
		/**
		 * Array of activities located by the query.
		 *
		 * @since 1.0.0
		 * @var array
		 */
		public $activities;
		/**
		 * The activity object currently being iterated on.
		 *
		 * @since 1.0.0
		 * @var object
		 */
		public $activity;
		/**
		 * A flag for whether the loop is currently being iterated.
		 *
		 * @since 1.0.0
		 * @var bool
		 */
		public $in_the_loop;
		/**
		 * URL parameter key for activity pagination. Default: 'acpage'.
		 *
		 * @since 2.1.0
		 * @var string
		 */
		public $pag_arg;
		/**
		 * The page number being requested.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $pag_page;
		/**
		 * The number of items being requested per page.
		 *
		 * @since 1.0.0
		 * @var int
		 */
		public $pag_num;
		/**
		 * An HTML string containing pagination links.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $pag_links;
		/**
		 * The displayed user's full name.
		 *
		 * @since 1.0.0
		 * @var string
		 */
		public $full_name;
		/**
		 * Check if post/comment replies are disabled.
		 *
		 * @since 1.0.0
		 * @var bool
		 */
		public $disable_blogforum_replies;
		/**
		 * If more items are available.
		 *
		 * @since 1.0.0
		 * @var bool
		 */
		public $has_more_items;
		/**
		 * An array of the logged in user's favorite activities.
		 *
		 * @since 1.0.0
		 * @var array
		 */
		public $my_favs;
		/**
		 * An array of parent activities.
		 *
		 * @since 1.0.0
		 * @var array
		 */
		public $activity_parents;
		/**
		 * Constructor method.
		 *
		 * The arguments passed to this class constructor are of the same
		 * format as {@link BP_Activity_Activity::get()}.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Activity_Activity::get() for a description of the argument
		 *      structure, as well as default values.
		 *
		 * @param array $args {
		 *     Array of arguments. Supports all arguments from
		 *     BP_Activity_Activity::get(), as well as 'page_arg' and
		 *     'include'. Default values for 'per_page' and 'display_comments'
		 *     differ from the originating function, and are described below.
		 *     @type string      $page_arg         The string used as a query parameter in
		 *                                         pagination links. Default: 'acpage'.
		 *     @type array|bool  $include          Pass an array of activity IDs to
		 *                                         retrieve only those items, or false to noop the 'include'
		 *                                         parameter. 'include' differs from 'in' in that 'in' forms
		 *                                         an IN clause that works in conjunction with other filters
		 *                                         passed to the function, while 'include' is interpreted as
		 *                                         an exact list of items to retrieve, which skips all other
		 *                                         filter-related parameters. Default: false.
		 *     @type int|bool    $per_page         Default: 20.
		 *     @type string|bool $display_comments Default: 'threaded'.
		 * }
		 */
		public function __construct($args)
		{
		}
		/**
		 * Whether there are activity items available in the loop.
		 *
		 * @since 1.0.0
		 *
		 * @see bp_has_activities()
		 *
		 * @return bool True if there are items in the loop, otherwise false.
		 */
		function has_activities()
		{
		}
		/**
		 * Set up the next activity item and iterate index.
		 *
		 * @since 1.0.0
		 *
		 * @return object The next activity item to iterate over.
		 */
		public function next_activity()
		{
		}
		/**
		 * Rewind the posts and reset post index.
		 *
		 * @since 1.0.0
		 */
		public function rewind_activities()
		{
		}
		/**
		 * Whether there are activity items left in the loop to iterate over.
		 *
		 * This method is used by {@link bp_activities()} as part of the while loop
		 * that controls iteration inside the activities loop, eg:
		 *     while ( bp_activities() ) { ...
		 *
		 * @since 1.0.0
		 *
		 * @see bp_activities()
		 *
		 * @return bool True if there are more activity items to show,
		 *              otherwise false.
		 */
		public function user_activities()
		{
		}
		/**
		 * Set up the current activity item inside the loop.
		 *
		 * Used by {@link bp_the_activity()} to set up the current activity item
		 * data while looping, so that template tags used during that iteration
		 * make reference to the current activity item.
		 *
		 * @since 1.0.0
		 *
		 * @see bp_the_activity()
		 */
		public function the_activity()
		{
		}
	}
	/**
	 * Main Activity Class.
	 *
	 * @since 1.5.0
	 */
	#[\AllowDynamicProperties]
	class BP_Activity_Component extends \BP_Component
	{
		/**
		 * Start the activity component setup process.
		 *
		 * @since 1.5.0
		 */
		public function __construct()
		{
		}
		/**
		 * Include component files.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::includes() for a description of arguments.
		 *
		 * @param array $includes See BP_Component::includes() for a description.
		 */
		public function includes($includes = array())
		{
		}
		/**
		 * Late includes method.
		 *
		 * Only load up certain code when on specific pages.
		 *
		 * @since 3.0.0
		 */
		public function late_includes()
		{
		}
		/**
		 * Set up component global variables.
		 *
		 * The BP_ACTIVITY_SLUG constant is deprecated.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_globals() for a description of arguments.
		 *
		 * @param array $args See BP_Component::setup_globals() for a description.
		 */
		public function setup_globals($args = array())
		{
		}
		/**
		 * Register component navigation.
		 *
		 * @since 12.0.0
		 *
		 * @see `BP_Component::register_nav()` for a description of arguments.
		 *
		 * @param array $main_nav Optional. See `BP_Component::register_nav()` for description.
		 * @param array $sub_nav  Optional. See `BP_Component::register_nav()` for description.
		 */
		public function register_nav($main_nav = array(), $sub_nav = array())
		{
		}
		/**
		 * Set up the component entries in the WordPress Admin Bar.
		 *
		 * @since 1.5.0
		 *
		 * @see BP_Component::setup_nav() for a description of the $wp_admin_nav
		 *      parameter array.
		 *
		 * @param array $wp_admin_nav See BP_Component::setup_admin_bar() for a
		 *                            description.
		 */
		public function setup_admin_bar($wp_admin_nav = array())
		{
		}
		/**
		 * Set up the title for pages and <title>.
		 *
		 * @since 1.5.0
		 *
		 */
		public function setup_title()
		{
		}
		/**
		 * Setup cache groups.
		 *
		 * @since 2.2.0
		 */
		public function setup_cache_groups()
		{
		}
		/**
		 * Parse the WP_Query and eventually display the component's directory or single item.
		 *
		 * @since 12.0.0
		 *
		 * @param WP_Query $query Required. See BP_Component::parse_query() for
		 *                        description.
		 */
		public function parse_query($query)
		{
		}
		/**
		 * Init the BP REST API.
		 *
		 * @since 5.0.0
		 *
		 * @param array $controllers Optional. See BP_Component::rest_api_init() for
		 *                           description.
		 */
		public function rest_api_init($controllers = array())
		{
		}
		/**
		 * Register the BP Activity Blocks.
		 *
		 * @since 7.0.0
		 * @since 12.0.0 Use the WP Blocks API v2.
		 *
		 * @param array $blocks Optional. See BP_Component::blocks_init() for
		 *                      description.
		 */
		public function blocks_init($blocks = array())
		{
		}
	}
	/**
	 * oEmbed handler to respond and render single activity items.
	 *
	 * @since 2.6.0
	 */
	class BP_Activity_oEmbed_Extension extends \BP_Core_oEmbed_Extension
	{
		/**
		 * Custom oEmbed slug endpoint.
		 *
		 * @since 2.6.0
		 *
		 * @var string
		 */
		public $slug_endpoint = 'activity';
		/**
		 * Custom hooks.
		 *
		 * @since 2.6.0
		 */
		protected function custom_hooks()
		{
		}
		/**
		 * Add custom endpoint arguments.
		 *
		 * Currently, includes 'hide_media'.
		 *
		 * @since 2.6.0
		 *
		 * @return array
		 */
		protected function set_route_args()
		{
		}
		/**
		 * Output our custom embed template part.
		 *
		 * @since 2.6.0
		 */
		protected function content()
		{
		}
		/**
		 * Check if we're on our single activity page.
		 *
		 * @since 2.6.0
		 *
		 * @return bool
		 */
		protected function is_page()
		{
		}
		/**
		 * Validates the URL to determine if the activity item is valid.
		 *
		 * @since 2.6.0
		 *
		 * @param  string   $url The URL to check.
		 * @return int|bool Activity ID on success; boolean false on failure.
		 */
		protected function validate_url_to_item_id($url)
		{
		}
		/**
		 * Sets the oEmbed response data for our activity item.
		 *
		 * @since 2.6.0
		 *
		 * @param  int $item_id The activity ID.
		 * @return array
		 */
		protected function set_oembed_response_data($item_id)
		{
		}
		/**
		 * Sets a custom <blockquote> for our oEmbed fallback HTML.
		 *
		 * @since 2.6.0
		 *
		 * @global BP_Activity_Template $activities_template The Activity template loop.
		 *
		 * @param  int $item_id The activity ID.
		 * @return string
		 */
		protected function set_fallback_html($item_id)
		{
		}
		/**
		 * Sets a custom <iframe> title for our oEmbed item.
		 *
		 * @since 2.6.0
		 *
		 * @param  int $item_id The activity ID
		 * @return string
		 */
		protected function set_iframe_title($item_id)
		{
		}
		/**
		 * Use our custom <iframe> sandbox attribute in our oEmbed response.
		 *
		 * WordPress sets the <iframe> sandbox attribute to 'allow-scripts' regardless
		 * of whatever the oEmbed response is in {@link wp_filter_oembed_result()}. We
		 * need to add back our custom sandbox value so links will work.
		 *
		 * @since 2.6.0
		 *
		 * @see BP_Activity_Component::modify_iframe() where our custom sandbox value is set.
		 *
		 * @param string $result The oEmbed HTML result.
		 * @param object $data   A data object result from an oEmbed provider.
		 * @param string $url    The URL of the content to be embedded.
		 * @return string
		 */
		public function use_custom_iframe_sandbox_attribute($result, $data, $url)
		{
		}
		/**
		 * Modify various IFRAME-related items if embeds are allowed.
		 *
		 * HTML modified:
		 *  - Add sandbox="allow-top-navigation" attribute. This allows links to work
		 *    within the iframe sandbox attribute.
		 *
		 * JS modified:
		 *  - Remove IFRAME height restriction of 1000px. Fixes long embed items being
		 *    truncated.
		 *
		 * @since 2.6.0
		 *
		 * @param  string $retval Current embed HTML.
		 * @return string
		 */
		public function modify_iframe($retval)
		{
		}
		/**
		 * Do stuff when our oEmbed activity header template part is loading.
		 *
		 * Currently, removes wpautop() from the bp_activity_action() function.
		 *
		 * @since 2.6.0
		 *
		 * @param string $slug Template part slug requested.
		 * @param string $name Template part name requested.
		 */
		public function on_activity_header($slug, $name)
		{
		}
		/**
		 * Prints the markup for the activity embed comments button.
		 *
		 * Basically a copy of {@link print_embed_comments_button()}, but modified for
		 * the BP activity component.
		 *
		 * @since 2.6.0
		 */
		public function embed_comments_button()
		{
		}
	}
	/**
	 * List table class for the Activity component admin page.
	 *
	 * @since 1.6.0
	 */
	class BP_Activity_List_Table extends \WP_List_Table
	{
		/**
		 * What type of view is being displayed?
		 *
		 * E.g. "all", "pending", "approved", "spam"...
		 *
		 * @since 1.6.0
		 * @var string $view
		 */
		public $view = 'all';
		/**
		 * How many activity items have been marked as spam.
		 *
		 * @since 1.6.0
		 * @var int $spam_count
		 */
		public $spam_count = 0;
		/**
		 * Total number of activities.
		 *
		 * @since 6.0.0
		 * @var int $all_count
		 */
		public $all_count = 0;
		/**
		 * Store activity-to-user-ID mappings for use in the In Response To column.
		 *
		 * @since 1.6.0
		 * @var array $activity_user_id
		 */
		protected $activity_user_id = array();
		/**
		 * If users can comment on post and comment activity items.
		 *
		 * @link https://buddypress.trac.wordpress.org/ticket/6277
		 *
		 * @since 2.2.2
		 * @var bool $disable_blogforum_comments
		 */
		public $disable_blogforum_comments = \false;
		/**
		 * Constructor.
		 *
		 * @since 1.6.0
		 */
		public function __construct()
		{
		}
		/**
		 * Handle filtering of data, sorting, pagination, and any other data manipulation prior to rendering.
		 *
		 * @since 1.6.0
		 */
		function prepare_items()
		{
		}
		/**
		 * Get an array of all the columns on the page.
		 *
		 * @since 1.6.0
		 *
		 * @return array Column headers.
		 */
		function get_column_info()
		{
		}
		/**
		 * Get name of default primary column
		 *
		 * @since 2.3.3
		 *
		 * @return string
		 */
		protected function get_default_primary_column_name()
		{
		}
		/**
		 * Display a message on screen when no items are found (e.g. no search matches).
		 *
		 * @since 1.6.0
		 */
		function no_items()
		{
		}
		/**
		 * Output the Activity data table.
		 *
		 * @since 1.6.0
		 */
		function display()
		{
		}
		/**
		 * Generate content for a single row of the table.
		 *
		 * @since 1.6.0
		 *
		 * @param object $item The current item.
		 */
		function single_row($item)
		{
		}
		/**
		 * Get the list of views available on this table (e.g. "all", "spam").
		 *
		 * @since 1.6.0
		 */
		function get_views()
		{
		}
		/**
		 * Get bulk actions.
		 *
		 * @since 1.6.0
		 *
		 * @return array Key/value pairs for the bulk actions dropdown.
		 */
		public function get_bulk_actions()
		{
		}
		/**
		 * Get the table column titles.
		 *
		 * @since 1.6.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @return array The columns to appear in the Activity list table.
		 */
		function get_columns()
		{
		}
		/**
		 * Get the column names for sortable columns.
		 *
		 * @since 1.6.0
		 *
		 * @return array The columns that can be sorted on the Activity screen.
		 */
		public function get_sortable_columns()
		{
		}
		/**
		 * Markup for the "filter" part of the form (i.e. which activity type to display).
		 *
		 * @since 1.6.0
		 *
		 * @param string $which 'top' or 'bottom'.
		 */
		function extra_tablenav($which)
		{
		}
		/**
		 * Override WP_List_Table::row_actions().
		 *
		 * Basically a duplicate of the row_actions() method, but removes the
		 * unnecessary <button> addition.
		 *
		 * @since 2.3.3
		 * @since 2.3.4 Visibility set to public for compatibility with WP < 4.0.0.
		 *
		 * @param array $actions The list of actions.
		 * @param bool  $always_visible Whether the actions should be always visible.
		 * @return string
		 */
		public function row_actions($actions, $always_visible = \false)
		{
		}
		/**
		 * Checkbox column markup.
		 *
		 * @since 1.6.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @param array $item A singular item (one full row).
		 */
		function column_cb($item)
		{
		}
		/**
		 * Author column markup.
		 *
		 * @since 1.6.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @param array $item A singular item (one full row).
		 */
		function column_author($item)
		{
		}
		/**
		 * Action column markup.
		 *
		 * @since 2.0.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @param array $item A singular item (one full row).
		 */
		function column_action($item)
		{
		}
		/**
		 * Content column, and "quick admin" rollover actions.
		 *
		 * Called "comment" in the CSS so we can re-use some WP core CSS.
		 *
		 * @since 1.6.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @param array $item A singular item (one full row).
		 */
		function column_comment($item)
		{
		}
		/**
		 * "In response to" column markup.
		 *
		 * @since 1.6.0
		 *
		 * @see WP_List_Table::single_row_columns()
		 *
		 * @param array $item A singular item (one full row).
		 */
		function column_response($item)
		{
		}
		/**
		 * Allow plugins to add their custom column.
		 *
		 * @since 2.4.0
		 *
		 * @param array  $item        Information about the current row.
		 * @param string $column_name The column name.
		 * @return string
		 */
		public function column_default($item = array(), $column_name = '')
		{
		}
		/**
		 * Get the user id associated with a given activity item.
		 *
		 * Wraps bp_activity_get_specific(), with some additional logic for
		 * avoiding duplicate queries.
		 *
		 * @since 1.6.0
		 *
		 * @param int $activity_id Activity ID to retrieve User ID for.
		 * @return int User ID of the activity item in question.
		 */
		protected function get_activity_user_id($activity_id)
		{
		}
		/**
		 * Checks if an activity item can be replied to.
		 *
		 * This method merges functionality from {@link bp_activity_can_comment()} and
		 * {@link bp_blogs_disable_activity_commenting()}. This is done because the activity
		 * list table doesn't use a BuddyPress activity loop, which prevents those
		 * functions from working as intended.
		 *
		 * @since 2.0.0
		 * @since 2.5.0 Include Post type activities types
		 *
		 * @param array $item An array version of the BP_Activity_Activity object.
		 * @return bool $can_comment
		 */
		protected function can_comment($item)
		{
		}
		/**
		 * Flatten the activity array.
		 *
		 * In some cases, BuddyPress gives us a structured tree of activity
		 * items plus their comments. This method converts it to a flat array.
		 *
		 * @since 1.6.0
		 *
		 * @param array $tree Source array.
		 * @return array Flattened array.
		 */
		public static function flatten_activity_array($tree)
		{
		}
	}
	/**
	 * The main theme compat class for BuddyPress Activity.
	 *
	 * This class sets up the necessary theme compatibility actions to safely output
	 * activity template parts to the_title and the_content areas of a theme.
	 *
	 * @since 1.7.0
	 */
	class BP_Activity_Theme_Compat
	{
		/**
		 * Set up the activity component theme compatibility.
		 *
		 * @since 1.7.0
		 */
		public function __construct()
		{
		}
		/**
		 * Set up the theme compatibility hooks, if we're looking at an activity page.
		 *
		 * @since 1.7.0
		 */
		public function is_activity()
		{
		}
		/** Directory *************************************************************/
		/**
		 * Add template hierarchy to theme compat for the activity directory page.
		 *
		 * This is to mirror how WordPress has {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param string $templates The templates from bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function directory_template_hierarchy($templates)
		{
		}
		/**
		 * Update the global $post with directory data.
		 *
		 * @since 1.7.0
		 */
		public function directory_dummy_post()
		{
		}
		/**
		 * Filter the_content with the groups index template part.
		 *
		 * @since 1.7.0
		 */
		public function directory_content()
		{
		}
		/** Single ****************************************************************/
		/**
		 * Add custom template hierarchy to theme compat for activity permalink pages.
		 *
		 * This is to mirror how WordPress has {@link https://codex.wordpress.org/Template_Hierarchy template hierarchy}.
		 *
		 * @since 1.8.0
		 *
		 * @param string $templates The templates from bp_get_theme_compat_templates().
		 * @return array $templates Array of custom templates to look for.
		 */
		public function single_template_hierarchy($templates)
		{
		}
		/**
		 * Update the global $post with the displayed user's data.
		 *
		 * @since 1.7.0
		 */
		public function single_dummy_post()
		{
		}
		/**
		 * Filter the_content with the members' activity permalink template part.
		 *
		 * @since 1.7.0
		 */
		public function single_dummy_content()
		{
		}
	}
}
namespace {
	// Required PHP version.
	\define('BP_REQUIRED_PHP_VERSION', '5.6.0');
	/**
	 * The main function responsible for returning the one true BuddyPress Instance to functions everywhere.
	 *
	 * Use this function like you would a global variable, except without needing
	 * to declare the global.
	 *
	 * Example: <?php $bp = buddypress(); ?>
	 *
	 * @return BuddyPress|null The one true BuddyPress Instance.
	 */
	function buddypress()
	{
	}
	/**
	 * Adds an admin notice to installations that don't meet BP's minimum PHP requirement.
	 *
	 * @since 2.8.0
	 */
	function bp_php_requirements_notice()
	{
	}
	/**
	 * Output the blogs component slug.
	 *
	 * @since 1.5.0
	 *
	 */
	function bp_blogs_slug()
	{
	}
	/**
	 * Return the blogs component slug.
	 *
	 * @since 1.5.0
	 *
	 * @return string The 'blogs' slug.
	 */
	function bp_get_blogs_slug()
	{
	}
	/**
	 * Output the blogs component root slug.
	 *
	 * @since 1.5.0
	 *
	 */
	function bp_blogs_root_slug()
	{
	}
	/**
	 * Return the blogs component root slug.
	 *
	 * @since 1.5.0
	 *
	 * @return string The 'blogs' root slug.
	 */
	function bp_get_blogs_root_slug()
	{
	}
	/**
	 * Output Blogs directory's URL.
	 *
	 * @since 12.0.0
	 */
	function bp_blogs_directory_url()
	{
	}
	/**
	 * Returns the Blogs directory's URL.
	 *
	 * @since 12.0.0
	 *
	 * @param array $path_chunks {
	 *     An array of arguments. Optional.
	 *
	 *     @type int $create_single_item `1` to get the Blogs create link.
	 * }
	 * @return string The URL built for the BP Rewrites URL parser.
	 */
	function bp_get_blogs_directory_url($path_chunks = array())
	{
	}
	/**
	 * Rewind the blogs and reset blog index.
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 */
	function bp_rewind_blogs()
	{
	}
	/**
	 * Initialize the blogs loop.
	 *
	 * Based on the $args passed, bp_has_blogs() populates the $blogs_template
	 * global, enabling the use of BuddyPress templates and template functions to
	 * display a list of blogs.
	 *
	 * @since 1.0.0
	 * @since 1.2.0 Added $type, $page, $search_terms parameters
	 * @since 1.6.0 Added $page_arg parameter
	 * @since 2.0.0 Added $include_blog_ids, $update_meta_cache parameters
	 * @since 10.0.0 Added $date_query parameter
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @param array|string $args {
	 *     Arguments for limiting the contents of the blogs loop. Most arguments
	 *     are in the same format as {@link BP_Blogs_Blog::get()}. However, because
	 *     the format of the arguments accepted here differs in a number of ways,
	 *     and because bp_has_blogs() determines some default arguments in a
	 *     dynamic fashion, we list all accepted arguments here as well.
	 *
	 *     @type int      $page             Which page of results to fetch. Using page=1 without
	 *                                      per_page will result in no pagination. Default: 1.
	 *     @type int|bool $per_page         Number of results per page. Default: 20.
	 *     @type string   $page_arg         The string used as a query parameter in
	 *                                      pagination links. Default: 'bpage'.
	 *     @type int|bool $max              Maximum number of results to return.
	 *                                      Default: false (unlimited).
	 *     @type string   $type             The order in which results should be fetched.
	 *                                      'active', 'alphabetical', 'newest', or 'random'.
	 *     @type array    $include_blog_ids Array of blog IDs to limit results to.
	 *     @type string   $search_terms     Limit results by a search term. Default: the value of `$_REQUEST['s']` or
	 *                                      `$_REQUEST['sites_search']`, if present.
	 *     @type int      $user_id          The ID of the user whose blogs should be retrieved.
	 *                                      When viewing a user profile page, 'user_id' defaults to the
	 *                                      ID of the displayed user. Otherwise the default is false.
	 *     @type array    $date_query       Filter results by site last activity date. See first parameter of
	 *                                      {@link WP_Date_Query::__construct()} for syntax. Only applicable if
	 *                                      $type is either 'newest' or 'active'.
	 * }
	 * @return bool Returns true when blogs are found, otherwise false.
	 */
	function bp_has_blogs($args = '')
	{
	}
	/**
	 * Determine if there are still blogs left in the loop.
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @return bool Returns true when blogs are found.
	 */
	function bp_blogs()
	{
	}
	/**
	 * Get the current blog object in the loop.
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @return object The current blog within the loop.
	 */
	function bp_the_blog()
	{
	}
	/**
	 * Output the blogs pagination count.
	 *
	 * @since 1.0.0
	 */
	function bp_blogs_pagination_count()
	{
	}
	/**
	 * Get the blogs pagination count.
	 *
	 * @since 2.7.0
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @return string
	 */
	function bp_get_blogs_pagination_count()
	{
	}
	/**
	 * Output the blogs pagination links.
	 */
	function bp_blogs_pagination_links()
	{
	}
	/**
	 * Return the blogs pagination links.
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @return string HTML pagination links.
	 */
	function bp_get_blogs_pagination_links()
	{
	}
	/**
	 * Output a blog's avatar.
	 *
	 * @see bp_get_blog_avatar() for description of arguments.
	 *
	 * @param array|string $args See {@link bp_get_blog_avatar()}.
	 */
	function bp_blog_avatar($args = '')
	{
	}
	/**
	 * Get a blog's avatar.
	 *
	 * At the moment, unless the blog has a site icon, the blog's avatar defaults
	 * to the /bp-core/images/mystery-blog.png image or the Blog's Admin user avatar
	 * if the `admin_user_id` argument contains the Blog's Admin user ID.
	 *
	 * @since 2.4.0 Introduced `$title` argument.
	 * @since 6.0.0 Introduced the `$blog_id`, `$admin_user_id` and `html` arguments.
	 * @since 7.0.0 Introduced the Blog's default avatar {@see bp_blogs_default_avatar()}.
	 *              Removed the `'bp_get_blog_avatar_' . $blog_id` filter (it was deprecated since 1.5).
	 *
	 * @see bp_core_fetch_avatar() For a description of arguments and
	 *      return values.
	 *
	 * @param array|string $args  {
	 *     Arguments are listed here with an explanation of their defaults.
	 *     For more information about the arguments, see
	 *     {@link bp_core_fetch_avatar()}.
	 *     @type string   $alt           Default: 'Profile picture of site author [user name]'.
	 *     @type string   $class         Default: 'avatar'.
	 *     @type string   $type          Default: 'full'.
	 *     @type int|bool $width         Default: false.
	 *     @type int|bool $height        Default: false.
	 *     @type bool     $id            Currently unused.
	 *     @type bool     $no_grav       Default: false.
	 *     @type int      $blog_id       The blog ID. Default: O.
	 *     @type int      $admin_user_id The Blog Admin user ID. Default: 0.
	 *     @type bool     $html          Default: true.
	 * }
	 * @return string User avatar string.
	 */
	function bp_get_blog_avatar($args = '')
	{
	}
	function bp_blog_permalink()
	{
	}
	function bp_get_blog_permalink()
	{
	}
	/**
	 * Output the name of the current blog in the loop.
	 */
	function bp_blog_name()
	{
	}
	/**
	 * Return the name of the current blog in the loop.
	 *
	 * @return string The name of the current blog in the loop.
	 */
	function bp_get_blog_name()
	{
	}
	/**
	 * Output the ID of the current blog in the loop.
	 *
	 * @since 1.7.0
	 */
	function bp_blog_id()
	{
	}
	/**
	 * Return the ID of the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @return int ID of the current blog in the loop.
	 */
	function bp_get_blog_id()
	{
	}
	/**
	 * Output the description of the current blog in the loop.
	 */
	function bp_blog_description()
	{
	}
	/**
	 * Return the description of the current blog in the loop.
	 *
	 * @return string Description of the current blog in the loop.
	 */
	function bp_get_blog_description()
	{
	}
	/**
	 * Output the row class of the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @param array $classes Array of custom classes.
	 */
	function bp_blog_class($classes = array())
	{
	}
	/**
	 * Return the row class of the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @param array $classes Array of custom classes.
	 * @return string Row class of the site.
	 */
	function bp_get_blog_class($classes = array())
	{
	}
	/**
	 * Output the last active date of the current blog in the loop.
	 *
	 * @param array $args See {@link bp_get_blog_last_active()}.
	 */
	function bp_blog_last_active($args = array())
	{
	}
	/**
	 * Return the last active date of the current blog in the loop.
	 *
	 * @param array $args {
	 *     Array of optional arguments.
	 *     @type bool $active_format If true, formatted "Active 5 minutes ago".
	 *                               If false, formatted "5 minutes ago".
	 *                               Default: true.
	 * }
	 * @return string Last active date.
	 */
	function bp_get_blog_last_active($args = array())
	{
	}
	/**
	 * Output the latest post from the current blog in the loop.
	 *
	 * @param array $args See {@link bp_get_blog_latest_post()}.
	 */
	function bp_blog_latest_post($args = array())
	{
	}
	/**
	 * Return the latest post from the current blog in the loop.
	 *
	 * @param array $args {
	 *     Array of optional arguments.
	 *     @type bool $latest_format If true, formatted "Latest post: [link to post]".
	 *                               If false, formatted "[link to post]".
	 *                               Default: true.
	 * }
	 * @return string $retval String of the form 'Latest Post: [link to post]'.
	 */
	function bp_get_blog_latest_post($args = array())
	{
	}
	/**
	 * Output the title of the latest post on the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @see bp_get_blog_latest_post_title()
	 */
	function bp_blog_latest_post_title()
	{
	}
	/**
	 * Return the title of the latest post on the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @return string Post title.
	 */
	function bp_get_blog_latest_post_title()
	{
	}
	/**
	 * Output the permalink of the latest post on the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @see bp_get_blog_latest_post_title()
	 */
	function bp_blog_latest_post_permalink()
	{
	}
	/**
	 * Return the permalink of the latest post on the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @return string URL of the blog's latest post.
	 */
	function bp_get_blog_latest_post_permalink()
	{
	}
	/**
	 * Output the content of the latest post on the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 */
	function bp_blog_latest_post_content()
	{
	}
	/**
	 * Return the content of the latest post on the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @return string Content of the blog's latest post.
	 */
	function bp_get_blog_latest_post_content()
	{
	}
	/**
	 * Output the featured image of the latest post on the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @see bp_get_blog_latest_post_content() For description of parameters.
	 *
	 * @param string $size See {@link bp_get_blog_latest_post_featured_image()}.
	 */
	function bp_blog_latest_post_featured_image($size = 'thumbnail')
	{
	}
	/**
	 * Return the featured image of the latest post on the current blog in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @global BP_Blogs_Template $blogs_template The main blog template loop class.
	 *
	 * @param string $size Image version to return. 'thumbnail', 'medium',
	 *                     'large', or 'post-thumbnail'. Default: 'thumbnail'.
	 * @return string URL of the image.
	 */
	function bp_get_blog_latest_post_featured_image($size = 'thumbnail')
	{
	}
	/**
	 * Does the latest blog post have a featured image?
	 *
	 * @since 1.7.0
	 *
	 * @param string $thumbnail Image version to return. 'thumbnail', 'medium', 'large',
	 *                          or 'post-thumbnail'. Default: 'thumbnail'.
	 * @return bool True if the latest blog post from the current blog has a
	 *              featured image of the given size.
	 */
	function bp_blog_latest_post_has_featured_image($thumbnail = 'thumbnail')
	{
	}
	/**
	 * Output hidden fields to help with form submissions in Sites directory.
	 *
	 * This function detects whether 's', 'letter', or 'blogs_search' requests are
	 * currently being made (as in a URL parameter), and creates corresponding
	 * hidden fields.
	 */
	function bp_blog_hidden_fields()
	{
	}
	/**
	 * Output the total number of blogs on the site.
	 */
	function bp_total_blog_count()
	{
	}
	/**
	 * Return the total number of blogs on the site.
	 *
	 * @return int Total number of blogs.
	 */
	function bp_get_total_blog_count()
	{
	}
	/**
	 * Output the total number of blogs for a given user.
	 *
	 * @param int $user_id ID of the user.
	 */
	function bp_total_blog_count_for_user($user_id = 0)
	{
	}
	/**
	 * Return the total number of blogs for a given user.
	 *
	 * @param int $user_id ID of the user.
	 * @return int Total number of blogs for the user.
	 */
	function bp_get_total_blog_count_for_user($user_id = 0)
	{
	}
	/** Blog Registration ********************************************************/
	/**
	 * Output the wrapper markup for the blog signup form.
	 *
	 * @since 1.0.0
	 *
	 * @param string          $blogname   Optional. The default blog name (path or domain).
	 * @param string          $blog_title Optional. The default blog title.
	 * @param string|WP_Error $errors     Optional. The WP_Error object returned by a previous
	 *                                    submission attempt.
	 */
	function bp_show_blog_signup_form($blogname = '', $blog_title = '', $errors = '')
	{
	}
	/**
	 * Output the input fields for the blog creation form.
	 *
	 * @since 1.0.0
	 *
	 * @param string          $blogname   Optional. The default blog name (path or domain).
	 * @param string          $blog_title Optional. The default blog title.
	 * @param string|WP_Error $errors     Optional. The WP_Error object returned by a previous
	 *                                    submission attempt.
	 */
	function bp_blogs_signup_blog($blogname = '', $blog_title = '', $errors = '')
	{
	}
	/**
	 * Process a blog registration submission.
	 *
	 * Passes submitted values to {@link wpmu_create_blog()}.
	 *
	 * @since 1.0.0
	 *
	 * @return bool|int|WP_Error False if not a form submission, the Blog ID on success, a WP_Error object on failure.
	 */
	function bp_blogs_validate_blog_signup()
	{
	}
	/**
	 * Display a message after successful blog registration.
	 *
	 * @since 1.0.0
	 * @since 2.6.0 Introduced `$blog_id` parameter.
	 *
	 * @param string       $domain     The new blog's domain.
	 * @param string       $path       The new blog's path.
	 * @param string       $blog_title The new blog's title.
	 * @param string       $user_name  The user name of the user who created the blog. Unused.
	 * @param string       $user_email The email of the user who created the blog. Unused.
	 * @param string|array $meta       Meta values associated with the new blog. Unused.
	 * @param int|null     $blog_id    ID of the newly created blog.
	 */
	function bp_blogs_confirm_blog_signup($domain, $path, $blog_title, $user_name, $user_email = '', $meta = '', $blog_id = \null)
	{
	}
	/**
	 * Output a "Create a Site" link for users viewing their own profiles.
	 *
	 * This function is not used by BuddyPress as of 1.2, but is kept here for older
	 * themes that may still be using it.
	 */
	function bp_create_blog_link()
	{
	}
	/**
	 * Output the blog directory search form.
	 *
	 * @since 1.9.0
	 */
	function bp_directory_blogs_search_form()
	{
	}
	/**
	 * Output the Create a Site button.
	 *
	 * @since 2.0.0
	 */
	function bp_blog_create_button()
	{
	}
	/**
	 * Get the Create a Site button.
	 *
	 * @since 2.0.0
	 *
	 * @return false|string
	 */
	function bp_get_blog_create_button()
	{
	}
	/**
	 * Output the Create a Site nav item.
	 *
	 * @since 2.2.0
	 */
	function bp_blog_create_nav_item()
	{
	}
	/**
	 * Get the Create a Site nav item.
	 *
	 * @since 2.2.0
	 *
	 * @return string
	 */
	function bp_get_blog_create_nav_item()
	{
	}
	/**
	 * Checks if a specific theme is still filtering the Blogs directory title
	 * if so, transform the title button into a Blogs directory nav item.
	 *
	 * @since 2.2.0
	 */
	function bp_blog_backcompat_create_nav_item()
	{
	}
	/**
	 * Output button for visiting a blog in a loop.
	 *
	 * @see bp_get_blogs_visit_blog_button_args() for description of arguments.
	 *
	 * @param array|string $args See {@link bp_get_blogs_visit_blog_button_args()}.
	 */
	function bp_blogs_visit_blog_button($args = '')
	{
	}
	/**
	 * Return the arguments of the button for visiting a blog in a loop.
	 *
	 * @see BP_Button for a complete description of arguments and return
	 *      value.
	 *
	 * @since 11.0.0
	 *
	 * @param array|string $args {
	 *     Arguments are listed below, with their default values. For a
	 *     complete description of arguments, see {@link BP_Button}.
	 *     @type string $id                Default: 'visit_blog'.
	 *     @type string $component         Default: 'blogs'.
	 *     @type bool   $must_be_logged_in Default: false.
	 *     @type bool   $block_self        Default: false.
	 *     @type string $wrapper_class     Default: 'blog-button visit'.
	 *     @type string $link_href         Permalink of the current blog in the loop.
	 *     @type string $link_class        Default: 'blog-button visit'.
	 *     @type string $link_text         Default: 'Visit Site'.
	 *     @type string $link_title        Default: 'Visit Site'.
	 * }
	 * @return array Thhe arguments of the button for visiting a blog in a loop.
	 */
	function bp_get_blogs_visit_blog_button_args($args = '')
	{
	}
	/**
	 * Return button for visiting a blog in a loop.
	 *
	 * @see BP_Button for a complete description of arguments and return
	 *      value.
	 *
	 * @see bp_get_blogs_visit_blog_button_args() for description of arguments.
	 *
	 * @param array|string $args See {@link bp_get_blogs_visit_blog_button_args()}.
	 * @return string The HTML for the Visit button.
	 */
	function bp_get_blogs_visit_blog_button($args = '')
	{
	}
	/** Stats **********************************************************************/
	/**
	 * Display the number of blogs in user's profile.
	 *
	 * @since 2.0.0
	 *
	 * @param array|string $args Before|after|user_id.
	 */
	function bp_blogs_profile_stats($args = '')
	{
	}
	/**
	 * Return the number of blogs in user's profile.
	 *
	 * @since 2.0.0
	 *
	 * @param array|string $args Before|after|user_id.
	 * @return string HTML for stats output.
	 */
	function bp_blogs_get_profile_stats($args = '')
	{
	}
	/**
	 * Check whether the $bp global lists an activity directory page.
	 *
	 * @since 1.5.0
	 *
	 * @return bool True if set, false if empty.
	 */
	function bp_blogs_has_directory()
	{
	}
	/**
	 * Retrieve a set of blogs.
	 *
	 * @since 1.2.0
	 * @since 2.0.0 Added $include_blog_ids, $update_meta_cache parameters
	 * @since 10.0.0 Added $date_query parameter
	 *
	 * @see BP_Blogs_Blog::get() for a description of arguments and return value.
	 *
	 * @param array|string $args {
	 *     Arguments are listed here with their default values. For more
	 *     information about the arguments, see {@link BP_Blogs_Blog::get()}.
	 *     @type string      $type              Default: 'active'.
	 *     @type int|bool    $user_id           Default: false.
	 *     @type array       $include_blog_ids  Default: false.
	 *     @type string|bool $search_terms      Default: false.
	 *     @type int         $per_page          Default: 20.
	 *     @type int         $page              Default: 1.
	 *     @type array       $date_query        Default: false.
	 *     @type bool        $update_meta_cache Whether to pre-fetch blogmeta. Default: true.
	 * }
	 * @return array See {@link BP_Blogs_Blog::get()}.
	 */
	function bp_blogs_get_blogs($args = '')
	{
	}
	/**
	 * Populate the BP blogs table with existing blogs.
	 *
	 * Warning: By default, this will remove all existing records from the BP
	 * blogs and blogmeta tables before re-populating the tables.
	 *
	 * @since 1.0.0
	 * @since 2.6.0 Accepts $args as a parameter.
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param array $args {
	 *     Array of arguments.
	 *     @type int    $offset   The offset to use.
	 *     @type int    $limit    The number of blogs to record at one time.
	 *     @type array  $blog_ids Blog IDs to record. If empty, all blogs will be recorded.
	 *     @type array  $site_id  The network site ID to use.
	 * }
	 * @return bool
	 */
	function bp_blogs_record_existing_blogs($args = array())
	{
	}
	/**
	 * Check whether a given blog should be recorded in activity streams.
	 *
	 * If $user_id is provided, you can restrict site from being recordable
	 * only to particular users.
	 *
	 * @since 1.7.0
	 *
	 * @param int $blog_id ID of the blog being checked.
	 * @param int $user_id Optional. ID of the user for whom access is being checked.
	 * @return bool True if blog is recordable, otherwise false.
	 */
	function bp_blogs_is_blog_recordable($blog_id, $user_id = 0)
	{
	}
	/**
	 * Check whether a given blog should be tracked by the Blogs component.
	 *
	 * If $user_id is provided, the developer can restrict site from
	 * being trackable only to particular users.
	 *
	 * @since 1.7.0
	 *
	 * @param int $blog_id ID of the blog being checked.
	 * @param int $user_id Optional. ID of the user for whom access is being checked.
	 * @return bool True if blog is trackable, otherwise false.
	 */
	function bp_blogs_is_blog_trackable($blog_id, $user_id = 0)
	{
	}
	/**
	 * Make BuddyPress aware of a new site so that it can track its activity.
	 *
	 * @since 1.0.0
	 *
	 * @param int  $blog_id     ID of the blog being recorded.
	 * @param int  $user_id     ID of the user for whom the blog is being recorded.
	 * @param bool $no_activity Optional. Whether to skip recording an activity
	 *                          item about this blog creation. Default: false.
	 */
	function bp_blogs_record_blog($blog_id, $user_id, $no_activity = \false)
	{
	}
	/**
	 * Update blog name in BuddyPress blogmeta table.
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param string $oldvalue Value before save. Passed by do_action() but
	 *                         unused here.
	 * @param string $newvalue Value to change meta to.
	 */
	function bp_blogs_update_option_blogname($oldvalue, $newvalue)
	{
	}
	/**
	 * Update blog description in BuddyPress blogmeta table.
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param string $oldvalue Value before save. Passed by do_action() but
	 *                         unused here.
	 * @param string $newvalue Value to change meta to.
	 */
	function bp_blogs_update_option_blogdescription($oldvalue, $newvalue)
	{
	}
	/**
	 * Update "Close comments for old posts" option in BuddyPress blogmeta table.
	 *
	 * @since 2.0.0
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param string $oldvalue Value before save. Passed by do_action() but
	 *                         unused here.
	 * @param string $newvalue Value to change meta to.
	 */
	function bp_blogs_update_option_close_comments_for_old_posts($oldvalue, $newvalue)
	{
	}
	/**
	 * Update "Close comments after days old" option in BuddyPress blogmeta table.
	 *
	 * @since 2.0.0
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param string $oldvalue Value before save. Passed by do_action() but
	 *                         unused here.
	 * @param string $newvalue Value to change meta to.
	 */
	function bp_blogs_update_option_close_comments_days_old($oldvalue, $newvalue)
	{
	}
	/**
	 * When toggling threaded comments, update thread depth in blogmeta table.
	 *
	 * @since 2.0.0
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param string $oldvalue Value before save. Passed by do_action() but
	 *                         unused here.
	 * @param string $newvalue Value to change meta to.
	 */
	function bp_blogs_update_option_thread_comments($oldvalue, $newvalue)
	{
	}
	/**
	 * When updating comment depth, update thread depth in blogmeta table.
	 *
	 * @since 2.0.0
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param string $oldvalue Value before save. Passed by do_action() but
	 *                         unused here.
	 * @param string $newvalue Value to change meta to.
	 */
	function bp_blogs_update_option_thread_comments_depth($oldvalue, $newvalue)
	{
	}
	/**
	 * When updating comment moderation, mirror value in blogmeta table.
	 *
	 * @since 3.0.0
	 *
	 * @param string $oldvalue Value before save. Passed by do_action() but unused here.
	 * @param string $newvalue Value to change meta to.
	 */
	function bp_blogs_update_option_comment_moderation($oldvalue, $newvalue)
	{
	}
	/**
	 * Syncs site icon URLs to blogmeta.
	 *
	 * @since 2.7.0
	 *
	 * @param int|string $old_value Old value
	 * @param int|string $new_value New value
	 */
	function bp_blogs_update_option_site_icon($old_value, $new_value)
	{
	}
	/**
	 * Deletes the 'url' blogmeta for a site.
	 *
	 * Fires when a site's details are updated, which generally happens when
	 * editing a site under "Network Admin > Sites".
	 *
	 * @since 2.3.0
	 *
	 * @param int $site_id The site ID.
	 */
	function bp_blogs_delete_url_blogmeta($site_id = 0)
	{
	}
	/**
	 * Record activity metadata about a published blog post.
	 *
	 * @since 2.2.0
	 *
	 * @param int     $activity_id ID of the activity item.
	 * @param WP_Post $post        Post object.
	 * @param array   $args        Array of arguments.
	 */
	function bp_blogs_publish_post_activity_meta($activity_id, $post, $args)
	{
	}
	/**
	 * Updates a blog post's activity meta entry during a post edit.
	 *
	 * @since 2.2.0
	 * @since 2.5.0 Add the post type tracking args object parameter
	 *
	 * @param WP_Post              $post                 Post object.
	 * @param BP_Activity_Activity $activity             Activity object.
	 * @param object               $activity_post_object The post type tracking args object.
	 */
	function bp_blogs_update_post_activity_meta($post, $activity, $activity_post_object)
	{
	}
	/**
	 * Update Activity and blogs meta and eventually sync comment with activity comment
	 *
	 * @since  2.5.0
	 *
	 * @param  int|bool        $activity_id          ID of recorded activity, or false if sync is active.
	 * @param  WP_Comment|null $comment              The comment object.
	 * @param  array           $activity_args        Array of activity arguments.
	 * @param  object|null     $activity_post_object The post type tracking args object.
	 */
	function bp_blogs_comment_sync_activity_comment(&$activity_id, $comment = \null, $activity_args = array(), $activity_post_object = \null)
	{
	}
	/**
	 * Record a user's association with a blog.
	 *
	 * This function is hooked to several WordPress actions where blog roles are
	 * set/changed ('add_user_to_blog', 'profile_update', 'user_register'). It
	 * parses the changes, and records them as necessary in the BP blog tracker.
	 *
	 * BuddyPress does not track blogs for users with the 'subscriber' role by
	 * default, though as of 2.1.0 you can filter 'bp_blogs_get_allowed_roles' to
	 * modify this behavior.
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param int         $user_id The ID of the user.
	 * @param string|bool $role    User's WordPress role for this blog ID.
	 * @param int         $blog_id Blog ID user is being added to.
	 */
	function bp_blogs_add_user_to_blog($user_id, $role = \false, $blog_id = 0)
	{
	}
	/**
	 * The allowed blog roles a member must have to be recorded into the
	 * `bp_user_blogs` pointer table.
	 *
	 * This added and was made filterable in BuddyPress 2.1.0 to make it easier
	 * to extend the functionality of the Blogs component.
	 *
	 * @since 2.1.0
	 *
	 * @return array
	 */
	function bp_blogs_get_allowed_roles()
	{
	}
	/**
	 * Remove a blog-user pair from BP's blog tracker.
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param int $user_id ID of the user whose blog is being removed.
	 * @param int $blog_id Optional. ID of the blog being removed. Default: current blog ID.
	 */
	function bp_blogs_remove_user_from_blog($user_id, $blog_id = 0)
	{
	}
	/**
	 * Rehook WP's maybe_add_existing_user_to_blog with a later priority.
	 *
	 * WordPress catches add-user-to-blog requests at init:10. In some cases, this
	 * can precede BP's Blogs component. This function bumps the priority of the
	 * core function, so that we can be sure that the Blogs component is loaded
	 * first. See https://buddypress.trac.wordpress.org/ticket/3916.
	 *
	 * @since 1.6.0
	 */
	function bp_blogs_maybe_add_user_to_blog()
	{
	}
	/**
	 * Remove the "blog created" item from the BP blogs tracker and activity stream.
	 *
	 * @param int $blog_id ID of the blog being removed.
	 */
	function bp_blogs_remove_blog($blog_id)
	{
	}
	/**
	 * Remove a blog from the tracker for a specific user.
	 *
	 * @param int $user_id ID of the user for whom the blog is being removed.
	 * @param int $blog_id ID of the blog being removed.
	 */
	function bp_blogs_remove_blog_for_user($user_id, $blog_id)
	{
	}
	/**
	 * Remove a synced activity comment from the activity stream.
	 *
	 * @since 2.5.0
	 *
	 * @param bool   $deleted              True when a comment post type activity was successfully removed.
	 * @param int    $comment_id           ID of the comment to be removed.
	 * @param object $activity_post_object The post type tracking args object.
	 * @param string $activity_type        The post type comment activity type.
	 */
	function bp_blogs_post_type_remove_comment($deleted, $comment_id, $activity_post_object, $activity_type = '')
	{
	}
	/**
	 * Removes blog comments that are associated with activity comments.
	 *
	 * @since 2.0.0
	 *
	 * @see bp_blogs_remove_synced_comment()
	 * @see bp_blogs_sync_delete_from_activity_comment()
	 *
	 * @param array $activity_ids The activity IDs to check association with blog
	 *                            comments.
	 * @param bool  $force_delete  Whether to force delete the comments. If false,
	 *                            comments are trashed instead.
	 */
	function bp_blogs_remove_associated_blog_comments($activity_ids = array(), $force_delete = \true)
	{
	}
	/**
	 * Get the total number of blogs being tracked by BuddyPress.
	 *
	 * @return int $count Total blog count.
	 */
	function bp_blogs_total_blogs()
	{
	}
	/**
	 * Get the total number of blogs being tracked by BP for a specific user.
	 *
	 * @since 1.2.0
	 *
	 * @param int $user_id ID of the user being queried. Default: on a user page,
	 *                     the displayed user. Otherwise, the logged-in user.
	 * @return int $count Total blog count for the user.
	 */
	function bp_blogs_total_blogs_for_user($user_id = 0)
	{
	}
	/**
	 * Remove the all data related to a given blog from the BP blogs tracker and activity stream.
	 *
	 * @param int $blog_id The ID of the blog to expunge.
	 */
	function bp_blogs_remove_data_for_blog($blog_id)
	{
	}
	/**
	 * Get all of a user's blogs, as tracked by BuddyPress.
	 *
	 * @see BP_Blogs_Blog::get_blogs_for_user() for a description of parameters
	 *      and return values.
	 *
	 * @param int  $user_id     See {@BP_Blogs_Blog::get_blogs_for_user()}.
	 * @param bool $show_hidden See {@BP_Blogs_Blog::get_blogs_for_user()}.
	 * @return array See {@BP_Blogs_Blog::get_blogs_for_user()}.
	 */
	function bp_blogs_get_blogs_for_user($user_id, $show_hidden = \false)
	{
	}
	/**
	 * Retrieve a list of all blogs.
	 *
	 * @see BP_Blogs_Blog::get_all() for a description of parameters and return values.
	 *
	 * @param int|null $limit See {@BP_Blogs_Blog::get_all()}.
	 * @param int|null $page  See {@BP_Blogs_Blog::get_all()}.
	 * @return array See {@BP_Blogs_Blog::get_all()}.
	 */
	function bp_blogs_get_all_blogs($limit = \null, $page = \null)
	{
	}
	/**
	 * Retrieve a random list of blogs.
	 *
	 * @see BP_Blogs_Blog::get() for a description of parameters and return values.
	 *
	 * @param int|null $per_page See {@BP_Blogs_Blog::get()}.
	 * @param int|null $page  See {@BP_Blogs_Blog::get()}.
	 * @return array See {@BP_Blogs_Blog::get()}.
	 */
	function bp_blogs_get_random_blogs($per_page = \null, $page = \null)
	{
	}
	/**
	 * Check whether a given blog is hidden.
	 *
	 * @see BP_Blogs_Blog::is_hidden() for a description of parameters and return values.
	 *
	 * @param int $blog_id See {@BP_Blogs_Blog::is_hidden()}.
	 * @return bool See {@BP_Blogs_Blog::is_hidden()}.
	 */
	function bp_blogs_is_blog_hidden($blog_id)
	{
	}
	/*
	 * Blog meta functions
	 *
	 * These functions are used to store specific blogmeta in one global table,
	 * rather than in each blog's options table. Significantly speeds up global blog
	 * queries. By default each blog's name, description and last updated time are
	 * stored and synced here.
	 */
	/**
	 * Delete a metadata from the DB for a blog.
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param int         $blog_id    ID of the blog whose metadata is being deleted.
	 * @param string|bool $meta_key   Optional. The key of the metadata being deleted. If
	 *                                omitted, all BP metadata associated with the blog will
	 *                                be deleted.
	 * @param string|bool $meta_value Optional. If present, the metadata will only be
	 *                                deleted if the meta_value matches this parameter.
	 * @param bool        $delete_all Optional. If true, delete matching metadata entries for
	 *                                all objects, ignoring the specified blog_id. Otherwise, only
	 *                                delete matching metadata entries for the specified blog.
	 *                                Default: false.
	 * @return bool
	 */
	function bp_blogs_delete_blogmeta($blog_id, $meta_key = \false, $meta_value = \false, $delete_all = \false)
	{
	}
	/**
	 * Get metadata for a given blog.
	 *
	 * @since 1.2.0
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param int    $blog_id  ID of the blog whose metadata is being requested.
	 * @param string $meta_key Optional. If present, only the metadata matching
	 *                         that meta key will be returned. Otherwise, all
	 *                         metadata for the blog will be fetched.
	 * @param bool   $single   Optional. If true, return only the first value of the
	 *                         specified meta_key. This parameter has no effect if
	 *                         meta_key is not specified. Default: true.
	 * @return mixed The meta value(s) being requested.
	 */
	function bp_blogs_get_blogmeta($blog_id, $meta_key = '', $single = \true)
	{
	}
	/**
	 * Update a piece of blog meta.
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param int    $blog_id    ID of the blog whose metadata is being updated.
	 * @param string $meta_key   Key of the metadata being updated.
	 * @param mixed  $meta_value Value to be set.
	 * @param mixed  $prev_value Optional. If specified, only update existing
	 *                           metadata entries with the specified value.
	 *                           Otherwise, update all entries.
	 * @return bool|int Returns false on failure. On successful update of existing
	 *                  metadata, returns true. On successful creation of new metadata,
	 *                  returns the integer ID of the new metadata row.
	 */
	function bp_blogs_update_blogmeta($blog_id, $meta_key, $meta_value, $prev_value = '')
	{
	}
	/**
	 * Add a piece of blog metadata.
	 *
	 * @since 2.0.0
	 *
	 * @param int    $blog_id    ID of the blog.
	 * @param string $meta_key   Metadata key.
	 * @param mixed  $meta_value Metadata value.
	 * @param bool   $unique     Optional. Whether to enforce a single metadata value
	 *                           for the given key. If true, and the object already has a value for
	 *                           the key, no change will be made. Default: false.
	 * @return int|bool The meta ID on successful update, false on failure.
	 */
	function bp_blogs_add_blogmeta($blog_id, $meta_key, $meta_value, $unique = \false)
	{
	}
	/**
	 * Remove all blog associations for a given user.
	 *
	 * @param int $user_id ID whose blog data should be removed.
	 */
	function bp_blogs_remove_data($user_id)
	{
	}
	/**
	 * Deletes user XProfile data on the 'delete_user' hook.
	 *
	 * @since 6.0.0
	 *
	 * @param int $user_id The ID of the deleted user.
	 */
	function bp_blogs_remove_data_on_delete_user($user_id)
	{
	}
	/**
	 * Restore all blog associations for a given user.
	 *
	 * @since 2.2.0
	 *
	 * @param int $user_id ID whose blog data should be restored.
	 */
	function bp_blogs_restore_data($user_id = 0)
	{
	}
	/**
	 * Checks whether blog creation is enabled.
	 *
	 * Returns true when blog creation is enabled for logged-in users only, or
	 * when it's enabled for new registrations.
	 *
	 * @since 1.0.0
	 * @since 7.0.0 The function has been moved into `bp-blogs/bp-blogs-functions.php`.
	 *
	 * @return bool True if blog registration is enabled.
	 */
	function bp_blog_signup_enabled()
	{
	}
	/**
	 * Returns the Blog signup's submitted vars.
	 *
	 * @since 7.0.0
	 *
	 * @return array An associative array containing the Blog signup's submitted vars.
	 */
	function bp_blogs_get_signup_form_submitted_vars()
	{
	}
	/**
	 * Validate a blog creation submission.
	 *
	 * Essentially, a wrapper for {@link wpmu_validate_blog_signup()}.
	 *
	 * @since 1.0.0
	 * @since 7.0.0 Add the blog_name and blog_title parameters.
	 *              The function has been moved into `bp-blogs/bp-blogs-functions.php`.
	 *
	 * @return array Contains the new site data and error messages.
	 */
	function bp_blogs_validate_blog_form($blog_name = '', $blog_title = '')
	{
	}
	/**
	 * Gets the site icon URL even when BuddyPress is not network activated.
	 *
	 * @since 7.0.0
	 *
	 * @param integer $blog_id The ID of the blog to get the site icon URL for.
	 * @param integer $size    The size of the site icon.
	 * @return string          The site icon URL
	 */
	function bp_blogs_get_site_icon_url($blog_id = 0, $size = 512)
	{
	}
	/**
	 * Slurp up blogmeta for a specified set of blogs.
	 *
	 * It grabs all blogmeta associated with all of the blogs passed
	 * in $blog_ids and adds it to the WP cache. This improves efficiency when
	 * using querying blogmeta inline.
	 *
	 * @param int|string|array|bool $blog_ids Accepts a single blog ID, or a comma-
	 *                                        separated list or array of blog IDs.
	 */
	function bp_blogs_update_meta_cache($blog_ids = \false)
	{
	}
	/**
	 * Clear the blog object cache.
	 *
	 * @since 1.0.0
	 *
	 * @param int $blog_id ID of the current blog.
	 * @param int $user_id ID of the user whose blog cache should be cleared.
	 */
	function bp_blogs_clear_blog_object_cache($blog_id = 0, $user_id = 0)
	{
	}
	/**
	 * Callback function to render the Recent Posts Block.
	 *
	 * @since 9.0.0
	 *
	 * @global BP_Activity_Template $activities_template The Activity template loop.
	 *
	 * @param array $attributes The block attributes.
	 * @return string           HTML output.
	 */
	function bp_blogs_render_recent_posts_block($attributes = array())
	{
	}
	/**
	 * Set up the bp-blogs component.
	 *
	 * @since 1.5.0
	 */
	function bp_setup_blogs()
	{
	}
	/**
	 * Register activity actions for the blogs component.
	 *
	 * @since 1.0.0
	 */
	function bp_blogs_register_activity_actions()
	{
	}
	/**
	 * Set up the tracking arguments for the 'post' post type.
	 *
	 * @since 2.5.0 This was moved out of the BP_Blogs_Component class.
	 *
	 * @see bp_activity_get_post_type_tracking_args() for information on parameters.
	 *
	 * @param object|null $params    Tracking arguments.
	 * @param string|int  $post_type Post type to track.
	 * @return object|null
	 */
	function bp_blogs_register_post_tracking_args($params = \null, $post_type = 0)
	{
	}
	/**
	 * Returns the blog URL and name which relates to a post or comment activity.
	 *
	 * @since 11.0.0
	 *
	 * @param BP_Activity_Activity $activity The activity object.
	 * @return array The blog URL and name which relates to a post or comment activity.
	 */
	function bp_blogs_activity_get_site_link_meta($activity = \null)
	{
	}
	/**
	 * Format 'new_blog' activity actions.
	 *
	 * @since 2.0.0
	 *
	 * @param string $action   Static activity action.
	 * @param object $activity Activity data object.
	 * @return string Constructed activity action.
	 */
	function bp_blogs_format_activity_action_new_blog($action, $activity)
	{
	}
	/**
	 * Format 'new_blog_post' activity actions.
	 *
	 * @since 2.0.0
	 *
	 * @param string $action   Static activity action.
	 * @param object $activity Activity data object.
	 * @return string Constructed activity action.
	 */
	function bp_blogs_format_activity_action_new_blog_post($action, $activity)
	{
	}
	/**
	 * Format 'new_blog_comment' activity actions.
	 *
	 * @since 2.0.0
	 *
	 * @param string $action   Static activity action.
	 * @param object $activity Activity data object.
	 * @return string Constructed activity action.
	 */
	function bp_blogs_format_activity_action_new_blog_comment($action, $activity)
	{
	}
	/**
	 * Fetch data related to blogs at the beginning of an activity loop.
	 *
	 * This reduces database overhead during the activity loop.
	 *
	 * @since 2.0.0
	 *
	 * @param array $activities Array of activity items.
	 * @return array
	 */
	function bp_blogs_prefetch_activity_object_data($activities)
	{
	}
	/**
	 * Record blog-related activity to the activity stream.
	 *
	 * @since 1.0.0
	 *
	 * @see bp_activity_add() for description of parameters.
	 *
	 * @param array|string $args {
	 *     See {@link bp_activity_add()} for complete description of arguments.
	 *     The arguments listed here have different default values from
	 *     bp_activity_add().
	 *     @type string $component Default: 'blogs'.
	 * }
	 * @return WP_Error|bool|int On success, returns the activity ID. False on failure.
	 */
	function bp_blogs_record_activity($args = '')
	{
	}
	/**
	 * Delete a blog-related activity stream item.
	 *
	 * @since 1.0.0
	 *
	 * @see bp_activity_delete() for description of parameters.
	 *
	 * @param array|string $args {
	 *     See {@link bp_activity_delete()} for complete description of arguments.
	 *     The arguments listed here have different default values from
	 *     bp_activity_add().
	 *     @type string $component Default: 'blogs'.
	 * }
	 * @return bool
	 */
	function bp_blogs_delete_activity($args = '')
	{
	}
	/**
	 * Check if a blog post's activity item should be closed from commenting.
	 *
	 * This mirrors the {@link comments_open()} and {@link _close_comments_for_old_post()}
	 * functions, but for use with the BuddyPress activity stream to be as
	 * lightweight as possible.
	 *
	 * By lightweight, we actually mirror a few of the blog's commenting settings
	 * to blogmeta and checks the values in blogmeta instead.  This is to prevent
	 * multiple {@link switch_to_blog()} calls in the activity stream.
	 *
	 * @since 2.0.0
	 *
	 * @param object $activity The BP_Activity_Activity object.
	 * @return bool
	 */
	function bp_blogs_comments_open($activity)
	{
	}
	/** SITE TRACKING *******************************************************/
	/**
	 * Add an activity entry for a newly-created site.
	 *
	 * Hooked to the 'bp_blogs_new_blog' action.
	 *
	 * @since 2.6.0
	 *
	 * @param BP_Blogs_Blog $recorded_blog Current site being recorded. Passed by reference.
	 * @param bool          $is_private    Whether the current site being recorded is private.
	 * @param bool          $is_recorded   Whether the current site was recorded.
	 */
	function bp_blogs_record_activity_on_site_creation($recorded_blog, $is_private, $is_recorded, $no_activity)
	{
	}
	/**
	 * Deletes the 'new_blog' activity entry when a site is deleted.
	 *
	 * @since 2.6.0
	 *
	 * @param int $blog_id Site ID.
	 */
	function bp_blogs_delete_new_blog_activity_for_site($blog_id, $user_id = 0)
	{
	}
	/**
	 * Delete all 'blogs' activity items for a site when the site is deleted.
	 *
	 * @since 2.6.0
	 *
	 * @param int $blog_id Site ID.
	 */
	function bp_blogs_delete_activity_for_site($blog_id)
	{
	}
	/**
	 * Remove a blog post activity item from the activity stream.
	 *
	 * @since 1.0.0
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param int $post_id ID of the post to be removed.
	 * @param int $blog_id Optional. Defaults to current blog ID.
	 * @param int $user_id Optional. Defaults to the logged-in user ID. This param
	 *                     is currently unused in the function (but is passed to hooks).
	 */
	function bp_blogs_remove_post($post_id, $blog_id = 0, $user_id = 0)
	{
	}
	/** POST COMMENT SYNCHRONIZATION ****************************************/
	/**
	 * Syncs activity comments and posts them back as blog comments.
	 *
	 * Note: This is only a one-way sync - activity comments -> blog comment.
	 *
	 * For blog post -> activity comment, see {@link bp_activity_post_type_comment()}.
	 *
	 * @since 2.0.0
	 * @since 2.5.0 Allow custom post types to sync their comments with activity ones
	 *
	 * @param int    $comment_id      The activity ID for the posted activity comment.
	 * @param array  $params          Parameters for the activity comment.
	 * @param object $parent_activity Parameters of the parent activity item (in this case, the blog post).
	 */
	function bp_blogs_sync_add_from_activity_comment($comment_id, $params, $parent_activity)
	{
	}
	/**
	 * Deletes the blog comment when the associated activity comment is deleted.
	 *
	 * Note: This is hooked on the 'bp_activity_delete_comment_pre' filter instead
	 * of the 'bp_activity_delete_comment' action because we need to fetch the
	 * activity comment children before they are deleted.
	 *
	 * @since 2.0.0
	 * @since 2.5.0 Add the $delected parameter
	 *
	 * @param bool $retval             Whether BuddyPress should continue or not.
	 * @param int  $parent_activity_id The parent activity ID for the activity comment.
	 * @param int  $activity_id        The activity ID for the pending deleted activity comment.
	 * @param bool $deleted            Whether the comment was deleted or not.
	 * @return bool
	 */
	function bp_blogs_sync_delete_from_activity_comment($retval, $parent_activity_id, $activity_id, &$deleted)
	{
	}
	/**
	 * Updates the blog comment when the associated activity comment is edited.
	 *
	 * @since 2.0.0
	 *
	 * @param BP_Activity_Activity $activity The activity object.
	 */
	function bp_blogs_sync_activity_edit_to_post_comment(\BP_Activity_Activity $activity)
	{
	}
	/**
	 * When a post is trashed, remove each comment's associated activity meta.
	 *
	 * When a post is trashed and later untrashed, we currently don't reinstate
	 * activity items for these comments since their activity entries are already
	 * deleted when initially trashed.
	 *
	 * Since these activity entries are deleted, we need to remove the deleted
	 * activity comment IDs from each comment's meta when a post is trashed.
	 *
	 * @since 2.0.0
	 *
	 * @param int   $post_id  The post ID.
	 * @param array $comments Array of comment statuses. The key is comment ID, the
	 *                        value is the $comment->comment_approved value.
	 */
	function bp_blogs_remove_activity_meta_for_trashed_comments($post_id = 0, $comments = array())
	{
	}
	/**
	 * Filter 'new_blog_comment' bp_has_activities() loop to include new- and old-style blog activity comment items.
	 *
	 * In BuddyPress 2.0, the schema for storing activity items related to blog
	 * posts changed. Instead creating new top-level 'new_blog_comment' activity
	 * items, blog comments are recorded in the activity stream as comments on the
	 * 'new_blog_post' activity items corresponding to the parent post. This filter
	 * ensures that the 'new_blog_comment' filter in bp_has_activities() (which
	 * powers the 'Comments' filter in the activity directory dropdown) includes
	 * both old-style and new-style activity comments.
	 *
	 * @since 2.1.0
	 * @since 2.5.0 Used for any synced Post type comments, in wp-admin or front-end contexts.
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param array $args Arguments passed from bp_parse_args() in bp_has_activities().
	 * @return array $args
	 */
	function bp_blogs_new_blog_comment_query_backpat($args)
	{
	}
	/**
	 * Utility function to set up some variables for use in the activity loop.
	 *
	 * Grabs the blog's comment depth and the post's open comment status options
	 * for later use in the activity and activity comment loops.
	 *
	 * This is to prevent having to requery these items later on.
	 *
	 * @since 2.0.0
	 *
	 * @see bp_blogs_disable_activity_commenting()
	 * @see bp_blogs_setup_comment_loop_globals_on_ajax()
	 *
	 * @param object $activity The BP_Activity_Activity object.
	 */
	function bp_blogs_setup_activity_loop_globals($activity)
	{
	}
	/**
	 * Set up some globals used in the activity comment loop when AJAX is used.
	 *
	 * @since 2.0.0
	 *
	 * @see bp_blogs_setup_activity_loop_globals()
	 */
	function bp_blogs_setup_comment_loop_globals_on_ajax()
	{
	}
	/**
	 * Disable activity commenting for blog posts based on certain criteria.
	 *
	 * If activity commenting is enabled for blog posts, we still need to disable
	 * commenting if:
	 *  - comments are disabled for the WP blog post from the admin dashboard
	 *  - the WP blog post is supposed to be automatically closed from comments
	 *    based on a certain age
	 *  - the activity entry is a 'new_blog_comment' type
	 *
	 * @since 2.0.0
	 *
	 * @global BP_Activity_Template $activities_template The Activity template object.
	 *
	 * @param bool $retval Is activity commenting enabled for this activity entry.
	 * @return bool
	 */
	function bp_blogs_disable_activity_commenting($retval)
	{
	}
	/**
	 * Limit the display of post type synced comments.
	 *
	 * @since  2.5.0
	 *
	 * When viewing the synced comments in stream mode, this prevents comments to
	 * be displayed twice, and avoids a Javascript error as the form to add replies
	 * is not available.
	 *
	 * @param  int $retval  The comment count for the activity.
	 * @return int          The comment count, or 0 to hide activity comment replies.
	 */
	function bp_blogs_post_type_comments_avoid_duplicates($retval)
	{
	}
	/**
	 * Check if an activity comment associated with a blog post can be replied to.
	 *
	 * By default, disables replying to activity comments if the corresponding WP
	 * blog post no longer accepts comments.
	 *
	 * This check uses a locally-cached value set in {@link bp_blogs_disable_activity_commenting()}
	 * via {@link bp_blogs_setup_activity_loop_globals()}.
	 *
	 * @since 2.0.0
	 *
	 * @param bool         $retval  Are replies allowed for this activity reply.
	 * @param object|array $comment The activity comment object.
	 *
	 * @return bool
	 */
	function bp_blogs_can_comment_reply($retval, $comment)
	{
	}
	/**
	 * Changes activity comment permalinks to use the blog comment permalink
	 * instead of the activity permalink.
	 *
	 * This is only done if activity commenting is allowed and whether the parent
	 * activity item is a 'new_blog_post' entry.
	 *
	 * @since 2.0.0
	 *
	 * @global BP_Activity_Template $activities_template The Activity template object.
	 *
	 * @param string $retval The activity comment permalink.
	 * @return string
	 */
	function bp_blogs_activity_comment_permalink($retval = '')
	{
	}
	/**
	 * Changes single activity comment entries to use the blog comment permalink.
	 *
	 * This is only done if the activity comment is associated with a blog comment.
	 *
	 * @since 2.0.1
	 *
	 * @param string               $retval   The activity permalink.
	 * @param BP_Activity_Activity $activity Activity object.
	 * @return string
	 */
	function bp_blogs_activity_comment_single_permalink($retval, $activity)
	{
	}
	/**
	 * Formats single activity comment entries to use the blog comment action.
	 *
	 * This is only done if the activity comment is associated with a blog comment.
	 *
	 * @since 2.0.1
	 *
	 * @param string               $retval   The activity action.
	 * @param BP_Activity_Activity $activity Activity object.
	 * @return string
	 */
	function bp_blogs_activity_comment_single_action($retval, $activity)
	{
	}
	/**
	 * Blogs: User's "Sites" screen handler
	 *
	 * @package BuddyPress
	 * @subpackage BlogsScreens
	 * @since 3.0.0
	 */
	/**
	 * Load the "My Blogs" screen.
	 *
	 * @since 1.0.0
	 */
	function bp_blogs_screen_my_blogs()
	{
	}
	/**
	 * Blogs: Create screen handler
	 *
	 * @package BuddyPress
	 * @subpackage BlogsScreens
	 * @since 3.0.0
	 */
	/**
	 * Load the "Create a Blog" screen.
	 *
	 * @since 1.0.0
	 */
	function bp_blogs_screen_create_a_blog()
	{
	}
	/**
	 * Blogs: Directory screen handler
	 *
	 * @package BuddyPress
	 * @subpackage BlogsScreens
	 * @since 3.0.0
	 */
	/**
	 * Load the top-level Blogs directory.
	 *
	 * @since 1.0.0
	 */
	function bp_blogs_screen_index()
	{
	}
	/**
	 * Ensure that the 'Create a new site' link at wp-admin/my-sites.php points to the BP blog signup.
	 *
	 * @since 1.6.0
	 *
	 * @param string $url The original URL (points to wp-signup.php by default).
	 * @return string The new URL.
	 */
	function bp_blogs_creation_location($url)
	{
	}
	/**
	 * Only select comments by ID instead of all fields when using get_comments().
	 *
	 * @since 2.1.0
	 *
	 * @see bp_blogs_update_post_activity_meta()
	 *
	 * @param array $retval Current SQL clauses in array format.
	 * @return array
	 */
	function bp_blogs_comments_clauses_select_by_id($retval)
	{
	}
	/**
	 * Check whether the current activity about a post or a comment can be published.
	 *
	 * Abstracted from the deprecated `bp_blogs_record_post()`.
	 *
	 * @since 2.2.0
	 *
	 * @param bool $return  Whether the post should be published.
	 * @param int  $blog_id ID of the blog.
	 * @param int  $post_id ID of the post.
	 * @param int  $user_id ID of the post author.
	 * @return bool True to authorize the post to be published, otherwise false.
	 */
	function bp_blogs_post_pre_publish($return = \true, $blog_id = 0, $post_id = 0, $user_id = 0)
	{
	}
	/**
	 * Registers our custom thumb size with WP's Site Icon feature.
	 *
	 * @since 2.7.0
	 *
	 * @param  array $sizes Current array of custom site icon sizes.
	 * @return array
	 */
	function bp_blogs_register_custom_site_icon_size($sizes)
	{
	}
	/**
	 * Use the mystery blog avatar for blogs.
	 *
	 * @since 7.0.0
	 *
	 * @param string $avatar Current avatar src.
	 * @param array  $params Avatar params.
	 * @return string
	 */
	function bp_blogs_default_avatar($avatar, $params)
	{
	}
	/**
	 * Filters the column name during blog metadata queries.
	 *
	 * This filters 'sanitize_key', which is used during various core metadata
	 * API functions: {@link https://core.trac.wordpress.org/browser/branches/4.9/src/wp-includes/meta.php?lines=47,160,324}.
	 * Due to how we are passing our meta type, we need to ensure that the correct
	 * DB column is referenced during blogmeta queries.
	 *
	 * @since 4.0.0
	 *
	 * @see bp_blogs_delete_blogmeta()
	 * @see bp_blogs_get_blogmeta()
	 * @see bp_blogs_update_blogmeta()
	 * @see bp_blogs_add_blogmeta()
	 *
	 * @param string $retval
	 *
	 * @return string
	 */
	function bp_blogs_filter_meta_column_name($retval)
	{
	}
	/**
	 * Blogs: Random blog action handler
	 *
	 * @package BuddyPress
	 * @subpackage BlogsActions
	 * @since 3.0.0
	 */
	/**
	 * Redirect to a random blog in the multisite network.
	 *
	 * @since 1.0.0
	 */
	function bp_blogs_redirect_to_random_blog()
	{
	}
	/**
	 * Notification formatting callback for bp-members notifications.
	 *
	 * @since 8.0.0
	 *
	 * @param string $action            The kind of notification being rendered.
	 * @param int    $item_id           The primary item ID.
	 * @param int    $secondary_item_id The secondary item ID.
	 * @param int    $total_items       The total number of members-related notifications
	 *                                  waiting for the user.
	 * @param string $format            'string' for BuddyBar-compatible notifications;
	 *                                  'array' for WP Toolbar. Default: 'string'.
	 * @return array|string
	 */
	function members_format_notifications($action, $item_id, $secondary_item_id, $total_items, $format = 'string')
	{
	}
	/**
	 * Notify one use that another user has accepted their site membership invitation.
	 *
	 * @since 8.0.0
	 *
	 * @param BP_Invitation $invite     Invitation that was accepted.
	 * @param WP_user       $new_user   User who accepted the membership invite.
	 * @param int           $inviter_id ID of the user who invited this user to the site.
	 */
	function bp_members_invitations_accepted_invitation_notification($invite, $new_user, $inviter_id)
	{
	}
	/**
	 * Mark accepted invitation notifications as read when user visits new user profile.
	 *
	 * @since 8.0.0
	 */
	function bp_members_mark_read_accepted_invitation_notification()
	{
	}
	/**
	 * Mark new membership request notifications as read when user visits Manage BP Signups screen.
	 *
	 * @since 10.0.0
	 */
	function bp_members_mark_read_submitted_membership_request_notification()
	{
	}
	/**
	 * Add Members-related settings to the Settings > Notifications page.
	 *
	 * @since 8.0.0
	 */
	function members_screen_notification_settings()
	{
	}
	/**
	 * Registers the script to manage the dynamic part of the Dynamic Members widget/block.
	 *
	 * @since 9.0.0
	 * @since 12.0.0 Uses the `@wordpress/scripts` `index.asset.php` generated file to get dependencies.
	 *
	 * @param array $scripts Data about the scripts to register.
	 * @return array Data about the scripts to register.
	 */
	function bp_members_register_scripts($scripts = array())
	{
	}
	/**
	 * Pre-fetch member type data when initializing a Members loop.
	 *
	 * @since 2.2.0
	 *
	 * @param BP_User_Query $bp_user_query BP_User_Query object.
	 */
	function bp_members_prefetch_member_type($bp_user_query)
	{
	}
	/**
	 * Clear the member_type cache for a user.
	 *
	 * Called when the user is deleted or marked as spam.
	 *
	 * @since 2.2.0
	 *
	 * @param int $user_id ID of the deleted user.
	 */
	function bp_members_clear_member_type_cache($user_id)
	{
	}
	/**
	 * Invalidate activity caches when a user's last_activity value is changed.
	 *
	 * @since 2.7.0
	 *
	 * @return bool
	 */
	function bp_members_reset_activity_cache_incrementor()
	{
	}
	/**
	 * Bust signup caches when editing or deleting.
	 *
	 * @since 10.0.0
	 *
	 * @param int $signup_id The ID of the signup affected.
	 */
	function bp_members_delete_signup_cache($signup_id = 0)
	{
	}
	/**
	 * Bust signup caches for arrays of signup IDs.
	 *
	 * @since 10.0.0
	 *
	 * @param array $signup_ids The IDs of the signups affected.
	 */
	function bp_members_delete_signup_cache_multiples($signup_ids = array())
	{
	}
	/**
	 * Reset cache incrementor for BP_Signups.
	 *
	 * This function invalidates all cached results of BP_Signup queries,
	 * whenever one of the following events takes place:
	 *   - A record is created or updated.
	 *   - A record is deleted.
	 *
	 * @since 10.0.0
	 *
	 * @return bool
	 */
	function bp_members_reset_signup_cache_incrementor()
	{
	}
	/**
	 * When a user joins the network via an invitation, skip sending the activation email.
	 *
	 * @since 8.0.0
	 *
	 * @param bool   $send       Whether or not to send the activation key.
	 * @param int    $user_id    User ID to send activation key to.
	 * @param string $user_email User email to send activation key to.
	 *
	 * @return bool Whether or not to send the activation key.
	 */
	function bp_members_invitations_cancel_activation_email($send, $user_id = 0, $user_email = '')
	{
	}
	/**
	 * When a user joins the network via an invitation:
	 * - mark all invitations and requests as accepted
	 * - activate the user upon signup
	 *
	 * @since 8.0.0
	 *
	 * @param bool|WP_Error $user_id True on success, WP_Error on failure.
	 */
	function bp_members_invitations_complete_signup($user_id)
	{
	}
	/**
	 * Delete site membership invitations when an opt-out request is saved.
	 *
	 * @since 8.0.0
	 *
	 * @param BP_Optout $optout Characteristics of the opt-out just saved.
	 */
	function bp_members_invitations_delete_optedout_invites($optout)
	{
	}
	/**
	 * If a user submits a site membership request, but there's a
	 * sent invitation to her, bypass the manual approval of the request.
	 *
	 * @since 10.0.0
	 *
	 * @param bool  $send    Whether or not this membership request should be approved
	 *                       immediately and the activation email sent.
	 *                       Default is `false` meaning that the request should be
	 *                       manually approved by a site admin.
	 * @param array $details The details of the request.
	 */
	function bp_members_invitations_maybe_bypass_request_approval($send, $details)
	{
	}
	/**
	 * Whether a user can access invitations screens.
	 * Referred to by BP_Members_Invitations_Component::register_nav().
	 *
	 * @since 12.0.0
	 *
	 * @param bool $access Whether the user can view member invitations screens.
	 */
	function bp_members_invitations_user_can_view_screens()
	{
	}
	/**
	 * Whether a user can access the send invitations member screen.
	 * Referred to by BP_Members_Invitations_Component::register_nav().
	 *
	 * @since 12.0.0
	 *
	 * @param bool $access Whether the user can view member invitations send screen.
	 */
	function bp_members_invitations_user_can_view_send_screen()
	{
	}
	/**
	 * Single site: When a user creates a membership request,
	 * prevent the sending of the activation email so that
	 * the site admins can send it manually.
	 *
	 * @since 10.0.0
	 *
	 * @param bool   $send           Whether or not to send the activation key.
	 * @param int    $user_id        User ID to send activation key to.
	 * @param string $user_email     User email to send activation key to.
	 * @param string $activation_key Activation key to be sent.
	 * @param array  $usermeta       Miscellaneous metadata about the user (blog-specific
	 *                               signup data, xprofile data, etc).
	 * @return bool Whether or not to send the activation key.
	 */
	function bp_members_membership_requests_cancel_activation_email($send, $user_id = 0, $user_email = '', $activation_key = '', $usermeta = array())
	{
	}
	/**
	 * WP Multisite: When a user creates a membership request,
	 * prevent the sending of the activation email so that
	 * the site admins can send it manually.
	 *
	 * @since 10.0.0
	 *
	 * @param bool   $send             Whether or not to send the activation key.
	 * @param string $user_login       User login name.
	 * @param string $user_email       User email address.
	 * @param string $activation_key   Activation key created in wpmu_signup_user().
	 * @param bool   $is_signup_resend Is the site admin sending this email?
	 * @return bool Whether or not to send the activation key.
	 */
	function bp_members_membership_requests_cancel_activation_email_multisite($send = \true, $user_login = '', $user_email = '', $activation_key = '', $is_signup_resend = \false)
	{
	}
	/**
	 * Notifications
	 *********************************************************************/
	/**
	 * Notify site admins about a new membership request.
	 *
	 * @since 10.0.0
	 *
	 * @param BP_Signup $signup The signup object that has been created.
	 */
	function bp_members_membership_requests_notify_site_admins($signup)
	{
	}
	/**
	 * Send a message to the requesting user when his or her
	 * site membership request has been rejected.
	 *
	 * @since 10.0.0
	 *
	 * @param array $signup_ids Array of pending IDs to delete.
	 */
	function bp_members_membership_requests_send_rejection_mail($signup_ids)
	{
	}
	/**
	 * When a request is approved, activated or deleted,
	 * delete the associated notifications.
	 *
	 * @since 10.0.0
	 *
	 * @param array $signup_ids Array of changing signup IDs.
	 */
	function bp_members_membership_requests_delete_notifications_on_change($signup_ids)
	{
	}
	/**
	 * In the Nouveau template pack, when membership requests are required,
	 * change registration form submit button label to "Submit Request".
	 *
	 * @since 10.0.0
	 *
	 * @return string $retval the HTML for the request membership link.
	 */
	function bp_members_membership_requests_filter_complete_signup_button($buttons)
	{
	}
	/**
	 * Administration: Change certain behavior and labels
	 * on the WP Admin > Users > Manage Signups screen.
	 *********************************************************************/
	/**
	 * Filter the actions available on the signups list table.
	 *
	 * @since 10.0.0
	 *
	 * @param array  $actions       Array of actions and corresponding links.
	 * @param object $signup_object The signup data object.
	 */
	function bp_members_membership_requests_filter_signup_row_actions($actions, $signup_object)
	{
	}
	/**
	 * Filter the bulk actions available on the signups list table.
	 *
	 * @since 10.0.0
	 *
	 * @param array $actions Array of actions and corresponding links.
	 * @return array         List of actions and corresponding links.
	 */
	function bp_members_membership_requests_filter_signup_bulk_actions($actions)
	{
	}
	/**
	 * Filter the "Last Sent" column header on the pending users table.
	 *
	 * @since 10.0.0
	 *
	 * @param array $columns Array of columns to display.
	 * @return array List of columns to display.
	 */
	function bp_members_membership_requests_filter_signup_table_date_sent_header($columns)
	{
	}
	/**
	 * Filter the "Last Sent" column message on the pending users table.
	 *
	 * @since 10.0.0
	 *
	 * @param string      $message "Not yet sent" message.
	 * @param object|null $signup  Signup object instance.
	 * @return string              "Not yet approved" message, if needed. Unchanged message otherwise.
	 */
	function bp_members_membership_requests_filter_signup_table_unsent_message($message, $signup)
	{
	}
	/**
	 * Filter/add "Request Membership" links in the following locations:
	 * - BP login block widget,
	 * - Sidebar register link,
	 * - WP Toolbar,
	 * - WP login form.
	 *********************************************************************/
	/**
	 * Add "Request Membership" link to Block Widget login form.
	 *
	 * @since 10.0.0
	 *
	 * @return string $retval the HTML for the request membership link.
	 */
	function bp_members_membership_requests_add_link_to_widget_login_form()
	{
	}
	/**
	 * Filter the "Register" link from `wp_register()` as used in
	 * `sidebar.php` and the WP Core meta widget.
	 *
	 * @since 10.0.0
	 *
	 * @param string $link The HTML code for the link to the Registration or Admin page.
	 * @return string      An empty string or the HTML code for the link to the Membership request page.
	 */
	function bp_members_membership_requests_filter_sidebar_register_link($link)
	{
	}
	/**
	 * Add a "Request Membership" link to the WP Toolbar.
	 * Priority 21 should place it just after the "Log In" link.
	 *
	 * @since 10.0.0
	 *
	 * @param WP_Admin_Bar $wp_admin_bar WordPress object implementing a Toolbar API.
	 */
	function bp_members_membership_requests_add_toolbar_link($wp_admin_bar)
	{
	}
	/**
	 * Add a "Request Membership" link to the WP Login form.
	 *
	 * @since 10.0.0
	 *
	 * @param string $link HTML link to the home URL of the current site.
	 * @return string      HTML link to the home URL of the current site and the one to request a membership.
	 */
	function bp_members_membership_requests_add_link_wp_login($link)
	{
	}
	/**
	 * Load additional sign-up sanitization filters on bp_loaded.
	 *
	 * These are used to prevent XSS in the BuddyPress sign-up process. You can
	 * unhook these to allow for customization of your registration fields;
	 * however, it is highly recommended that you leave these in place for the
	 * safety of your network.
	 *
	 * @since 1.5.0
	 */
	function bp_members_signup_sanitization()
	{
	}
	/**
	 * Make sure the username is not the blog slug in case of root profile & subdirectory blog.
	 *
	 * If BP_ENABLE_ROOT_PROFILES is defined & multisite config is set to subdirectories,
	 * then there is a chance site.url/username == site.url/blogslug. If so, user's profile
	 * is not reachable, instead the blog is displayed. This filter makes sure the signup username
	 * is not the same than the blog slug for this particular config.
	 *
	 * @since 2.1.0
	 *
	 * @param array $illegal_names Array of illiegal names.
	 * @return array $illegal_names
	 */
	function bp_members_signup_with_subdirectory_blog($illegal_names = array())
	{
	}
	/**
	 * Filter the user profile URL to point to BuddyPress profile edit.
	 *
	 * @since 1.6.0
	 *
	 * @param string $url     WP profile edit URL.
	 * @param int    $user_id ID of the user.
	 * @param string $scheme  Scheme to use.
	 * @return string
	 */
	function bp_members_edit_profile_url($url, $user_id, $scheme = 'admin')
	{
	}
	/**
	 * Filter the bp_user_can value to determine what the user can do in the members component.
	 *
	 * @since 8.0.0
	 *
	 * @param bool   $retval     Whether or not the current user has the capability.
	 * @param int    $user_id    User ID.
	 * @param string $capability The capability being checked for.
	 * @param int    $site_id    Site ID. Defaults to the BP root blog.
	 * @param array  $args       Array of extra arguments passed.
	 *
	 * @return bool
	 */
	function bp_members_user_can_filter($retval, $user_id, $capability, $site_id, $args = array())
	{
	}
	/**
	 * Do not allow the new user to change the email address
	 * if they are accepting a community invitation.
	 *
	 * @since 8.0.0
	 *
	 * @param array  $attributes The field attributes.
	 * @param string $name       The field name.
	 *
	 * @return array $attributes The field attributes.
	 */
	function bp_members_invitations_make_registration_email_input_readonly_if_invite($attributes, $name)
	{
	}
	/**
	 * Provide a more-specific welcome message if the new user
	 * is accepting a network invitation.
	 *
	 * @since 8.0.0
	 *
	 * @return string $message The message text.
	 */
	function bp_members_invitations_get_registration_welcome_message()
	{
	}
	/**
	 * Provide a more-specific "registration is disabled" message
	 * if registration is available by invitation only.
	 * Also provide failure note if new user is trying to accept
	 * a network invitation but there's a problem.
	 *
	 * @since 8.0.0
	 *
	 * @return string $message The message text.
	 */
	function bp_members_invitations_get_modified_registration_disabled_message()
	{
	}
	/**
	 * Sanitize the invitation property output.
	 *
	 * @since 8.0.0
	 *
	 * @param int|string $value    The value for the requested property.
	 * @param string     $property The name of the requested property.
	 * @param string     $context  Optional. The context of display.
	 * @return int|string          The sanitized value.
	 */
	function bp_members_sanitize_invitation_property($value = '', $property = '', $context = 'html')
	{
	}
	/**
	 * Members: Register screen handler
	 *
	 * @package BuddyPress
	 * @subpackage MembersScreens
	 * @since 3.0.0
	 */
	/**
	 * Handle the loading of the signup screen.
	 *
	 * @since 1.1.0
	 */
	function bp_core_screen_signup()
	{
	}
	/**
	 * Members: Change Cover Image screen handler
	 *
	 * @package BuddyPress
	 * @subpackage MembersScreens
	 * @since 6.0.0
	 */
	/**
	 * Handle the display of the profile Change Cover Image page by loading the correct template file.
	 *
	 * @since 6.0.0
	 */
	function bp_members_screen_change_cover_image()
	{
	}
	/**
	 * Catch and process the Send Invites page.
	 *
	 * @since 8.0.0
	 */
	function members_screen_send_invites()
	{
	}
	/**
	 * Catch and process the Pending Invites page.
	 *
	 * @since 8.0.0
	 */
	function members_screen_list_sent_invites()
	{
	}
	/**
	 * Members: Directory screen handler
	 *
	 * @package BuddyPress
	 * @subpackage MembersScreens
	 * @since 3.0.0
	 */
	/**
	 * Handle the display of the members directory index.
	 *
	 * @since 1.5.0
	 */
	function bp_members_screen_index()
	{
	}
	/**
	 * Members: Activate screen handler
	 *
	 * @package BuddyPress
	 * @subpackage MembersScreens
	 * @since 3.0.0
	 */
	/**
	 * Handle the loading of the Activate screen.
	 *
	 * @since 1.1.0
	 */
	function bp_core_screen_activation()
	{
	}
	/**
	 * Catches and processes account activation requests.
	 *
	 * @since 3.0.0
	 */
	function bp_members_action_activate_account()
	{
	}
	/**
	 * Members: Profile screen handler
	 *
	 * @package BuddyPress
	 * @subpackage MembersScreens
	 * @since 3.0.0
	 */
	/**
	 * Handle the display of the profile page by loading the correct template file.
	 *
	 * @since 1.5.0
	 */
	function bp_members_screen_display_profile()
	{
	}
	/**
	 * Members: Change Avatar screen handler
	 *
	 * @package BuddyPress
	 * @subpackage MembersScreens
	 * @since 6.0.0
	 */
	/**
	 * Handle the display of the profile Change Avatar page by loading the correct template file.
	 *
	 * @since 6.0.0
	 */
	function bp_members_screen_change_avatar()
	{
	}
	/**
	 * Check for the existence of a Members directory page.
	 *
	 * @since 1.5.0
	 *
	 * @return bool True if found, otherwise false.
	 */
	function bp_members_has_directory()
	{
	}
	/**
	 * Fetch an array of users based on the parameters passed.
	 *
	 * Since BuddyPress 1.7, bp_core_get_users() uses BP_User_Query. If you
	 * need backward compatibility with BP_Core_User::get_users(), filter the
	 * bp_use_legacy_user_query value, returning true.
	 *
	 * @since 1.2.0
	 * @since 7.0.0 Added `xprofile_query` parameter. Added `user_ids` parameter.
	 *
	 * @param array|string $args {
	 *     Array of arguments. All are optional. See {@link BP_User_Query} for
	 *     a more complete description of arguments.
	 *     @type string       $type                Sort order. Default: 'active'.
	 *     @type int          $user_id             Limit results to friends of a user. Default: false.
	 *     @type mixed        $exclude             IDs to exclude from results. Default: false.
	 *     @type string       $search_terms        Limit to users matching search terms. Default: false.
	 *     @type string       $meta_key            Limit to users with a meta_key. Default: false.
	 *     @type string       $meta_value          Limit to users with a meta_value (with meta_key). Default: false.
	 *     @type array|string $member_type         Array or comma-separated string of member types.
	 *     @type array|string $member_type__in     Array or comma-separated string of member types.
	 *                                             `$member_type` takes precedence over this parameter.
	 *     @type array|string $member_type__not_in Array or comma-separated string of member types to be excluded.
	 *     @type mixed        $include             Limit results by user IDs. Default: false.
	 *     @type mixed        $user_ids            IDs corresponding to the users. Default: false.
	 *     @type int          $per_page            Results per page. Default: 20.
	 *     @type int          $page                Page of results. Default: 1.
	 *     @type bool         $populate_extras     Fetch optional extras. Default: true.
	 *     @type array        $xprofile_query      Filter results by xprofile data. Requires the xprofile
	 *                                             component. See {@see BP_XProfile_Query} for details.
	 *     @type string|bool  $count_total         How to do total user count. Default: 'count_query'.
	 * }
	 * @return array
	 */
	function bp_core_get_users($args = '')
	{
	}
	/**
	 * Get single Members item customized path chunks using an array of BP URL default slugs.
	 *
	 * @since 12.0.0
	 *
	 * @param array $chunks An array of BP URL default slugs.
	 * @return array An associative array containing member's customized path chunks.
	 */
	function bp_members_get_path_chunks($chunks = array())
	{
	}
	/**
	 * Return the Members single item's URL.
	 *
	 * @since 12.0.0
	 *
	 * @param integer $user_id  The user ID.
	 * @param array   $path_chunks {
	 *     An array of arguments. Optional.
	 *
	 *     @type string $single_item_component        The component slug the action is relative to.
	 *     @type string $single_item_action           The slug of the action to perform.
	 *     @type array  $single_item_action_variables An array of additional informations about the action to perform.
	 * }
	 * @return string The URL built for the BP Rewrites URL parser.
	 */
	function bp_members_get_user_url($user_id = 0, $path_chunks = array())
	{
	}
	/**
	 * Fetch everything in the wp_users table for a user, without any usermeta.
	 *
	 * @since 1.2.0
	 *
	 * @param int $user_id The ID of the user.
	 * @return array|bool Array of data on success, false on failure.
	 */
	function bp_core_get_core_userdata($user_id = 0)
	{
	}
	/**
	 * Return the user ID based on a user's user_login.
	 *
	 * @since 1.0.0
	 *
	 * @param string $username user_login to check.
	 * @return int|null The ID of the matched user on success, null on failure.
	 */
	function bp_core_get_userid($username = '')
	{
	}
	/**
	 * Return the user ID based on a user's user_nicename.
	 *
	 * @since 1.2.3
	 *
	 * @param string $user_nicename user_nicename to check.
	 * @return int|null The ID of the matched user on success, null on failure.
	 */
	function bp_core_get_userid_from_nicename($user_nicename = '')
	{
	}
	/**
	 * Returns the members single item (member) slug.
	 *
	 * @since 12.0.0
	 *
	 * @param integer $user_id The User ID.
	 * @return string The member slug.
	 */
	function bp_members_get_user_slug($user_id = 0)
	{
	}
	/**
	 * Return the user_nicename for a user based on their user_id.
	 *
	 * This should be used for linking to user profiles and anywhere else a
	 * sanitized and unique slug to a user is needed.
	 *
	 * @since 1.5.0
	 *
	 * @param int $user_id User ID to check.
	 * @return string The username of the matched user or an empty string if no user is found.
	 */
	function bp_members_get_user_nicename($user_id)
	{
	}
	/**
	 * Return the email address for the user based on user ID.
	 *
	 * @since 1.0.0
	 *
	 * @param int $user_id User ID to check.
	 * @return string The email for the matched user. Empty string if no user
	 *                matches the $user_id.
	 */
	function bp_core_get_user_email($user_id)
	{
	}
	/**
	 * Return a HTML formatted link for a user with the user's full name as the link text.
	 *
	 * Eg: <a href="http://andy.example.com/">Andy Peatling</a>
	 *
	 * Optional parameters will return just the name or just the URL.
	 *
	 * @since 1.0.0
	 *
	 * @param int  $user_id   User ID to check.
	 * @param bool $no_anchor Disable URL and HTML and just return full name.
	 *                        Default: false.
	 * @param bool $just_link Disable full name and HTML and just return the URL
	 *                        text. Default false.
	 * @return string|false The link text based on passed parameters, or false on
	 *                     no match.
	 */
	function bp_core_get_userlink($user_id, $no_anchor = \false, $just_link = \false)
	{
	}
	/**
	 * Fetch the display name for a group of users.
	 *
	 * Uses the 'Name' field in xprofile if available. Falls back on WP
	 * display_name, and then user_nicename.
	 *
	 * @since 2.0.0
	 *
	 * @param array $user_ids Array of user IDs to get display names for.
	 * @return array Associative array of the format "id" => "displayname".
	 */
	function bp_core_get_user_displaynames($user_ids)
	{
	}
	/**
	 * Fetch the display name for a user.
	 *
	 * @since 1.0.1
	 *
	 * @param int|string|bool $user_id_or_username User ID or username.
	 * @return string|bool The display name for the user in question, or false if
	 *                     user not found.
	 */
	function bp_core_get_user_displayname($user_id_or_username)
	{
	}
	/**
	 * Return the user link for the user based on user email address.
	 *
	 * @since 1.0.0
	 *
	 * @param string $email The email address for the user.
	 * @return string The link to the users home base. False on no match.
	 */
	function bp_core_get_userlink_by_email($email)
	{
	}
	/**
	 * Return the user link for the user based on the supplied identifier.
	 *
	 * @since 1.0.0
	 *
	 * @param string $username If BP_ENABLE_USERNAME_COMPATIBILITY_MODE is set,
	 *                         this should be user_login, otherwise it should
	 *                         be user_nicename.
	 * @return string|bool The link to the user's domain, false on no match.
	 */
	function bp_core_get_userlink_by_username($username)
	{
	}
	/**
	 * Return the total number of members for the installation.
	 *
	 * Note that this is a raw count of non-spam, activated users. It does not
	 * account for users who have logged activity (last_active). See
	 * {@link bp_core_get_active_member_count()}.
	 *
	 * @since 1.2.0
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @return int The total number of members.
	 */
	function bp_core_get_total_member_count()
	{
	}
	/**
	 * Return the total number of members, limited to those members with last_activity.
	 *
	 * @since 1.6.0
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @return int The number of active members.
	 */
	function bp_core_get_active_member_count()
	{
	}
	/**
	 * Update the spam status of the member on multisite configs.
	 *
	 * @since 5.0.0
	 *
	 * @param int    $user_id The user ID to spam or ham.
	 * @param string $value   '0' to mark the user as `ham`, '1' to mark as `spam`.
	 * @return bool          True if the spam status of the member changed.
	 *                       False otherwise.
	 */
	function bp_core_update_member_status($user_id = 0, $value = 0)
	{
	}
	/**
	 * Process a spammed or unspammed user.
	 *
	 * This function is called from three places:
	 *
	 * - in bp_settings_action_capabilities() (from the front-end)
	 * - by bp_core_mark_user_spam_admin()    (from wp-admin)
	 * - bp_core_mark_user_ham_admin()        (from wp-admin)
	 *
	 * @since 1.6.0
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param int    $user_id       The ID of the user being spammed/hammed.
	 * @param string $status        'spam' if being marked as spam, 'ham' otherwise.
	 * @param bool   $do_wp_cleanup Optional. True to force the cleanup of WordPress content
	 *                              and status, otherwise false. Generally, this should
	 *                              only be false if WordPress is expected to have
	 *                              performed this cleanup independently, as when hooked
	 *                              to 'make_spam_user'.
	 * @return bool
	 */
	function bp_core_process_spammer_status($user_id, $status, $do_wp_cleanup = \true)
	{
	}
	/**
	 * Hook to WP's make_spam_user and run our custom BP spam functions.
	 *
	 * @since 1.6.0
	 *
	 * @param int $user_id The user ID passed from the make_spam_user hook.
	 */
	function bp_core_mark_user_spam_admin($user_id)
	{
	}
	/**
	 * Hook to WP's make_ham_user and run our custom BP spam functions.
	 *
	 * @since 1.6.0
	 *
	 * @param int $user_id The user ID passed from the make_ham_user hook.
	 */
	function bp_core_mark_user_ham_admin($user_id)
	{
	}
	/**
	 * Check whether a user has been marked as a spammer.
	 *
	 * @since 1.6.0
	 *
	 * @global BP_Core_Members_Template $members_template The Members template loop class.
	 *
	 * @param int $user_id The ID for the user.
	 * @return bool True if spammer, otherwise false.
	 */
	function bp_is_user_spammer($user_id = 0)
	{
	}
	/**
	 * Check whether a user has been marked as deleted.
	 *
	 * @since 1.6.0
	 *
	 * @param int $user_id The ID for the user.
	 * @return bool True if deleted, otherwise false.
	 */
	function bp_is_user_deleted($user_id = 0)
	{
	}
	/**
	 * Check whether a user is "active", ie neither deleted nor spammer.
	 *
	 * @since 1.6.0
	 *
	 * @param int $user_id Optional. The user ID to check.
	 * @return bool True if active, otherwise false.
	 */
	function bp_is_user_active($user_id = 0)
	{
	}
	/**
	 * Check whether user is not active.
	 *
	 * @since 1.6.0
	 *
	 * @param int $user_id Optional. The user ID to check.
	 * @return bool True if inactive, otherwise false.
	 */
	function bp_is_user_inactive($user_id = 0)
	{
	}
	/**
	 * Update a user's last activity.
	 *
	 * @since 1.9.0
	 * @since 7.0.0 Backward compatibility usermeta mirroring is only allowed if the
	 *              legacy user query is enabled.
	 *
	 * @param int    $user_id Optional. ID of the user being updated.
	 * @param string $time    Optional. Time of last activity, in 'Y-m-d H:i:s' format.
	 * @return bool
	 */
	function bp_update_user_last_activity($user_id = 0, $time = '')
	{
	}
	/**
	 * Backward compatibility for 'last_activity' usermeta fetching.
	 *
	 * In BuddyPress 2.0, user last_activity data was moved out of usermeta. For
	 * backward compatibility, we continue to mirror the data there. This function
	 * serves two purposes: it warns plugin authors of the change, and it returns
	 * the data from the proper location.
	 *
	 * @since 2.0.0
	 * @since 2.9.3 Added the `$single` parameter.
	 *
	 * @access private For internal use only.
	 *
	 * @param null   $retval Null retval value.
	 * @param int    $object_id ID of the user.
	 * @param string $meta_key  Meta key being fetched.
	 * @param bool   $single    Whether a single key is being fetched (vs an array).
	 * @return string|null
	 */
	function _bp_get_user_meta_last_activity_warning($retval, $object_id, $meta_key, $single)
	{
	}
	/**
	 * Backward compatibility for 'last_activity' usermeta setting.
	 *
	 * In BuddyPress 2.0, user last_activity data was moved out of usermeta. For
	 * backward compatibility, we continue to mirror the data there. This function
	 * serves two purposes: it warns plugin authors of the change, and it updates
	 * the data in the proper location.
	 *
	 * @since 2.0.0
	 *
	 * @access private For internal use only.
	 *
	 * @param int    $meta_id    ID of the just-set usermeta row.
	 * @param int    $object_id  ID of the user.
	 * @param string $meta_key   Meta key being fetched.
	 * @param string $meta_value Active time.
	 */
	function _bp_update_user_meta_last_activity_warning($meta_id, $object_id, $meta_key, $meta_value)
	{
	}
	/**
	 * Get the last activity for a given user.
	 *
	 * @since 1.9.0
	 *
	 * @param int $user_id The ID of the user.
	 * @return string Time of last activity, in 'Y-m-d H:i:s' format, or an empty
	 *                string if none is found.
	 */
	function bp_get_user_last_activity($user_id = 0)
	{
	}
	/**
	 * Migrate last_activity data from the usermeta table to the activity table.
	 *
	 * Generally, this function is only run when BP is upgraded to 2.0. It can also
	 * be called directly from the BuddyPress Tools panel.
	 *
	 * @since 2.0.0
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @return bool
	 */
	function bp_last_activity_migrate()
	{
	}
	/**
	 * Process account deletion requests.
	 *
	 * Primarily used for self-deletions, as requested through Settings.
	 *
	 * @since 1.0.0
	 *
	 * @param int $user_id Optional. ID of the user to be deleted. Default: the
	 *                     logged-in user.
	 * @return bool
	 */
	function bp_core_delete_account($user_id = 0)
	{
	}
	/**
	 * Determines whether user data should be removed on the 'delete_user' hook.
	 *
	 * WordPress's 'delete_user' hook is ambiguous: on a standard installation, it means that a user
	 * account is being removed from the system, while on Multisite it simply means the user is
	 * being removed from a specific site (ie its roles are being revoked). As a rule, this means
	 * that BuddyPress should remove user data on the delete_user hook only on non-Multisite
	 * installations - only when the user account is being removed altogether. However, this behavior
	 * can be filtered in a global, per-user, or per-component fashion.
	 *
	 * @since 6.0.0
	 *
	 * @param string $data_type Type of data to be removed.
	 * @param int    $user_id   ID of the user, as passed to 'delete_user'.
	 * @return bool
	 */
	function bp_remove_user_data_on_delete_user_hook($component, $user_id)
	{
	}
	/**
	 * Delete a user's avatar when the user is deleted.
	 *
	 * @since 1.9.0
	 *
	 * @param int $user_id ID of the user who is about to be deleted.
	 * @return bool
	 */
	function bp_core_delete_avatar_on_user_delete($user_id)
	{
	}
	/**
	 * Deletes last_activity data on the 'delete_user' hook.
	 *
	 * @since 6.0.0
	 *
	 * @param int $user_id The ID of the deleted user.
	 */
	function bp_core_delete_avatar_on_delete_user($user_id)
	{
	}
	/**
	 * Multibyte-safe ucfirst() support.
	 *
	 * Uses multibyte functions when available on the PHP build.
	 *
	 * @since 1.0.0
	 *
	 * @param string $str String to be upper-cased.
	 * @return string
	 */
	function bp_core_ucfirst($str)
	{
	}
	/**
	 * Prevent spammers from logging in.
	 *
	 * When a user logs in, check if they have been marked as a spammer. If yes
	 * then simply redirect them to the home page and stop them from logging in.
	 *
	 * @since 1.1.2
	 *
	 * @param WP_User|WP_Error $user Either the WP_User object or the WP_Error
	 *                               object, as passed to the 'authenticate' filter.
	 * @return WP_User|WP_Error If the user is not a spammer, return the WP_User
	 *                          object. Otherwise a new WP_Error object.
	 */
	function bp_core_boot_spammer($user)
	{
	}
	/**
	 * Delete last_activity data for the user when the user is deleted.
	 *
	 * @since 1.0.0
	 *
	 * @param int $user_id The user ID for the user to delete usermeta for.
	 */
	function bp_core_remove_data($user_id)
	{
	}
	/**
	 * Deletes last_activity data on the 'delete_user' hook.
	 *
	 * @since 6.0.0
	 *
	 * @param int $user_id The ID of the deleted user.
	 */
	function bp_core_remove_data_on_delete_user($user_id)
	{
	}
	/**
	 * Check whether the logged-in user can edit settings for the displayed user.
	 *
	 * @since 1.5.0
	 *
	 * @return bool True if editing is allowed, otherwise false.
	 */
	function bp_core_can_edit_settings()
	{
	}
	/** Sign-up *******************************************************************/
	/**
	 * Flush illegal names by getting and setting 'illegal_names' site option.
	 *
	 * @since 1.2.5
	 */
	function bp_core_flush_illegal_names()
	{
	}
	/**
	 * Add BuddyPress-specific items to the illegal_names array.
	 *
	 * @since 1.2.7
	 *
	 * @param array|string $value Illegal names as being saved defined in
	 *                            Multisite settings.
	 * @return array Merged and unique array of illegal names.
	 */
	function bp_core_get_illegal_names($value = '')
	{
	}
	/**
	 * Check that an email address is valid for use.
	 *
	 * Performs the following checks:
	 *   - Is the email address well-formed?
	 *   - Is the email address already used?
	 *   - If there are disallowed email domains, is the current domain among them?
	 *   - If there's an email domain whitelist, is the current domain on it?
	 *
	 * @since 1.6.2
	 *
	 * @param string $user_email The email being checked.
	 * @return bool|array True if the address passes all checks; otherwise an array
	 *                    of error codes.
	 */
	function bp_core_validate_email_address($user_email)
	{
	}
	/**
	 * Add the appropriate errors to a WP_Error object, given results of a validation test.
	 *
	 * Functions like bp_core_validate_email_address() return a structured array
	 * of error codes. bp_core_add_validation_error_messages() takes this array and
	 * parses, adding the appropriate error messages to the WP_Error object.
	 *
	 * @since 1.7.0
	 *
	 * @see bp_core_validate_email_address()
	 *
	 * @param WP_Error $errors             WP_Error object.
	 * @param array    $validation_results The return value of a validation function
	 *                                     like bp_core_validate_email_address().
	 */
	function bp_core_add_validation_error_messages(\WP_Error $errors, $validation_results)
	{
	}
	/**
	 * Validate a user name and email address when creating a new user.
	 *
	 * @since 1.2.2
	 *
	 * @param string $user_name  Username to validate.
	 * @param string $user_email Email address to validate.
	 * @return array Results of user validation including errors, if any.
	 */
	function bp_core_validate_user_signup($user_name, $user_email)
	{
	}
	/**
	 * Validate a user password.
	 *
	 * @since 7.0.0
	 *
	 * @param string       $pass         The password.
	 * @param string       $confirm_pass The confirmed password.
	 * @param null|WP_User $userdata     Null or the userdata object when a member updates their password from front-end.
	 * @return WP_Error A WP error object possibly containing error messages.
	 */
	function bp_members_validate_user_password($pass, $confirm_pass, $userdata = \null)
	{
	}
	/**
	 * Validate blog URL and title provided at signup.
	 *
	 * @since 1.2.2
	 *
	 * @todo Why do we have this wrapper?
	 *
	 * @param string $blog_url   Blog URL requested during registration.
	 * @param string $blog_title Blog title requested during registration.
	 * @return array
	 */
	function bp_core_validate_blog_signup($blog_url, $blog_title)
	{
	}
	/**
	 * Process data submitted at user registration and convert to a signup object.
	 *
	 * @since 1.2.0
	 *
	 * @todo There appears to be a bug in the return value on success.
	 *
	 * @param string $user_login    Login name requested by the user.
	 * @param string $user_password Password requested by the user.
	 * @param string $user_email    Email address entered by the user.
	 * @param array  $usermeta      Miscellaneous metadata about the user (blog-specific
	 *                              signup data, xprofile data, etc).
	 * @return int|false True on success, WP_Error on failure.
	 */
	function bp_core_signup_user($user_login, $user_password, $user_email, $usermeta)
	{
	}
	/**
	 * Create a blog and user based on data supplied at user registration.
	 *
	 * @since 1.2.2
	 *
	 * @param string $blog_domain Domain requested by user.
	 * @param string $blog_path   Path requested by user.
	 * @param string $blog_title  Title as entered by user.
	 * @param string $user_name   user_login of requesting user.
	 * @param string $user_email  Email address of requesting user.
	 * @param string $usermeta    Miscellaneous metadata for the user.
	 * @return bool|null
	 */
	function bp_core_signup_blog($blog_domain, $blog_path, $blog_title, $user_name, $user_email, $usermeta)
	{
	}
	/**
	 * Activate a signup, as identified by an activation key.
	 *
	 * @since 1.2.2
	 *
	 * @global wpdb $wpdb WordPress database object.
	 *
	 * @param string $key Activation key.
	 * @return int|bool User ID on success, false on failure.
	 */
	function bp_core_activate_signup($key)
	{
	}
	/**
	 * Add default WordPress role for new signups on the BP root blog.
	 *
	 * @since 3.0.0
	 *
	 * @param int $user_id The user ID to add the default role for.
	 */
	function bp_members_add_role_after_activation($user_id)
	{
	}
	/**
	 * Migrate signups from pre-2.0 configuration to wp_signups.
	 *
	 * @since 2.0.1
	 *
	 * @global wpdb $wpdb WordPress database object.
	 */
	function bp_members_migrate_signups()
	{
	}
	/**
	 * Map a user's WP display name to the XProfile fullname field, if necessary.
	 *
	 * This only happens when a user is registered in wp-admin by an administrator;
	 * during normal registration, XProfile data is provided directly by the user.
	 *
	 * @since 1.2.0
	 *
	 * @param int $user_id ID of the user.
	 * @return bool
	 */
	function bp_core_map_user_registration($user_id)
	{
	}
	/**
	 * Get the avatar storage directory for use during registration.
	 *
	 * @since 1.1.0
	 *
	 * @return string|bool Directory path on success, false on failure.
	 */
	function bp_core_signup_avatar_upload_dir()
	{
	}
	/**
	 * Send activation email to a newly registered user.
	 *
	 * @since 1.2.2
	 * @since 2.5.0 Add the $user_login parameter.
	 * @since 5.0.0 Change $user_login parameter to more general $salutation.
	 *
	 * @param int|bool $user_id    ID of the new user, false if BP_SIGNUPS_SKIP_USER_CREATION is true.
	 * @param string   $user_email   Email address of the new user.
	 * @param string   $key          Activation key.
	 * @param string   $salutation   Optional. The name to be used as a salutation in the email.
	 */
	function bp_core_signup_send_validation_email($user_id, $user_email, $key, $salutation = '')
	{
	}
	/**
	 * Display a "resend email" link when an unregistered user attempts to log in.
	 *
	 * @since 1.2.2
	 *
	 * @param WP_User|WP_Error|null $user     Either the WP_User or the WP_Error object.
	 * @param string                $username The inputted, attempted username.
	 * @param string                $password The inputted, attempted password.
	 * @return WP_User|WP_Error
	 */
	function bp_core_signup_disable_inactive($user = \null, $username = '', $password = '')
	{
	}
	/**
	 * On the login screen, resends the activation email for a user.
	 *
	 * @since 2.0.0
	 *
	 * @global string $error The error message.
	 *
	 * @see bp_core_signup_disable_inactive()
	 */
	function bp_members_login_resend_activation_email()
	{
	}
	/**
	 * Redirect away from wp-signup.php if BP registration templates are present.
	 *
	 * @since 1.1.0
	 */
	function bp_core_wpsignup_redirect()
	{
	}
	/**
	 * Stop a logged-in user who is marked as a spammer.
	 *
	 * When an admin marks a live user as a spammer, that user can still surf
	 * around and cause havoc on the site until that person is logged out.
	 *
	 * This code checks to see if a logged-in user is marked as a spammer.  If so,
	 * we redirect the user back to wp-login.php with the 'reauth' parameter.
	 *
	 * This clears the logged-in spammer's cookies and will ask the spammer to
	 * reauthenticate.
	 *
	 * Note: A spammer cannot log back in - {@see bp_core_boot_spammer()}.
	 *
	 * Runs on 'bp_init' at priority 5 so the members component globals are setup
	 * before we do our spammer checks.
	 *
	 * This is important as the $bp->loggedin_user object is setup at priority 4.
	 *
	 * @since 1.8.0
	 */
	function bp_stop_live_spammer()
	{
	}
	/**
	 * Show a custom error message when a logged-in user is marked as a spammer.
	 *
	 * @since 1.8.0
	 *
	 * @global string $error The error message.
	 */
	function bp_live_spammer_login_error()
	{
	}
	/**
	 * Get the displayed user Object
	 *
	 * @since 2.6.0
	 *
	 * @return object The displayed user object, null otherwise.
	 */
	function bp_get_displayed_user()
	{
	}
	/** Member Types *************************************************************/
	/**
	 * Output the slug of the member type taxonomy.
	 *
	 * @since 2.7.0
	 */
	function bp_member_type_tax_name()
	{
	}
	/**
	 * Return the slug of the member type taxonomy.
	 *
	 * @since 2.7.0
	 *
	 * @return string The unique member taxonomy slug.
	 */
	function bp_get_member_type_tax_name()
	{
	}
	/**
	 * Returns labels used by the member type taxonomy.
	 *
	 * @since 7.0.0
	 *
	 * @return array
	 */
	function bp_get_member_type_tax_labels()
	{
	}
	/**
	 * Returns arguments used by the Member type taxonomy.
	 *
	 * @since 7.0.0
	 *
	 * @return array
	 */
	function bp_get_member_type_tax_args()
	{
	}
	/**
	 * Extend generic Type metadata schema to match Member Type needs.
	 *
	 * @since 7.0.0
	 *
	 * @param array  $schema   The generic Type metadata schema.
	 * @param string $taxonomy The taxonomy name the schema applies to.
	 * @return array           The Member Type metadata schema.
	 */
	function bp_get_member_type_metadata_schema($schema = array(), $taxonomy = '')
	{
	}
	/**
	 * Registers the Member type metadata.
	 *
	 * @since 7.0.0
	 */
	function bp_register_member_type_metadata()
	{
	}
	/**
	 * Register a member type.
	 *
	 * @since 2.2.0
	 *
	 * @param string $member_type Unique string identifier for the member type.
	 * @param array  $args {
	 *     Array of arguments describing the member type.
	 *
	 *     @type array       $labels {
	 *         Array of labels to use in various parts of the interface.
	 *
	 *         @type string $name          Default name. Should typically be plural.
	 *         @type string $singular_name Singular name.
	 *     }
	 *     @type bool|string $has_directory Whether the member type should have its own type-specific directory.
	 *                                      Pass `true` to use the `$member_type` string as the type's slug.
	 *                                      Pass a string to customize the slug. Pass `false` to disable.
	 *                                      Default: true.
	 *     @type bool        $show_in_list  Whether this member type should be shown in lists rendered by
	 *                                      bp_member_type_list(). Default: false.
	 *     @type bool        $code          Whether this member type is registered using code. Default: true.
	 *     @type int         $db_id         The member type term ID. Default: 0.
	 * }
	 * @return object|WP_Error Member type object on success, WP_Error object on failure.
	 */
	function bp_register_member_type($member_type, $args = array())
	{
	}
	/**
	 * Retrieve a member type object by name.
	 *
	 * @since 2.2.0
	 *
	 * @param string $member_type The name of the member type.
	 * @return object|null A member type object or null if it doesn't exist.
	 */
	function bp_get_member_type_object($member_type)
	{
	}
	/**
	 * Get a list of all registered member type objects.
	 *
	 * @since 2.2.0
	 *
	 * @see bp_register_member_type() for accepted arguments.
	 *
	 * @param array|string $args     Optional. An array of key => value arguments to match against
	 *                               the member type objects. Default empty array.
	 * @param string       $output   Optional. The type of output to return. Accepts 'names'
	 *                               or 'objects'. Default 'names'.
	 * @param string       $operator Optional. The logical operation to perform. 'or' means only one
	 *                               element from the array needs to match; 'and' means all elements
	 *                               must match. Accepts 'or' or 'and'. Default 'and'.
	 * @return array A list of member type names or objects.
	 */
	function bp_get_member_types($args = array(), $output = 'names', $operator = 'and')
	{
	}
	/**
	 * Only gets the member types registered by code.
	 *
	 * @since 7.0.0
	 *
	 * @return array The member types registered by code.
	 */
	function bp_get_member_types_registered_by_code()
	{
	}
	/**
	 * Generates missing metadata for a type registered by code.
	 *
	 * @since 7.0.0
	 *
	 * @return array The member type metadata.
	 */
	function bp_set_registered_by_code_member_type_metadata($metadata = array(), $type = '')
	{
	}
	/**
	 * Insert member types registered by code not yet saved into the database as WP Terms.
	 *
	 * @since 7.0.0
	 */
	function bp_insert_member_types_registered_by_code()
	{
	}
	/**
	 * Set type for a member.
	 *
	 * @since 2.2.0
	 * @since 7.0.0 $member_type parameter also accepts an array of member type names.
	 *
	 * @param int          $user_id     ID of the user.
	 * @param string|array $member_type The member type name or an array of member type names.
	 * @param bool         $append      Optional. True to append this to existing types for user,
	 *                                  false to replace. Default: false.
	 * @return bool|array $retval See {@see bp_set_object_terms()}.
	 */
	function bp_set_member_type($user_id, $member_type, $append = \false)
	{
	}
	/**
	 * Remove type for a member.
	 *
	 * @since 2.3.0
	 *
	 * @param int    $user_id     ID of the user.
	 * @param string $member_type Member Type.
	 * @return bool|WP_Error
	 */
	function bp_remove_member_type($user_id, $member_type)
	{
	}
	/**
	 * Get type for a member.
	 *
	 * @since 2.2.0
	 * @since 7.0.0 Adds the `$use_db` parameter.
	 *
	 * @param int  $user_id ID of the user.
	 * @param bool $single  Optional. Whether to return a single type string. If multiple types are found
	 *                      for the user, the oldest one will be returned. Default: true.
	 * @param bool $use_db  Optional. Whether to request all member types or only the ones registered by code.
	 *                      Default: true.
	 * @return string|array|bool On success, returns a single member type (if $single is true) or an array of member
	 *                           types (if $single is false). Returns false on failure.
	 */
	function bp_get_member_type($user_id, $single = \true, $use_db = \true)
	{
	}
	/**
	 * Check whether the given user has a certain member type.
	 *
	 * @since 2.3.0
	 *
	 * @param int    $user_id     $user_id ID of the user.
	 * @param string $member_type Member Type.
	 * @return bool Whether the user has the given member type.
	 */
	function bp_has_member_type($user_id, $member_type)
	{
	}
	/**
	 * Delete a user's member type when the user when the user is deleted.
	 *
	 * @since 2.2.0
	 *
	 * @param int $user_id ID of the user.
	 * @return bool|array $value See {@see bp_set_member_type()}.
	 */
	function bp_remove_member_type_on_user_delete($user_id)
	{
	}
	/**
	 * Deletes user member type on the 'delete_user' hook.
	 *
	 * @since 6.0.0
	 *
	 * @param int $user_id The ID of the deleted user.
	 */
	function bp_remove_member_type_on_delete_user($user_id)
	{
	}
	/**
	 * Get the "current" member type, if one is provided, in member directories.
	 *
	 * @since 2.3.0
	 *
	 * @return string
	 */
	function bp_get_current_member_type()
	{
	}
	/**
	 * Setup the avatar upload directory for a user.
	 *
	 * @since 6.0.0
	 *
	 * @param string $directory The root directory name. Optional.
	 * @param int    $user_id   The user ID. Optional.
	 * @return array Array containing the path, URL, and other helpful settings.
	 */
	function bp_members_avatar_upload_dir($directory = 'avatars', $user_id = 0)
	{
	}
	/**
	 * Send welcome email on successful user activation.
	 *
	 * @since 8.0.0
	 *
	 * @param int $user_id The new user's ID.
	 */
	function bp_send_welcome_email($user_id = 0)
	{
	}
	/**
	 * Get invitations to the BP community filtered by arguments.
	 *
	 * @since 8.0.0
	 *
	 * @param array $args Invitation arguments. See BP_Invitation::get() for list.
	 * @return array $invites Matching BP_Invitation objects.
	 */
	function bp_members_invitations_get_invites($args = array())
	{
	}
	/**
	 * Check whether a user has sent any community invitations.
	 *
	 * @since 8.0.0
	 *
	 * @param int $user_id ID of user to check for invitations sent by.
	 *                     Defaults to the current user's ID.
	 *
	 * @return bool $invites True if user has sent invites.
	 */
	function bp_members_invitations_user_has_sent_invites($user_id = 0)
	{
	}
	/**
	 * Invite a user to a BP community.
	 *
	 * @since 8.0.0
	 *
	 * @param array|string $args {
	 *     Array of arguments.
	 *     @type int    $invitee_email Email address of the user being invited.
	 *     @type int    $network_id    ID of the network to which the user is being invited.
	 *     @type int    $inviter_id    Optional. ID of the inviting user. Default:
	 *                                 ID of the logged-in user.
	 *     @type string $date_modified Optional. Modified date for the invitation.
	 *                                 Default: current date/time.
	 *     @type string $content       Optional. Message to invitee.
	 *     @type bool   $send_invite   Optional. Whether the invitation should be
	 *                                 sent now. Default: false.
	 * }
	 * @return bool
	 */
	function bp_members_invitations_invite_user($args = array())
	{
	}
	/**
	 * Resend a membership invitation email by id.
	 *
	 * @since 8.0.0
	 *
	 * @param int $id ID of the invitation to resend.
	 * @return bool
	 */
	function bp_members_invitation_resend_by_id($id = 0)
	{
	}
	/**
	 * Delete a membership invitation by id.
	 *
	 * @since 8.0.0
	 *
	 * @param int $id ID of the invitation to delete.
	 * @return int|bool Number of rows deleted on success, false on failure.
	 */
	function bp_members_invitations_delete_by_id($id = 0)
	{
	}
	/**
	 * Delete a membership invitation.
	 *
	 * @since 8.0.0
	 *
	 * @param intring $args {
	 *     Array of arguments.
	 *     @type int|array $id            Id(s) of the invitation(s) to remove.
	 *     @type int       $invitee_email Email address of the user being invited.
	 *     @type int       $network_id    ID of the network to which the user is being invited.
	 *     @type int       $inviter_id    ID of the inviting user.
	 *     @type int       $accepted      Whether the invitation has been accepted yet.
	 *     @type int       $invite_sent   Whether the invitation has been sent yet.
	 * }
	 * @return bool True if all were deleted.
	 */
	function bp_members_invitations_delete_invites($args = array())
	{
	}
	/**
	 * Get hash based on details of a membership invitation and the inviter.
	 *
	 * @since 8.0.0
	 *
	 * @param BP_Invitation $invitation Invitation to create hash from.
	 *
	 * @return string $hash Calculated sha1 hash.
	 */
	function bp_members_invitations_get_hash($invitation)
	{
	}
	/**
	 * Get the current invitation specified by the $_GET parameters.
	 *
	 * @since 8.0.0
	 *
	 * @return BP_Invitation $invite Invitation specified by the $_GET parameters.
	 */
	function bp_get_members_invitation_from_request()
	{
	}
	/**
	 * Get WP_User object corresponding to a record in the signups table.
	 *
	 * @since 10.0.0
	 *
	 * @param string $field Which fields to search by. Possible values are
	 *                      activation_key, user_email, id.
	 * @param string $value Value to search by.
	 * @return bool|BP_Signup $signup Found signup, returns first found
	 *                                if more than one is found.
	 */
	function bp_members_get_signup_by($field = 'activation_key', $value = '')
	{
	}
	/**
	 * Are site creation requests currently enabled?
	 *
	 * @since 10.0.0
	 *
	 * @return bool Whether site requests are currently enabled.
	 */
	function bp_members_site_requests_enabled()
	{
	}
	/**
	 * Returns the strength score a password needs to have to be used by a member.
	 *
	 * Score => Allowed Strength.
	 * 0     => any passwords.
	 * 1     => at least short passwords.
	 * 2     => at least weak passwords.
	 * 3     => at least good passwords.
	 * 4     => at least strong passwords.
	 *
	 * @since 10.0.0
	 *
	 * @return int the strength score a password needs to have to be used by a member.
	 */
	function bp_members_user_pass_required_strength()
	{
	}
	/**
	 * Is the Admin User's community profile enabled?
	 *
	 * @since 10.0.0
	 *
	 * @return bool True if enabled. False otherwise.
	 */
	function bp_members_is_community_profile_enabled()
	{
	}
	/**
	 * Create Users submenu to manage BuddyPress types.
	 *
	 * @since 7.0.0
	 */
	function bp_members_type_admin_menu()
	{
	}
	/**
	 * Checks whether a member type already exists.
	 *
	 * @since 7.0.0
	 *
	 * @param  boolean $exists  True if the member type already exists. False otherwise.
	 * @param  string  $type_id The member type identifier.
	 * @return bool True if the member type already exists. False otherwise.
	 */
	function bp_members_type_admin_type_exists($exists = \false, $type_id = '')
	{
	}
	/**
	 * Set the feedback messages for the Member Types Admin actions.
	 *
	 * @since 7.0.0
	 *
	 * @param array $messages The feedback messages.
	 * @return array The feedback messages including the ones for the Member Types Admin actions.
	 */
	function bp_members_type_admin_updated_messages($messages = array())
	{
	}
	/**
	 * Formats xprofile field data about a signup/membership request for display.
	 *
	 * Operates recursively on arrays, which are then imploded with commas.
	 *
	 * @since 10.0.0
	 *
	 * @param string|array $value Field value.
	 */
	function bp_members_admin_format_xprofile_field_for_display($value)
	{
	}
	/**
	 * Outputs Informations about a signup/membership request into a modal inside the Signups Admin Screen.
	 *
	 * @since 10.0.0
	 *
	 * @param array $signup_field_labels The Signup field labels.
	 * @param object|null $signup_object The signup data object.
	 */
	function bp_members_admin_preview_signup_profile_info($signup_field_labels = array(), $signup_object = \null)
	{
	}
	/**
	 * Member Invitations: Bulk-manage action handler
	 *
	 * @package BuddyPress
	 * @subpackage MembersActions
	 * @since 8.0.0
	 */
	/**
	 * Handles bulk management (resend, cancellation) of invitations.
	 *
	 * @since 8.0.0
	 *
	 * @return bool
	 */
	function bp_members_invitations_action_bulk_manage()
	{
	}
	/**
	 * Members: Random member action handler
	 *
	 * @package BuddyPress
	 * @subpackage MembersActions
	 * @since 3.0.0
	 */
	/**
	 * Redirect to a random member page when visiting a ?random-member URL.
	 *
	 * @since 1.0.0
	 */
	function bp_core_get_random_member()
	{
	}
	/**
	 * Members: Avatar deletion action handler
	 *
	 * @package BuddyPress
	 * @subpackage MembersActions
	 * @since 6.0.0
	 */
	/**
	 * This function runs when an action is set for a screen:
	 * example.com/members/andy/profile/change-avatar/ [delete-avatar]
	 *
	 * The function will delete the active avatar for a user.
	 *
	 * @since 6.0.0
	 */
	function bp_members_action_delete_avatar()
	{
	}
	/**
	 * Set up the bp-members component.
	 *
	 * @since 1.6.0
	 */
	function bp_setup_members()
	{
	}
	/**
	 * Set up the bp-members-invitations component.
	 *
	 * @since 12.0.0
	 */
	function bp_setup_members_invitations()
	{
	}
	/**
	 * Callback function to render the BP Member Block.
	 *
	 * @since 6.0.0
	 *
	 * @param array $attributes The block attributes.
	 * @return string           HTML output.
	 */
	function bp_members_render_member_block($attributes = array())
	{
	}
	/**
	 * Callback function to render the BP Members Block.
	 *
	 * @since 7.0.0
	 *
	 * @param array $attributes The block attributes.
	 * @return string           HTML output.
	 */
	function bp_members_render_members_block($attributes = array())
	{
	}
	/**
	 * Adds specific script data for the BP Members blocks.
	 *
	 * Only used for the BP Dynamic Members block.
	 *
	 * @since 9.0.0
	 */
	function bp_members_blocks_add_script_data()
	{
	}
	/**
	 * Callback function to render the Dynamic Members Block.
	 *
	 * @since 9.0.0
	 *
	 * @param array $attributes The block attributes.
	 * @return string           HTML output.
	 */
	function bp_members_render_dynamic_members_block($attributes = array())
	{
	}
	/**
	 * Common function to render the Recently Active & Online Members Blocks.
	 *
	 * @since 9.0.0
	 *
	 * @param array $block_args {
	 *    Optional. An array of Block arguments.
	 *
	 *    @type string $title      The title of the Block.
	 *    @type int    $maxMembers The maximum number of members to show. Defaults to `0`.
	 *    @type string $noMembers  The string to output when there are no members to show.
	 *    @type string $classname  The name of the CSS class to use.
	 *    @type string $type       The type of filter to perform. Possible values are `online`, `active`,
	 *                             `newest`, `alphabetical`, `random` or `popular`.
	 * }
	 * @return string HTML output.
	 */
	function bp_members_render_members_avatars_block($block_args = array())
	{
	}
	/**
	 * Callback function to render the Online Members Block.
	 *
	 * @since 9.0.0
	 *
	 * @param array $attributes The block attributes.
	 * @return string           HTML output.
	 */
	function bp_members_render_online_members_block($attributes = array())
	{
	}
	/**
	 * Callback function to render the Recently Active Members Block.
	 *
	 * @since 9.0.0
	 *
	 * @param array $attributes The block attributes.
	 * @return string           HTML output.
	 */
	function bp_members_render_active_members_block($attributes = array())
	{
	}
	/**
	 * Register the 'new member' activity type.
	 *
	 * @since 2.2.0
	 */
	function bp_members_register_activity_actions()
	{
	}
	/**
	 * Format 'new_member' activity actions.
	 *
	 * @since 2.2.0
	 *
	 * @param string $action   Static activity action.
	 * @param object $activity Activity object.
	 * @return string $action
	 */
	function bp_members_format_activity_action_new_member($action, $activity)
	{
	}
	/**
	 * Format 'new_avatar' activity actions.
	 *
	 * @since 8.0.0
	 *
	 * @param string $action   Static activity action.
	 * @param object $activity Activity object.
	 * @return string
	 */
	function bp_members_format_activity_action_new_avatar($action, $activity)
	{
	}
	/**
	 * Create a "became a registered user" activity item when a user activates his account.
	 *
	 * @since 1.2.2
	 *
	 * @param array $user Array of userdata passed to bp_core_activated_user hook.
	 * @return bool
	 */
	function bp_core_new_user_activity($user)
	{
	}
	/**
	 * Adds an activity stream item when a user has uploaded a new avatar.
	 *
	 * @since 8.0.0
	 * @since 10.0.0 Adds the `$type`, `$crop_data` and `$cropped_avatar` parameters.
	 *
	 * @param int    $user_id        The user id the avatar was set for.
	 * @param string $type           The way the avatar was set ('camera' or `crop`).
	 * @param array  $crop_data      Array of parameters passed to the crop handler.
	 * @param array  $cropped_avatar Array containing the full, thumb avatar and the timestamp.
	 */
	function bp_members_new_avatar_activity($user_id = 0, $type = '', $crop_data = array(), $cropped_avatar = array())
	{
	}
	/**
	 * Remove the `new_avatar` activity corresponding to the deleted previous avatar.
	 *
	 * @since 10.0.0
	 *
	 * @param int $user_id   The user ID.
	 * @param int $timestamp The timestamp when the activity was created.
	 * @return bool False otherwise.
	 */
	function bp_members_remove_previous_avatar_activity($user_id = 0, $timestamp = 0)
	{
	}
	/**
	 * Output the profile component slug.
	 *
	 * @since 2.4.0
	 */
	function bp_profile_slug()
	{
	}
	/**
	 * Return the profile component slug.
	 *
	 * @since 2.4.0
	 *
	 * @return string
	 */
	function bp_get_profile_slug()
	{
	}
	/**
	 * Output the members component slug.
	 *
	 * @since 1.5.0
	 */
	function bp_members_slug()
	{
	}
	/**
	 * Return the members component slug.
	 *
	 * @since 1.5.0
	 *
	 * @return string
	 */
	function bp_get_members_slug()
	{
	}
	/**
	 * Output the members component root slug.
	 *
	 * @since 1.5.0
	 */
	function bp_members_root_slug()
	{
	}
	/**
	 * Return the members component root slug.
	 *
	 * @since 1.5.0
	 *
	 * @return string
	 */
	function bp_get_members_root_slug()
	{
	}
	/**
	 * Output the member type base slug.
	 *
	 * @since 2.5.0
	 */
	function bp_members_member_type_base()
	{
	}
	/**
	 * Get the member type URL base.
	 *
	 * The base slug is the string used as the base prefix when generating member type directory URLs.
	 * For example, in example.com/members/type/foo/, 'foo' is the member type and 'type' is the
	 * base slug.
	 *
	 * @since 2.5.0
	 *
	 * @return string
	 */
	function bp_get_members_member_type_base()
	{
	}
	/**
	 * Output member directory permalink.
	 *
	 * @since 1.5.0
	 */
	function bp_members_directory_permalink()
	{
	}
	/**
	 * Return member directory permalink.
	 *
	 * @since 1.5.0
	 *
	 * @return string
	 */
	function bp_get_members_directory_permalink()
	{
	}
	/**
	 * Output member type directory permalink.
	 *
	 * @since 2.5.0
	 *
	 * @param string $member_type Optional. Member type. Defaults to current member type.
	 */
	function bp_member_type_directory_permalink($member_type = '')
	{
	}
	/**
	 * Return member type directory permalink.
	 *
	 * @since 2.5.0
	 *
	 * @param string $member_type Optional. Member type. Defaults to current member type.
	 * @return string Member type directory URL on success, an empty string on failure.
	 */
	function bp_get_member_type_directory_permalink($member_type = '')
	{
	}
	/**
	 * Output the sign-up slug.
	 *
	 * @since 1.5.0
	 */
	function bp_signup_slug()
	{
	}
	/**
	 * Return the sign-up slug.
	 *
	 * @since 1.5.0
	 *
	 * @return string
	 */
	function bp_get_signup_slug()
	{
	}
	/**
	 * Output the activation slug.
	 *
	 * @since 1.5.0
	 */
	function bp_activate_slug()
	{
	}
	/**
	 * Return the activation slug.
	 *
	 * @since 1.5.0
	 *
	 * @return string
	 */
	function bp_get_activate_slug()
	{
	}
	/**
	 * Output the members invitation pane slug.
	 *
	 * @since 8.0.0
	 */
	function bp_members_invitations_slug()
	{
	}
	/**
	 * Return the members invitations root slug.
	 *
	 * @since 8.0.0
	 *
	 * @return string
	 */
	function bp_get_members_invitations_slug()
	{
	}
	/**
	 * Initialize the members loop.
	 *
	 * Based on the $args passed, bp_has_members() populates the $members_template
	 * global, enabling the use of BuddyPress templates and template functions to
	 * display a list of members.
	 *
	 * @since 1.2.0
	 * @since 7.0.0 Added `xprofile_query` parameter. Added `user_ids` parameter.
	 * @since 10.0.0 Added `date_query` parameter.
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @param array|string $args {
	 *     Arguments for limiting the contents of the members loop. Most arguments
	 *     are in the same format as {@link BP_User_Query}. However, because
	 *     the format of the arguments accepted here differs in a number of ways,
	 *     and because bp_has_members() determines some default arguments in a
	 *     dynamic fashion, we list all accepted arguments here as well.
	 *
	 *     Arguments can be passed as an associative array, or as a URL query
	 *     string (eg, 'user_id=4&per_page=3').
	 *
	 *     @type int                   $type                Sort order. Accepts 'active', 'random', 'newest', 'popular',
	 *                                                      'online', 'alphabetical'. Default: 'active'.
	 *     @type int|bool              $page                Page of results to display. Default: 1.
	 *     @type int|bool              $per_page            Number of results per page. Default: 20.
	 *     @type int|bool              $max                 Maximum number of results to return. Default: false (unlimited).
	 *     @type string                $page_arg            The string used as a query parameter in pagination links.
	 *                                                      Default: 'bpage'.
	 *     @type array|int|string|bool $include             Limit results by a list of user IDs. Accepts an array, a
	 *                                                      single integer, a comma-separated list of IDs, or false (to
	 *                                                      disable this limiting). Accepts 'active', 'alphabetical',
	 *                                                      'newest', or 'random'. Default: false.
	 *     @type array|int|string|bool $exclude             Exclude users from results by ID. Accepts an array, a single
	 *                                                      integer, a comma-separated list of IDs, or false (to disable
	 *                                                      this limiting). Default: false.
	 *     @type array|string|bool     $user_ids            An array or comma-separated list of IDs, or false (to
	 *                                                      disable this limiting). Default: false.
	 *     @type int                   $user_id             If provided, results are limited to the friends of the specified
	 *                                                      user. When on a user's Friends page, defaults to the ID of the
	 *                                                      displayed user. Otherwise defaults to 0.
	 *     @type string|array          $member_type         Array or comma-separated list of member types to limit
	 *                                                      results to.
	 *     @type string|array          $member_type__in     Array or comma-separated list of member types to limit
	 *                                                      results to.
	 *     @type string|array          $member_type__not_in Array or comma-separated list of member types to exclude
	 *                                                      from results.
	 *     @type string                $search_terms        Limit results by a search term. Default: value of
	 *                                                      `$_REQUEST['members_search']` or `$_REQUEST['s']`, if present.
	 *                                                      Otherwise false.
	 *     @type string                $meta_key            Limit results by the presence of a usermeta key.
	 *                                                      Default: false.
	 *     @type mixed                 $meta_value          When used with meta_key, limits results by the a matching
	 *                                                      usermeta value. Default: false.
	 *     @type array                 $xprofile_query      Filter results by xprofile data. Requires the xprofile
	 *                                                      component. See {@see BP_XProfile_Query} for details.
	 *     @type array                 $date_query          Filter results by member last activity date. See first parameter of
	 *                                                      {@link WP_Date_Query::__construct()} for syntax. Only applicable if
	 *                                                      $type is either 'active', 'random', 'newest', or 'online'.
	 *     @type bool                  $populate_extras     Whether to fetch optional data, such as friend counts.
	 *                                                      Default: true.
	 * }
	 * @return bool Returns true when blogs are found, otherwise false.
	 */
	function bp_has_members($args = '')
	{
	}
	/**
	 * Set up the current member inside the loop.
	 *
	 * @since 1.2.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return object
	 */
	function bp_the_member()
	{
	}
	/**
	 * Check whether there are more members to iterate over.
	 *
	 * @since 1.2.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return bool
	 */
	function bp_members()
	{
	}
	/**
	 * Output the members pagination count.
	 *
	 * @since 1.2.0
	 */
	function bp_members_pagination_count()
	{
	}
	/**
	 * Generate the members pagination count.
	 *
	 * @since 1.5.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return string
	 */
	function bp_get_members_pagination_count()
	{
	}
	/**
	 * Output the members pagination links.
	 *
	 * @since 1.2.0
	 */
	function bp_members_pagination_links()
	{
	}
	/**
	 * Fetch the members pagination links.
	 *
	 * @since 1.2.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return string
	 */
	function bp_get_members_pagination_links()
	{
	}
	/**
	 * Output the ID of the current member in the loop.
	 *
	 * @since 1.2.0
	 */
	function bp_member_user_id()
	{
	}
	/**
	 * Get the ID of the current member in the loop.
	 *
	 * @since 1.2.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return int Member ID.
	 */
	function bp_get_member_user_id()
	{
	}
	/**
	 * Output the row class of the current member in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @param array $classes Array of custom classes.
	 */
	function bp_member_class($classes = array())
	{
	}
	/**
	 * Return the row class of the current member in the loop.
	 *
	 * @since 1.7.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @param array $classes Array of custom classes.
	 *
	 * @return string Row class of the member
	 */
	function bp_get_member_class($classes = array())
	{
	}
	/**
	 * Output nicename of current member in the loop.
	 *
	 * @since 1.2.5
	 */
	function bp_member_user_nicename()
	{
	}
	/**
	 * Get the nicename of the current member in the loop.
	 *
	 * @since 1.2.5
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return string Members nicename.
	 */
	function bp_get_member_user_nicename()
	{
	}
	/**
	 * Output login for current member in the loop.
	 *
	 * @since 1.2.5
	 */
	function bp_member_user_login()
	{
	}
	/**
	 * Get the login of the current member in the loop.
	 *
	 * @since 1.2.5
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return string Member's login.
	 */
	function bp_get_member_user_login()
	{
	}
	/**
	 * Output the email address for the current member in the loop.
	 *
	 * @since 1.2.5
	 */
	function bp_member_user_email()
	{
	}
	/**
	 * Get the email address of the current member in the loop.
	 *
	 * @since 1.2.5
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return string Member's email address.
	 */
	function bp_get_member_user_email()
	{
	}
	/**
	 * Check whether the current member in the loop is the logged-in user.
	 *
	 * @since 1.2.5
	 * @since 10.0.0 Updated to get member ID from `bp_get_member_user_id`.
	 *
	 * @return bool
	 */
	function bp_member_is_loggedin_user()
	{
	}
	/**
	 * Output a member's avatar.
	 *
	 * @since 1.2.0
	 *
	 * @see bp_get_member_avatar() for description of arguments.
	 *
	 * @param array|string $args See {@link bp_get_member_avatar()}.
	 */
	function bp_member_avatar($args = '')
	{
	}
	/**
	 * Get a member's avatar.
	 *
	 * @since 1.2.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @see bp_core_fetch_avatar() For a description of arguments and
	 *      return values.
	 *
	 * @param array|string $args  {
	 *     Arguments are listed here with an explanation of their defaults.
	 *     For more information about the arguments, see
	 *     {@link bp_core_fetch_avatar()}.
	 *     @type string   $alt     Default: 'Profile picture of [user name]'.
	 *     @type string   $class   Default: 'avatar'.
	 *     @type string   $type    Default: 'thumb'.
	 *     @type int|bool $width   Default: false.
	 *     @type int|bool $height  Default: false.
	 *     @type bool     $no_grav Default: false.
	 *     @type bool     $id      Currently unused.
	 * }
	 * @return string User avatar string.
	 */
	function bp_get_member_avatar($args = '')
	{
	}
	/**
	 * Output the permalink for the current member in the loop.
	 *
	 * @since 1.2.0
	 */
	function bp_member_permalink()
	{
	}
	/**
	 * Get the permalink for the current member in the loop.
	 *
	 * @since 1.2.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return string
	 */
	function bp_get_member_permalink()
	{
	}
	/**
	 * Alias of {@link bp_member_permalink()}.
	 *
	 * @since 1.2.0
	 */
	function bp_member_link()
	{
	}
	/**
	 * Alias of {@link bp_get_member_permalink()}.
	 *
	 * @since 1.2.0
	 */
	function bp_get_member_link()
	{
	}
	/**
	 * Output display name of current member in the loop.
	 *
	 * @since 1.2.0
	 */
	function bp_member_name()
	{
	}
	/**
	 * Get the display name of the current member in the loop.
	 *
	 * Full name is, by default, pulled from xprofile's Full Name field.
	 * When this field is empty, we try to get an alternative name from the
	 * WP users table, in the following order of preference: display_name,
	 * user_nicename, user_login.
	 *
	 * @since 1.2.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @return string The user's fullname for display.
	 */
	function bp_get_member_name()
	{
	}
	/**
	 * Output the current member's last active time.
	 *
	 * @since 1.2.0
	 *
	 * @param array $args {@see bp_get_member_last_active()}.
	 */
	function bp_member_last_active($args = array())
	{
	}
	/**
	 * Return the current member's last active time.
	 *
	 * @since 1.2.0
	 * @since 2.7.0 Added 'relative' as a parameter to $args.
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @param array $args {
	 *     Array of optional arguments.
	 *     @type mixed $active_format If true, formatted "active 5 minutes ago". If false, formatted "5 minutes
	 *                                ago". If string, should be sprintf'able like 'last seen %s ago'.
	 *     @type bool  $relative      If true, will return relative time "5 minutes ago". If false, will return
	 *                                date from database. Default: true.
	 * }
	 * @return string
	 */
	function bp_get_member_last_active($args = array())
	{
	}
	/**
	 * Output the latest update of the current member in the loop.
	 *
	 * @since 1.2.0
	 *
	 * @param array|string $args {@see bp_get_member_latest_update()}.
	 */
	function bp_member_latest_update($args = '')
	{
	}
	/**
	 * Get the latest update from the current member in the loop.
	 *
	 * @since 1.2.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @param array|string $args {
	 *     Array of optional arguments.
	 *     @type int  $length    Truncation length. Default: 225.
	 *     @type bool $view_link Whether to provide a 'View' link for
	 *                           truncated entries. Default: false.
	 * }
	 * @return string
	 */
	function bp_get_member_latest_update($args = '')
	{
	}
	/**
	 * Output a piece of user profile data.
	 *
	 * @since 1.2.0
	 *
	 * @see bp_get_member_profile_data() for a description of params.
	 *
	 * @param array|string $args See {@link bp_get_member_profile_data()}.
	 */
	function bp_member_profile_data($args = '')
	{
	}
	/**
	 * Get a piece of user profile data.
	 *
	 * When used in a bp_has_members() loop, this function will attempt
	 * to fetch profile data cached in the template global. It is also safe
	 * to use outside of the loop.
	 *
	 * @since 1.2.0
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @param array|string $args {
	 *     Array of config parameters.
	 *     @type string $field   Name of the profile field.
	 *     @type int    $user_id ID of the user whose data is being fetched.
	 *                           Defaults to the current member in the loop, or if not
	 *                           present, to the currently displayed user.
	 * }
	 * @return string|bool Profile data if found, otherwise false.
	 */
	function bp_get_member_profile_data($args = '')
	{
	}
	/**
	 * Output the 'registered [x days ago]' string for the current member.
	 *
	 * @since 1.2.0
	 * @since 2.7.0 Added $args as a parameter.
	 *
	 * @param array $args Optional. {@see bp_get_member_registered()}.
	 */
	function bp_member_registered($args = array())
	{
	}
	/**
	 * Get the 'registered [x days ago]' string for the current member.
	 *
	 * @since 1.2.0
	 * @since 2.7.0 Added `$args` as a parameter.
	 *
	 * @global BP_Core_Members_Template $members_template The main member template loop class.
	 *
	 * @param array $args {
	 *     Array of optional parameters.
	 *     @type bool $relative Optional. If true, returns relative registered date. eg. registered 5 months ago.
	 *                          If false, returns registered date value from database.
	 * }
	 * @return string
	 */
	function bp_get_member_registered($args = array())
	{
	}
	/**
	 * Output a random piece of profile data for the current member in the loop.
	 *
	 * @since 1.2.0
	 * @since 10.0.0 Updated to get member ID using `bp_get_member_user_id`.
	 */
	function bp_member_random_profile_data()
	{
	}
	/**
	 * Output hidden input for preserving member search params on form submit.
	 *
	 * @since 1.2.0
	 */
	function bp_member_hidden_fields()
	{
	}
	/**
	 * Output the Members directory search form.
	 *
	 * @since 1.0.0
	 */
	function bp_directory_members_search_form()
	{
	}
	/**
	 * Output the total member count.
	 *
	 * @since 1.2.0
	 */
	function bp_total_site_member_count()
	{
	}
	/**
	 * Get the total site member count.
	 *
	 * @since 1.2.0
	 *
	 * @return string
	 */
	function bp_get_total_site_member_count()
	{
	}
	/** Navigation and other misc template tags ***********************************/
	/**
	 * Render the navigation markup for the logged-in user.
	 *
	 * Each component adds to this navigation array within its own
	 * [component_name]setup_nav() function.
	 *
	 * This navigation array is the top level navigation, so it contains items such as:
	 *      [Blog, Profile, Messages, Groups, Friends] ...
	 *
	 * The function will also analyze the current component the user is in, to
	 * determine whether or not to highlight a particular nav item.
	 *
	 * @since 1.1.0
	 *
	 * @todo Move to a back-compat file?
	 * @deprecated Does not seem to be called anywhere in BP core.
	 */
	function bp_get_loggedin_user_nav()
	{
	}
	/**
	 * Output the contents of the current user's home page.
	 *
	 * @since 2.6.0
	 */
	function bp_displayed_user_front_template_part()
	{
	}
	/**
	 * Locate a custom user front template if it exists.
	 *
	 * @since 2.6.0
	 *
	 * @param  object|null $displayed_user Optional. Falls back to current user if not passed.
	 * @return string|bool                 Path to front template on success; boolean false on failure.
	 */
	function bp_displayed_user_get_front_template($displayed_user = \null)
	{
	}
	/**
	 * Check if the displayed user has a custom front template.
	 *
	 * @since 2.6.0
	 */
	function bp_displayed_user_has_front_template()
	{
	}
	/**
	 * Render the navigation markup for the displayed user.
	 *
	 * @since 1.1.0
	 */
	function bp_get_displayed_user_nav()
	{
	}
	/** Cover image ***************************************************************/
	/**
	 * Should we use the cover image header
	 *
	 * @since 2.4.0
	 *
	 * @return bool True if the displayed user has a cover image,
	 *              False otherwise
	 */
	function bp_displayed_user_use_cover_image_header()
	{
	}
	/** Avatars *******************************************************************/
	/**
	 * Output the logged-in user's avatar.
	 *
	 * @since 1.1.0
	 *
	 * @see bp_get_loggedin_user_avatar() for a description of params.
	 *
	 * @param array|string $args {@see bp_get_loggedin_user_avatar()}.
	 */
	function bp_loggedin_user_avatar($args = '')
	{
	}
	/**
	 * Get the logged-in user's avatar.
	 *
	 * @since 1.1.0
	 *
	 * @see bp_core_fetch_avatar() For a description of arguments and
	 *      return values.
	 *
	 * @param array|string $args  {
	 *     Arguments are listed here with an explanation of their defaults.
	 *     For more information about the arguments, see
	 *     {@link bp_core_fetch_avatar()}.
	 *     @type string   $alt    Default: 'Profile picture of [user name]'.
	 *     @type bool     $html   Default: true.
	 *     @type string   $type   Default: 'thumb'.
	 *     @type int|bool $width  Default: false.
	 *     @type int|bool $height Default: false.
	 * }
	 * @return string User avatar string.
	 */
	function bp_get_loggedin_user_avatar($args = '')
	{
	}
	/**
	 * Output the displayed user's avatar.
	 *
	 * @since 1.1.0
	 *
	 * @see bp_get_displayed_user_avatar() for a description of params.
	 *
	 * @param array|string $args {@see bp_get_displayed_user_avatar()}.
	 */
	function bp_displayed_user_avatar($args = '')
	{
	}
	/**
	 * Get the displayed user's avatar.
	 *
	 * @since 1.1.0
	 *
	 * @see bp_core_fetch_avatar() For a description of arguments and
	 *      return values.
	 *
	 * @param array|string $args  {
	 *     Arguments are listed here with an explanation of their defaults.
	 *     For more information about the arguments, see
	 *     {@link bp_core_fetch_avatar()}.
	 *     @type string   $alt    Default: 'Profile picture of [user name]'.
	 *     @type bool     $html   Default: true.
	 *     @type string   $type   Default: 'thumb'.
	 *     @type int|bool $width  Default: false.
	 *     @type int|bool $height Default: false.
	 * }
	 * @return string User avatar string.
	 */
	function bp_get_displayed_user_avatar($args = '')
	{
	}
	/**
	 * Output the email address of the displayed user.
	 *
	 * @since 1.5.0
	 */
	function bp_displayed_user_email()
	{
	}
	/**
	 * Get the email address of the displayed user.
	 *
	 * @since 1.5.0
	 *
	 * @return string
	 */
	function bp_get_displayed_user_email()
	{
	}
	/**
	 * Output the "active [x days ago]" string for a user.
	 *
	 * @since 1.0.0
	 *
	 * @see bp_get_last_activity() for a description of parameters.
	 *
	 * @param int $user_id See {@link bp_get_last_activity()}.
	 */
	function bp_last_activity($user_id = 0)
	{
	}
	/**
	 * Get the "active [x days ago]" string for a user.
	 *
	 * @since 1.5.0
	 *
	 * @param int $user_id ID of the user. Default: displayed user ID.
	 * @return string
	 */
	function bp_get_last_activity($user_id = 0)
	{
	}
	/**
	 * Output the calculated first name of the displayed or logged-in user.
	 *
	 * @since 1.2.0
	 */
	function bp_user_firstname()
	{
	}
	/**
	 * Output the first name of a user.
	 *
	 * Simply takes all the characters before the first space in a name.
	 *
	 * @since 1.2.0
	 *
	 * @param string|bool $name Full name to use when generating first name.
	 *                          Defaults to displayed user's first name, or to
	 *                          logged-in user's first name if it's unavailable.
	 * @return string
	 */
	function bp_get_user_firstname($name = \false)
	{
	}
	/**
	 * Alias of {@link bp_displayed_user_id()}.
	 *
	 * @since 1.0.0
	 */
	function bp_current_user_id()
	{
	}
	/**
	 * Output the link for the displayed user's profile.
	 *
	 * @since 1.2.4
	 * @since 12.0.0 Introduced the `$chunk` argument.
	 *
	 * @param array $chunk A list of slugs to append to the URL.
	 */
	function bp_displayed_user_link($chunks = array())
	{
	}
	/**
	 * Builds the logged-in user's profile URL.
	 *
	 * @since 12.0.0
	 *
	 * @param array $path_chunks {
	 *     An array of arguments. Optional.
	 *
	 *     @type string $single_item_component        The component slug the action is relative to.
	 *     @type string $single_item_action           The slug of the action to perform.
	 *     @type array  $single_item_action_variables An array of additional informations about the action to perform.
	 * }
	 * @return string The logged-in user's profile URL.
	 */
	function bp_displayed_user_url($path_chunks = array())
	{
	}
	/**
	 * Generate the link for the displayed user's profile.
	 *
	 * @since 1.0.0
	 * @since 12.0.0 This function is now an alias of `bp_displayed_user_url()`.
	 *               You should only use it to get the "home" URL of the displayed
	 *               user's profile page. If you need to build an URL to reach another
	 *               page, we strongly advise you to use `bp_displayed_user_url()`.
	 *
	 * @todo Deprecating this function would be safer.
	 * @return string
	 */
	function bp_displayed_user_domain()
	{
	}
	/**
	 * Output the link for the logged-in user's profile.
	 *
	 * @since 1.2.4
	 * @since 12.0.0 Introduced the `$chunk` argument.
	 *
	 * @param array $chunk A list of slugs to append to the URL.
	 */
	function bp_loggedin_user_link($chunks = array())
	{
	}
	/**
	 * Builds the logged-in user's profile URL.
	 *
	 * @since 12.0.0
	 *
	 * @param array $path_chunks {
	 *     An array of arguments. Optional.
	 *
	 *     @type string $single_item_component        The component slug the action is relative to.
	 *     @type string $single_item_action           The slug of the action to perform.
	 *     @type array  $single_item_action_variables An array of additional informations about the action to perform.
	 * }
	 * @return string The logged-in user's profile URL.
	 */
	function bp_loggedin_user_url($path_chunks = array())
	{
	}
	/**
	 * Generate the link for the logged-in user's profile.
	 *
	 * @since 1.0.0
	 * @since 12.0.0 This function is now an alias of `bp_loggedin_user_url()`.
	 *               You should only use it to get the "home" URL of the logged-in
	 *               user's profile page. If you need to build an URL to reach another
	 *               page, we strongly advise you to use `bp_loggedin_user_url()`.
	 *
	 * @todo Deprecating this function would be safer.
	 * @return string
	 */
	function bp_loggedin_user_domain()
	{
	}
	/**
	 * Output the displayed user's display name.
	 *
	 * @since 1.0.0
	 */
	function bp_displayed_user_fullname()
	{
	}
	/**
	 * Get the displayed user's display name.
	 *
	 * @since 1.2.0
	 *
	 * @return string
	 */
	function bp_get_displayed_user_fullname()
	{
	}
	/**
	 * Alias of {@link bp_get_displayed_user_fullname()}.
	 *
	 * @since 1.0.0
	 */
	function bp_user_fullname()
	{
	}
	/**
	 * Output the logged-in user's display name.
	 *
	 * @since 1.0.0
	 */
	function bp_loggedin_user_fullname()
	{
	}
	/**
	 * Get the logged-in user's display name.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	function bp_get_loggedin_user_fullname()
	{
	}
	/**
	 * Output the username of the displayed user.
	 *
	 * @since 1.2.0
	 */
	function bp_displayed_user_username()
	{
	}
	/**
	 * Get the username of the displayed user.
	 *
	 * @since 1.2.0
	 *
	 * @return string
	 */
	function bp_get_displayed_user_username()
	{
	}
	/**
	 * Output the username of the logged-in user.
	 *
	 * @since 1.2.0
	 */
	function bp_loggedin_user_username()
	{
	}
	/**
	 * Get the username of the logged-in user.
	 *
	 * @since 1.2.0
	 *
	 * @return string
	 */
	function bp_get_loggedin_user_username()
	{
	}
	/**
	 * Echo the current member type message.
	 *
	 * @since 2.3.0
	 */
	function bp_current_member_type_message()
	{
	}
	/**
	 * Generate the current member type message.
	 *
	 * @since 2.3.0
	 *
	 * @return string
	 */
	function bp_get_current_member_type_message()
	{
	}
	/**
	 * Output member type directory link.
	 *
	 * @since 7.0.0
	 *
	 * @param string $member_type Unique member type identifier as used in bp_register_member_type().
	 */
	function bp_member_type_directory_link($member_type = '')
	{
	}
	/**
	 * Return member type directory link.
	 *
	 * @since 7.0.0
	 *
	 * @param string $member_type Unique member type identifier as used in bp_register_member_type().
	 * @return string
	 */
	function bp_get_member_type_directory_link($member_type = '')
	{
	}
	/**
	 * Output a comma-delimited list of member types.
	 *
	 * @since 7.0.0
	 *
	 * @see bp_get_member_type_list() For additional information on default arguments.
	 *
	 * @param int   $user_id User ID.
	 * @param array $r       Optional. Member type list arguments. Default empty array.
	 */
	function bp_member_type_list($user_id = 0, $r = array())
	{
	}
	/**
	 * Return a comma-delimited list of member types.
	 *
	 * @since 7.0.0
	 *
	 * @param int          $user_id User ID. Defaults to displayed user ID if on a member page.
	 * @param array|string $r       {
	 *     Array of parameters. All items are optional.
	 *     @type string $parent_element     Element to wrap around the list. Defaults to 'p'.
	 *     @type array  $parent_attr        Element attributes for parent element. Defaults to
	 *                                      array( 'class' => 'bp-member-type-list' ).
	 *     @type array  $label              Plural and singular labels to use before the list. Defaults to
	 *                                      array( 'plural' => 'Member Types:', 'singular' => 'Member Type:' ).
	 *     @type string $label_element      Element to wrap around the label. Defaults to 'strong'.
	 *     @type array  $label_attr         Element attributes for label element. Defaults to array().
	 *     @type bool   $show_all           Whether to show all registered group types. Defaults to 'false'. If
	 *                                      'false', only shows member types with the 'show_in_list' parameter set to
	 *                                      true. See bp_register_member_type() for more info.
	 *     @type string $list_element       Element to wrap around the comma separated list of membet types. Defaults to ''.
	 *     @type string $list_element_attr  Element attributes for list element. Defaults to array().
	 * }
	 * @return string
	 */
	function bp_get_member_type_list($user_id = 0, $r = array())
	{
	}
	/** Signup Form ***************************************************************/
	/**
	 * Do we have a working custom sign up page?
	 *
	 * @since 1.5.0
	 *
	 * @return bool True if page and template exist, false if not.
	 */
	function bp_has_custom_signup_page()
	{
	}
	/**
	 * Output the URL to the signup page.
	 *
	 * @since 1.0.0
	 */
	function bp_signup_page()
	{
	}
	/**
	 * Get the URL to the signup page.
	 *
	 * @since 1.1.0
	 *
	 * @return string
	 */
	function bp_get_signup_page()
	{
	}
	/**
	 * Do we have a working custom activation page?
	 *
	 * @since 1.5.0
	 *
	 * @return bool True if page and template exist, false if not.
	 */
	function bp_has_custom_activation_page()
	{
	}
	/**
	 * Output the URL of the activation page.
	 *
	 * @since 1.0.0
	 */
	function bp_activation_page()
	{
	}
	/**
	 * Get the URL of the activation page.
	 *
	 * @since 1.2.0
	 *
	 * @return string
	 */
	function bp_get_activation_page()
	{
	}
	/**
	 * Get the activation key from the current request URL.
	 *
	 * @since 3.0.0
	 *
	 * @return string
	 */
	function bp_get_current_activation_key()
	{
	}
	/**
	 * Output the username submitted during signup.
	 *
	 * @since 1.1.0
	 */
	function bp_signup_username_value()
	{
	}
	/**
	 * Get the username submitted during signup.
	 *
	 * @since 1.1.0
	 *
	 * @todo This should be properly escaped.
	 *
	 * @return string
	 */
	function bp_get_signup_username_value()
	{
	}
	/**
	 * Output the user email address submitted during signup.
	 *
	 * @since 1.1.0
	 */
	function bp_signup_email_value()
	{
	}
	/**
	 * Get the email address submitted during signup.
	 *
	 * @since 1.1.0
	 *
	 * @todo This should be properly escaped.
	 *
	 * @return string
	 */
	function bp_get_signup_email_value()
	{
	}
	/**
	 * Output the 'signup_with_blog' value submitted during signup.
	 *
	 * @since 1.1.0
	 */
	function bp_signup_with_blog_value()
	{
	}
	/**
	 * Get the 's