#!/usr/bin/bash

DIRECTADMIN_PLUGIN="/usr/local/directadmin/plugins/Imunify"
CPANEL_PLUGIN="/usr/local/cpanel/base/frontend/jupiter/imunify"
AV_USERSIDE_PLUGIN_FLAG="/var/imunify360/av-userside-plugin.installed"
I360_USERSIDE_PLUGIN_FLAG="/var/imunify360/i360-userside-plugin.installed"
IS_I360_PACKAGE=false

# Get the name of installed panel
get_panel() {
    if [ -e /usr/local/cpanel/cpanel ]; then
        printf "cpanel\n"
    elif [ -e /usr/local/directadmin/directadmin ]; then
        printf "directadmin\n"
    elif [ -e /usr/sbin/plesk ]; then
        printf "plesk\n"
    else
        return 1
    fi
}

install_cpanel() {
    local conf_dir="antivirus_conf"
    if "${IS_I360_PACKAGE}"; then
        if [[ -f /var/imunify360/myimunify-freemium.flag ]]; then
            conf_dir="myimunify_conf"
        else
            conf_dir="conf"
        fi
    fi

    for theme_dir in /usr/local/cpanel/base/frontend/*; do
        [[ -d "${theme_dir}" ]] || continue
        local theme
        theme=$(basename "${theme_dir}")

        if [[ "${theme}" != "jupiter" ]]; then
            mkdir -p "/usr/local/cpanel/base/frontend/${theme}/imunify"
            cp -a "${CPANEL_PLUGIN}" "/usr/local/cpanel/base/frontend/${theme}"
        fi
        /usr/local/cpanel/scripts/install_plugin "/etc/sysconfig/imunify360/cpanel/${conf_dir}" --theme "${theme}"

        if "${IS_I360_PACKAGE}" && [[ -e "${AV_USERSIDE_PLUGIN_FLAG}" ]]; then
            # remove av plugin if it exists
            /usr/local/cpanel/scripts/uninstall_plugin "/etc/sysconfig/imunify360/cpanel/antivirus_conf" --theme "${theme}"
            rm -f "${AV_USERSIDE_PLUGIN_FLAG}"
        fi
    done
    touch "$(get_plugin_flag)"
}

install_directadmin() {
    local enabled_plugin="${DIRECTADMIN_PLUGIN}/user"
    local disabled_plugin="${DIRECTADMIN_PLUGIN}/.user"

    if [[ -d "${disabled_plugin}" ]] && [[ -n "$(ls -A "${disabled_plugin}")" ]]; then
        rm -rf "${enabled_plugin}"
        mv "${disabled_plugin}" "${enabled_plugin}"
    fi
    touch "$(get_plugin_flag)"
}

install_plesk() {
    if ! check_plugin_flag; then
        touch "$(get_plugin_flag)"
    fi
}

remove_cpanel() {
    local conf_dir="antivirus_conf"
    if "${IS_I360_PACKAGE}"; then
        conf_dir="conf"
    fi

    for theme_dir in /usr/local/cpanel/base/frontend/*; do
        [[ -d "${theme_dir}" ]] || continue
        local theme
        theme=$(basename "${theme_dir}")

        /usr/local/cpanel/scripts/uninstall_plugin "/etc/sysconfig/imunify360/cpanel/${conf_dir}" --theme "${theme}"

        if [[ -d "/usr/local/cpanel/base/frontend/${theme}/imunify" ]]; then
            rm -rf "/usr/local/cpanel/base/frontend/${theme}/imunify"
        fi
    done
    remove_plugin_flag
}

remove_directadmin() {
    local enabled_plugin="${DIRECTADMIN_PLUGIN}/user"
    local disabled_plugin="${DIRECTADMIN_PLUGIN}/.user"

    if [[ -d "${enabled_plugin}" ]] && [[ -n "$(ls -A "${enabled_plugin}")" ]]; then
        rm -rf "${disabled_plugin}"
        mv "${enabled_plugin}" "${disabled_plugin}"
    fi
    remove_plugin_flag
}

remove_plesk() {
    if check_plugin_flag; then
        remove_plugin_flag
    fi
}

update_cpanel() {
    if check_plugin_flag; then
        install_cpanel
    else
        printf "User-side plugin is not installed. Skipping update...\n"
    fi
}

update_directadmin() {
    if ! check_plugin_flag && [[ -e "${DIRECTADMIN_PLUGIN}/user" ]]; then
        remove_directadmin
    fi
}

update_plesk() {
    install_plesk
}

update_package_config_cpanel() {
    for theme_dir in /usr/local/cpanel/base/frontend/*; do
        [[ -d "${theme_dir}" ]] || continue
        local theme
        theme=$(basename "${theme_dir}")

        local theme_path="/usr/local/cpanel/base/frontend/${theme}/imunify/assets/js/config.js"
        if [[ -f "${theme_path}" ]]; then
            if ! grep -q "IMUNIFY_PACKAGE" "${theme_path}"; then
                printf "var IMUNIFY_PACKAGE = '360'\n" > "${theme_path}"
            else
                sed -i -E "s/IMUNIFY_PACKAGE = 'AV'/IMUNIFY_PACKAGE = '360'/" "${theme_path}"
            fi
        fi
    done
}

update_package_config_directadmin() {
    install_directadmin
}

update_package_config_plesk() {
    printf "Updating package config for Plesk is not implemented.\n"
}

# Get the appropriate flag based on package type
get_plugin_flag() {
    if "${IS_I360_PACKAGE}"; then
        echo "${I360_USERSIDE_PLUGIN_FLAG}"
    else
        echo "${AV_USERSIDE_PLUGIN_FLAG}"
    fi
}

# Check if plugin flag exists based on package type
check_plugin_flag() {
    if "${IS_I360_PACKAGE}"; then
        # For 360, check if at least one flag exists
        if [[ -e "${I360_USERSIDE_PLUGIN_FLAG}" ]] || [[ -e "${AV_USERSIDE_PLUGIN_FLAG}" ]]; then
            return 0
        else
            return 1
        fi
    else
        # For AV, check only AV flag
        if [[ -e "${AV_USERSIDE_PLUGIN_FLAG}" ]]; then
            return 0
        else
            return 1
        fi
    fi
}

# Remove appropriate flag based on package type
remove_plugin_flag() {
    if "${IS_I360_PACKAGE}"; then
        rm -f "${I360_USERSIDE_PLUGIN_FLAG}"
    else
        rm -f "${AV_USERSIDE_PLUGIN_FLAG}"
    fi
}

main() {
    local panel; panel=$(get_panel)

    if [[ -z "${panel}" ]]; then
        printf "Detected panel doesn't support av user side plugin\n"
        exit 0
    fi

    for arg in "$@"; do
        if [[ "$arg" =~ ^package= ]]; then
            local imunify_package="${arg#*=}"
            if [[ "${imunify_package}" == "360" ]]; then
                IS_I360_PACKAGE=true
            else
                IS_I360_PACKAGE=false
            fi
        fi
    done

    case "${1}" in
        "-r")
            "remove_${panel}"
            ;;
        "-u")
            "update_${panel}"
            ;;
        "-update-package")
            "update_package_config_${panel}"
            ;;
        "-i")
            "install_${panel}"
            ;;
        "")
            "install_${panel}"
            ;;
        *)
            printf "Unrecognized option: %s\n" "${1}"
            exit 1
            ;;
    esac
}

main "$@"
